/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.internal.builder.execution;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.builder.MetamodelBuilderPlugin;
import com.metamatrix.metamodels.builder.MetamodelEntityBuilder;
import com.metamatrix.metamodels.builder.MetamodelEntityRecord;
import com.metamatrix.metamodels.builder.execution.MetamodelBuilderConstants;
import com.metamatrix.metamodels.builder.execution.MetamodelBuilderExecutionPlugin;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.extension.util.ExtensionUtil;
import com.metamatrix.metamodels.internal.builder.execution.util.MetamodelBuilderUtil;
import com.metamatrix.metamodels.internal.builder.util.MetaClassUriHelper;
import com.metamatrix.metamodels.relational.util.RelationalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class MetamodelEntityBuilderImpl
implements MetamodelEntityBuilder,
MetamodelBuilderConstants {
    private final MultiStatus status;
    private final ResourceSet resources;
    private boolean builderDebugEnabled = false;
    private static final String ENTITY_NAME = "Name";
    private MetamodelEntityRecord currentRecord;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$metamodels$internal$builder$execution$MetamodelEntityBuilderImpl == null ? (class$com$metamatrix$metamodels$internal$builder$execution$MetamodelEntityBuilderImpl = MetamodelEntityBuilderImpl.class$("com.metamatrix.metamodels.internal.builder.execution.MetamodelEntityBuilderImpl")) : class$com$metamatrix$metamodels$internal$builder$execution$MetamodelEntityBuilderImpl));
    static /* synthetic */ Class class$com$metamatrix$metamodels$internal$builder$execution$MetamodelEntityBuilderImpl;

    private static String getString(String id) {
        return MetamodelBuilderConstants.UTIL.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, Object param1) {
        return MetamodelBuilderConstants.UTIL.getString(I18N_PREFIX + id, param1);
    }

    private static String getString(String id, Object param1, Object param2) {
        return MetamodelBuilderConstants.UTIL.getString(I18N_PREFIX + id, param1, param2);
    }

    public MetamodelEntityBuilderImpl(MultiStatus status, ResourceSet resources) {
        ArgCheck.isNotNull((Object)status);
        ArgCheck.isNotNull((Object)resources);
        ArgCheck.isNotEmpty((Collection)resources.getResources());
        this.status = status;
        this.resources = resources;
    }

    public EObject create(MetamodelEntityRecord record, IProgressMonitor monitor) {
        String metaClassUri;
        String ePkgUri;
        EPackage ePkg;
        ArgCheck.isNotNull((Object)record);
        this.builderDebugEnabled = MetamodelBuilderPlugin.Util.isDebugEnabled("metamodelBuilder");
        this.currentRecord = record;
        EObject entity = null;
        boolean isExisting = false;
        String parentPath = record.getParentPath();
        Map featuresMap = record.getFeaturesNameValueMap();
        Object nameValue = featuresMap.get(ENTITY_NAME);
        if (nameValue != null) {
            String shortName = (String)nameValue;
            String fullPath = parentPath + "\\\\" + shortName;
            Object existingEntity = MetamodelBuilderUtil.findEObjectByPath((ResourceSet)this.resources, (String)fullPath, (String)record.getMetaClassUri(), (MultiStatus)this.status);
            if (existingEntity != null && existingEntity instanceof EObject) {
                entity = (EObject)existingEntity;
                isExisting = true;
            }
        }
        if ((ePkg = MetamodelBuilderUtil.getEPackageForUri((String)(ePkgUri = MetaClassUriHelper.getPackageUri((String)(metaClassUri = record.getMetaClassUri()))), (MultiStatus)this.status)) == null) {
            return null;
        }
        EClass eClass = (EClass)MetamodelBuilderUtil.getEClassForUri((String)metaClassUri, (MultiStatus)this.status);
        if (eClass == null) {
            return null;
        }
        EFactory factory = ePkg.getEFactoryInstance();
        if (entity == null) {
            entity = factory.create(eClass);
        }
        if (entity == null) {
            String msg = MetamodelEntityBuilderImpl.getString("unableToCreateEntity", eClass.getName());
            MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return null;
        }
        this.process(entity, record, factory, isExisting);
        if (monitor != null) {
            monitor.worked(1);
        }
        return entity;
    }

    public List create(List records, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)records);
        ArrayList<EObject> eObjs = new ArrayList<EObject>(records.size());
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            EObject eObj = this.create((MetamodelEntityRecord)iter.next(), monitor);
            if (eObj == null) continue;
            eObjs.add(eObj);
        }
        return eObjs;
    }

    private void process(EObject entity, MetamodelEntityRecord entityRecord, EFactory factory, boolean isExisting) {
        boolean added;
        if (!isExisting && !(added = this.addEntity(entity, entityRecord))) {
            return;
        }
        Map featuresMap = entityRecord.getFeaturesNameValueMap();
        if (!isExisting) {
            Object nameValue = featuresMap.get(ENTITY_NAME);
            if (entity != null && nameValue != null) {
                this.setFeatureValue(entity, factory, ENTITY_NAME, nameValue, isExisting);
            }
        }
        Iterator properties = featuresMap.entrySet().iterator();
        while (properties.hasNext()) {
            Map.Entry next = properties.next();
            String name = (String)next.getKey();
            Object value = next.getValue();
            if (name == null || entity == null || name.equals(ENTITY_NAME)) continue;
            this.setFeatureValue(entity, factory, name, value, isExisting);
        }
    }

    private boolean addEntity(EObject entity, MetamodelEntityRecord entityRecord) {
        String path = entityRecord.getParentPath();
        ArgCheck.isNotNull((Object)path);
        Resource rsrc = MetamodelBuilderUtil.findResource((ResourceSet)this.resources, (String)path);
        if (rsrc == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noRsrc", entityRecord.getParentPath());
            MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return false;
        }
        Object parent = MetamodelBuilderUtil.findEObjectByPath((ResourceSet)this.resources, (String)path, (String)entityRecord.getParentMetaClassUri(), (MultiStatus)this.status);
        if (parent == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noParent", entity.eClass().getName(), entityRecord.getParentPath());
            MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return false;
        }
        return this.addChildToParent(rsrc, entity, parent);
    }

    private boolean addChildToParent(Resource rsrc, EObject child, Object parent) {
        if (parent instanceof Resource) {
            ((Resource)parent).getContents().add((Object)child);
            return true;
        }
        EObject parentEObj = (EObject)parent;
        int rsrcType = MetamodelBuilderUtil.getModelType((Resource)rsrc);
        boolean added = false;
        switch (rsrcType) {
            case 1: {
                added = RelationalUtil.addChildToParent((EObject)child, (EObject)parentEObj);
                break;
            }
            case 2: {
                added = ExtensionUtil.addChildToParent((EObject)child, (EObject)parentEObj);
            }
        }
        if (!added) {
            String msg = MetamodelEntityBuilderImpl.getString("noAdd", child.eClass().getName(), parentEObj.eClass().getName());
            MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
        }
        return added;
    }

    private boolean addFeatureValue(EObject eObject, String featureName, Object value) {
        EStructuralFeature feature = this.getFeature(eObject.eClass(), featureName, false);
        if (feature != null && feature.isMany()) {
            List values = (List)eObject.eGet(feature);
            if (value instanceof Collection) {
                return values.addAll((Collection)value);
            }
            return values.add(value);
        }
        return false;
    }

    private void setFeatureValue(EObject eObject, EFactory factory, String featureName, Object value, boolean isExisting) {
        block29: {
            if (value == null && !isExisting) {
                return;
            }
            try {
                if (featureName != null && featureName.equalsIgnoreCase("description")) {
                    this.setDescription(eObject, (String)value);
                    return;
                }
                EStructuralFeature feature = this.getFeature(eObject.eClass(), featureName, false);
                if (feature == null) {
                    EObject extension = MetamodelBuilderUtil.getExtension((EObject)eObject, (MultiStatus)this.status);
                    if (extension != null) {
                        this.setFeatureValue(extension, factory, featureName, value, isExisting);
                        return;
                    }
                    String msg = MetamodelEntityBuilderImpl.getString("noFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                    MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
                    if (this.builderDebugEnabled) {
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    return;
                }
                if (!feature.isChangeable()) {
                    String msg = MetamodelEntityBuilderImpl.getString("featureNotChangeable", featureName, this.getEntityString(this.currentRecord, eObject));
                    MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)2, (String)msg);
                    if (this.builderDebugEnabled) {
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    return;
                }
                if (feature instanceof EReference && value instanceof String) {
                    ArrayList<Object> refObjects = new ArrayList<Object>();
                    StringTokenizer refs = new StringTokenizer((String)value, ",");
                    Object first = null;
                    while (refs.hasMoreTokens()) {
                        String ref = refs.nextToken();
                        Object next = MetamodelBuilderUtil.findEObjectByPath((ResourceSet)this.resources, (String)ref, null, (MultiStatus)this.status);
                        if (next != null) {
                            refObjects.add(next);
                            if (first != null) continue;
                            first = next;
                            continue;
                        }
                        String msg = MetamodelEntityBuilderImpl.getString("badRef", ref, featureName);
                        MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
                        if (!this.builderDebugEnabled) continue;
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    if (refObjects.size() == 1) {
                        this.setFeatureValue(eObject, factory, featureName, first, isExisting);
                    } else if (refObjects.size() > 1) {
                        this.setFeatureValue(eObject, factory, featureName, refObjects, isExisting);
                    }
                } else if (!feature.isMany()) {
                    if (value instanceof String && feature instanceof EAttribute) {
                        EDataType type = ((EAttribute)feature).getEAttributeType();
                        if (type instanceof EEnum) {
                            Object valObj = factory.createFromString(type, (String)value);
                            eObject.eSet(feature, valObj);
                        } else {
                            Object dtValue = EcoreFactory.eINSTANCE.createFromString(type, (String)value);
                            eObject.eSet(feature, dtValue);
                        }
                    } else if (value instanceof Character && feature instanceof EAttribute) {
                        EDataType type = ((EAttribute)feature).getEAttributeType();
                        if (type.getName().equalsIgnoreCase("EBoolean")) {
                            Boolean val = this.getBooleanForChar((Character)value);
                            eObject.eSet(feature, (Object)val);
                        }
                    } else {
                        eObject.eSet(feature, value);
                    }
                } else if (feature.isMany()) {
                    if (value != null) {
                        this.addFeatureValue(eObject, featureName, value);
                    } else {
                        String msg = MetamodelEntityBuilderImpl.getString("addNullToMultiFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                        MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)2, (String)msg);
                        if (this.builderDebugEnabled) {
                            MetamodelBuilderExecutionPlugin.Util.log(2, msg);
                        }
                    }
                }
            }
            catch (Exception err) {
                String msg = MetamodelEntityBuilderImpl.getString("errFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg, (Throwable)err);
                if (!this.builderDebugEnabled) break block29;
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
        }
    }

    private Boolean getBooleanForChar(Character character) {
        Boolean result = null;
        char charValue = character.charValue();
        if (charValue == 't' || charValue == 'T' || charValue == '1' || charValue == 'Y' || charValue == 'y') {
            result = Boolean.TRUE;
        } else if (charValue == 'f' || charValue == 'F' || charValue == '0' || charValue == 'N' || charValue == 'n') {
            result = Boolean.FALSE;
        }
        return result;
    }

    private String getEntityString(MetamodelEntityRecord entityRecord, EObject eObject) {
        StringBuffer sb = new StringBuffer();
        if (eObject != null) {
            EClass ec = eObject.eClass();
            sb.append(ec.getName() + " ");
            if (entityRecord != null && entityRecord.getParentPath() != null) {
                sb.append(entityRecord.getParentPath() + "\\\\");
            } else {
                sb.append("UnknownPath\\\\");
            }
            EStructuralFeature nameFeature = this.getFeature(ec, ENTITY_NAME, false);
            if (nameFeature != null) {
                Object nameValue = eObject.eGet(nameFeature);
                if (nameValue != null) {
                    sb.append(nameValue.toString());
                } else {
                    sb.append("UnknownName");
                }
            }
        }
        return sb.toString();
    }

    private void setDescription(EObject eObject, String value) {
        Annotation existing;
        Resource eResource = eObject.eResource();
        if (eResource == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noResource");
            MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return;
        }
        AnnotationContainer cntr = MetamodelBuilderUtil.getAnnotationContainer((Resource)eResource);
        if (cntr == null) {
            EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
            cntr = (AnnotationContainer)factory.create(CorePackage.eINSTANCE.getAnnotationContainer());
        }
        if ((existing = cntr.findAnnotation(eObject)) != null) {
            existing.setDescription(value);
        } else {
            EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
            Annotation annot = (Annotation)factory.create(CorePackage.eINSTANCE.getAnnotation());
            annot.setAnnotatedObject(eObject);
            annot.setDescription(value);
        }
    }

    private EStructuralFeature getFeature(EClass eClass, String featureName, boolean caseSensitiveMatch) {
        EStructuralFeature next;
        if (featureName == null) {
            return null;
        }
        if (caseSensitiveMatch && (next = eClass.getEStructuralFeature(featureName)) != null) {
            return next;
        }
        Iterator iter = eClass.getEAllStructuralFeatures().iterator();
        while (iter.hasNext()) {
            EStructuralFeature next2 = (EStructuralFeature)iter.next();
            if (!featureName.equalsIgnoreCase(next2.getName())) continue;
            return next2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

