/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.PluginConstants;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.util.TransformationNotificationListener;
import com.metamatrix.ui.AbstractUiPlugin;
import com.metamatrix.ui.PreferenceKeyAndDefaultValue;
import com.metamatrix.ui.actions.ActionService;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUiPlugin
implements UiConstants {
    private static UiPlugin plugin;
    private TransformationNotificationListener notificationListener = new TransformationNotificationListener();

    public UiPlugin() {
        plugin = this;
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void init() {
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this.notificationListener);
    }

    public void setIgnoreTransformationNotifications(boolean ignoreNotifications) {
        if (this.notificationListener != null) {
            this.notificationListener.setIgnoreNotifications(ignoreNotifications);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)UiConstants.Util).initializePlatformLogger((Plugin)this);
        this.storeDefaultPreferenceValues();
        this.init();
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public ActionService getActionService(IWorkbenchPage page) {
        return DiagramUiPlugin.getDefault().getActionService(page);
    }

    public PluginUtil getPluginUtil() {
        return UiConstants.Util;
    }

    private void storeDefaultPreferenceValues() {
        int i;
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        for (i = 0; i < PluginConstants.Prefs.Appearance.PREFERENCES.length; ++i) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Appearance.PREFERENCES[i]);
        }
        DiagramUiPlugin.getDefault().savePluginPreferences();
        preferenceStore = UiPlugin.getDefault().getPreferenceStore();
        for (i = 0; i < PluginConstants.Prefs.Reconciler.PREFERENCES.length; ++i) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Reconciler.PREFERENCES[i]);
        }
        UiPlugin.getDefault().savePluginPreferences();
    }

    public void shutdown() throws CoreException {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notificationListener);
        super.shutdown();
    }
}

