/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.storage.file;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.log.LogManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileStorageManager
implements StorageManager {
    private static final String FILE_PREFIX = "b_";
    private int maxOpenFiles = 10;
    private long maxFileSize = 0x80000000L;
    private String directory;
    private Object openFileLock = new Object();
    private int openFiles = 0;
    private Map tupleSourceMap = new HashMap();

    public void initialize(Properties props) throws MetaMatrixComponentException {
        String maxFileSizeString;
        String numFilesStr;
        this.directory = props.getProperty("metamatrix.buffer.storageDirectory");
        if (this.directory == null) {
            throw new MetaMatrixComponentException("ERR.003.006.0024", CommonPlugin.Util.getString("ERR.003.006.0024"));
        }
        File dir = new File(this.directory);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new MetaMatrixComponentException("ERR.003.006.0025", CommonPlugin.Util.getString("ERR.003.006.0025", (Object)this.directory));
            }
        } else if (!dir.mkdir()) {
            throw new MetaMatrixComponentException("ERR.003.006.0026", CommonPlugin.Util.getString("ERR.003.006.0026", (Object)this.directory));
        }
        if ((numFilesStr = props.getProperty("metamatrix.buffer.maxOpenFiles")) != null) {
            try {
                this.maxOpenFiles = Integer.parseInt(numFilesStr);
            }
            catch (Exception e2) {
                LogManager.logWarning((String)"STORAGE_MGR", (Throwable)e2, (Object[])new Object[]{"metamatrix.buffer.maxOpenFiles", numFilesStr, String.valueOf(this.openFiles)});
            }
        }
        if ((maxFileSizeString = props.getProperty("metamatrix.buffer.maxFileSize")) != null) {
            try {
                this.maxFileSize = Long.parseLong(maxFileSizeString) * 1024L * 1024L;
            }
            catch (Exception e3) {
                LogManager.logWarning((String)"STORAGE_MGR", (Throwable)e3, (Object[])new Object[]{"metamatrix.buffer.maxFileSize", maxFileSizeString, String.valueOf(this.maxFileSize)});
            }
        }
    }

    public int getStorageType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleSourceInfo getTupleSourceInfo(TupleSourceID sourceID, boolean shouldCreate) throws MetaMatrixComponentException {
        Map map = this.tupleSourceMap;
        synchronized (map) {
            TupleSourceInfo info = (TupleSourceInfo)this.tupleSourceMap.get(sourceID);
            if (info == null && shouldCreate) {
                info = new TupleSourceInfo();
                this.tupleSourceMap.put(sourceID, info);
            }
            return info;
        }
    }

    private File createFile(TupleSourceID sourceID, int fileNumber) throws MetaMatrixComponentException {
        File storageFile = new File(this.directory, FILE_PREFIX + sourceID.getIDValue() + "_" + fileNumber);
        if (storageFile.exists()) {
            throw new MetaMatrixComponentException("ERR.003.006.0027", CommonPlugin.Util.getString("ERR.003.006.0027", (Object)storageFile.getAbsoluteFile()));
        }
        if (LogManager.isMessageToBeRecorded((String)"STORAGE_MGR", (int)5)) {
            LogManager.logDetail((String)"STORAGE_MGR", (String)("Creating temporary storage area file " + storageFile.getAbsoluteFile()));
        }
        try {
            boolean created = storageFile.createNewFile();
            if (!created) {
                throw new MetaMatrixComponentException("ERR.003.006.0028", CommonPlugin.Util.getString("ERR.003.006.0028", (Object)storageFile.getAbsoluteFile()));
            }
        }
        catch (IOException e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.003.006.0028", CommonPlugin.Util.getString("ERR.003.006.0028", (Object)storageFile.getAbsoluteFile()));
        }
        return storageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(TupleSourceID sourceID, TupleBatch batch, String[] types) throws MetaMatrixComponentException {
        TupleSourceInfo tsInfo;
        TupleSourceInfo tupleSourceInfo = tsInfo = this.getTupleSourceInfo(sourceID, true);
        synchronized (tupleSourceInfo) {
            FileInfo fileInfo;
            if (tsInfo.isRemoved) {
                return;
            }
            Integer batchKey = new Integer(batch.getBeginRow());
            if (tsInfo.tupleBatchPointers != null && tsInfo.tupleBatchPointers.containsKey(batchKey)) {
                return;
            }
            byte[] bytes = this.convertToBytes(batch, types);
            if ((long)bytes.length > this.maxFileSize) {
                LogManager.logWarning((String)"STORAGE_MGR", (String)("Detected an attempt to save a batch (" + sourceID + ", begin=" + batch.getBeginRow() + ", size=" + bytes.length + ") larger than the buffer max file size setting of " + this.maxFileSize + " bytes. The buffer manager will ignore the max file size setting for this batch, and create a buffer file dedicated to this batch. It may be necessary to reduce the buffer batch setting or increase the buffer max file size setting."));
            }
            if ((fileInfo = tsInfo.getMostRecentlyCreatedFile()) == null || fileInfo.file.length() + (long)bytes.length > this.maxFileSize) {
                fileInfo = new FileInfo(this.createFile(sourceID, tsInfo.storageFiles.size()));
                tsInfo.storageFiles.add(fileInfo);
            }
            long pointer = 0L;
            if (LogManager.isMessageToBeRecorded((String)"STORAGE_MGR", (int)5)) {
                LogManager.logDetail((String)"STORAGE_MGR", (String)("Adding batch to storage area file " + fileInfo.file.getAbsoluteFile()));
            }
            try {
                boolean opened = fileInfo.open();
                RandomAccessFile fileAccess = fileInfo.getAccess();
                pointer = fileAccess.length();
                fileAccess.setLength(pointer + (long)bytes.length);
                fileAccess.seek(pointer);
                fileAccess.write(bytes);
                if (opened && !this.canCacheFile()) {
                    fileInfo.close();
                }
            }
            catch (IOException e2) {
                fileInfo.close();
                throw new MetaMatrixComponentException((Throwable)e2, "ERR.003.006.0029", CommonPlugin.Util.getString("ERR.003.006.0029", (Object)e2.getMessage()));
            }
            tsInfo.tupleBatchPointers.put(batchKey, new PointerInfo(fileInfo, pointer, bytes.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCacheFile() {
        Object object = this.openFileLock;
        synchronized (object) {
            if (this.openFiles >= this.maxOpenFiles) {
                return false;
            }
            ++this.openFiles;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] convertToBytes(TupleBatch batch, String[] types) throws MetaMatrixComponentException {
        byte[] byArray;
        ObjectOutputStream oos = null;
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                batch.setDataTypes(types);
                batch.writeExternal((ObjectOutput)oos);
                oos.flush();
                byArray = baos.toByteArray();
                Object var7_7 = null;
                if (oos == null) return byArray;
            }
            catch (IOException e3) {
                throw new MetaMatrixComponentException((Throwable)e3, "ERR.003.006.0030", CommonPlugin.Util.getString("ERR.003.006.0030"));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return byArray;
        }
        oos.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TupleBatch convertToBatch(byte[] bytes, String[] types) throws MetaMatrixComponentException {
        TupleBatch tupleBatch;
        ObjectInputStream ois = null;
        try {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ois = new ObjectInputStream(bais);
                TupleBatch batch = new TupleBatch();
                batch.setDataTypes(types);
                batch.readExternal((ObjectInput)ois);
                tupleBatch = batch;
                Object var8_9 = null;
                if (ois == null) return tupleBatch;
            }
            catch (ClassNotFoundException e2) {
                throw new MetaMatrixComponentException((Throwable)e2, "ERR.003.006.0031", CommonPlugin.Util.getString("ERR.003.006.0031"));
            }
            catch (IOException e3) {
                throw new MetaMatrixComponentException((Throwable)e3, "ERR.003.006.0032", CommonPlugin.Util.getString("ERR.003.006.0032"));
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e4) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e4) {
            // empty catch block
            return tupleBatch;
        }
        ois.close();
        return tupleBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBatch getBatch(TupleSourceID sourceID, int beginRow, String[] types) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(sourceID, false);
        if (info == null) {
            throw new TupleSourceNotFoundException("ERR.003.006.0033", CommonPlugin.Util.getString("ERR.003.006.0033", (Object)sourceID));
        }
        byte[] bytes = null;
        TupleSourceInfo tupleSourceInfo = info;
        synchronized (tupleSourceInfo) {
            if (info.isRemoved) {
                throw new TupleSourceNotFoundException("ERR.003.006.0033", CommonPlugin.Util.getString("ERR.003.006.0033", (Object)sourceID));
            }
            PointerInfo pointerInfo = (PointerInfo)info.tupleBatchPointers.get(new Integer(beginRow));
            if (pointerInfo == null) {
                throw new MetaMatrixComponentException("ERR.003.006.0034", CommonPlugin.Util.getString("ERR.003.006.0034", new Object[]{String.valueOf(beginRow), sourceID}));
            }
            FileInfo fileInfo = pointerInfo.fileInfo;
            boolean opened = false;
            RandomAccessFile fileAccess = null;
            try {
                opened = fileInfo.open();
                fileAccess = fileInfo.getAccess();
                fileAccess.seek(pointerInfo.pointer);
                bytes = new byte[pointerInfo.length];
                fileAccess.readFully(bytes);
            }
            catch (IOException e2) {
                throw new MetaMatrixComponentException((Throwable)e2, "ERR.003.006.0035", CommonPlugin.Util.getString("ERR.003.006.0035", (Object)e2.getMessage()));
            }
            finally {
                if (opened && !this.canCacheFile()) {
                    fileInfo.close();
                }
            }
        }
        return this.convertToBatch(bytes, types);
    }

    public void removeBatch(TupleSourceID sourceID, int beginRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatches(TupleSourceID sourceID) throws MetaMatrixComponentException {
        TupleSourceInfo info = null;
        Object object = this.tupleSourceMap;
        synchronized (object) {
            info = (TupleSourceInfo)this.tupleSourceMap.remove(sourceID);
        }
        if (info == null) {
            return;
        }
        if (LogManager.isMessageToBeRecorded((String)"STORAGE_MGR", (int)5)) {
            LogManager.logDetail((String)"STORAGE_MGR", (String)("Removing storage for " + sourceID));
        }
        object = info;
        synchronized (object) {
            if (info.isRemoved) {
                return;
            }
            for (int i2 = 0; i2 < info.storageFiles.size(); ++i2) {
                FileInfo fileInfo = (FileInfo)info.storageFiles.get(i2);
                if (fileInfo.isOpen()) {
                    fileInfo.close();
                    Object object2 = this.openFileLock;
                    synchronized (object2) {
                        --this.openFiles;
                    }
                }
                fileInfo.file.delete();
            }
            info.isRemoved = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LogManager.logDetail((String)"STORAGE_MGR", (String)"Removing all storage area files ");
        Map map = this.tupleSourceMap;
        synchronized (map) {
            Iterator tsIter = this.tupleSourceMap.keySet().iterator();
            while (tsIter.hasNext()) {
                TupleSourceID key = (TupleSourceID)tsIter.next();
                try {
                    this.removeBatches(key);
                }
                catch (MetaMatrixComponentException e2) {
                    LogManager.logWarning((String)"STORAGE_MGR", (Throwable)e2, (String)("Shutdown failed while removing batches for tuple source: " + key));
                }
            }
            this.tupleSourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenFiles() {
        Object object = this.openFileLock;
        synchronized (object) {
            return this.openFiles;
        }
    }

    private static class TupleSourceInfo {
        Map tupleBatchPointers = new HashMap();
        List storageFiles = new ArrayList(2);
        private boolean isRemoved = false;

        private TupleSourceInfo() {
        }

        FileInfo getMostRecentlyCreatedFile() {
            if (this.storageFiles.isEmpty()) {
                return null;
            }
            return (FileInfo)this.storageFiles.get(this.storageFiles.size() - 1);
        }
    }

    private static class PointerInfo {
        FileInfo fileInfo;
        public long pointer;
        public int length;

        public PointerInfo(FileInfo fileInfo, long pointer, int length) {
            this.fileInfo = fileInfo;
            this.pointer = pointer;
            this.length = length;
        }
    }

    private static class FileInfo {
        private File file;
        private RandomAccessFile fileData;

        public FileInfo(File file) {
            this.file = file;
        }

        public boolean isOpen() {
            return this.fileData != null;
        }

        public boolean open() throws FileNotFoundException {
            if (this.fileData == null) {
                this.fileData = new RandomAccessFile(this.file, "rw");
                return true;
            }
            return false;
        }

        public RandomAccessFile getAccess() {
            return this.fileData;
        }

        public void close() {
            if (this.fileData != null) {
                try {
                    this.fileData.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fileData = null;
            }
        }

        public String toString() {
            return "FileInfo<" + this.file.getName() + ", has fileData = " + (this.fileData != null) + ">";
        }
    }
}

