/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInlineView;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;

final class BindValueVisitor
extends HierarchyVisitor {
    private boolean replaceWithBinding = false;

    BindValueVisitor() {
    }

    public void visit(IInlineView obj) {
        this.replaceWithBinding = false;
        this.visitNode((ILanguageObject)obj.getQuery());
    }

    public void visit(IScalarSubquery obj) {
        this.replaceWithBinding = false;
        super.visit(obj);
    }

    public void visit(IExistsCriteria obj) {
        this.replaceWithBinding = false;
        super.visit(obj);
    }

    public void visit(ISubqueryCompareCriteria obj) {
        this.replaceWithBinding = false;
        super.visit(obj);
    }

    public void visit(IFunction obj) {
        this.replaceWithBinding = false;
        super.visit(obj);
    }

    public void visit(IInCriteria obj) {
        this.replaceWithBinding = true;
        this.visitNodes(obj.getRightExpressions());
    }

    public void visit(ILikeCriteria obj) {
        this.replaceWithBinding = true;
        this.visitNode((ILanguageObject)obj.getRightExpression());
    }

    public void visit(ICompareCriteria obj) {
        this.replaceWithBinding = true;
        this.visitNode((ILanguageObject)obj.getRightExpression());
    }

    public void visit(ICaseExpression obj) {
        this.replaceWithBinding = true;
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode((ILanguageObject)obj.getWhenExpression(i));
        }
    }

    public void visit(ISearchedCaseExpression obj) {
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode((ILanguageObject)obj.getWhenCriteria(i));
        }
    }

    public void visit(IInsert obj) {
        this.replaceWithBinding = true;
        this.visitNodes(obj.getValues());
    }

    public void visit(ILiteral obj) {
        if (this.replaceWithBinding || TranslatedCommand.isBindEligible(obj)) {
            obj.setBindValue(true);
        }
    }

    public void visitNode(ILanguageObject obj) {
        boolean replacementMode = this.replaceWithBinding;
        super.visitNode(obj);
        this.replaceWithBinding = replacementMode;
    }
}

