"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const fs = require("fs");
const che_1 = require("../api/che");
class WorkspaceTasks {
    constructor(flags) {
        this.cheHelper = new che_1.CheHelper(flags);
        this.cheNamespace = flags.chenamespace;
        this.accessToken = flags['access-token'];
    }
    getWorkspaceStartTask(debug) {
        return [
            {
                title: 'Start the workspace',
                task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    yield this.cheHelper.startWorkspace(this.cheNamespace, ctx.workspaceId, debug, this.accessToken);
                    task.title = `${task.title}... Done`;
                })
            }
        ];
    }
    getWorkspaceStopTask() {
        return [
            {
                title: 'Stop the workspace',
                task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    yield this.cheHelper.stopWorkspace(ctx.cheURL, ctx.workspaceId, this.accessToken);
                    task.title = `${task.title}... Done`;
                })
            }
        ];
    }
    getWorkspaceCreateTask(devfile, workspaceName) {
        return [{
                title: 'Create a workspace from the Devfile',
                task: (ctx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    if (!devfile) {
                        if (fs.existsSync('devfile.yaml')) {
                            devfile = 'devfile.yaml';
                        }
                        else if (fs.existsSync('devfile.yml')) {
                            devfile = 'devfile.yml';
                        }
                    }
                    if (!devfile) {
                        throw new Error("E_DEVFILE_MISSING - Devfile wasn't specified via '-f' option and \'devfile.yaml' is not present in current directory.");
                    }
                    ctx.workspaceConfig = yield this.cheHelper.createWorkspaceFromDevfile(this.cheNamespace, devfile, workspaceName, this.accessToken);
                    ctx.workspaceId = ctx.workspaceConfig.id;
                })
            }];
    }
    getWorkspaceIdeUrlTask() {
        return [
            {
                title: 'Get the workspace IDE URL',
                task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const workspaceConfig = yield this.cheHelper.getWorkspace(ctx.cheURL, ctx.workspaceId, this.accessToken);
                    if (workspaceConfig.links && workspaceConfig.links.ide) {
                        ctx.workspaceIdeURL = yield this.cheHelper.buildDashboardURL(workspaceConfig.links.ide);
                    }
                    task.title = `${task.title}... Done`;
                })
            }
        ];
    }
}
exports.WorkspaceTasks = WorkspaceTasks;
//# sourceMappingURL=workspace-tasks.js.map