/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
export default class Update extends Command {
    static description: string;
    static flags: {
        installer: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        platform: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        chenamespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        templates: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'che-operator-image': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'skip-version-check': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'deployment-name': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'listr-renderer': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'skip-kubernetes-health-check': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
    };
    static getTemplatesDir(): string;
    checkIfInstallerSupportUpdating(flags: any): Promise<void>;
    run(): Promise<void>;
    setDomainFlag(flags: any): Promise<void>;
    setDefaultInstaller(flags: any): Promise<void>;
}
