"use strict";
/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const Listr = require("listr");
const notifier = require("node-notifier");
const common_flags_1 = require("../../common-flags");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
const workspace_tasks_1 = require("../../tasks/workspace-tasks");
class Start extends command_1.default {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Start);
            const { args } = this.parse(Start);
            const ctx = {};
            const tasks = new Listr([], { renderer: 'silent' });
            const apiTasks = new api_1.ApiTasks();
            const cheTasks = new che_1.CheTasks(flags);
            const workspaceTasks = new workspace_tasks_1.WorkspaceTasks(flags);
            ctx.workspaceId = args.workspace;
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.retrieveEclipseCheUrl(flags));
            tasks.add(cheTasks.checkEclipseCheStatus());
            tasks.add(workspaceTasks.getWorkspaceStartTask(flags.debug));
            tasks.add(workspaceTasks.getWorkspaceIdeUrlTask());
            try {
                yield tasks.run(ctx);
                this.log('Workspace start request has been sent, workspace will be available shortly:');
                cli_ux_1.cli.url(ctx.workspaceIdeURL, ctx.workspaceIdeURL);
            }
            catch (err) {
                this.error(err);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:start has completed successfully.'
            });
            this.exit(0);
        });
    }
}
exports.default = Start;
Start.description = 'Starts a workspace';
Start.flags = {
    help: command_1.flags.help({ char: 'h' }),
    debug: command_1.flags.boolean({
        char: 'd',
        description: 'Debug workspace start. It is useful when workspace start fails and it is needed to print more logs on startup.',
        default: false
    }),
    'access-token': common_flags_1.accessToken,
    chenamespace: common_flags_1.cheNamespace,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
Start.args = [
    {
        name: 'workspace',
        description: 'The workspace id to start',
        required: true
    }
];
//# sourceMappingURL=start.js.map