/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { che as chetypes } from '@eclipse-che/api';
import { OpenShiftHelper } from '../api/openshift';
import { KubeHelper } from './kube';
export declare class CheHelper {
    defaultCheResponseTimeoutMs: number;
    kube: KubeHelper;
    oc: OpenShiftHelper;
    private readonly axios;
    constructor(flags: any);
    /**
     * Finds a pod where workspace is running.
     * Rejects if no workspace is found for the given workspace ID
     * or if workspace ID wasn't specified but more than one workspace is found.
     */
    getWorkspacePodName(namespace: string, cheWorkspaceId: string): Promise<string>;
    getWorkspacePodContainers(namespace: string, cheWorkspaceId?: string): Promise<string[]>;
    cheURL(namespace?: string): Promise<string>;
    isSelfSignedCertificateSecretExist(namespace: string): Promise<boolean>;
    /**
     * Gets self-signed Che CA certificate from 'self-signed-certificate' secret.
     * If secret doesn't exist, undefined is returned.
     */
    retrieveCheCaCert(cheNamespace: string): Promise<string | undefined>;
    saveCheCaCert(cheCaCert: string, destinaton?: string): Promise<string>;
    /**
     * Retreives Keycloak admin user credentials.
     * Works only with installers which use Che CR (operator, olm).
     * Returns credentials as an array of two values: [login, password]
     * In case of an error an array with undefined values will be returned.
     */
    retrieveKeycloakAdminCredentials(cheNamespace: string): Promise<string[]>;
    cheK8sURL(namespace?: string): Promise<string>;
    cheOpenShiftURL(namespace?: string): Promise<string>;
    cheNamespaceExist(namespace?: string): Promise<boolean>;
    getCheServerStatus(cheURL: string, responseTimeoutMs?: number): Promise<string>;
    startShutdown(cheURL: string, accessToken?: string, responseTimeoutMs?: number): Promise<void>;
    waitUntilReadyToShutdown(cheURL: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    isCheServerReady(cheURL: string, responseTimeoutMs?: number): Promise<boolean>;
    startWorkspace(cheNamespace: string, workspaceId: string, debug: boolean, accessToken: string | undefined): Promise<void>;
    stopWorkspace(cheUrl: string, workspaceId: string, accessToken?: string): Promise<void>;
    createWorkspaceFromDevfile(namespace: string | undefined, devfilePath: string | undefined, workspaceName: string | undefined, accessToken?: string): Promise<chetypes.workspace.Workspace>;
    parseDevfile(devfilePath?: string): Promise<string>;
    isAuthenticationEnabled(cheURL: string, responseTimeoutMs?: number): Promise<boolean>;
    buildDashboardURL(ideURL: string): Promise<string>;
    /**
     * Finds workspace pods and reads logs from it.
     */
    readWorkspacePodLog(namespace: string, workspaceId: string, directory: string): Promise<boolean>;
    /**
     * Reads logs from pods that match a given selector.
     */
    readPodLog(namespace: string, podLabelSelector: string | undefined, directory: string, follow: boolean): Promise<void>;
    /**
     * Reads containers logs inside pod that match a given selector.
     */
    readNamespacedPodLog(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    /**
     * Reads all namespace events and store into a file.
     */
    readNamespaceEvents(namespace: string, directory: string, follow: boolean): Promise<void>;
    watchNamespacedPods(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    getAllWorkspaces(cheURL: string, accessToken?: string): Promise<any[]>;
    /**
     * Returns list of workspaces
     */
    doGetWorkspaces(cheUrl: string, skipCount: number, maxItems: number, accessToken?: string): Promise<any[]>;
    /**
     * Get workspace.
     */
    getWorkspace(cheUrl: string, workspaceId: string, accessToken?: string): Promise<any>;
    /**
     * Deletes workspace.
     */
    deleteWorkspace(cheUrl: string, workspaceId: string, accessToken?: string): Promise<void>;
    /**
     * Indicates if pod matches given labels.
     */
    private matchLabels;
    /**
     * Returns containers names.
     */
    private getContainers;
    /**
     * Reads pod log from a specific container of the pod.
     */
    private doReadNamespacedPodLog;
    private doCreateLogFile;
    private getCheApiError;
}
