/*
 * bb.h 
 * BIG BROTHER INCLUDE FILE
 * Sean MacGuire
 * Version 1.9c
 * May 15th, 2002
 *
 * (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
 */

#include <stdio.h>
#include <sys/types.h>

#define _HAVE_STDLIB_H_
#define _HAVE_STRING_H_
#define _HAVE_UNISTD_H_

#ifdef _HAVE_STDLIB_H_
#include <stdlib.h>
#endif
#ifdef _HAVE_STRING_H_
#include <string.h>
#endif
#ifdef _HAVE_UNISTD_H_
#include <unistd.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/signal.h>                 /* FOR ALARMS */
#include <sys/wait.h>                 	/* FOR STUPID FREEBSD */
#include <syslog.h>                     /* FOR LOGGING */
#include <setjmp.h>                     /* FOR NON-LOCAL GOTO */

#define MAXLINE  8192			/* CHANGED FROM 256 - MAX LINE SIZE */

#ifndef DEBUG
#define DEBUG	0
#endif

#define debug   printf

#define PORT    1984                    /* OBVIOUSLY BIG BROTHER'S PORT # */

#ifdef BZERO
#define bzero(a,b) memset(a,0,b)
#endif /* BZERO */
#ifdef SYSLOG
#define LOG_DAEMON      (3<<3)
#endif /* SYSLOG */

#define BBREL	"1.9c"
#define BBRELDATE "Wed, 15 May 2002 11:00:00 GMT"

#define PAGELEVELSDEFAULT "red purple"	/* Make sure same value is in bbdef.sh */

#define VALIDFILENAMECHARS	"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.,:"

#define REG_FULL        1
#define REG_BOL         2
#define REG_EOL         4
#define REG_IGN_CASE    8
#define REG_PATHEXP	16
 
#define PAGE_DEFAULT            1
#define PAGE_BASIC              2
#define PAGE_ESCALATE           4
#define PAGE_INITDELAY          8
        
#define GETDIR_FILE     1
#define GETDIR_DIR      2
#define GETDIR_OTHER    4
#define GETDIR_ALL      8

#define LINEBBHOSTS_ALL		1
#define LINEBBHOSTS_IPADDR	2

#define BB_DISABLEMSG	1
#define BB_ENABLEMSG	2

#ifdef __GNUC__
/* GCC on darwin doesn't like function in function */
/* GCC on solaris does not seem to process a function within a function correctly */
#ifndef DARWIN
#ifndef SOLARIS
#define FUNCINFUNCOK	1
#endif
#endif
#endif
