/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __SOC_MEDIATEK_MT8188_MMSYS_H
#define __SOC_MEDIATEK_MT8188_MMSYS_H

#include <linux/soc/mediatek/mtk-mmsys.h>
#include <dt-bindings/reset/mt8188-resets.h>

#define MT8188_VDO0_SW0_RST_B				0x190
#define MT8188_VDO0_OVL_MOUT_EN				0xf14
#define MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0		BIT(0)
#define MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0		BIT(1)
#define MT8188_MOUT_DISP_OVL0_TO_DISP_OVL1		BIT(2)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_RDMA1		BIT(4)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_WDMA1		BIT(5)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_OVL0		BIT(6)

#define MT8188_VDO0_SEL_IN				0xf34
#define MT8188_VDO0_SEL_OUT				0xf38

#define MT8188_VDO0_DISP_RDMA_SEL			0xf40
#define MT8188_SOUT_DISP_RDMA0_TO_MASK			GENMASK(2, 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_COLOR0		(0 << 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_DSI0		(1 << 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_DP_INTF0		(5 << 0)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_MASK		GENMASK(8, 8)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_OVL0		(0 << 8)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_RSZ0		(1 << 8)


#define MT8188_VDO0_DSI0_SEL_IN				0xf44
#define MT8188_SEL_IN_DSI0_FROM_MASK			BIT(0)
#define MT8188_SEL_IN_DSI0_FROM_DSC_WRAP0_OUT		(0 << 0)
#define MT8188_SEL_IN_DSI0_FROM_DISP_DITHER0		(1 << 0)

#define MT8188_VDO0_DP_INTF0_SEL_IN			0xf4C
#define MT8188_SEL_IN_DP_INTF0_FROM_MASK		GENMASK(2, 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_DSC_WRAP0C1_OUT	(0 << 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_VPP_MERGE		(1 << 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_DISP_DITHER0	(3 << 0)

#define MT8188_VDO0_DISP_DITHER0_SEL_OUT		0xf58
#define MT8188_SOUT_DISP_DITHER0_TO_MASK		GENMASK(2, 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DSC_WRAP0_IN	(0 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DSI0		(1 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_VPP_MERGE0		(6 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DP_INTF0		(7 << 0)

#define MT8188_VDO0_VPP_MERGE_SEL			0xf60
#define MT8188_SEL_IN_VPP_MERGE_FROM_MASK		GENMASK(1, 0)
#define MT8188_SEL_IN_VPP_MERGE_FROM_DSC_WRAP0_OUT	(0 << 0)
#define MT8188_SEL_IN_VPP_MERGE_FROM_DITHER0_OUT	(3 << 0)

#define MT8188_SOUT_VPP_MERGE_TO_MASK			GENMASK(6, 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSI1			(0 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DP_INTF0		(1 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_SINA_VIRTUAL0		(2 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA1		(3 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP0_IN		(4 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA0		(5 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP1_IN_MASK	GENMASK(11, 11)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP1_IN		(0 << 11)

#define MT8188_VDO0_DSC_WARP_SEL			0xf64
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_MASK		GENMASK(0, 0)
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_DISP_DITHER0	(0 << 0)
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_VPP_MERGE	(1 << 0)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK		GENMASK(19, 16)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_DSI0		BIT(16)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_SINB_VIRTUAL0	BIT(17)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_VPP_MERGE		BIT(18)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_DISP_WDMA0		BIT(19)

#define MT8188_VDO1_SW0_RST_B					0x1d0
#define MT8188_VDO1_HDR_TOP_CFG					0xd00
#define MT8188_VDO1_MIXER_IN1_ALPHA				0xd30
#define MT8188_VDO1_MIXER_IN1_PAD				0xd40
#define MT8188_VDO1_MIXER_VSYNC_LEN				0xd5c
#define MT8188_VDO1_MERGE0_ASYNC_CFG_WD				0xe30
#define MT8188_VDO1_HDRBE_ASYNC_CFG_WD				0xe70
#define MT8188_VDO1_VPP_MERGE0_P0_SEL_IN			0xf04
#define MT8188_VPP_MERGE0_P0_SEL_IN_FROM_MDP_RDMA0		1
#define MT8188_VDO1_VPP_MERGE0_P1_SEL_IN			0xf08
#define MT8188_VPP_MERGE0_P1_SEL_IN_FROM_MDP_RDMA1		1
#define MT8188_VDO1_DISP_DPI1_SEL_IN				0xf10
#define MT8188_DISP_DPI1_SEL_IN_FROM_VPP_MERGE4_MOUT		0
#define MT8188_VDO1_DISP_DP_INTF0_SEL_IN			0xf14
#define MT8188_DISP_DP_INTF0_SEL_IN_FROM_VPP_MERGE4_MOUT	0
#define MT8188_VDO1_MERGE4_SOUT_SEL				0xf18
#define MT8188_MERGE4_SOUT_TO_DPI1_SEL				BIT(2)
#define MT8188_MERGE4_SOUT_TO_DP_INTF0_SEL			BIT(3)
#define MT8188_VDO1_MIXER_IN1_SEL_IN				0xf24
#define MT8188_MIXER_IN1_SEL_IN_FROM_MERGE0_ASYNC_SOUT		1
#define MT8188_VDO1_MIXER_IN2_SEL_IN				0xf28
#define MT8188_MIXER_IN2_SEL_IN_FROM_MERGE1_ASYNC_SOUT		1
#define MT8188_VDO1_MIXER_IN3_SEL_IN				0xf2c
#define MT8188_MIXER_IN3_SEL_IN_FROM_MERGE2_ASYNC_SOUT		1
#define MT8188_VDO1_MIXER_IN4_SEL_IN				0xf30
#define MT8188_MIXER_IN4_SEL_IN_FROM_MERGE3_ASYNC_SOUT		1
#define MT8188_VDO1_MIXER_OUT_SOUT_SEL				0xf34
#define MT8188_MIXER_SOUT_TO_MERGE4_ASYNC_SEL			1
#define MT8188_VDO1_VPP_MERGE1_P0_SEL_IN			0xf3c
#define MT8188_VPP_MERGE1_P0_SEL_IN_FROM_MDP_RDMA2		1
#define MT8188_VDO1_MERGE0_ASYNC_SOUT_SEL			0xf40
#define MT8188_SOUT_TO_MIXER_IN1_SEL				1
#define MT8188_VDO1_MERGE1_ASYNC_SOUT_SEL			0xf44
#define MT8188_SOUT_TO_MIXER_IN2_SEL				1
#define MT8188_VDO1_MERGE2_ASYNC_SOUT_SEL			0xf48
#define MT8188_SOUT_TO_MIXER_IN3_SEL				1
#define MT8188_VDO1_MERGE3_ASYNC_SOUT_SEL			0xf4c
#define MT8188_SOUT_TO_MIXER_IN4_SEL				1
#define MT8188_VDO1_MERGE4_ASYNC_SEL_IN				0xf50
#define MT8188_MERGE4_ASYNC_SEL_IN_FROM_MIXER_OUT_SOUT		1
#define MT8188_VDO1_MIXER_IN1_SOUT_SEL				0xf58
#define MT8188_MIXER_IN1_SOUT_TO_DISP_MIXER			0
#define MT8188_VDO1_MIXER_IN2_SOUT_SEL				0xf5c
#define MT8188_MIXER_IN2_SOUT_TO_DISP_MIXER			0
#define MT8188_VDO1_MIXER_IN3_SOUT_SEL				0xf60
#define MT8188_MIXER_IN3_SOUT_TO_DISP_MIXER			0
#define MT8188_VDO1_MIXER_IN4_SOUT_SEL				0xf64
#define MT8188_MIXER_IN4_SOUT_TO_DISP_MIXER			0
#define MT8188_VDO1_MIXER_SOUT_SEL_IN				0xf68
#define MT8188_MIXER_SOUT_SEL_IN_FROM_DISP_MIXER		0

static const u8 mmsys_mt8188_vdo0_rst_tb[] = {
	[MT8188_VDO0_RST_DISP_OVL0]	= MMSYS_RST_NR(0, 0),
	[MT8188_VDO0_RST_FAKE_ENG0]	= MMSYS_RST_NR(0, 2),
	[MT8188_VDO0_RST_DISP_CCORR0]	= MMSYS_RST_NR(0, 4),
	[MT8188_VDO0_RST_DISP_MUTEX0]	= MMSYS_RST_NR(0, 6),
	[MT8188_VDO0_RST_DISP_GAMMA0]	= MMSYS_RST_NR(0, 8),
	[MT8188_VDO0_RST_DISP_DITHER0]	= MMSYS_RST_NR(0, 10),
	[MT8188_VDO0_RST_DISP_WDMA0]	= MMSYS_RST_NR(0, 17),
	[MT8188_VDO0_RST_DISP_RDMA0]	= MMSYS_RST_NR(0, 19),
	[MT8188_VDO0_RST_DSI0]		= MMSYS_RST_NR(0, 21),
	[MT8188_VDO0_RST_DSI1]		= MMSYS_RST_NR(0, 22),
	[MT8188_VDO0_RST_DSC_WRAP0]	= MMSYS_RST_NR(0, 23),
	[MT8188_VDO0_RST_VPP_MERGE0]	= MMSYS_RST_NR(0, 24),
	[MT8188_VDO0_RST_DP_INTF0]	= MMSYS_RST_NR(0, 25),
	[MT8188_VDO0_RST_DISP_AAL0]	= MMSYS_RST_NR(0, 26),
	[MT8188_VDO0_RST_INLINEROT0]	= MMSYS_RST_NR(0, 27),
	[MT8188_VDO0_RST_APB_BUS]	= MMSYS_RST_NR(0, 28),
	[MT8188_VDO0_RST_DISP_COLOR0]	= MMSYS_RST_NR(0, 29),
	[MT8188_VDO0_RST_MDP_WROT0]	= MMSYS_RST_NR(0, 30),
	[MT8188_VDO0_RST_DISP_RSZ0]	= MMSYS_RST_NR(0, 31),
};

static const u8 mmsys_mt8188_vdo1_rst_tb[] = {
	[MT8188_VDO1_RST_SMI_LARB2]			= MMSYS_RST_NR(0, 0),
	[MT8188_VDO1_RST_SMI_LARB3]			= MMSYS_RST_NR(0, 1),
	[MT8188_VDO1_RST_GALS]				= MMSYS_RST_NR(0, 2),
	[MT8188_VDO1_RST_FAKE_ENG0]			= MMSYS_RST_NR(0, 3),
	[MT8188_VDO1_RST_FAKE_ENG1]			= MMSYS_RST_NR(0, 4),
	[MT8188_VDO1_RST_MDP_RDMA0]			= MMSYS_RST_NR(0, 5),
	[MT8188_VDO1_RST_MDP_RDMA1]			= MMSYS_RST_NR(0, 6),
	[MT8188_VDO1_RST_MDP_RDMA2]			= MMSYS_RST_NR(0, 7),
	[MT8188_VDO1_RST_MDP_RDMA3]			= MMSYS_RST_NR(0, 8),
	[MT8188_VDO1_RST_VPP_MERGE0]			= MMSYS_RST_NR(0, 9),
	[MT8188_VDO1_RST_VPP_MERGE1]			= MMSYS_RST_NR(0, 10),
	[MT8188_VDO1_RST_VPP_MERGE2]			= MMSYS_RST_NR(0, 11),
	[MT8188_VDO1_RST_VPP_MERGE3]			= MMSYS_RST_NR(1, 0),
	[MT8188_VDO1_RST_VPP_MERGE4]			= MMSYS_RST_NR(1, 1),
	[MT8188_VDO1_RST_VPP2_TO_VDO1_DL_ASYNC]		= MMSYS_RST_NR(1, 2),
	[MT8188_VDO1_RST_VPP3_TO_VDO1_DL_ASYNC]		= MMSYS_RST_NR(1, 3),
	[MT8188_VDO1_RST_DISP_MUTEX]			= MMSYS_RST_NR(1, 4),
	[MT8188_VDO1_RST_MDP_RDMA4]			= MMSYS_RST_NR(1, 5),
	[MT8188_VDO1_RST_MDP_RDMA5]			= MMSYS_RST_NR(1, 6),
	[MT8188_VDO1_RST_MDP_RDMA6]			= MMSYS_RST_NR(1, 7),
	[MT8188_VDO1_RST_MDP_RDMA7]			= MMSYS_RST_NR(1, 8),
	[MT8188_VDO1_RST_DP_INTF1_MMCK]			= MMSYS_RST_NR(1, 9),
	[MT8188_VDO1_RST_DPI0_MM_CK]			= MMSYS_RST_NR(1, 10),
	[MT8188_VDO1_RST_DPI1_MM_CK]			= MMSYS_RST_NR(1, 11),
	[MT8188_VDO1_RST_MERGE0_DL_ASYNC]		= MMSYS_RST_NR(1, 13),
	[MT8188_VDO1_RST_MERGE1_DL_ASYNC]		= MMSYS_RST_NR(1, 14),
	[MT8188_VDO1_RST_MERGE2_DL_ASYNC]		= MMSYS_RST_NR(1, 15),
	[MT8188_VDO1_RST_MERGE3_DL_ASYNC]		= MMSYS_RST_NR(1, 16),
	[MT8188_VDO1_RST_MERGE4_DL_ASYNC]		= MMSYS_RST_NR(1, 17),
	[MT8188_VDO1_RST_VDO0_DSC_TO_VDO1_DL_ASYNC]	= MMSYS_RST_NR(1, 18),
	[MT8188_VDO1_RST_VDO0_MERGE_TO_VDO1_DL_ASYNC]	= MMSYS_RST_NR(1, 19),
	[MT8188_VDO1_RST_PADDING0]			= MMSYS_RST_NR(1, 20),
	[MT8188_VDO1_RST_PADDING1]			= MMSYS_RST_NR(1, 21),
	[MT8188_VDO1_RST_PADDING2]			= MMSYS_RST_NR(1, 22),
	[MT8188_VDO1_RST_PADDING3]			= MMSYS_RST_NR(1, 23),
	[MT8188_VDO1_RST_PADDING4]			= MMSYS_RST_NR(1, 24),
	[MT8188_VDO1_RST_PADDING5]			= MMSYS_RST_NR(1, 25),
	[MT8188_VDO1_RST_PADDING6]			= MMSYS_RST_NR(1, 26),
	[MT8188_VDO1_RST_PADDING7]			= MMSYS_RST_NR(1, 27),
	[MT8188_VDO1_RST_DISP_RSZ0]			= MMSYS_RST_NR(1, 28),
	[MT8188_VDO1_RST_DISP_RSZ1]			= MMSYS_RST_NR(1, 29),
	[MT8188_VDO1_RST_DISP_RSZ2]			= MMSYS_RST_NR(1, 30),
	[MT8188_VDO1_RST_DISP_RSZ3]			= MMSYS_RST_NR(1, 31),
	[MT8188_VDO1_RST_HDR_VDO_FE0]			= MMSYS_RST_NR(2, 0),
	[MT8188_VDO1_RST_HDR_GFX_FE0]			= MMSYS_RST_NR(2, 1),
	[MT8188_VDO1_RST_HDR_VDO_BE]			= MMSYS_RST_NR(2, 2),
	[MT8188_VDO1_RST_HDR_VDO_FE1]			= MMSYS_RST_NR(2, 16),
	[MT8188_VDO1_RST_HDR_GFX_FE1]			= MMSYS_RST_NR(2, 17),
	[MT8188_VDO1_RST_DISP_MIXER]			= MMSYS_RST_NR(2, 18),
	[MT8188_VDO1_RST_HDR_VDO_FE0_DL_ASYNC]		= MMSYS_RST_NR(2, 19),
	[MT8188_VDO1_RST_HDR_VDO_FE1_DL_ASYNC]		= MMSYS_RST_NR(2, 20),
	[MT8188_VDO1_RST_HDR_GFX_FE0_DL_ASYNC]		= MMSYS_RST_NR(2, 21),
	[MT8188_VDO1_RST_HDR_GFX_FE1_DL_ASYNC]		= MMSYS_RST_NR(2, 22),
	[MT8188_VDO1_RST_HDR_VDO_BE_DL_ASYNC]		= MMSYS_RST_NR(2, 23),
};

static const struct mtk_mmsys_routes mmsys_mt8188_routing_table[] = {
	{
		DDP_COMPONENT_OVL0, DDP_COMPONENT_RDMA0,
		MT8188_VDO0_OVL_MOUT_EN, MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0,
		MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0
	}, {
		DDP_COMPONENT_OVL0, DDP_COMPONENT_WDMA0,
		MT8188_VDO0_OVL_MOUT_EN, MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0,
		MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0
	}, {
		DDP_COMPONENT_OVL0, DDP_COMPONENT_RDMA0,
		MT8188_VDO0_DISP_RDMA_SEL, MT8188_SEL_IN_DISP_RDMA0_FROM_MASK,
		MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_OVL0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSI0_SEL_IN, MT8188_SEL_IN_DSI0_FROM_MASK,
		MT8188_SEL_IN_DSI0_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SEL_IN_VPP_MERGE_FROM_MASK,
		MT8188_SEL_IN_VPP_MERGE_FROM_DITHER0_OUT
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSC0,
		MT8188_VDO0_DSC_WARP_SEL,
		MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_MASK,
		MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_DP_INTF0_SEL_IN, MT8188_SEL_IN_DP_INTF0_FROM_MASK,
		MT8188_SEL_IN_DP_INTF0_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SEL_IN_VPP_MERGE_FROM_MASK,
		MT8188_SEL_IN_VPP_MERGE_FROM_DSC_WRAP0_OUT
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSI0_SEL_IN, MT8188_SEL_IN_DSI0_FROM_MASK,
		MT8188_SEL_IN_DSI0_FROM_DSC_WRAP0_OUT
	}, {
		DDP_COMPONENT_RDMA0, DDP_COMPONENT_COLOR0,
		MT8188_VDO0_DISP_RDMA_SEL, MT8188_SOUT_DISP_RDMA0_TO_MASK,
		MT8188_SOUT_DISP_RDMA0_TO_DISP_COLOR0
	},  {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DISP_DITHER0_SEL_OUT,
		MT8188_SOUT_DISP_DITHER0_TO_MASK,
		MT8188_SOUT_DISP_DITHER0_TO_DSI0
	},  {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_DISP_DITHER0_SEL_OUT,
		MT8188_SOUT_DISP_DITHER0_TO_MASK,
		MT8188_SOUT_DISP_DITHER0_TO_DP_INTF0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DP_INTF0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DPI0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_SINA_VIRTUAL0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_WDMA0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DSC0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP0_IN
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSC_WARP_SEL, MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK,
		MT8188_SOUT_DSC_WRAP0_OUT_TO_DSI0
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_DSC_WARP_SEL, MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK,
		MT8188_SOUT_DSC_WRAP0_OUT_TO_VPP_MERGE
	},
};

static const struct mtk_mmsys_routes mmsys_mt8188_vdo1_routing_table[] = {
	{
		DDP_COMPONENT_MDP_RDMA0, DDP_COMPONENT_MERGE1,
		MT8188_VDO1_VPP_MERGE0_P0_SEL_IN, GENMASK(0, 0),
		MT8188_VPP_MERGE0_P0_SEL_IN_FROM_MDP_RDMA0
	}, {
		DDP_COMPONENT_MDP_RDMA1, DDP_COMPONENT_MERGE1,
		MT8188_VDO1_VPP_MERGE0_P1_SEL_IN, GENMASK(0, 0),
		MT8188_VPP_MERGE0_P1_SEL_IN_FROM_MDP_RDMA1
	}, {
		DDP_COMPONENT_MDP_RDMA2, DDP_COMPONENT_MERGE2,
		MT8188_VDO1_VPP_MERGE1_P0_SEL_IN, GENMASK(0, 0),
		MT8188_VPP_MERGE1_P0_SEL_IN_FROM_MDP_RDMA2
	}, {
		DDP_COMPONENT_MERGE1, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MERGE0_ASYNC_SOUT_SEL, GENMASK(1, 0),
		MT8188_SOUT_TO_MIXER_IN1_SEL
	}, {
		DDP_COMPONENT_MERGE2, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MERGE1_ASYNC_SOUT_SEL, GENMASK(1, 0),
		MT8188_SOUT_TO_MIXER_IN2_SEL
	}, {
		DDP_COMPONENT_MERGE3, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MERGE2_ASYNC_SOUT_SEL, GENMASK(1, 0),
		MT8188_SOUT_TO_MIXER_IN3_SEL
	}, {
		DDP_COMPONENT_MERGE4, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MERGE3_ASYNC_SOUT_SEL, GENMASK(1, 0),
		MT8188_SOUT_TO_MIXER_IN4_SEL
	}, {
		DDP_COMPONENT_ETHDR_MIXER, DDP_COMPONENT_MERGE5,
		MT8188_VDO1_MIXER_OUT_SOUT_SEL, GENMASK(0, 0),
		MT8188_MIXER_SOUT_TO_MERGE4_ASYNC_SEL
	}, {
		DDP_COMPONENT_MERGE1, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MIXER_IN1_SEL_IN, GENMASK(0, 0),
		MT8188_MIXER_IN1_SEL_IN_FROM_MERGE0_ASYNC_SOUT
	}, {
		DDP_COMPONENT_MERGE2, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MIXER_IN2_SEL_IN, GENMASK(0, 0),
		MT8188_MIXER_IN2_SEL_IN_FROM_MERGE1_ASYNC_SOUT
	}, {
		DDP_COMPONENT_MERGE3, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MIXER_IN3_SEL_IN, GENMASK(0, 0),
		MT8188_MIXER_IN3_SEL_IN_FROM_MERGE2_ASYNC_SOUT
	}, {
		DDP_COMPONENT_MERGE4, DDP_COMPONENT_ETHDR_MIXER,
		MT8188_VDO1_MIXER_IN4_SEL_IN, GENMASK(0, 0),
		MT8188_MIXER_IN4_SEL_IN_FROM_MERGE3_ASYNC_SOUT
	}, {
		DDP_COMPONENT_ETHDR_MIXER, DDP_COMPONENT_MERGE5,
		MT8188_VDO1_MIXER_SOUT_SEL_IN, GENMASK(2, 0),
		MT8188_MIXER_SOUT_SEL_IN_FROM_DISP_MIXER
	}, {
		DDP_COMPONENT_ETHDR_MIXER, DDP_COMPONENT_MERGE5,
		MT8188_VDO1_MERGE4_ASYNC_SEL_IN, GENMASK(2, 0),
		MT8188_MERGE4_ASYNC_SEL_IN_FROM_MIXER_OUT_SOUT
	}, {
		DDP_COMPONENT_MERGE5, DDP_COMPONENT_DPI1,
		MT8188_VDO1_DISP_DPI1_SEL_IN, GENMASK(1, 0),
		MT8188_DISP_DPI1_SEL_IN_FROM_VPP_MERGE4_MOUT
	}, {
		DDP_COMPONENT_MERGE5, DDP_COMPONENT_DPI1,
		MT8188_VDO1_MERGE4_SOUT_SEL, GENMASK(1, 0),
		MT8188_MERGE4_SOUT_TO_DPI1_SEL
	}, {
		DDP_COMPONENT_MERGE5, DDP_COMPONENT_DP_INTF1,
		MT8188_VDO1_DISP_DP_INTF0_SEL_IN, GENMASK(1, 0),
		MT8188_DISP_DP_INTF0_SEL_IN_FROM_VPP_MERGE4_MOUT
	}, {
		DDP_COMPONENT_MERGE5, DDP_COMPONENT_DP_INTF1,
		MT8188_VDO1_MERGE4_SOUT_SEL, GENMASK(3, 0),
		MT8188_MERGE4_SOUT_TO_DP_INTF0_SEL
	}
};

#endif /* __SOC_MEDIATEK_MT8188_MMSYS_H */
