'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
'\" t
.TH XCreateGC __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XCreateGC, XCopyGC, XChangeGC, XGetGCValues, XFreeGC, XGContextFromGC, XGCValues \- create or free graphics contexts and graphics context structure
.SH SYNTAX
.HP
GC XCreateGC\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, unsigned long
\fIvaluemask\fP\^, XGCValues *\^\fIvalues\fP\^);
.HP
int XCopyGC\^(\^Display *\fIdisplay\fP\^, GC \fIsrc\fP\^,
unsigned long \fIvaluemask\fP\^, GC \fIdest\fP\^);
.HP
int XChangeGC\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^, unsigned long
\fIvaluemask\fP\^, XGCValues *\^\fIvalues\fP\^);
.HP
Status XGetGCValues\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^, unsigned long
\fIvaluemask\fP\^, XGCValues *\fIvalues_return\fP\^);
.HP
int XFreeGC\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^);
.HP
GContext XGContextFromGC\^(\^GC \fIgc\fP\^);
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable.
.IP \fIdest\fP 1i
Specifies the destination GC.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fIsrc\fP 1i
Specifies the components of the source GC.
.IP \fIvaluemask\fP 1i
Specifies which components in the GC are to be set, copied, changed, or returned.
This argument is the bitwise inclusive OR of zero or more of the valid
GC component mask bits.
.IP \fIvalues\fP 1i
Specifies any values as specified by the valuemask.
.IP \fIvalues_return\fP 1i
Returns the GC values in the specified
.B XGCValues
structure.
.SH DESCRIPTION
The
.B XCreateGC
function creates a graphics context and returns a GC.
The GC can be used with any destination drawable having the same root
and depth as the specified drawable.
Use with other drawables results in a
.B BadMatch
error.
.LP
.B XCreateGC
can generate
.BR BadAlloc ,
.BR BadDrawable ,
.BR BadFont ,
.BR BadMatch ,
.BR BadPixmap ,
and
.B BadValue
errors.
.LP
The
.B XCopyGC
function copies the specified components from the source GC
to the destination GC.
The source and destination GCs must have the same root and depth,
or a
.B BadMatch
error results.
The valuemask specifies which component to copy, as for
.BR XCreateGC .
.LP
.B XCopyGC
can generate
.BR BadAlloc ,
.BR BadGC ,
and
.B BadMatch
errors.
.LP
The
.B XChangeGC
function changes the components specified by valuemask for
the specified GC.
The values argument contains the values to be set.
The values and restrictions are the same as for
.BR XCreateGC .
Changing the clip-mask overrides any previous
.B XSetClipRectangles
request on the context.
Changing the dash-offset or dash-list
overrides any previous
.B XSetDashes
request on the context.
The order in which components are verified and altered is server dependent.
If an error is generated, a subset of the components may have been altered.
.LP
.B XChangeGC
can generate
.BR BadAlloc ,
.BR BadFont ,
.BR BadGC ,
.BR BadMatch ,
.BR BadPixmap ,
and
.B BadValue
errors.
.LP
The
.B XGetGCValues
function returns the components specified by valuemask for the specified GC.
If the valuemask contains a valid set of GC mask bits
.RB ( GCFunction ,
.BR GCPlaneMask ,
.BR GCForeground ,
.BR GCBackground ,
.BR GCLineWidth ,
.BR GCLineStyle ,
.BR GCCapStyle ,
.BR GCJoinStyle ,
.BR GCFillStyle ,
.BR GCFillRule ,
.BR GCTile ,
.BR GCStipple ,
.BR GCTileStipXOrigin ,
.BR GCTileStipYOrigin ,
.BR GCFont ,
.BR GCSubwindowMode ,
.BR GCGraphicsExposures ,
.BR GCClipXOrigin ,
.BR GCClipYOrigin ,
.BR GCDashOffset ,
or
.BR GCArcMode )
and no error occurs,
.B XGetGCValues
sets the requested components in values_return and returns a nonzero status.
Otherwise, it returns a zero status.
Note that the clip-mask and dash-list (represented by the
.B GCClipMask
and
.B GCDashList
bits, respectively, in the valuemask)
cannot be requested.
Also note that an invalid resource ID (with one or more of the three
most significant bits set to 1) will be returned for
.BR GCFont ,
.BR GCTile ,
and
.B GCStipple
if the component has never been explicitly set by the client.
.LP
The
.B XFreeGC
function destroys the specified GC as well as all the associated storage.
.LP
.B XFreeGC
can generate a
.B BadGC
error.
.SH STRUCTURES
The
.B XGCValues
structure contains:
.LP
/\&* GC attribute value mask bits */
.TS
lw(.5i) lw(2.5i) lw(.75i).
\&#define	T{
.B GCFunction
T}	T{
(1L<<0)
T}
\&#define	T{
.B GCPlaneMask
T}	T{
(1L<<1)
T}
\&#define	T{
.B GCForeground
T}	T{
(1L<<2)
T}
\&#define	T{
.B GCBackground
T}	T{
(1L<<3)
T}
\&#define	T{
.B GCLineWidth
T}	T{
(1L<<4)
T}
\&#define	T{
.B GCLineStyle
T}	T{
(1L<<5)
T}
\&#define	T{
.B GCCapStyle
T}	T{
(1L<<6)
T}
\&#define	T{
.B GCJoinStyle
T}	T{
(1L<<7)
T}
\&#define	T{
.B GCFillStyle
T}	T{
(1L<<8)
T}
\&#define	T{
.B GCFillRule
T}	T{
(1L<<9)
T}
\&#define	T{
.B GCTile
T}	T{
(1L<<10)
T}
\&#define	T{
.B GCStipple
T}	T{
(1L<<11)
T}
\&#define	T{
.B GCTileStipXOrigin
T}	T{
(1L<<12)
T}
\&#define	T{
.B GCTileStipYOrigin
T}	T{
(1L<<13)
T}
\&#define	T{
.B GCFont
T}	T{
(1L<<14)
T}
\&#define	T{
.B GCSubwindowMode
T}	T{
(1L<<15)
T}
\&#define	T{
.B GCGraphicsExposures
T}	T{
(1L<<16)
T}
\&#define	T{
.B GCClipXOrigin
T}	T{
(1L<<17)
T}
\&#define	T{
.B GCClipYOrigin
T}	T{
(1L<<18)
T}
\&#define	T{
.B GCClipMask
T}	T{
(1L<<19)
T}
\&#define	T{
.B GCDashOffset
T}	T{
(1L<<20)
T}
\&#define	T{
.B GCDashList
T}	T{
(1L<<21)
T}
\&#define	T{
.B GCArcMode
T}	T{
(1L<<22)
T}
.TE
.LP
.EX
/\&* Values */

typedef struct {
        int function;   /\&* logical operation */
        unsigned long plane_mask;       /\&* plane mask */
        unsigned long foreground;       /\&* foreground pixel */
        unsigned long background;       /\&* background pixel */
        int line_width; /\&* line width (in pixels) */
        int line_style; /\&* LineSolid, LineOnOffDash, LineDoubleDash */
        int cap_style;  /\&* CapNotLast, CapButt, CapRound, CapProjecting */
        int join_style; /\&* JoinMiter, JoinRound, JoinBevel */
        int fill_style; /\&* FillSolid, FillTiled, FillStippled FillOpaqueStippled*/
        int fill_rule;  /\&* EvenOddRule, WindingRule */
        int arc_mode;   /\&* ArcChord, ArcPieSlice */
        Pixmap tile;    /\&* tile pixmap for tiling operations */
        Pixmap stipple; /\&* stipple 1 plane pixmap for stippling */
        int ts_x_origin;        /\&* offset for tile or stipple operations */
        int ts_y_origin;
        Font font;      /\&* default text font for text operations */
        int subwindow_mode;     /\&* ClipByChildren, IncludeInferiors */
        Bool graphics_exposures;        /\&* boolean, should exposures be generated */
        int clip_x_origin;      /\&* origin for clipping */
        int clip_y_origin;
        Pixmap clip_mask;       /\&* bitmap clipping; other calls for rects */
        int dash_offset;        /\&* patterned/dashed line information */
        char dashes;
} XGCValues;
.EE
.LP
The function attributes of a GC are used when you update a section of
a drawable (the destination) with bits from somewhere else (the source).
The function in a GC defines how the new destination bits are to be
computed from the source bits and the old destination bits.
.B GXcopy
is typically the most useful because it will work on a color display,
but special applications may use other functions,
particularly in concert with particular planes of a color display.
The 16 GC functions, defined in
.BR X11/X.h ,
are:
.\" are listed in Table 5-1 along with the
.\"the associated hexadecimal code
.\" and operation.
.\".CP T 1
.\"Display Functions
.TS
lw(1.5i) cw(.5i) lw(2i).
_
.sp 6p
.B
Function Name	Value	Operation
.sp 6p
_
.sp 6p
T{
.B GXclear
T}	T{
0x0
T}	T{
0
T}
T{
.B GXand
T}	T{
0x1
T}	T{
src AND dst
T}
T{
.B GXandReverse
T}	T{
0x2
T}	T{
src AND NOT dst
T}
T{
.B GXcopy
T}	T{
0x3
T}	T{
src
T}
T{
.B GXandInverted
T}	T{
0x4
T}	T{
(NOT src) AND dst
T}
T{
.B GXnoop
T}	T{
0x5
T}	T{
dst
T}
T{
.B GXxor
T}	T{
0x6
T}	T{
src XOR dst
T}
T{
.B GXor
T}	T{
0x7
T}	T{
src OR dst
T}
T{
.B GXnor
T}	T{
0x8
T}	T{
(NOT src) AND (NOT dst)
T}
T{
.B GXequiv
T}	T{
0x9
T}	T{
(NOT src) XOR dst
T}
T{
.B GXinvert
T}	T{
0xa
T}	T{
NOT dst
T}
T{
.B GXorReverse
T}	T{
0xb
T}	T{
src OR (NOT dst)
T}
T{
.B GXcopyInverted
T}	T{
0xc
T}	T{
NOT src
T}
T{
.B GXorInverted
T}	T{
0xd
T}	T{
(NOT src) OR dst
T}
T{
.B GXnand
T}	T{
0xe
T}	T{
(NOT src) OR (NOT dst)
T}
T{
.B GXset
T}	T{
0xf
T}	T{
1
T}
.sp 6p
_
.TE
.LP
Many graphics operations depend on either pixel values or planes in a GC.
The planes attribute is of type long, and it specifies which planes of the
destination are to be modified, one bit per plane.
A monochrome display has only one plane and
will be the least significant bit of the word.
As planes are added to the display hardware, they will occupy more
significant bits in the plane mask.
.LP
In graphics operations, given a source and destination pixel,
the result is computed bitwise on corresponding bits of the pixels.
That is, a Boolean operation is performed in each bit plane.
The plane_mask restricts the operation to a subset of planes.
A macro constant
.B AllPlanes
can be used to refer to all planes of the screen simultaneously.
The result is computed by the following:
.LP
.EX
((src FUNC dst) AND plane-mask) OR (dst AND (NOT plane-mask))
.EE
.LP
Range checking is not performed on the values for foreground,
background, or plane_mask.
They are simply truncated to the appropriate
number of bits.
The line-width is measured in pixels and either can be greater than or equal to
one (wide line) or can be the special value zero (thin line).
.LP
Wide lines are drawn centered on the path described by the graphics request.
Unless otherwise specified by the join-style or cap-style,
the bounding box of a wide line with endpoints [x1, y1], [x2, y2] and
width w is a rectangle with vertices at the following real coordinates:
.LP
.EX
[x1-(w*sn/2), y1+(w*cs/2)], [x1+(w*sn/2), y1-(w*cs/2)],
[x2-(w*sn/2), y2+(w*cs/2)], [x2+(w*sn/2), y2-(w*cs/2)]
.EE
.LP
Here sn is the sine of the angle of the line,
and cs is the cosine of the angle of the line.
A pixel is part of the line and so is drawn
if the center of the pixel is fully inside the bounding box
(which is viewed as having infinitely thin edges).
If the center of the pixel is exactly on the bounding box,
it is part of the line if and only if the interior is immediately to its right
(x increasing direction).
Pixels with centers on a horizontal edge are a special case and are part of
the line if and only if the interior or the boundary is immediately below
(y increasing direction) and the interior or the boundary is immediately
to the right (x increasing direction).
.LP
Thin lines (zero line-width) are one-pixel-wide lines drawn using an
unspecified, device-dependent algorithm.
There are only two constraints on this algorithm.
.IP 1. 5
If a line is drawn unclipped from [x1,y1] to [x2,y2] and
if another line is drawn unclipped from [x1+dx,y1+dy] to [x2+dx,y2+dy],
a point [x,y] is touched by drawing the first line
if and only if the point [x+dx,y+dy] is touched by drawing the second line.
.IP 2. 5
The effective set of points comprising a line cannot be affected by clipping.
That is, a point is touched in a clipped line if and only if the point
lies inside the clipping region and the point would be touched
by the line when drawn unclipped.
.LP
A wide line drawn from [x1,y1] to [x2,y2] always draws the same pixels
as a wide line drawn from [x2,y2] to [x1,y1], not counting cap-style
and join-style.
It is recommended that this property be true for thin lines,
but this is not required.
A line-width of zero may differ from a line-width of one in which pixels are
drawn.
This permits the use of many manufacturers' line drawing hardware,
which may run many times faster than the more precisely specified
wide lines.
.LP
In general,
drawing a thin line will be faster than drawing a wide line of width one.
However, because of their different drawing algorithms,
thin lines may not mix well aesthetically with wide lines.
If it is desirable to obtain precise and uniform results across all displays,
a client should always use a line-width of one rather than a line-width of zero.
.LP
The line-style defines which sections of a line are drawn:
.TS
lw(1.0i) lw(4.5i).
T{
.B LineSolid
T}	T{
The full path of the line is drawn.
T}
.sp 6p
T{
.B LineDoubleDash
T}	T{
The full path of the line is drawn,
but the even dashes are filled differently
from the odd dashes (see fill-style) with
.B CapButt
style used where even and odd dashes meet.
T}
.sp 6p
T{
.B LineOnOffDash
T}	T{
Only the even dashes are drawn,
and cap-style applies to
all internal ends of the individual dashes,
except
.B CapNotLast
is treated as
.BR CapButt .
T}
.TE
.LP
The cap-style defines how the endpoints of a path are drawn:
.TS
lw(1.0i) lw(4.5i).
T{
.B CapNotLast
T}	T{
This is equivalent to
.B CapButt
except that for a line-width of zero the final endpoint is not drawn.
T}
.sp 6p
T{
.B CapButt
T}	T{
The line is square at the endpoint (perpendicular to the slope of the line)
with no projection beyond.
T}
.sp 6p
T{
.B CapRound
T}	T{
The line has a circular arc with the diameter equal to the line-width,
centered on the endpoint.
(This is equivalent to
.B CapButt
for line-width of zero).
T}
.sp 6p
T{
.B CapProjecting
T}	T{
The line is square at the end, but the path continues beyond the endpoint
for a distance equal to half the line-width.
(This is equivalent to
.B CapButt
for line-width of zero).
T}
.TE
.LP
The join-style defines how corners are drawn for wide lines:
.TS
lw(1.0i) lw(4.5i).
T{
.B JoinMiter
T}	T{
The outer edges of two lines extend to meet at an angle.
However, if the angle is less than 11 degrees,
then a
.B JoinBevel
join-style is used instead.
T}
.sp 6p
T{
.B JoinRound
T}	T{
The corner is a circular arc with the diameter equal to the line-width,
centered on the joinpoint.
T}
.sp 6p
T{
.B JoinBevel
T}	T{
The corner has
.B CapButt
endpoint styles with the triangular notch filled.
T}
.TE
.LP
For a line with coincident endpoints (x1=x2, y1=y2),
when the cap-style is applied to both endpoints,
the semantics depends on the line-width and the cap-style:
.TS
lw(1.0i) lw(.5i) lw(4i).
T{
.B CapNotLast
T}	T{
thin
T}	T{
The results are device dependent,
but the desired effect is that nothing is drawn.
T}
.sp 6p
T{
.B CapButt
T}	T{
thin
T}	T{
The results are device dependent,
but the desired effect is that a single pixel is drawn.
T}
.sp 6p
T{
.B CapRound
T}	T{
thin
T}	T{
The results are the same as for
.BR CapButt /thin.
T}
.sp 6p
T{
.B CapProjecting
T}	T{
thin
T}	T{
The results are the same as for
.BR CapButt /thin.
T}
.sp 6p
T{
.B CapButt
T}	T{
wide
T}	T{
Nothing is drawn.
T}
.sp 6p
T{
.B CapRound
T}	T{
wide
T}	T{
The closed path is a circle, centered at the endpoint, and
with the diameter equal to the line-width.
T}
.sp 6p
T{
.B CapProjecting
T}	T{
wide
T}	T{
The closed path is a square, aligned with the coordinate axes, centered at the
endpoint, and with the sides equal to the line-width.
T}
.TE
.LP
For a line with coincident endpoints (x1=x2, y1=y2),
when the join-style is applied at one or both endpoints,
the effect is as if the line was removed from the overall path.
However, if the total path consists of or is reduced to a single point joined
with itself, the effect is the same as when the cap-style is applied at both
endpoints.
.LP
The tile/stipple represents an infinite two-dimensional plane,
with the tile/stipple replicated in all dimensions.
When that plane is superimposed on the drawable
for use in a graphics operation, the upper-left corner
of some instance of the tile/stipple is at the coordinates within
the drawable specified by the tile/stipple origin.
The tile/stipple and clip origins are interpreted relative to the
origin of whatever destination drawable is specified in a graphics
request.
The tile pixmap must have the same root and depth as the GC,
or a
.B BadMatch
error results.
The stipple pixmap must have depth one and must have the same root as the
GC, or a
.B BadMatch
error results.
For stipple operations where the fill-style is
.B FillStippled
but not
.BR FillOpaqueStippled ,
the stipple pattern is tiled in a
single plane and acts as an additional clip mask to be ANDed with the clip-mask.
Although some sizes may be faster to use than others,
any size pixmap can be used for tiling or stippling.
.LP
The fill-style defines the contents of the source for line, text, and
fill requests.
For all text and fill requests (for example,
.BR XDrawText ,
.BR XDrawText16 ,
.BR XFillRectangle ,
.BR XFillPolygon ,
and
.BR XFillArc );
for line requests
with line-style
.B LineSolid
(for example,
.BR XDrawLine ,
.BR XDrawSegments ,
.BR XDrawRectangle ,
.BR XDrawArc );
and for the even dashes for line requests with line-style
.B LineOnOffDash
or
.BR LineDoubleDash ,
the following apply:
.TS
lw(1.5i) lw(4i).
T{
.B FillSolid
T}	T{
Foreground
T}
.sp 6p
T{
.B FillTiled
T}	T{
Tile
T}
.sp 6p
T{
.B FillOpaqueStippled
T}	T{
A tile with the same width and height as stipple,
but with background everywhere stipple has a zero
and with foreground everywhere stipple has a one
T}
.sp 6p
T{
.B FillStippled
T}	T{
Foreground masked by stipple
T}
.TE
.LP
When drawing lines with line-style
.BR LineDoubleDash ,
the odd dashes are controlled by the fill-style in the following manner:
.TS
lw(1.5i) lw(4i).
T{
.B FillSolid
T}	T{
Background
T}
.sp 6p
T{
.B FillTiled
T}	T{
Same as for even dashes
T}
.sp 6p
T{
.B FillOpaqueStippled
T}	T{
Same as for even dashes
T}
.sp 6p
T{
.B FillStippled
T}	T{
Background masked by stipple
T}
.TE
.LP
Storing a pixmap in a GC might or might not result in a copy
being made.
If the pixmap is later used as the destination for a graphics request,
the change might or might not be reflected in the GC.
If the pixmap is used simultaneously in a graphics request both as
a destination and as a tile or stipple,
the results are undefined.
.LP
For optimum performance,
you should draw as much as possible with the same GC
(without changing its components).
The costs of changing GC components relative to using different GCs
depend on the display hardware and the server implementation.
It is quite likely that some amount of GC information will be
cached in display hardware and that such hardware can only cache a small number
of GCs.
.LP
The dashes value is actually a simplified form of the
more general patterns that can be set with
.BR XSetDashes .
Specifying a
value of N is equivalent to specifying the two-element list [N, N] in
.BR XSetDashes .
The value must be nonzero,
or a
.B BadValue
error results.
.LP
The clip-mask restricts writes to the destination drawable.
If the clip-mask is set to a pixmap,
it must have depth one and have the same root as the GC,
or a
.B BadMatch
error results.
If clip-mask is set to
.BR None ,
the pixels are always drawn regardless of the clip origin.
The clip-mask also can be set by calling the
.B XSetClipRectangles
or
.B XSetRegion
functions.
Only pixels where the clip-mask has a bit set to 1 are drawn.
Pixels are not drawn outside the area covered by the clip-mask
or where the clip-mask has a bit set to 0.
The clip-mask affects all graphics requests.
The clip-mask does not clip sources.
The clip-mask origin is interpreted relative to the origin of whatever
destination drawable is specified in a graphics request.
.LP
You can set the subwindow-mode to
.B ClipByChildren
or
.BR IncludeInferiors .
For
.BR ClipByChildren ,
both source and destination windows are
additionally clipped by all viewable
.B InputOutput
children.
For
.BR IncludeInferiors ,
neither source nor destination window is clipped by inferiors.
This will result in including subwindow contents in the source
and drawing through subwindow boundaries of the destination.
The use of
.B IncludeInferiors
on a window of one depth with mapped
inferiors of differing depth is not illegal, but the semantics are
undefined by the core protocol.
.LP
The fill-rule defines what pixels are inside (drawn) for
paths given in
.B XFillPolygon
requests and can be set to
.B EvenOddRule
or
.BR WindingRule .
For
.BR EvenOddRule ,
a point is inside if
an infinite ray with the point as origin crosses the path an odd number
of times.
For
.BR WindingRule ,
a point is inside if an infinite ray with the
point as origin crosses an unequal number of clockwise and
counterclockwise directed path segments.
A clockwise directed path segment is one that crosses the ray from left to
right as observed from the point.
A counterclockwise segment is one that crosses the ray from right to left
as observed from the point.
The case where a directed line segment is coincident with the ray is
uninteresting because you can simply choose a different ray that is not
coincident with a segment.
.LP
For both
.B EvenOddRule
and
.BR WindingRule ,
a point is infinitely small,
and the path is an infinitely thin line.
A pixel is inside if the center point of the pixel is inside
and the center point is not on the boundary.
If the center point is on the boundary,
the pixel is inside if and only if the polygon interior is immediately to
its right (x increasing direction).
Pixels with centers on a horizontal edge are a special case
and are inside if and only if the polygon interior is immediately below
(y increasing direction).
.LP
The arc-mode controls filling in the
.B XFillArcs
function and can be set to
.B ArcPieSlice
or
.BR ArcChord .
For
.BR ArcPieSlice ,
the arcs are pie-slice filled.
For
.BR ArcChord ,
the arcs are chord filled.
.LP
The graphics-exposure flag controls
.B GraphicsExpose
event generation
for
.B XCopyArea
and
.B XCopyPlane
requests (and any similar requests defined by extensions).
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.B BadFont
A value for a Font or GContext argument does not name a defined Font.
.TP 1i
.B BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.B BadMatch
An
.B InputOnly
window is used as a Drawable.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadPixmap
A value for a Pixmap argument does not name a defined Pixmap.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.BR AllPlanes (__libmansuffix__),
.BR XCopyArea (__libmansuffix__),
.BR XCreateRegion (__libmansuffix__),
.BR XDrawArc (__libmansuffix__),
.BR XDrawLine (__libmansuffix__),
.BR XDrawRectangle (__libmansuffix__),
.BR XDrawText (__libmansuffix__),
.BR XFillRectangle (__libmansuffix__),
.BR XQueryBestSize (__libmansuffix__),
.BR XSetArcMode (__libmansuffix__),
.BR XSetClipOrigin (__libmansuffix__),
.BR XSetFillStyle (__libmansuffix__),
.BR XSetFont (__libmansuffix__),
.BR XSetLineAttributes (__libmansuffix__),
.BR XSetState (__libmansuffix__),
.BR XSetTile (__libmansuffix__)
.br
\fI\*(xL\fP
