/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDataStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFormulaAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextTableFormulaElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "table-formula");

    public TextTableFormulaElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleDataStyleNameAttribute() {
        StyleDataStyleNameAttribute attr = (StyleDataStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "data-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleDataStyleNameAttribute(String styleDataStyleNameValue) {
        StyleDataStyleNameAttribute attr = new StyleDataStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleDataStyleNameValue);
    }

    public String getTextDisplayAttribute() {
        TextDisplayAttribute attr = (TextDisplayAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "display");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextDisplayAttribute(String textDisplayValue) {
        TextDisplayAttribute attr = new TextDisplayAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textDisplayValue);
    }

    public String getTextFormulaAttribute() {
        TextFormulaAttribute attr = (TextFormulaAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "formula");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextFormulaAttribute(String textFormulaValue) {
        TextFormulaAttribute attr = new TextFormulaAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textFormulaValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

