/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_ctrl_ip_h__
#define __ls10_dev_ctrl_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_CTRL                      0x0001FFFF:0x00000000 /* RW--D */
#define NV_CTRL_CPU_INTR_TOP(i)             (0x00013400+(i)*4) /* R--4A */
#define NV_CTRL_CPU_INTR_TOP__SIZE_1 64 /*       */
#define NV_CTRL_CPU_INTR_TOP_VALUE                        31:0 /* R--VF */
#define NV_CTRL_CPU_INTR_TOP_EN_SET(i)               (0x00013800+(i)*4) /* RW-4A */
#define NV_CTRL_CPU_INTR_TOP_EN_SET__SIZE_1   64 /*       */
#define NV_CTRL_CPU_INTR_TOP_EN_SET_VALUE                          31:0 /* RWIVF */
#define NV_CTRL_CPU_INTR_TOP_EN_SET_VALUE_INIT               0x00000000 /* R-I-V */
#define NV_CTRL_CPU_INTR_TOP_EN_CLEAR(i)             (0x00013C00+(i)*4) /* RW-4A */
#define NV_CTRL_CPU_INTR_TOP_EN_CLEAR__SIZE_1 64 /*       */
#define NV_CTRL_CPU_INTR_TOP_EN_CLEAR_VALUE                        31:0 /* RWIVF */
#define NV_CTRL_CPU_INTR_TOP_EN_CLEAR_VALUE_INIT             0x00000000 /* R-I-V */
#define NV_CTRL_CPU_INTR_LEAF(i)                                         (0x00014000+(i)*4) /* RW-4A */
#define NV_CTRL_CPU_INTR_LEAF__SIZE_1    1024 /*       */
#define NV_CTRL_CPU_INTR_LEAF_VALUE                                                    31:0 /* RWIVF */
#define NV_CTRL_CPU_INTR_LEAF_VALUE_INIT                                         0x00000000 /* R-I-V */
#define NV_CTRL_CPU_INTR_LEAF_ARRAY_SIZE_PER_FN  16 /*       */
#define NV_CTRL_CPU_INTR_LEAF_EN_SET(i)                                           (0x00018000+(i)*4) /* RW-4A */
#define NV_CTRL_CPU_INTR_LEAF_EN_SET__SIZE_1      1024 /*       */
#define NV_CTRL_CPU_INTR_LEAF_EN_SET_VALUE                                                      31:0 /* RWIVF */
#define NV_CTRL_CPU_INTR_LEAF_EN_SET_VALUE_INIT                                           0x00000000 /* R-I-V */
#define NV_CTRL_CPU_INTR_LEAF_EN_CLEAR(i)                                         (0x0001C000+(i)*4) /* RW-4A */
#define NV_CTRL_CPU_INTR_LEAF_EN_CLEAR__SIZE_1    1024 /*       */
#define NV_CTRL_CPU_INTR_LEAF_EN_CLEAR_VALUE                                                    31:0 /* RWIVF */
#define NV_CTRL_CPU_INTR_LEAF_EN_CLEAR_VALUE_INIT                                         0x00000000 /* R-I-V */
#define NV_CTRL_CPU_INTR_LEAF_TRIGGER(i)                   (0x00006C00+(i)*4) /* -W-4A */
#define NV_CTRL_CPU_INTR_LEAF_TRIGGER__SIZE_1       64 /*       */
#define NV_CTRL_CPU_INTR_LEAF_TRIGGER_VECTOR                             11:0 /* -WXVF */
#define NV_CTRL_PRI_CTRL_CG1                             0x00006A00 /* RW-4R */
#define NV_CTRL_PRI_CTRL_CG1_SLCG                               2:1 /*       */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_ENABLED                0x00000000 /*       */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_DISABLED               0x00000003 /*       */
#define NV_CTRL_PRI_CTRL_CG1_SLCG__PROD                  0x00000000 /*       */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_CTRLPRI                       1:1 /* RWIVF */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_CTRLPRI_ENABLED        0x00000000 /* RW--V */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_CTRLPRI_DISABLED       0x00000001 /* RWI-V */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_CTRLPRI__PROD          0x00000000 /* RW--V */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_MSIX                          2:2 /* RWIVF */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_MSIX_ENABLED           0x00000000 /* RW--V */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_MSIX_DISABLED          0x00000001 /* RWI-V */
#define NV_CTRL_PRI_CTRL_CG1_SLCG_MSIX__PROD             0x00000000 /* RW--V */
#endif // __ls10_dev_ctrl_ip_h__
