/*----------------------------------------------------------------------------
  ChucK Strongly-timed Audio Programming Language
    Compiler and Virtual Machine

  Copyright (c) 2003 Ge Wang and Perry R. Cook. All rights reserved.
    http://chuck.cs.princeton.edu/
    http://soundlab.cs.princeton.edu/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  U.S.A.
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// file: util_raw.c
// desc: raw data from STK
//
// authors: Ge Wang (gewang@cs.princeton.edu)
//          Perry R. Cook (prc@cs.princeton.edu)
// date: Autumn 2002
//------------------------------------------------------------------------------
#include "util_raw.h"

#ifndef __DISABLE_RAW__

// data for ahh.raw...
SAMPLE ahh_data[] = {
    -619.0f,-1663.0f,-3454.0f,-5317.0f,-6337.0f,-6667.0f,-5952.0f,-2723.0f,
    2562.0f,7412.0f,11227.0f,14729.0f,16641.0f,15910.0f,13340.0f,9605.0f,
    5268.0f,1887.0f,-177.0f,-2049.0f,-3518.0f,-3831.0f,-3647.0f,-3872.0f,
    -4378.0f,-4611.0f,-3839.0f,-1824.0f,505.0f,2730.0f,5372.0f,7967.0f,
    9003.0f,8047.0f,5951.0f,3059.0f,-691.0f,-4064.0f,-6233.0f,-7582.0f,
    -7574.0f,-5984.0f,-4032.0f,-2386.0f,-940.0f,-177.0f,-41.0f,514.0f,
    1469.0f,2232.0f,3838.0f,6585.0f,8368.0f,8440.0f,7774.0f,6192.0f,
    3333.0f,-201.0f,-3261.0f,-4851.0f,-4715.0f,-3221.0f,-932.0f,1678.0f,
    4128.0f,5782.0f,5951.0f,4746.0f,3212.0f,1975.0f,1028.0f,393.0f,
    248.0f,827.0f,1678.0f,1831.0f,1228.0f,602.0f,144.0f,-515.0f,
    -1245.0f,-1149.0f,16.0f,1365.0f,2047.0f,2200.0f,2634.0f,3140.0f,
    2409.0f,787.0f,-121.0f,40.0f,
    0
}; t_CKUINT ahh_size = 92;

// data for britestk.raw...
SAMPLE britestk_data[] = {
    353.0f,1285.0f,-2916.0f,3646.0f,-129.0f,257.0f,-169.0f,-2177.0f,
    931.0f,-643.0f,2545.0f,-1045.0f,682.0f,-2980.0f,4047.0f,-5245.0f,
    3140.0f,-707.0f,-1687.0f,3485.0f,-1446.0f,2120.0f,-4241.0f,-940.0f,
    843.0f,1542.0f,2537.0f,-466.0f,160.0f,-4072.0f,2457.0f,-1486.0f,
    1903.0f,48.0f,136.0f,1156.0f,1068.0f,-1759.0f,200.0f,-2024.0f,
    1421.0f,361.0f,-65.0f,1084.0f,-25.0f,-3036.0f,3076.0f,-1567.0f,
    1799.0f,-1020.0f,1839.0f,-3317.0f,3477.0f,-2434.0f,2096.0f,-860.0f,
    64.0f,120.0f,-892.0f,562.0f,176.0f,481.0f,-137.0f,-177.0f,
    -362.0f,658.0f,-515.0f,1076.0f,473.0f,-498.0f,-523.0f,787.0f,
    -1173.0f,1301.0f,-2707.0f,2634.0f,-747.0f,1252.0f,-1253.0f,-274.0f,
    -1687.0f,658.0f,-322.0f,706.0f,-788.0f,1389.0f,-1462.0f,1790.0f,
    -812.0f,722.0f,257.0f,-169.0f,265.0f,32.0f,-137.0f,562.0f,
    -523.0f,393.0f,-25.0f,979.0f,-1663.0f,746.0f,-1663.0f,1445.0f,
    -1591.0f,1951.0f,-563.0f,578.0f,570.0f,1614.0f,-3904.0f,3027.0f,
    -4145.0f,4280.0f,96.0f,2529.0f,-788.0f,570.0f,-1751.0f,1204.0f,
    -1904.0f,224.0f,-201.0f,-217.0f,6232.0f,-5614.0f,2738.0f,-3751.0f,
    1341.0f,-2024.0f,3919.0f,-2065.0f,2313.0f,-3566.0f,1943.0f,-924.0f,
    265.0f,152.0f,136.0f,-1824.0f,4296.0f,-3558.0f,2457.0f,-1318.0f,
    120.0f,2650.0f,-4080.0f,2529.0f,80.0f,-1840.0f,771.0f,1309.0f,
    -1462.0f,1100.0f,-747.0f,-57.0f,-274.0f,80.0f,658.0f,971.0f,
    -1478.0f,2529.0f,-5036.0f,3316.0f,-169.0f,2417.0f,-1575.0f,1750.0f,
    -3141.0f,2409.0f,-1045.0f,1317.0f,538.0f,-1125.0f,738.0f,-241.0f,
    -1920.0f,2401.0f,-2330.0f,602.0f,2345.0f,-900.0f,1815.0f,-2980.0f,
    538.0f,-1061.0f,2144.0f,184.0f,1397.0f,-346.0f,-643.0f,-474.0f,
    907.0f,-370.0f,1156.0f,-1302.0f,1036.0f,-3165.0f,5830.0f,-6225.0f,
    5838.0f,-2779.0f,-683.0f,-49.0f,-266.0f,-274.0f,1742.0f,-1165.0f,
    1517.0f,-1366.0f,746.0f,-274.0f,-3872.0f,1782.0f,88.0f,1124.0f,
    3413.0f,-1269.0f,-2105.0f,4039.0f,-8779.0f,10689.0f,-5414.0f,1742.0f,
    2441.0f,-1735.0f,-121.0f,2867.0f,-3968.0f,827.0f,168.0f,923.0f,
    -1470.0f,-9.0f,1437.0f,-3173.0f,1172.0f,594.0f,-611.0f,-780.0f,
    2497.0f,-1960.0f,3999.0f,-2498.0f,867.0f,1525.0f,-884.0f,754.0f,
    666.0f,-386.0f,1003.0f,939.0f,-1085.0f,-193.0f,-980.0f,1044.0f,
    -1671.0f,3132.0f,-3631.0f,1807.0f,-1928.0f,843.0f,72.0f,305.0f,
    -153.0f,-338.0f,136.0f,-1310.0f,2280.0f,-1141.0f,754.0f,1052.0f,
    -410.0f,-595.0f,1293.0f,-1663.0f,385.0f,96.0f,481.0f,2313.0f,
    -1671.0f,1566.0f,-1631.0f,1028.0f,-1591.0f,2048.0f,-3221.0f,3630.0f,
    -2113.0f,1044.0f,698.0f,-1061.0f,2843.0f,-3277.0f,24.0f,2031.0f,
    -2490.0f,2786.0f,1028.0f,-81.0f,1011.0f,-1261.0f,1068.0f,-659.0f,
    1204.0f,-1342.0f,2200.0f,-4354.0f,6232.0f,-5558.0f,3204.0f,1100.0f,
    -2803.0f,578.0f,730.0f,-1607.0f,-161.0f,-1029.0f,931.0f,1108.0f,
    1782.0f,-97.0f,-1671.0f,-1229.0f,811.0f,297.0f,827.0f,923.0f,
    273.0f,-1037.0f,-41.0f,184.0f,-1655.0f,1461.0f,-1671.0f,1903.0f,
    -506.0f,72.0f,626.0f,-4707.0f,5348.0f,-4843.0f,4754.0f,-2587.0f,
    1525.0f,-932.0f,208.0f,634.0f,72.0f,248.0f,-185.0f,1558.0f,
    -643.0f,2192.0f,-2354.0f,2738.0f,-1703.0f,658.0f,-346.0f,88.0f,
    -370.0f,3389.0f,-3173.0f,2031.0f,-1575.0f,-274.0f,289.0f,-667.0f,
    -338.0f,1180.0f,160.0f,811.0f,401.0f,-1398.0f,-450.0f,313.0f,
    1196.0f,-531.0f,1477.0f,-282.0f,923.0f,-241.0f,1582.0f,-3109.0f,
    2072.0f,-996.0f,481.0f,-1591.0f,1670.0f,-1205.0f,-290.0f,-97.0f,
    1084.0f,-2016.0f,1710.0f,-1559.0f,-233.0f,1485.0f,-1342.0f,650.0f,
    -249.0f,1790.0f,-555.0f,1453.0f,-2314.0f,2296.0f,-1984.0f,1662.0f,
    -1053.0f,1485.0f,-763.0f,554.0f,-362.0f,-185.0f,-153.0f,-49.0f,
    -515.0f,907.0f,136.0f,385.0f,-515.0f,1533.0f,-1229.0f,1060.0f,
    -1310.0f,1582.0f,-370.0f,899.0f,433.0f,321.0f,353.0f,208.0f,
    361.0f,-1245.0f,1967.0f,-1623.0f,2594.0f,-418.0f,232.0f,40.0f,
    -1486.0f,-788.0f,1453.0f,-266.0f,-1004.0f,2080.0f,-1526.0f,265.0f,
    1084.0f,-3735.0f,2987.0f,-2611.0f,2160.0f,-258.0f,-860.0f,4023.0f,
    -5494.0f,5364.0f,-2522.0f,979.0f,240.0f,-988.0f,1156.0f,-1840.0f,
    2521.0f,-1944.0f,1124.0f,-964.0f,-41.0f,522.0f,-2811.0f,3349.0f,
    -2217.0f,602.0f,650.0f,-924.0f,1517.0f,-2081.0f,2296.0f,-1302.0f,
    1084.0f,859.0f,-177.0f,1244.0f,72.0f,-619.0f,1293.0f,-868.0f,
    754.0f,-788.0f,2642.0f,-4779.0f,8031.0f,-7968.0f,6047.0f,-2410.0f,
    -683.0f,1509.0f,-1518.0f,1309.0f,1140.0f,-1133.0f,1156.0f,-1245.0f,
    -354.0f,1333.0f,-1109.0f,1646.0f,-900.0f,1341.0f,-1711.0f,2843.0f,
    -3398.0f,3726.0f,-4217.0f,4505.0f,-836.0f,-707.0f,417.0f,-1173.0f,
    -1486.0f,3220.0f,-2587.0f,2064.0f,-1294.0f,80.0f,48.0f,-506.0f,
    -836.0f,32.0f,56.0f,1092.0f,329.0f,-298.0f,-217.0f,-571.0f,
    192.0f,1244.0f,401.0f,522.0f,-354.0f,289.0f,224.0f,-1631.0f,
    1726.0f,-1534.0f,947.0f,1766.0f,361.0f,-1695.0f,1341.0f,-4522.0f,
    4136.0f,-1510.0f,2393.0f,-755.0f,1188.0f,-1197.0f,1782.0f,-2169.0f,
    505.0f,-812.0f,2313.0f,1252.0f,-1952.0f,6513.0f,-10096.0f,7051.0f,
    -3486.0f,626.0f,779.0f,-747.0f,1044.0f,2168.0f,-2418.0f,1927.0f,
    -1840.0f,706.0f,-980.0f,1606.0f,-2699.0f,3565.0f,-3133.0f,1863.0f,
    -715.0f,-354.0f,2031.0f,-4900.0f,6360.0f,-4032.0f,2329.0f,-1197.0f,
    1180.0f,-900.0f,1863.0f,-1350.0f,16.0f,754.0f,-860.0f,-715.0f,
    3076.0f,-5446.0f,7453.0f,-7197.0f,5549.0f,-2177.0f,-643.0f,-73.0f,
    -1896.0f,2698.0f,-836.0f,1654.0f,-1.0f,-539.0f,1991.0f,-2643.0f,
    2979.0f,-2996.0f,3758.0f,-2161.0f,1413.0f,754.0f,-1623.0f,2529.0f,
    -4787.0f,4513.0f,-1872.0f,762.0f,-386.0f,811.0f,-2522.0f,3477.0f,
    -2860.0f,3116.0f,-1751.0f,939.0f,-1029.0f,1285.0f,-1446.0f,2529.0f,
    -3647.0f,4280.0f,-1743.0f,883.0f,-169.0f,-1711.0f,1011.0f,-241.0f,
    449.0f,-153.0f,1349.0f,-1767.0f,2602.0f,-3068.0f,1742.0f,-876.0f,
    -579.0f,746.0f,682.0f,-1446.0f,1598.0f,-828.0f,56.0f,562.0f,
    -1069.0f,1397.0f,-249.0f,-49.0f,1148.0f,329.0f,-916.0f,1911.0f,
    -1109.0f,-25.0f,353.0f,-555.0f,1670.0f,-362.0f,634.0f,-129.0f,
    -1037.0f,570.0f,64.0f,-290.0f,1260.0f,-611.0f,-996.0f,1333.0f,
    -1551.0f,626.0f,-73.0f,-33.0f,1951.0f,1598.0f,-185.0f,-1551.0f,
    377.0f,-2065.0f,2473.0f,1598.0f,-2490.0f,2931.0f,-1494.0f,24.0f,
    -450.0f,-515.0f,-1615.0f,1678.0f,16.0f,1710.0f,-1077.0f,-81.0f,
    -1253.0f,152.0f,1365.0f,-1559.0f,1646.0f,-651.0f,-490.0f,1799.0f,
    -1101.0f,811.0f,96.0f,385.0f,-1398.0f,907.0f,626.0f,-1029.0f,
    1638.0f,-362.0f,313.0f,843.0f,-1944.0f,2256.0f,-1904.0f,248.0f,
    1317.0f,-627.0f,779.0f,-1077.0f,1244.0f,-1743.0f,746.0f,2529.0f,
    -2257.0f,2730.0f,-2450.0f,2039.0f,-1414.0f,2931.0f,-1791.0f,1710.0f,
    88.0f,-996.0f,1927.0f,-1992.0f,1140.0f,-667.0f,1060.0f,754.0f,
    -57.0f,-1029.0f,-249.0f,-2587.0f,2594.0f,-1020.0f,554.0f,867.0f,
    -169.0f,1517.0f,-81.0f,-2314.0f,827.0f,-418.0f,1019.0f,-900.0f,
    2465.0f,-2040.0f,2015.0f,-1430.0f,-290.0f,1268.0f,-1952.0f,1493.0f,
    -996.0f,184.0f,1983.0f,-2980.0f,2449.0f,-627.0f,-980.0f,2698.0f,
    -2563.0f,811.0f,-820.0f,-306.0f,1831.0f,305.0f,168.0f,859.0f,
    -1020.0f,-225.0f,2176.0f,-2065.0f,1220.0f,995.0f,618.0f,-105.0f,
    843.0f,-1422.0f,730.0f,-1117.0f,2570.0f,-1149.0f,666.0f,1542.0f,
    -4594.0f,3533.0f,-1125.0f,-241.0f,1999.0f,-1920.0f,1276.0f,457.0f,
    -699.0f,104.0f,-33.0f,-225.0f,1469.0f,-338.0f,963.0f,-707.0f,
    16.0f,208.0f,112.0f,-442.0f,1116.0f,-2185.0f,2481.0f,-1438.0f,
    -105.0f,-298.0f,-225.0f,-298.0f,594.0f,-763.0f,987.0f,449.0f,
    128.0f,819.0f,-1840.0f,-121.0f,-249.0f,1566.0f,24.0f,224.0f,
    353.0f,-386.0f,441.0f,72.0f,-908.0f,1895.0f,-1061.0f,1236.0f,
    923.0f,-964.0f,-25.0f,-1101.0f,771.0f,1373.0f,602.0f,-217.0f,
    -338.0f,-354.0f,104.0f,369.0f,819.0f,32.0f,538.0f,-298.0f,
    1196.0f,-1004.0f,-97.0f,-274.0f,923.0f,931.0f,2280.0f,-2466.0f,
    1469.0f,-2474.0f,2015.0f,-1518.0f,2248.0f,-1936.0f,2224.0f,-2900.0f,
    3895.0f,-4851.0f,3357.0f,-2932.0f,1341.0f,706.0f,-812.0f,1766.0f,
    -2201.0f,1333.0f,377.0f,-836.0f,2144.0f,-2113.0f,1582.0f,-2418.0f,
    2393.0f,-2105.0f,3421.0f,-3277.0f,2529.0f,-1165.0f,-370.0f,192.0f,
    -217.0f,-1422.0f,3172.0f,-1783.0f,1831.0f,706.0f,-3261.0f,2305.0f,
    -1719.0f,1421.0f,192.0f,441.0f,-97.0f,2047.0f,-1808.0f,1429.0f,
    257.0f,-1655.0f,3204.0f,-2378.0f,1887.0f,1076.0f,-2273.0f,2706.0f,
    -1559.0f,666.0f,995.0f,-1591.0f,1052.0f,-65.0f,-675.0f,1525.0f,
    -1928.0f,2296.0f,-1719.0f,1148.0f,-241.0f,32.0f,-458.0f,1469.0f,
    -2314.0f,2104.0f,-2169.0f,1582.0f,698.0f,955.0f,-474.0f,-458.0f,
    -25.0f,48.0f,-338.0f,40.0f,-354.0f,522.0f,1148.0f,-1623.0f,
    618.0f,-876.0f,-820.0f,1389.0f,0.0f,1228.0f,-1398.0f,939.0f,
    -3036.0f,3822.0f,-2281.0f,1911.0f,-57.0f,313.0f,-73.0f,626.0f,
    -1334.0f,867.0f,-1053.0f,1999.0f,16.0f,1325.0f,-531.0f,-442.0f,
    200.0f,136.0f,232.0f,698.0f,-306.0f,-442.0f,2698.0f,-3325.0f,
    3324.0f,-1205.0f,883.0f,-1334.0f,2264.0f,-2474.0f,2449.0f,-1518.0f,
    240.0f,1622.0f,-1430.0f,1509.0f,-747.0f,-699.0f,803.0f,-723.0f,
    1140.0f,-41.0f,337.0f,216.0f,-1952.0f,2425.0f,-1816.0f,1044.0f,
    -587.0f,1052.0f,-932.0f,578.0f,433.0f,-2129.0f,1927.0f,-1310.0f,
    1718.0f,192.0f,-418.0f,48.0f,-884.0f,803.0f,-523.0f,1100.0f,
    -1310.0f,1148.0f,1236.0f,-2241.0f,1911.0f,-2707.0f,1766.0f,-1141.0f,
    2714.0f,-876.0f,883.0f,-667.0f,738.0f,48.0f,-563.0f,128.0f,
    377.0f,1116.0f,393.0f,-49.0f,425.0f,-852.0f,730.0f,-57.0f,
    1188.0f,-988.0f,1333.0f,-1832.0f,1469.0f,-739.0f,546.0f,-137.0f,
    -282.0f,1212.0f,-161.0f,-153.0f,-105.0f,-691.0f,1807.0f,-1197.0f,
    2730.0f,-1165.0f,-25.0f,-241.0f,-603.0f,939.0f,-659.0f,851.0f,
    -1109.0f,1999.0f,-1286.0f,48.0f,433.0f,-603.0f,-129.0f,1887.0f,
    -996.0f,554.0f,-185.0f,-1671.0f,1309.0f,136.0f,1220.0f,-1037.0f,
    554.0f,-820.0f,-667.0f,1188.0f,-1269.0f,690.0f,1260.0f,650.0f,
    1188.0f,-675.0f,-410.0f,-1133.0f,313.0f,2176.0f,-1518.0f,1309.0f,
    281.0f,-675.0f,1381.0f,-2450.0f,2602.0f,-3125.0f,3646.0f,-2169.0f,
    1694.0f,32.0f,-1277.0f,457.0f,0.0f,1381.0f,-892.0f,1477.0f,
    -1253.0f,1132.0f,915.0f,-2378.0f,1927.0f,-442.0f,-426.0f,1654.0f,
    -523.0f,-314.0f,-193.0f,112.0f,-523.0f,955.0f,-394.0f,24.0f,
    1148.0f,289.0f,-611.0f,345.0f,-450.0f,-330.0f,1204.0f,-1318.0f,
    931.0f,-249.0f,-129.0f,385.0f,-964.0f,939.0f,232.0f,-1053.0f,
    2023.0f,-723.0f,224.0f,562.0f,-707.0f,1260.0f,-290.0f,32.0f,
    698.0f,-563.0f,915.0f,-1093.0f,1172.0f,-804.0f,867.0f,-603.0f,
    441.0f,353.0f,-523.0f,1036.0f,-217.0f,497.0f,-707.0f,1100.0f,
    -1245.0f,1028.0f,-169.0f,-683.0f,2224.0f,-434.0f,152.0f,-177.0f,
    -370.0f,-402.0f,1188.0f,-723.0f,481.0f,497.0f,-97.0f,72.0f,
    -73.0f,-579.0f,425.0f,-290.0f,1100.0f,1052.0f,-900.0f,8.0f,
    -571.0f,1212.0f,-1334.0f,1855.0f,-1294.0f,843.0f,-1478.0f,2056.0f,
    -2779.0f,2377.0f,-1350.0f,473.0f,1622.0f,377.0f,-804.0f,-282.0f,
    297.0f,184.0f,522.0f,674.0f,-370.0f,706.0f,-1037.0f,1076.0f,
    -876.0f,505.0f,-57.0f,112.0f,995.0f,-258.0f,449.0f,-266.0f,
    184.0f,634.0f,64.0f,-129.0f,481.0f,24.0f,-450.0f,120.0f,
    1646.0f,-1832.0f,2537.0f,-2795.0f,2345.0f,-1992.0f,1381.0f,-651.0f,
    224.0f,722.0f,281.0f,481.0f,-1133.0f,1927.0f,-2731.0f,2594.0f,
    -1607.0f,835.0f,722.0f,-1438.0f,1847.0f,-667.0f,-852.0f,1871.0f,
    -2530.0f,2698.0f,-2040.0f,698.0f,963.0f,-1277.0f,915.0f,273.0f,
    -9.0f,1180.0f,-1502.0f,1855.0f,-1735.0f,1437.0f,-57.0f,120.0f,
    -153.0f,1164.0f,-739.0f,538.0f,-442.0f,257.0f,-73.0f,449.0f,
    722.0f,554.0f,-169.0f,160.0f,240.0f,208.0f,-233.0f,16.0f,
    1076.0f,-1647.0f,1975.0f,-1012.0f,112.0f,1485.0f,-1077.0f,-667.0f,
    1750.0f,-1800.0f,1694.0f,104.0f,-1109.0f,2594.0f,-2008.0f,1943.0f,
    -1342.0f,-249.0f,-89.0f,-274.0f,1879.0f,-908.0f,1381.0f,-1663.0f,
    1285.0f,-1269.0f,1204.0f,-1583.0f,1574.0f,-643.0f,313.0f,-137.0f,
    1654.0f,-3020.0f,2240.0f,-474.0f,449.0f,722.0f,562.0f,-1318.0f,
    1100.0f,-290.0f,546.0f,-330.0f,754.0f,-386.0f,698.0f,16.0f,
    -225.0f,-73.0f,433.0f,-113.0f,1252.0f,698.0f,-1567.0f,2489.0f,
    -2137.0f,1405.0f,48.0f,-418.0f,610.0f,971.0f,-1543.0f,1911.0f,
    -1856.0f,1702.0f,-1302.0f,1437.0f,-65.0f,425.0f,152.0f,248.0f,
    -739.0f,1630.0f,-715.0f,-555.0f,2232.0f,-2193.0f,1999.0f,-1398.0f,
    714.0f,602.0f,-1004.0f,297.0f,80.0f,24.0f,-370.0f,562.0f,
    -402.0f,441.0f,457.0f,-1237.0f,1429.0f,-482.0f,-370.0f,1268.0f,
    -916.0f,1076.0f,-820.0f,385.0f,-290.0f,-49.0f,1686.0f,-1261.0f,
    1236.0f,-386.0f,-772.0f,746.0f,-354.0f,1003.0f,-442.0f,867.0f,
    0.0f,610.0f,-595.0f,297.0f,257.0f,-185.0f,1678.0f,-1189.0f,
    2031.0f,-1928.0f,1068.0f,-73.0f,361.0f,666.0f,-105.0f,337.0f,
    64.0f,297.0f,337.0f,224.0f,208.0f,409.0f,-225.0f,248.0f,
    232.0f,-515.0f,208.0f,803.0f,-956.0f,1566.0f,-627.0f,-201.0f,
    48.0f,409.0f,-249.0f,192.0f,401.0f,-129.0f,425.0f,-137.0f,
    -225.0f,425.0f,-852.0f,867.0f,-908.0f,1718.0f,-1277.0f,1244.0f,
    -225.0f,562.0f,-1727.0f,481.0f,-804.0f,1493.0f,-474.0f,232.0f,
    1036.0f,-1711.0f,2545.0f,-2466.0f,1638.0f,-515.0f,738.0f,522.0f,
    1108.0f,-306.0f,-916.0f,674.0f,-1117.0f,2626.0f,-739.0f,658.0f,
    248.0f,-1053.0f,2072.0f,-1599.0f,730.0f,16.0f,1357.0f,-571.0f,
    1493.0f,24.0f,-1398.0f,224.0f,682.0f,931.0f,192.0f,64.0f,
    -402.0f,995.0f,-2330.0f,3156.0f,-2836.0f,2578.0f,-1213.0f,2168.0f,
    -1318.0f,489.0f,-651.0f,-964.0f,1935.0f,160.0f,-105.0f,1204.0f,
    -1559.0f,88.0f,-57.0f,112.0f,-651.0f,835.0f,0.0f,1188.0f,
    -1358.0f,1349.0f,-2048.0f,2015.0f,-1816.0f,1991.0f,-563.0f,-161.0f,
    658.0f,-209.0f,56.0f,698.0f,923.0f,-2257.0f,3284.0f,-2129.0f,
    819.0f,441.0f,-258.0f,-571.0f,1991.0f,-1438.0f,1381.0f,-233.0f,
    875.0f,787.0f,-547.0f,859.0f,-539.0f,979.0f,-298.0f,-137.0f,
    1019.0f,80.0f,-940.0f,2256.0f,-2073.0f,2047.0f,-796.0f,72.0f,
    1068.0f,-683.0f,706.0f,-282.0f,369.0f,200.0f,706.0f,-635.0f,
    1092.0f,-932.0f,80.0f,546.0f,658.0f,-466.0f,1799.0f,-2554.0f,
    1919.0f,-1791.0f,1807.0f,-1872.0f,1349.0f,257.0f,353.0f,-370.0f,
    1188.0f,-2129.0f,1060.0f,297.0f,-105.0f,762.0f,232.0f,-980.0f,
    1124.0f,-386.0f,273.0f,-747.0f,1276.0f,-523.0f,176.0f,875.0f,
    -73.0f,-667.0f,1919.0f,-1101.0f,489.0f,987.0f,-932.0f,658.0f,
    1405.0f,-1711.0f,2369.0f,-1599.0f,1726.0f,-1366.0f,2176.0f,-2209.0f,
    1606.0f,-89.0f,-241.0f,706.0f,811.0f,-932.0f,1847.0f,-1069.0f,
    1060.0f,152.0f,-523.0f,706.0f,-193.0f,1855.0f,-2546.0f,2505.0f,
    -1494.0f,554.0f,160.0f,-555.0f,1566.0f,-603.0f,-402.0f,1542.0f,
    -1454.0f,722.0f,666.0f,-1848.0f,2136.0f,-1004.0f,779.0f,-844.0f,
    1823.0f,-715.0f,305.0f,-587.0f,1132.0f,-2153.0f,2851.0f,-2932.0f,
    2738.0f,-900.0f,208.0f,361.0f,-89.0f,-89.0f,104.0f,1084.0f,
    -675.0f,1606.0f,-73.0f,-627.0f,441.0f,618.0f,-667.0f,835.0f,
    160.0f,-105.0f,795.0f,-1085.0f,2240.0f,-1607.0f,1790.0f,-948.0f,
    1044.0f,-1117.0f,2080.0f,-1117.0f,779.0f,674.0f,-201.0f,-25.0f,
    224.0f,200.0f,-177.0f,104.0f,947.0f,80.0f,32.0f,546.0f,
    -1583.0f,1919.0f,-1342.0f,2192.0f,-1117.0f,1044.0f,-1085.0f,1236.0f,
    -1358.0f,1702.0f,-876.0f,329.0f,192.0f,128.0f,289.0f,-916.0f,
    570.0f,168.0f,-458.0f,947.0f,24.0f,-796.0f,1919.0f,-1872.0f,
    2208.0f,-1414.0f,1839.0f,-836.0f,248.0f,-49.0f,626.0f,297.0f,
    514.0f,-25.0f,88.0f,-683.0f,522.0f,746.0f,-386.0f,546.0f,
    361.0f,-1.0f,586.0f,722.0f,-1390.0f,1807.0f,-627.0f,1228.0f,
    -1053.0f,2176.0f,-2281.0f,1790.0f,-418.0f,313.0f,939.0f,-1205.0f,
    1019.0f,-715.0f,586.0f,465.0f,64.0f,706.0f,385.0f,-635.0f,
    1807.0f,-2603.0f,1839.0f,-1543.0f,1220.0f,835.0f,-57.0f,176.0f,
    88.0f,-707.0f,489.0f,208.0f,-1261.0f,2353.0f,-763.0f,128.0f,
    2570.0f,-4105.0f,3188.0f,-2105.0f,779.0f,1871.0f,-2546.0f,3991.0f,
    -3301.0f,2337.0f,-659.0f,-81.0f,-386.0f,1509.0f,-1430.0f,1831.0f,
    -547.0f,-490.0f,1879.0f,-1775.0f,1790.0f,1196.0f,-2820.0f,3686.0f,
    -2876.0f,1180.0f,1461.0f,-1302.0f,2441.0f,-1454.0f,273.0f,489.0f,
    -707.0f,-81.0f,1437.0f,-1012.0f,738.0f,1413.0f,-1366.0f,321.0f,
    1421.0f,-2169.0f,2810.0f,-2506.0f,3051.0f,-2016.0f,1517.0f,-402.0f,
    136.0f,377.0f,570.0f,-1286.0f,979.0f,-1.0f,-185.0f,690.0f,
    136.0f,40.0f,1003.0f,-1783.0f,1397.0f,-41.0f,-643.0f,610.0f,
    1100.0f,-1414.0f,1357.0f,-1053.0f,1517.0f,-603.0f,497.0f,-17.0f,
    -65.0f,923.0f,-322.0f,-169.0f,939.0f,-916.0f,1662.0f,-1053.0f,
    939.0f,273.0f,-145.0f,562.0f,714.0f,-298.0f,-145.0f,2168.0f,
    -3237.0f,3469.0f,-1446.0f,457.0f,48.0f,329.0f,-498.0f,-129.0f,
    1373.0f,265.0f,-370.0f,1180.0f,-394.0f,698.0f,152.0f,-1494.0f,
    1951.0f,-860.0f,497.0f,642.0f,-177.0f,-523.0f,1742.0f,-2346.0f,
    2184.0f,-1856.0f,1895.0f,-1221.0f,746.0f,771.0f,-105.0f,-731.0f,
    1566.0f,-515.0f,-796.0f,1742.0f,-1534.0f,1517.0f,-153.0f,72.0f,
    457.0f,240.0f,208.0f,-97.0f,-1253.0f,3003.0f,-2691.0f,1983.0f,
    -298.0f,497.0f,827.0f,-1037.0f,1405.0f,-1864.0f,1774.0f,-691.0f,
    1678.0f,-41.0f,329.0f,682.0f,-2024.0f,2810.0f,-1928.0f,409.0f,
    1317.0f,-1639.0f,4184.0f,-3671.0f,2819.0f,-1502.0f,1726.0f,-2434.0f,
    4634.0f,-3848.0f,2915.0f,-1020.0f,-217.0f,1485.0f,-1157.0f,923.0f,
    -442.0f,-892.0f,1421.0f,-1093.0f,947.0f,473.0f,273.0f,377.0f,
    -1318.0f,2489.0f,-2916.0f,2473.0f,-1751.0f,2385.0f,-1125.0f,867.0f,
    706.0f,-2081.0f,2136.0f,-1149.0f,-723.0f,3003.0f,-3342.0f,3477.0f,
    -2065.0f,1003.0f,771.0f,-1085.0f,1068.0f,-964.0f,377.0f,329.0f,
    281.0f,1357.0f,-386.0f,562.0f,441.0f,-458.0f,-964.0f,3357.0f,
    -3615.0f,3477.0f,-1101.0f,883.0f,-651.0f,1333.0f,-1061.0f,401.0f,
    722.0f,-354.0f,1381.0f,-1478.0f,2537.0f,-2916.0f,3493.0f,-1261.0f,
    907.0f,321.0f,-1350.0f,578.0f,947.0f,-1069.0f,1405.0f,-322.0f,
    104.0f,433.0f,995.0f,-2161.0f,2682.0f,-1117.0f,184.0f,417.0f,
    265.0f,-306.0f,-145.0f,200.0f,-209.0f,835.0f,-258.0f,-129.0f,
    0
}; t_CKUINT britestk_size = 2048;

// data for dope.raw...
SAMPLE dope_data[] = {
    8.0f,16.0f,16.0f,16.0f,8.0f,32.0f,32.0f,24.0f,
    8.0f,16.0f,24.0f,24.0f,16.0f,16.0f,32.0f,32.0f,
    32.0f,40.0f,24.0f,16.0f,16.0f,0.0f,-1.0f,-9.0f,
    -9.0f,-9.0f,-9.0f,-25.0f,-49.0f,-41.0f,-33.0f,-41.0f,
    -41.0f,-57.0f,-57.0f,-65.0f,-65.0f,-57.0f,0.0f,32.0f,
    -258.0f,-563.0f,-619.0f,-1302.0f,-1663.0f,-1245.0f,-1639.0f,-1824.0f,
    -1944.0f,-2161.0f,-2105.0f,-1647.0f,-1269.0f,-1221.0f,-1109.0f,-1687.0f,
    -1559.0f,-1165.0f,-1221.0f,-1061.0f,-1165.0f,-1663.0f,-1559.0f,-1037.0f,
    -1189.0f,-1012.0f,-852.0f,-900.0f,-627.0f,-225.0f,8.0f,-338.0f,
    -346.0f,-434.0f,-266.0f,530.0f,489.0f,425.0f,-41.0f,-523.0f,
    -780.0f,-1012.0f,-362.0f,-394.0f,-667.0f,-490.0f,-739.0f,-1149.0f,
    -691.0f,-217.0f,-266.0f,-177.0f,88.0f,-249.0f,-900.0f,-619.0f,
    -908.0f,-1269.0f,-1438.0f,-1639.0f,-1526.0f,-1775.0f,-1583.0f,-1534.0f,
    -1502.0f,-1037.0f,-747.0f,-137.0f,184.0f,-17.0f,240.0f,345.0f,
    112.0f,345.0f,465.0f,594.0f,281.0f,-17.0f,-193.0f,-563.0f,
    -370.0f,-25.0f,24.0f,96.0f,-394.0f,-490.0f,-81.0f,104.0f,
    489.0f,899.0f,1100.0f,714.0f,1036.0f,1148.0f,514.0f,393.0f,
    -17.0f,-113.0f,305.0f,56.0f,-41.0f,104.0f,8.0f,-89.0f,
    505.0f,1060.0f,610.0f,923.0f,1397.0f,899.0f,489.0f,96.0f,
    -25.0f,112.0f,682.0f,1052.0f,642.0f,353.0f,-1.0f,0.0f,
    682.0f,899.0f,1028.0f,538.0f,-466.0f,-370.0f,-523.0f,-402.0f,
    514.0f,96.0f,-282.0f,289.0f,690.0f,1341.0f,1405.0f,1437.0f,
    618.0f,-868.0f,-410.0f,-482.0f,-956.0f,329.0f,449.0f,192.0f,
    1060.0f,738.0f,859.0f,995.0f,353.0f,602.0f,16.0f,-17.0f,
    602.0f,56.0f,690.0f,1076.0f,779.0f,1477.0f,722.0f,-57.0f,
    -354.0f,-1567.0f,-1101.0f,-763.0f,-1125.0f,-105.0f,64.0f,248.0f,
    1132.0f,1333.0f,1718.0f,1244.0f,305.0f,8.0f,-418.0f,200.0f,
    1132.0f,1710.0f,2056.0f,1525.0f,1268.0f,971.0f,1036.0f,1686.0f,
    1815.0f,1469.0f,1341.0f,1622.0f,1678.0f,2240.0f,3300.0f,3790.0f,
    3638.0f,3590.0f,3276.0f,2160.0f,1574.0f,1598.0f,1164.0f,1373.0f,
    1550.0f,907.0f,1156.0f,1268.0f,1485.0f,1694.0f,1349.0f,698.0f,
    144.0f,32.0f,-145.0f,248.0f,650.0f,248.0f,-241.0f,-490.0f,
    -691.0f,-611.0f,96.0f,265.0f,-515.0f,-1342.0f,-1743.0f,-1623.0f,
    -1687.0f,-1061.0f,-563.0f,-1245.0f,-844.0f,-169.0f,618.0f,1453.0f,
    1140.0f,417.0f,-129.0f,-699.0f,-1534.0f,-651.0f,425.0f,248.0f,
    1052.0f,1517.0f,987.0f,963.0f,698.0f,650.0f,200.0f,425.0f,
    313.0f,-900.0f,-290.0f,-121.0f,417.0f,1574.0f,1582.0f,1790.0f,
    979.0f,570.0f,1381.0f,1590.0f,2305.0f,2345.0f,2023.0f,2465.0f,
    2513.0f,2529.0f,2907.0f,2843.0f,2144.0f,2401.0f,2497.0f,1509.0f,
    1132.0f,658.0f,473.0f,1084.0f,602.0f,409.0f,80.0f,-996.0f,
    -884.0f,-1045.0f,-1181.0f,-1534.0f,-2482.0f,-1422.0f,-1269.0f,-2691.0f,
    -2579.0f,-2924.0f,-3534.0f,-1920.0f,-643.0f,-956.0f,-1069.0f,-1165.0f,
    -1615.0f,-1671.0f,-113.0f,409.0f,80.0f,433.0f,8.0f,803.0f,
    1228.0f,570.0f,1373.0f,1349.0f,658.0f,1774.0f,2200.0f,1461.0f,
    1373.0f,562.0f,465.0f,1807.0f,1935.0f,2465.0f,3252.0f,2819.0f,
    2794.0f,2722.0f,2867.0f,3204.0f,3204.0f,3316.0f,2465.0f,1550.0f,
    2056.0f,1750.0f,1758.0f,2594.0f,2545.0f,2610.0f,2481.0f,2072.0f,
    1807.0f,947.0f,562.0f,642.0f,-667.0f,-1695.0f,-1703.0f,-3197.0f,
    -4932.0f,-4281.0f,-4072.0f,-4273.0f,-3342.0f,-3791.0f,-4225.0f,-4474.0f,
    -5590.0f,-4803.0f,-4072.0f,-3751.0f,-2306.0f,-2137.0f,-1053.0f,546.0f,
    923.0f,1533.0f,1831.0f,1525.0f,963.0f,586.0f,1132.0f,1285.0f,
    -233.0f,-547.0f,-490.0f,-490.0f,1116.0f,1718.0f,1935.0f,2152.0f,
    1807.0f,1927.0f,2650.0f,3798.0f,3871.0f,2786.0f,2264.0f,2128.0f,
    2626.0f,3453.0f,4112.0f,4618.0f,3606.0f,3003.0f,3341.0f,2802.0f,
    2810.0f,2931.0f,2015.0f,891.0f,289.0f,883.0f,1477.0f,1622.0f,
    1678.0f,481.0f,-980.0f,-2105.0f,-3221.0f,-3735.0f,-5213.0f,-6570.0f,
    -6907.0f,-7181.0f,-6337.0f,-5293.0f,-5542.0f,-5526.0f,-5550.0f,-6402.0f,
    -5727.0f,-4129.0f,-3494.0f,-2876.0f,-1984.0f,-1551.0f,-1061.0f,554.0f,
    1999.0f,2007.0f,2184.0f,1887.0f,1260.0f,1453.0f,2031.0f,1517.0f,
    56.0f,-836.0f,-1181.0f,-884.0f,184.0f,1517.0f,2208.0f,2208.0f,
    2120.0f,2987.0f,4168.0f,3943.0f,3284.0f,2200.0f,1285.0f,1742.0f,
    2337.0f,3164.0f,3638.0f,3188.0f,2746.0f,2192.0f,2160.0f,2481.0f,
    2128.0f,1140.0f,-306.0f,-1245.0f,-1518.0f,-1181.0f,522.0f,1750.0f,
    939.0f,-89.0f,-1077.0f,-2996.0f,-4530.0f,-5197.0f,-6891.0f,-8931.0f,
    -9357.0f,-8867.0f,-8305.0f,-7871.0f,-7108.0f,-6610.0f,-6859.0f,-7148.0f,
    -6297.0f,-4675.0f,-3888.0f,-2779.0f,-1607.0f,-611.0f,56.0f,706.0f,
    3148.0f,5726.0f,6609.0f,6441.0f,6039.0f,3991.0f,1815.0f,1212.0f,
    690.0f,987.0f,2023.0f,2562.0f,3108.0f,4007.0f,4585.0f,5405.0f,
    5324.0f,4457.0f,4553.0f,3614.0f,2256.0f,2537.0f,2746.0f,1951.0f,
    2168.0f,3421.0f,4160.0f,4738.0f,4899.0f,4304.0f,3067.0f,1373.0f,
    -161.0f,-1374.0f,-2105.0f,-1912.0f,-699.0f,0.0f,-506.0f,-924.0f,
    -1703.0f,-3711.0f,-5398.0f,-6787.0f,-8819.0f,-10602.0f,-11252.0f,-10947.0f,
    -10321.0f,-9389.0f,-8458.0f,-7566.0f,-6177.0f,-4868.0f,-3944.0f,-3109.0f,
    -2297.0f,-2225.0f,-2121.0f,-1462.0f,-378.0f,2039.0f,4762.0f,7236.0f,
    8585.0f,7878.0f,6802.0f,5340.0f,2827.0f,2120.0f,3308.0f,3172.0f,
    3027.0f,4545.0f,4899.0f,4577.0f,6272.0f,8465.0f,8979.0f,8143.0f,
    7308.0f,5903.0f,3606.0f,2738.0f,2425.0f,1268.0f,1405.0f,2521.0f,
    3140.0f,3726.0f,4465.0f,4465.0f,2891.0f,779.0f,-908.0f,-2723.0f,
    -3904.0f,-3695.0f,-3671.0f,-4410.0f,-4643.0f,-4586.0f,-5398.0f,-6610.0f,
    -7678.0f,-9229.0f,-11148.0f,-12297.0f,-12409.0f,-12248.0f,-11831.0f,-10843.0f,
    -9911.0f,-8787.0f,-7301.0f,-5735.0f,-3759.0f,-2137.0f,-595.0f,915.0f,
    1678.0f,3067.0f,5099.0f,7019.0f,9236.0f,11163.0f,11404.0f,10352.0f,
    9244.0f,7870.0f,6200.0f,5501.0f,5678.0f,5646.0f,5999.0f,6625.0f,
    6601.0f,6714.0f,7147.0f,7348.0f,7019.0f,6216.0f,4995.0f,2875.0f,
    1244.0f,457.0f,-651.0f,-1053.0f,-796.0f,-820.0f,-892.0f,-1149.0f,
    -1663.0f,-2731.0f,-4426.0f,-6040.0f,-7309.0f,-7863.0f,-7719.0f,-7992.0f,
    -8361.0f,-8458.0f,-9020.0f,-9582.0f,-9927.0f,-10433.0f,-10907.0f,-11220.0f,
    -11204.0f,-11060.0f,-10642.0f,-9710.0f,-8570.0f,-7237.0f,-5542.0f,-3655.0f,
    -1599.0f,441.0f,2152.0f,3308.0f,4328.0f,5694.0f,7059.0f,8858.0f,
    10914.0f,12079.0f,12207.0f,11701.0f,10762.0f,9581.0f,8384.0f,7718.0f,
    7300.0f,7220.0f,7533.0f,7485.0f,7364.0f,7091.0f,6296.0f,5670.0f,
    5067.0f,3975.0f,2305.0f,305.0f,-1639.0f,-3358.0f,-4313.0f,-4627.0f,
    -4538.0f,-3936.0f,-3566.0f,-4105.0f,-5116.0f,-6257.0f,-7566.0f,-8650.0f,
    -9036.0f,-8947.0f,-8947.0f,-8972.0f,-8666.0f,-8466.0f,-8401.0f,-8168.0f,
    -8112.0f,-8273.0f,-8474.0f,-8811.0f,-8875.0f,-8393.0f,-7526.0f,-6345.0f,
    -4859.0f,-3141.0f,-1109.0f,907.0f,2529.0f,3983.0f,5172.0f,5798.0f,
    6208.0f,7188.0f,8481.0f,10007.0f,11773.0f,12858.0f,12834.0f,11902.0f,
    10280.0f,8481.0f,6882.0f,5678.0f,5324.0f,5662.0f,6280.0f,6601.0f,
    6047.0f,4577.0f,2955.0f,1799.0f,754.0f,-346.0f,-1599.0f,-3374.0f,
    -5639.0f,-7558.0f,-8642.0f,-8723.0f,-7727.0f,-6313.0f,-5446.0f,-5341.0f,
    -5847.0f,-6739.0f,-7558.0f,-7863.0f,-7606.0f,-7164.0f,-6899.0f,-6642.0f,
    -6305.0f,-5879.0f,-5141.0f,-4217.0f,-3582.0f,-3309.0f,-3430.0f,-4024.0f,
    -4458.0f,-4305.0f,-3695.0f,-2627.0f,-1101.0f,714.0f,2586.0f,4553.0f,
    6376.0f,7886.0f,8987.0f,9179.0f,9067.0f,9059.0f,9220.0f,10239.0f,
    11404.0f,12047.0f,11902.0f,10818.0f,9067.0f,6995.0f,4842.0f,2955.0f,
    2031.0f,2056.0f,2562.0f,2907.0f,2176.0f,361.0f,-1711.0f,-3607.0f,
    -4972.0f,-5526.0f,-5855.0f,-6506.0f,-7413.0f,-8562.0f,-9486.0f,-9486.0f,
    -8650.0f,-7430.0f,-6169.0f,-5293.0f,-4932.0f,-4916.0f,-4908.0f,-4562.0f,
    -3856.0f,-2892.0f,-1880.0f,-1390.0f,-1302.0f,-1173.0f,-1286.0f,-1342.0f,
    -1181.0f,-1302.0f,-1454.0f,-1229.0f,-1165.0f,-1077.0f,-193.0f,883.0f,
    1790.0f,2979.0f,3975.0f,4907.0f,6168.0f,6947.0f,7613.0f,8095.0f,
    8031.0f,8175.0f,8505.0f,9187.0f,10239.0f,10930.0f,10617.0f,9308.0f,
    7396.0f,4867.0f,2031.0f,-434.0f,-2000.0f,-2354.0f,-1751.0f,-1093.0f,
    -868.0f,-1382.0f,-2803.0f,-4570.0f,-6032.0f,-6899.0f,-7365.0f,-7751.0f,
    -8056.0f,-8490.0f,-8867.0f,-8514.0f,-7413.0f,-5855.0f,-3992.0f,-2185.0f,
    -1029.0f,-458.0f,-209.0f,-217.0f,-274.0f,8.0f,449.0f,674.0f,
    819.0f,779.0f,377.0f,80.0f,-201.0f,-836.0f,-1045.0f,-844.0f,
    -1109.0f,-1149.0f,-506.0f,-49.0f,682.0f,1654.0f,2015.0f,2778.0f,
    3702.0f,4031.0f,4650.0f,4955.0f,4995.0f,5806.0f,6609.0f,7533.0f,
    8858.0f,9485.0f,9179.0f,8368.0f,6457.0f,3445.0f,473.0f,-2370.0f,
    -4362.0f,-4024.0f,-2587.0f,-1277.0f,128.0f,297.0f,-1053.0f,-2820.0f,
    -4578.0f,-5807.0f,-6530.0f,-7213.0f,-7622.0f,-8192.0f,-8618.0f,-7927.0f,
    -6450.0f,-4442.0f,-1727.0f,554.0f,1670.0f,2200.0f,2048.0f,1084.0f,
    449.0f,425.0f,265.0f,265.0f,425.0f,297.0f,297.0f,538.0f,
    321.0f,-169.0f,-515.0f,-1213.0f,-2289.0f,-2908.0f,-2980.0f,-2611.0f,
    -1575.0f,-362.0f,1052.0f,2947.0f,4353.0f,5364.0f,6457.0f,6569.0f,
    6481.0f,7324.0f,7549.0f,8111.0f,9814.0f,10464.0f,10023.0f,8834.0f,
    6208.0f,3011.0f,232.0f,-2587.0f,-4321.0f,-3679.0f,-2546.0f,-1687.0f,
    -924.0f,-1518.0f,-3125.0f,-4980.0f,-6562.0f,-7438.0f,-8144.0f,-8345.0f,
    -8096.0f,-8337.0f,-7911.0f,-6410.0f,-4835.0f,-2667.0f,-81.0f,1646.0f,
    2618.0f,3292.0f,3156.0f,2562.0f,2433.0f,2433.0f,1991.0f,1445.0f,
    1100.0f,803.0f,578.0f,176.0f,-482.0f,-1141.0f,-1687.0f,-2330.0f,
    -3020.0f,-3325.0f,-3020.0f,-2362.0f,-1478.0f,-33.0f,1766.0f,3477.0f,
    5083.0f,6087.0f,6505.0f,6850.0f,6409.0f,6119.0f,6794.0f,7565.0f,
    8722.0f,9685.0f,9477.0f,8328.0f,6079.0f,2706.0f,-739.0f,-3735.0f,
    -5815.0f,-5960.0f,-4924.0f,-3775.0f,-2603.0f,-2579.0f,-3904.0f,-5438.0f,
    -6747.0f,-7558.0f,-7670.0f,-7164.0f,-6418.0f,-5968.0f,-5398.0f,-4394.0f,
    -3181.0f,-1310.0f,939.0f,2802.0f,4272.0f,5356.0f,5662.0f,5509.0f,
    5485.0f,5260.0f,4449.0f,3437.0f,2176.0f,610.0f,-691.0f,-1783.0f,
    -2763.0f,-3197.0f,-3430.0f,-3807.0f,-4016.0f,-4169.0f,-3968.0f,-3342.0f,
    -2619.0f,-1374.0f,313.0f,2184.0f,3879.0f,4931.0f,5846.0f,6047.0f,
    5525.0f,5694.0f,6023.0f,6698.0f,8352.0f,9533.0f,9709.0f,8979.0f,
    6898.0f,3838.0f,144.0f,-3671.0f,-6281.0f,-6940.0f,-6072.0f,-4321.0f,
    -2828.0f,-2297.0f,-3028.0f,-4892.0f,-6546.0f,-7405.0f,-7510.0f,-6650.0f,
    -5655.0f,-4843.0f,-4096.0f,-3615.0f,-2779.0f,-1253.0f,787.0f,3180.0f,
    5316.0f,6979.0f,7975.0f,8007.0f,7565.0f,6641.0f,5083.0f,3357.0f,
    1477.0f,-458.0f,-1743.0f,-2595.0f,-3510.0f,-4000.0f,-4490.0f,-5213.0f,
    -5647.0f,-5928.0f,-5550.0f,-4506.0f,-3502.0f,-1888.0f,-177.0f,1220.0f,
    3180.0f,4690.0f,5533.0f,6545.0f,6666.0f,6352.0f,6706.0f,7067.0f,
    7886.0f,9115.0f,9750.0f,9468.0f,8023.0f,5405.0f,1943.0f,-2057.0f,
    -5606.0f,-7614.0f,-7960.0f,-6964.0f,-5382.0f,-4177.0f,-3880.0f,-4755.0f,
    -6217.0f,-7285.0f,-7590.0f,-6843.0f,-5382.0f,-3968.0f,-2715.0f,-1960.0f,
    -1543.0f,-691.0f,682.0f,2674.0f,5075.0f,7188.0f,8722.0f,9388.0f,
    8987.0f,7846.0f,6047.0f,3855.0f,1646.0f,-466.0f,-2145.0f,-3366.0f,
    -4514.0f,-5446.0f,-6281.0f,-7116.0f,-7462.0f,-7486.0f,-6964.0f,-5727.0f,
    -4289.0f,-2530.0f,-603.0f,1148.0f,3092.0f,4698.0f,5878.0f,7043.0f,
    7429.0f,7292.0f,7228.0f,6963.0f,6963.0f,7653.0f,8376.0f,8738.0f,
    8577.0f,7196.0f,4497.0f,859.0f,-3293.0f,-6996.0f,-9277.0f,-9670.0f,
    -8674.0f,-7333.0f,-6056.0f,-5446.0f,-5984.0f,-6779.0f,-7293.0f,-7173.0f,
    -5871.0f,-3960.0f,-1936.0f,-129.0f,883.0f,1413.0f,1726.0f,2264.0f,
    3646.0f,5356.0f,7204.0f,8697.0f,8818.0f,8224.0f,7292.0f,5445.0f,
    3011.0f,345.0f,-2193.0f,-4129.0f,-5566.0f,-6763.0f,-7638.0f,-8160.0f,
    -8458.0f,-8337.0f,-7630.0f,-6522.0f,-5076.0f,-3342.0f,-1615.0f,168.0f,
    1807.0f,3333.0f,4939.0f,6095.0f,7091.0f,7846.0f,7710.0f,7260.0f,
    7011.0f,6786.0f,6826.0f,7429.0f,7902.0f,7790.0f,6971.0f,5019.0f,
    1815.0f,-2137.0f,-5968.0f,-9028.0f,-10498.0f,-10128.0f,-8931.0f,-7598.0f,
    -6377.0f,-5960.0f,-6177.0f,-6257.0f,-5783.0f,-4305.0f,-2089.0f,257.0f,
    2393.0f,3718.0f,4136.0f,4176.0f,4240.0f,4842.0f,6007.0f,7284.0f,
    8432.0f,8922.0f,8344.0f,6931.0f,4505.0f,1293.0f,-1591.0f,-4048.0f,
    -6128.0f,-7566.0f,-8530.0f,-9237.0f,-9678.0f,-9686.0f,-9277.0f,-8297.0f,
    -6851.0f,-5165.0f,-3085.0f,-980.0f,1028.0f,2979.0f,4778.0f,6497.0f,
    7653.0f,8304.0f,8561.0f,8167.0f,7549.0f,7115.0f,6658.0f,6465.0f,
    6682.0f,6561.0f,6039.0f,4923.0f,2843.0f,-185.0f,-3799.0f,-7052.0f,
    -9478.0f,-10489.0f,-10008.0f,-8931.0f,-7751.0f,-6843.0f,-6418.0f,-6257.0f,
    -5751.0f,-4450.0f,-2121.0f,738.0f,3300.0f,5300.0f,6240.0f,6296.0f,
    6039.0f,5742.0f,5967.0f,6601.0f,7139.0f,7348.0f,6802.0f,5445.0f,
    3413.0f,795.0f,-1856.0f,-4305.0f,-6361.0f,-7735.0f,-8626.0f,-9212.0f,
    -9542.0f,-9574.0f,-9116.0f,-8136.0f,-6586.0f,-4635.0f,-2490.0f,-571.0f,
    1148.0f,3051.0f,4738.0f,5943.0f,7107.0f,8047.0f,8400.0f,8529.0f,
    8087.0f,7059.0f,6015.0f,4939.0f,4216.0f,3903.0f,3477.0f,2899.0f,
    1790.0f,-209.0f,-3004.0f,-5976.0f,-8393.0f,-10040.0f,-10377.0f,-9566.0f,
    -8393.0f,-7060.0f,-5847.0f,-5092.0f,-4225.0f,-2988.0f,-1229.0f,1309.0f,
    3935.0f,6184.0f,7766.0f,8304.0f,8192.0f,7621.0f,6906.0f,6360.0f,
    5710.0f,4971.0f,3879.0f,2232.0f,305.0f,-1912.0f,-4064.0f,-5831.0f,
    -7148.0f,-7927.0f,-8265.0f,-8377.0f,-8409.0f,-8184.0f,-7614.0f,-6763.0f,
    -5261.0f,-3301.0f,-1213.0f,1204.0f,3445.0f,5212.0f,6778.0f,7694.0f,
    8095.0f,8344.0f,7991.0f,7260.0f,6368.0f,5099.0f,3887.0f,2851.0f,
    2272.0f,2248.0f,2144.0f,1951.0f,1325.0f,-258.0f,-2691.0f,-5486.0f,
    -7839.0f,-9461.0f,-9959.0f,-9237.0f,-8048.0f,-6819.0f,-5582.0f,-4691.0f,
    -3775.0f,-2330.0f,-458.0f,2072.0f,4690.0f,6834.0f,8352.0f,8818.0f,
    8513.0f,7758.0f,6698.0f,5726.0f,4666.0f,3437.0f,1935.0f,32.0f,
    -2057.0f,-4265.0f,-6169.0f,-7454.0f,-8225.0f,-8201.0f,-7743.0f,-7277.0f,
    -6667.0f,-6136.0f,-5470.0f,-4498.0f,-3229.0f,-1342.0f,795.0f,2939.0f,
    5043.0f,6585.0f,7485.0f,7894.0f,7758.0f,7139.0f,6272.0f,5372.0f,
    4353.0f,3300.0f,2465.0f,1694.0f,1156.0f,1196.0f,1028.0f,754.0f,
    377.0f,-1181.0f,-3205.0f,-5309.0f,-7550.0f,-8859.0f,-9188.0f,-8755.0f,
    -7638.0f,-6337.0f,-4988.0f,-3743.0f,-2482.0f,-948.0f,779.0f,2963.0f,
    5236.0f,7067.0f,8489.0f,8954.0f,8569.0f,7838.0f,6505.0f,5083.0f,
    3670.0f,1935.0f,152.0f,-1775.0f,-3775.0f,-5582.0f,-7044.0f,-7944.0f,
    -8313.0f,-7984.0f,-7205.0f,-6273.0f,-5004.0f,-3831.0f,-2651.0f,-1358.0f,
    -81.0f,1574.0f,3252.0f,4802.0f,6208.0f,6882.0f,6971.0f,6601.0f,
    5533.0f,4280.0f,3284.0f,2353.0f,1831.0f,1879.0f,1999.0f,2489.0f,
    3132.0f,3003.0f,2578.0f,1533.0f,-539.0f,-2739.0f,-5028.0f,-7100.0f,
    -8184.0f,-8578.0f,-8297.0f,-7550.0f,-6779.0f,-5719.0f,-4691.0f,-3494.0f,
    -1647.0f,497.0f,3003.0f,5445.0f,7212.0f,8336.0f,8561.0f,8015.0f,
    7115.0f,5726.0f,4120.0f,2489.0f,738.0f,-988.0f,-2651.0f,-4113.0f,
    -5333.0f,-6080.0f,-6313.0f,-6209.0f,-5695.0f,-5036.0f,-4378.0f,-3574.0f,
    -2908.0f,-2040.0f,-844.0f,337.0f,1726.0f,3003.0f,3951.0f,4634.0f,
    4786.0f,4529.0f,4071.0f,3341.0f,2553.0f,1991.0f,1903.0f,2256.0f,
    2915.0f,4047.0f,4947.0f,5083.0f,4706.0f,3565.0f,1413.0f,-1277.0f,
    -3735.0f,-5767.0f,-7124.0f,-7518.0f,-7526.0f,-7301.0f,-6996.0f,-6650.0f,
    -5984.0f,-4996.0f,-3334.0f,-731.0f,1863.0f,3557.0f,4489.0f,5220.0f,
    5814.0f,5943.0f,5629.0f,5220.0f,4786.0f,4047.0f,2843.0f,1236.0f,
    -699.0f,-2635.0f,-4169.0f,-5189.0f,-5655.0f,-5574.0f,-5325.0f,-5068.0f,
    -4851.0f,-4635.0f,-4209.0f,-3446.0f,-2225.0f,-643.0f,1244.0f,2971.0f,
    4264.0f,5276.0f,5654.0f,5533.0f,5413.0f,4931.0f,4216.0f,3782.0f,
    3349.0f,2971.0f,3084.0f,3622.0f,4144.0f,4353.0f,4216.0f,3533.0f,
    1911.0f,-563.0f,-3036.0f,-5125.0f,-6851.0f,-7606.0f,-7622.0f,-7381.0f,
    -6859.0f,-6233.0f,-5502.0f,-4386.0f,-2755.0f,-531.0f,2128.0f,4545.0f,
    6473.0f,7734.0f,8119.0f,7951.0f,7348.0f,6376.0f,5300.0f,4007.0f,
    2296.0f,409.0f,-1727.0f,-3783.0f,-5382.0f,-6610.0f,-7084.0f,-6883.0f,
    -6522.0f,-5783.0f,-4827.0f,-4080.0f,-3125.0f,-1767.0f,-266.0f,1437.0f,
    3324.0f,4794.0f,5726.0f,6071.0f,5670.0f,4907.0f,3919.0f,2770.0f,
    1774.0f,1003.0f,867.0f,1236.0f,1967.0f,3228.0f,4208.0f,4425.0f,
    4192.0f,3043.0f,771.0f,-1808.0f,-4249.0f,-6450.0f,-7662.0f,-8088.0f,
    -8088.0f,-7333.0f,-6787.0f,-6016.0f,-4715.0f,-3366.0f,-1221.0f,1550.0f,
    4071.0f,6232.0f,7782.0f,8191.0f,7894.0f,7083.0f,5814.0f,4457.0f,
    3092.0f,1493.0f,-370.0f,-2225.0f,-4088.0f,-5566.0f,-6361.0f,-6659.0f,
    -6345.0f,-5598.0f,-4932.0f,-4281.0f,-3486.0f,-2771.0f,-1912.0f,-490.0f,
    1044.0f,2385.0f,3686.0f,4545.0f,4794.0f,4778.0f,4529.0f,4136.0f,
    3557.0f,2786.0f,2080.0f,1333.0f,835.0f,883.0f,1301.0f,2104.0f,
    2955.0f,3381.0f,3212.0f,2096.0f,64.0f,-2289.0f,-4675.0f,-6787.0f,
    -7823.0f,-7944.0f,-7662.0f,-6723.0f,-5647.0f,-4787.0f,-3639.0f,-2161.0f,
    -354.0f,1879.0f,4168.0f,6200.0f,7637.0f,8191.0f,7910.0f,6979.0f,
    5549.0f,3967.0f,2313.0f,570.0f,-1141.0f,-2771.0f,-4458.0f,-5920.0f,
    -6787.0f,-7173.0f,-7036.0f,-6273.0f,-5341.0f,-4321.0f,-3125.0f,-2008.0f,
    -804.0f,779.0f,2433.0f,3838.0f,5059.0f,5895.0f,5927.0f,5437.0f,
    4770.0f,3758.0f,2658.0f,1758.0f,787.0f,-129.0f,-555.0f,-619.0f,
    -201.0f,698.0f,1839.0f,2682.0f,2802.0f,2216.0f,738.0f,-1430.0f,
    -3687.0f,-5703.0f,-7052.0f,-7502.0f,-7173.0f,-6305.0f,-5301.0f,-4233.0f,
    -3052.0f,-1783.0f,-193.0f,1766.0f,3790.0f,5790.0f,7404.0f,8191.0f,
    8191.0f,7437.0f,5895.0f,3991.0f,1951.0f,-153.0f,-2040.0f,-3623.0f,
    -5141.0f,-6337.0f,-7084.0f,-7526.0f,-7373.0f,-6610.0f,-5574.0f,-4169.0f,
    -2450.0f,-780.0f,955.0f,2562.0f,3710.0f,4650.0f,5220.0f,5340.0f,
    5324.0f,4915.0f,4104.0f,3164.0f,1951.0f,489.0f,-755.0f,-1639.0f,
    -2040.0f,-1599.0f,-378.0f,1260.0f,2778.0f,3678.0f,3847.0f,2867.0f,
    891.0f,-1205.0f,-3277.0f,-4819.0f,-5422.0f,-5759.0f,-5719.0f,-5791.0f,
    -6209.0f,-5976.0f,-5365.0f,-4177.0f,-1751.0f,1060.0f,3606.0f,5790.0f,
    7043.0f,7316.0f,7003.0f,6224.0f,5429.0f,4513.0f,3132.0f,1421.0f,
    -627.0f,-3044.0f,-5253.0f,-6819.0f,-7807.0f,-7968.0f,-7365.0f,-6498.0f,
    -5398.0f,-4129.0f,-2868.0f,-1446.0f,176.0f,1911.0f,3686.0f,5132.0f,
    6047.0f,6497.0f,6224.0f,5429.0f,4521.0f,3300.0f,1943.0f,674.0f,
    -466.0f,-1366.0f,-1840.0f,-1454.0f,-563.0f,730.0f,2529.0f,3702.0f,
    4015.0f,3638.0f,1999.0f,-121.0f,-1936.0f,-3534.0f,-4715.0f,-5365.0f,
    -5887.0f,-6586.0f,-7156.0f,-7253.0f,-6650.0f,-5197.0f,-2852.0f,-65.0f,
    2545.0f,4642.0f,6160.0f,7035.0f,7155.0f,6963.0f,6609.0f,5581.0f,
    3951.0f,2136.0f,-113.0f,-2803.0f,-4988.0f,-6610.0f,-7759.0f,-7871.0f,
    -7229.0f,-6185.0f,-4940.0f,-3663.0f,-2081.0f,-707.0f,273.0f,1879.0f,
    3011.0f,2851.0f,3124.0f,3581.0f,3132.0f,2730.0f,2553.0f,1887.0f,
    1076.0f,489.0f,-73.0f,-362.0f,-217.0f,128.0f,819.0f,1839.0f,
    2810.0f,3084.0f,2441.0f,1622.0f,666.0f,-1149.0f,-3117.0f,-4691.0f,
    -6185.0f,-6972.0f,-6988.0f,-6642.0f,-5711.0f,-4434.0f,-3077.0f,-1559.0f,
    16.0f,1574.0f,2931.0f,4208.0f,5421.0f,6328.0f,6866.0f,6722.0f,
    5903.0f,4746.0f,3284.0f,1726.0f,257.0f,-1117.0f,-2273.0f,-3422.0f,
    -4482.0f,-5390.0f,-6329.0f,-6843.0f,-6811.0f,-6313.0f,-5317.0f,-3920.0f,
    -2129.0f,-282.0f,1558.0f,3469.0f,4923.0f,5830.0f,6641.0f,6987.0f,
    6529.0f,6087.0f,5244.0f,3590.0f,2216.0f,867.0f,-828.0f,-1832.0f,
    -2185.0f,-2490.0f,-2024.0f,-932.0f,0.0f,1019.0f,1790.0f,1823.0f,
    1405.0f,40.0f,-1920.0f,-3671.0f,-5518.0f,-6787.0f,-6803.0f,-6257.0f,
    -5205.0f,-3582.0f,-1992.0f,-402.0f,1108.0f,2562.0f,4079.0f,5445.0f,
    6714.0f,7629.0f,7854.0f,7469.0f,6328.0f,4577.0f,2361.0f,-129.0f,
    -2410.0f,-4329.0f,-5863.0f,-6811.0f,-7381.0f,-7646.0f,-7566.0f,-7140.0f,
    -6209.0f,-4932.0f,-3366.0f,-1326.0f,875.0f,2955.0f,4698.0f,5782.0f,
    6425.0f,7083.0f,7396.0f,6802.0f,5686.0f,4393.0f,2899.0f,1156.0f,
    -643.0f,-2306.0f,-3663.0f,-4345.0f,-3888.0f,-2651.0f,-667.0f,1839.0f,
    3437.0f,4353.0f,4377.0f,2650.0f,771.0f,-820.0f,-2908.0f,-4137.0f,
    -4538.0f,-5373.0f,-5863.0f,-6056.0f,-6209.0f,-5430.0f,-3936.0f,-1703.0f,
    1413.0f,4104.0f,5895.0f,7292.0f,7718.0f,7196.0f,6890.0f,6360.0f,
    5204.0f,3975.0f,2176.0f,-362.0f,-3109.0f,-5695.0f,-7695.0f,-8819.0f,
    -9028.0f,-8482.0f,-7510.0f,-6353.0f,-5012.0f,-3406.0f,-1526.0f,586.0f,
    2931.0f,5115.0f,6834.0f,8015.0f,8416.0f,8103.0f,7172.0f,5822.0f,
    4280.0f,2489.0f,835.0f,-482.0f,-1671.0f,-2233.0f,-1840.0f,-868.0f,
    433.0f,1967.0f,2730.0f,2337.0f,1485.0f,200.0f,-1165.0f,-1976.0f,
    -2482.0f,-3334.0f,-4305.0f,-5325.0f,-6426.0f,-6988.0f,-6506.0f,-5149.0f,
    -3277.0f,-972.0f,1405.0f,3533.0f,5413.0f,7051.0f,8200.0f,8681.0f,
    8601.0f,7782.0f,6095.0f,3814.0f,1044.0f,-1952.0f,-4635.0f,-6779.0f,
    -8257.0f,-8907.0f,-8923.0f,-8441.0f,-7446.0f,-6000.0f,-3920.0f,-1663.0f,
    682.0f,3180.0f,5115.0f,6658.0f,7959.0f,8376.0f,8047.0f,7188.0f,
    5541.0f,3324.0f,1276.0f,-611.0f,-2378.0f,-3550.0f,-4016.0f,-3888.0f,
    -3012.0f,-1141.0f,1204.0f,3067.0f,4385.0f,4947.0f,3991.0f,2570.0f,
    1100.0f,-691.0f,-2057.0f,-3077.0f,-4088.0f,-5036.0f,-6056.0f,-6731.0f,
    -6980.0f,-6530.0f,-4916.0f,-2659.0f,104.0f,2955.0f,5115.0f,6561.0f,
    7284.0f,7445.0f,7228.0f,6433.0f,5268.0f,3461.0f,1108.0f,-1197.0f,
    -3526.0f,-5606.0f,-6835.0f,-7502.0f,-7598.0f,-6964.0f,-5751.0f,-4297.0f,
    -2860.0f,-1213.0f,361.0f,1501.0f,2762.0f,4120.0f,4883.0f,5413.0f,
    5862.0f,5557.0f,4722.0f,3726.0f,2280.0f,730.0f,-587.0f,-1510.0f,
    -1751.0f,-1607.0f,-1253.0f,-209.0f,939.0f,1678.0f,2802.0f,3702.0f,
    3092.0f,2192.0f,875.0f,-1816.0f,-4105.0f,-5558.0f,-7084.0f,-7405.0f,
    -6618.0f,-6008.0f,-4667.0f,-3052.0f,-1808.0f,24.0f,1919.0f,3421.0f,
    5292.0f,6842.0f,7597.0f,8031.0f,7637.0f,6184.0f,4481.0f,2305.0f,
    -233.0f,-2362.0f,-4297.0f,-6153.0f,-7269.0f,-7919.0f,-8209.0f,-7574.0f,
    -6418.0f,-5028.0f,-3060.0f,-1085.0f,690.0f,2794.0f,4353.0f,5156.0f,
    5999.0f,6240.0f,5686.0f,5196.0f,4385.0f,2907.0f,1397.0f,-121.0f,
    -1896.0f,-3165.0f,-3888.0f,-3864.0f,-2362.0f,-258.0f,2192.0f,4850.0f,
    6160.0f,6144.0f,5421.0f,3164.0f,48.0f,-2530.0f,-4859.0f,-6594.0f,
    -7462.0f,-7823.0f,-7976.0f,-8088.0f,-7389.0f,-5992.0f,-4273.0f,-1494.0f,
    1517.0f,3895.0f,5999.0f,7637.0f,8320.0f,8183.0f,7637.0f,6392.0f,
    4577.0f,2409.0f,-378.0f,-3317.0f,-5855.0f,-7911.0f,-9028.0f,-9084.0f,
    -8562.0f,-7381.0f,-5823.0f,-4362.0f,-2659.0f,-707.0f,1044.0f,3011.0f,
    5124.0f,6561.0f,7340.0f,7412.0f,6625.0f,5573.0f,4168.0f,2586.0f,
    1276.0f,-145.0f,-1502.0f,-2241.0f,-2121.0f,-828.0f,1293.0f,3726.0f,
    5822.0f,6200.0f,5316.0f,3710.0f,1188.0f,-828.0f,-2378.0f,-3856.0f,
    -5004.0f,-6305.0f,-7654.0f,-8731.0f,-8851.0f,-7927.0f,-6273.0f,-3502.0f,
    -378.0f,2465.0f,4963.0f,6850.0f,8175.0f,8762.0f,8641.0f,7943.0f,
    6561.0f,4553.0f,1823.0f,-1181.0f,-3984.0f,-6450.0f,-8104.0f,-8835.0f,
    -8827.0f,-8257.0f,-7333.0f,-5887.0f,-4185.0f,-2233.0f,112.0f,2409.0f,
    4369.0f,6007.0f,7115.0f,7589.0f,7669.0f,7011.0f,5886.0f,4561.0f,
    2714.0f,1148.0f,-258.0f,-1856.0f,-2619.0f,-2386.0f,-1518.0f,224.0f,
    2610.0f,4537.0f,4995.0f,4577.0f,3349.0f,690.0f,-1615.0f,-2787.0f,
    -4281.0f,-5382.0f,-5639.0f,-6506.0f,-7518.0f,-7646.0f,-7164.0f,-5968.0f,
    -3807.0f,-884.0f,2208.0f,4618.0f,6320.0f,7549.0f,7589.0f,7035.0f,
    6842.0f,5991.0f,4409.0f,2835.0f,706.0f,-1896.0f,-4056.0f,-5671.0f,
    -6875.0f,-7397.0f,-7156.0f,-6514.0f,-5639.0f,-4546.0f,-3317.0f,-1992.0f,
    -707.0f,971.0f,2802.0f,4465.0f,5830.0f,6513.0f,6392.0f,5621.0f,
    4385.0f,2899.0f,1517.0f,136.0f,-1101.0f,-1727.0f,-1920.0f,-1719.0f,
    -651.0f,923.0f,2288.0f,3461.0f,4344.0f,4208.0f,3019.0f,1453.0f,
    -659.0f,-3165.0f,-4948.0f,-6088.0f,-7100.0f,-7317.0f,-6867.0f,-6538.0f,
    -5855.0f,-4442.0f,-2715.0f,-563.0f,1991.0f,4465.0f,6577.0f,8167.0f,
    9011.0f,8971.0f,8007.0f,6360.0f,4272.0f,1702.0f,-988.0f,-3430.0f,
    -5711.0f,-7438.0f,-8369.0f,-8634.0f,-8000.0f,-6691.0f,-5084.0f,-3036.0f,
    -916.0f,754.0f,2618.0f,4336.0f,5083.0f,5766.0f,6143.0f,5413.0f,
    4401.0f,3493.0f,2136.0f,481.0f,-932.0f,-2322.0f,-3430.0f,-3663.0f,
    -2996.0f,-1318.0f,1108.0f,3598.0f,5646.0f,6746.0f,6449.0f,5011.0f,
    2690.0f,-97.0f,-2747.0f,-4851.0f,-6169.0f,-7197.0f,-7614.0f,-7847.0f,
    -8000.0f,-7100.0f,-5711.0f,-3671.0f,-466.0f,2722.0f,5348.0f,7565.0f,
    8609.0f,8505.0f,8191.0f,7212.0f,5734.0f,4208.0f,2007.0f,-755.0f,
    -3325.0f,-5711.0f,-7606.0f,-8490.0f,-8530.0f,-8016.0f,-6883.0f,-5558.0f,
    -4329.0f,-2691.0f,-940.0f,771.0f,2899.0f,4698.0f,5991.0f,6995.0f,
    7019.0f,6489.0f,5814.0f,4385.0f,2682.0f,1019.0f,-691.0f,-1791.0f,
    -1920.0f,-1197.0f,481.0f,2586.0f,4553.0f,5766.0f,5597.0f,4385.0f,
    2313.0f,-57.0f,-1783.0f,-3052.0f,-4161.0f,-5341.0f,-6771.0f,-8160.0f,
    -8923.0f,-8642.0f,-7454.0f,-5261.0f,-2402.0f,168.0f,2714.0f,4891.0f,
    6368.0f,7613.0f,8208.0f,8208.0f,7589.0f,6168.0f,4176.0f,1558.0f,
    -1149.0f,-3719.0f,-6032.0f,-7542.0f,-8353.0f,-8658.0f,-8450.0f,-7719.0f,
    -6594.0f,-4980.0f,-2811.0f,-458.0f,2007.0f,4449.0f,6320.0f,7629.0f,
    8360.0f,8256.0f,7613.0f,6441.0f,4714.0f,2931.0f,1100.0f,-595.0f,
    -2000.0f,-2844.0f,-2828.0f,-2137.0f,-820.0f,979.0f,2296.0f,2553.0f,
    2441.0f,1895.0f,473.0f,-362.0f,-426.0f,-1326.0f,-2265.0f,-2900.0f,
    -4570.0f,-6265.0f,-6691.0f,-6506.0f,-5687.0f,-3888.0f,-1775.0f,216.0f,
    1710.0f,2963.0f,4312.0f,5091.0f,5493.0f,6184.0f,6272.0f,5107.0f,
    3630.0f,2007.0f,-370.0f,-2490.0f,-3719.0f,-4916.0f,-5839.0f,-6209.0f,
    -6434.0f,-6418.0f,-6056.0f,-4980.0f,-3366.0f,-1583.0f,393.0f,2417.0f,
    3903.0f,4850.0f,5694.0f,5895.0f,5429.0f,4858.0f,3967.0f,2537.0f,
    1092.0f,-217.0f,-1181.0f,-1679.0f,-1671.0f,-723.0f,497.0f,1268.0f,
    1991.0f,2473.0f,1871.0f,1011.0f,642.0f,-129.0f,-852.0f,-932.0f,
    -1551.0f,-2579.0f,-3470.0f,-4386.0f,-5181.0f,-5590.0f,-5060.0f,-3751.0f,
    -2354.0f,-523.0f,1469.0f,2810.0f,3806.0f,4850.0f,5549.0f,5878.0f,
    6063.0f,5525.0f,4176.0f,2489.0f,337.0f,-1800.0f,-3550.0f,-5149.0f,
    -6185.0f,-6602.0f,-6675.0f,-6201.0f,-5277.0f,-4257.0f,-2892.0f,-1189.0f,
    698.0f,2682.0f,4200.0f,5156.0f,5638.0f,5509.0f,4858.0f,4168.0f,
    3525.0f,2465.0f,1172.0f,-193.0f,-1406.0f,-2065.0f,-2161.0f,-1390.0f,
    120.0f,1807.0f,3212.0f,4457.0f,5075.0f,4425.0f,3196.0f,1405.0f,
    -1157.0f,-3566.0f,-5365.0f,-6867.0f,-7727.0f,-7735.0f,-7389.0f,-6699.0f,
    -5341.0f,-3422.0f,-1245.0f,1148.0f,3670.0f,6143.0f,8007.0f,9067.0f,
    9444.0f,8802.0f,7276.0f,5196.0f,2626.0f,-65.0f,-2828.0f,-5373.0f,
    -7494.0f,-8923.0f,-9325.0f,-8891.0f,-7735.0f,-6064.0f,-4105.0f,-1952.0f,
    425.0f,2586.0f,4128.0f,5348.0f,6264.0f,6915.0f,6866.0f,6264.0f,
    5782.0f,4481.0f,2393.0f,650.0f,-868.0f,-2289.0f,-3052.0f,-2603.0f,
    -1205.0f,489.0f,2586.0f,4706.0f,5846.0f,5694.0f,4810.0f,2875.0f,
    128.0f,-1864.0f,-3727.0f,-5647.0f,-6699.0f,-7646.0f,-8313.0f,-8337.0f,
    -7751.0f,-6402.0f,-4602.0f,-1928.0f,1397.0f,4224.0f,6176.0f,7661.0f,
    8352.0f,7886.0f,7083.0f,5967.0f,4095.0f,1847.0f,-852.0f,-3735.0f,
    -6329.0f,-8369.0f,-9196.0f,-8707.0f,-7606.0f,-6120.0f,-3968.0f,-1888.0f,
    -177.0f,1582.0f,3260.0f,4561.0f,5678.0f,6497.0f,6641.0f,6376.0f,
    5565.0f,4015.0f,2650.0f,1156.0f,-916.0f,-2490.0f,-3470.0f,-3984.0f,
    -3285.0f,-1462.0f,939.0f,3381.0f,5292.0f,6143.0f,5629.0f,4200.0f,
    2240.0f,497.0f,-699.0f,-1912.0f,-3591.0f,-5502.0f,-6988.0f,-8393.0f,
    -9060.0f,-8064.0f,-6369.0f,-4161.0f,-1358.0f,1108.0f,3043.0f,4867.0f,
    6433.0f,7445.0f,7934.0f,7846.0f,7155.0f,5621.0f,3156.0f,337.0f,
    -2338.0f,-4803.0f,-6482.0f,-7197.0f,-7606.0f,-7574.0f,-7156.0f,-6490.0f,
    -4996.0f,-3093.0f,-1406.0f,409.0f,2586.0f,4473.0f,5774.0f,6826.0f,
    7115.0f,6449.0f,5252.0f,3606.0f,1919.0f,232.0f,-1478.0f,-2803.0f,
    -3558.0f,-3631.0f,-2860.0f,-1374.0f,690.0f,2602.0f,3172.0f,3204.0f,
    2995.0f,1879.0f,1301.0f,971.0f,-611.0f,-2273.0f,-3382.0f,-4868.0f,
    -6426.0f,-6755.0f,-6313.0f,-5269.0f,-3446.0f,-1711.0f,289.0f,1919.0f,
    3100.0f,4529.0f,5477.0f,6039.0f,6304.0f,5686.0f,4361.0f,2401.0f,
    -298.0f,-2988.0f,-4707.0f,-5839.0f,-6538.0f,-6578.0f,-6426.0f,-5936.0f,
    -5213.0f,-4209.0f,-2675.0f,-868.0f,955.0f,2859.0f,4457.0f,5276.0f,
    5726.0f,5670.0f,5003.0f,4385.0f,3324.0f,1807.0f,658.0f,-298.0f,
    -1061.0f,-1101.0f,-386.0f,497.0f,1742.0f,3445.0f,3879.0f,3284.0f,
    2602.0f,1212.0f,-747.0f,-2402.0f,-3655.0f,-4908.0f,-5920.0f,-6353.0f,
    -6506.0f,-6434.0f,-5847.0f,-4490.0f,-2659.0f,-659.0f,1566.0f,3590.0f,
    5316.0f,6762.0f,7565.0f,7782.0f,7541.0f,6529.0f,4794.0f,2674.0f,
    -89.0f,-3085.0f,-5598.0f,-7542.0f,-8586.0f,-8931.0f,-8498.0f,-7430.0f,
    -6064.0f,-4153.0f,-1808.0f,730.0f,3108.0f,5340.0f,7115.0f,7822.0f,
    8047.0f,7541.0f,6489.0f,5646.0f,4224.0f,2465.0f,787.0f,-1189.0f,
    -3157.0f,-4506.0f,-4908.0f,-4450.0f,-2916.0f,-820.0f,1132.0f,2955.0f,
    3750.0f,3421.0f,3011.0f,2031.0f,248.0f,-1077.0f,-1944.0f,-3245.0f,
    -4281.0f,-4819.0f,-5582.0f,-5944.0f,-5422.0f,-4265.0f,-2506.0f,-338.0f,
    1935.0f,3855.0f,5268.0f,6232.0f,6682.0f,6593.0f,6063.0f,5364.0f,
    4208.0f,2545.0f,626.0f,-1848.0f,-4145.0f,-5871.0f,-7325.0f,-7984.0f,
    -8048.0f,-7462.0f,-6016.0f,-4321.0f,-2209.0f,401.0f,2802.0f,4690.0f,
    6425.0f,7332.0f,7099.0f,6818.0f,6071.0f,4939.0f,3638.0f,1630.0f,
    -466.0f,-2434.0f,-4249.0f,-5076.0f,-4362.0f,-2619.0f,-314.0f,2610.0f,
    4505.0f,4883.0f,5276.0f,4529.0f,2923.0f,2248.0f,1276.0f,-788.0f,
    -2771.0f,-5044.0f,-7727.0f,-9325.0f,-9397.0f,-8795.0f,-7293.0f,-4763.0f,
    -2193.0f,168.0f,2385.0f,4706.0f,6754.0f,8264.0f,9091.0f,8898.0f,
    7902.0f,6047.0f,3742.0f,1003.0f,-1896.0f,-4362.0f,-6618.0f,-8016.0f,
    -8755.0f,-9012.0f,-8217.0f,-6932.0f,-5084.0f,-2538.0f,56.0f,2545.0f,
    4947.0f,6497.0f,7188.0f,7677.0f,7710.0f,7212.0f,6376.0f,4867.0f,
    2859.0f,867.0f,-1334.0f,-3101.0f,-4096.0f,-4418.0f,-3213.0f,-1012.0f,
    1260.0f,3726.0f,5107.0f,4537.0f,3742.0f,2618.0f,955.0f,473.0f,
    -89.0f,-2161.0f,-4370.0f,-6297.0f,-8441.0f,-9397.0f,-8466.0f,-7229.0f,
    -5197.0f,-2137.0f,449.0f,2883.0f,5356.0f,6987.0f,7822.0f,8344.0f,
    7854.0f,6666.0f,5140.0f,2891.0f,248.0f,-2458.0f,-5044.0f,-6907.0f,
    -8008.0f,-8755.0f,-8875.0f,-8184.0f,-7164.0f,-5590.0f,-3309.0f,-796.0f,
    1646.0f,4079.0f,6119.0f,7461.0f,8256.0f,8224.0f,7493.0f,6087.0f,
    4224.0f,2433.0f,457.0f,-1551.0f,-3165.0f,-4474.0f,-5125.0f,-4233.0f,
    -2627.0f,-860.0f,1622.0f,3333.0f,3694.0f,4039.0f,3180.0f,1333.0f,
    682.0f,-137.0f,-1430.0f,-1808.0f,-2546.0f,-4032.0f,-5181.0f,-6040.0f,
    -6570.0f,-6088.0f,-4522.0f,-2314.0f,377.0f,2313.0f,3782.0f,5188.0f,
    5332.0f,5236.0f,5188.0f,4096.0f,2690.0f,1220.0f,-812.0f,-2723.0f,
    -4153.0f,-5269.0f,-5839.0f,-5896.0f,-5671.0f,-5108.0f,-4321.0f,-3446.0f,
    -2145.0f,-659.0f,666.0f,2112.0f,3204.0f,3935.0f,4786.0f,5156.0f,
    5188.0f,4794.0f,3871.0f,2955.0f,1662.0f,192.0f,-1037.0f,-2089.0f,
    -2338.0f,-2000.0f,-1029.0f,546.0f,1991.0f,2955.0f,3389.0f,3349.0f,
    2513.0f,1293.0f,152.0f,-1366.0f,-2948.0f,-4105.0f,-5068.0f,-5687.0f,
    -5855.0f,-5687.0f,-5285.0f,-4418.0f,-3117.0f,-1518.0f,473.0f,2594.0f,
    4521.0f,6039.0f,7067.0f,7461.0f,7027.0f,5870.0f,4079.0f,1871.0f,
    -450.0f,-2747.0f,-4739.0f,-6385.0f,-7582.0f,-8008.0f,-7622.0f,-6594.0f,
    -4940.0f,-2828.0f,-595.0f,1590.0f,3549.0f,4923.0f,5316.0f,5878.0f,
    6352.0f,5646.0f,5124.0f,4577.0f,3092.0f,1373.0f,-418.0f,-2442.0f,
    -4169.0f,-5028.0f,-4900.0f,-3470.0f,-924.0f,1815.0f,4433.0f,6184.0f,
    6457.0f,5782.0f,3959.0f,1325.0f,-876.0f,-2956.0f,-4691.0f,-5430.0f,
    -6064.0f,-6907.0f,-7446.0f,-7349.0f,-6699.0f,-5333.0f,-2876.0f,265.0f,
    3212.0f,5621.0f,7573.0f,8232.0f,7645.0f,6778.0f,5621.0f,4095.0f,
    2497.0f,698.0f,-1695.0f,-4000.0f,-5968.0f,-7614.0f,-8217.0f,-8008.0f,
    -6835.0f,-5068.0f,-3438.0f,-1510.0f,353.0f,1871.0f,3333.0f,4690.0f,
    5533.0f,5734.0f,5742.0f,5236.0f,4288.0f,3316.0f,2015.0f,626.0f,
    -707.0f,-1800.0f,-2346.0f,-2057.0f,-627.0f,1437.0f,3702.0f,5662.0f,
    6256.0f,5694.0f,4264.0f,2152.0f,650.0f,-691.0f,-2362.0f,-3607.0f,
    -5398.0f,-7558.0f,-8763.0f,-9172.0f,-8715.0f,-7245.0f,-4884.0f,-2346.0f,
    56.0f,2634.0f,4698.0f,6192.0f,7734.0f,8384.0f,8192.0f,7557.0f,
    6015.0f,3758.0f,1381.0f,-1012.0f,-3334.0f,-5020.0f,-6225.0f,-7229.0f,
    -7703.0f,-7855.0f,-7614.0f,-6514.0f,-4924.0f,-2820.0f,-217.0f,2280.0f,
    4433.0f,6152.0f,7252.0f,7541.0f,7356.0f,6834.0f,5686.0f,4288.0f,
    2738.0f,923.0f,-595.0f,-1133.0f,-972.0f,-426.0f,971.0f,1991.0f,
    1429.0f,658.0f,-137.0f,-1896.0f,-2683.0f,-2233.0f,-2868.0f,-3470.0f,
    -3767.0f,-5092.0f,-5928.0f,-5711.0f,-5060.0f,-3647.0f,-2097.0f,-884.0f,
    497.0f,1670.0f,3172.0f,5083.0f,6360.0f,7276.0f,7862.0f,7188.0f,
    5726.0f,4128.0f,1413.0f,-1543.0f,-3823.0f,-5815.0f,-7181.0f,-7735.0f,
    -8048.0f,-8176.0f,-7687.0f,-6659.0f,-5044.0f,-2908.0f,-739.0f,1445.0f,
    3718.0f,5605.0f,7196.0f,8497.0f,8810.0f,8175.0f,6818.0f,4738.0f,
    2642.0f,706.0f,-1647.0f,-3510.0f,-4594.0f,-5470.0f,-5197.0f,-3582.0f,
    -2016.0f,-563.0f,1373.0f,2280.0f,2537.0f,3003.0f,2778.0f,2465.0f,
    1887.0f,449.0f,-1350.0f,-3068.0f,-4570.0f,-5213.0f,-5012.0f,-4490.0f,
    -3004.0f,-1382.0f,-362.0f,955.0f,1790.0f,2023.0f,3067.0f,4208.0f,
    4537.0f,4778.0f,4513.0f,2971.0f,1188.0f,-595.0f,-2755.0f,-4297.0f,
    -5317.0f,-6064.0f,-6056.0f,-5791.0f,-5116.0f,-3799.0f,-2081.0f,-97.0f,
    2240.0f,4176.0f,5453.0f,6256.0f,5911.0f,5212.0f,4521.0f,3124.0f,
    1646.0f,216.0f,-1783.0f,-3342.0f,-3984.0f,-4297.0f,-3550.0f,-1992.0f,
    -723.0f,1276.0f,3525.0f,4818.0f,6143.0f,7003.0f,6915.0f,6280.0f,
    4987.0f,3059.0f,385.0f,-2209.0f,-4715.0f,-7068.0f,-8361.0f,-9245.0f,
    -9405.0f,-8530.0f,-7317.0f,-5454.0f,-2972.0f,-41.0f,2907.0f,5662.0f,
    7943.0f,9115.0f,9485.0f,9099.0f,7878.0f,6160.0f,4023.0f,1533.0f,
    -956.0f,-3285.0f,-5534.0f,-7269.0f,-8184.0f,-8297.0f,-7807.0f,-6667.0f,
    -5004.0f,-3518.0f,-1872.0f,40.0f,1309.0f,2353.0f,3622.0f,4505.0f,
    4915.0f,5220.0f,5597.0f,4802.0f,3268.0f,2497.0f,1188.0f,-57.0f,
    281.0f,1196.0f,2618.0f,4585.0f,6232.0f,6433.0f,5670.0f,4585.0f,
    2537.0f,345.0f,-1960.0f,-4241.0f,-6193.0f,-7968.0f,-9188.0f,-9839.0f,
    -9622.0f,-8586.0f,-7116.0f,-5141.0f,-2667.0f,96.0f,3124.0f,5533.0f,
    7437.0f,8794.0f,9019.0f,8497.0f,7493.0f,5935.0f,3967.0f,1935.0f,
    -563.0f,-3301.0f,-5896.0f,-8152.0f,-9277.0f,-9678.0f,-9494.0f,-8345.0f,
    -7012.0f,-5502.0f,-3510.0f,-1398.0f,867.0f,3284.0f,5381.0f,7244.0f,
    8408.0f,8577.0f,8529.0f,7894.0f,6208.0f,4377.0f,2473.0f,714.0f,
    -571.0f,-908.0f,-233.0f,762.0f,2096.0f,3196.0f,3148.0f,2128.0f,
    401.0f,-1912.0f,-3687.0f,-4956.0f,-5655.0f,-6072.0f,-7036.0f,-7839.0f,
    -8016.0f,-7719.0f,-6506.0f,-4643.0f,-2659.0f,-249.0f,2048.0f,4272.0f,
    5983.0f,6939.0f,7894.0f,7702.0f,6834.0f,6007.0f,4144.0f,2256.0f,
    192.0f,-2603.0f,-5068.0f,-7197.0f,-8787.0f,-9156.0f,-8851.0f,-7863.0f,
    -6474.0f,-5028.0f,-3052.0f,-1125.0f,1084.0f,3614.0f,5822.0f,7501.0f,
    8946.0f,9420.0f,8786.0f,7782.0f,6087.0f,4071.0f,1847.0f,-346.0f,
    -2209.0f,-3767.0f,-4362.0f,-4048.0f,-3181.0f,-1671.0f,-643.0f,-988.0f,
    -916.0f,-1245.0f,-2587.0f,-2434.0f,-1928.0f,-2530.0f,-2635.0f,-3117.0f,
    -4619.0f,-5309.0f,-5084.0f,-4113.0f,-2177.0f,168.0f,2256.0f,4353.0f,
    5742.0f,6433.0f,7404.0f,7260.0f,6473.0f,5694.0f,4007.0f,1790.0f,
    -515.0f,-3229.0f,-5695.0f,-7662.0f,-8819.0f,-8739.0f,-8321.0f,-7389.0f,
    -5863.0f,-4386.0f,-2458.0f,-89.0f,2369.0f,4650.0f,6481.0f,8256.0f,
    8938.0f,8577.0f,8304.0f,7252.0f,5573.0f,3750.0f,1469.0f,-1109.0f,
    -3462.0f,-5141.0f,-5879.0f,-5727.0f,-4892.0f,-3077.0f,-1229.0f,-73.0f,
    1341.0f,1943.0f,1389.0f,1140.0f,939.0f,441.0f,369.0f,96.0f,
    -852.0f,-1864.0f,-3004.0f,-4064.0f,-4442.0f,-3960.0f,-2643.0f,-587.0f,
    1301.0f,2867.0f,4288.0f,4875.0f,5011.0f,5292.0f,5003.0f,4047.0f,
    2979.0f,1301.0f,-988.0f,-3350.0f,-5598.0f,-7237.0f,-8048.0f,-7911.0f,
    -6803.0f,-5125.0f,-3173.0f,-1221.0f,1019.0f,3413.0f,5075.0f,6529.0f,
    7653.0f,7581.0f,6730.0f,5525.0f,3967.0f,2112.0f,530.0f,-924.0f,
    -2498.0f,-3759.0f,-4884.0f,-5695.0f,-5622.0f,-4827.0f,-3542.0f,-1502.0f,
    939.0f,2979.0f,4810.0f,6176.0f,6328.0f,5766.0f,4754.0f,3076.0f,
    1100.0f,-884.0f,-2884.0f,-4683.0f,-6104.0f,-7004.0f,-7156.0f,-6739.0f,
    -5936.0f,-4370.0f,-2322.0f,-233.0f,2104.0f,4409.0f,6023.0f,7019.0f,
    7364.0f,6762.0f,5348.0f,3549.0f,1533.0f,-683.0f,-2595.0f,-3856.0f,
    -4843.0f,-5357.0f,-5012.0f,-4442.0f,-3944.0f,-3004.0f,-1800.0f,-844.0f,
    176.0f,1397.0f,2513.0f,3300.0f,3871.0f,4272.0f,4256.0f,3766.0f,
    2939.0f,1847.0f,385.0f,-1286.0f,-2659.0f,-3398.0f,-3133.0f,-1695.0f,
    530.0f,3043.0f,5027.0f,5959.0f,6111.0f,5389.0f,3838.0f,2385.0f,
    1212.0f,-354.0f,-2161.0f,-4096.0f,-6281.0f,-8233.0f,-9229.0f,-9044.0f,
    -8225.0f,-6586.0f,-4209.0f,-2137.0f,-362.0f,1533.0f,3525.0f,5284.0f,
    6746.0f,8047.0f,8497.0f,7822.0f,6770.0f,5075.0f,2786.0f,706.0f,
    -1093.0f,-3036.0f,-4964.0f,-6177.0f,-7189.0f,-7984.0f,-7887.0f,-6907.0f,
    -5550.0f,-3695.0f,-1213.0f,1003.0f,3019.0f,4706.0f,5718.0f,6409.0f,
    6577.0f,6063.0f,5132.0f,3871.0f,2152.0f,738.0f,-209.0f,-683.0f,
    64.0f,1140.0f,2248.0f,3662.0f,3879.0f,2995.0f,1839.0f,192.0f,
    -1318.0f,-2065.0f,-2554.0f,-3591.0f,-5044.0f,-6418.0f,-7606.0f,-8241.0f,
    -7678.0f,-6289.0f,-4498.0f,-2683.0f,-1165.0f,554.0f,2048.0f,3790.0f,
    5886.0f,7493.0f,8569.0f,8794.0f,8079.0f,6834.0f,5075.0f,3108.0f,
    819.0f,-1751.0f,-3848.0f,-6000.0f,-7927.0f,-8610.0f,-8707.0f,-8249.0f,
    -6956.0f,-5277.0f,-3325.0f,-1261.0f,811.0f,2963.0f,4995.0f,6457.0f,
    7380.0f,7621.0f,7115.0f,6095.0f,4714.0f,3228.0f,1742.0f,457.0f,
    -563.0f,-1133.0f,-1446.0f,-1607.0f,-1374.0f,-1848.0f,-2322.0f,-2346.0f,
    -2916.0f,-2755.0f,-1968.0f,-1687.0f,-1374.0f,-1534.0f,-2241.0f,-3101.0f,
    -4032.0f,-4097.0f,-3751.0f,-3510.0f,-2530.0f,-1438.0f,-820.0f,120.0f,
    1903.0f,3774.0f,5172.0f,6641.0f,7429.0f,6890.0f,5895.0f,4312.0f,
    1999.0f,-394.0f,-2579.0f,-4619.0f,-6329.0f,-7245.0f,-7542.0f,-7719.0f,
    -7164.0f,-5783.0f,-4185.0f,-2306.0f,-241.0f,1726.0f,3220.0f,4200.0f,
    5397.0f,5830.0f,5469.0f,5276.0f,5188.0f,4698.0f,3469.0f,2039.0f,
    417.0f,-1261.0f,-2362.0f,-2924.0f,-2820.0f,-1767.0f,-739.0f,-161.0f,
    714.0f,1028.0f,265.0f,72.0f,8.0f,-956.0f,-1743.0f,-2514.0f,
    -3872.0f,-5261.0f,-6193.0f,-6177.0f,-5534.0f,-4426.0f,-2225.0f,457.0f,
    2714.0f,4601.0f,6593.0f,7348.0f,6866.0f,6955.0f,6328.0f,4834.0f,
    3501.0f,1598.0f,-796.0f,-2731.0f,-4562.0f,-6032.0f,-6683.0f,-7221.0f,
    -7285.0f,-6554.0f,-5558.0f,-4281.0f,-2394.0f,-362.0f,1525.0f,3790.0f,
    5846.0f,7228.0f,8135.0f,8352.0f,7814.0f,6601.0f,5115.0f,3324.0f,
    1164.0f,-860.0f,-2506.0f,-3775.0f,-4482.0f,-4097.0f,-2916.0f,-1350.0f,
    570.0f,2240.0f,3533.0f,3943.0f,2987.0f,1525.0f,8.0f,-1631.0f,
    -2988.0f,-4209.0f,-5301.0f,-5912.0f,-5968.0f,-5566.0f,-4619.0f,-3036.0f,
    -1004.0f,1509.0f,3734.0f,5300.0f,6666.0f,7075.0f,6698.0f,6200.0f,
    5445.0f,4296.0f,2843.0f,1100.0f,-1069.0f,-3253.0f,-5406.0f,-7229.0f,
    -8176.0f,-8530.0f,-8273.0f,-7189.0f,-5647.0f,-3848.0f,-1567.0f,851.0f,
    3084.0f,5340.0f,6987.0f,7951.0f,8216.0f,7437.0f,6192.0f,4377.0f,
    2337.0f,514.0f,-1567.0f,-3325.0f,-3984.0f,-3727.0f,-2418.0f,-97.0f,
    2505.0f,4658.0f,5613.0f,5517.0f,4545.0f,2891.0f,1116.0f,-386.0f,
    -1735.0f,-3486.0f,-5277.0f,-6924.0f,-8040.0f,-7944.0f,-7084.0f,-5373.0f,
    -2763.0f,32.0f,2015.0f,3156.0f,4449.0f,5188.0f,6047.0f,7252.0f,
    7260.0f,6505.0f,5429.0f,3654.0f,1646.0f,-555.0f,-3052.0f,-5229.0f,
    -6859.0f,-7807.0f,-8160.0f,-7935.0f,-7213.0f,-5984.0f,-4378.0f,-2394.0f,
    -1.0f,2441.0f,4738.0f,6449.0f,7637.0f,8127.0f,7959.0f,7284.0f,
    6111.0f,4473.0f,2409.0f,313.0f,-1446.0f,-2795.0f,-3438.0f,-2787.0f,
    -1149.0f,762.0f,2851.0f,4055.0f,3525.0f,2160.0f,433.0f,-1382.0f,
    -2611.0f,-2868.0f,-3157.0f,-4297.0f,-5092.0f,-5647.0f,-6305.0f,-5606.0f,
    -3655.0f,-1783.0f,56.0f,1606.0f,3019.0f,3590.0f,3766.0f,4794.0f,
    5557.0f,6160.0f,6585.0f,6184.0f,4923.0f,2995.0f,947.0f,-1294.0f,
    -3542.0f,-5622.0f,-7116.0f,-7984.0f,-8538.0f,-8120.0f,-7148.0f,-5896.0f,
    -3984.0f,-1880.0f,449.0f,2963.0f,5003.0f,6754.0f,7686.0f,7445.0f,
    7147.0f,6449.0f,4931.0f,3557.0f,2128.0f,112.0f,-1534.0f,-2707.0f,
    -3141.0f,-2579.0f,-1639.0f,-49.0f,1646.0f,1807.0f,1164.0f,586.0f,
    -1181.0f,-2554.0f,-2482.0f,-2394.0f,-1856.0f,-1526.0f,-2225.0f,-2972.0f,
    -3751.0f,-4329.0f,-4000.0f,-2731.0f,-1374.0f,-153.0f,1317.0f,2353.0f,
    3092.0f,4304.0f,5180.0f,5943.0f,6738.0f,6192.0f,5164.0f,3967.0f,
    1622.0f,-972.0f,-3446.0f,-5727.0f,-7253.0f,-7871.0f,-7703.0f,-7100.0f,
    -6008.0f,-4562.0f,-2868.0f,-715.0f,1485.0f,3549.0f,5228.0f,6111.0f,
    6441.0f,6216.0f,5300.0f,4545.0f,3847.0f,2650.0f,1485.0f,281.0f,
    -900.0f,-2049.0f,-2643.0f,-2241.0f,-1816.0f,-932.0f,385.0f,819.0f,
    1060.0f,1276.0f,714.0f,401.0f,602.0f,425.0f,-73.0f,-161.0f,
    -274.0f,-1832.0f,-3550.0f,-4370.0f,-5735.0f,-6731.0f,-6032.0f,-4843.0f,
    -3502.0f,-1149.0f,1252.0f,3300.0f,5413.0f,6746.0f,7396.0f,7477.0f,
    6513.0f,5172.0f,3501.0f,1011.0f,-1543.0f,-3663.0f,-5871.0f,-7462.0f,
    -7582.0f,-7446.0f,-6779.0f,-5293.0f,-3856.0f,-2121.0f,-442.0f,1228.0f,
    3116.0f,4449.0f,5324.0f,6119.0f,6184.0f,5421.0f,4634.0f,4023.0f,
    2827.0f,1148.0f,-49.0f,-1390.0f,-2932.0f,-3566.0f,-3582.0f,-3093.0f,
    -2105.0f,-972.0f,433.0f,1887.0f,3164.0f,3927.0f,3847.0f,3485.0f,
    2931.0f,1373.0f,-659.0f,-2362.0f,-4458.0f,-6827.0f,-8120.0f,-8128.0f,
    -7783.0f,-6747.0f,-4675.0f,-2386.0f,144.0f,2674.0f,4698.0f,6633.0f,
    7766.0f,7766.0f,7292.0f,6152.0f,4361.0f,2240.0f,-241.0f,-2908.0f,
    -5060.0f,-6755.0f,-7895.0f,-8112.0f,-7670.0f,-6899.0f,-6040.0f,-4498.0f,
    -2450.0f,-635.0f,1293.0f,3573.0f,5509.0f,6376.0f,6794.0f,7308.0f,
    6842.0f,5477.0f,4296.0f,2754.0f,433.0f,-1647.0f,-3438.0f,-4924.0f,
    -5189.0f,-4394.0f,-2884.0f,-587.0f,1774.0f,3357.0f,4047.0f,4200.0f,
    4618.0f,4320.0f,3124.0f,2449.0f,554.0f,-2579.0f,-5100.0f,-7164.0f,
    -8369.0f,-8506.0f,-7542.0f,-5984.0f,-4225.0f,-2354.0f,-563.0f,1670.0f,
    4007.0f,5509.0f,6489.0f,7115.0f,7011.0f,6280.0f,4810.0f,2907.0f,
    979.0f,-940.0f,-2956.0f,-4819.0f,-6104.0f,-7245.0f,-8104.0f,-8192.0f,
    -7478.0f,-6450.0f,-5004.0f,-2996.0f,-916.0f,1317.0f,3308.0f,5124.0f,
    6714.0f,7252.0f,7340.0f,7099.0f,6007.0f,4248.0f,2216.0f,112.0f,
    -1912.0f,-2980.0f,-2763.0f,-2233.0f,-940.0f,762.0f,1164.0f,971.0f,
    1405.0f,1879.0f,1469.0f,1301.0f,1140.0f,-972.0f,-3623.0f,-5438.0f,
    -7036.0f,-7895.0f,-7060.0f,-5598.0f,-4153.0f,-2297.0f,-434.0f,1445.0f,
    3437.0f,5525.0f,7404.0f,8449.0f,8577.0f,8055.0f,6826.0f,5043.0f,
    3220.0f,1437.0f,-490.0f,-2659.0f,-4410.0f,-5855.0f,-7333.0f,-8201.0f,
    -8112.0f,-7454.0f,-6490.0f,-4803.0f,-2876.0f,-940.0f,1212.0f,3236.0f,
    5332.0f,6955.0f,7669.0f,8143.0f,7830.0f,6609.0f,4971.0f,2827.0f,
    353.0f,-1743.0f,-2755.0f,-3157.0f,-2707.0f,-980.0f,72.0f,497.0f,
    1317.0f,1614.0f,1782.0f,2080.0f,2015.0f,1397.0f,-314.0f,-2771.0f,
    -4948.0f,-6859.0f,-7887.0f,-7229.0f,-5992.0f,-4177.0f,-1767.0f,-193.0f,
    891.0f,2369.0f,3847.0f,5051.0f,6569.0f,7790.0f,7710.0f,6898.0f,
    5862.0f,4184.0f,2168.0f,232.0f,-1703.0f,-3229.0f,-4819.0f,-6329.0f,
    -7421.0f,-8217.0f,-8353.0f,-7510.0f,-6096.0f,-4522.0f,-2281.0f,40.0f,
    1983.0f,3959.0f,5710.0f,6641.0f,7372.0f,7726.0f,7188.0f,5983.0f,
    4031.0f,1702.0f,-442.0f,-2177.0f,-2868.0f,-2386.0f,-1221.0f,505.0f,
    2128.0f,2947.0f,3059.0f,2995.0f,2176.0f,706.0f,-314.0f,-1462.0f,
    -3237.0f,-4811.0f,-6225.0f,-7863.0f,-8313.0f,-7454.0f,-6313.0f,-4474.0f,
    -2081.0f,104.0f,2353.0f,4593.0f,5991.0f,6842.0f,7509.0f,7404.0f,
    7035.0f,6248.0f,4842.0f,3228.0f,1140.0f,-1069.0f,-3173.0f,-5221.0f,
    -6827.0f,-7735.0f,-8385.0f,-8506.0f,-7863.0f,-6964.0f,-5526.0f,-3647.0f,
    -1719.0f,481.0f,2690.0f,4915.0f,6939.0f,7886.0f,8320.0f,8208.0f,
    7131.0f,5694.0f,3822.0f,1485.0f,-804.0f,-2900.0f,-4281.0f,-4562.0f,
    -4064.0f,-2579.0f,-378.0f,1228.0f,2505.0f,4023.0f,4120.0f,3035.0f,
    2240.0f,803.0f,-1414.0f,-3181.0f,-4562.0f,-6104.0f,-6996.0f,-7156.0f,
    -7020.0f,-5968.0f,-4586.0f,-3253.0f,-1197.0f,1003.0f,2851.0f,4842.0f,
    6489.0f,7147.0f,7525.0f,7493.0f,6465.0f,5397.0f,4095.0f,2208.0f,
    337.0f,-1848.0f,-4040.0f,-5960.0f,-7654.0f,-8594.0f,-8923.0f,-8763.0f,
    -7847.0f,-6321.0f,-4611.0f,-2530.0f,-290.0f,1967.0f,4232.0f,5911.0f,
    7147.0f,7629.0f,7236.0f,6232.0f,4449.0f,2570.0f,714.0f,-1221.0f,
    -2884.0f,-3775.0f,-3526.0f,-2563.0f,-619.0f,1887.0f,3244.0f,4031.0f,
    4762.0f,3967.0f,2553.0f,1879.0f,963.0f,-844.0f,-2691.0f,-4321.0f,
    -6626.0f,-8401.0f,-8506.0f,-7919.0f,-6899.0f,-4803.0f,-2683.0f,-956.0f,
    746.0f,2039.0f,3413.0f,5003.0f,6513.0f,7934.0f,8079.0f,7340.0f,
    6320.0f,4553.0f,2859.0f,875.0f,-1197.0f,-2940.0f,-4980.0f,-6659.0f,
    -7855.0f,-8715.0f,-8779.0f,-8008.0f,-6699.0f,-5165.0f,-3060.0f,-964.0f,
    827.0f,2714.0f,4505.0f,6200.0f,7324.0f,7686.0f,7453.0f,6537.0f,
    4786.0f,2802.0f,642.0f,-1543.0f,-2522.0f,-2498.0f,-1679.0f,265.0f,
    2047.0f,3019.0f,3662.0f,3252.0f,2112.0f,1228.0f,433.0f,-563.0f,
    -1944.0f,-3831.0f,-5944.0f,-7614.0f,-8393.0f,-8000.0f,-6675.0f,-5141.0f,
    -3430.0f,-1687.0f,377.0f,2192.0f,3670.0f,5710.0f,7324.0f,8336.0f,
    8489.0f,7509.0f,6441.0f,5059.0f,3397.0f,1895.0f,48.0f,-2065.0f,
    -4105.0f,-6201.0f,-8096.0f,-8939.0f,-9020.0f,-8417.0f,-7044.0f,-5478.0f,
    -3719.0f,-1824.0f,289.0f,2754.0f,4987.0f,6730.0f,8296.0f,8995.0f,
    8617.0f,7951.0f,6537.0f,4296.0f,1935.0f,-362.0f,-2032.0f,-2595.0f,
    -2755.0f,-1936.0f,-266.0f,-145.0f,-217.0f,1036.0f,923.0f,32.0f,
    738.0f,787.0f,-1085.0f,-2820.0f,-4193.0f,-6000.0f,-7052.0f,-6570.0f,
    -5341.0f,-3807.0f,-2113.0f,-804.0f,971.0f,2762.0f,3871.0f,5742.0f,
    7324.0f,7710.0f,7967.0f,7477.0f,6232.0f,4979.0f,3236.0f,1349.0f,
    -506.0f,-2273.0f,-3823.0f,-5614.0f,-7148.0f,-7984.0f,-8305.0f,-7879.0f,
    -6731.0f,-5261.0f,-3542.0f,-1671.0f,265.0f,2497.0f,4610.0f,6087.0f,
    7356.0f,8127.0f,7967.0f,7340.0f,6127.0f,4176.0f,1911.0f,-370.0f,
    -2113.0f,-2643.0f,-2506.0f,-1800.0f,-105.0f,722.0f,329.0f,1003.0f,
    1750.0f,875.0f,674.0f,1180.0f,-153.0f,-2257.0f,-3534.0f,-5084.0f,
    -6932.0f,-7197.0f,-6305.0f,-5502.0f,-3791.0f,-1543.0f,32.0f,1574.0f,
    3043.0f,4336.0f,5734.0f,6513.0f,7099.0f,7453.0f,6449.0f,5228.0f,
    4031.0f,2031.0f,112.0f,-1679.0f,-3293.0f,-4771.0f,-6217.0f,-7237.0f,
    -7735.0f,-7735.0f,-7237.0f,-6032.0f,-4426.0f,-2787.0f,-812.0f,1196.0f,
    3212.0f,5107.0f,6392.0f,7461.0f,8143.0f,8071.0f,7268.0f,5927.0f,
    4096.0f,1887.0f,-249.0f,-1759.0f,-2442.0f,-2563.0f,-1824.0f,-515.0f,
    88.0f,642.0f,1678.0f,1493.0f,546.0f,377.0f,-161.0f,-1438.0f,
    -2811.0f,-4040.0f,-5269.0f,-6514.0f,-6827.0f,-6048.0f,-5044.0f,-3430.0f,
    -1101.0f,987.0f,3067.0f,4987.0f,6087.0f,6778.0f,7155.0f,7123.0f,
    6521.0f,5501.0f,4473.0f,2827.0f,771.0f,-1229.0f,-3205.0f,-4811.0f,
    -6265.0f,-7253.0f,-7518.0f,-7606.0f,-7365.0f,-6474.0f,-5181.0f,-3711.0f,
    -1848.0f,385.0f,2529.0f,4730.0f,6601.0f,7541.0f,8063.0f,8111.0f,
    7043.0f,5469.0f,3975.0f,2072.0f,-161.0f,-1984.0f,-2884.0f,-3518.0f,
    -3783.0f,-2836.0f,-1390.0f,-113.0f,859.0f,1493.0f,2425.0f,2586.0f,
    1413.0f,875.0f,489.0f,-1229.0f,-3004.0f,-4040.0f,-5245.0f,-6209.0f,
    -6144.0f,-5365.0f,-3896.0f,-2073.0f,-386.0f,1542.0f,3308.0f,4417.0f,
    5260.0f,5654.0f,5790.0f,5967.0f,5525.0f,4626.0f,3855.0f,2465.0f,
    353.0f,-1623.0f,-3237.0f,-4811.0f,-6305.0f,-7269.0f,-7614.0f,-7751.0f,
    -7430.0f,-6273.0f,-4715.0f,-3004.0f,-972.0f,1011.0f,3164.0f,5220.0f,
    6256.0f,7196.0f,7782.0f,7107.0f,5959.0f,4505.0f,2441.0f,88.0f,
    -2024.0f,-3374.0f,-4016.0f,-4201.0f,-3454.0f,-2081.0f,-1125.0f,-498.0f,
    457.0f,1887.0f,2802.0f,2859.0f,3156.0f,2762.0f,530.0f,-1856.0f,
    -3582.0f,-5253.0f,-6233.0f,-5944.0f,-5068.0f,-3928.0f,-3085.0f,-2667.0f,
    -1310.0f,345.0f,1839.0f,3863.0f,5445.0f,5718.0f,5284.0f,4730.0f,
    4112.0f,3654.0f,3084.0f,2023.0f,634.0f,-836.0f,-2635.0f,-4827.0f,
    -6578.0f,-7558.0f,-8289.0f,-8522.0f,-7711.0f,-6377.0f,-5028.0f,-3502.0f,
    -1663.0f,522.0f,2393.0f,3557.0f,5115.0f,6770.0f,7236.0f,6955.0f,
    6352.0f,5067.0f,3517.0f,1686.0f,-41.0f,-587.0f,-1085.0f,-1575.0f,
    -772.0f,-249.0f,-643.0f,-523.0f,144.0f,722.0f,730.0f,369.0f,
    -611.0f,-2659.0f,-4683.0f,-6273.0f,-7301.0f,-7044.0f,-6112.0f,-5285.0f,
    -3960.0f,-2378.0f,-1318.0f,232.0f,2851.0f,5180.0f,6738.0f,7918.0f,
    8143.0f,7750.0f,6842.0f,5292.0f,4031.0f,2329.0f,136.0f,-1800.0f,
    -3912.0f,-5904.0f,-7373.0f,-8530.0f,-9124.0f,-8666.0f,-7823.0f,-6675.0f,
    -4932.0f,-3093.0f,-1318.0f,730.0f,2907.0f,5340.0f,7445.0f,8681.0f,
    9380.0f,9300.0f,8449.0f,6947.0f,5180.0f,3300.0f,1028.0f,-852.0f,
    -1775.0f,-2755.0f,-3494.0f,-3125.0f,-2980.0f,-2651.0f,-1286.0f,-490.0f,
    337.0f,1807.0f,1437.0f,240.0f,-595.0f,-2458.0f,-4434.0f,-5125.0f,
    -5317.0f,-5301.0f,-4418.0f,-3382.0f,-2129.0f,-274.0f,1574.0f,3116.0f,
    4834.0f,6360.0f,7380.0f,7951.0f,7653.0f,6537.0f,4955.0f,3196.0f,
    1188.0f,-755.0f,-2498.0f,-4602.0f,-6161.0f,-7124.0f,-8128.0f,-8401.0f,
    -7670.0f,-6691.0f,-5574.0f,-3960.0f,-2225.0f,-458.0f,1566.0f,3493.0f,
    5236.0f,6947.0f,7870.0f,8256.0f,8424.0f,7637.0f,6320.0f,4778.0f,
    2794.0f,987.0f,-386.0f,-1510.0f,-2065.0f,-2048.0f,-2241.0f,-2498.0f,
    -1912.0f,-1173.0f,-667.0f,-113.0f,754.0f,1357.0f,465.0f,-699.0f,
    -1856.0f,-4008.0f,-5799.0f,-6249.0f,-6080.0f,-5341.0f,-3783.0f,-2000.0f,
    -418.0f,1509.0f,3477.0f,5348.0f,7380.0f,8641.0f,8874.0f,8296.0f,
    7123.0f,5437.0f,3429.0f,1268.0f,-1061.0f,-2868.0f,-4362.0f,-5719.0f,
    -6506.0f,-6907.0f,-6988.0f,-6883.0f,-6201.0f,-4755.0f,-3229.0f,-1775.0f,
    -169.0f,1293.0f,2337.0f,3397.0f,4634.0f,5838.0f,6754.0f,7043.0f,
    6898.0f,6304.0f,5220.0f,3967.0f,2529.0f,931.0f,-354.0f,-1302.0f,
    -1920.0f,-1599.0f,-1037.0f,-972.0f,-619.0f,-41.0f,-113.0f,-523.0f,
    -386.0f,0.0f,-571.0f,-1631.0f,-2217.0f,-3398.0f,-5084.0f,-5952.0f,
    -6144.0f,-5920.0f,-4892.0f,-3197.0f,-1117.0f,1276.0f,3678.0f,5605.0f,
    7163.0f,8224.0f,8449.0f,8159.0f,7212.0f,5878.0f,4208.0f,2248.0f,
    257.0f,-2137.0f,-4474.0f,-6281.0f,-7727.0f,-8297.0f,-8072.0f,-7646.0f,
    -7092.0f,-5928.0f,-4362.0f,-2916.0f,-836.0f,1421.0f,3389.0f,5140.0f,
    6352.0f,7469.0f,8272.0f,8400.0f,8127.0f,7573.0f,6449.0f,4738.0f,
    2939.0f,939.0f,-1294.0f,-3093.0f,-4273.0f,-4803.0f,-4474.0f,-3719.0f,
    -2739.0f,-1567.0f,-266.0f,706.0f,762.0f,1036.0f,1678.0f,923.0f,
    -282.0f,-747.0f,-2040.0f,-4000.0f,-5068.0f,-5590.0f,-5783.0f,-4956.0f,
    -3374.0f,-1374.0f,1052.0f,3389.0f,5276.0f,7027.0f,8071.0f,8087.0f,
    7541.0f,6384.0f,4883.0f,3027.0f,971.0f,-1422.0f,-3952.0f,-5815.0f,
    -7526.0f,-8626.0f,-8482.0f,-8144.0f,-7654.0f,-6385.0f,-4675.0f,-3060.0f,
    -1117.0f,955.0f,2835.0f,4545.0f,5806.0f,6738.0f,7380.0f,7501.0f,
    7003.0f,6304.0f,5397.0f,3855.0f,1879.0f,-9.0f,-1816.0f,-3141.0f,
    -3727.0f,-4096.0f,-3711.0f,-3125.0f,-3277.0f,-2892.0f,-1743.0f,-619.0f,
    248.0f,1807.0f,3132.0f,2200.0f,722.0f,-603.0f,-2836.0f,-4916.0f,
    -5711.0f,-5349.0f,-5277.0f,-4811.0f,-3566.0f,-2538.0f,-996.0f,1357.0f,
    3871.0f,6144.0f,7798.0f,8312.0f,7669.0f,6441.0f,4802.0f,2819.0f,
    578.0f,-1896.0f,-3783.0f,-5438.0f,-7197.0f,-7903.0f,-8072.0f,-8168.0f,
    -7438.0f,-5976.0f,-4145.0f,-2338.0f,-683.0f,899.0f,2264.0f,3373.0f,
    4417.0f,5453.0f,6360.0f,6706.0f,6601.0f,6216.0f,5276.0f,4104.0f,
    2361.0f,489.0f,-515.0f,-1583.0f,-2675.0f,-2836.0f,-2747.0f,-3775.0f,
    -4619.0f,-3920.0f,-3189.0f,-2153.0f,-330.0f,650.0f,1164.0f,947.0f,
    -490.0f,-1567.0f,-2434.0f,-3390.0f,-3936.0f,-4121.0f,-4105.0f,-3550.0f,
    -2418.0f,-1414.0f,160.0f,2240.0f,3557.0f,4939.0f,6666.0f,6906.0f,
    6095.0f,5091.0f,3429.0f,1517.0f,-515.0f,-2811.0f,-4482.0f,-6008.0f,
    -7301.0f,-7590.0f,-7413.0f,-6787.0f,-5783.0f,-4418.0f,-2771.0f,-1141.0f,
    353.0f,1807.0f,3043.0f,4047.0f,4826.0f,5445.0f,6144.0f,6625.0f,
    6368.0f,5814.0f,5107.0f,3606.0f,2072.0f,1285.0f,-89.0f,-1470.0f,
    -1976.0f,-3253.0f,-4611.0f,-4586.0f,-4578.0f,-4345.0f,-2988.0f,-1406.0f,
    40.0f,385.0f,481.0f,1469.0f,795.0f,-860.0f,-691.0f,-876.0f,
    -2675.0f,-3285.0f,-2707.0f,-3004.0f,-2779.0f,-1374.0f,-1.0f,1566.0f,
    3164.0f,4465.0f,5670.0f,5895.0f,5565.0f,4923.0f,3284.0f,1823.0f,
    200.0f,-2314.0f,-4217.0f,-5767.0f,-7148.0f,-7446.0f,-7181.0f,-6217.0f,
    -5020.0f,-4064.0f,-2458.0f,-643.0f,843.0f,2345.0f,3549.0f,4618.0f,
    5324.0f,5533.0f,5870.0f,6071.0f,5613.0f,4794.0f,3959.0f,3188.0f,
    2586.0f,1935.0f,1092.0f,409.0f,-844.0f,-2643.0f,-3438.0f,-3848.0f,
    -4209.0f,-3703.0f,-2828.0f,-2314.0f,-1438.0f,-804.0f,-1197.0f,-1020.0f,
    -394.0f,-667.0f,-731.0f,-394.0f,-772.0f,-1534.0f,-1848.0f,-1703.0f,
    -1149.0f,265.0f,2015.0f,3710.0f,5196.0f,5702.0f,5750.0f,5959.0f,
    5260.0f,3991.0f,2650.0f,554.0f,-1703.0f,-3823.0f,-5992.0f,-7421.0f,
    -8289.0f,-8506.0f,-7727.0f,-6514.0f,-4795.0f,-2811.0f,-1020.0f,811.0f,
    2642.0f,4176.0f,5204.0f,5991.0f,6561.0f,6433.0f,5927.0f,5501.0f,
    4858.0f,4007.0f,3172.0f,2634.0f,2144.0f,1429.0f,859.0f,192.0f,
    -1037.0f,-2362.0f,-3446.0f,-4273.0f,-4811.0f,-4651.0f,-3856.0f,-3245.0f,
    -2739.0f,-1695.0f,-1012.0f,-1382.0f,-1302.0f,-362.0f,313.0f,682.0f,
    1421.0f,1533.0f,441.0f,-177.0f,112.0f,361.0f,1220.0f,2778.0f,
    3879.0f,4473.0f,4690.0f,4353.0f,3774.0f,2843.0f,1742.0f,586.0f,
    -1165.0f,-2892.0f,-4434.0f,-6161.0f,-7405.0f,-7678.0f,-7301.0f,-6104.0f,
    -4362.0f,-2394.0f,-450.0f,1236.0f,2802.0f,4079.0f,5083.0f,5686.0f,
    5878.0f,5951.0f,5838.0f,5276.0f,4393.0f,3437.0f,2329.0f,1188.0f,
    570.0f,522.0f,570.0f,602.0f,594.0f,-1.0f,-988.0f,-1976.0f,
    -3141.0f,-4088.0f,-4691.0f,-4916.0f,-4554.0f,-3976.0f,-3277.0f,-2209.0f,
    -1462.0f,-1414.0f,-940.0f,240.0f,987.0f,1445.0f,2361.0f,2907.0f,
    2610.0f,2513.0f,2770.0f,2562.0f,2545.0f,2867.0f,3084.0f,3397.0f,
    3381.0f,2963.0f,2393.0f,1276.0f,-233.0f,-1912.0f,-3775.0f,-5237.0f,
    -6450.0f,-7526.0f,-7927.0f,-7727.0f,-7116.0f,-5695.0f,-3687.0f,-1462.0f,
    843.0f,2979.0f,4762.0f,6103.0f,6971.0f,7260.0f,7027.0f,6577.0f,
    5862.0f,4545.0f,2987.0f,1574.0f,120.0f,-1004.0f,-1221.0f,-996.0f,
    -828.0f,-474.0f,-418.0f,-1125.0f,-1856.0f,-2563.0f,-3422.0f,-3623.0f,
    -3213.0f,-2811.0f,-2378.0f,-2153.0f,-2426.0f,-2530.0f,-2426.0f,-2225.0f,
    -1213.0f,594.0f,2208.0f,2794.0f,3051.0f,2794.0f,1742.0f,1349.0f,
    1839.0f,2305.0f,2971.0f,3694.0f,3750.0f,3469.0f,2931.0f,1895.0f,
    1011.0f,297.0f,-860.0f,-2145.0f,-3831.0f,-5815.0f,-7470.0f,-8642.0f,
    -9124.0f,-8417.0f,-7124.0f,-5462.0f,-3229.0f,-988.0f,1220.0f,3381.0f,
    5292.0f,6810.0f,7702.0f,8103.0f,7766.0f,6746.0f,5734.0f,4304.0f,
    2481.0f,1156.0f,337.0f,-129.0f,-17.0f,393.0f,787.0f,385.0f,
    -852.0f,-1783.0f,-2402.0f,-3261.0f,-3607.0f,-3181.0f,-3872.0f,-5414.0f,
    -5960.0f,-6369.0f,-6956.0f,-5743.0f,-3486.0f,-1992.0f,-772.0f,634.0f,
    2096.0f,2602.0f,3501.0f,5300.0f,5678.0f,5485.0f,5589.0f,5011.0f,
    3766.0f,2618.0f,1951.0f,1068.0f,-362.0f,-1623.0f,-2643.0f,-4177.0f,
    -5863.0f,-6964.0f,-8072.0f,-8939.0f,-8723.0f,-7944.0f,-6899.0f,-5205.0f,
    -3462.0f,-1567.0f,746.0f,3027.0f,5356.0f,7477.0f,8754.0f,9131.0f,
    9091.0f,8529.0f,7340.0f,5886.0f,4192.0f,2288.0f,481.0f,-659.0f,
    -1213.0f,-1952.0f,-2032.0f,-1936.0f,-2892.0f,-2996.0f,-2571.0f,-2932.0f,
    -2747.0f,-2474.0f,-3197.0f,-4193.0f,-5084.0f,-5534.0f,-5574.0f,-5245.0f,
    -4233.0f,-2619.0f,-892.0f,730.0f,2586.0f,4441.0f,6184.0f,7364.0f,
    7702.0f,8143.0f,8039.0f,6722.0f,5654.0f,4449.0f,2345.0f,586.0f,
    -908.0f,-2579.0f,-3912.0f,-5189.0f,-6594.0f,-7494.0f,-8088.0f,-8249.0f,
    -7927.0f,-7502.0f,-6490.0f,-5141.0f,-3727.0f,-1783.0f,289.0f,2353.0f,
    4256.0f,5654.0f,7308.0f,8746.0f,9533.0f,9693.0f,9035.0f,7918.0f,
    5951.0f,3549.0f,1831.0f,160.0f,-1679.0f,-2707.0f,-3390.0f,-4321.0f,
    -4667.0f,-4096.0f,-3599.0f,-3109.0f,-2233.0f,-1759.0f,-1952.0f,-2330.0f,
    -2554.0f,-3052.0f,-3807.0f,-3864.0f,-3518.0f,-3358.0f,-2691.0f,-1358.0f,
    361.0f,2160.0f,3983.0f,5911.0f,7645.0f,8593.0f,8569.0f,8432.0f,
    7854.0f,6152.0f,4658.0f,3148.0f,730.0f,-1382.0f,-3454.0f,-5566.0f,
    -6932.0f,-7960.0f,-8658.0f,-8618.0f,-7984.0f,-7197.0f,-6305.0f,-5004.0f,
    -3358.0f,-1816.0f,-113.0f,1959.0f,3951.0f,5638.0f,7147.0f,8449.0f,
    9203.0f,9380.0f,9147.0f,8376.0f,7099.0f,5734.0f,4192.0f,2513.0f,
    939.0f,-587.0f,-2049.0f,-3695.0f,-4739.0f,-4884.0f,-5028.0f,-4699.0f,
    -3462.0f,-2675.0f,-2699.0f,-2498.0f,-2546.0f,-3358.0f,-3912.0f,-3944.0f,
    -4000.0f,-3864.0f,-3245.0f,-2595.0f,-1944.0f,-683.0f,1060.0f,3148.0f,
    5509.0f,7340.0f,8738.0f,9709.0f,9083.0f,8079.0f,7163.0f,5348.0f,
    3549.0f,1847.0f,-362.0f,-2731.0f,-5084.0f,-7213.0f,-8755.0f,-9461.0f,
    -9413.0f,-8474.0f,-7076.0f,-5695.0f,-3848.0f,-2024.0f,-266.0f,1742.0f,
    3766.0f,5493.0f,6826.0f,8023.0f,8609.0f,8577.0f,8328.0f,7830.0f,
    6746.0f,5268.0f,3919.0f,2714.0f,1453.0f,104.0f,-1237.0f,-2659.0f,
    -4241.0f,-5542.0f,-6217.0f,-6297.0f,-5847.0f,-5068.0f,-4241.0f,-3591.0f,
    -3229.0f,-3301.0f,-3791.0f,-3992.0f,-3679.0f,-3325.0f,-2579.0f,-1559.0f,
    -868.0f,-370.0f,457.0f,1815.0f,3541.0f,5734.0f,7710.0f,8818.0f,
    9533.0f,9059.0f,7621.0f,6553.0f,4875.0f,2899.0f,1204.0f,-1045.0f,
    -3470.0f,-5815.0f,-7968.0f,-9502.0f,-9791.0f,-9108.0f,-8136.0f,-6514.0f,
    -4747.0f,-3165.0f,-1205.0f,787.0f,2827.0f,4955.0f,6392.0f,7308.0f,
    8216.0f,8288.0f,7702.0f,6955.0f,5734.0f,4120.0f,2513.0f,1293.0f,
    232.0f,-707.0f,-1414.0f,-2386.0f,-3534.0f,-4305.0f,-5173.0f,-5912.0f,
    -5871.0f,-5406.0f,-5004.0f,-4201.0f,-3157.0f,-2731.0f,-2587.0f,-2474.0f,
    -2571.0f,-2458.0f,-2105.0f,-1518.0f,-659.0f,88.0f,891.0f,1871.0f,
    2899.0f,4007.0f,5348.0f,6730.0f,7702.0f,8047.0f,7951.0f,7067.0f,
    5533.0f,4176.0f,2401.0f,481.0f,-1478.0f,-3960.0f,-6217.0f,-8184.0f,
    -9662.0f,-9943.0f,-9285.0f,-8201.0f,-6642.0f,-4835.0f,-3052.0f,-1061.0f,
    1116.0f,3204.0f,5091.0f,6898.0f,7959.0f,8127.0f,8119.0f,7348.0f,
    6039.0f,4618.0f,2995.0f,1405.0f,48.0f,-1004.0f,-1856.0f,-2418.0f,
    -3109.0f,-4201.0f,-4972.0f,-5349.0f,-5896.0f,-5743.0f,-4554.0f,-3454.0f,
    -2900.0f,-2289.0f,-1904.0f,-2314.0f,-2442.0f,-1695.0f,-780.0f,32.0f,
    714.0f,1100.0f,835.0f,321.0f,634.0f,1582.0f,2602.0f,4079.0f,
    5830.0f,6633.0f,6401.0f,6401.0f,6360.0f,4971.0f,3766.0f,2907.0f,
    835.0f,-1053.0f,-3101.0f,-5663.0f,-7622.0f,-9212.0f,-9759.0f,-9052.0f,
    -8024.0f,-6546.0f,-4803.0f,-3165.0f,-1318.0f,594.0f,2505.0f,4256.0f,
    5469.0f,6248.0f,6682.0f,6754.0f,6288.0f,5148.0f,4095.0f,3140.0f,
    2120.0f,1148.0f,232.0f,-579.0f,-1253.0f,-2217.0f,-3623.0f,-4611.0f,
    -5076.0f,-5534.0f,-5639.0f,-5036.0f,-4739.0f,-4924.0f,-4611.0f,-3984.0f,
    -3574.0f,-2723.0f,-1334.0f,-225.0f,433.0f,1196.0f,1967.0f,2409.0f,
    2810.0f,3389.0f,3871.0f,4071.0f,4320.0f,4762.0f,5067.0f,5252.0f,
    5348.0f,5075.0f,4569.0f,3646.0f,2288.0f,1076.0f,-627.0f,-2747.0f,
    -4843.0f,-6883.0f,-8401.0f,-9261.0f,-9164.0f,-8193.0f,-6883.0f,-5317.0f,
    -3462.0f,-1671.0f,321.0f,2602.0f,4593.0f,6224.0f,7669.0f,8368.0f,
    8095.0f,7477.0f,6850.0f,5886.0f,4714.0f,3533.0f,2409.0f,1293.0f,
    248.0f,-715.0f,-2040.0f,-3012.0f,-3566.0f,-4442.0f,-4787.0f,-4554.0f,
    -4892.0f,-5181.0f,-5028.0f,-4755.0f,-4410.0f,-3815.0f,-2755.0f,-1510.0f,
    -410.0f,754.0f,2047.0f,2963.0f,3485.0f,4184.0f,4762.0f,4826.0f,
    4939.0f,4939.0f,4601.0f,4280.0f,4087.0f,4136.0f,3766.0f,3084.0f,
    2931.0f,2080.0f,505.0f,-611.0f,-2185.0f,-4080.0f,-5799.0f,-7060.0f,
    -7719.0f,-8241.0f,-7815.0f,-6683.0f,-5647.0f,-4145.0f,-2289.0f,-780.0f,
    1036.0f,3067.0f,4393.0f,5453.0f,6730.0f,7549.0f,7613.0f,7067.0f,
    6248.0f,5316.0f,4224.0f,2883.0f,1742.0f,594.0f,-1165.0f,-2346.0f,
    -2844.0f,-3558.0f,-3775.0f,-3623.0f,-3952.0f,-4273.0f,-4659.0f,-5076.0f,
    -4988.0f,-4827.0f,-4450.0f,-3446.0f,-2522.0f,-1775.0f,-515.0f,795.0f,
    1782.0f,3059.0f,4481.0f,5348.0f,5975.0f,6336.0f,6055.0f,5469.0f,
    4810.0f,4192.0f,3590.0f,3084.0f,2698.0f,1734.0f,706.0f,240.0f,
    -1077.0f,-2691.0f,-3534.0f,-4755.0f,-6217.0f,-7020.0f,-7301.0f,-7518.0f,
    -7253.0f,-6136.0f,-4731.0f,-3374.0f,-1534.0f,313.0f,2152.0f,4272.0f,
    6087.0f,7493.0f,8352.0f,8714.0f,8440.0f,7686.0f,6979.0f,5878.0f,
    4312.0f,3067.0f,1349.0f,-844.0f,-2121.0f,-3036.0f,-4185.0f,-4394.0f,
    -3984.0f,-4337.0f,-4980.0f,-5173.0f,-5398.0f,-6056.0f,-5944.0f,-4996.0f,
    -4386.0f,-3767.0f,-2715.0f,-1824.0f,-1085.0f,128.0f,1871.0f,3565.0f,
    5067.0f,6240.0f,6818.0f,6690.0f,6015.0f,5517.0f,4891.0f,3750.0f,
    2891.0f,2240.0f,1140.0f,-153.0f,-1342.0f,-2209.0f,-3213.0f,-4506.0f,
    -4916.0f,-5044.0f,-5799.0f,-6249.0f,-6112.0f,-6120.0f,-5896.0f,-4707.0f,
    -3277.0f,-1880.0f,-33.0f,1782.0f,3413.0f,5220.0f,6666.0f,7645.0f,
    8264.0f,8416.0f,8360.0f,7951.0f,6866.0f,5662.0f,4007.0f,1726.0f,
    -482.0f,-2097.0f,-3358.0f,-4530.0f,-4908.0f,-5036.0f,-5703.0f,-6225.0f,
    -6466.0f,-6787.0f,-6667.0f,-5984.0f,-4964.0f,-3936.0f,-2980.0f,-2097.0f,
    -1446.0f,-667.0f,586.0f,2176.0f,3967.0f,5573.0f,6706.0f,7131.0f,
    6746.0f,6127.0f,5252.0f,4120.0f,3140.0f,2088.0f,819.0f,-386.0f,
    -1575.0f,-3044.0f,-4466.0f,-4900.0f,-4916.0f,-5382.0f,-5044.0f,-4297.0f,
    -4522.0f,-4635.0f,-4008.0f,-3390.0f,-2715.0f,-1534.0f,-65.0f,1188.0f,
    2353.0f,3501.0f,4601.0f,5646.0f,6328.0f,6882.0f,7308.0f,7396.0f,
    7019.0f,6256.0f,5075.0f,3300.0f,1220.0f,-450.0f,-2113.0f,-3591.0f,
    -4177.0f,-4667.0f,-5550.0f,-6080.0f,-6112.0f,-6530.0f,-6996.0f,-6305.0f,
    -5165.0f,-4707.0f,-3807.0f,-2249.0f,-1647.0f,-1510.0f,-249.0f,1236.0f,
    2112.0f,3694.0f,5654.0f,6384.0f,6481.0f,6714.0f,6280.0f,5067.0f,
    4120.0f,3469.0f,1983.0f,216.0f,-1004.0f,-2466.0f,-4209.0f,-5494.0f,
    -6136.0f,-5920.0f,-5655.0f,-5502.0f,-4466.0f,-3671.0f,-3591.0f,-2868.0f,
    -1591.0f,-675.0f,152.0f,1461.0f,2610.0f,3365.0f,4240.0f,4979.0f,
    5581.0f,6168.0f,6746.0f,7075.0f,6923.0f,6802.0f,5975.0f,4112.0f,
    2529.0f,939.0f,-1077.0f,-2603.0f,-3229.0f,-4000.0f,-5462.0f,-6273.0f,
    -6707.0f,-7598.0f,-7622.0f,-6393.0f,-5494.0f,-4675.0f,-3390.0f,-2595.0f,
    -2249.0f,-1302.0f,32.0f,1204.0f,2658.0f,3879.0f,4610.0f,5340.0f,
    5919.0f,6184.0f,5951.0f,5429.0f,4963.0f,3935.0f,2280.0f,457.0f,
    -1583.0f,-3727.0f,-5357.0f,-6201.0f,-6787.0f,-7221.0f,-6803.0f,-5823.0f,
    -5438.0f,-4779.0f,-3285.0f,-2065.0f,-892.0f,851.0f,2353.0f,3124.0f,
    3838.0f,4690.0f,5244.0f,5581.0f,5967.0f,6425.0f,6850.0f,7003.0f,
    6955.0f,6658.0f,5405.0f,3830.0f,2553.0f,738.0f,-940.0f,-2032.0f,
    -3277.0f,-4940.0f,-6426.0f,-7349.0f,-8160.0f,-8401.0f,-7598.0f,-6369.0f,
    -5253.0f,-4201.0f,-2916.0f,-1655.0f,-780.0f,642.0f,2433.0f,3557.0f,
    4505.0f,5461.0f,5734.0f,5525.0f,5621.0f,5678.0f,5099.0f,4650.0f,
    4200.0f,3092.0f,1726.0f,248.0f,-1494.0f,-3390.0f,-5012.0f,-6040.0f,
    -6731.0f,-6899.0f,-6570.0f,-6313.0f,-5357.0f,-3872.0f,-2723.0f,-980.0f,
    1092.0f,2353.0f,3509.0f,4850.0f,5372.0f,5629.0f,6063.0f,6071.0f,
    6144.0f,6208.0f,5919.0f,5718.0f,5348.0f,4120.0f,2971.0f,2023.0f,
    650.0f,-458.0f,-1438.0f,-2884.0f,-4410.0f,-6032.0f,-7261.0f,-7903.0f,
    -8160.0f,-7751.0f,-6835.0f,-5968.0f,-4956.0f,-3478.0f,-2057.0f,-755.0f,
    915.0f,2618.0f,3782.0f,4730.0f,5493.0f,5565.0f,5115.0f,4754.0f,
    4369.0f,3678.0f,3059.0f,2578.0f,1670.0f,538.0f,-434.0f,-1526.0f,
    -2699.0f,-3759.0f,-4498.0f,-5221.0f,-5759.0f,-5783.0f,-5534.0f,-4948.0f,
    -4097.0f,-3068.0f,-1334.0f,546.0f,1831.0f,3445.0f,5067.0f,5758.0f,
    6264.0f,6858.0f,6963.0f,6577.0f,6312.0f,5798.0f,4690.0f,3678.0f,
    2232.0f,690.0f,-185.0f,-1237.0f,-2161.0f,-2763.0f,-3663.0f,-4691.0f,
    -5622.0f,-6345.0f,-6626.0f,-6675.0f,-6289.0f,-5494.0f,-4755.0f,-3984.0f,
    -2964.0f,-1775.0f,-482.0f,1076.0f,2666.0f,3895.0f,4786.0f,5075.0f,
    4642.0f,4224.0f,3903.0f,3453.0f,2690.0f,1799.0f,923.0f,-306.0f,
    -1631.0f,-2554.0f,-3422.0f,-4177.0f,-4514.0f,-4667.0f,-4594.0f,-4402.0f,
    -4088.0f,-3518.0f,-3093.0f,-2514.0f,-1326.0f,-49.0f,1501.0f,2963.0f,
    4288.0f,5846.0f,6497.0f,6858.0f,7485.0f,7172.0f,6320.0f,5862.0f,
    4947.0f,3341.0f,1975.0f,425.0f,-1775.0f,-3309.0f,-4426.0f,-5767.0f,
    -5928.0f,-5478.0f,-5414.0f,-5157.0f,-4715.0f,-4297.0f,-4096.0f,-3486.0f,
    -2145.0f,-1406.0f,-860.0f,144.0f,409.0f,546.0f,1092.0f,1638.0f,
    2264.0f,2923.0f,3477.0f,3702.0f,3421.0f,3051.0f,2610.0f,1766.0f,
    899.0f,248.0f,-595.0f,-1743.0f,-2506.0f,-3189.0f,-4209.0f,-4683.0f,
    -4554.0f,-4378.0f,-3743.0f,-2820.0f,-1888.0f,-932.0f,-209.0f,618.0f,
    1646.0f,2457.0f,3517.0f,4746.0f,5694.0f,6384.0f,6658.0f,7083.0f,
    7091.0f,6135.0f,5517.0f,4810.0f,3188.0f,1622.0f,377.0f,-1462.0f,
    -3719.0f,-5406.0f,-6795.0f,-8120.0f,-8514.0f,-8160.0f,-7687.0f,-6723.0f,
    -5414.0f,-4241.0f,-3149.0f,-1615.0f,72.0f,1413.0f,2778.0f,4096.0f,
    4601.0f,4650.0f,4569.0f,4144.0f,3766.0f,3260.0f,2819.0f,2553.0f,
    2047.0f,1421.0f,811.0f,32.0f,-474.0f,-940.0f,-1390.0f,-1559.0f,
    -1775.0f,-2057.0f,-2450.0f,-2811.0f,-3173.0f,-3574.0f,-3647.0f,-3382.0f,
    -2980.0f,-2426.0f,-1864.0f,-1269.0f,-796.0f,-338.0f,546.0f,1268.0f,
    1782.0f,2714.0f,3453.0f,4087.0f,4818.0f,5196.0f,6063.0f,6842.0f,
    6609.0f,6617.0f,6232.0f,4650.0f,3084.0f,1726.0f,-113.0f,-1880.0f,
    -3052.0f,-4731.0f,-6482.0f,-7558.0f,-8827.0f,-9365.0f,-8490.0f,-7365.0f,
    -5904.0f,-4313.0f,-2916.0f,-1486.0f,-394.0f,995.0f,2794.0f,4096.0f,
    5292.0f,6039.0f,5999.0f,5589.0f,4762.0f,3999.0f,3260.0f,2441.0f,
    1766.0f,819.0f,-258.0f,-1141.0f,-2289.0f,-3526.0f,-4337.0f,-4811.0f,
    -5084.0f,-4980.0f,-4265.0f,-3534.0f,-2988.0f,-1976.0f,-739.0f,417.0f,
    1895.0f,3485.0f,4858.0f,5605.0f,5927.0f,6103.0f,5541.0f,4650.0f,
    4039.0f,3445.0f,2802.0f,2072.0f,1413.0f,1244.0f,530.0f,-924.0f,
    -1342.0f,-1390.0f,-2265.0f,-2603.0f,-1944.0f,-2121.0f,-3173.0f,-3494.0f,
    -3743.0f,-4482.0f,-4418.0f,-3888.0f,-3518.0f,-2820.0f,-2193.0f,-1775.0f,
    -1350.0f,-643.0f,337.0f,1068.0f,1823.0f,2819.0f,3220.0f,3365.0f,
    3565.0f,3405.0f,3204.0f,2971.0f,2778.0f,2586.0f,2208.0f,1638.0f,
    843.0f,56.0f,-434.0f,-964.0f,-1085.0f,-780.0f,-699.0f,-539.0f,
    -531.0f,-699.0f,-804.0f,-908.0f,-996.0f,-1069.0f,-1093.0f,-1173.0f,
    -1446.0f,-1679.0f,-2065.0f,-2434.0f,-2474.0f,-2587.0f,-2442.0f,-1880.0f,
    -1213.0f,-121.0f,1003.0f,2064.0f,3790.0f,5316.0f,5951.0f,6882.0f,
    7878.0f,7348.0f,6409.0f,5935.0f,4465.0f,2232.0f,642.0f,-1101.0f,
    -3542.0f,-5205.0f,-6594.0f,-7935.0f,-8249.0f,-8152.0f,-7413.0f,-6241.0f,
    -4996.0f,-3133.0f,-1534.0f,-306.0f,1309.0f,2553.0f,3268.0f,3798.0f,
    4184.0f,4216.0f,3581.0f,2947.0f,2449.0f,1790.0f,1076.0f,281.0f,
    -233.0f,-659.0f,-1438.0f,-1735.0f,-1647.0f,-1695.0f,-1390.0f,-675.0f,
    128.0f,754.0f,1542.0f,2144.0f,2433.0f,2835.0f,2770.0f,2441.0f,
    2272.0f,1558.0f,642.0f,-17.0f,-1101.0f,-2193.0f,-2771.0f,-3125.0f,
    -3077.0f,-2996.0f,-2779.0f,-1599.0f,-1221.0f,-1277.0f,208.0f,1244.0f,
    1260.0f,1903.0f,2754.0f,2377.0f,1630.0f,1606.0f,1044.0f,-25.0f,
    -450.0f,-860.0f,-1366.0f,-1679.0f,-1751.0f,-1824.0f,-2024.0f,-1711.0f,
    -1342.0f,-1310.0f,-860.0f,-330.0f,-113.0f,40.0f,16.0f,240.0f,
    168.0f,-81.0f,56.0f,8.0f,-105.0f,-330.0f,-603.0f,-378.0f,
    -458.0f,-691.0f,-474.0f,-306.0f,-450.0f,-579.0f,-394.0f,-434.0f,
    -442.0f,-121.0f,56.0f,522.0f,1011.0f,1172.0f,1662.0f,2112.0f,
    2176.0f,2481.0f,2987.0f,3180.0f,3043.0f,3228.0f,3300.0f,2337.0f,
    1582.0f,1839.0f,1276.0f,-49.0f,-282.0f,-763.0f,-2579.0f,-3928.0f,
    -4362.0f,-5301.0f,-6313.0f,-6177.0f,-5944.0f,-6217.0f,-5622.0f,-4667.0f,
    -3984.0f,-2587.0f,-731.0f,505.0f,1718.0f,3437.0f,4264.0f,4288.0f,
    4521.0f,4328.0f,3525.0f,2762.0f,1903.0f,1084.0f,32.0f,-892.0f,
    -1037.0f,-1117.0f,-836.0f,168.0f,1116.0f,2072.0f,3188.0f,3774.0f,
    4023.0f,4401.0f,4224.0f,3397.0f,2513.0f,1092.0f,-860.0f,-2884.0f,
    -4771.0f,-6458.0f,-7743.0f,-8546.0f,-8723.0f,-8361.0f,-7791.0f,-6554.0f,
    -4787.0f,-2996.0f,-796.0f,1766.0f,4200.0f,6280.0f,8063.0f,9653.0f,
    10328.0f,10071.0f,9549.0f,8609.0f,7051.0f,5099.0f,3172.0f,851.0f,
    -1928.0f,-4265.0f,-6458.0f,-8466.0f,-9333.0f,-9534.0f,-9253.0f,-7992.0f,
    -6474.0f,-5149.0f,-3566.0f,-1711.0f,-185.0f,1100.0f,2473.0f,3276.0f,
    3533.0f,3606.0f,3236.0f,2786.0f,2176.0f,1477.0f,1076.0f,771.0f,
    522.0f,224.0f,-129.0f,-185.0f,-201.0f,-266.0f,240.0f,995.0f,
    1260.0f,1542.0f,1863.0f,1501.0f,1060.0f,819.0f,473.0f,329.0f,
    473.0f,417.0f,361.0f,88.0f,-603.0f,-964.0f,-1277.0f,-1679.0f,
    -1567.0f,-1414.0f,-1205.0f,-1277.0f,-1663.0f,-1398.0f,-1004.0f,-1093.0f,
    -627.0f,152.0f,24.0f,-225.0f,0.0f,-266.0f,-964.0f,-1101.0f,
    -1269.0f,-1719.0f,-1791.0f,-1767.0f,-2008.0f,-1992.0f,-1663.0f,-1294.0f,
    -956.0f,-129.0f,1164.0f,2377.0f,3630.0f,4899.0f,5750.0f,5935.0f,
    6087.0f,6192.0f,5750.0f,5140.0f,4272.0f,2843.0f,939.0f,-1253.0f,
    -3518.0f,-5550.0f,-6996.0f,-8096.0f,-8530.0f,-8626.0f,-8618.0f,-7847.0f,
    -6899.0f,-5550.0f,-3623.0f,-1727.0f,337.0f,2602.0f,4561.0f,6160.0f,
    7525.0f,8272.0f,8497.0f,8304.0f,7613.0f,6617.0f,5324.0f,3686.0f,
    2112.0f,803.0f,-547.0f,-1671.0f,-2040.0f,-2314.0f,-2418.0f,-2057.0f,
    -1639.0f,-1093.0f,-659.0f,-97.0f,232.0f,-129.0f,-595.0f,-1358.0f,
    -2434.0f,-3366.0f,-4145.0f,-4924.0f,-5341.0f,-5237.0f,-5020.0f,-4643.0f,
    -3679.0f,-2362.0f,-1165.0f,329.0f,2031.0f,3164.0f,4095.0f,4818.0f,
    5180.0f,5573.0f,5573.0f,5589.0f,5710.0f,5292.0f,4521.0f,3622.0f,
    2690.0f,1646.0f,1011.0f,722.0f,289.0f,-185.0f,-916.0f,-1864.0f,
    -2787.0f,-3534.0f,-4153.0f,-4394.0f,-4233.0f,-4329.0f,-4048.0f,-3574.0f,
    -3406.0f,-2715.0f,-1679.0f,-804.0f,257.0f,1670.0f,2570.0f,3365.0f,
    4240.0f,4642.0f,4907.0f,4915.0f,4850.0f,4915.0f,4328.0f,3373.0f,
    2674.0f,1461.0f,-434.0f,-1430.0f,-2201.0f,-3623.0f,-4024.0f,-3848.0f,
    -3960.0f,-3438.0f,-2731.0f,-2177.0f,-1269.0f,-338.0f,505.0f,1293.0f,
    2007.0f,2353.0f,2096.0f,1501.0f,907.0f,136.0f,-635.0f,-1053.0f,
    -1422.0f,-1824.0f,-2209.0f,-2394.0f,-2386.0f,-2065.0f,-1414.0f,-820.0f,
    -33.0f,1060.0f,1766.0f,2489.0f,3308.0f,3678.0f,3943.0f,3863.0f,
    3606.0f,3349.0f,2658.0f,1951.0f,1365.0f,658.0f,-113.0f,-466.0f,
    -691.0f,-1029.0f,-892.0f,-675.0f,-747.0f,-515.0f,-474.0f,-595.0f,
    -370.0f,-482.0f,-892.0f,-1173.0f,-1310.0f,-1478.0f,-2073.0f,-2306.0f,
    -2193.0f,-2627.0f,-2844.0f,-2498.0f,-2498.0f,-2554.0f,-2201.0f,-1848.0f,
    -1518.0f,-1045.0f,-555.0f,-193.0f,265.0f,979.0f,1574.0f,1999.0f,
    2778.0f,3541.0f,3670.0f,3790.0f,4152.0f,4192.0f,3943.0f,4023.0f,
    4176.0f,3847.0f,3092.0f,2433.0f,1630.0f,361.0f,-755.0f,-1840.0f,
    -2820.0f,-3687.0f,-4643.0f,-5060.0f,-5205.0f,-5671.0f,-5446.0f,-4570.0f,
    -4121.0f,-3293.0f,-1856.0f,-972.0f,-145.0f,1204.0f,2176.0f,2963.0f,
    3871.0f,4353.0f,4626.0f,4336.0f,3477.0f,2891.0f,1983.0f,795.0f,
    361.0f,8.0f,-924.0f,-1430.0f,-1061.0f,-1101.0f,-1310.0f,-563.0f,
    128.0f,144.0f,176.0f,481.0f,337.0f,-233.0f,-739.0f,-1141.0f,
    -1872.0f,-2771.0f,-3237.0f,-3807.0f,-4257.0f,-3952.0f,-3960.0f,-3767.0f,
    -2643.0f,-2024.0f,-1310.0f,-1.0f,779.0f,1413.0f,2321.0f,2754.0f,
    3252.0f,3935.0f,3991.0f,4007.0f,4087.0f,3806.0f,3180.0f,2529.0f,
    2288.0f,2015.0f,1084.0f,762.0f,1132.0f,530.0f,-161.0f,281.0f,
    144.0f,-956.0f,-1261.0f,-1165.0f,-2073.0f,-3093.0f,-3117.0f,-3422.0f,
    -4522.0f,-4851.0f,-4354.0f,-4602.0f,-4851.0f,-4016.0f,-3390.0f,-3237.0f,
    -2289.0f,-804.0f,-137.0f,345.0f,1959.0f,3019.0f,2859.0f,3397.0f,
    4152.0f,3413.0f,2730.0f,2794.0f,1879.0f,754.0f,425.0f,-57.0f,
    -812.0f,-1157.0f,-1261.0f,-1599.0f,-1543.0f,-635.0f,-137.0f,313.0f,
    1493.0f,1983.0f,1847.0f,2023.0f,2031.0f,1654.0f,979.0f,393.0f,
    0.0f,-1101.0f,-2137.0f,-2370.0f,-2763.0f,-2948.0f,-2466.0f,-2153.0f,
    -1655.0f,-844.0f,-466.0f,168.0f,1180.0f,1542.0f,1999.0f,2545.0f,
    2264.0f,1871.0f,1212.0f,56.0f,-763.0f,-1759.0f,-2852.0f,-3149.0f,
    -3510.0f,-3984.0f,-3574.0f,-3141.0f,-2723.0f,-1703.0f,-691.0f,578.0f,
    1879.0f,2698.0f,3565.0f,4168.0f,4457.0f,4425.0f,4248.0f,3911.0f,
    2827.0f,1477.0f,449.0f,-916.0f,-2635.0f,-3711.0f,-4506.0f,-5406.0f,
    -5655.0f,-5422.0f,-5510.0f,-5125.0f,-4032.0f,-3093.0f,-2289.0f,-747.0f,
    915.0f,1927.0f,3116.0f,4521.0f,5051.0f,5220.0f,5565.0f,5581.0f,
    5228.0f,4553.0f,4047.0f,3630.0f,2947.0f,2393.0f,2152.0f,1477.0f,
    730.0f,257.0f,-394.0f,-1101.0f,-1607.0f,-2161.0f,-2779.0f,-3277.0f,
    -3976.0f,-4715.0f,-4948.0f,-5084.0f,-5325.0f,-5116.0f,-4739.0f,-4442.0f,
    -3960.0f,-3125.0f,-2161.0f,-1302.0f,-386.0f,514.0f,1148.0f,1694.0f,
    2409.0f,3156.0f,3397.0f,3549.0f,4433.0f,4746.0f,4457.0f,4907.0f,
    5156.0f,4417.0f,3790.0f,3710.0f,3027.0f,1831.0f,1204.0f,586.0f,
    -619.0f,-1695.0f,-2571.0f,-3358.0f,-3880.0f,-4097.0f,-4378.0f,-4329.0f,
    -3944.0f,-3992.0f,-3382.0f,-2081.0f,-1294.0f,-282.0f,1268.0f,2288.0f,
    3003.0f,3814.0f,4320.0f,4505.0f,4513.0f,4666.0f,4642.0f,3830.0f,
    3244.0f,2891.0f,1349.0f,-266.0f,-828.0f,-1655.0f,-3165.0f,-3647.0f,
    -3446.0f,-4345.0f,-5253.0f,-4787.0f,-4257.0f,-4297.0f,-3478.0f,-1800.0f,
    -796.0f,-217.0f,1164.0f,2409.0f,2682.0f,3212.0f,4240.0f,4328.0f,
    3879.0f,3879.0f,3590.0f,2272.0f,1124.0f,979.0f,281.0f,-844.0f,
    -940.0f,-1141.0f,-2185.0f,-2795.0f,-2803.0f,-3245.0f,-3719.0f,-3325.0f,
    -2787.0f,-2611.0f,-2024.0f,-1165.0f,-482.0f,562.0f,1590.0f,2015.0f,
    2626.0f,3501.0f,3686.0f,3790.0f,4344.0f,4417.0f,4047.0f,3951.0f,
    3806.0f,3389.0f,2867.0f,2465.0f,2120.0f,1389.0f,546.0f,48.0f,
    -515.0f,-1149.0f,-1374.0f,-1534.0f,-1896.0f,-2257.0f,-2386.0f,-2514.0f,
    -2627.0f,-2522.0f,-2619.0f,-2884.0f,-2988.0f,-3269.0f,-3647.0f,-3671.0f,
    -3679.0f,-3831.0f,-3615.0f,-3253.0f,-3109.0f,-2611.0f,-1791.0f,-932.0f,
    120.0f,1317.0f,2698.0f,3975.0f,4634.0f,5662.0f,6874.0f,6987.0f,
    6955.0f,7412.0f,6842.0f,5517.0f,4802.0f,3710.0f,1718.0f,96.0f,
    -1414.0f,-3221.0f,-4699.0f,-5783.0f,-6546.0f,-6763.0f,-6578.0f,-6096.0f,
    -5317.0f,-4105.0f,-2699.0f,-1350.0f,337.0f,2096.0f,3565.0f,4778.0f,
    5822.0f,6481.0f,6441.0f,5862.0f,5413.0f,4658.0f,3461.0f,2449.0f,
    1429.0f,-105.0f,-1518.0f,-2514.0f,-3534.0f,-4201.0f,-4378.0f,-4474.0f,
    -4402.0f,-4008.0f,-3558.0f,-2755.0f,-1912.0f,-1117.0f,-169.0f,345.0f,
    634.0f,1180.0f,1196.0f,955.0f,923.0f,425.0f,-306.0f,-836.0f,
    -1494.0f,-2081.0f,-2346.0f,-2571.0f,-2699.0f,-2635.0f,-2145.0f,-1462.0f,
    -972.0f,-201.0f,706.0f,1276.0f,1726.0f,2642.0f,3573.0f,3871.0f,
    4120.0f,4585.0f,4296.0f,3686.0f,3485.0f,2859.0f,1911.0f,1542.0f,
    1068.0f,0.0f,-394.0f,-330.0f,-988.0f,-1318.0f,-603.0f,-571.0f,
    -747.0f,-33.0f,514.0f,538.0f,522.0f,714.0f,923.0f,779.0f,
    690.0f,923.0f,706.0f,168.0f,-161.0f,-579.0f,-1302.0f,-1840.0f,
    -2169.0f,-2747.0f,-3293.0f,-3671.0f,-4313.0f,-5036.0f,-5237.0f,-5486.0f,
    -5831.0f,-5598.0f,-5076.0f,-4683.0f,-3912.0f,-2876.0f,-1912.0f,-651.0f,
    706.0f,1871.0f,3333.0f,4770.0f,5822.0f,6842.0f,7372.0f,7348.0f,
    7581.0f,7292.0f,6433.0f,6071.0f,5124.0f,3469.0f,2104.0f,787.0f,
    -980.0f,-2418.0f,-3358.0f,-4193.0f,-4884.0f,-5044.0f,-5068.0f,-5036.0f,
    -4498.0f,-3518.0f,-2571.0f,-1687.0f,-81.0f,1116.0f,1485.0f,2216.0f,
    3043.0f,2810.0f,2610.0f,2827.0f,2553.0f,1726.0f,1003.0f,297.0f,
    -595.0f,-1165.0f,-1615.0f,-2153.0f,-2378.0f,-2322.0f,-2538.0f,-2281.0f,
    -1462.0f,-812.0f,-539.0f,232.0f,1164.0f,1212.0f,1060.0f,1437.0f,
    1309.0f,305.0f,-410.0f,-868.0f,-2105.0f,-3663.0f,-4048.0f,-4546.0f,
    -5751.0f,-5944.0f,-5470.0f,-5534.0f,-5253.0f,-4080.0f,-2779.0f,-1840.0f,
    -611.0f,1285.0f,3059.0f,4288.0f,5670.0f,7461.0f,8537.0f,8706.0f,
    9059.0f,9276.0f,8352.0f,7420.0f,6802.0f,5244.0f,3413.0f,2208.0f,
    489.0f,-1526.0f,-2490.0f,-3165.0f,-4466.0f,-5012.0f,-4442.0f,-4570.0f,
    -4940.0f,-3992.0f,-3117.0f,-3157.0f,-2386.0f,-924.0f,-354.0f,-161.0f,
    754.0f,1381.0f,1148.0f,1236.0f,1558.0f,1188.0f,714.0f,530.0f,
    48.0f,-828.0f,-1406.0f,-1808.0f,-2707.0f,-3414.0f,-3510.0f,-3831.0f,
    -4305.0f,-4072.0f,-3687.0f,-3896.0f,-3647.0f,-2707.0f,-2314.0f,-1864.0f,
    -547.0f,570.0f,1156.0f,2072.0f,3148.0f,3838.0f,4200.0f,4810.0f,
    5605.0f,5589.0f,5260.0f,5581.0f,5517.0f,4409.0f,3943.0f,3943.0f,
    3067.0f,1951.0f,1774.0f,1397.0f,56.0f,-426.0f,-410.0f,-1205.0f,
    -1671.0f,-1302.0f,-1551.0f,-1783.0f,-1583.0f,-1575.0f,-1695.0f,-1486.0f,
    -1422.0f,-1920.0f,-1735.0f,-1623.0f,-2450.0f,-2691.0f,-2289.0f,-2587.0f,
    -3036.0f,-2731.0f,-2257.0f,-2281.0f,-2105.0f,-1085.0f,-386.0f,-145.0f,
    835.0f,1774.0f,2015.0f,2401.0f,3212.0f,3365.0f,2859.0f,3019.0f,
    2939.0f,1815.0f,867.0f,433.0f,-619.0f,-2201.0f,-3229.0f,-3952.0f,
    -5076.0f,-5879.0f,-6008.0f,-6112.0f,-6032.0f,-5598.0f,-4763.0f,-3663.0f,
    -2314.0f,-755.0f,1084.0f,2923.0f,4561.0f,6280.0f,7870.0f,8738.0f,
    9525.0f,10264.0f,10207.0f,9637.0f,9179.0f,8183.0f,6513.0f,5196.0f,
    3734.0f,1622.0f,-129.0f,-1414.0f,-3237.0f,-4715.0f,-5382.0f,-6112.0f,
    -6875.0f,-6626.0f,-6249.0f,-6434.0f,-5703.0f,-4699.0f,-4321.0f,-3470.0f,
    -2402.0f,-1719.0f,-1012.0f,-394.0f,72.0f,465.0f,578.0f,730.0f,
    722.0f,465.0f,369.0f,120.0f,-161.0f,-354.0f,-434.0f,-715.0f,
    -796.0f,-474.0f,-707.0f,-804.0f,-410.0f,-418.0f,-611.0f,-233.0f,
    40.0f,-193.0f,-89.0f,361.0f,192.0f,104.0f,562.0f,698.0f,
    811.0f,1156.0f,1558.0f,2056.0f,2401.0f,2594.0f,3059.0f,3662.0f,
    3638.0f,3646.0f,4280.0f,4095.0f,3437.0f,3509.0f,3501.0f,2570.0f,
    1839.0f,1678.0f,787.0f,-410.0f,-836.0f,-1510.0f,-2514.0f,-3036.0f,
    -3366.0f,-4121.0f,-4538.0f,-4570.0f,-4956.0f,-4884.0f,-4586.0f,-4707.0f,
    -4482.0f,-3944.0f,-3727.0f,-3285.0f,-2458.0f,-1856.0f,-1430.0f,-707.0f,
    248.0f,883.0f,1276.0f,2240.0f,2762.0f,2738.0f,3059.0f,3485.0f,
    3381.0f,2899.0f,2963.0f,2642.0f,1766.0f,1212.0f,787.0f,-193.0f,
    -1229.0f,-1703.0f,-2418.0f,-3374.0f,-3607.0f,-3719.0f,-4121.0f,-4048.0f,
    -3534.0f,-3093.0f,-2338.0f,-1237.0f,-25.0f,1373.0f,2618.0f,3951.0f,
    5493.0f,6617.0f,7364.0f,8151.0f,8722.0f,8481.0f,8055.0f,7702.0f,
    6625.0f,5316.0f,4240.0f,2722.0f,947.0f,-217.0f,-1735.0f,-3430.0f,
    -4305.0f,-5092.0f,-6185.0f,-6715.0f,-6522.0f,-6731.0f,-6948.0f,-6249.0f,
    -5663.0f,-5454.0f,-4659.0f,-3872.0f,-3358.0f,-2860.0f,-2362.0f,-1896.0f,
    -1647.0f,-1302.0f,-844.0f,-739.0f,-506.0f,-89.0f,257.0f,682.0f,
    1132.0f,1686.0f,1823.0f,2168.0f,2778.0f,2963.0f,3212.0f,3654.0f,
    3734.0f,3381.0f,3333.0f,3132.0f,2353.0f,1742.0f,1558.0f,851.0f,
    -249.0f,-699.0f,-988.0f,-1703.0f,-2000.0f,-1767.0f,-1454.0f,-1478.0f,
    -980.0f,289.0f,811.0f,1252.0f,2449.0f,3172.0f,3324.0f,3806.0f,
    4336.0f,4087.0f,3477.0f,3260.0f,2650.0f,1509.0f,779.0f,104.0f,
    -1237.0f,-2113.0f,-2490.0f,-3478.0f,-4602.0f,-4466.0f,-4185.0f,-5004.0f,
    -4964.0f,-4040.0f,-4105.0f,-4096.0f,-3261.0f,-2707.0f,-2571.0f,-2354.0f,
    -1623.0f,-1197.0f,-972.0f,-370.0f,72.0f,80.0f,305.0f,738.0f,
    1124.0f,1365.0f,1670.0f,2023.0f,1887.0f,2080.0f,2425.0f,2208.0f,
    2120.0f,2313.0f,2080.0f,1509.0f,1220.0f,963.0f,24.0f,-490.0f,
    -683.0f,-1583.0f,-2089.0f,-2081.0f,-2265.0f,-2370.0f,-1968.0f,-1269.0f,
    -643.0f,160.0f,1831.0f,3011.0f,3638.0f,5011.0f,6152.0f,6497.0f,
    6850.0f,7260.0f,7059.0f,6208.0f,5461.0f,4714.0f,3196.0f,1871.0f,
    714.0f,-996.0f,-2426.0f,-3374.0f,-4635.0f,-5904.0f,-6249.0f,-6498.0f,
    -7285.0f,-7140.0f,-6305.0f,-6273.0f,-5871.0f,-4884.0f,-4209.0f,-3759.0f,
    -3334.0f,-2554.0f,-2049.0f,-2016.0f,-1454.0f,-916.0f,-892.0f,-474.0f,
    152.0f,602.0f,787.0f,1333.0f,2088.0f,2280.0f,2762.0f,3606.0f,
    3903.0f,4096.0f,4489.0f,4513.0f,4304.0f,4280.0f,4055.0f,3292.0f,
    2698.0f,2023.0f,859.0f,64.0f,-482.0f,-1205.0f,-1647.0f,-1751.0f,
    -1735.0f,-1735.0f,-1261.0f,-330.0f,-25.0f,642.0f,1726.0f,2039.0f,
    2562.0f,3204.0f,3461.0f,3533.0f,3204.0f,2883.0f,2578.0f,1750.0f,
    939.0f,257.0f,-515.0f,-1342.0f,-2225.0f,-2892.0f,-3414.0f,-3872.0f,
    -4177.0f,-4225.0f,-3872.0f,-3815.0f,-3759.0f,-3165.0f,-2739.0f,-2474.0f,
    -2249.0f,-1695.0f,-1149.0f,-1133.0f,-836.0f,-394.0f,-418.0f,-490.0f,
    -354.0f,-137.0f,-57.0f,40.0f,409.0f,578.0f,562.0f,907.0f,
    1172.0f,1228.0f,1582.0f,1959.0f,1823.0f,1710.0f,1718.0f,1325.0f,
    851.0f,546.0f,80.0f,-378.0f,-659.0f,-836.0f,-812.0f,-739.0f,
    -611.0f,-225.0f,425.0f,1196.0f,1919.0f,2995.0f,4055.0f,4626.0f,
    5260.0f,5694.0f,5814.0f,5814.0f,5589.0f,5172.0f,4569.0f,3726.0f,
    2537.0f,1309.0f,192.0f,-1012.0f,-2362.0f,-3422.0f,-4072.0f,-5060.0f,
    -5735.0f,-5807.0f,-6008.0f,-6193.0f,-5799.0f,-5165.0f,-4747.0f,-4129.0f,
    -3422.0f,-2892.0f,-2530.0f,-2137.0f,-1647.0f,-1438.0f,-1229.0f,-892.0f,
    -892.0f,-892.0f,-731.0f,-571.0f,-330.0f,-97.0f,377.0f,771.0f,
    843.0f,1453.0f,1855.0f,2007.0f,2361.0f,2634.0f,2674.0f,2353.0f,
    2425.0f,2329.0f,1734.0f,1381.0f,1228.0f,955.0f,666.0f,674.0f,
    923.0f,1076.0f,1212.0f,1574.0f,2056.0f,2369.0f,2626.0f,2947.0f,
    3236.0f,3108.0f,2923.0f,2835.0f,2409.0f,1911.0f,1413.0f,771.0f,
    -17.0f,-876.0f,-1454.0f,-2097.0f,-2988.0f,-3317.0f,-3663.0f,-3976.0f,
    -3960.0f,-3960.0f,-3799.0f,-3607.0f,-3446.0f,-2916.0f,-2378.0f,-2105.0f,
    -1719.0f,-1141.0f,-868.0f,-804.0f,-595.0f,-249.0f,-217.0f,-249.0f,
    8.0f,32.0f,24.0f,64.0f,176.0f,248.0f,248.0f,393.0f,
    530.0f,634.0f,514.0f,409.0f,361.0f,80.0f,-298.0f,-442.0f,
    -739.0f,-1245.0f,-1390.0f,-1462.0f,-1446.0f,-1277.0f,-1261.0f,-707.0f,
    -17.0f,265.0f,995.0f,1959.0f,2505.0f,2891.0f,3646.0f,4353.0f,
    4553.0f,4698.0f,4947.0f,4794.0f,4610.0f,4272.0f,3590.0f,2987.0f,
    2385.0f,1574.0f,722.0f,152.0f,-563.0f,-1286.0f,-1719.0f,-2073.0f,
    -2490.0f,-2675.0f,-2699.0f,-2803.0f,-2795.0f,-2723.0f,-2667.0f,-2643.0f,
    -2707.0f,-2546.0f,-2482.0f,-2563.0f,-2458.0f,-2314.0f,-2314.0f,-2490.0f,
    -2506.0f,-2418.0f,-2466.0f,-2418.0f,-2105.0f,-1960.0f,-1840.0f,-1494.0f,
    -1157.0f,-884.0f,-603.0f,-274.0f,-169.0f,-41.0f,144.0f,152.0f,
    273.0f,361.0f,722.0f,923.0f,891.0f,1309.0f,1903.0f,2144.0f,
    2473.0f,3276.0f,3686.0f,3838.0f,4280.0f,4674.0f,4666.0f,4537.0f,
    4457.0f,4120.0f,3541.0f,3092.0f,2393.0f,1533.0f,666.0f,-41.0f,
    -844.0f,-1687.0f,-2169.0f,-2723.0f,-3229.0f,-3430.0f,-3566.0f,-3526.0f,
    -3165.0f,-3109.0f,-2715.0f,-2113.0f,-1992.0f,-1414.0f,-932.0f,-659.0f,
    -306.0f,-266.0f,40.0f,80.0f,-9.0f,200.0f,32.0f,-161.0f,
    -233.0f,-225.0f,-282.0f,-394.0f,-410.0f,-193.0f,-266.0f,-370.0f,
    -25.0f,-89.0f,-322.0f,-426.0f,-579.0f,-739.0f,-1221.0f,-1294.0f,
    -1350.0f,-1687.0f,-1671.0f,-1655.0f,-1559.0f,-1294.0f,-1020.0f,-474.0f,
    -65.0f,232.0f,931.0f,1558.0f,1983.0f,2497.0f,2899.0f,3148.0f,
    3180.0f,3228.0f,3196.0f,2634.0f,2337.0f,1999.0f,1421.0f,907.0f,
    602.0f,160.0f,-290.0f,-394.0f,-362.0f,-434.0f,-330.0f,104.0f,
    369.0f,787.0f,1132.0f,1309.0f,1855.0f,2031.0f,1943.0f,2337.0f,
    2288.0f,2039.0f,1774.0f,1333.0f,1132.0f,602.0f,-105.0f,-434.0f,
    -772.0f,-1438.0f,-1976.0f,-2209.0f,-2322.0f,-2868.0f,-3229.0f,-2852.0f,
    -3077.0f,-3510.0f,-3358.0f,-3301.0f,-3502.0f,-3687.0f,-3342.0f,-2980.0f,
    -3036.0f,-2635.0f,-1952.0f,-1518.0f,-1157.0f,-338.0f,578.0f,1003.0f,
    1558.0f,2433.0f,2987.0f,3236.0f,3678.0f,3975.0f,4015.0f,3830.0f,
    3670.0f,3469.0f,2859.0f,2513.0f,2088.0f,1301.0f,827.0f,417.0f,
    -225.0f,-627.0f,-780.0f,-988.0f,-1261.0f,-1213.0f,-1037.0f,-1045.0f,
    -908.0f,-555.0f,-266.0f,-97.0f,160.0f,425.0f,497.0f,473.0f,
    722.0f,674.0f,441.0f,546.0f,522.0f,305.0f,80.0f,8.0f,
    -17.0f,-249.0f,-418.0f,-274.0f,-346.0f,-627.0f,-563.0f,-675.0f,
    -988.0f,-1012.0f,-1157.0f,-1294.0f,-1277.0f,-1253.0f,-1181.0f,-1197.0f,
    -940.0f,-402.0f,-298.0f,-57.0f,690.0f,1060.0f,1260.0f,1590.0f,
    1943.0f,2144.0f,1967.0f,1919.0f,1983.0f,1493.0f,1044.0f,706.0f,
    8.0f,-675.0f,-1245.0f,-1984.0f,-2619.0f,-2916.0f,-3269.0f,-3623.0f,
    -3502.0f,-3325.0f,-3261.0f,-2731.0f,-2297.0f,-2032.0f,-1366.0f,-988.0f,
    -635.0f,-1.0f,385.0f,915.0f,1309.0f,1525.0f,2120.0f,2345.0f,
    2473.0f,2907.0f,3019.0f,3140.0f,3180.0f,3172.0f,3405.0f,3236.0f,
    3124.0f,3381.0f,3076.0f,2794.0f,2754.0f,2272.0f,1734.0f,1309.0f,
    779.0f,232.0f,-370.0f,-804.0f,-1085.0f,-1727.0f,-2016.0f,-1832.0f,
    -2249.0f,-2490.0f,-1896.0f,-1824.0f,-1968.0f,-1526.0f,-1012.0f,-892.0f,
    -908.0f,-547.0f,-169.0f,-450.0f,-434.0f,-137.0f,-426.0f,-603.0f,
    -635.0f,-908.0f,-1189.0f,-1342.0f,-1510.0f,-1791.0f,-1976.0f,-1928.0f,
    -2105.0f,-2161.0f,-1960.0f,-2024.0f,-1824.0f,-1534.0f,-1462.0f,-1020.0f,
    -675.0f,-458.0f,-65.0f,144.0f,618.0f,1019.0f,1156.0f,1702.0f,
    2080.0f,2128.0f,2337.0f,2369.0f,2393.0f,2288.0f,1879.0f,1839.0f,
    1622.0f,947.0f,642.0f,417.0f,-266.0f,-852.0f,-1109.0f,-1422.0f,
    -1880.0f,-2121.0f,-1968.0f,-2024.0f,-2089.0f,-1551.0f,-1117.0f,-868.0f,
    -121.0f,650.0f,1148.0f,1766.0f,2481.0f,3067.0f,3469.0f,3718.0f,
    4047.0f,4128.0f,3927.0f,3838.0f,3405.0f,2810.0f,2425.0f,1774.0f,
    939.0f,305.0f,-386.0f,-1189.0f,-1976.0f,-2563.0f,-3173.0f,-3751.0f,
    -4088.0f,-4386.0f,-4602.0f,-4643.0f,-4594.0f,-4554.0f,-4265.0f,-3936.0f,
    -3655.0f,-3358.0f,-2892.0f,-2322.0f,-1912.0f,-1470.0f,-812.0f,-241.0f,
    208.0f,714.0f,1124.0f,1373.0f,1566.0f,1646.0f,1566.0f,1542.0f,
    1381.0f,1060.0f,771.0f,578.0f,377.0f,56.0f,-113.0f,88.0f,
    88.0f,-73.0f,232.0f,746.0f,1052.0f,1333.0f,2064.0f,2843.0f,
    3140.0f,3549.0f,4232.0f,4618.0f,4778.0f,4842.0f,4850.0f,4706.0f,
    4344.0f,3863.0f,3268.0f,2570.0f,1879.0f,1084.0f,48.0f,-659.0f,
    -1382.0f,-2418.0f,-3157.0f,-3711.0f,-4337.0f,-4787.0f,-5181.0f,-5277.0f,
    -5213.0f,-5277.0f,-5092.0f,-4586.0f,-4129.0f,-3623.0f,-3101.0f,-2354.0f,
    -1446.0f,-956.0f,-282.0f,546.0f,1060.0f,1493.0f,1831.0f,2248.0f,
    2537.0f,2385.0f,2385.0f,2345.0f,1943.0f,1614.0f,1252.0f,706.0f,
    168.0f,-450.0f,-988.0f,-1518.0f,-2057.0f,-2314.0f,-2667.0f,-2980.0f,
    -2779.0f,-2546.0f,-2386.0f,-1896.0f,-1045.0f,-298.0f,232.0f,1156.0f,
    2064.0f,2481.0f,2947.0f,3381.0f,3533.0f,3573.0f,3533.0f,3260.0f,
    2859.0f,2465.0f,2064.0f,1453.0f,875.0f,505.0f,0.0f,-603.0f,
    -980.0f,-1061.0f,-1350.0f,-1567.0f,-1430.0f,-1302.0f,-1269.0f,-1141.0f,
    -796.0f,-482.0f,-121.0f,216.0f,425.0f,875.0f,1276.0f,1317.0f,
    1542.0f,1879.0f,1847.0f,1879.0f,1879.0f,1774.0f,1670.0f,1244.0f,
    979.0f,771.0f,192.0f,-298.0f,-643.0f,-1165.0f,-1791.0f,-2257.0f,
    -2715.0f,-3221.0f,-3542.0f,-3711.0f,-4000.0f,-4113.0f,-3815.0f,-3631.0f,
    -3599.0f,-3004.0f,-2169.0f,-1655.0f,-996.0f,-1.0f,923.0f,1421.0f,
    1782.0f,2393.0f,2754.0f,2658.0f,2802.0f,2891.0f,2666.0f,2433.0f,
    2200.0f,1799.0f,1429.0f,1068.0f,650.0f,385.0f,208.0f,0.0f,
    -105.0f,-89.0f,-81.0f,-1.0f,120.0f,257.0f,481.0f,658.0f,
    811.0f,1052.0f,1276.0f,1525.0f,1726.0f,1823.0f,1975.0f,2048.0f,
    1991.0f,2056.0f,1975.0f,1750.0f,1542.0f,1252.0f,939.0f,473.0f,
    -57.0f,-466.0f,-988.0f,-1663.0f,-2177.0f,-2683.0f,-3245.0f,-3719.0f,
    -4000.0f,-4169.0f,-4402.0f,-4394.0f,-4000.0f,-3679.0f,-3350.0f,-2490.0f,
    -1607.0f,-980.0f,-362.0f,489.0f,1188.0f,1413.0f,1879.0f,2369.0f,
    2393.0f,2489.0f,2682.0f,2481.0f,2385.0f,2321.0f,2064.0f,1815.0f,
    1558.0f,1349.0f,1052.0f,779.0f,690.0f,457.0f,281.0f,168.0f,
    -89.0f,-209.0f,-338.0f,-579.0f,-651.0f,-763.0f,-924.0f,-996.0f,
    -1037.0f,-956.0f,-948.0f,-860.0f,-627.0f,-547.0f,-386.0f,-137.0f,
    -73.0f,72.0f,208.0f,240.0f,345.0f,192.0f,112.0f,160.0f,
    -145.0f,-362.0f,-402.0f,-667.0f,-924.0f,-1109.0f,-1245.0f,-1310.0f,
    -1462.0f,-1462.0f,-1310.0f,-1237.0f,-1061.0f,-884.0f,-498.0f,-9.0f,
    248.0f,674.0f,1244.0f,1630.0f,1951.0f,2184.0f,2449.0f,2722.0f,
    2754.0f,2722.0f,2762.0f,2706.0f,2513.0f,2288.0f,2112.0f,1903.0f,
    1550.0f,1228.0f,987.0f,634.0f,200.0f,-25.0f,-394.0f,-788.0f,
    -1029.0f,-1470.0f,-1864.0f,-2049.0f,-2297.0f,-2611.0f,-2868.0f,-2900.0f,
    -2924.0f,-3052.0f,-2884.0f,-2603.0f,-2394.0f,-2081.0f,-1695.0f,-1245.0f,
    -820.0f,-531.0f,-201.0f,120.0f,345.0f,449.0f,554.0f,722.0f,
    746.0f,634.0f,626.0f,473.0f,192.0f,88.0f,-129.0f,-298.0f,
    -241.0f,-394.0f,-555.0f,-322.0f,-193.0f,-201.0f,224.0f,722.0f,
    915.0f,1252.0f,1750.0f,2088.0f,2264.0f,2465.0f,2746.0f,2827.0f,
    2778.0f,2802.0f,2666.0f,2473.0f,2296.0f,1975.0f,1662.0f,1381.0f,
    1011.0f,642.0f,257.0f,-177.0f,-723.0f,-1125.0f,-1454.0f,-1767.0f,
    -2000.0f,-2257.0f,-2563.0f,-2707.0f,-2795.0f,-2988.0f,-3085.0f,-3004.0f,
    -2892.0f,-2828.0f,-2611.0f,-2249.0f,-1904.0f,-1494.0f,-1085.0f,-699.0f,
    -249.0f,88.0f,313.0f,578.0f,738.0f,819.0f,835.0f,787.0f,
    779.0f,674.0f,457.0f,313.0f,152.0f,-73.0f,-306.0f,-434.0f,
    -539.0f,-635.0f,-675.0f,-627.0f,-466.0f,-306.0f,-145.0f,208.0f,
    554.0f,803.0f,1084.0f,1429.0f,1718.0f,1847.0f,1887.0f,2047.0f,
    2072.0f,1943.0f,1863.0f,1710.0f,1558.0f,1429.0f,1156.0f,915.0f,
    754.0f,514.0f,200.0f,-65.0f,-282.0f,-547.0f,-828.0f,-1020.0f,
    -1157.0f,-1334.0f,-1494.0f,-1599.0f,-1639.0f,-1687.0f,-1759.0f,-1759.0f,
    -1663.0f,-1575.0f,-1510.0f,-1422.0f,-1245.0f,-964.0f,-739.0f,-547.0f,
    -274.0f,8.0f,192.0f,337.0f,546.0f,714.0f,771.0f,851.0f,
    995.0f,1028.0f,939.0f,1003.0f,995.0f,819.0f,706.0f,626.0f,
    546.0f,433.0f,377.0f,337.0f,232.0f,224.0f,265.0f,273.0f,
    305.0f,449.0f,602.0f,610.0f,682.0f,819.0f,891.0f,811.0f,
    746.0f,787.0f,714.0f,674.0f,586.0f,505.0f,554.0f,473.0f,
    329.0f,289.0f,240.0f,144.0f,-25.0f,-137.0f,-217.0f,-386.0f,
    -547.0f,-667.0f,-772.0f,-796.0f,-924.0f,-1037.0f,-1004.0f,-1045.0f,
    -1077.0f,-1101.0f,-1029.0f,-940.0f,-860.0f,-747.0f,-627.0f,-482.0f,
    -346.0f,-249.0f,-161.0f,-41.0f,96.0f,136.0f,152.0f,273.0f,
    353.0f,353.0f,361.0f,337.0f,385.0f,433.0f,345.0f,425.0f,
    449.0f,337.0f,297.0f,281.0f,281.0f,289.0f,216.0f,240.0f,
    248.0f,232.0f,240.0f,168.0f,216.0f,313.0f,313.0f,321.0f,
    393.0f,465.0f,441.0f,377.0f,449.0f,538.0f,586.0f,538.0f,
    505.0f,610.0f,602.0f,530.0f,489.0f,457.0f,465.0f,385.0f,
    265.0f,257.0f,176.0f,40.0f,-81.0f,-113.0f,-153.0f,-258.0f,
    -298.0f,-338.0f,-418.0f,-466.0f,-539.0f,-587.0f,-563.0f,-555.0f,
    -611.0f,-587.0f,-531.0f,-506.0f,-474.0f,-474.0f,-490.0f,-458.0f,
    -458.0f,-498.0f,-482.0f,-450.0f,-426.0f,-434.0f,-482.0f,-434.0f,
    -402.0f,-378.0f,-306.0f,-233.0f,-193.0f,-217.0f,-258.0f,-258.0f,
    -282.0f,-298.0f,-241.0f,-177.0f,-201.0f,-193.0f,-121.0f,-73.0f,
    0.0f,72.0f,200.0f,345.0f,449.0f,546.0f,674.0f,835.0f,
    899.0f,939.0f,1028.0f,1076.0f,1084.0f,1019.0f,971.0f,979.0f,
    947.0f,875.0f,795.0f,746.0f,738.0f,634.0f,546.0f,530.0f,
    473.0f,441.0f,329.0f,265.0f,248.0f,200.0f,152.0f,56.0f,
    40.0f,8.0f,-73.0f,-121.0f,-177.0f,-233.0f,-298.0f,-362.0f,
    -450.0f,-555.0f,-619.0f,-659.0f,-755.0f,-812.0f,-820.0f,-900.0f,
    -988.0f,-988.0f,-988.0f,-1020.0f,-1012.0f,-948.0f,-892.0f,-860.0f,
    -812.0f,-739.0f,-707.0f,-635.0f,-555.0f,-498.0f,-386.0f,-314.0f,
    -258.0f,-201.0f,-153.0f,-97.0f,-25.0f,104.0f,184.0f,200.0f,
    265.0f,321.0f,337.0f,377.0f,409.0f,441.0f,481.0f,538.0f,
    570.0f,570.0f,562.0f,538.0f,522.0f,530.0f,505.0f,489.0f,
    530.0f,562.0f,618.0f,642.0f,634.0f,706.0f,722.0f,682.0f,
    698.0f,714.0f,690.0f,634.0f,586.0f,489.0f,393.0f,313.0f,
    224.0f,104.0f,-9.0f,-113.0f,-201.0f,-249.0f,-330.0f,-386.0f,
    -426.0f,-482.0f,-506.0f,-531.0f,-563.0f,-555.0f,-539.0f,-531.0f,
    -498.0f,-434.0f,-378.0f,-346.0f,-338.0f,-290.0f,-282.0f,-290.0f,
    -249.0f,-201.0f,-185.0f,-153.0f,-73.0f,-33.0f,-65.0f,-81.0f,
    -89.0f,-129.0f,-137.0f,-137.0f,-137.0f,-193.0f,-225.0f,-225.0f,
    -266.0f,-306.0f,-322.0f,-322.0f,-370.0f,-386.0f,-394.0f,-434.0f,
    -434.0f,-450.0f,-474.0f,-490.0f,-458.0f,-418.0f,-410.0f,-418.0f,
    -386.0f,-354.0f,-370.0f,-338.0f,-330.0f,-306.0f,-241.0f,-225.0f,
    -169.0f,-145.0f,-89.0f,8.0f,96.0f,216.0f,297.0f,425.0f,
    514.0f,586.0f,674.0f,714.0f,754.0f,803.0f,803.0f,787.0f,
    787.0f,771.0f,714.0f,642.0f,554.0f,481.0f,433.0f,369.0f,
    289.0f,248.0f,184.0f,72.0f,16.0f,-1.0f,-33.0f,-73.0f,
    -97.0f,-81.0f,-89.0f,-89.0f,-105.0f,-129.0f,-137.0f,-145.0f,
    -145.0f,-153.0f,-129.0f,-137.0f,-145.0f,-169.0f,-209.0f,-225.0f,
    -290.0f,-354.0f,-370.0f,-402.0f,-442.0f,-450.0f,-442.0f,-498.0f,
    -498.0f,-466.0f,-474.0f,-442.0f,-394.0f,-362.0f,-338.0f,-274.0f,
    -209.0f,-177.0f,-81.0f,-9.0f,16.0f,80.0f,152.0f,216.0f,
    232.0f,248.0f,289.0f,297.0f,289.0f,273.0f,257.0f,216.0f,
    184.0f,160.0f,128.0f,120.0f,112.0f,96.0f,64.0f,24.0f,
    32.0f,-1.0f,-25.0f,0.0f,-1.0f,-9.0f,-1.0f,-9.0f,
    0
}; t_CKUINT dope_size = 10240;

// data for eee.raw...
SAMPLE eee_data[] = {
    -458.0f,746.0f,297.0f,1807.0f,4160.0f,3879.0f,3646.0f,5204.0f,
    4802.0f,4385.0f,5951.0f,5662.0f,4497.0f,4425.0f,4031.0f,3493.0f,
    3389.0f,2497.0f,1317.0f,971.0f,-137.0f,-1334.0f,-1486.0f,-2137.0f,
    -2820.0f,-2996.0f,-3647.0f,-4474.0f,-4570.0f,-4402.0f,-4795.0f,-5542.0f,
    -5871.0f,-5044.0f,-5181.0f,-6618.0f,-5341.0f,-2948.0f,-4410.0f,-5622.0f,
    -2057.0f,-627.0f,-3068.0f,-1093.0f,2883.0f,987.0f,-322.0f,4417.0f,
    5895.0f,2730.0f,4216.0f,7501.0f,5589.0f,4449.0f,7388.0f,7453.0f,
    5204.0f,5581.0f,6232.0f,4995.0f,4248.0f,3766.0f,2730.0f,2248.0f,
    875.0f,-772.0f,-788.0f,-2000.0f,-5422.0f,-6546.0f,-5373.0f,-6795.0f,
    -9036.0f,-7911.0f,-7775.0f,-10987.0f,-10891.0f,-7630.0f,-8538.0f,-11052.0f,
    -8996.0f,-7301.0f,-8538.0f,-7197.0f,-4940.0f,-5261.0f,-5181.0f,-3117.0f,
    -1237.0f,-635.0f,-394.0f,-458.0f,
    0
}; t_CKUINT eee_size = 92;

// data for fwavblnk.raw...
SAMPLE fwavblnk_data[] = {
    0.0f,1606.0f,3212.0f,4802.0f,6392.0f,7967.0f,9509.0f,11035.0f,
    12536.0f,14014.0f,15444.0f,16841.0f,18207.0f,19516.0f,20785.0f,22005.0f,
    23170.0f,24278.0f,25330.0f,26318.0f,27242.0f,28109.0f,28896.0f,29619.0f,
    30278.0f,30848.0f,31354.0f,31788.0f,32141.0f,32414.0f,32615.0f,32727.0f,
    32767.0f,32727.0f,32615.0f,32414.0f,32141.0f,31788.0f,31354.0f,30848.0f,
    30278.0f,29619.0f,28896.0f,28109.0f,27242.0f,26318.0f,25330.0f,24278.0f,
    23170.0f,22005.0f,20785.0f,19516.0f,18207.0f,16841.0f,15444.0f,14014.0f,
    12536.0f,11035.0f,9509.0f,7967.0f,6392.0f,4802.0f,3212.0f,1606.0f,
    0.0f,1606.0f,3212.0f,4802.0f,6392.0f,7967.0f,9509.0f,11035.0f,
    12536.0f,14014.0f,15444.0f,16841.0f,18207.0f,19516.0f,20785.0f,22005.0f,
    23170.0f,24278.0f,25330.0f,26318.0f,27242.0f,28109.0f,28896.0f,29619.0f,
    30278.0f,30848.0f,31354.0f,31788.0f,32141.0f,32414.0f,32615.0f,32727.0f,
    32767.0f,32727.0f,32615.0f,32414.0f,32141.0f,31788.0f,31354.0f,30848.0f,
    30278.0f,29619.0f,28896.0f,28109.0f,27242.0f,26318.0f,25330.0f,24278.0f,
    23170.0f,22005.0f,20785.0f,19516.0f,18207.0f,16841.0f,15444.0f,14014.0f,
    12536.0f,11035.0f,9509.0f,7967.0f,6392.0f,4802.0f,3212.0f,1606.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT fwavblnk_size = 256;

// data for halfwave.raw...
SAMPLE halfwave_data[] = {
    0.0f,803.0f,1606.0f,2409.0f,3212.0f,4015.0f,4802.0f,5605.0f,
    6392.0f,7180.0f,7967.0f,8738.0f,9509.0f,10272.0f,11035.0f,11798.0f,
    12536.0f,13275.0f,14014.0f,14729.0f,15444.0f,16151.0f,16841.0f,17532.0f,
    18207.0f,18865.0f,19516.0f,20158.0f,20785.0f,21403.0f,22005.0f,22592.0f,
    23170.0f,23732.0f,24278.0f,24808.0f,25330.0f,25828.0f,26318.0f,26784.0f,
    27242.0f,27684.0f,28109.0f,28511.0f,28896.0f,29266.0f,29619.0f,29957.0f,
    30278.0f,30575.0f,30848.0f,31113.0f,31354.0f,31579.0f,31788.0f,31972.0f,
    32141.0f,32286.0f,32414.0f,32527.0f,32615.0f,32679.0f,32727.0f,32759.0f,
    32767.0f,32759.0f,32727.0f,32679.0f,32615.0f,32527.0f,32414.0f,32286.0f,
    32141.0f,31972.0f,31788.0f,31579.0f,31354.0f,31113.0f,30848.0f,30575.0f,
    30278.0f,29957.0f,29619.0f,29266.0f,28896.0f,28511.0f,28109.0f,27684.0f,
    27242.0f,26784.0f,26318.0f,25828.0f,25330.0f,24808.0f,24278.0f,23732.0f,
    23170.0f,22592.0f,22005.0f,21403.0f,20785.0f,20158.0f,19516.0f,18865.0f,
    18207.0f,17532.0f,16841.0f,16151.0f,15444.0f,14729.0f,14014.0f,13275.0f,
    12536.0f,11798.0f,11035.0f,10272.0f,9509.0f,8738.0f,7967.0f,7180.0f,
    6392.0f,5605.0f,4802.0f,4015.0f,3212.0f,2409.0f,1606.0f,803.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT halfwave_size = 256;

// data for impuls10.raw...
SAMPLE impuls10_data[] = {
    32767.0f,32390.0f,31266.0f,29443.0f,27001.0f,24021.0f,20624.0f,16938.0f,
    13099.0f,9252.0f,5525.0f,2039.0f,-1093.0f,-3775.0f,-5952.0f,-7566.0f,
    -8618.0f,-9116.0f,-9092.0f,-8610.0f,-7735.0f,-6554.0f,-5173.0f,-3687.0f,
    -2185.0f,-772.0f,473.0f,1509.0f,2264.0f,2722.0f,2875.0f,2730.0f,
    2313.0f,1670.0f,851.0f,-81.0f,-1077.0f,-2049.0f,-2948.0f,-3727.0f,
    -4321.0f,-4723.0f,-4916.0f,-4876.0f,-4635.0f,-4209.0f,-3639.0f,-2956.0f,
    -2209.0f,-1462.0f,-747.0f,-113.0f,393.0f,762.0f,955.0f,979.0f,
    835.0f,530.0f,88.0f,-442.0f,-1045.0f,-1671.0f,-2265.0f,-2820.0f,
    -3277.0f,-3615.0f,-3823.0f,-3880.0f,-3783.0f,-3558.0f,-3205.0f,-2763.0f,
    -2249.0f,-1719.0f,-1181.0f,-691.0f,-266.0f,56.0f,265.0f,345.0f,
    289.0f,112.0f,-169.0f,-547.0f,-996.0f,-1478.0f,-1960.0f,-2418.0f,
    -2811.0f,-3133.0f,-3350.0f,-3454.0f,-3430.0f,-3293.0f,-3052.0f,-2715.0f,
    -2314.0f,-1880.0f,-1422.0f,-988.0f,-603.0f,-282.0f,-57.0f,56.0f,
    64.0f,-33.0f,-241.0f,-547.0f,-916.0f,-1334.0f,-1767.0f,-2177.0f,
    -2563.0f,-2884.0f,-3125.0f,-3261.0f,-3293.0f,-3213.0f,-3036.0f,-2755.0f,
    -2410.0f,-2024.0f,-1599.0f,-1181.0f,-796.0f,-458.0f,-209.0f,-49.0f,
    0.0f,-49.0f,-209.0f,-458.0f,-796.0f,-1181.0f,-1599.0f,-2024.0f,
    -2410.0f,-2755.0f,-3036.0f,-3213.0f,-3293.0f,-3261.0f,-3125.0f,-2884.0f,
    -2563.0f,-2177.0f,-1767.0f,-1334.0f,-916.0f,-547.0f,-241.0f,-33.0f,
    64.0f,56.0f,-57.0f,-282.0f,-603.0f,-988.0f,-1422.0f,-1880.0f,
    -2314.0f,-2715.0f,-3052.0f,-3293.0f,-3430.0f,-3454.0f,-3350.0f,-3133.0f,
    -2811.0f,-2418.0f,-1960.0f,-1478.0f,-996.0f,-547.0f,-169.0f,112.0f,
    289.0f,345.0f,265.0f,56.0f,-266.0f,-691.0f,-1181.0f,-1719.0f,
    -2249.0f,-2763.0f,-3205.0f,-3558.0f,-3783.0f,-3880.0f,-3823.0f,-3615.0f,
    -3277.0f,-2820.0f,-2265.0f,-1671.0f,-1045.0f,-442.0f,88.0f,530.0f,
    835.0f,979.0f,955.0f,762.0f,393.0f,-113.0f,-747.0f,-1462.0f,
    -2209.0f,-2956.0f,-3639.0f,-4209.0f,-4635.0f,-4876.0f,-4916.0f,-4723.0f,
    -4321.0f,-3727.0f,-2948.0f,-2049.0f,-1077.0f,-81.0f,851.0f,1670.0f,
    2313.0f,2730.0f,2875.0f,2722.0f,2264.0f,1509.0f,473.0f,-772.0f,
    -2185.0f,-3687.0f,-5173.0f,-6554.0f,-7735.0f,-8610.0f,-9092.0f,-9116.0f,
    -8618.0f,-7566.0f,-5952.0f,-3775.0f,-1093.0f,2039.0f,5525.0f,9252.0f,
    13099.0f,16938.0f,20624.0f,24021.0f,27001.0f,29443.0f,31266.0f,32390.0f,
    0
}; t_CKUINT impuls10_size = 256;

// data for impuls20.raw...
SAMPLE impuls20_data[] = {
    32767.0f,31370.0f,27378.0f,21395.0f,14279.0f,7003.0f,538.0f,-4362.0f,
    -7277.0f,-8128.0f,-7173.0f,-4964.0f,-2169.0f,489.0f,2481.0f,3445.0f,
    3300.0f,2200.0f,522.0f,-1294.0f,-2828.0f,-3743.0f,-3888.0f,-3285.0f,
    -2145.0f,-788.0f,465.0f,1325.0f,1614.0f,1293.0f,489.0f,-571.0f,
    -1639.0f,-2442.0f,-2811.0f,-2675.0f,-2105.0f,-1253.0f,-330.0f,417.0f,
    843.0f,843.0f,433.0f,-249.0f,-1053.0f,-1767.0f,-2217.0f,-2314.0f,
    -2048.0f,-1486.0f,-780.0f,-113.0f,361.0f,530.0f,369.0f,-73.0f,
    -691.0f,-1318.0f,-1808.0f,-2040.0f,-1968.0f,-1615.0f,-1077.0f,-490.0f,
    0.0f,281.0f,281.0f,16.0f,-442.0f,-988.0f,-1486.0f,-1808.0f,
    -1880.0f,-1687.0f,-1286.0f,-780.0f,-290.0f,48.0f,176.0f,56.0f,
    -266.0f,-731.0f,-1213.0f,-1583.0f,-1767.0f,-1711.0f,-1438.0f,-1012.0f,
    -547.0f,-153.0f,64.0f,64.0f,-145.0f,-523.0f,-972.0f,-1374.0f,
    -1639.0f,-1695.0f,-1543.0f,-1205.0f,-772.0f,-362.0f,-65.0f,40.0f,
    -57.0f,-354.0f,-755.0f,-1173.0f,-1502.0f,-1655.0f,-1607.0f,-1358.0f,
    -980.0f,-563.0f,-217.0f,-9.0f,-9.0f,-209.0f,-555.0f,-972.0f,
    -1342.0f,-1583.0f,-1639.0f,-1486.0f,-1173.0f,-763.0f,-378.0f,-97.0f,
    0.0f,-97.0f,-378.0f,-763.0f,-1173.0f,-1486.0f,-1639.0f,-1583.0f,
    -1342.0f,-972.0f,-555.0f,-209.0f,-9.0f,-9.0f,-217.0f,-563.0f,
    -980.0f,-1358.0f,-1607.0f,-1655.0f,-1502.0f,-1173.0f,-755.0f,-354.0f,
    -57.0f,40.0f,-65.0f,-362.0f,-772.0f,-1205.0f,-1543.0f,-1695.0f,
    -1639.0f,-1374.0f,-972.0f,-523.0f,-145.0f,64.0f,64.0f,-153.0f,
    -547.0f,-1012.0f,-1438.0f,-1711.0f,-1767.0f,-1583.0f,-1213.0f,-731.0f,
    -266.0f,56.0f,176.0f,48.0f,-290.0f,-780.0f,-1286.0f,-1687.0f,
    -1880.0f,-1808.0f,-1486.0f,-988.0f,-442.0f,16.0f,281.0f,281.0f,
    0.0f,-490.0f,-1077.0f,-1615.0f,-1968.0f,-2040.0f,-1808.0f,-1318.0f,
    -691.0f,-73.0f,369.0f,530.0f,361.0f,-113.0f,-780.0f,-1486.0f,
    -2048.0f,-2314.0f,-2217.0f,-1767.0f,-1053.0f,-249.0f,433.0f,843.0f,
    843.0f,417.0f,-330.0f,-1253.0f,-2105.0f,-2675.0f,-2811.0f,-2442.0f,
    -1639.0f,-571.0f,489.0f,1293.0f,1614.0f,1325.0f,465.0f,-788.0f,
    -2145.0f,-3285.0f,-3888.0f,-3743.0f,-2828.0f,-1294.0f,522.0f,2200.0f,
    3300.0f,3445.0f,2481.0f,489.0f,-2169.0f,-4964.0f,-7173.0f,-8128.0f,
    -7277.0f,-4362.0f,538.0f,7003.0f,14279.0f,21395.0f,27378.0f,31370.0f,
    0
}; t_CKUINT impuls20_size = 256;

// data for impuls40.raw...
SAMPLE impuls40_data[] = {
    32767.0f,27563.0f,14850.0f,1357.0f,-6594.0f,-6867.0f,-2153.0f,2570.0f,
    3750.0f,1301.0f,-2057.0f,-3446.0f,-2065.0f,489.0f,1927.0f,1196.0f,
    -820.0f,-2241.0f,-1944.0f,-338.0f,1036.0f,1036.0f,-217.0f,-1534.0f,
    -1759.0f,-788.0f,441.0f,835.0f,104.0f,-1029.0f,-1551.0f,-1037.0f,
    0.0f,610.0f,281.0f,-635.0f,-1310.0f,-1149.0f,-338.0f,369.0f,
    353.0f,-330.0f,-1061.0f,-1181.0f,-603.0f,120.0f,345.0f,-113.0f,
    -820.0f,-1133.0f,-788.0f,-113.0f,265.0f,32.0f,-587.0f,-1037.0f,
    -908.0f,-338.0f,144.0f,120.0f,-378.0f,-900.0f,-964.0f,-531.0f,
    0.0f,144.0f,-201.0f,-739.0f,-964.0f,-683.0f,-161.0f,120.0f,
    -73.0f,-563.0f,-908.0f,-796.0f,-330.0f,48.0f,8.0f,-402.0f,
    -820.0f,-860.0f,-490.0f,-57.0f,48.0f,-249.0f,-699.0f,-876.0f,
    -627.0f,-185.0f,40.0f,-129.0f,-563.0f,-844.0f,-731.0f,-322.0f,
    0.0f,-41.0f,-418.0f,-780.0f,-804.0f,-466.0f,-81.0f,0.0f,
    -282.0f,-683.0f,-828.0f,-595.0f,-185.0f,8.0f,-161.0f,-563.0f,
    -820.0f,-699.0f,-314.0f,-17.0f,-73.0f,-434.0f,-763.0f,-772.0f,
    -450.0f,-81.0f,-17.0f,-306.0f,-683.0f,-812.0f,-571.0f,-185.0f,
    0.0f,-185.0f,-571.0f,-812.0f,-683.0f,-306.0f,-17.0f,-81.0f,
    -450.0f,-772.0f,-763.0f,-434.0f,-73.0f,-17.0f,-314.0f,-699.0f,
    -820.0f,-563.0f,-161.0f,8.0f,-185.0f,-595.0f,-828.0f,-683.0f,
    -282.0f,0.0f,-81.0f,-466.0f,-804.0f,-780.0f,-418.0f,-41.0f,
    0.0f,-322.0f,-731.0f,-844.0f,-563.0f,-129.0f,40.0f,-185.0f,
    -627.0f,-876.0f,-699.0f,-249.0f,48.0f,-57.0f,-490.0f,-860.0f,
    -820.0f,-402.0f,8.0f,48.0f,-330.0f,-796.0f,-908.0f,-563.0f,
    -73.0f,120.0f,-161.0f,-683.0f,-964.0f,-739.0f,-201.0f,144.0f,
    0.0f,-531.0f,-964.0f,-900.0f,-378.0f,120.0f,144.0f,-338.0f,
    -908.0f,-1037.0f,-587.0f,32.0f,265.0f,-113.0f,-788.0f,-1133.0f,
    -820.0f,-113.0f,345.0f,120.0f,-603.0f,-1181.0f,-1061.0f,-330.0f,
    353.0f,369.0f,-338.0f,-1149.0f,-1310.0f,-635.0f,281.0f,610.0f,
    0.0f,-1037.0f,-1551.0f,-1029.0f,104.0f,835.0f,441.0f,-788.0f,
    -1759.0f,-1534.0f,-217.0f,1036.0f,1036.0f,-338.0f,-1944.0f,-2241.0f,
    -820.0f,1196.0f,1927.0f,489.0f,-2065.0f,-3446.0f,-2057.0f,1301.0f,
    3750.0f,2570.0f,-2153.0f,-6867.0f,-6594.0f,1357.0f,14850.0f,27563.0f,
    0
}; t_CKUINT impuls40_size = 256;

// data for mand10.raw...
SAMPLE mand10_data[] = {
    0.0f,224.0f,-73.0f,-611.0f,-474.0f,-1069.0f,-1294.0f,-1671.0f,
    -1615.0f,128.0f,1060.0f,1212.0f,1525.0f,1815.0f,1060.0f,1301.0f,
    1887.0f,1132.0f,674.0f,393.0f,240.0f,216.0f,947.0f,1638.0f,
    2072.0f,2441.0f,2080.0f,1774.0f,1670.0f,1076.0f,562.0f,-498.0f,
    -1623.0f,-1502.0f,-1735.0f,-2129.0f,-2129.0f,-2683.0f,-3494.0f,-3109.0f,
    -2418.0f,-2386.0f,-2988.0f,-3655.0f,-3864.0f,-3502.0f,-2603.0f,-2795.0f,
    -2820.0f,-964.0f,514.0f,281.0f,-667.0f,-828.0f,184.0f,1437.0f,
    2120.0f,1558.0f,1044.0f,1855.0f,2859.0f,3059.0f,2827.0f,2802.0f,
    2786.0f,2819.0f,3276.0f,3887.0f,3798.0f,2859.0f,1983.0f,1694.0f,
    1766.0f,1943.0f,1790.0f,955.0f,32.0f,-145.0f,144.0f,827.0f,
    1268.0f,771.0f,-81.0f,-1004.0f,-1518.0f,-1655.0f,-2193.0f,-2651.0f,
    -2836.0f,-2538.0f,-1543.0f,-1149.0f,-1310.0f,-1518.0f,-1808.0f,-2049.0f,
    -2394.0f,-2651.0f,-2884.0f,-2956.0f,-2554.0f,-1824.0f,-1189.0f,-1157.0f,
    -1318.0f,-755.0f,321.0f,1164.0f,1469.0f,1389.0f,1501.0f,1670.0f,
    1477.0f,1236.0f,714.0f,176.0f,144.0f,353.0f,915.0f,1357.0f,
    1445.0f,1453.0f,1421.0f,1566.0f,1959.0f,1847.0f,1437.0f,1301.0f,
    1011.0f,722.0f,714.0f,995.0f,1188.0f,867.0f,64.0f,-523.0f,
    -691.0f,-780.0f,-844.0f,-1157.0f,-1326.0f,-1117.0f,-916.0f,-892.0f,
    -1077.0f,-1342.0f,-1591.0f,-1703.0f,-1767.0f,-1800.0f,-1767.0f,-1968.0f,
    -2257.0f,-2185.0f,-1743.0f,-1053.0f,-643.0f,-659.0f,-169.0f,353.0f,
    682.0f,1172.0f,1606.0f,2120.0f,2048.0f,1726.0f,1879.0f,2120.0f,
    2152.0f,2047.0f,1935.0f,1887.0f,2120.0f,2168.0f,1734.0f,1654.0f,
    1871.0f,1638.0f,1309.0f,995.0f,819.0f,787.0f,393.0f,-241.0f,
    -651.0f,-547.0f,-579.0f,-900.0f,-1037.0f,-1205.0f,-1261.0f,-1213.0f,
    -1318.0f,-1245.0f,-1318.0f,-1639.0f,-1904.0f,-2008.0f,-1968.0f,-2008.0f,
    -2065.0f,-2089.0f,-2073.0f,-2105.0f,-2273.0f,-2506.0f,-2394.0f,-2049.0f,
    -1526.0f,-948.0f,-539.0f,-97.0f,361.0f,586.0f,578.0f,698.0f,
    939.0f,1196.0f,1413.0f,1574.0f,1694.0f,1525.0f,1333.0f,1574.0f,
    2031.0f,2232.0f,2168.0f,2160.0f,2176.0f,2096.0f,1951.0f,1638.0f,
    1333.0f,1156.0f,1011.0f,915.0f,875.0f,803.0f,610.0f,313.0f,
    48.0f,-65.0f,-161.0f,-474.0f,-852.0f,-1077.0f,-1197.0f,-1173.0f,
    -1149.0f,-1101.0f,-1029.0f,-1061.0f,-1069.0f,-1037.0f,-996.0f,-1061.0f,
    -1237.0f,-1294.0f,-1197.0f,-1189.0f,-1286.0f,-1318.0f,-1061.0f,-595.0f,
    -241.0f,-9.0f,176.0f,321.0f,377.0f,417.0f,562.0f,730.0f,
    754.0f,658.0f,602.0f,690.0f,787.0f,762.0f,690.0f,578.0f,
    546.0f,554.0f,546.0f,562.0f,409.0f,224.0f,112.0f,32.0f,
    72.0f,64.0f,-81.0f,-225.0f,-282.0f,-274.0f,-274.0f,-346.0f,
    -474.0f,-547.0f,-515.0f,-474.0f,-498.0f,-523.0f,-555.0f,-579.0f,
    -555.0f,-539.0f,-506.0f,-531.0f,-547.0f,-442.0f,-314.0f,-201.0f,
    -153.0f,-137.0f,-65.0f,-33.0f,-81.0f,-41.0f,160.0f,417.0f,
    546.0f,562.0f,642.0f,698.0f,698.0f,690.0f,666.0f,666.0f,
    738.0f,803.0f,851.0f,899.0f,899.0f,811.0f,706.0f,658.0f,
    666.0f,698.0f,706.0f,634.0f,497.0f,281.0f,64.0f,-73.0f,
    -145.0f,-161.0f,-185.0f,-258.0f,-314.0f,-370.0f,-442.0f,-571.0f,
    -723.0f,-900.0f,-1045.0f,-1069.0f,-996.0f,-900.0f,-884.0f,-956.0f,
    -988.0f,-892.0f,-788.0f,-804.0f,-828.0f,-780.0f,-667.0f,-571.0f,
    -515.0f,-426.0f,-322.0f,-193.0f,-73.0f,24.0f,120.0f,248.0f,
    385.0f,489.0f,562.0f,586.0f,594.0f,594.0f,594.0f,642.0f,
    674.0f,682.0f,650.0f,618.0f,594.0f,562.0f,522.0f,489.0f,
    481.0f,457.0f,449.0f,433.0f,385.0f,337.0f,265.0f,208.0f,
    192.0f,176.0f,104.0f,-17.0f,-153.0f,-258.0f,-282.0f,-282.0f,
    -298.0f,-314.0f,-274.0f,-209.0f,-161.0f,-153.0f,-185.0f,-217.0f,
    -233.0f,-241.0f,-258.0f,-282.0f,-290.0f,-298.0f,-298.0f,-249.0f,
    -177.0f,-97.0f,-17.0f,24.0f,56.0f,104.0f,176.0f,248.0f,
    257.0f,200.0f,144.0f,144.0f,160.0f,192.0f,200.0f,208.0f,
    208.0f,176.0f,136.0f,96.0f,32.0f,-33.0f,-73.0f,-97.0f,
    -121.0f,-153.0f,-193.0f,-241.0f,-290.0f,-338.0f,-362.0f,-354.0f,
    -314.0f,-274.0f,-258.0f,-258.0f,-241.0f,-241.0f,-233.0f,-233.0f,
    -217.0f,-201.0f,-185.0f,-161.0f,-137.0f,-105.0f,-73.0f,-57.0f,
    -25.0f,24.0f,80.0f,120.0f,168.0f,224.0f,281.0f,313.0f,
    321.0f,337.0f,361.0f,369.0f,385.0f,393.0f,417.0f,433.0f,
    409.0f,369.0f,337.0f,337.0f,353.0f,385.0f,393.0f,393.0f,
    377.0f,345.0f,289.0f,224.0f,160.0f,104.0f,56.0f,8.0f,
    -25.0f,-81.0f,-145.0f,-209.0f,-258.0f,-290.0f,-314.0f,-314.0f,
    -306.0f,-314.0f,-354.0f,-410.0f,-450.0f,-474.0f,-474.0f,-458.0f,
    -450.0f,-434.0f,-410.0f,-386.0f,-346.0f,-306.0f,-282.0f,-266.0f,
    -241.0f,-209.0f,-153.0f,-105.0f,-65.0f,-17.0f,24.0f,72.0f,
    128.0f,184.0f,232.0f,265.0f,281.0f,313.0f,337.0f,361.0f,
    361.0f,345.0f,313.0f,297.0f,273.0f,265.0f,240.0f,216.0f,
    176.0f,144.0f,112.0f,88.0f,64.0f,40.0f,24.0f,16.0f,
    8.0f,-9.0f,-33.0f,-41.0f,-57.0f,-81.0f,-105.0f,-105.0f,
    -105.0f,-97.0f,-97.0f,-89.0f,-65.0f,-33.0f,-9.0f,0.0f,
    24.0f,40.0f,48.0f,48.0f,48.0f,48.0f,56.0f,56.0f,
    64.0f,72.0f,72.0f,80.0f,72.0f,64.0f,64.0f,56.0f,
    56.0f,64.0f,72.0f,72.0f,72.0f,64.0f,64.0f,80.0f,
    88.0f,72.0f,48.0f,16.0f,-1.0f,-25.0f,-65.0f,-105.0f,
    -145.0f,-177.0f,-185.0f,-185.0f,-193.0f,-217.0f,-225.0f,-225.0f,
    -217.0f,-209.0f,-209.0f,-209.0f,-217.0f,-209.0f,-185.0f,-161.0f,
    -145.0f,-137.0f,-129.0f,-121.0f,-97.0f,-65.0f,-33.0f,0.0f,
    40.0f,72.0f,104.0f,120.0f,136.0f,160.0f,184.0f,216.0f,
    248.0f,265.0f,281.0f,289.0f,289.0f,281.0f,273.0f,265.0f,
    257.0f,248.0f,240.0f,224.0f,200.0f,184.0f,168.0f,160.0f,
    144.0f,136.0f,128.0f,112.0f,96.0f,80.0f,64.0f,48.0f,
    24.0f,-9.0f,-41.0f,-73.0f,-113.0f,-145.0f,-169.0f,-169.0f,
    -169.0f,-185.0f,-201.0f,-217.0f,-217.0f,-209.0f,-201.0f,-193.0f,
    -177.0f,-169.0f,-161.0f,-153.0f,-153.0f,-145.0f,-137.0f,-129.0f,
    -113.0f,-113.0f,-113.0f,-97.0f,-81.0f,-65.0f,-41.0f,-17.0f,
    8.0f,48.0f,72.0f,80.0f,88.0f,104.0f,112.0f,120.0f,
    120.0f,112.0f,104.0f,96.0f,104.0f,112.0f,120.0f,136.0f,
    144.0f,136.0f,120.0f,104.0f,88.0f,88.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    0
}; t_CKUINT mand10_size = 1024;

// data for mand11.raw...
SAMPLE mand11_data[] = {
    0.0f,-177.0f,-531.0f,-723.0f,-908.0f,-1261.0f,-1286.0f,-450.0f,
    931.0f,1276.0f,72.0f,-506.0f,514.0f,1758.0f,1525.0f,626.0f,
    594.0f,1293.0f,1501.0f,666.0f,216.0f,811.0f,1630.0f,1501.0f,
    417.0f,-667.0f,-932.0f,-298.0f,96.0f,-346.0f,-1189.0f,-1165.0f,
    -9.0f,594.0f,-105.0f,-1350.0f,-2201.0f,-1896.0f,-1037.0f,-282.0f,
    200.0f,-651.0f,-1534.0f,-2040.0f,-2225.0f,-1671.0f,-1053.0f,-418.0f,
    -450.0f,-763.0f,-1053.0f,-563.0f,586.0f,859.0f,329.0f,-121.0f,
    -129.0f,538.0f,1252.0f,1132.0f,618.0f,538.0f,1100.0f,1694.0f,
    1750.0f,971.0f,634.0f,1405.0f,2168.0f,2015.0f,1517.0f,1268.0f,
    1244.0f,1116.0f,433.0f,265.0f,819.0f,1550.0f,1196.0f,216.0f,
    -258.0f,-225.0f,248.0f,144.0f,-394.0f,-900.0f,-844.0f,-515.0f,
    -450.0f,-683.0f,-1165.0f,-1711.0f,-2161.0f,-1888.0f,-1245.0f,-715.0f,
    -739.0f,-1197.0f,-1366.0f,-1069.0f,-699.0f,-458.0f,-177.0f,-274.0f,
    -707.0f,-1117.0f,-1061.0f,-539.0f,-314.0f,-314.0f,-225.0f,104.0f,
    449.0f,554.0f,522.0f,385.0f,505.0f,666.0f,674.0f,658.0f,
    690.0f,666.0f,682.0f,907.0f,851.0f,497.0f,232.0f,449.0f,
    947.0f,1060.0f,722.0f,337.0f,152.0f,216.0f,224.0f,-105.0f,
    -362.0f,-386.0f,-241.0f,-97.0f,-322.0f,-763.0f,-1029.0f,-763.0f,
    -515.0f,-699.0f,-1181.0f,-1502.0f,-972.0f,-266.0f,-65.0f,-298.0f,
    -362.0f,224.0f,843.0f,899.0f,674.0f,449.0f,281.0f,200.0f,
    184.0f,216.0f,393.0f,754.0f,987.0f,987.0f,995.0f,1076.0f,
    1116.0f,1076.0f,883.0f,562.0f,265.0f,136.0f,152.0f,200.0f,
    273.0f,425.0f,401.0f,184.0f,-17.0f,-121.0f,-81.0f,-113.0f,
    -346.0f,-683.0f,-1045.0f,-1149.0f,-988.0f,-940.0f,-1053.0f,-1181.0f,
    -1133.0f,-996.0f,-828.0f,-659.0f,-643.0f,-755.0f,-1077.0f,-1286.0f,
    -1205.0f,-1045.0f,-755.0f,-506.0f,-474.0f,-394.0f,-193.0f,32.0f,
    289.0f,305.0f,160.0f,16.0f,56.0f,345.0f,594.0f,530.0f,
    240.0f,216.0f,481.0f,795.0f,1011.0f,1019.0f,915.0f,762.0f,
    771.0f,891.0f,883.0f,698.0f,514.0f,489.0f,578.0f,738.0f,
    690.0f,441.0f,321.0f,393.0f,562.0f,578.0f,329.0f,72.0f,
    -25.0f,-89.0f,-137.0f,-177.0f,-209.0f,-249.0f,-354.0f,-410.0f,
    -346.0f,-306.0f,-306.0f,-338.0f,-490.0f,-619.0f,-555.0f,-426.0f,
    -330.0f,-266.0f,-282.0f,-298.0f,-346.0f,-426.0f,-402.0f,-362.0f,
    -306.0f,-306.0f,-322.0f,-225.0f,-73.0f,56.0f,-1.0f,-113.0f,
    -145.0f,-17.0f,176.0f,240.0f,192.0f,96.0f,48.0f,-1.0f,
    -65.0f,-121.0f,-89.0f,16.0f,112.0f,120.0f,32.0f,-33.0f,
    -41.0f,0.0f,-9.0f,-89.0f,-177.0f,-185.0f,-121.0f,-97.0f,
    -145.0f,-193.0f,-177.0f,-137.0f,-161.0f,-177.0f,-105.0f,0.0f,
    40.0f,-25.0f,-89.0f,-41.0f,40.0f,80.0f,8.0f,40.0f,
    144.0f,248.0f,337.0f,329.0f,329.0f,345.0f,313.0f,281.0f,
    345.0f,465.0f,497.0f,441.0f,369.0f,377.0f,409.0f,393.0f,
    345.0f,313.0f,305.0f,321.0f,305.0f,232.0f,176.0f,112.0f,
    88.0f,112.0f,144.0f,120.0f,56.0f,8.0f,-1.0f,-41.0f,
    -145.0f,-298.0f,-402.0f,-450.0f,-450.0f,-482.0f,-539.0f,-547.0f,
    -555.0f,-571.0f,-579.0f,-571.0f,-563.0f,-531.0f,-506.0f,-498.0f,
    -523.0f,-555.0f,-563.0f,-506.0f,-394.0f,-314.0f,-282.0f,-249.0f,
    -105.0f,64.0f,136.0f,104.0f,64.0f,80.0f,152.0f,224.0f,
    257.0f,265.0f,281.0f,273.0f,273.0f,337.0f,425.0f,481.0f,
    481.0f,465.0f,473.0f,489.0f,457.0f,369.0f,248.0f,160.0f,
    152.0f,208.0f,289.0f,329.0f,313.0f,265.0f,224.0f,192.0f,
    152.0f,88.0f,32.0f,-1.0f,-17.0f,-33.0f,-65.0f,-105.0f,
    -137.0f,-145.0f,-153.0f,-137.0f,-105.0f,-81.0f,-57.0f,-57.0f,
    -73.0f,-113.0f,-137.0f,-129.0f,-89.0f,-73.0f,-65.0f,-25.0f,
    0.0f,0.0f,-33.0f,-113.0f,-153.0f,-137.0f,-105.0f,-81.0f,
    -65.0f,-49.0f,-33.0f,-9.0f,-9.0f,-17.0f,-25.0f,-41.0f,
    -49.0f,-49.0f,-49.0f,-57.0f,-89.0f,-121.0f,-145.0f,-145.0f,
    -137.0f,-105.0f,-81.0f,-65.0f,-73.0f,-81.0f,-81.0f,-97.0f,
    -113.0f,-153.0f,-169.0f,-161.0f,-137.0f,-113.0f,-89.0f,-65.0f,
    -49.0f,-41.0f,-17.0f,16.0f,48.0f,64.0f,72.0f,104.0f,
    136.0f,160.0f,184.0f,216.0f,257.0f,289.0f,305.0f,321.0f,
    321.0f,321.0f,313.0f,321.0f,337.0f,321.0f,289.0f,265.0f,
    257.0f,257.0f,232.0f,184.0f,136.0f,120.0f,120.0f,112.0f,
    96.0f,56.0f,24.0f,-1.0f,-33.0f,-49.0f,-65.0f,-89.0f,
    -113.0f,-145.0f,-177.0f,-217.0f,-258.0f,-290.0f,-298.0f,-298.0f,
    -282.0f,-258.0f,-225.0f,-201.0f,-193.0f,-201.0f,-217.0f,-225.0f,
    -217.0f,-201.0f,-177.0f,-161.0f,-145.0f,-137.0f,-113.0f,-89.0f,
    -65.0f,-49.0f,-33.0f,-9.0f,16.0f,32.0f,24.0f,16.0f,
    16.0f,32.0f,48.0f,56.0f,64.0f,88.0f,120.0f,144.0f,
    160.0f,160.0f,136.0f,120.0f,112.0f,120.0f,128.0f,120.0f,
    112.0f,120.0f,120.0f,128.0f,120.0f,120.0f,120.0f,120.0f,
    120.0f,120.0f,112.0f,104.0f,96.0f,80.0f,72.0f,64.0f,
    64.0f,64.0f,64.0f,56.0f,40.0f,32.0f,32.0f,32.0f,
    32.0f,24.0f,24.0f,16.0f,16.0f,16.0f,24.0f,32.0f,
    32.0f,24.0f,8.0f,8.0f,0.0f,0.0f,-17.0f,-49.0f,
    -65.0f,-81.0f,-97.0f,-105.0f,-121.0f,-129.0f,-137.0f,-137.0f,
    -137.0f,-145.0f,-153.0f,-169.0f,-169.0f,-169.0f,-161.0f,-153.0f,
    -145.0f,-129.0f,-105.0f,-81.0f,-65.0f,-41.0f,-25.0f,-1.0f,
    0.0f,8.0f,8.0f,0.0f,0.0f,0.0f,16.0f,32.0f,
    48.0f,56.0f,56.0f,56.0f,72.0f,96.0f,104.0f,96.0f,
    80.0f,80.0f,88.0f,96.0f,104.0f,112.0f,120.0f,136.0f,
    144.0f,160.0f,160.0f,144.0f,136.0f,120.0f,112.0f,96.0f,
    88.0f,80.0f,72.0f,64.0f,56.0f,48.0f,40.0f,40.0f,
    24.0f,8.0f,0.0f,-9.0f,-17.0f,-17.0f,-25.0f,-33.0f,
    -49.0f,-57.0f,-57.0f,-57.0f,-49.0f,-57.0f,-65.0f,-73.0f,
    -81.0f,-81.0f,-89.0f,-89.0f,-81.0f,-81.0f,-81.0f,-73.0f,
    -73.0f,-65.0f,-65.0f,-65.0f,-57.0f,-49.0f,-49.0f,-49.0f,
    -49.0f,-33.0f,-17.0f,-9.0f,-9.0f,-17.0f,-17.0f,-9.0f,
    -9.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-9.0f,
    -9.0f,-9.0f,0.0f,0.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,16.0f,32.0f,48.0f,56.0f,64.0f,72.0f,
    72.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,80.0f,
    0
}; t_CKUINT mand11_size = 1024;

// data for mand12.raw...
SAMPLE mand12_data[] = {
    0.0f,224.0f,-836.0f,-1824.0f,-1534.0f,-2651.0f,-3149.0f,-1149.0f,
    2048.0f,3734.0f,3814.0f,3011.0f,971.0f,-1.0f,-33.0f,-314.0f,
    0.0f,1019.0f,1156.0f,1542.0f,1831.0f,1710.0f,843.0f,-892.0f,
    -563.0f,-330.0f,610.0f,1309.0f,281.0f,-547.0f,-1518.0f,-1205.0f,
    240.0f,795.0f,-739.0f,-1743.0f,-1703.0f,-1663.0f,-1583.0f,-2402.0f,
    -3093.0f,-2322.0f,-1559.0f,-1478.0f,-675.0f,200.0f,-531.0f,-2579.0f,
    -3133.0f,-2032.0f,-402.0f,1309.0f,1212.0f,313.0f,337.0f,353.0f,
    184.0f,-201.0f,-354.0f,-177.0f,915.0f,2634.0f,3092.0f,2618.0f,
    2409.0f,2481.0f,1710.0f,891.0f,1533.0f,2706.0f,3156.0f,2794.0f,
    1734.0f,867.0f,369.0f,417.0f,417.0f,192.0f,1036.0f,1718.0f,
    1461.0f,562.0f,-410.0f,-1326.0f,-1639.0f,-1181.0f,-1173.0f,-747.0f,
    329.0f,321.0f,-402.0f,-1004.0f,-1615.0f,-1631.0f,-1743.0f,-1872.0f,
    -1446.0f,-868.0f,-972.0f,-1944.0f,-2193.0f,-1743.0f,-1213.0f,-1053.0f,
    -1374.0f,-1510.0f,-1221.0f,-1205.0f,-1012.0f,-49.0f,353.0f,-282.0f,
    -1149.0f,-1229.0f,-362.0f,859.0f,1927.0f,2505.0f,2923.0f,2626.0f,
    1036.0f,-225.0f,-314.0f,425.0f,1236.0f,1188.0f,329.0f,-25.0f,
    602.0f,1260.0f,1076.0f,160.0f,-611.0f,-1141.0f,-691.0f,-274.0f,
    -306.0f,-89.0f,16.0f,144.0f,80.0f,610.0f,1333.0f,1421.0f,
    1076.0f,481.0f,240.0f,554.0f,674.0f,96.0f,-788.0f,-1149.0f,
    -940.0f,-539.0f,-458.0f,-804.0f,-820.0f,-466.0f,-217.0f,-338.0f,
    -595.0f,-282.0f,602.0f,1108.0f,971.0f,570.0f,289.0f,457.0f,
    963.0f,1228.0f,1293.0f,1397.0f,1469.0f,1341.0f,698.0f,-129.0f,
    -820.0f,-844.0f,-177.0f,377.0f,417.0f,24.0f,-539.0f,-996.0f,
    -1117.0f,-1020.0f,-892.0f,-1004.0f,-1061.0f,-555.0f,-41.0f,-49.0f,
    -378.0f,-836.0f,-1109.0f,-1069.0f,-868.0f,-595.0f,-474.0f,-555.0f,
    -731.0f,-707.0f,-603.0f,-555.0f,-627.0f,-1020.0f,-1197.0f,-876.0f,
    -442.0f,-153.0f,88.0f,160.0f,64.0f,32.0f,160.0f,497.0f,
    746.0f,618.0f,522.0f,795.0f,1076.0f,1084.0f,955.0f,923.0f,
    1108.0f,1373.0f,1493.0f,1461.0f,1437.0f,1389.0f,1252.0f,987.0f,
    666.0f,369.0f,160.0f,88.0f,232.0f,457.0f,473.0f,393.0f,
    281.0f,168.0f,-81.0f,-555.0f,-908.0f,-972.0f,-796.0f,-523.0f,
    -410.0f,-410.0f,-282.0f,-225.0f,-370.0f,-482.0f,-386.0f,-322.0f,
    -466.0f,-603.0f,-707.0f,-900.0f,-1069.0f,-1045.0f,-731.0f,-290.0f,
    -33.0f,-129.0f,-314.0f,-193.0f,128.0f,232.0f,40.0f,-89.0f,
    16.0f,273.0f,313.0f,224.0f,208.0f,224.0f,273.0f,216.0f,
    40.0f,-65.0f,-41.0f,-25.0f,0.0f,80.0f,128.0f,128.0f,
    -1.0f,-145.0f,-137.0f,-113.0f,-81.0f,-33.0f,-33.0f,-81.0f,
    -97.0f,-113.0f,-161.0f,-201.0f,-185.0f,-1.0f,224.0f,353.0f,
    337.0f,232.0f,192.0f,160.0f,128.0f,56.0f,-1.0f,-1.0f,
    -17.0f,-89.0f,-121.0f,16.0f,265.0f,393.0f,289.0f,192.0f,
    265.0f,369.0f,465.0f,481.0f,425.0f,345.0f,281.0f,273.0f,
    345.0f,457.0f,489.0f,361.0f,265.0f,297.0f,313.0f,281.0f,
    176.0f,112.0f,168.0f,200.0f,152.0f,8.0f,-177.0f,-370.0f,
    -547.0f,-619.0f,-619.0f,-515.0f,-338.0f,-225.0f,-306.0f,-490.0f,
    -627.0f,-683.0f,-699.0f,-715.0f,-723.0f,-675.0f,-563.0f,-442.0f,
    -418.0f,-418.0f,-378.0f,-306.0f,-249.0f,-217.0f,-161.0f,-81.0f,
    16.0f,112.0f,192.0f,240.0f,240.0f,248.0f,273.0f,297.0f,
    337.0f,417.0f,473.0f,465.0f,361.0f,265.0f,273.0f,369.0f,
    473.0f,497.0f,433.0f,385.0f,393.0f,369.0f,265.0f,128.0f,
    32.0f,-9.0f,-1.0f,48.0f,104.0f,112.0f,80.0f,32.0f,
    24.0f,48.0f,80.0f,120.0f,80.0f,-25.0f,-145.0f,-209.0f,
    -225.0f,-193.0f,-161.0f,-129.0f,-57.0f,48.0f,152.0f,176.0f,
    112.0f,40.0f,24.0f,0.0f,-25.0f,-65.0f,-65.0f,-9.0f,
    64.0f,96.0f,64.0f,16.0f,-1.0f,24.0f,80.0f,112.0f,
    96.0f,48.0f,16.0f,8.0f,-9.0f,-57.0f,-129.0f,-161.0f,
    -169.0f,-201.0f,-233.0f,-258.0f,-282.0f,-306.0f,-338.0f,-354.0f,
    -338.0f,-290.0f,-225.0f,-209.0f,-217.0f,-241.0f,-249.0f,-233.0f,
    -217.0f,-193.0f,-153.0f,-105.0f,-57.0f,-9.0f,32.0f,80.0f,
    128.0f,160.0f,176.0f,184.0f,208.0f,248.0f,265.0f,240.0f,
    208.0f,200.0f,208.0f,216.0f,248.0f,289.0f,345.0f,409.0f,
    409.0f,369.0f,345.0f,345.0f,353.0f,353.0f,321.0f,273.0f,
    224.0f,176.0f,128.0f,112.0f,96.0f,88.0f,80.0f,96.0f,
    120.0f,144.0f,136.0f,72.0f,-1.0f,-65.0f,-113.0f,-153.0f,
    -201.0f,-233.0f,-258.0f,-266.0f,-258.0f,-241.0f,-249.0f,-266.0f,
    -290.0f,-314.0f,-322.0f,-306.0f,-290.0f,-282.0f,-290.0f,-322.0f,
    -322.0f,-298.0f,-258.0f,-233.0f,-201.0f,-169.0f,-137.0f,-129.0f,
    -129.0f,-121.0f,-73.0f,-9.0f,40.0f,64.0f,104.0f,144.0f,
    184.0f,192.0f,200.0f,216.0f,248.0f,257.0f,240.0f,232.0f,
    240.0f,248.0f,232.0f,216.0f,232.0f,240.0f,208.0f,152.0f,
    88.0f,48.0f,40.0f,32.0f,24.0f,32.0f,48.0f,64.0f,
    72.0f,72.0f,72.0f,72.0f,64.0f,40.0f,8.0f,-9.0f,
    -25.0f,-25.0f,-9.0f,8.0f,32.0f,24.0f,8.0f,8.0f,
    32.0f,72.0f,96.0f,88.0f,64.0f,48.0f,40.0f,32.0f,
    8.0f,-17.0f,-17.0f,0.0f,24.0f,24.0f,8.0f,-9.0f,
    -17.0f,-17.0f,-17.0f,-17.0f,-17.0f,-25.0f,-41.0f,-65.0f,
    -89.0f,-105.0f,-121.0f,-129.0f,-137.0f,-145.0f,-161.0f,-161.0f,
    -161.0f,-153.0f,-129.0f,-121.0f,-137.0f,-161.0f,-169.0f,-145.0f,
    -121.0f,-105.0f,-97.0f,-81.0f,-65.0f,-65.0f,-57.0f,-41.0f,
    -17.0f,16.0f,40.0f,56.0f,72.0f,88.0f,104.0f,112.0f,
    120.0f,152.0f,184.0f,216.0f,224.0f,232.0f,240.0f,248.0f,
    257.0f,273.0f,289.0f,289.0f,289.0f,265.0f,240.0f,216.0f,
    184.0f,160.0f,144.0f,128.0f,104.0f,80.0f,56.0f,40.0f,
    40.0f,40.0f,32.0f,8.0f,-17.0f,-49.0f,-73.0f,-97.0f,
    -113.0f,-145.0f,-169.0f,-185.0f,-193.0f,-193.0f,-193.0f,-177.0f,
    -161.0f,-153.0f,-145.0f,-153.0f,-153.0f,-153.0f,-153.0f,-145.0f,
    -137.0f,-129.0f,-121.0f,-105.0f,-89.0f,-81.0f,-73.0f,-81.0f,
    -73.0f,-49.0f,-25.0f,-9.0f,-9.0f,0.0f,24.0f,64.0f,
    96.0f,104.0f,120.0f,120.0f,120.0f,120.0f,120.0f,120.0f,
    128.0f,128.0f,120.0f,112.0f,112.0f,112.0f,96.0f,88.0f,
    80.0f,72.0f,56.0f,48.0f,40.0f,32.0f,32.0f,32.0f,
    40.0f,32.0f,32.0f,32.0f,32.0f,24.0f,16.0f,16.0f,
    16.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,8.0f,
    0
}; t_CKUINT mand12_size = 1024;

// data for mand1.raw...
SAMPLE mand1_data[] = {
    0.0f,441.0f,-4827.0f,-14441.0f,-12674.0f,-4153.0f,6192.0f,11806.0f,
    7075.0f,650.0f,4505.0f,8577.0f,3212.0f,602.0f,2128.0f,3389.0f,
    1140.0f,2056.0f,5421.0f,7918.0f,9412.0f,1477.0f,-5606.0f,-6032.0f,
    -2474.0f,2232.0f,1437.0f,-258.0f,-2956.0f,-4988.0f,-2964.0f,-611.0f,
    -1470.0f,-3534.0f,-3984.0f,-5309.0f,-4611.0f,-2354.0f,-836.0f,-2105.0f,
    -6482.0f,-8698.0f,-5422.0f,40.0f,931.0f,-2667.0f,-5133.0f,-4691.0f,
    -3574.0f,-1567.0f,88.0f,-1229.0f,-2346.0f,-1848.0f,915.0f,4449.0f,
    6368.0f,7139.0f,5308.0f,2521.0f,899.0f,2272.0f,6184.0f,8673.0f,
    6971.0f,4296.0f,3863.0f,4714.0f,4722.0f,3919.0f,3067.0f,3051.0f,
    3798.0f,4907.0f,6545.0f,5011.0f,843.0f,-1157.0f,-217.0f,1582.0f,
    1782.0f,-266.0f,-1277.0f,393.0f,2064.0f,-137.0f,-3390.0f,-4249.0f,
    -3518.0f,-3984.0f,-5213.0f,-4908.0f,-4707.0f,-5333.0f,-6626.0f,-6578.0f,
    -4747.0f,-3245.0f,-3767.0f,-3542.0f,-2008.0f,-1687.0f,-4233.0f,-6482.0f,
    -5036.0f,-2434.0f,-1518.0f,-2474.0f,-2129.0f,72.0f,2176.0f,2722.0f,
    2867.0f,2208.0f,1011.0f,-121.0f,-619.0f,345.0f,1911.0f,3421.0f,
    3565.0f,3590.0f,3405.0f,2963.0f,2867.0f,3341.0f,4786.0f,5316.0f,
    3581.0f,1485.0f,1124.0f,2264.0f,2441.0f,-531.0f,-2723.0f,-1559.0f,
    1485.0f,3549.0f,2192.0f,-97.0f,-1350.0f,-1125.0f,-258.0f,-466.0f,
    -739.0f,24.0f,650.0f,1019.0f,682.0f,-796.0f,-1840.0f,-2289.0f,
    -2040.0f,-1157.0f,-723.0f,-780.0f,-868.0f,-233.0f,313.0f,-17.0f,
    -579.0f,-563.0f,-330.0f,0.0f,827.0f,1686.0f,1485.0f,-346.0f,
    -1848.0f,-1832.0f,-346.0f,698.0f,345.0f,-129.0f,152.0f,963.0f,
    1148.0f,867.0f,457.0f,-73.0f,-619.0f,-563.0f,-249.0f,80.0f,
    240.0f,40.0f,-81.0f,-185.0f,-249.0f,-836.0f,-892.0f,-274.0f,
    -153.0f,-1077.0f,-2241.0f,-2370.0f,-2121.0f,-1534.0f,-876.0f,-651.0f,
    -788.0f,-515.0f,281.0f,754.0f,240.0f,-948.0f,-1872.0f,-2016.0f,
    -1061.0f,-145.0f,152.0f,88.0f,273.0f,642.0f,32.0f,-330.0f,
    72.0f,851.0f,1646.0f,1758.0f,1831.0f,2152.0f,2224.0f,1566.0f,
    1036.0f,1092.0f,1477.0f,1509.0f,1140.0f,1293.0f,1999.0f,2545.0f,
    1999.0f,1108.0f,947.0f,1558.0f,1895.0f,1582.0f,1268.0f,1100.0f,
    594.0f,-306.0f,-643.0f,-410.0f,192.0f,546.0f,0.0f,-780.0f,
    -1093.0f,-860.0f,-715.0f,-844.0f,-1141.0f,-1671.0f,-2057.0f,-1936.0f,
    -1197.0f,-763.0f,-1390.0f,-2073.0f,-2065.0f,-1599.0f,-1478.0f,-1824.0f,
    -1976.0f,-1526.0f,-876.0f,-755.0f,-964.0f,-916.0f,-563.0f,-346.0f,
    -498.0f,-611.0f,-418.0f,-137.0f,-41.0f,-25.0f,232.0f,345.0f,
    184.0f,152.0f,481.0f,1156.0f,1734.0f,1919.0f,1782.0f,1550.0f,
    1212.0f,891.0f,867.0f,1019.0f,979.0f,497.0f,-9.0f,-1.0f,
    489.0f,1028.0f,1196.0f,1100.0f,939.0f,883.0f,779.0f,481.0f,
    144.0f,-217.0f,-426.0f,-466.0f,-466.0f,-442.0f,-306.0f,-113.0f,
    -249.0f,-627.0f,-675.0f,-258.0f,273.0f,489.0f,361.0f,208.0f,
    104.0f,88.0f,-1.0f,-298.0f,-362.0f,-121.0f,152.0f,176.0f,
    0.0f,16.0f,216.0f,602.0f,851.0f,658.0f,313.0f,136.0f,
    248.0f,353.0f,120.0f,-402.0f,-876.0f,-972.0f,-667.0f,-314.0f,
    -153.0f,-89.0f,32.0f,192.0f,208.0f,64.0f,-233.0f,-474.0f,
    -651.0f,-804.0f,-852.0f,-852.0f,-788.0f,-739.0f,-659.0f,-571.0f,
    -643.0f,-796.0f,-844.0f,-820.0f,-691.0f,-523.0f,-386.0f,-290.0f,
    -177.0f,-137.0f,-282.0f,-330.0f,-193.0f,-49.0f,-49.0f,-105.0f,
    32.0f,337.0f,642.0f,819.0f,827.0f,787.0f,867.0f,1019.0f,
    1140.0f,1196.0f,1156.0f,1019.0f,867.0f,779.0f,819.0f,883.0f,
    899.0f,835.0f,730.0f,706.0f,859.0f,1028.0f,1003.0f,811.0f,
    522.0f,313.0f,192.0f,88.0f,16.0f,-1.0f,-25.0f,-89.0f,
    -137.0f,-233.0f,-378.0f,-506.0f,-587.0f,-611.0f,-667.0f,-731.0f,
    -780.0f,-796.0f,-828.0f,-868.0f,-892.0f,-876.0f,-796.0f,-715.0f,
    -659.0f,-611.0f,-571.0f,-515.0f,-426.0f,-322.0f,-177.0f,-33.0f,
    24.0f,24.0f,-17.0f,-73.0f,-137.0f,-233.0f,-322.0f,-346.0f,
    -322.0f,-274.0f,-201.0f,-73.0f,168.0f,401.0f,505.0f,457.0f,
    361.0f,281.0f,176.0f,56.0f,-1.0f,32.0f,104.0f,136.0f,
    160.0f,216.0f,313.0f,393.0f,409.0f,361.0f,329.0f,329.0f,
    353.0f,361.0f,337.0f,265.0f,152.0f,80.0f,104.0f,216.0f,
    297.0f,273.0f,160.0f,120.0f,208.0f,337.0f,409.0f,361.0f,
    257.0f,200.0f,248.0f,321.0f,345.0f,329.0f,289.0f,257.0f,
    265.0f,297.0f,321.0f,281.0f,192.0f,120.0f,56.0f,-1.0f,
    -65.0f,-137.0f,-225.0f,-314.0f,-362.0f,-370.0f,-362.0f,-346.0f,
    -338.0f,-306.0f,-266.0f,-274.0f,-338.0f,-386.0f,-370.0f,-346.0f,
    -426.0f,-579.0f,-675.0f,-659.0f,-587.0f,-547.0f,-515.0f,-458.0f,
    -378.0f,-338.0f,-354.0f,-370.0f,-362.0f,-306.0f,-217.0f,-145.0f,
    -105.0f,-65.0f,-17.0f,64.0f,200.0f,273.0f,257.0f,208.0f,
    216.0f,305.0f,385.0f,369.0f,305.0f,281.0f,337.0f,441.0f,
    546.0f,602.0f,610.0f,578.0f,538.0f,505.0f,522.0f,578.0f,
    602.0f,538.0f,433.0f,369.0f,393.0f,441.0f,457.0f,385.0f,
    265.0f,168.0f,136.0f,136.0f,104.0f,48.0f,24.0f,24.0f,
    32.0f,8.0f,-49.0f,-113.0f,-177.0f,-233.0f,-298.0f,-354.0f,
    -378.0f,-386.0f,-394.0f,-418.0f,-434.0f,-466.0f,-458.0f,-410.0f,
    -338.0f,-282.0f,-274.0f,-290.0f,-282.0f,-249.0f,-185.0f,-113.0f,
    -81.0f,-113.0f,-169.0f,-209.0f,-193.0f,-153.0f,-121.0f,-89.0f,
    -65.0f,-49.0f,-33.0f,-25.0f,-1.0f,32.0f,80.0f,112.0f,
    96.0f,72.0f,48.0f,40.0f,48.0f,56.0f,40.0f,32.0f,
    56.0f,136.0f,208.0f,216.0f,168.0f,104.0f,96.0f,136.0f,
    168.0f,144.0f,120.0f,112.0f,136.0f,184.0f,240.0f,305.0f,
    345.0f,337.0f,297.0f,265.0f,248.0f,248.0f,224.0f,184.0f,
    120.0f,72.0f,56.0f,72.0f,112.0f,152.0f,176.0f,184.0f,
    184.0f,184.0f,176.0f,144.0f,104.0f,80.0f,56.0f,32.0f,
    -9.0f,-65.0f,-113.0f,-153.0f,-177.0f,-185.0f,-169.0f,-145.0f,
    -113.0f,-81.0f,-89.0f,-113.0f,-153.0f,-177.0f,-193.0f,-201.0f,
    -217.0f,-249.0f,-290.0f,-306.0f,-306.0f,-274.0f,-241.0f,-209.0f,
    -201.0f,-201.0f,-201.0f,-177.0f,-145.0f,-113.0f,-105.0f,-113.0f,
    -113.0f,-81.0f,-33.0f,16.0f,56.0f,80.0f,96.0f,112.0f,
    128.0f,144.0f,152.0f,160.0f,160.0f,160.0f,176.0f,208.0f,
    240.0f,257.0f,248.0f,240.0f,248.0f,273.0f,297.0f,297.0f,
    297.0f,281.0f,265.0f,265.0f,273.0f,273.0f,257.0f,216.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,200.0f,
    0
}; t_CKUINT mand1_size = 1024;

// data for mand2.raw...
SAMPLE mand2_data[] = {
    0.0f,-65.0f,-844.0f,-1952.0f,-4394.0f,-4514.0f,-2611.0f,-1294.0f,
    1204.0f,1638.0f,-563.0f,1975.0f,5268.0f,7445.0f,7083.0f,-9.0f,
    -2811.0f,-402.0f,4666.0f,6240.0f,3092.0f,-249.0f,216.0f,4224.0f,
    2915.0f,-1181.0f,-2980.0f,-2105.0f,-2924.0f,-2571.0f,104.0f,505.0f,
    -1334.0f,-2193.0f,-3189.0f,-4097.0f,-2860.0f,-2964.0f,-4410.0f,-4289.0f,
    -2209.0f,-1414.0f,-539.0f,-2354.0f,-4763.0f,-3173.0f,-1647.0f,-1053.0f,
    -1663.0f,-2595.0f,-1679.0f,578.0f,1124.0f,465.0f,827.0f,2433.0f,
    3782.0f,2802.0f,674.0f,867.0f,3148.0f,5276.0f,5067.0f,4762.0f,
    4047.0f,2545.0f,3590.0f,3357.0f,3172.0f,3027.0f,2377.0f,3236.0f,
    3381.0f,2521.0f,618.0f,-587.0f,1028.0f,3084.0f,2602.0f,746.0f,
    -1221.0f,-1334.0f,-354.0f,-515.0f,216.0f,393.0f,-1952.0f,-4097.0f,
    -3856.0f,-2450.0f,-2306.0f,-3783.0f,-4667.0f,-3165.0f,-1358.0f,-1599.0f,
    -3245.0f,-3831.0f,-3558.0f,-3454.0f,-2747.0f,-2482.0f,-2145.0f,-2129.0f,
    -1783.0f,-1711.0f,-2546.0f,-2201.0f,-1575.0f,-458.0f,658.0f,666.0f,
    891.0f,1847.0f,2224.0f,2264.0f,1381.0f,995.0f,819.0f,160.0f,
    915.0f,2240.0f,3598.0f,3702.0f,3670.0f,3212.0f,2240.0f,2465.0f,
    2160.0f,1807.0f,1879.0f,1349.0f,899.0f,811.0f,1140.0f,1212.0f,
    771.0f,232.0f,-731.0f,-1085.0f,152.0f,1373.0f,1453.0f,674.0f,
    -1069.0f,-1687.0f,-1020.0f,-498.0f,-924.0f,-2073.0f,-1944.0f,-571.0f,
    570.0f,32.0f,-1181.0f,-1422.0f,-884.0f,-1109.0f,-1679.0f,-1526.0f,
    -828.0f,465.0f,674.0f,-113.0f,-274.0f,-201.0f,-458.0f,-547.0f,
    -378.0f,80.0f,337.0f,112.0f,-298.0f,-426.0f,-81.0f,104.0f,
    216.0f,554.0f,971.0f,1060.0f,706.0f,538.0f,811.0f,754.0f,
    -1.0f,-747.0f,-643.0f,-217.0f,160.0f,417.0f,425.0f,433.0f,
    16.0f,-378.0f,-506.0f,-274.0f,32.0f,-33.0f,-482.0f,-964.0f,
    -1053.0f,-1020.0f,-635.0f,-193.0f,-249.0f,-900.0f,-1109.0f,-362.0f,
    128.0f,-177.0f,-956.0f,-1454.0f,-1181.0f,-547.0f,-25.0f,586.0f,
    851.0f,843.0f,803.0f,497.0f,650.0f,1260.0f,1622.0f,1630.0f,
    1429.0f,1285.0f,1293.0f,955.0f,570.0f,666.0f,987.0f,1309.0f,
    1268.0f,1108.0f,1293.0f,1469.0f,1333.0f,843.0f,224.0f,-41.0f,
    32.0f,184.0f,369.0f,361.0f,128.0f,-209.0f,-755.0f,-1037.0f,
    -972.0f,-812.0f,-707.0f,-1012.0f,-1334.0f,-1004.0f,-531.0f,-611.0f,
    -1277.0f,-1816.0f,-1623.0f,-1205.0f,-1117.0f,-1237.0f,-1261.0f,-1189.0f,
    -964.0f,-860.0f,-1037.0f,-884.0f,-490.0f,-169.0f,88.0f,224.0f,
    425.0f,449.0f,313.0f,176.0f,200.0f,385.0f,345.0f,192.0f,
    248.0f,481.0f,754.0f,931.0f,787.0f,642.0f,738.0f,875.0f,
    971.0f,1068.0f,979.0f,690.0f,369.0f,88.0f,120.0f,425.0f,
    714.0f,746.0f,698.0f,730.0f,835.0f,947.0f,754.0f,353.0f,
    40.0f,-41.0f,56.0f,48.0f,-105.0f,-241.0f,-394.0f,-571.0f,
    -675.0f,-723.0f,-555.0f,-266.0f,-25.0f,-153.0f,-539.0f,-571.0f,
    -370.0f,-282.0f,-370.0f,-450.0f,-330.0f,-145.0f,-81.0f,-81.0f,
    -105.0f,-97.0f,-97.0f,-153.0f,-57.0f,168.0f,329.0f,353.0f,
    281.0f,273.0f,345.0f,297.0f,144.0f,8.0f,-1.0f,40.0f,
    8.0f,-41.0f,-49.0f,-81.0f,-105.0f,-105.0f,-169.0f,-161.0f,
    -105.0f,-89.0f,-57.0f,-137.0f,-258.0f,-346.0f,-490.0f,-587.0f,
    -611.0f,-474.0f,-193.0f,-9.0f,-41.0f,-137.0f,-137.0f,-33.0f,
    -25.0f,-153.0f,-185.0f,-57.0f,64.0f,40.0f,-57.0f,-65.0f,
    40.0f,176.0f,240.0f,297.0f,433.0f,618.0f,706.0f,754.0f,
    754.0f,682.0f,570.0f,465.0f,457.0f,489.0f,449.0f,353.0f,
    265.0f,248.0f,313.0f,433.0f,489.0f,417.0f,305.0f,216.0f,
    224.0f,321.0f,321.0f,152.0f,-81.0f,-233.0f,-266.0f,-282.0f,
    -290.0f,-274.0f,-209.0f,-209.0f,-290.0f,-282.0f,-274.0f,-330.0f,
    -474.0f,-571.0f,-523.0f,-426.0f,-426.0f,-498.0f,-506.0f,-434.0f,
    -410.0f,-458.0f,-450.0f,-362.0f,-225.0f,-169.0f,-185.0f,-137.0f,
    -25.0f,88.0f,128.0f,112.0f,120.0f,120.0f,80.0f,24.0f,
    16.0f,72.0f,152.0f,184.0f,168.0f,144.0f,160.0f,184.0f,
    176.0f,168.0f,168.0f,200.0f,192.0f,128.0f,8.0f,-65.0f,
    -57.0f,0.0f,64.0f,104.0f,160.0f,216.0f,289.0f,353.0f,
    377.0f,369.0f,313.0f,208.0f,176.0f,232.0f,273.0f,240.0f,
    152.0f,96.0f,136.0f,200.0f,208.0f,152.0f,72.0f,40.0f,
    32.0f,48.0f,56.0f,72.0f,56.0f,-1.0f,-65.0f,-65.0f,
    -33.0f,-1.0f,-1.0f,-49.0f,-89.0f,-121.0f,-121.0f,-97.0f,
    -73.0f,-65.0f,-73.0f,-81.0f,-81.0f,-73.0f,-89.0f,-121.0f,
    -201.0f,-298.0f,-322.0f,-306.0f,-274.0f,-266.0f,-290.0f,-290.0f,
    -249.0f,-217.0f,-225.0f,-249.0f,-241.0f,-225.0f,-217.0f,-217.0f,
    -185.0f,-121.0f,-49.0f,-17.0f,-25.0f,-17.0f,24.0f,64.0f,
    96.0f,128.0f,168.0f,200.0f,208.0f,176.0f,152.0f,144.0f,
    144.0f,176.0f,208.0f,257.0f,289.0f,305.0f,321.0f,345.0f,
    353.0f,329.0f,281.0f,248.0f,248.0f,273.0f,289.0f,248.0f,
    184.0f,128.0f,112.0f,128.0f,136.0f,120.0f,96.0f,72.0f,
    48.0f,24.0f,8.0f,-1.0f,-17.0f,-41.0f,-57.0f,-57.0f,
    -49.0f,-49.0f,-73.0f,-105.0f,-121.0f,-145.0f,-185.0f,-217.0f,
    -225.0f,-217.0f,-209.0f,-233.0f,-249.0f,-233.0f,-193.0f,-161.0f,
    -177.0f,-193.0f,-193.0f,-161.0f,-129.0f,-113.0f,-129.0f,-153.0f,
    -161.0f,-137.0f,-97.0f,-41.0f,0.0f,24.0f,40.0f,40.0f,
    32.0f,24.0f,32.0f,56.0f,64.0f,56.0f,56.0f,64.0f,
    80.0f,96.0f,112.0f,120.0f,120.0f,104.0f,104.0f,112.0f,
    120.0f,112.0f,104.0f,112.0f,136.0f,160.0f,160.0f,160.0f,
    152.0f,144.0f,128.0f,104.0f,104.0f,120.0f,128.0f,112.0f,
    96.0f,96.0f,104.0f,104.0f,80.0f,48.0f,16.0f,0.0f,
    -1.0f,0.0f,8.0f,16.0f,16.0f,8.0f,0.0f,0.0f,
    0.0f,16.0f,24.0f,16.0f,8.0f,-9.0f,-33.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-65.0f,-73.0f,-73.0f,-65.0f,-65.0f,
    -65.0f,-65.0f,-65.0f,-49.0f,-33.0f,-25.0f,-33.0f,-49.0f,
    -65.0f,-73.0f,-81.0f,-73.0f,-73.0f,-73.0f,-81.0f,-89.0f,
    -81.0f,-65.0f,-49.0f,-41.0f,-33.0f,-41.0f,-49.0f,-57.0f,
    -57.0f,-33.0f,-1.0f,0.0f,0.0f,0.0f,24.0f,64.0f,
    104.0f,128.0f,128.0f,128.0f,144.0f,168.0f,184.0f,192.0f,
    192.0f,184.0f,176.0f,184.0f,192.0f,184.0f,168.0f,144.0f,
    136.0f,136.0f,136.0f,128.0f,112.0f,88.0f,72.0f,64.0f,
    64.0f,56.0f,48.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    0
}; t_CKUINT mand2_size = 1024;

// data for mand3.raw...
SAMPLE mand3_data[] = {
    0.0f,-161.0f,-515.0f,-418.0f,96.0f,706.0f,489.0f,393.0f,
    168.0f,867.0f,-362.0f,-2346.0f,-4859.0f,-5486.0f,-4723.0f,-6257.0f,
    803.0f,9750.0f,12296.0f,4626.0f,-3968.0f,-3221.0f,1766.0f,3565.0f,
    -161.0f,-1920.0f,-1390.0f,2080.0f,1871.0f,-49.0f,-193.0f,1285.0f,
    5276.0f,6216.0f,5694.0f,5999.0f,4015.0f,-691.0f,-2217.0f,-1205.0f,
    -3165.0f,-6458.0f,-4225.0f,2562.0f,6095.0f,530.0f,-7678.0f,-7678.0f,
    -1775.0f,738.0f,-2322.0f,-5855.0f,-6345.0f,-5309.0f,-6410.0f,-7197.0f,
    -4032.0f,-506.0f,-1880.0f,-3952.0f,-2137.0f,152.0f,265.0f,-2000.0f,
    -2129.0f,297.0f,658.0f,40.0f,120.0f,2762.0f,7300.0f,8665.0f,
    7533.0f,4601.0f,2337.0f,3076.0f,3573.0f,4537.0f,4417.0f,2521.0f,
    1598.0f,2377.0f,4634.0f,5951.0f,6240.0f,5340.0f,4867.0f,5132.0f,
    3252.0f,208.0f,-1133.0f,-490.0f,-1470.0f,-3077.0f,-3117.0f,-860.0f,
    779.0f,-651.0f,-1775.0f,-2048.0f,-1237.0f,-1093.0f,-2241.0f,-3848.0f,
    -5213.0f,-6265.0f,-8048.0f,-8192.0f,-7237.0f,-5125.0f,-3783.0f,-4787.0f,
    -5341.0f,-3936.0f,-820.0f,851.0f,514.0f,-1494.0f,-2659.0f,-1719.0f,
    -523.0f,1790.0f,3413.0f,3027.0f,2296.0f,2851.0f,4867.0f,5389.0f,
    3292.0f,1598.0f,1582.0f,2305.0f,2513.0f,1590.0f,1036.0f,1967.0f,
    3397.0f,3381.0f,2023.0f,1172.0f,1260.0f,1574.0f,1260.0f,562.0f,
    -354.0f,-1310.0f,-1261.0f,-739.0f,-121.0f,-129.0f,-1069.0f,-1607.0f,
    -1470.0f,-908.0f,-1181.0f,-1735.0f,-924.0f,160.0f,409.0f,-844.0f,
    -2643.0f,-2844.0f,-1655.0f,-450.0f,-161.0f,-531.0f,-603.0f,160.0f,
    1196.0f,1325.0f,56.0f,-1334.0f,-1430.0f,-81.0f,1774.0f,2473.0f,
    1807.0f,1285.0f,1694.0f,2208.0f,2184.0f,1477.0f,1325.0f,2144.0f,
    2650.0f,2296.0f,1180.0f,176.0f,-1.0f,104.0f,-81.0f,-603.0f,
    -555.0f,112.0f,650.0f,762.0f,160.0f,-675.0f,-1615.0f,-2410.0f,
    -2779.0f,-2546.0f,-1543.0f,-747.0f,-892.0f,-1735.0f,-2281.0f,-2225.0f,
    -2257.0f,-2354.0f,-2595.0f,-2675.0f,-2137.0f,-1518.0f,-1061.0f,-1053.0f,
    -1350.0f,-1639.0f,-1824.0f,-1615.0f,-1157.0f,-450.0f,224.0f,851.0f,
    1582.0f,1991.0f,2031.0f,1517.0f,1293.0f,1782.0f,2160.0f,2224.0f,
    1983.0f,2056.0f,2537.0f,2907.0f,2698.0f,2305.0f,2377.0f,2489.0f,
    2305.0f,1895.0f,1590.0f,1614.0f,1710.0f,1341.0f,754.0f,441.0f,
    441.0f,626.0f,417.0f,-49.0f,-691.0f,-1470.0f,-1719.0f,-1318.0f,
    -788.0f,-539.0f,-579.0f,-804.0f,-964.0f,-1093.0f,-1350.0f,-1607.0f,
    -1647.0f,-1494.0f,-1390.0f,-1358.0f,-1334.0f,-1382.0f,-1526.0f,-1687.0f,
    -1679.0f,-1350.0f,-852.0f,-426.0f,-241.0f,-161.0f,-121.0f,-233.0f,
    -482.0f,-643.0f,-418.0f,80.0f,570.0f,803.0f,899.0f,915.0f,
    915.0f,931.0f,955.0f,931.0f,851.0f,738.0f,706.0f,803.0f,
    867.0f,706.0f,281.0f,8.0f,16.0f,216.0f,489.0f,626.0f,
    642.0f,554.0f,337.0f,-129.0f,-723.0f,-1205.0f,-1358.0f,-1101.0f,
    -659.0f,-153.0f,240.0f,361.0f,208.0f,-137.0f,-466.0f,-595.0f,
    -458.0f,-161.0f,72.0f,208.0f,321.0f,321.0f,168.0f,-41.0f,
    -193.0f,-41.0f,361.0f,722.0f,819.0f,746.0f,650.0f,634.0f,
    714.0f,730.0f,618.0f,530.0f,562.0f,746.0f,971.0f,1011.0f,
    803.0f,449.0f,184.0f,96.0f,16.0f,-177.0f,-338.0f,-290.0f,
    -129.0f,-65.0f,-129.0f,-145.0f,-137.0f,-241.0f,-386.0f,-515.0f,
    -555.0f,-571.0f,-731.0f,-996.0f,-1221.0f,-1334.0f,-1286.0f,-980.0f,
    -515.0f,-217.0f,-233.0f,-458.0f,-635.0f,-683.0f,-804.0f,-956.0f,
    -980.0f,-876.0f,-691.0f,-571.0f,-515.0f,-434.0f,-258.0f,-33.0f,
    184.0f,425.0f,594.0f,610.0f,514.0f,449.0f,457.0f,489.0f,
    530.0f,658.0f,851.0f,1036.0f,1124.0f,1100.0f,1084.0f,1052.0f,
    971.0f,931.0f,1003.0f,1044.0f,963.0f,762.0f,546.0f,457.0f,
    433.0f,345.0f,136.0f,-33.0f,-57.0f,-17.0f,16.0f,8.0f,
    -1.0f,-33.0f,-129.0f,-290.0f,-442.0f,-458.0f,-378.0f,-274.0f,
    -258.0f,-386.0f,-563.0f,-675.0f,-667.0f,-603.0f,-539.0f,-474.0f,
    -362.0f,-193.0f,-81.0f,-41.0f,-57.0f,-97.0f,-153.0f,-225.0f,
    -290.0f,-274.0f,-193.0f,-121.0f,-81.0f,-73.0f,-81.0f,-65.0f,
    0.0f,104.0f,144.0f,56.0f,-65.0f,-105.0f,-25.0f,72.0f,
    112.0f,80.0f,24.0f,0.0f,0.0f,-25.0f,-89.0f,-161.0f,
    -201.0f,-209.0f,-177.0f,-129.0f,-65.0f,0.0f,64.0f,48.0f,
    -33.0f,-121.0f,-145.0f,-97.0f,0.0f,64.0f,128.0f,192.0f,
    208.0f,200.0f,200.0f,224.0f,273.0f,313.0f,305.0f,297.0f,
    337.0f,401.0f,441.0f,441.0f,409.0f,401.0f,433.0f,489.0f,
    538.0f,554.0f,546.0f,497.0f,417.0f,337.0f,289.0f,281.0f,
    265.0f,224.0f,128.0f,40.0f,-1.0f,-41.0f,-113.0f,-225.0f,
    -330.0f,-370.0f,-346.0f,-290.0f,-241.0f,-241.0f,-306.0f,-410.0f,
    -506.0f,-547.0f,-563.0f,-571.0f,-587.0f,-579.0f,-579.0f,-587.0f,
    -595.0f,-539.0f,-418.0f,-290.0f,-225.0f,-201.0f,-177.0f,-121.0f,
    -65.0f,-65.0f,-105.0f,-161.0f,-169.0f,-113.0f,-9.0f,88.0f,
    176.0f,232.0f,257.0f,257.0f,232.0f,192.0f,152.0f,144.0f,
    144.0f,168.0f,232.0f,321.0f,401.0f,441.0f,433.0f,425.0f,
    425.0f,417.0f,409.0f,401.0f,377.0f,337.0f,273.0f,216.0f,
    200.0f,216.0f,224.0f,200.0f,144.0f,88.0f,64.0f,48.0f,
    32.0f,0.0f,-41.0f,-97.0f,-137.0f,-161.0f,-153.0f,-137.0f,
    -113.0f,-105.0f,-97.0f,-113.0f,-121.0f,-121.0f,-97.0f,-57.0f,
    -33.0f,-33.0f,-41.0f,-41.0f,-33.0f,-49.0f,-65.0f,-89.0f,
    -97.0f,-81.0f,-65.0f,-49.0f,-57.0f,-73.0f,-97.0f,-105.0f,
    -113.0f,-121.0f,-145.0f,-153.0f,-161.0f,-169.0f,-161.0f,-121.0f,
    -73.0f,-49.0f,-73.0f,-129.0f,-185.0f,-193.0f,-177.0f,-153.0f,
    -145.0f,-153.0f,-169.0f,-169.0f,-153.0f,-121.0f,-81.0f,-33.0f,
    -1.0f,24.0f,48.0f,80.0f,112.0f,144.0f,176.0f,208.0f,
    224.0f,240.0f,265.0f,281.0f,281.0f,273.0f,265.0f,257.0f,
    265.0f,281.0f,273.0f,257.0f,240.0f,240.0f,273.0f,305.0f,
    321.0f,289.0f,232.0f,168.0f,128.0f,112.0f,112.0f,112.0f,
    96.0f,72.0f,48.0f,24.0f,0.0f,-9.0f,-25.0f,-49.0f,
    -73.0f,-113.0f,-161.0f,-185.0f,-193.0f,-185.0f,-177.0f,-201.0f,
    -233.0f,-274.0f,-290.0f,-290.0f,-290.0f,-298.0f,-298.0f,-290.0f,
    -258.0f,-233.0f,-217.0f,-209.0f,-185.0f,-145.0f,-121.0f,-97.0f,
    -89.0f,-73.0f,-73.0f,-65.0f,-49.0f,-9.0f,48.0f,96.0f,
    120.0f,120.0f,96.0f,72.0f,72.0f,88.0f,104.0f,104.0f,
    88.0f,88.0f,112.0f,160.0f,184.0f,224.0f,208.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,224.0f,
    0
}; t_CKUINT mand3_size = 1024;

// data for mand4.raw...
SAMPLE mand4_data[] = {
    0.0f,-145.0f,-73.0f,-1109.0f,-2892.0f,-2860.0f,-2121.0f,-1743.0f,
    -2378.0f,-2956.0f,-2434.0f,554.0f,4497.0f,7332.0f,5862.0f,698.0f,
    -1703.0f,3236.0f,10336.0f,8569.0f,321.0f,-4345.0f,-1141.0f,4923.0f,
    7621.0f,3324.0f,-3390.0f,-5189.0f,-2892.0f,-129.0f,-1004.0f,-3534.0f,
    -1832.0f,-763.0f,-4458.0f,-5261.0f,-2811.0f,216.0f,1260.0f,-2217.0f,
    -5133.0f,-5936.0f,-3679.0f,-868.0f,-1350.0f,-2169.0f,-4627.0f,-4980.0f,
    -2281.0f,-490.0f,1060.0f,-394.0f,-1470.0f,-755.0f,819.0f,3204.0f,
    3212.0f,1582.0f,1164.0f,2305.0f,3019.0f,3381.0f,3573.0f,4136.0f,
    3790.0f,2682.0f,2048.0f,3188.0f,5381.0f,5236.0f,3284.0f,746.0f,
    843.0f,2698.0f,3959.0f,4425.0f,2642.0f,666.0f,-217.0f,48.0f,
    1244.0f,883.0f,-1671.0f,-3719.0f,-3277.0f,-1366.0f,-370.0f,-1639.0f,
    -3655.0f,-4739.0f,-3856.0f,-2418.0f,-1848.0f,-1759.0f,-2346.0f,-2386.0f,
    -1751.0f,-1029.0f,-1583.0f,-3028.0f,-3599.0f,-3117.0f,-1591.0f,-876.0f,
    -1221.0f,-1615.0f,-1936.0f,-1880.0f,-1414.0f,-266.0f,473.0f,465.0f,
    208.0f,200.0f,1188.0f,1726.0f,1638.0f,1718.0f,1477.0f,1276.0f,
    1244.0f,2321.0f,3670.0f,3196.0f,1927.0f,1084.0f,1678.0f,2570.0f,
    2473.0f,2064.0f,1646.0f,915.0f,650.0f,1614.0f,1855.0f,803.0f,
    -346.0f,-1358.0f,-1286.0f,-651.0f,-627.0f,-884.0f,-1575.0f,-2040.0f,
    -1920.0f,-1856.0f,-1647.0f,-1012.0f,-498.0f,-482.0f,-1077.0f,-1735.0f,
    -1430.0f,-619.0f,-266.0f,-731.0f,-1045.0f,-426.0f,915.0f,1935.0f,
    1493.0f,369.0f,-137.0f,297.0f,1140.0f,1614.0f,1742.0f,1718.0f,
    915.0f,160.0f,192.0f,505.0f,690.0f,481.0f,489.0f,666.0f,
    762.0f,939.0f,1140.0f,771.0f,-233.0f,-1061.0f,-940.0f,281.0f,
    1003.0f,441.0f,-731.0f,-1374.0f,-1045.0f,-611.0f,-587.0f,-1430.0f,
    -2209.0f,-2040.0f,-1310.0f,-820.0f,-1037.0f,-1623.0f,-1687.0f,-1004.0f,
    -450.0f,-683.0f,-1061.0f,-844.0f,-354.0f,-153.0f,-587.0f,-1061.0f,
    -812.0f,-274.0f,136.0f,329.0f,361.0f,730.0f,1188.0f,1124.0f,
    859.0f,787.0f,1116.0f,1550.0f,1429.0f,1108.0f,987.0f,1100.0f,
    1373.0f,1349.0f,1180.0f,1060.0f,1076.0f,1445.0f,1750.0f,1421.0f,
    666.0f,176.0f,289.0f,666.0f,754.0f,514.0f,144.0f,-121.0f,
    -249.0f,-434.0f,-635.0f,-780.0f,-731.0f,-772.0f,-956.0f,-1037.0f,
    -988.0f,-940.0f,-940.0f,-1020.0f,-1141.0f,-1085.0f,-739.0f,-306.0f,
    -217.0f,-386.0f,-531.0f,-354.0f,-65.0f,-81.0f,-434.0f,-820.0f,
    -587.0f,184.0f,811.0f,658.0f,64.0f,-282.0f,-97.0f,232.0f,
    144.0f,-89.0f,-306.0f,-298.0f,96.0f,481.0f,505.0f,152.0f,
    -225.0f,-225.0f,-25.0f,184.0f,377.0f,417.0f,297.0f,136.0f,
    -9.0f,0.0f,176.0f,265.0f,160.0f,-33.0f,-17.0f,224.0f,
    353.0f,265.0f,72.0f,-201.0f,-386.0f,-338.0f,-105.0f,72.0f,
    96.0f,104.0f,152.0f,257.0f,313.0f,240.0f,104.0f,40.0f,
    80.0f,144.0f,136.0f,136.0f,136.0f,80.0f,-33.0f,-113.0f,
    -1.0f,240.0f,473.0f,505.0f,457.0f,409.0f,265.0f,184.0f,
    192.0f,104.0f,-25.0f,-17.0f,208.0f,385.0f,361.0f,160.0f,
    -25.0f,-41.0f,64.0f,120.0f,-57.0f,-346.0f,-474.0f,-426.0f,
    -314.0f,-225.0f,-249.0f,-362.0f,-515.0f,-603.0f,-627.0f,-627.0f,
    -579.0f,-611.0f,-699.0f,-659.0f,-466.0f,-201.0f,-73.0f,-201.0f,
    -370.0f,-314.0f,-17.0f,257.0f,232.0f,0.0f,-137.0f,-41.0f,
    168.0f,224.0f,96.0f,-17.0f,16.0f,168.0f,265.0f,297.0f,
    257.0f,265.0f,353.0f,393.0f,337.0f,192.0f,144.0f,257.0f,
    361.0f,393.0f,329.0f,216.0f,176.0f,257.0f,321.0f,273.0f,
    216.0f,240.0f,321.0f,337.0f,265.0f,160.0f,64.0f,56.0f,
    112.0f,160.0f,184.0f,208.0f,224.0f,176.0f,56.0f,-73.0f,
    -153.0f,-161.0f,-177.0f,-217.0f,-249.0f,-266.0f,-233.0f,-233.0f,
    -258.0f,-266.0f,-233.0f,-161.0f,-129.0f,-145.0f,-129.0f,-81.0f,
    -41.0f,-81.0f,-169.0f,-241.0f,-233.0f,-121.0f,-25.0f,-9.0f,
    -41.0f,-49.0f,-1.0f,24.0f,8.0f,-33.0f,-121.0f,-169.0f,
    -161.0f,-129.0f,-89.0f,-81.0f,-65.0f,-49.0f,-17.0f,0.0f,
    -41.0f,-97.0f,-137.0f,-137.0f,-81.0f,-57.0f,-49.0f,-57.0f,
    -41.0f,16.0f,104.0f,160.0f,144.0f,56.0f,0.0f,48.0f,
    176.0f,273.0f,281.0f,224.0f,208.0f,281.0f,385.0f,425.0f,
    329.0f,192.0f,152.0f,200.0f,273.0f,281.0f,192.0f,80.0f,
    48.0f,104.0f,176.0f,224.0f,216.0f,160.0f,88.0f,40.0f,
    16.0f,-1.0f,-25.0f,-41.0f,-49.0f,-57.0f,-73.0f,-73.0f,
    -49.0f,-17.0f,-25.0f,-41.0f,-49.0f,-17.0f,16.0f,8.0f,
    -49.0f,-121.0f,-153.0f,-137.0f,-137.0f,-177.0f,-241.0f,-290.0f,
    -306.0f,-298.0f,-306.0f,-306.0f,-322.0f,-330.0f,-298.0f,-249.0f,
    -201.0f,-161.0f,-129.0f,-105.0f,-65.0f,-33.0f,-9.0f,-1.0f,
    -1.0f,8.0f,48.0f,104.0f,144.0f,136.0f,96.0f,88.0f,
    136.0f,184.0f,208.0f,184.0f,160.0f,136.0f,128.0f,144.0f,
    176.0f,192.0f,208.0f,208.0f,208.0f,208.0f,200.0f,168.0f,
    136.0f,136.0f,144.0f,136.0f,128.0f,128.0f,128.0f,104.0f,
    64.0f,40.0f,72.0f,128.0f,152.0f,136.0f,104.0f,88.0f,
    96.0f,80.0f,32.0f,-33.0f,-89.0f,-113.0f,-121.0f,-121.0f,
    -113.0f,-97.0f,-81.0f,-65.0f,-57.0f,-65.0f,-81.0f,-81.0f,
    -89.0f,-97.0f,-97.0f,-97.0f,-105.0f,-121.0f,-121.0f,-113.0f,
    -89.0f,-81.0f,-73.0f,-73.0f,-57.0f,-57.0f,-65.0f,-73.0f,
    -57.0f,-33.0f,-9.0f,-1.0f,-1.0f,0.0f,8.0f,8.0f,
    8.0f,8.0f,0.0f,-9.0f,-25.0f,-25.0f,-17.0f,-9.0f,
    -1.0f,0.0f,8.0f,24.0f,32.0f,40.0f,48.0f,56.0f,
    72.0f,80.0f,96.0f,112.0f,136.0f,152.0f,176.0f,192.0f,
    192.0f,192.0f,176.0f,160.0f,152.0f,152.0f,152.0f,160.0f,
    152.0f,128.0f,128.0f,136.0f,152.0f,144.0f,120.0f,96.0f,
    96.0f,96.0f,64.0f,8.0f,-25.0f,-41.0f,-41.0f,-33.0f,
    -41.0f,-49.0f,-65.0f,-65.0f,-49.0f,-49.0f,-49.0f,-57.0f,
    -57.0f,-49.0f,-33.0f,-41.0f,-49.0f,-65.0f,-73.0f,-73.0f,
    -89.0f,-105.0f,-121.0f,-105.0f,-81.0f,-57.0f,-49.0f,-57.0f,
    -65.0f,-49.0f,-33.0f,-25.0f,-25.0f,-33.0f,-17.0f,0.0f,
    16.0f,16.0f,16.0f,32.0f,48.0f,64.0f,64.0f,56.0f,
    56.0f,72.0f,88.0f,104.0f,104.0f,104.0f,104.0f,120.0f,
    136.0f,128.0f,120.0f,112.0f,120.0f,128.0f,120.0f,96.0f,
    72.0f,64.0f,64.0f,64.0f,64.0f,48.0f,48.0f,40.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,48.0f,
    0
}; t_CKUINT mand4_size = 1024;

// data for mand5.raw...
SAMPLE mand5_data[] = {
    0.0f,273.0f,-1880.0f,-2683.0f,-2811.0f,-4016.0f,-3205.0f,1084.0f,
    -1125.0f,-5052.0f,-506.0f,3662.0f,8954.0f,8368.0f,-627.0f,-3615.0f,
    6143.0f,7123.0f,3076.0f,-1518.0f,-4233.0f,3670.0f,6746.0f,7549.0f,
    2626.0f,2794.0f,4867.0f,2168.0f,3485.0f,1975.0f,-370.0f,-3141.0f,
    -2249.0f,1172.0f,1397.0f,-635.0f,-2731.0f,-2330.0f,-5237.0f,-7526.0f,
    -7293.0f,-7325.0f,-4530.0f,-4948.0f,-6402.0f,-5373.0f,-5141.0f,-8417.0f,
    -10385.0f,-7060.0f,-3237.0f,-988.0f,-2370.0f,-3687.0f,-2217.0f,32.0f,
    827.0f,-1277.0f,-1045.0f,714.0f,1807.0f,3156.0f,4481.0f,6127.0f,
    6939.0f,6296.0f,4320.0f,5381.0f,7083.0f,7236.0f,7493.0f,7268.0f,
    8183.0f,7019.0f,4232.0f,4176.0f,6328.0f,5324.0f,2144.0f,64.0f,
    1244.0f,5758.0f,6666.0f,3991.0f,714.0f,-33.0f,522.0f,-1061.0f,
    -2498.0f,-3639.0f,-4297.0f,-4972.0f,-5622.0f,-4651.0f,-3133.0f,-2338.0f,
    -3799.0f,-5855.0f,-6434.0f,-6594.0f,-6771.0f,-6185.0f,-4225.0f,-3309.0f,
    -4257.0f,-6249.0f,-6755.0f,-3823.0f,-1623.0f,-1679.0f,-1470.0f,-531.0f,
    200.0f,-378.0f,-844.0f,650.0f,1807.0f,1060.0f,811.0f,2578.0f,
    5148.0f,5662.0f,3413.0f,1614.0f,1871.0f,3316.0f,3196.0f,1935.0f,
    1116.0f,1268.0f,3164.0f,4312.0f,4369.0f,3437.0f,2979.0f,3445.0f,
    2987.0f,1301.0f,-1061.0f,-2338.0f,-1358.0f,-1.0f,-330.0f,-916.0f,
    -747.0f,-595.0f,-1510.0f,-2948.0f,-3293.0f,-1888.0f,-1077.0f,-1840.0f,
    -2876.0f,-2860.0f,-1647.0f,-763.0f,-804.0f,-1165.0f,-996.0f,-442.0f,
    -161.0f,48.0f,361.0f,305.0f,690.0f,1156.0f,1678.0f,1935.0f,
    1293.0f,1405.0f,2232.0f,2746.0f,3067.0f,2867.0f,2152.0f,1598.0f,
    1341.0f,1477.0f,1437.0f,1196.0f,1180.0f,1188.0f,1405.0f,1582.0f,
    1028.0f,-169.0f,-940.0f,-772.0f,160.0f,730.0f,481.0f,-209.0f,
    -1277.0f,-2370.0f,-3430.0f,-3237.0f,-2000.0f,-1294.0f,-1695.0f,-2306.0f,
    -2402.0f,-2185.0f,-2265.0f,-2956.0f,-3848.0f,-4378.0f,-4193.0f,-3550.0f,
    -2988.0f,-2635.0f,-2097.0f,-1454.0f,-1261.0f,-1221.0f,-1045.0f,-1181.0f,
    -1004.0f,-97.0f,1333.0f,2305.0f,2288.0f,1750.0f,1325.0f,1871.0f,
    2666.0f,2762.0f,2634.0f,3276.0f,4634.0f,5790.0f,5517.0f,4096.0f,
    3027.0f,2810.0f,2955.0f,2786.0f,2329.0f,2064.0f,1871.0f,1325.0f,
    714.0f,232.0f,192.0f,722.0f,1052.0f,610.0f,-177.0f,-675.0f,
    -996.0f,-1382.0f,-1727.0f,-2089.0f,-2322.0f,-2049.0f,-1382.0f,-1125.0f,
    -1430.0f,-1679.0f,-1856.0f,-1976.0f,-2049.0f,-2249.0f,-2402.0f,-2193.0f,
    -1559.0f,-964.0f,-884.0f,-1093.0f,-1133.0f,-780.0f,-346.0f,-258.0f,
    -354.0f,-426.0f,-241.0f,24.0f,120.0f,64.0f,8.0f,208.0f,
    722.0f,1309.0f,1558.0f,1461.0f,1204.0f,915.0f,658.0f,369.0f,
    88.0f,56.0f,224.0f,257.0f,152.0f,120.0f,257.0f,313.0f,
    88.0f,-33.0f,88.0f,393.0f,522.0f,136.0f,-394.0f,-635.0f,
    -506.0f,-354.0f,-474.0f,-683.0f,-595.0f,-145.0f,240.0f,224.0f,
    72.0f,16.0f,-73.0f,-258.0f,-322.0f,-33.0f,433.0f,690.0f,
    546.0f,248.0f,96.0f,128.0f,289.0f,570.0f,859.0f,995.0f,
    955.0f,1068.0f,1461.0f,1686.0f,1469.0f,1003.0f,803.0f,1019.0f,
    1236.0f,1100.0f,722.0f,441.0f,345.0f,176.0f,-17.0f,-97.0f,
    -129.0f,-169.0f,-266.0f,-354.0f,-466.0f,-643.0f,-723.0f,-747.0f,
    -836.0f,-1069.0f,-1189.0f,-972.0f,-691.0f,-691.0f,-1020.0f,-1342.0f,
    -1358.0f,-1165.0f,-1053.0f,-1061.0f,-1020.0f,-924.0f,-908.0f,-1004.0f,
    -1101.0f,-1093.0f,-956.0f,-812.0f,-699.0f,-506.0f,-330.0f,-306.0f,
    -394.0f,-362.0f,-145.0f,136.0f,393.0f,562.0f,698.0f,819.0f,
    827.0f,738.0f,746.0f,963.0f,1244.0f,1413.0f,1501.0f,1542.0f,
    1493.0f,1389.0f,1285.0f,1180.0f,1019.0f,851.0f,746.0f,730.0f,
    771.0f,762.0f,674.0f,546.0f,393.0f,192.0f,16.0f,-73.0f,
    -145.0f,-177.0f,-105.0f,16.0f,24.0f,-113.0f,-354.0f,-506.0f,
    -434.0f,-258.0f,-137.0f,-97.0f,-129.0f,-217.0f,-402.0f,-627.0f,
    -731.0f,-683.0f,-531.0f,-330.0f,-161.0f,-49.0f,56.0f,112.0f,
    48.0f,-73.0f,-177.0f,-217.0f,-193.0f,-177.0f,-209.0f,-249.0f,
    -290.0f,-274.0f,-193.0f,-105.0f,-57.0f,-121.0f,-266.0f,-394.0f,
    -418.0f,-370.0f,-322.0f,-346.0f,-418.0f,-490.0f,-490.0f,-394.0f,
    -209.0f,-65.0f,-1.0f,-33.0f,-121.0f,-193.0f,-241.0f,-249.0f,
    -209.0f,-145.0f,-81.0f,0.0f,128.0f,232.0f,281.0f,289.0f,
    281.0f,305.0f,401.0f,497.0f,546.0f,538.0f,505.0f,473.0f,
    505.0f,602.0f,682.0f,722.0f,730.0f,730.0f,746.0f,787.0f,
    835.0f,843.0f,819.0f,779.0f,690.0f,570.0f,465.0f,417.0f,
    433.0f,425.0f,337.0f,208.0f,112.0f,40.0f,-49.0f,-161.0f,
    -225.0f,-241.0f,-290.0f,-378.0f,-482.0f,-563.0f,-595.0f,-603.0f,
    -595.0f,-579.0f,-595.0f,-651.0f,-683.0f,-675.0f,-651.0f,-675.0f,
    -731.0f,-780.0f,-780.0f,-755.0f,-731.0f,-707.0f,-651.0f,-539.0f,
    -418.0f,-322.0f,-233.0f,-169.0f,-137.0f,-113.0f,-65.0f,16.0f,
    152.0f,265.0f,289.0f,257.0f,240.0f,265.0f,329.0f,417.0f,
    465.0f,473.0f,449.0f,441.0f,449.0f,457.0f,449.0f,433.0f,
    441.0f,489.0f,514.0f,505.0f,481.0f,473.0f,457.0f,401.0f,
    321.0f,257.0f,224.0f,216.0f,224.0f,224.0f,224.0f,200.0f,
    144.0f,96.0f,56.0f,8.0f,-41.0f,-81.0f,-73.0f,-33.0f,
    -9.0f,-49.0f,-121.0f,-161.0f,-153.0f,-121.0f,-105.0f,-97.0f,
    -81.0f,-73.0f,-73.0f,-65.0f,-25.0f,24.0f,72.0f,88.0f,
    72.0f,56.0f,40.0f,24.0f,-1.0f,-25.0f,-49.0f,-73.0f,
    -97.0f,-113.0f,-113.0f,-105.0f,-113.0f,-137.0f,-169.0f,-217.0f,
    -274.0f,-338.0f,-402.0f,-418.0f,-402.0f,-362.0f,-322.0f,-290.0f,
    -274.0f,-258.0f,-241.0f,-225.0f,-225.0f,-209.0f,-185.0f,-153.0f,
    -137.0f,-145.0f,-145.0f,-113.0f,-41.0f,40.0f,128.0f,184.0f,
    232.0f,281.0f,329.0f,369.0f,385.0f,385.0f,385.0f,393.0f,
    401.0f,417.0f,441.0f,473.0f,505.0f,514.0f,497.0f,457.0f,
    425.0f,425.0f,441.0f,441.0f,409.0f,361.0f,337.0f,329.0f,
    297.0f,224.0f,144.0f,96.0f,80.0f,88.0f,72.0f,24.0f,
    -33.0f,-81.0f,-121.0f,-161.0f,-201.0f,-241.0f,-249.0f,-266.0f,
    -282.0f,-306.0f,-314.0f,-314.0f,-306.0f,-314.0f,-338.0f,-370.0f,
    -378.0f,-362.0f,-338.0f,-330.0f,-338.0f,-354.0f,-338.0f,-306.0f,
    -266.0f,-217.0f,-185.0f,-161.0f,-129.0f,-97.0f,-89.0f,-89.0f,
    -65.0f,-25.0f,24.0f,64.0f,96.0f,144.0f,184.0f,208.0f,
    208.0f,200.0f,192.0f,200.0f,208.0f,216.0f,224.0f,224.0f,
    232.0f,248.0f,257.0f,273.0f,281.0f,273.0f,265.0f,248.0f,
    232.0f,208.0f,176.0f,152.0f,128.0f,112.0f,96.0f,112.0f,
    128.0f,160.0f,160.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,176.0f,
    0
}; t_CKUINT mand5_size = 1024;

// data for mand6.raw...
SAMPLE mand6_data[] = {
    0.0f,136.0f,-1928.0f,-4667.0f,-6402.0f,-7630.0f,-7357.0f,-5325.0f,
    2305.0f,8657.0f,8344.0f,3180.0f,-804.0f,2835.0f,4377.0f,489.0f,
    -3631.0f,-3068.0f,6384.0f,14247.0f,13516.0f,9404.0f,2377.0f,-1896.0f,
    -3221.0f,-1647.0f,3525.0f,6168.0f,4931.0f,1566.0f,530.0f,1052.0f,
    -362.0f,-4056.0f,-4105.0f,-1181.0f,369.0f,-2137.0f,-5815.0f,-7140.0f,
    -5671.0f,-3984.0f,-6538.0f,-8682.0f,-8658.0f,-5775.0f,-3020.0f,-2297.0f,
    -2249.0f,-3952.0f,-6377.0f,-7197.0f,-6169.0f,-3647.0f,-900.0f,-1727.0f,
    -3695.0f,-3117.0f,1598.0f,4730.0f,3999.0f,3581.0f,2594.0f,2642.0f,
    3830.0f,6224.0f,7549.0f,6738.0f,6441.0f,6376.0f,5943.0f,4746.0f,
    4698.0f,6240.0f,6995.0f,5991.0f,4818.0f,4577.0f,5605.0f,5750.0f,
    3236.0f,562.0f,-651.0f,-354.0f,104.0f,-780.0f,-2378.0f,-4129.0f,
    -4378.0f,-2506.0f,-836.0f,160.0f,771.0f,-314.0f,-3229.0f,-6008.0f,
    -6522.0f,-4779.0f,-3775.0f,-4249.0f,-4522.0f,-3759.0f,-2201.0f,-1719.0f,
    -3526.0f,-5333.0f,-5116.0f,-3912.0f,-2587.0f,-2571.0f,-3687.0f,-3695.0f,
    -2699.0f,-1816.0f,-1783.0f,-1053.0f,1678.0f,3879.0f,4112.0f,3051.0f,
    2674.0f,2971.0f,2465.0f,1429.0f,257.0f,554.0f,2810.0f,5397.0f,
    7011.0f,7340.0f,6312.0f,4690.0f,3726.0f,3268.0f,2200.0f,570.0f,
    -137.0f,152.0f,530.0f,32.0f,-1583.0f,-3044.0f,-3607.0f,-2884.0f,
    -1976.0f,-1767.0f,-1663.0f,-2048.0f,-2089.0f,-1864.0f,-2233.0f,-2972.0f,
    -3414.0f,-2522.0f,-1711.0f,-1277.0f,-723.0f,64.0f,811.0f,602.0f,
    -490.0f,-1647.0f,-1390.0f,-346.0f,562.0f,698.0f,562.0f,1084.0f,
    1774.0f,2425.0f,2650.0f,2650.0f,2481.0f,2369.0f,2361.0f,2031.0f,
    1509.0f,1036.0f,1092.0f,1485.0f,1799.0f,2144.0f,2786.0f,2931.0f,
    2377.0f,1702.0f,1421.0f,1445.0f,867.0f,-57.0f,-900.0f,-1623.0f,
    -2193.0f,-2587.0f,-2828.0f,-2876.0f,-2771.0f,-2442.0f,-2153.0f,-2306.0f,
    -2563.0f,-2932.0f,-3293.0f,-3390.0f,-3334.0f,-3165.0f,-2964.0f,-2972.0f,
    -3004.0f,-2659.0f,-2129.0f,-1534.0f,-1229.0f,-1020.0f,-715.0f,-233.0f,
    192.0f,184.0f,337.0f,859.0f,1397.0f,1630.0f,1678.0f,1903.0f,
    2313.0f,2682.0f,2995.0f,3228.0f,3421.0f,3758.0f,4031.0f,3830.0f,
    3220.0f,2770.0f,3019.0f,3421.0f,3228.0f,2674.0f,2208.0f,1975.0f,
    1598.0f,875.0f,72.0f,-386.0f,-659.0f,-1125.0f,-1791.0f,-2129.0f,
    -1727.0f,-1197.0f,-1085.0f,-1221.0f,-1358.0f,-1494.0f,-1928.0f,-2587.0f,
    -3020.0f,-3052.0f,-2755.0f,-2201.0f,-1551.0f,-1037.0f,-820.0f,-812.0f,
    -868.0f,-587.0f,-137.0f,-9.0f,-233.0f,-434.0f,-225.0f,-137.0f,
    -378.0f,-531.0f,-402.0f,0.0f,409.0f,618.0f,642.0f,586.0f,
    795.0f,1108.0f,1076.0f,714.0f,297.0f,184.0f,417.0f,730.0f,
    971.0f,1132.0f,1196.0f,1196.0f,1028.0f,642.0f,313.0f,281.0f,
    401.0f,377.0f,104.0f,-161.0f,-298.0f,-418.0f,-627.0f,-820.0f,
    -892.0f,-868.0f,-804.0f,-755.0f,-828.0f,-988.0f,-1197.0f,-1398.0f,
    -1382.0f,-1109.0f,-675.0f,-249.0f,8.0f,160.0f,273.0f,297.0f,
    385.0f,417.0f,417.0f,497.0f,562.0f,642.0f,795.0f,955.0f,
    1068.0f,1108.0f,1108.0f,1260.0f,1566.0f,1734.0f,1614.0f,1405.0f,
    1276.0f,1180.0f,947.0f,618.0f,369.0f,305.0f,417.0f,505.0f,
    457.0f,257.0f,16.0f,-137.0f,-306.0f,-466.0f,-619.0f,-796.0f,
    -1037.0f,-1245.0f,-1446.0f,-1727.0f,-1872.0f,-1832.0f,-1695.0f,-1518.0f,
    -1350.0f,-1197.0f,-1101.0f,-1125.0f,-1269.0f,-1406.0f,-1398.0f,-1181.0f,
    -932.0f,-731.0f,-547.0f,-370.0f,-177.0f,-57.0f,0.0f,104.0f,
    232.0f,401.0f,554.0f,618.0f,546.0f,385.0f,297.0f,361.0f,
    481.0f,594.0f,698.0f,915.0f,1212.0f,1389.0f,1357.0f,1172.0f,
    1003.0f,963.0f,987.0f,963.0f,907.0f,955.0f,1076.0f,1092.0f,
    955.0f,730.0f,489.0f,321.0f,257.0f,176.0f,32.0f,-161.0f,
    -330.0f,-442.0f,-579.0f,-747.0f,-900.0f,-908.0f,-812.0f,-780.0f,
    -796.0f,-763.0f,-699.0f,-659.0f,-683.0f,-731.0f,-715.0f,-603.0f,
    -434.0f,-225.0f,0.0f,168.0f,216.0f,176.0f,120.0f,88.0f,
    72.0f,72.0f,136.0f,224.0f,265.0f,208.0f,136.0f,152.0f,
    200.0f,208.0f,128.0f,8.0f,-33.0f,-25.0f,-89.0f,-233.0f,
    -378.0f,-402.0f,-322.0f,-249.0f,-258.0f,-314.0f,-370.0f,-402.0f,
    -426.0f,-490.0f,-563.0f,-547.0f,-442.0f,-370.0f,-378.0f,-394.0f,
    -330.0f,-201.0f,-113.0f,-97.0f,-113.0f,-97.0f,-57.0f,-17.0f,
    16.0f,88.0f,160.0f,208.0f,208.0f,208.0f,273.0f,385.0f,
    505.0f,586.0f,610.0f,610.0f,578.0f,530.0f,497.0f,481.0f,
    522.0f,562.0f,586.0f,602.0f,578.0f,554.0f,530.0f,505.0f,
    497.0f,481.0f,449.0f,401.0f,321.0f,232.0f,128.0f,32.0f,
    -33.0f,-65.0f,-65.0f,-73.0f,-185.0f,-394.0f,-603.0f,-731.0f,
    -804.0f,-868.0f,-932.0f,-948.0f,-932.0f,-900.0f,-876.0f,-836.0f,
    -780.0f,-731.0f,-723.0f,-739.0f,-739.0f,-691.0f,-619.0f,-539.0f,
    -466.0f,-394.0f,-314.0f,-249.0f,-193.0f,-129.0f,-17.0f,104.0f,
    232.0f,321.0f,337.0f,313.0f,289.0f,281.0f,289.0f,305.0f,
    345.0f,417.0f,481.0f,522.0f,514.0f,473.0f,441.0f,425.0f,
    417.0f,385.0f,345.0f,281.0f,208.0f,128.0f,88.0f,80.0f,
    104.0f,128.0f,144.0f,152.0f,136.0f,88.0f,48.0f,16.0f,
    -1.0f,-49.0f,-113.0f,-161.0f,-169.0f,-145.0f,-129.0f,-129.0f,
    -113.0f,-105.0f,-105.0f,-121.0f,-137.0f,-145.0f,-129.0f,-113.0f,
    -105.0f,-97.0f,-105.0f,-105.0f,-97.0f,-89.0f,-73.0f,-65.0f,
    -49.0f,-41.0f,-25.0f,-17.0f,-1.0f,8.0f,32.0f,56.0f,
    72.0f,72.0f,40.0f,8.0f,-25.0f,-57.0f,-81.0f,-105.0f,
    -145.0f,-193.0f,-258.0f,-330.0f,-386.0f,-426.0f,-434.0f,-418.0f,
    -394.0f,-378.0f,-378.0f,-378.0f,-370.0f,-378.0f,-378.0f,-362.0f,
    -314.0f,-249.0f,-177.0f,-105.0f,-33.0f,16.0f,56.0f,96.0f,
    136.0f,176.0f,208.0f,257.0f,289.0f,313.0f,337.0f,361.0f,
    385.0f,385.0f,385.0f,393.0f,385.0f,385.0f,385.0f,385.0f,
    369.0f,337.0f,313.0f,281.0f,265.0f,232.0f,208.0f,176.0f,
    144.0f,112.0f,96.0f,80.0f,48.0f,16.0f,0.0f,-1.0f,
    -17.0f,-49.0f,-89.0f,-129.0f,-177.0f,-233.0f,-290.0f,-338.0f,
    -370.0f,-386.0f,-394.0f,-402.0f,-418.0f,-426.0f,-426.0f,-410.0f,
    -394.0f,-370.0f,-346.0f,-322.0f,-306.0f,-282.0f,-266.0f,-249.0f,
    -233.0f,-209.0f,-185.0f,-161.0f,-121.0f,-73.0f,-25.0f,8.0f,
    48.0f,80.0f,104.0f,128.0f,136.0f,136.0f,144.0f,160.0f,
    168.0f,184.0f,192.0f,208.0f,208.0f,200.0f,184.0f,176.0f,
    176.0f,168.0f,152.0f,136.0f,112.0f,80.0f,56.0f,48.0f,
    48.0f,48.0f,48.0f,32.0f,16.0f,8.0f,0.0f,-1.0f,
    -25.0f,-33.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    -57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,-57.0f,
    0
}; t_CKUINT mand6_size = 1024;

// data for mand7.raw...
SAMPLE mand7_data[] = {
    0.0f,-17.0f,-338.0f,-739.0f,-804.0f,-635.0f,-330.0f,-9.0f,
    112.0f,168.0f,530.0f,1156.0f,1485.0f,1309.0f,883.0f,562.0f,
    803.0f,1188.0f,1019.0f,618.0f,433.0f,586.0f,851.0f,803.0f,
    96.0f,-555.0f,-474.0f,-137.0f,168.0f,-113.0f,-643.0f,-635.0f,
    -595.0f,-924.0f,-1374.0f,-1406.0f,-1302.0f,-1318.0f,-1398.0f,-1502.0f,
    -996.0f,-466.0f,-772.0f,-1494.0f,-1832.0f,-1575.0f,-900.0f,-258.0f,
    -105.0f,-474.0f,-715.0f,-490.0f,-547.0f,-490.0f,-161.0f,449.0f,
    1100.0f,1413.0f,1333.0f,939.0f,843.0f,1164.0f,1558.0f,1445.0f,
    1405.0f,1967.0f,2377.0f,2144.0f,2088.0f,1726.0f,995.0f,779.0f,
    730.0f,746.0f,730.0f,746.0f,714.0f,369.0f,-97.0f,-241.0f,
    -338.0f,-330.0f,-274.0f,-466.0f,-571.0f,-780.0f,-972.0f,-1237.0f,
    -1286.0f,-1109.0f,-1181.0f,-1310.0f,-1253.0f,-940.0f,-643.0f,-627.0f,
    -932.0f,-996.0f,-812.0f,-755.0f,-948.0f,-1045.0f,-699.0f,-314.0f,
    -386.0f,-667.0f,-579.0f,-346.0f,72.0f,586.0f,979.0f,1236.0f,
    1036.0f,650.0f,522.0f,578.0f,385.0f,192.0f,353.0f,795.0f,
    1276.0f,1252.0f,875.0f,393.0f,-9.0f,-225.0f,-290.0f,-153.0f,
    -193.0f,-410.0f,-402.0f,-482.0f,-563.0f,-466.0f,-563.0f,-691.0f,
    -707.0f,-282.0f,88.0f,-41.0f,-225.0f,-386.0f,-370.0f,-290.0f,
    -233.0f,-105.0f,96.0f,160.0f,192.0f,441.0f,586.0f,514.0f,
    232.0f,-33.0f,88.0f,570.0f,851.0f,835.0f,706.0f,586.0f,
    650.0f,779.0f,1052.0f,1220.0f,1148.0f,883.0f,602.0f,546.0f,
    554.0f,538.0f,393.0f,297.0f,281.0f,305.0f,345.0f,144.0f,
    -177.0f,-450.0f,-659.0f,-804.0f,-1004.0f,-1221.0f,-1286.0f,-1318.0f,
    -1286.0f,-1318.0f,-1398.0f,-1277.0f,-1101.0f,-916.0f,-892.0f,-876.0f,
    -747.0f,-675.0f,-531.0f,-506.0f,-523.0f,-482.0f,-410.0f,-282.0f,
    -225.0f,-105.0f,56.0f,257.0f,345.0f,273.0f,224.0f,200.0f,
    337.0f,425.0f,417.0f,385.0f,449.0f,626.0f,795.0f,730.0f,
    465.0f,361.0f,481.0f,706.0f,674.0f,522.0f,457.0f,522.0f,
    706.0f,714.0f,586.0f,505.0f,514.0f,481.0f,393.0f,345.0f,
    321.0f,265.0f,152.0f,32.0f,-105.0f,-290.0f,-426.0f,-410.0f,
    -233.0f,-73.0f,-65.0f,-169.0f,-233.0f,-274.0f,-346.0f,-402.0f,
    -450.0f,-402.0f,-274.0f,-193.0f,-81.0f,56.0f,88.0f,0.0f,
    -81.0f,-41.0f,24.0f,-57.0f,-137.0f,-193.0f,-193.0f,-177.0f,
    -153.0f,-169.0f,-217.0f,-153.0f,-81.0f,-73.0f,-97.0f,-65.0f,
    -1.0f,-17.0f,-105.0f,-193.0f,-241.0f,-258.0f,-241.0f,-217.0f,
    -161.0f,-73.0f,-49.0f,-89.0f,-169.0f,-290.0f,-378.0f,-378.0f,
    -314.0f,-249.0f,-266.0f,-346.0f,-378.0f,-306.0f,-177.0f,-65.0f,
    0.0f,40.0f,80.0f,144.0f,232.0f,297.0f,297.0f,257.0f,
    248.0f,313.0f,393.0f,433.0f,401.0f,353.0f,329.0f,361.0f,
    441.0f,497.0f,522.0f,514.0f,497.0f,497.0f,497.0f,481.0f,
    449.0f,401.0f,361.0f,313.0f,289.0f,305.0f,329.0f,289.0f,
    144.0f,8.0f,-65.0f,-81.0f,-81.0f,-89.0f,-121.0f,-153.0f,
    -185.0f,-249.0f,-290.0f,-354.0f,-442.0f,-506.0f,-531.0f,-506.0f,
    -515.0f,-555.0f,-595.0f,-619.0f,-627.0f,-619.0f,-563.0f,-474.0f,
    -394.0f,-330.0f,-290.0f,-290.0f,-306.0f,-338.0f,-354.0f,-306.0f,
    -225.0f,-121.0f,-33.0f,24.0f,72.0f,88.0f,96.0f,112.0f,
    128.0f,168.0f,216.0f,265.0f,265.0f,240.0f,216.0f,200.0f,
    232.0f,273.0f,297.0f,329.0f,361.0f,401.0f,417.0f,377.0f,
    313.0f,273.0f,273.0f,281.0f,265.0f,232.0f,192.0f,152.0f,
    136.0f,128.0f,104.0f,64.0f,8.0f,-9.0f,-9.0f,0.0f,
    -1.0f,-17.0f,-49.0f,-73.0f,-97.0f,-113.0f,-121.0f,-121.0f,
    -129.0f,-129.0f,-129.0f,-129.0f,-129.0f,-129.0f,-105.0f,-49.0f,
    -1.0f,16.0f,32.0f,56.0f,40.0f,0.0f,-17.0f,-33.0f,
    -33.0f,-17.0f,0.0f,24.0f,32.0f,-1.0f,-57.0f,-81.0f,
    -65.0f,-41.0f,-57.0f,-89.0f,-121.0f,-129.0f,-137.0f,-161.0f,
    -177.0f,-185.0f,-193.0f,-177.0f,-161.0f,-153.0f,-161.0f,-193.0f,
    -233.0f,-258.0f,-258.0f,-241.0f,-225.0f,-209.0f,-193.0f,-153.0f,
    -113.0f,-73.0f,-49.0f,-41.0f,-9.0f,24.0f,88.0f,128.0f,
    136.0f,136.0f,152.0f,168.0f,192.0f,208.0f,248.0f,289.0f,
    321.0f,345.0f,345.0f,329.0f,297.0f,273.0f,265.0f,281.0f,
    289.0f,273.0f,240.0f,216.0f,192.0f,168.0f,136.0f,112.0f,
    96.0f,104.0f,96.0f,72.0f,24.0f,0.0f,-1.0f,-9.0f,
    -17.0f,-41.0f,-57.0f,-65.0f,-81.0f,-105.0f,-145.0f,-201.0f,
    -249.0f,-298.0f,-330.0f,-330.0f,-322.0f,-322.0f,-322.0f,-314.0f,
    -298.0f,-266.0f,-249.0f,-241.0f,-225.0f,-193.0f,-153.0f,-129.0f,
    -113.0f,-113.0f,-105.0f,-97.0f,-81.0f,-41.0f,-9.0f,16.0f,
    24.0f,24.0f,8.0f,0.0f,0.0f,8.0f,16.0f,40.0f,
    64.0f,88.0f,112.0f,128.0f,136.0f,136.0f,144.0f,144.0f,
    144.0f,152.0f,152.0f,152.0f,152.0f,144.0f,144.0f,136.0f,
    128.0f,128.0f,120.0f,128.0f,120.0f,104.0f,80.0f,56.0f,
    40.0f,24.0f,16.0f,16.0f,32.0f,40.0f,40.0f,32.0f,
    24.0f,24.0f,16.0f,16.0f,16.0f,24.0f,24.0f,32.0f,
    32.0f,24.0f,0.0f,-17.0f,-17.0f,-17.0f,-25.0f,-33.0f,
    -49.0f,-57.0f,-65.0f,-73.0f,-73.0f,-73.0f,-89.0f,-97.0f,
    -97.0f,-97.0f,-89.0f,-97.0f,-105.0f,-97.0f,-89.0f,-81.0f,
    -89.0f,-89.0f,-97.0f,-105.0f,-113.0f,-129.0f,-137.0f,-137.0f,
    -137.0f,-137.0f,-129.0f,-121.0f,-113.0f,-97.0f,-81.0f,-57.0f,
    -41.0f,-17.0f,-1.0f,16.0f,24.0f,32.0f,48.0f,64.0f,
    80.0f,96.0f,104.0f,112.0f,120.0f,120.0f,120.0f,120.0f,
    128.0f,128.0f,136.0f,152.0f,152.0f,152.0f,144.0f,136.0f,
    144.0f,144.0f,128.0f,120.0f,120.0f,112.0f,104.0f,96.0f,
    88.0f,80.0f,64.0f,40.0f,16.0f,8.0f,0.0f,-1.0f,
    -9.0f,-25.0f,-41.0f,-57.0f,-65.0f,-73.0f,-73.0f,-73.0f,
    -81.0f,-81.0f,-89.0f,-97.0f,-113.0f,-121.0f,-129.0f,-129.0f,
    -121.0f,-113.0f,-105.0f,-97.0f,-97.0f,-97.0f,-97.0f,-97.0f,
    -89.0f,-81.0f,-73.0f,-65.0f,-65.0f,-73.0f,-65.0f,-65.0f,
    -49.0f,-41.0f,-41.0f,-33.0f,-25.0f,-25.0f,-17.0f,-9.0f,
    8.0f,32.0f,40.0f,48.0f,64.0f,80.0f,88.0f,88.0f,
    88.0f,96.0f,88.0f,88.0f,80.0f,80.0f,72.0f,72.0f,
    72.0f,72.0f,72.0f,64.0f,64.0f,56.0f,48.0f,40.0f,
    32.0f,32.0f,32.0f,32.0f,32.0f,32.0f,40.0f,40.0f,
    40.0f,32.0f,24.0f,16.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,24.0f,
    0
}; t_CKUINT mand7_size = 1024;

// data for mand8.raw...
SAMPLE mand8_data[] = {
    0.0f,-33.0f,-249.0f,-426.0f,-571.0f,-683.0f,-458.0f,-33.0f,
    232.0f,232.0f,152.0f,168.0f,297.0f,425.0f,546.0f,762.0f,
    883.0f,891.0f,771.0f,409.0f,168.0f,425.0f,1019.0f,1437.0f,
    1325.0f,987.0f,618.0f,265.0f,-65.0f,-426.0f,-788.0f,-948.0f,
    -860.0f,-812.0f,-715.0f,-619.0f,-747.0f,-1125.0f,-1454.0f,-1406.0f,
    -1221.0f,-1133.0f,-1181.0f,-1229.0f,-1133.0f,-876.0f,-739.0f,-820.0f,
    -804.0f,-667.0f,-426.0f,-9.0f,281.0f,208.0f,16.0f,-17.0f,
    120.0f,321.0f,457.0f,505.0f,650.0f,955.0f,1196.0f,1180.0f,
    1003.0f,931.0f,971.0f,947.0f,1019.0f,1092.0f,883.0f,377.0f,
    -9.0f,80.0f,425.0f,722.0f,883.0f,931.0f,1036.0f,1028.0f,
    714.0f,265.0f,-73.0f,-266.0f,-258.0f,-161.0f,-41.0f,168.0f,
    208.0f,40.0f,-185.0f,-354.0f,-466.0f,-515.0f,-523.0f,-506.0f,
    -571.0f,-780.0f,-908.0f,-924.0f,-844.0f,-868.0f,-988.0f,-948.0f,
    -707.0f,-482.0f,-386.0f,-474.0f,-780.0f,-1012.0f,-996.0f,-812.0f,
    -563.0f,-322.0f,-233.0f,-177.0f,-73.0f,56.0f,297.0f,530.0f,
    690.0f,827.0f,995.0f,1156.0f,1252.0f,1196.0f,971.0f,771.0f,
    771.0f,963.0f,1019.0f,835.0f,522.0f,313.0f,345.0f,305.0f,
    40.0f,-266.0f,-474.0f,-587.0f,-675.0f,-755.0f,-828.0f,-820.0f,
    -772.0f,-755.0f,-699.0f,-691.0f,-675.0f,-587.0f,-547.0f,-595.0f,
    -643.0f,-474.0f,-185.0f,16.0f,64.0f,40.0f,128.0f,305.0f,
    489.0f,562.0f,497.0f,441.0f,433.0f,441.0f,481.0f,505.0f,
    554.0f,618.0f,634.0f,578.0f,570.0f,690.0f,867.0f,963.0f,
    827.0f,578.0f,393.0f,313.0f,337.0f,281.0f,160.0f,168.0f,
    224.0f,305.0f,305.0f,128.0f,-65.0f,-225.0f,-330.0f,-490.0f,
    -667.0f,-755.0f,-852.0f,-924.0f,-940.0f,-868.0f,-755.0f,-755.0f,
    -844.0f,-1020.0f,-1053.0f,-964.0f,-924.0f,-940.0f,-948.0f,-860.0f,
    -731.0f,-635.0f,-587.0f,-490.0f,-354.0f,-233.0f,-153.0f,-65.0f,
    72.0f,248.0f,353.0f,401.0f,489.0f,586.0f,690.0f,690.0f,
    634.0f,650.0f,754.0f,875.0f,907.0f,915.0f,931.0f,979.0f,
    1036.0f,1019.0f,947.0f,899.0f,835.0f,779.0f,674.0f,514.0f,
    369.0f,192.0f,56.0f,-49.0f,-137.0f,-201.0f,-266.0f,-338.0f,
    -474.0f,-635.0f,-691.0f,-659.0f,-643.0f,-627.0f,-627.0f,-587.0f,
    -498.0f,-442.0f,-458.0f,-442.0f,-346.0f,-282.0f,-201.0f,-113.0f,
    -33.0f,16.0f,40.0f,64.0f,120.0f,184.0f,192.0f,104.0f,
    0.0f,80.0f,160.0f,136.0f,40.0f,-41.0f,-33.0f,-1.0f,
    32.0f,16.0f,-25.0f,-33.0f,0.0f,56.0f,104.0f,48.0f,
    -57.0f,-137.0f,-153.0f,-137.0f,-97.0f,-41.0f,-97.0f,-209.0f,
    -290.0f,-274.0f,-201.0f,-121.0f,-129.0f,-233.0f,-282.0f,-233.0f,
    -193.0f,-209.0f,-249.0f,-241.0f,-193.0f,-121.0f,-41.0f,-17.0f,
    -9.0f,8.0f,48.0f,96.0f,192.0f,313.0f,369.0f,393.0f,
    409.0f,417.0f,417.0f,433.0f,433.0f,449.0f,481.0f,505.0f,
    514.0f,497.0f,489.0f,441.0f,385.0f,353.0f,313.0f,265.0f,
    224.0f,168.0f,112.0f,72.0f,32.0f,-9.0f,-73.0f,-121.0f,
    -161.0f,-161.0f,-161.0f,-217.0f,-306.0f,-370.0f,-402.0f,-410.0f,
    -402.0f,-410.0f,-426.0f,-458.0f,-466.0f,-450.0f,-450.0f,-458.0f,
    -442.0f,-402.0f,-338.0f,-290.0f,-241.0f,-201.0f,-169.0f,-153.0f,
    -153.0f,-137.0f,-105.0f,-65.0f,-9.0f,8.0f,24.0f,56.0f,
    96.0f,136.0f,136.0f,136.0f,136.0f,120.0f,120.0f,112.0f,
    120.0f,120.0f,144.0f,152.0f,168.0f,200.0f,232.0f,257.0f,
    273.0f,273.0f,265.0f,248.0f,257.0f,257.0f,232.0f,208.0f,
    184.0f,184.0f,168.0f,136.0f,104.0f,72.0f,48.0f,24.0f,
    0.0f,-9.0f,-33.0f,-57.0f,-81.0f,-97.0f,-105.0f,-97.0f,
    -97.0f,-105.0f,-105.0f,-89.0f,-73.0f,-65.0f,-57.0f,-41.0f,
    -17.0f,-1.0f,16.0f,48.0f,72.0f,80.0f,80.0f,72.0f,
    72.0f,72.0f,56.0f,32.0f,0.0f,-17.0f,-41.0f,-65.0f,
    -89.0f,-113.0f,-137.0f,-161.0f,-161.0f,-169.0f,-169.0f,-177.0f,
    -185.0f,-193.0f,-201.0f,-193.0f,-193.0f,-193.0f,-193.0f,-177.0f,
    -161.0f,-145.0f,-137.0f,-121.0f,-113.0f,-97.0f,-81.0f,-57.0f,
    -49.0f,-41.0f,-17.0f,-1.0f,0.0f,16.0f,40.0f,64.0f,
    88.0f,104.0f,120.0f,136.0f,152.0f,160.0f,160.0f,160.0f,
    168.0f,176.0f,176.0f,176.0f,184.0f,192.0f,200.0f,200.0f,
    208.0f,216.0f,224.0f,216.0f,192.0f,176.0f,160.0f,136.0f,
    112.0f,88.0f,64.0f,48.0f,40.0f,24.0f,0.0f,-1.0f,
    -17.0f,-33.0f,-57.0f,-81.0f,-105.0f,-113.0f,-129.0f,-153.0f,
    -177.0f,-201.0f,-201.0f,-201.0f,-209.0f,-225.0f,-233.0f,-225.0f,
    -225.0f,-217.0f,-201.0f,-185.0f,-169.0f,-145.0f,-129.0f,-105.0f,
    -89.0f,-73.0f,-65.0f,-49.0f,-17.0f,0.0f,16.0f,24.0f,
    32.0f,40.0f,40.0f,40.0f,40.0f,40.0f,32.0f,32.0f,
    32.0f,40.0f,48.0f,48.0f,40.0f,40.0f,32.0f,40.0f,
    40.0f,40.0f,32.0f,32.0f,40.0f,48.0f,48.0f,40.0f,
    40.0f,40.0f,56.0f,64.0f,72.0f,72.0f,72.0f,72.0f,
    72.0f,72.0f,64.0f,64.0f,56.0f,56.0f,48.0f,48.0f,
    40.0f,32.0f,24.0f,16.0f,24.0f,24.0f,24.0f,16.0f,
    16.0f,16.0f,16.0f,24.0f,16.0f,16.0f,16.0f,8.0f,
    8.0f,8.0f,8.0f,0.0f,0.0f,-1.0f,-9.0f,-25.0f,
    -33.0f,-57.0f,-73.0f,-89.0f,-97.0f,-113.0f,-113.0f,-113.0f,
    -121.0f,-121.0f,-129.0f,-137.0f,-145.0f,-145.0f,-145.0f,-153.0f,
    -153.0f,-145.0f,-137.0f,-121.0f,-113.0f,-105.0f,-89.0f,-81.0f,
    -73.0f,-57.0f,-41.0f,-25.0f,-9.0f,0.0f,24.0f,48.0f,
    64.0f,80.0f,96.0f,104.0f,112.0f,120.0f,120.0f,112.0f,
    112.0f,112.0f,112.0f,112.0f,104.0f,112.0f,120.0f,128.0f,
    120.0f,112.0f,104.0f,96.0f,80.0f,64.0f,56.0f,48.0f,
    40.0f,32.0f,32.0f,32.0f,16.0f,8.0f,0.0f,-1.0f,
    -9.0f,-9.0f,-17.0f,-25.0f,-33.0f,-41.0f,-49.0f,-57.0f,
    -65.0f,-73.0f,-81.0f,-81.0f,-81.0f,-81.0f,-89.0f,-89.0f,
    -89.0f,-89.0f,-97.0f,-97.0f,-97.0f,-97.0f,-81.0f,-81.0f,
    -73.0f,-65.0f,-57.0f,-49.0f,-33.0f,-33.0f,-25.0f,-17.0f,
    -17.0f,-9.0f,-9.0f,-9.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,0.0f,0.0f,8.0f,8.0f,16.0f,16.0f,16.0f,
    8.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,8.0f,16.0f,24.0f,
    32.0f,32.0f,40.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,56.0f,
    0
}; t_CKUINT mand8_size = 1024;

// data for mand9.raw...
SAMPLE mand9_data[] = {
    0.0f,40.0f,-595.0f,-1559.0f,-1478.0f,-386.0f,-217.0f,-1856.0f,
    -3012.0f,-1591.0f,1293.0f,3035.0f,2995.0f,2545.0f,2305.0f,1204.0f,
    40.0f,594.0f,2023.0f,2224.0f,1598.0f,1285.0f,1622.0f,2513.0f,
    2457.0f,618.0f,-1141.0f,-1398.0f,-836.0f,-450.0f,-1181.0f,-1800.0f,
    -1269.0f,-820.0f,-1310.0f,-2097.0f,-2466.0f,-2587.0f,-2482.0f,-2073.0f,
    -1992.0f,-2860.0f,-3486.0f,-2948.0f,-1759.0f,-860.0f,-755.0f,-306.0f,
    562.0f,722.0f,401.0f,32.0f,369.0f,1389.0f,1702.0f,1036.0f,
    289.0f,289.0f,963.0f,1887.0f,1951.0f,1517.0f,1405.0f,1542.0f,
    2064.0f,2843.0f,3059.0f,2521.0f,1999.0f,1550.0f,1437.0f,1188.0f,
    803.0f,787.0f,642.0f,401.0f,313.0f,377.0f,377.0f,-121.0f,
    -547.0f,-772.0f,-1221.0f,-1342.0f,-1318.0f,-1269.0f,-1470.0f,-1920.0f,
    -2169.0f,-1856.0f,-852.0f,-298.0f,-547.0f,-884.0f,-788.0f,-474.0f,
    -539.0f,-836.0f,-1213.0f,-1253.0f,-619.0f,24.0f,273.0f,40.0f,
    -145.0f,-346.0f,-563.0f,-683.0f,-1093.0f,-1253.0f,-828.0f,-81.0f,
    811.0f,1244.0f,851.0f,329.0f,200.0f,449.0f,730.0f,738.0f,
    859.0f,1469.0f,1758.0f,1349.0f,875.0f,746.0f,995.0f,1220.0f,
    1084.0f,811.0f,947.0f,1180.0f,971.0f,176.0f,-812.0f,-1647.0f,
    -2097.0f,-1896.0f,-1334.0f,-956.0f,-988.0f,-1173.0f,-948.0f,-458.0f,
    -282.0f,-434.0f,-547.0f,-354.0f,144.0f,586.0f,586.0f,449.0f,
    305.0f,224.0f,184.0f,-9.0f,-121.0f,176.0f,698.0f,931.0f,
    698.0f,353.0f,144.0f,88.0f,176.0f,345.0f,457.0f,530.0f,
    634.0f,473.0f,297.0f,144.0f,-57.0f,-65.0f,120.0f,465.0f,
    730.0f,754.0f,618.0f,481.0f,345.0f,144.0f,-89.0f,-193.0f,
    -161.0f,-97.0f,-225.0f,-707.0f,-1117.0f,-1334.0f,-1414.0f,-1277.0f,
    -1085.0f,-796.0f,-539.0f,-490.0f,-603.0f,-667.0f,-450.0f,-153.0f,
    -9.0f,-105.0f,-290.0f,-378.0f,-354.0f,-249.0f,-225.0f,-306.0f,
    -314.0f,-169.0f,56.0f,321.0f,465.0f,489.0f,457.0f,321.0f,
    152.0f,40.0f,-49.0f,0.0f,208.0f,530.0f,819.0f,907.0f,
    867.0f,835.0f,835.0f,827.0f,795.0f,795.0f,819.0f,843.0f,
    730.0f,546.0f,393.0f,265.0f,112.0f,-17.0f,-81.0f,-129.0f,
    -225.0f,-410.0f,-659.0f,-852.0f,-988.0f,-1012.0f,-908.0f,-804.0f,
    -691.0f,-531.0f,-306.0f,-9.0f,160.0f,144.0f,96.0f,48.0f,
    80.0f,160.0f,265.0f,353.0f,305.0f,184.0f,-33.0f,-241.0f,
    -306.0f,-274.0f,-209.0f,-249.0f,-274.0f,-177.0f,-41.0f,-9.0f,
    -73.0f,-209.0f,-338.0f,-282.0f,-153.0f,8.0f,120.0f,144.0f,
    112.0f,88.0f,168.0f,248.0f,265.0f,176.0f,48.0f,16.0f,
    72.0f,128.0f,208.0f,248.0f,176.0f,16.0f,-113.0f,-129.0f,
    -73.0f,-49.0f,-65.0f,-89.0f,-113.0f,-105.0f,-57.0f,24.0f,
    120.0f,184.0f,200.0f,160.0f,112.0f,64.0f,-1.0f,-65.0f,
    -153.0f,-233.0f,-266.0f,-258.0f,-185.0f,-113.0f,-97.0f,-97.0f,
    -25.0f,64.0f,144.0f,160.0f,160.0f,120.0f,64.0f,32.0f,
    0.0f,-1.0f,56.0f,168.0f,289.0f,353.0f,337.0f,305.0f,
    297.0f,329.0f,369.0f,305.0f,176.0f,56.0f,16.0f,56.0f,
    56.0f,16.0f,-65.0f,-161.0f,-225.0f,-266.0f,-290.0f,-282.0f,
    -266.0f,-274.0f,-282.0f,-298.0f,-290.0f,-233.0f,-169.0f,-121.0f,
    -113.0f,-121.0f,-137.0f,-137.0f,-113.0f,-97.0f,-145.0f,-161.0f,
    -129.0f,-73.0f,-17.0f,0.0f,0.0f,-41.0f,-89.0f,-137.0f,
    -153.0f,-145.0f,-121.0f,-97.0f,-97.0f,-49.0f,8.0f,96.0f,
    176.0f,257.0f,329.0f,353.0f,329.0f,297.0f,297.0f,281.0f,
    248.0f,200.0f,168.0f,152.0f,192.0f,265.0f,337.0f,385.0f,
    353.0f,273.0f,176.0f,104.0f,72.0f,24.0f,-33.0f,-89.0f,
    -129.0f,-161.0f,-177.0f,-169.0f,-145.0f,-153.0f,-185.0f,-201.0f,
    -193.0f,-153.0f,-145.0f,-161.0f,-153.0f,-129.0f,-97.0f,-73.0f,
    -73.0f,-65.0f,-57.0f,-65.0f,-57.0f,-25.0f,0.0f,16.0f,
    8.0f,8.0f,-1.0f,-41.0f,-81.0f,-81.0f,-41.0f,0.0f,
    16.0f,8.0f,-17.0f,-25.0f,-9.0f,8.0f,16.0f,0.0f,
    -17.0f,-25.0f,-9.0f,0.0f,8.0f,-1.0f,-17.0f,-41.0f,
    -41.0f,-33.0f,-9.0f,8.0f,32.0f,32.0f,32.0f,48.0f,
    56.0f,64.0f,48.0f,40.0f,48.0f,64.0f,80.0f,96.0f,
    80.0f,40.0f,-1.0f,-41.0f,-49.0f,-33.0f,-1.0f,8.0f,
    24.0f,48.0f,80.0f,104.0f,96.0f,56.0f,16.0f,-1.0f,
    -9.0f,-17.0f,-25.0f,-17.0f,8.0f,32.0f,48.0f,48.0f,
    48.0f,64.0f,96.0f,120.0f,128.0f,120.0f,112.0f,80.0f,
    48.0f,16.0f,0.0f,-1.0f,-9.0f,-25.0f,-33.0f,-41.0f,
    -73.0f,-121.0f,-169.0f,-209.0f,-225.0f,-225.0f,-209.0f,-185.0f,
    -153.0f,-129.0f,-121.0f,-105.0f,-81.0f,-57.0f,-49.0f,-33.0f,
    -25.0f,-1.0f,8.0f,16.0f,8.0f,8.0f,-1.0f,-9.0f,
    -9.0f,-1.0f,16.0f,40.0f,56.0f,64.0f,72.0f,88.0f,
    104.0f,120.0f,120.0f,104.0f,96.0f,96.0f,96.0f,88.0f,
    64.0f,40.0f,40.0f,40.0f,48.0f,72.0f,96.0f,112.0f,
    104.0f,88.0f,80.0f,72.0f,72.0f,56.0f,32.0f,16.0f,
    16.0f,16.0f,8.0f,-1.0f,-1.0f,-9.0f,-17.0f,-33.0f,
    -49.0f,-49.0f,-33.0f,-33.0f,-33.0f,-25.0f,-25.0f,-25.0f,
    -33.0f,-33.0f,-33.0f,-41.0f,-41.0f,-25.0f,-9.0f,0.0f,
    -1.0f,-33.0f,-57.0f,-73.0f,-73.0f,-65.0f,-49.0f,-41.0f,
    -25.0f,-1.0f,8.0f,16.0f,24.0f,40.0f,40.0f,32.0f,
    24.0f,16.0f,8.0f,8.0f,-1.0f,-17.0f,-33.0f,-41.0f,
    -41.0f,-33.0f,-17.0f,-9.0f,0.0f,8.0f,8.0f,8.0f,
    16.0f,32.0f,48.0f,56.0f,64.0f,88.0f,112.0f,120.0f,
    112.0f,96.0f,72.0f,56.0f,48.0f,40.0f,40.0f,40.0f,
    48.0f,48.0f,40.0f,24.0f,16.0f,16.0f,8.0f,0.0f,
    -9.0f,-25.0f,-33.0f,-25.0f,-25.0f,-25.0f,-25.0f,-25.0f,
    -17.0f,-1.0f,0.0f,8.0f,8.0f,8.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,8.0f,16.0f,16.0f,16.0f,
    8.0f,-1.0f,-17.0f,-33.0f,-41.0f,-41.0f,-33.0f,-25.0f,
    -17.0f,-9.0f,-1.0f,0.0f,8.0f,16.0f,16.0f,16.0f,
    16.0f,8.0f,8.0f,8.0f,0.0f,0.0f,-1.0f,-9.0f,
    -17.0f,-9.0f,-1.0f,8.0f,8.0f,16.0f,16.0f,24.0f,
    24.0f,32.0f,32.0f,32.0f,32.0f,32.0f,40.0f,40.0f,
    32.0f,24.0f,16.0f,16.0f,8.0f,16.0f,16.0f,8.0f,
    8.0f,8.0f,0.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,-1.0f,
    0
}; t_CKUINT mand9_size = 1024;

// data for mandpluk.raw...
SAMPLE mandpluk_data[] = {
    0.0f,8.0f,96.0f,224.0f,265.0f,16.0f,-498.0f,-948.0f,
    -651.0f,754.0f,2754.0f,3847.0f,2160.0f,-3165.0f,-11044.0f,-18722.0f,
    -23018.0f,-22119.0f,-16425.0f,-8144.0f,361.0f,7766.0f,14006.0f,19628.0f,
    24664.0f,28358.0f,29788.0f,28712.0f,25869.0f,22335.0f,18648.0f,14336.0f,
    8465.0f,570.0f,-8506.0f,-16939.0f,-22745.0f,-24817.0f,-23275.0f,-19284.0f,
    -14497.0f,-10658.0f,-9204.0f,-11003.0f,-15686.0f,-21500.0f,-25709.0f,-25741.0f,
    -20673.0f,-11983.0f,-3125.0f,1935.0f,787.0f,-6144.0f,-15605.0f,-23018.0f,
    -24785.0f,-20095.0f,-11277.0f,-2635.0f,2184.0f,2128.0f,-804.0f,-2948.0f,
    -1229.0f,5172.0f,14456.0f,23523.0f,29683.0f,31964.0f,31153.0f,29057.0f,
    27362.0f,26937.0f,27555.0f,28190.0f,27652.0f,25090.0f,20568.0f,15187.0f,
    10617.0f,8440.0f,9131.0f,11790.0f,14488.0f,15364.0f,13613.0f,9854.0f,
    5686.0f,2698.0f,1542.0f,1662.0f,1879.0f,931.0f,-1783.0f,-6241.0f,
    -11766.0f,-17380.0f,-22215.0f,-25669.0f,-27620.0f,-28407.0f,-28648.0f,-28833.0f,
    -29114.0f,-29178.0f,-28640.0f,-27251.0f,-25307.0f,-23364.0f,-21926.0f,-21059.0f,
    -20344.0f,-19212.0f,-17533.0f,-15710.0f,-14385.0f,-13734.0f,-13076.0f,-11285.0f,
    -7510.0f,-2089.0f,3357.0f,6866.0f,7388.0f,5437.0f,2947.0f,2048.0f,
    4047.0f,8746.0f,14858.0f,20857.0f,25628.0f,28728.0f,30326.0f,30824.0f,
    30768.0f,30591.0f,30454.0f,30214.0f,29386.0f,27547.0f,24616.0f,21122.0f,
    17845.0f,15331.0f,13573.0f,12103.0f,10472.0f,8770.0f,7356.0f,6585.0f,
    6240.0f,5437.0f,3324.0f,-137.0f,-4008.0f,-6795.0f,-7413.0f,-5960.0f,
    -3542.0f,-1735.0f,-1438.0f,-2554.0f,-4337.0f,-5928.0f,-6883.0f,-7317.0f,
    -7743.0f,-8867.0f,-11429.0f,-15758.0f,-21348.0f,-26504.0f,-28809.0f,-26303.0f,
    -18834.0f,-8570.0f,915.0f,6505.0f,7244.0f,4513.0f,738.0f,-2354.0f,
    -4755.0f,-7534.0f,-11357.0f,-15509.0f,-18111.0f,-17573.0f,-13975.0f,-9269.0f,
    -6096.0f,-6088.0f,-8707.0f,-11903.0f,-13525.0f,-12851.0f,-10859.0f,-9365.0f,
    -9518.0f,-10955.0f,-12240.0f,-11927.0f,-9702.0f,-6393.0f,-3390.0f,-1575.0f,
    -884.0f,-683.0f,-346.0f,240.0f,891.0f,1293.0f,1509.0f,2007.0f,
    3204.0f,5260.0f,7798.0f,10007.0f,11107.0f,10737.0f,9316.0f,7951.0f,
    7910.0f,9910.0f,13629.0f,17717.0f,20720.0f,21965.0f,21941.0f,21901.0f,
    22801.0f,24455.0f,25595.0f,24760.0f,21491.0f,16793.0f,12601.0f,10617.0f,
    11292.0f,13661.0f,16151.0f,17532.0f,17500.0f,16480.0f,14970.0f,13139.0f,
    10770.0f,7846.0f,4634.0f,1807.0f,-217.0f,-1462.0f,-2330.0f,-3237.0f,
    -4145.0f,-4578.0f,-4185.0f,-3277.0f,-2860.0f,-4225.0f,-8040.0f,-13871.0f,
    -20280.0f,-25580.0f,-28817.0f,-30054.0f,-30054.0f,-29556.0f,-28841.0f,-27669.0f,
    -25773.0f,-23211.0f,-20280.0f,-17188.0f,-13871.0f,-10168.0f,-6289.0f,-3068.0f,
    -1583.0f,-2474.0f,-5406.0f,-9028.0f,-11831.0f,-12803.0f,-12080.0f,-10514.0f,
    -9060.0f,-8120.0f,-7486.0f,-6610.0f,-5092.0f,-2972.0f,-587.0f,1550.0f,
    3148.0f,4168.0f,4802.0f,5300.0f,5919.0f,6698.0f,7589.0f,8392.0f,
    8858.0f,8794.0f,8192.0f,7268.0f,6481.0f,6417.0f,7613.0f,10223.0f,
    13797.0f,17283.0f,19427.0f,19347.0f,17187.0f,14239.0f,12312.0f,12785.0f,
    15701.0f,19660.0f,22640.0f,23162.0f,21050.0f,17540.0f,14311.0f,12488.0f,
    12111.0f,12231.0f,11790.0f,10248.0f,7902.0f,5493.0f,3766.0f,2995.0f,
    3019.0f,3405.0f,3654.0f,3437.0f,2545.0f,1052.0f,-772.0f,-2522.0f,
    -3880.0f,-4675.0f,-5092.0f,-5494.0f,-6112.0f,-6980.0f,-8000.0f,-9156.0f,
    -10650.0f,-12875.0f,-16087.0f,-20151.0f,-24408.0f,-27869.0f,-29773.0f,-29837.0f,
    -28488.0f,-26544.0f,-24785.0f,-23589.0f,-22761.0f,-21846.0f,-20440.0f,-18521.0f,
    -16441.0f,-14658.0f,-13461.0f,-12738.0f,-12112.0f,-11044.0f,-9325.0f,-7084.0f,
    -4715.0f,-2635.0f,-1053.0f,176.0f,1429.0f,2923.0f,4706.0f,6465.0f,
    7806.0f,8368.0f,8175.0f,7661.0f,7541.0f,8449.0f,10681.0f,14070.0f,
    17982.0f,21756.0f,24881.0f,27138.0f,28503.0f,28985.0f,28615.0f,27403.0f,
    25531.0f,23315.0f,21130.0f,19243.0f,17677.0f,16279.0f,14785.0f,13091.0f,
    11203.0f,9252.0f,7372.0f,5694.0f,4232.0f,2971.0f,1839.0f,690.0f,
    -506.0f,-1896.0f,-3366.0f,-4651.0f,-5502.0f,-5711.0f,-5390.0f,-5028.0f,
    -5229.0f,-6337.0f,-8209.0f,-10104.0f,-11156.0f,-10795.0f,-9156.0f,-7028.0f,
    -5406.0f,-4908.0f,-5470.0f,-6482.0f,-7261.0f,-7534.0f,-7486.0f,-7446.0f,
    -7494.0f,-7317.0f,-6450.0f,-4811.0f,-2892.0f,-1526.0f,-1406.0f,-2506.0f,
    -4201.0f,-5775.0f,-6907.0f,-8016.0f,-9855.0f,-12803.0f,-16489.0f,-19830.0f,
    -21645.0f,-21404.0f,-19452.0f,-16754.0f,-14296.0f,-12521.0f,-11341.0f,-10329.0f,
    -9196.0f,-7911.0f,-6650.0f,-5614.0f,-4731.0f,-3920.0f,-3044.0f,-2145.0f,
    -1294.0f,-498.0f,329.0f,1381.0f,2706.0f,4168.0f,5565.0f,6778.0f,
    7830.0f,8906.0f,10231.0f,11902.0f,13926.0f,16151.0f,18383.0f,20359.0f,
    21748.0f,22295.0f,21981.0f,21090.0f,20150.0f,19620.0f,19628.0f,19877.0f,
    19853.0f,19138.0f,17765.0f,16094.0f,14568.0f,13452.0f,12609.0f,11709.0f,
    10505.0f,8946.0f,7252.0f,5718.0f,4433.0f,3381.0f,2401.0f,1397.0f,
    313.0f,-731.0f,-1695.0f,-2546.0f,-3438.0f,-4530.0f,-5968.0f,-7743.0f,
    -9654.0f,-11236.0f,-12040.0f,-11871.0f,-10987.0f,-10176.0f,-10377.0f,-12152.0f,
    -15276.0f,-18770.0f,-21324.0f,-22031.0f,-20898.0f,-18890.0f,-17332.0f,-17083.0f,
    -18071.0f,-19348.0f,-19734.0f,-18593.0f,-16240.0f,-13549.0f,-11485.0f,-10417.0f,
    -10040.0f,-9662.0f,-8779.0f,-7325.0f,-5582.0f,-3944.0f,-2563.0f,-1438.0f,
    -458.0f,377.0f,971.0f,1317.0f,1622.0f,2208.0f,3357.0f,5075.0f,
    7003.0f,8754.0f,10127.0f,11308.0f,12761.0f,14817.0f,17387.0f,19853.0f,
    21347.0f,21299.0f,19765.0f,17428.0f,15299.0f,14167.0f,14191.0f,14946.0f,
    15717.0f,15886.0f,15267.0f,14087.0f,12705.0f,11412.0f,10280.0f,9244.0f,
    8208.0f,7099.0f,5911.0f,4658.0f,3397.0f,2248.0f,1397.0f,947.0f,
    811.0f,722.0f,361.0f,-426.0f,-1551.0f,-2683.0f,-3550.0f,-4080.0f,
    -4514.0f,-5253.0f,-6538.0f,-8385.0f,-10409.0f,-12088.0f,-12955.0f,-12899.0f,
    -12184.0f,-11325.0f,-10827.0f,-10915.0f,-11381.0f,-11807.0f,-11911.0f,-11702.0f,
    -11542.0f,-11847.0f,-12738.0f,-13927.0f,-14818.0f,-14931.0f,-14168.0f,-12835.0f,
    -11477.0f,-10506.0f,-10008.0f,-9791.0f,-9598.0f,-9204.0f,-8522.0f,-7574.0f,
    -6377.0f,-5052.0f,-3783.0f,-2771.0f,-2129.0f,-1816.0f,-1575.0f,-1165.0f,
    -354.0f,859.0f,2329.0f,3822.0f,5115.0f,5999.0f,6376.0f,6352.0f,
    6111.0f,5927.0f,5983.0f,6248.0f,6513.0f,6489.0f,6135.0f,5734.0f,
    5838.0f,6898.0f,9091.0f,12071.0f,15171.0f,17789.0f,19540.0f,20399.0f,
    20504.0f,20038.0f,19074.0f,17701.0f,16054.0f,14376.0f,12946.0f,11886.0f,
    11147.0f,10521.0f,9806.0f,8914.0f,7910.0f,6890.0f,5943.0f,5051.0f,
    4128.0f,3148.0f,2072.0f,995.0f,-73.0f,-1109.0f,-2065.0f,-2932.0f,
    -3663.0f,-4185.0f,-4522.0f,-4771.0f,-4988.0f,-5253.0f,-5606.0f,-6056.0f,
    -6626.0f,-7357.0f,-8257.0f,-9309.0f,-10377.0f,-11373.0f,-12321.0f,-13341.0f,
    -14626.0f,-16240.0f,-17927.0f,-19236.0f,-19726.0f,-19147.0f,-17702.0f,-15903.0f,
    -14312.0f,-13252.0f,-12714.0f,-12409.0f,-12056.0f,-11469.0f,-10746.0f,-10080.0f,
    -9558.0f,-9140.0f,-8658.0f,-7935.0f,-6899.0f,-5671.0f,-4378.0f,-3205.0f,
    -2145.0f,-1141.0f,-113.0f,971.0f,2104.0f,3180.0f,4136.0f,5027.0f,
    5935.0f,7003.0f,8304.0f,9798.0f,11340.0f,12769.0f,14062.0f,15299.0f,
    16592.0f,17966.0f,19259.0f,20150.0f,20399.0f,19965.0f,19042.0f,17958.0f,
    16938.0f,16022.0f,15115.0f,14135.0f,13107.0f,12167.0f,11420.0f,10818.0f,
    10231.0f,9420.0f,8344.0f,7115.0f,5870.0f,4730.0f,3710.0f,2690.0f,
    1574.0f,337.0f,-932.0f,-2121.0f,-3197.0f,-4153.0f,-5020.0f,-5847.0f,
    -6659.0f,-7470.0f,-8305.0f,-9229.0f,-10240.0f,-11317.0f,-12417.0f,-13509.0f,
    -14585.0f,-15622.0f,-16561.0f,-17324.0f,-17782.0f,-17870.0f,-17573.0f,-16923.0f,
    -15999.0f,-14867.0f,-13590.0f,-12280.0f,-11044.0f,-9975.0f,-9108.0f,-8409.0f,
    -7815.0f,-7277.0f,-6787.0f,-6321.0f,-5855.0f,-5213.0f,-4297.0f,-3133.0f,
    -1783.0f,-394.0f,939.0f,2224.0f,3557.0f,4931.0f,6288.0f,7429.0f,
    8191.0f,8449.0f,8256.0f,7782.0f,7268.0f,6995.0f,7180.0f,7934.0f,
    9115.0f,10440.0f,11541.0f,12079.0f,11990.0f,11412.0f,10593.0f,9742.0f,
    8874.0f,7886.0f,6674.0f,5316.0f,4055.0f,3252.0f,3148.0f,3766.0f,
    4891.0f,6184.0f,7324.0f,8087.0f,8384.0f,8312.0f,7999.0f,7557.0f,
    7083.0f,6561.0f,5935.0f,5124.0f,4144.0f,3124.0f,2240.0f,1670.0f,
    1445.0f,1461.0f,1533.0f,1437.0f,1084.0f,497.0f,-225.0f,-980.0f,
    -1703.0f,-2370.0f,-3012.0f,-3687.0f,-4426.0f,-5301.0f,-6321.0f,-7373.0f,
    -8225.0f,-8690.0f,-8690.0f,-8409.0f,-8257.0f,-8618.0f,-9670.0f,-11212.0f,
    -12819.0f,-14120.0f,-14947.0f,-15501.0f,-16063.0f,-16722.0f,-17316.0f,-17445.0f,
    -16818.0f,-15461.0f,-13710.0f,-11967.0f,-10481.0f,-9245.0f,-8056.0f,-6795.0f,
    -5510.0f,-4345.0f,-3422.0f,-2667.0f,-1904.0f,-1012.0f,-57.0f,779.0f,
    1309.0f,1574.0f,1799.0f,2305.0f,3284.0f,4650.0f,6216.0f,7782.0f,
    9220.0f,10569.0f,11902.0f,13147.0f,14199.0f,14922.0f,15283.0f,15355.0f,
    15275.0f,15171.0f,15115.0f,15131.0f,15211.0f,15331.0f,15388.0f,15243.0f,
    14753.0f,13813.0f,12488.0f,10986.0f,9549.0f,8296.0f,7228.0f,6200.0f,
    5075.0f,3847.0f,2634.0f,1662.0f,995.0f,626.0f,385.0f,48.0f,
    -498.0f,-1261.0f,-2105.0f,-2924.0f,-3623.0f,-4225.0f,-4851.0f,-5606.0f,
    -6546.0f,-7590.0f,-8562.0f,-9317.0f,-9718.0f,-9815.0f,-9775.0f,-9791.0f,
    -10008.0f,-10441.0f,-10971.0f,-11389.0f,-11558.0f,-11445.0f,-11140.0f,-10859.0f,
    -10795.0f,-11044.0f,-11517.0f,-11975.0f,-12112.0f,-11662.0f,-10618.0f,-9204.0f,
    -7783.0f,-6626.0f,-5847.0f,-5269.0f,-4611.0f,-3703.0f,-2554.0f,-1430.0f,
    -563.0f,-113.0f,-9.0f,-41.0f,56.0f,457.0f,1252.0f,2457.0f,
    3967.0f,5597.0f,7123.0f,8376.0f,9308.0f,9999.0f,10601.0f,11179.0f,
    11645.0f,11806.0f,11581.0f,11115.0f,10705.0f,10617.0f,10874.0f,11268.0f,
    11492.0f,11380.0f,11002.0f,10569.0f,10207.0f,9838.0f,9252.0f,8296.0f,
    7075.0f,5806.0f,4786.0f,4112.0f,3662.0f,3188.0f,2553.0f,1831.0f,
    1172.0f,746.0f,505.0f,289.0f,-121.0f,-780.0f,-1559.0f,-2289.0f,
    -2924.0f,-3542.0f,-4289.0f,-5293.0f,-6361.0f,-7213.0f,-7534.0f,-7277.0f,
    -6731.0f,-6329.0f,-6377.0f,-6851.0f,-7421.0f,-7711.0f,-7646.0f,-7462.0f,
    -7558.0f,-8160.0f,-9124.0f,-10064.0f,-10618.0f,-10706.0f,-10498.0f,-10232.0f,
    -9959.0f,-9510.0f,-8682.0f,-7470.0f,-6120.0f,-4988.0f,-4281.0f,-3888.0f,
    -3486.0f,-2820.0f,-1960.0f,-1157.0f,-707.0f,-651.0f,-715.0f,-531.0f,
    160.0f,1268.0f,2449.0f,3397.0f,3983.0f,4312.0f,4626.0f,5043.0f,
    5485.0f,5774.0f,5782.0f,5549.0f,5228.0f,4995.0f,4875.0f,4778.0f,
    4569.0f,4256.0f,4039.0f,4144.0f,4746.0f,5718.0f,6698.0f,7316.0f,
    7396.0f,7035.0f,6537.0f,6184.0f,6071.0f,6055.0f,5935.0f,5629.0f,
    5252.0f,4995.0f,4987.0f,5188.0f,5405.0f,5445.0f,5292.0f,5027.0f,
    4794.0f,4601.0f,4361.0f,3943.0f,3244.0f,2353.0f,1437.0f,626.0f,
    -25.0f,-587.0f,-1133.0f,-1751.0f,-2410.0f,-3093.0f,-3711.0f,-4257.0f,
    -4747.0f,-5213.0f,-5671.0f,-6136.0f,-6594.0f,-7076.0f,-7622.0f,-8273.0f,
    -9036.0f,-9823.0f,-10441.0f,-10738.0f,-10626.0f,-10184.0f,-9606.0f,-9068.0f,
    -8618.0f,-8168.0f,-7558.0f,-6763.0f,-5936.0f,-5293.0f,-4988.0f,-4972.0f,
    -4988.0f,-4795.0f,-4265.0f,-3518.0f,-2731.0f,-2057.0f,-1486.0f,-876.0f,
    -137.0f,714.0f,1566.0f,2272.0f,2794.0f,3148.0f,3397.0f,3614.0f,
    3798.0f,3983.0f,4216.0f,4601.0f,5188.0f,5943.0f,6746.0f,7493.0f,
    8063.0f,8424.0f,8657.0f,8786.0f,8842.0f,8778.0f,8593.0f,8296.0f,
    7951.0f,7589.0f,7220.0f,6794.0f,6304.0f,5798.0f,5364.0f,5083.0f,
    4931.0f,4818.0f,4585.0f,4160.0f,3541.0f,2794.0f,2047.0f,1325.0f,
    634.0f,-25.0f,-659.0f,-1245.0f,-1751.0f,-2137.0f,-2394.0f,-2482.0f,
    -2402.0f,-2177.0f,-1912.0f,-1767.0f,-1888.0f,-2322.0f,-3028.0f,-3839.0f,
    -4611.0f,-5293.0f,-5904.0f,-6498.0f,-7124.0f,-7678.0f,-8056.0f,-8152.0f,
    -7952.0f,-7542.0f,-7036.0f,-6530.0f,-6120.0f,-5823.0f,-5695.0f,-5799.0f,
    -6128.0f,-6578.0f,-6980.0f,-7116.0f,-6899.0f,-6345.0f,-5606.0f,-4851.0f,
    -4169.0f,-3558.0f,-2940.0f,-2257.0f,-1518.0f,-788.0f,-169.0f,273.0f,
    546.0f,682.0f,754.0f,867.0f,1116.0f,1542.0f,2152.0f,2907.0f,
    3726.0f,4513.0f,5252.0f,5895.0f,6457.0f,6939.0f,7332.0f,7597.0f,
    7710.0f,7653.0f,7420.0f,7035.0f,6553.0f,6079.0f,5670.0f,5405.0f,
    5284.0f,5260.0f,5260.0f,5252.0f,5212.0f,5148.0f,5035.0f,4826.0f,
    4505.0f,4063.0f,3533.0f,2979.0f,2449.0f,1975.0f,1517.0f,1108.0f,
    779.0f,602.0f,618.0f,762.0f,915.0f,915.0f,674.0f,192.0f,
    -402.0f,-1029.0f,-1623.0f,-2249.0f,-3004.0f,-3912.0f,-4868.0f,-5695.0f,
    -6201.0f,-6321.0f,-6145.0f,-5863.0f,-5647.0f,-5566.0f,-5590.0f,-5598.0f,
    -5550.0f,-5454.0f,-5414.0f,-5494.0f,-5727.0f,-6024.0f,-6273.0f,-6442.0f,
    -6466.0f,-6369.0f,-6161.0f,-5815.0f,-5333.0f,-4739.0f,-4113.0f,-3558.0f,
    -3093.0f,-2723.0f,-2418.0f,-2105.0f,-1767.0f,-1398.0f,-972.0f,-482.0f,
    80.0f,706.0f,1333.0f,1903.0f,2369.0f,2786.0f,3212.0f,3694.0f,
    4184.0f,4634.0f,4955.0f,5140.0f,5244.0f,5332.0f,5453.0f,5581.0f,
    5686.0f,5774.0f,5911.0f,6168.0f,6585.0f,7091.0f,7533.0f,7774.0f,
    7782.0f,7613.0f,7356.0f,7107.0f,6850.0f,6521.0f,6071.0f,5493.0f,
    4842.0f,4224.0f,3710.0f,3276.0f,2867.0f,2401.0f,1871.0f,1276.0f,
    674.0f,96.0f,-474.0f,-1157.0f,-1984.0f,-2940.0f,-3920.0f,-4739.0f,
    -5309.0f,-5614.0f,-5751.0f,-5855.0f,-5992.0f,-6144.0f,-6241.0f,-6265.0f,
    -6201.0f,-6104.0f,-6024.0f,-6008.0f,-6088.0f,-6265.0f,-6562.0f,-6916.0f,
    -7229.0f,-7389.0f,-7325.0f,-7012.0f,-6546.0f,-6032.0f,-5526.0f,-5044.0f,
    -4546.0f,-3992.0f,-3366.0f,-2699.0f,-2057.0f,-1510.0f,-1053.0f,-707.0f,
    -426.0f,-153.0f,120.0f,457.0f,843.0f,1228.0f,1598.0f,1983.0f,
    2393.0f,2883.0f,3413.0f,3935.0f,4353.0f,4610.0f,4722.0f,4722.0f,
    4666.0f,4577.0f,4473.0f,4385.0f,4385.0f,4537.0f,4867.0f,5300.0f,
    5694.0f,5919.0f,5919.0f,5766.0f,5565.0f,5397.0f,5228.0f,4963.0f,
    4513.0f,3863.0f,3084.0f,2353.0f,1799.0f,1469.0f,1349.0f,1341.0f,
    1365.0f,1365.0f,1317.0f,1236.0f,1132.0f,1028.0f,907.0f,754.0f,
    514.0f,160.0f,-274.0f,-763.0f,-1181.0f,-1438.0f,-1510.0f,-1438.0f,
    -1350.0f,-1414.0f,-1711.0f,-2217.0f,-2820.0f,-3366.0f,-3767.0f,-4024.0f,
    -4217.0f,-4490.0f,-4900.0f,-5438.0f,-6040.0f,-6586.0f,-7020.0f,-7269.0f,
    -7317.0f,-7189.0f,-6916.0f,-6570.0f,-6201.0f,-5871.0f,-5574.0f,-5285.0f,
    -4980.0f,-4643.0f,-4321.0f,-4040.0f,-3807.0f,-3591.0f,-3309.0f,-2860.0f,
    -2209.0f,-1382.0f,-458.0f,465.0f,1325.0f,2056.0f,2674.0f,3212.0f,
    3710.0f,4152.0f,4561.0f,4875.0f,5091.0f,5212.0f,5316.0f,5477.0f,
    5726.0f,6015.0f,6256.0f,6360.0f,6256.0f,6015.0f,5694.0f,5405.0f,
    5172.0f,4939.0f,4626.0f,4192.0f,3662.0f,3132.0f,2738.0f,2529.0f,
    2497.0f,2537.0f,2545.0f,2465.0f,2288.0f,2080.0f,1879.0f,1702.0f,
    1533.0f,1341.0f,1092.0f,762.0f,369.0f,-57.0f,-490.0f,-884.0f,
    -1197.0f,-1406.0f,-1502.0f,-1534.0f,-1551.0f,-1591.0f,-1695.0f,-1832.0f,
    -1984.0f,-2129.0f,-2289.0f,-2498.0f,-2771.0f,-3101.0f,-3438.0f,-3719.0f,
    -3872.0f,-3904.0f,-3831.0f,-3711.0f,-3607.0f,-3566.0f,-3607.0f,-3711.0f,
    -3864.0f,-4000.0f,-4088.0f,-4105.0f,-4080.0f,-4008.0f,-3920.0f,-3823.0f,
    -3679.0f,-3446.0f,-3117.0f,-2691.0f,-2209.0f,-1719.0f,-1261.0f,-884.0f,
    -627.0f,-482.0f,-442.0f,-434.0f,-426.0f,-370.0f,-258.0f,-113.0f,
    56.0f,257.0f,505.0f,811.0f,1188.0f,1630.0f,2112.0f,2674.0f,
    3284.0f,3943.0f,4585.0f,5148.0f,5525.0f,5670.0f,5565.0f,5324.0f,
    5067.0f,4915.0f,4915.0f,5043.0f,5236.0f,5405.0f,5477.0f,5421.0f,
    5228.0f,4915.0f,4521.0f,4079.0f,3598.0f,3092.0f,2545.0f,1935.0f,
    1244.0f,530.0f,-113.0f,-635.0f,-980.0f,-1157.0f,-1229.0f,-1302.0f,
    -1422.0f,-1623.0f,-1888.0f,-2169.0f,-2458.0f,-2715.0f,-2932.0f,-3133.0f,
    -3350.0f,-3615.0f,-3944.0f,-4297.0f,-4619.0f,-4795.0f,-4787.0f,-4578.0f,
    -4233.0f,-3848.0f,-3518.0f,-3301.0f,-3229.0f,-3245.0f,-3277.0f,-3245.0f,
    -3101.0f,-2876.0f,-2651.0f,-2506.0f,-2466.0f,-2490.0f,-2490.0f,-2386.0f,
    -2161.0f,-1872.0f,-1583.0f,-1318.0f,-1093.0f,-860.0f,-643.0f,-466.0f,
    -370.0f,-338.0f,-298.0f,-145.0f,176.0f,642.0f,1116.0f,1485.0f,
    1686.0f,1815.0f,2015.0f,2393.0f,2947.0f,3525.0f,3927.0f,4015.0f,
    3790.0f,3389.0f,3003.0f,2786.0f,2786.0f,2939.0f,3116.0f,3228.0f,
    3212.0f,3108.0f,2947.0f,2810.0f,2730.0f,2714.0f,2746.0f,2770.0f,
    2714.0f,2521.0f,2184.0f,1758.0f,1349.0f,1076.0f,1036.0f,1188.0f,
    1413.0f,1550.0f,1477.0f,1188.0f,795.0f,441.0f,208.0f,88.0f,
    -1.0f,-177.0f,-482.0f,-884.0f,-1318.0f,-1743.0f,-2105.0f,-2410.0f,
    -2627.0f,-2739.0f,-2779.0f,-2811.0f,-2924.0f,-3173.0f,-3534.0f,-3920.0f,
    -4193.0f,-4321.0f,-4321.0f,-4257.0f,-4233.0f,-4265.0f,-4297.0f,-4257.0f,
    -4080.0f,-3751.0f,-3317.0f,-2836.0f,-2370.0f,-1944.0f,-1559.0f,-1221.0f,
    -908.0f,-619.0f,-346.0f,-97.0f,128.0f,345.0f,570.0f,819.0f,
    1116.0f,1445.0f,1758.0f,2039.0f,2256.0f,2417.0f,2521.0f,2562.0f,
    2505.0f,2345.0f,2104.0f,1823.0f,1566.0f,1389.0f,1309.0f,1301.0f,
    1349.0f,1437.0f,1542.0f,1670.0f,1799.0f,1935.0f,2048.0f,2152.0f,
    2240.0f,2272.0f,2216.0f,2039.0f,1718.0f,1325.0f,963.0f,722.0f,
    634.0f,690.0f,811.0f,931.0f,1011.0f,1060.0f,1100.0f,1124.0f,
    1156.0f,1172.0f,1164.0f,1092.0f,947.0f,706.0f,369.0f,-25.0f,
    -442.0f,-788.0f,-996.0f,-1053.0f,-980.0f,-868.0f,-788.0f,-804.0f,
    -908.0f,-1045.0f,-1149.0f,-1173.0f,-1165.0f,-1189.0f,-1342.0f,-1631.0f,
    -1992.0f,-2314.0f,-2482.0f,-2466.0f,-2306.0f,-2097.0f,-1936.0f,-1840.0f,
    -1808.0f,-1791.0f,-1791.0f,-1808.0f,-1864.0f,-1960.0f,-2057.0f,-2145.0f,
    -2217.0f,-2289.0f,-2378.0f,-2474.0f,-2514.0f,-2434.0f,-2185.0f,-1791.0f,
    -1342.0f,-964.0f,-723.0f,-643.0f,-627.0f,-571.0f,-386.0f,-65.0f,
    321.0f,698.0f,1011.0f,1252.0f,1469.0f,1726.0f,2039.0f,2393.0f,
    2746.0f,3059.0f,3324.0f,3541.0f,3710.0f,3798.0f,3790.0f,3662.0f,
    3453.0f,3212.0f,3027.0f,2907.0f,2835.0f,2770.0f,2642.0f,2465.0f,
    2256.0f,2056.0f,1903.0f,1774.0f,1654.0f,1493.0f,1301.0f,1044.0f,
    746.0f,401.0f,24.0f,-346.0f,-675.0f,-924.0f,-1085.0f,-1173.0f,
    -1237.0f,-1326.0f,-1454.0f,-1591.0f,-1687.0f,-1727.0f,-1711.0f,-1679.0f,
    -1687.0f,-1767.0f,-1928.0f,-2137.0f,-2362.0f,-2546.0f,-2659.0f,-2683.0f,
    -2635.0f,-2554.0f,-2482.0f,-2474.0f,-2571.0f,-2747.0f,-2932.0f,-3028.0f,
    -2980.0f,-2787.0f,-2538.0f,-2330.0f,-2209.0f,-2145.0f,-2032.0f,-1751.0f,
    -1310.0f,-812.0f,-386.0f,-137.0f,-49.0f,-41.0f,0.0f,136.0f,
    353.0f,570.0f,746.0f,875.0f,987.0f,1132.0f,1301.0f,1493.0f,
    1670.0f,1831.0f,2015.0f,2232.0f,2481.0f,2706.0f,2819.0f,2786.0f,
    2602.0f,2361.0f,2120.0f,1951.0f,1847.0f,1790.0f,1758.0f,1734.0f,
    1702.0f,1662.0f,1614.0f,1582.0f,1582.0f,1614.0f,1670.0f,1694.0f,
    1662.0f,1542.0f,1357.0f,1156.0f,987.0f,875.0f,819.0f,779.0f,
    722.0f,658.0f,570.0f,473.0f,345.0f,200.0f,24.0f,-161.0f,
    -378.0f,-611.0f,-892.0f,-1221.0f,-1583.0f,-1952.0f,-2257.0f,-2482.0f,
    -2627.0f,-2691.0f,-2707.0f,-2715.0f,-2731.0f,-2755.0f,-2771.0f,-2763.0f,
    -2723.0f,-2651.0f,-2579.0f,-2538.0f,-2546.0f,-2579.0f,-2579.0f,-2498.0f,
    -2306.0f,-2040.0f,-1743.0f,-1470.0f,-1221.0f,-980.0f,-715.0f,-434.0f,
    -169.0f,32.0f,152.0f,224.0f,273.0f,305.0f,329.0f,345.0f,
    369.0f,449.0f,618.0f,891.0f,1220.0f,1533.0f,1766.0f,1911.0f,
    1983.0f,2023.0f,2064.0f,2088.0f,2080.0f,2023.0f,1927.0f,1839.0f,
    1782.0f,1766.0f,1774.0f,1782.0f,1790.0f,1790.0f,1823.0f,1903.0f,
    1991.0f,2056.0f,2064.0f,2015.0f,1895.0f,1758.0f,1614.0f,1461.0f,
    1276.0f,1068.0f,835.0f,602.0f,393.0f,184.0f,-33.0f,-282.0f,
    -547.0f,-796.0f,-1012.0f,-1173.0f,-1302.0f,-1430.0f,-1567.0f,-1719.0f,
    -1864.0f,-1976.0f,-2016.0f,-2008.0f,-1968.0f,-1920.0f,-1880.0f,-1840.0f,
    -1791.0f,-1743.0f,-1679.0f,-1623.0f,-1583.0f,-1551.0f,-1543.0f,-1534.0f,
    -1510.0f,-1478.0f,-1438.0f,-1374.0f,-1318.0f,-1277.0f,-1253.0f,-1269.0f,
    -1286.0f,-1302.0f,-1277.0f,-1197.0f,-1069.0f,-908.0f,-755.0f,-643.0f,
    -603.0f,-611.0f,-627.0f,-571.0f,-402.0f,-137.0f,168.0f,457.0f,
    682.0f,835.0f,979.0f,1140.0f,1349.0f,1566.0f,1758.0f,1895.0f,
    1975.0f,2015.0f,2047.0f,2088.0f,2176.0f,2305.0f,2473.0f,2658.0f,
    2794.0f,2843.0f,2770.0f,2578.0f,2321.0f,2072.0f,1863.0f,1686.0f,
    1509.0f,1293.0f,1028.0f,730.0f,457.0f,232.0f,64.0f,-41.0f,
    -137.0f,-217.0f,-314.0f,-410.0f,-506.0f,-587.0f,-659.0f,-723.0f,
    -788.0f,-844.0f,-908.0f,-972.0f,-1020.0f,-1061.0f,-1069.0f,-1061.0f,
    -1045.0f,-1061.0f,-1117.0f,-1237.0f,-1390.0f,-1559.0f,-1695.0f,-1800.0f,
    -1888.0f,-1968.0f,-2048.0f,-2113.0f,-2145.0f,-2097.0f,-1976.0f,-1767.0f,
    -1526.0f,-1286.0f,-1077.0f,-916.0f,-796.0f,-699.0f,-603.0f,-506.0f,
    -410.0f,-338.0f,-298.0f,-290.0f,-314.0f,-314.0f,-274.0f,-145.0f,
    72.0f,353.0f,650.0f,915.0f,1116.0f,1260.0f,1389.0f,1525.0f,
    1654.0f,1750.0f,1758.0f,1654.0f,1461.0f,1228.0f,1011.0f,867.0f,
    811.0f,811.0f,835.0f,843.0f,811.0f,746.0f,682.0f,642.0f,
    634.0f,650.0f,658.0f,634.0f,586.0f,514.0f,449.0f,417.0f,
    441.0f,530.0f,674.0f,835.0f,979.0f,1060.0f,1052.0f,963.0f,
    811.0f,650.0f,505.0f,385.0f,265.0f,112.0f,-81.0f,-314.0f,
    -555.0f,-772.0f,-940.0f,-1053.0f,-1141.0f,-1213.0f,-1286.0f,-1350.0f,
    -1422.0f,-1478.0f,-1526.0f,-1559.0f,-1575.0f,-1567.0f,-1543.0f,-1494.0f,
    -1438.0f,-1382.0f,-1350.0f,-1334.0f,-1326.0f,-1286.0f,-1205.0f,-1069.0f,
    -908.0f,-739.0f,-619.0f,-539.0f,-498.0f,-466.0f,-418.0f,-346.0f,
    -241.0f,-129.0f,-9.0f,88.0f,176.0f,248.0f,313.0f,369.0f,
    417.0f,457.0f,473.0f,481.0f,465.0f,433.0f,401.0f,369.0f,
    345.0f,321.0f,321.0f,353.0f,409.0f,497.0f,594.0f,658.0f,
    698.0f,722.0f,762.0f,851.0f,1003.0f,1188.0f,1349.0f,1445.0f,
    1453.0f,1397.0f,1333.0f,1309.0f,1333.0f,1365.0f,1365.0f,1293.0f,
    1132.0f,907.0f,658.0f,425.0f,208.0f,0.0f,-209.0f,-434.0f,
    -659.0f,-844.0f,-956.0f,-996.0f,-972.0f,-916.0f,-868.0f,-844.0f,
    -852.0f,-892.0f,-940.0f,-988.0f,-996.0f,-972.0f,-924.0f,-876.0f,
    -860.0f,-876.0f,-916.0f,-940.0f,-924.0f,-860.0f,-763.0f,-667.0f,
    -587.0f,-523.0f,-474.0f,-434.0f,-418.0f,-418.0f,-418.0f,-426.0f,
    -434.0f,-442.0f,-466.0f,-498.0f,-523.0f,-506.0f,-434.0f,-298.0f,
    -145.0f,-17.0f,32.0f,16.0f,-41.0f,-97.0f,-129.0f,-121.0f,
    -89.0f,-49.0f,0.0f,72.0f,192.0f,361.0f,578.0f,819.0f,
    1036.0f,1228.0f,1373.0f,1477.0f,1550.0f,1582.0f,1582.0f,1533.0f,
    1437.0f,1317.0f,1164.0f,1011.0f,859.0f,706.0f,570.0f,449.0f,
    361.0f,281.0f,216.0f,136.0f,48.0f,-25.0f,-81.0f,-113.0f,
    -113.0f,-121.0f,-153.0f,-217.0f,-306.0f,-386.0f,-442.0f,-450.0f,
    -402.0f,-322.0f,-241.0f,-185.0f,-169.0f,-201.0f,-290.0f,-402.0f,
    -515.0f,-595.0f,-643.0f,-651.0f,-651.0f,-659.0f,-667.0f,-675.0f,
    -667.0f,-635.0f,-595.0f,-547.0f,-531.0f,-531.0f,-547.0f,-579.0f,
    -611.0f,-643.0f,-683.0f,-723.0f,-763.0f,-780.0f,-780.0f,-747.0f,
    -675.0f,-587.0f,-490.0f,-394.0f,-298.0f,-193.0f,-73.0f,40.0f,
    168.0f,281.0f,353.0f,385.0f,377.0f,353.0f,329.0f,305.0f,
    305.0f,305.0f,313.0f,313.0f,289.0f,248.0f,192.0f,136.0f,
    80.0f,40.0f,8.0f,-17.0f,-65.0f,-129.0f,-177.0f,-185.0f,
    -161.0f,-105.0f,-57.0f,-17.0f,8.0f,48.0f,104.0f,192.0f,
    297.0f,401.0f,497.0f,578.0f,650.0f,714.0f,779.0f,835.0f,
    899.0f,955.0f,1003.0f,1019.0f,979.0f,875.0f,714.0f,522.0f,
    337.0f,192.0f,88.0f,0.0f,-73.0f,-177.0f,-306.0f,-434.0f,
    -539.0f,-611.0f,-635.0f,-627.0f,-603.0f,-603.0f,-627.0f,-691.0f,
    -780.0f,-876.0f,-948.0f,-988.0f,-980.0f,-940.0f,-884.0f,-828.0f,
    -780.0f,-715.0f,-619.0f,-482.0f,-314.0f,-153.0f,-17.0f,64.0f,
    88.0f,88.0f,64.0f,40.0f,32.0f,24.0f,8.0f,-9.0f,
    -49.0f,-97.0f,-137.0f,-153.0f,-129.0f,-73.0f,8.0f,96.0f,
    160.0f,192.0f,184.0f,160.0f,152.0f,192.0f,273.0f,385.0f,
    514.0f,634.0f,730.0f,803.0f,867.0f,931.0f,987.0f,1044.0f,
    1068.0f,1060.0f,995.0f,891.0f,754.0f,586.0f,409.0f,232.0f,
    72.0f,-49.0f,-129.0f,-161.0f,-161.0f,-153.0f,-153.0f,-169.0f,
    -225.0f,-306.0f,-394.0f,-474.0f,-555.0f,-619.0f,-675.0f,-731.0f,
    -780.0f,-804.0f,-812.0f,-788.0f,-723.0f,-643.0f,-531.0f,-410.0f,
    -274.0f,-137.0f,-17.0f,72.0f,136.0f,168.0f,176.0f,176.0f,
    168.0f,160.0f,128.0f,80.0f,16.0f,-49.0f,-113.0f,-177.0f,
    -233.0f,-290.0f,-354.0f,-434.0f,-506.0f,-563.0f,-611.0f,-635.0f,
    -659.0f,-691.0f,-723.0f,-763.0f,-780.0f,-747.0f,-659.0f,-539.0f,
    -386.0f,-249.0f,-145.0f,-73.0f,-25.0f,16.0f,80.0f,160.0f,
    248.0f,329.0f,393.0f,441.0f,473.0f,497.0f,530.0f,546.0f,
    554.0f,546.0f,522.0f,489.0f,433.0f,361.0f,281.0f,208.0f,
    152.0f,120.0f,112.0f,128.0f,152.0f,168.0f,176.0f,184.0f,
    192.0f,216.0f,240.0f,248.0f,257.0f,248.0f,240.0f,240.0f,
    232.0f,208.0f,160.0f,104.0f,48.0f,24.0f,24.0f,48.0f,
    72.0f,80.0f,64.0f,32.0f,-9.0f,-57.0f,-121.0f,-185.0f,
    -274.0f,-354.0f,-426.0f,-490.0f,-555.0f,-619.0f,-691.0f,-747.0f,
    -796.0f,-812.0f,-812.0f,-812.0f,-804.0f,-796.0f,-772.0f,-723.0f,
    -643.0f,-563.0f,-482.0f,-410.0f,-322.0f,-209.0f,-65.0f,88.0f,
    232.0f,337.0f,393.0f,401.0f,385.0f,345.0f,313.0f,273.0f,
    224.0f,176.0f,120.0f,56.0f,-17.0f,-89.0f,-145.0f,-177.0f,
    -169.0f,-121.0f,-65.0f,0.0f,56.0f,104.0f,136.0f,144.0f,
    136.0f,112.0f,96.0f,104.0f,136.0f,184.0f,240.0f,297.0f,
    337.0f,377.0f,417.0f,465.0f,530.0f,586.0f,626.0f,650.0f,
    650.0f,634.0f,602.0f,562.0f,505.0f,433.0f,345.0f,265.0f,
    192.0f,152.0f,120.0f,96.0f,56.0f,-1.0f,-89.0f,-177.0f,
    -274.0f,-362.0f,-458.0f,-563.0f,-683.0f,-804.0f,-908.0f,-980.0f,
    -1012.0f,-996.0f,-924.0f,-804.0f,-635.0f,-450.0f,-266.0f,-105.0f,
    -1.0f,40.0f,48.0f,32.0f,16.0f,-1.0f,-17.0f,-49.0f,
    -73.0f,-113.0f,-145.0f,-177.0f,-193.0f,-209.0f,-201.0f,-185.0f,
    -145.0f,-97.0f,-49.0f,-17.0f,-17.0f,-25.0f,-49.0f,-49.0f,
    -41.0f,-1.0f,40.0f,96.0f,144.0f,184.0f,224.0f,281.0f,
    337.0f,393.0f,441.0f,465.0f,473.0f,465.0f,457.0f,433.0f,
    417.0f,393.0f,361.0f,337.0f,329.0f,337.0f,353.0f,361.0f,
    345.0f,313.0f,257.0f,184.0f,104.0f,8.0f,-81.0f,-185.0f,
    -282.0f,-362.0f,-418.0f,-466.0f,-515.0f,-563.0f,-595.0f,-611.0f,
    -595.0f,-563.0f,-523.0f,-482.0f,-450.0f,-402.0f,-330.0f,-233.0f,
    -145.0f,-73.0f,-25.0f,0.0f,32.0f,88.0f,168.0f,240.0f,
    305.0f,321.0f,297.0f,232.0f,144.0f,40.0f,-49.0f,-153.0f,
    -233.0f,-314.0f,-378.0f,-442.0f,-498.0f,-555.0f,-595.0f,-603.0f,
    -571.0f,-498.0f,-418.0f,-346.0f,-306.0f,-290.0f,-290.0f,-282.0f,
    -241.0f,-177.0f,-89.0f,0.0f,80.0f,144.0f,200.0f,248.0f,
    305.0f,337.0f,353.0f,345.0f,321.0f,289.0f,273.0f,265.0f,
    273.0f,281.0f,265.0f,224.0f,160.0f,88.0f,32.0f,24.0f,
    48.0f,104.0f,144.0f,152.0f,112.0f,32.0f,-41.0f,-97.0f,
    -121.0f,-105.0f,-89.0f,-89.0f,-105.0f,-129.0f,-153.0f,-153.0f,
    -129.0f,-65.0f,16.0f,104.0f,192.0f,257.0f,289.0f,289.0f,
    257.0f,208.0f,152.0f,104.0f,56.0f,0.0f,-73.0f,-161.0f,
    -249.0f,-330.0f,-378.0f,-394.0f,-402.0f,-426.0f,-474.0f,-547.0f,
    -611.0f,-643.0f,-635.0f,-587.0f,-506.0f,-434.0f,-370.0f,-322.0f,
    -266.0f,-193.0f,-97.0f,16.0f,152.0f,273.0f,361.0f,401.0f,
    393.0f,369.0f,329.0f,313.0f,313.0f,305.0f,281.0f,232.0f,
    152.0f,88.0f,40.0f,16.0f,16.0f,24.0f,24.0f,8.0f,
    -9.0f,-41.0f,-97.0f,-169.0f,-241.0f,-314.0f,-370.0f,-394.0f,
    -402.0f,-402.0f,-386.0f,-362.0f,-306.0f,-217.0f,-121.0f,-17.0f,
    56.0f,112.0f,160.0f,216.0f,289.0f,361.0f,417.0f,441.0f,
    425.0f,409.0f,401.0f,441.0f,497.0f,554.0f,570.0f,538.0f,
    465.0f,377.0f,297.0f,216.0f,144.0f,64.0f,-17.0f,-97.0f,
    -169.0f,-233.0f,-282.0f,-338.0f,-378.0f,-394.0f,-378.0f,-330.0f,
    -258.0f,-177.0f,-113.0f,-81.0f,-73.0f,-65.0f,-57.0f,-41.0f,
    -33.0f,-33.0f,-57.0f,-89.0f,-121.0f,-137.0f,-137.0f,-137.0f,
    -161.0f,-209.0f,-274.0f,-338.0f,-378.0f,-402.0f,-410.0f,-418.0f,
    -434.0f,-458.0f,-498.0f,-523.0f,-531.0f,-515.0f,-458.0f,-394.0f,
    -322.0f,-274.0f,-249.0f,-249.0f,-241.0f,-217.0f,-161.0f,-81.0f,
    0.0f,88.0f,160.0f,216.0f,257.0f,289.0f,313.0f,353.0f,
    401.0f,473.0f,546.0f,586.0f,586.0f,554.0f,489.0f,417.0f,
    353.0f,305.0f,257.0f,200.0f,136.0f,56.0f,-1.0f,-41.0f,
    -73.0f,-105.0f,-137.0f,-185.0f,-225.0f,-258.0f,-266.0f,-258.0f,
    -241.0f,-217.0f,-185.0f,-145.0f,-73.0f,8.0f,120.0f,224.0f,
    329.0f,425.0f,497.0f,554.0f,578.0f,562.0f,505.0f,425.0f,
    313.0f,208.0f,112.0f,16.0f,-81.0f,-185.0f,-282.0f,-370.0f,
    -434.0f,-474.0f,-506.0f,-531.0f,-555.0f,-571.0f,-579.0f,-555.0f,
    -531.0f,-506.0f,-498.0f,-515.0f,-539.0f,-555.0f,-539.0f,-490.0f,
    -410.0f,-322.0f,-241.0f,-185.0f,-153.0f,-145.0f,-145.0f,-129.0f,
    -89.0f,-41.0f,16.0f,72.0f,120.0f,152.0f,168.0f,176.0f,
    192.0f,216.0f,248.0f,273.0f,273.0f,240.0f,184.0f,104.0f,
    24.0f,-49.0f,-113.0f,-169.0f,-209.0f,-241.0f,-258.0f,-258.0f,
    -225.0f,-153.0f,-57.0f,48.0f,168.0f,281.0f,369.0f,441.0f,
    489.0f,522.0f,522.0f,505.0f,457.0f,385.0f,305.0f,216.0f,
    128.0f,56.0f,0.0f,-25.0f,-57.0f,-81.0f,-105.0f,-145.0f,
    -201.0f,-266.0f,-322.0f,-362.0f,-378.0f,-386.0f,-394.0f,-418.0f,
    -450.0f,-474.0f,-474.0f,-442.0f,-378.0f,-298.0f,-217.0f,-145.0f,
    -89.0f,-33.0f,0.0f,56.0f,96.0f,136.0f,160.0f,176.0f,
    192.0f,224.0f,257.0f,305.0f,345.0f,361.0f,345.0f,313.0f,
    257.0f,192.0f,128.0f,72.0f,16.0f,-25.0f,-81.0f,-153.0f,
    -233.0f,-306.0f,-362.0f,-386.0f,-378.0f,-346.0f,-314.0f,-298.0f,
    -290.0f,-298.0f,-298.0f,-290.0f,-258.0f,-201.0f,-129.0f,-49.0f,
    16.0f,88.0f,136.0f,176.0f,216.0f,257.0f,305.0f,353.0f,
    401.0f,441.0f,457.0f,441.0f,409.0f,361.0f,305.0f,240.0f,
    168.0f,88.0f,24.0f,-25.0f,-65.0f,-89.0f,-97.0f,-121.0f,
    -145.0f,-177.0f,-193.0f,-201.0f,-185.0f,-169.0f,-145.0f,-121.0f,
    -97.0f,-65.0f,-41.0f,-17.0f,-1.0f,-1.0f,8.0f,24.0f,
    48.0f,64.0f,64.0f,32.0f,-17.0f,-73.0f,-121.0f,-153.0f,
    -169.0f,-193.0f,-225.0f,-258.0f,-282.0f,-298.0f,-298.0f,-306.0f,
    -306.0f,-322.0f,-338.0f,-346.0f,-346.0f,-346.0f,-354.0f,-378.0f,
    -402.0f,-418.0f,-418.0f,-402.0f,-346.0f,-282.0f,-193.0f,-105.0f,
    -17.0f,64.0f,136.0f,192.0f,248.0f,305.0f,353.0f,401.0f,
    441.0f,449.0f,425.0f,369.0f,297.0f,224.0f,168.0f,120.0f,
    88.0f,56.0f,24.0f,-25.0f,-81.0f,-145.0f,-201.0f,-249.0f,
    -282.0f,-306.0f,-314.0f,-322.0f,-314.0f,-290.0f,-266.0f,-225.0f,
    -177.0f,-113.0f,-49.0f,16.0f,80.0f,136.0f,176.0f,208.0f,
    216.0f,208.0f,192.0f,176.0f,160.0f,144.0f,128.0f,128.0f,
    128.0f,144.0f,168.0f,184.0f,192.0f,176.0f,136.0f,80.0f,
    16.0f,-41.0f,-89.0f,-129.0f,-169.0f,-217.0f,-282.0f,-338.0f,
    -378.0f,-394.0f,-378.0f,-330.0f,-274.0f,-225.0f,-193.0f,-161.0f,
    -137.0f,-105.0f,-65.0f,-25.0f,16.0f,64.0f,96.0f,120.0f,
    128.0f,136.0f,144.0f,136.0f,120.0f,88.0f,56.0f,8.0f,
    -25.0f,-65.0f,-97.0f,-137.0f,-169.0f,-217.0f,-258.0f,-290.0f,
    -306.0f,-290.0f,-249.0f,-185.0f,-137.0f,-105.0f,-105.0f,-121.0f,
    -153.0f,-169.0f,-153.0f,-113.0f,-41.0f,32.0f,104.0f,152.0f,
    184.0f,208.0f,232.0f,257.0f,289.0f,313.0f,313.0f,289.0f,
    257.0f,216.0f,176.0f,144.0f,112.0f,80.0f,32.0f,-1.0f,
    -41.0f,-73.0f,-89.0f,-105.0f,-121.0f,-137.0f,-153.0f,-169.0f,
    -169.0f,-169.0f,-161.0f,-153.0f,-137.0f,-121.0f,-89.0f,-65.0f,
    -41.0f,-17.0f,8.0f,40.0f,80.0f,120.0f,144.0f,152.0f,
    144.0f,120.0f,88.0f,64.0f,56.0f,64.0f,72.0f,80.0f,
    56.0f,24.0f,-17.0f,-65.0f,-113.0f,-145.0f,-185.0f,-217.0f,
    -266.0f,-314.0f,-362.0f,-402.0f,-434.0f,-458.0f,-466.0f,-466.0f,
    -450.0f,-410.0f,-354.0f,-282.0f,-201.0f,-121.0f,-33.0f,32.0f,
    104.0f,168.0f,216.0f,265.0f,289.0f,305.0f,297.0f,289.0f,
    273.0f,240.0f,208.0f,176.0f,136.0f,112.0f,88.0f,72.0f,
    56.0f,32.0f,0.0f,-33.0f,-73.0f,-105.0f,-121.0f,-129.0f,
    -129.0f,-121.0f,-121.0f,-121.0f,-113.0f,-105.0f,-97.0f,-89.0f,
    -73.0f,-49.0f,-25.0f,-9.0f,8.0f,24.0f,48.0f,80.0f,
    104.0f,120.0f,128.0f,120.0f,120.0f,128.0f,144.0f,160.0f,
    176.0f,168.0f,136.0f,80.0f,8.0f,-65.0f,-145.0f,-225.0f,
    -298.0f,-346.0f,-386.0f,-402.0f,-410.0f,-418.0f,-410.0f,-402.0f,
    -370.0f,-314.0f,-241.0f,-169.0f,-105.0f,-57.0f,-25.0f,0.0f,
    16.0f,32.0f,40.0f,40.0f,32.0f,24.0f,16.0f,16.0f,
    32.0f,48.0f,48.0f,40.0f,16.0f,-17.0f,-57.0f,-89.0f,
    -121.0f,-137.0f,-161.0f,-169.0f,-177.0f,-177.0f,-177.0f,-177.0f,
    -177.0f,-193.0f,-209.0f,-225.0f,-233.0f,-225.0f,-217.0f,-193.0f,
    -161.0f,-121.0f,-65.0f,-1.0f,64.0f,128.0f,184.0f,216.0f,
    248.0f,281.0f,313.0f,345.0f,369.0f,369.0f,361.0f,329.0f,
    289.0f,257.0f,224.0f,192.0f,152.0f,104.0f,48.0f,-1.0f,
    -49.0f,-89.0f,-129.0f,-161.0f,-201.0f,-241.0f,-274.0f,-298.0f,
    -314.0f,-314.0f,-306.0f,-282.0f,-258.0f,-225.0f,-201.0f,-177.0f,
    -153.0f,-121.0f,-73.0f,-25.0f,16.0f,56.0f,80.0f,88.0f,
    72.0f,56.0f,40.0f,40.0f,48.0f,56.0f,48.0f,24.0f,
    -1.0f,-41.0f,-81.0f,-121.0f,-153.0f,-177.0f,-217.0f,-249.0f,
    -266.0f,-266.0f,-249.0f,-209.0f,-169.0f,-137.0f,-113.0f,-89.0f,
    -65.0f,-25.0f,8.0f,48.0f,80.0f,112.0f,136.0f,152.0f,
    168.0f,176.0f,176.0f,184.0f,192.0f,200.0f,216.0f,224.0f,
    216.0f,208.0f,184.0f,160.0f,144.0f,144.0f,136.0f,120.0f,
    80.0f,32.0f,-25.0f,-73.0f,-121.0f,-145.0f,-161.0f,-185.0f,
    -209.0f,-241.0f,-282.0f,-298.0f,-298.0f,-274.0f,-233.0f,-185.0f,
    -129.0f,-73.0f,-17.0f,24.0f,64.0f,96.0f,120.0f,144.0f,
    160.0f,176.0f,168.0f,152.0f,104.0f,56.0f,8.0f,-25.0f,
    -57.0f,-89.0f,-121.0f,-169.0f,-209.0f,-233.0f,-258.0f,-274.0f,
    -298.0f,-330.0f,-354.0f,-362.0f,-354.0f,-314.0f,-258.0f,-193.0f,
    -145.0f,-97.0f,-65.0f,-41.0f,-17.0f,-1.0f,16.0f,32.0f,
    40.0f,48.0f,64.0f,80.0f,104.0f,136.0f,160.0f,184.0f,
    208.0f,224.0f,232.0f,232.0f,232.0f,224.0f,208.0f,184.0f,
    144.0f,88.0f,24.0f,-49.0f,-121.0f,-193.0f,-249.0f,-290.0f,
    -322.0f,-330.0f,-338.0f,-322.0f,-298.0f,-249.0f,-201.0f,-145.0f,
    -89.0f,-41.0f,0.0f,48.0f,88.0f,128.0f,160.0f,176.0f,
    184.0f,184.0f,176.0f,152.0f,120.0f,96.0f,72.0f,64.0f,
    64.0f,72.0f,72.0f,56.0f,24.0f,-1.0f,-49.0f,-89.0f,
    -121.0f,-145.0f,-169.0f,-185.0f,-201.0f,-209.0f,-201.0f,-185.0f,
    -169.0f,-161.0f,-153.0f,-145.0f,-137.0f,-121.0f,-97.0f,-65.0f,
    -25.0f,0.0f,24.0f,40.0f,48.0f,48.0f,48.0f,48.0f,
    48.0f,48.0f,40.0f,24.0f,8.0f,-17.0f,-41.0f,-73.0f,
    -105.0f,-129.0f,-153.0f,-177.0f,-193.0f,-209.0f,-209.0f,-209.0f,
    -209.0f,-201.0f,-193.0f,-185.0f,-169.0f,-145.0f,-113.0f,-81.0f,
    -49.0f,-25.0f,-1.0f,16.0f,48.0f,88.0f,112.0f,136.0f,
    152.0f,168.0f,184.0f,208.0f,224.0f,240.0f,232.0f,208.0f,
    168.0f,120.0f,80.0f,32.0f,-1.0f,-49.0f,-97.0f,-153.0f,
    -225.0f,-314.0f,-394.0f,-474.0f,-539.0f,-579.0f,-595.0f,-571.0f,
    -531.0f,-482.0f,-418.0f,-354.0f,-290.0f,-225.0f,-169.0f,-113.0f,
    -57.0f,-9.0f,32.0f,72.0f,104.0f,120.0f,136.0f,128.0f,
    120.0f,112.0f,96.0f,88.0f,80.0f,80.0f,88.0f,96.0f,
    96.0f,104.0f,104.0f,104.0f,96.0f,88.0f,80.0f,64.0f,
    48.0f,24.0f,0.0f,-9.0f,-9.0f,-9.0f,-1.0f,0.0f,
    8.0f,16.0f,32.0f,56.0f,88.0f,112.0f,136.0f,160.0f,
    176.0f,192.0f,208.0f,232.0f,257.0f,273.0f,281.0f,273.0f,
    248.0f,216.0f,168.0f,112.0f,56.0f,0.0f,-49.0f,-97.0f,
    -153.0f,-201.0f,-249.0f,-290.0f,-314.0f,-330.0f,-330.0f,-314.0f,
    -282.0f,-249.0f,-217.0f,-193.0f,-161.0f,-121.0f,-65.0f,-9.0f,
    40.0f,80.0f,104.0f,96.0f,88.0f,80.0f,72.0f,72.0f,
    80.0f,80.0f,80.0f,72.0f,72.0f,64.0f,48.0f,24.0f,
    0.0f,-25.0f,-49.0f,-81.0f,-121.0f,-169.0f,-225.0f,-274.0f,
    -306.0f,-322.0f,-322.0f,-314.0f,-314.0f,-314.0f,-314.0f,-298.0f,
    -258.0f,-209.0f,-145.0f,-97.0f,-49.0f,-9.0f,24.0f,64.0f,
    120.0f,160.0f,192.0f,208.0f,208.0f,208.0f,200.0f,192.0f,
    184.0f,168.0f,136.0f,112.0f,80.0f,56.0f,32.0f,0.0f,
    -25.0f,-65.0f,-105.0f,-145.0f,-177.0f,-201.0f,-217.0f,-225.0f,
    -225.0f,-217.0f,-209.0f,-193.0f,-177.0f,-161.0f,-145.0f,-121.0f,
    -89.0f,-41.0f,8.0f,48.0f,80.0f,88.0f,80.0f,80.0f,
    80.0f,104.0f,128.0f,144.0f,144.0f,120.0f,88.0f,56.0f,
    32.0f,16.0f,-1.0f,-25.0f,-57.0f,-97.0f,-137.0f,-185.0f,
    -225.0f,-258.0f,-282.0f,-290.0f,-274.0f,-249.0f,-209.0f,-169.0f,
    -129.0f,-97.0f,-57.0f,-17.0f,24.0f,72.0f,104.0f,120.0f,
    120.0f,120.0f,120.0f,120.0f,112.0f,104.0f,80.0f,56.0f,
    48.0f,40.0f,56.0f,72.0f,80.0f,80.0f,64.0f,32.0f,
    -1.0f,-41.0f,-73.0f,-113.0f,-145.0f,-185.0f,-217.0f,-249.0f,
    -274.0f,-282.0f,-274.0f,-258.0f,-233.0f,-201.0f,-177.0f,-145.0f,
    -105.0f,-57.0f,-9.0f,32.0f,72.0f,112.0f,136.0f,152.0f,
    168.0f,176.0f,184.0f,184.0f,184.0f,176.0f,144.0f,104.0f,
    56.0f,8.0f,-33.0f,-65.0f,-97.0f,-121.0f,-153.0f,-185.0f,
    -217.0f,-249.0f,-266.0f,-258.0f,-241.0f,-201.0f,-169.0f,-145.0f,
    -137.0f,-137.0f,-145.0f,-153.0f,-153.0f,-153.0f,-145.0f,-121.0f,
    -89.0f,-57.0f,-33.0f,-9.0f,8.0f,24.0f,48.0f,72.0f,
    96.0f,112.0f,120.0f,112.0f,104.0f,104.0f,96.0f,96.0f,
    72.0f,40.0f,-1.0f,-57.0f,-105.0f,-137.0f,-153.0f,-161.0f,
    -177.0f,-185.0f,-201.0f,-193.0f,-169.0f,-129.0f,-81.0f,-41.0f,
    -17.0f,0.0f,32.0f,64.0f,104.0f,136.0f,168.0f,184.0f,
    184.0f,184.0f,168.0f,152.0f,120.0f,88.0f,64.0f,32.0f,
    16.0f,8.0f,0.0f,0.0f,-1.0f,-9.0f,-25.0f,-49.0f,
    -81.0f,-121.0f,-169.0f,-217.0f,-258.0f,-282.0f,-290.0f,-282.0f,
    -266.0f,-258.0f,-241.0f,-233.0f,-209.0f,-169.0f,-121.0f,-65.0f,
    -17.0f,16.0f,40.0f,64.0f,88.0f,112.0f,136.0f,152.0f,
    160.0f,160.0f,144.0f,128.0f,104.0f,72.0f,32.0f,-1.0f,
    -33.0f,-49.0f,-57.0f,-57.0f,-73.0f,-97.0f,-121.0f,-145.0f,
    -161.0f,-153.0f,-145.0f,-121.0f,-97.0f,-81.0f,-73.0f,-65.0f,
    -57.0f,-49.0f,-33.0f,-17.0f,-9.0f,-1.0f,0.0f,8.0f,
    24.0f,48.0f,72.0f,96.0f,120.0f,128.0f,136.0f,136.0f,
    128.0f,120.0f,104.0f,80.0f,40.0f,8.0f,-33.0f,-81.0f,
    -129.0f,-177.0f,-217.0f,-249.0f,-266.0f,-282.0f,-274.0f,-274.0f,
    -258.0f,-241.0f,-217.0f,-185.0f,-145.0f,-97.0f,-49.0f,-9.0f,
    16.0f,32.0f,48.0f,56.0f,56.0f,64.0f,72.0f,80.0f,
    88.0f,96.0f,112.0f,120.0f,112.0f,104.0f,72.0f,48.0f,
    16.0f,-1.0f,-17.0f,-33.0f,-41.0f,-65.0f,-89.0f,-121.0f,
    -145.0f,-169.0f,-177.0f,-177.0f,-169.0f,-169.0f,-169.0f,-169.0f,
    -161.0f,-153.0f,-129.0f,-113.0f,-81.0f,-49.0f,-17.0f,24.0f,
    64.0f,104.0f,128.0f,144.0f,144.0f,144.0f,136.0f,128.0f,
    120.0f,96.0f,64.0f,24.0f,-1.0f,-41.0f,-81.0f,-121.0f,
    -169.0f,-201.0f,-225.0f,-241.0f,-233.0f,-225.0f,-217.0f,-217.0f,
    -217.0f,-225.0f,-225.0f,-217.0f,-193.0f,-161.0f,-129.0f,-97.0f,
    -73.0f,-49.0f,-25.0f,-1.0f,24.0f,56.0f,88.0f,112.0f,
    128.0f,136.0f,144.0f,152.0f,152.0f,152.0f,152.0f,152.0f,
    152.0f,152.0f,144.0f,112.0f,64.0f,8.0f,-33.0f,-73.0f,
    -97.0f,-121.0f,-145.0f,-169.0f,-193.0f,-217.0f,-225.0f,-209.0f,
    -185.0f,-153.0f,-113.0f,-65.0f,-25.0f,8.0f,40.0f,56.0f,
    64.0f,56.0f,48.0f,40.0f,40.0f,40.0f,48.0f,56.0f,
    56.0f,48.0f,32.0f,16.0f,0.0f,-25.0f,-41.0f,-57.0f,
    -73.0f,-81.0f,-97.0f,-121.0f,-161.0f,-185.0f,-193.0f,-161.0f,
    -113.0f,-49.0f,
    0
}; t_CKUINT mandpluk_size = 4450;

// data for marmstk1.raw...
SAMPLE marmstk1_data[] = {
    16.0f,-113.0f,522.0f,-1237.0f,2056.0f,5525.0f,-7413.0f,-659.0f,
    562.0f,1076.0f,923.0f,-2153.0f,3357.0f,-4434.0f,-2900.0f,4433.0f,
    1212.0f,987.0f,-772.0f,-1671.0f,3951.0f,-7325.0f,7710.0f,-9702.0f,
    12601.0f,-11919.0f,6754.0f,2521.0f,-8594.0f,10047.0f,-11437.0f,11773.0f,
    -9992.0f,5140.0f,738.0f,-2081.0f,570.0f,803.0f,-531.0f,-1848.0f,
    3067.0f,-3566.0f,7059.0f,-11630.0f,10384.0f,-5398.0f,939.0f,3116.0f,
    -5430.0f,7172.0f,-7839.0f,5999.0f,-860.0f,-539.0f,-1382.0f,2634.0f,
    -4048.0f,2345.0f,-699.0f,-17.0f,2626.0f,-6169.0f,7565.0f,-5647.0f,
    1092.0f,3646.0f,-4177.0f,3887.0f,-4466.0f,2256.0f,1373.0f,-4129.0f,
    4393.0f,-812.0f,-3101.0f,4481.0f,-4611.0f,4063.0f,-2635.0f,-1101.0f,
    5493.0f,-6385.0f,4963.0f,-1390.0f,-940.0f,1011.0f,-2603.0f,2329.0f,
    883.0f,-2474.0f,3614.0f,-2506.0f,-1422.0f,2064.0f,-3261.0f,4513.0f,
    -2828.0f,1550.0f,738.0f,-3044.0f,2313.0f,-1197.0f,-161.0f,1678.0f,
    -1398.0f,1381.0f,-796.0f,-1310.0f,2706.0f,-3093.0f,1293.0f,1212.0f,
    -2008.0f,2650.0f,-2297.0f,1220.0f,289.0f,-2554.0f,3084.0f,-1591.0f,
    313.0f,666.0f,-1061.0f,714.0f,-699.0f,-1085.0f,3349.0f,-2940.0f,
    1734.0f,-49.0f,-2306.0f,3590.0f,-3414.0f,3814.0f,-2434.0f,-145.0f,
    2015.0f,-2972.0f,1863.0f,-498.0f,-338.0f,642.0f,8.0f,-563.0f,
    2144.0f,-3928.0f,3461.0f,-1687.0f,-796.0f,2819.0f,-3269.0f,3999.0f,
    -3237.0f,1252.0f,1124.0f,-2338.0f,1293.0f,-563.0f,-49.0f,1028.0f,
    -908.0f,433.0f,441.0f,-2747.0f,3397.0f,-2024.0f,883.0f,1196.0f,
    -2579.0f,2923.0f,-2964.0f,1140.0f,634.0f,-2297.0f,3365.0f,-2322.0f,
    1301.0f,666.0f,-2579.0f,2128.0f,-1502.0f,907.0f,393.0f,-611.0f,
    514.0f,-354.0f,-1406.0f,2039.0f,-1077.0f,152.0f,923.0f,-2217.0f,
    2553.0f,-2065.0f,1285.0f,401.0f,-1719.0f,2433.0f,-2081.0f,1124.0f,
    449.0f,-1454.0f,1389.0f,-1551.0f,650.0f,674.0f,-1310.0f,1598.0f,
    -844.0f,-555.0f,1260.0f,-1840.0f,2023.0f,-466.0f,-755.0f,1702.0f,
    -2289.0f,1437.0f,-547.0f,72.0f,1108.0f,-1302.0f,690.0f,-338.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT marmstk1_size = 256;

// data for ooo.raw...
SAMPLE ooo_data[] = {
    -153.0f,473.0f,-209.0f,-924.0f,-739.0f,-587.0f,-868.0f,-1077.0f,
    -1221.0f,-1358.0f,-1077.0f,-707.0f,-932.0f,-1526.0f,-1751.0f,-1286.0f,
    -932.0f,-1551.0f,-2346.0f,-2217.0f,-2346.0f,-4627.0f,-7863.0f,-8883.0f,
    -7004.0f,-5566.0f,-6851.0f,-6843.0f,-1366.0f,4674.0f,4618.0f,2931.0f,
    6617.0f,11316.0f,10063.0f,6376.0f,5951.0f,7669.0f,8449.0f,6360.0f,
    3067.0f,3276.0f,6007.0f,4577.0f,-884.0f,-3309.0f,-2410.0f,-4482.0f,
    -9309.0f,-11823.0f,-11927.0f,-11405.0f,-10843.0f,-10875.0f,-10200.0f,-7486.0f,
    -4795.0f,-4072.0f,-3711.0f,-2450.0f,-1318.0f,-547.0f,273.0f,754.0f,
    979.0f,2072.0f,3606.0f,3646.0f,2730.0f,3067.0f,4095.0f,3670.0f,
    1871.0f,795.0f,1325.0f,1566.0f,-121.0f,-1936.0f,-1567.0f,-635.0f,
    -1775.0f,-3615.0f,-3526.0f,-2426.0f,-2538.0f,-3358.0f,-3109.0f,-1599.0f,
    -466.0f,-611.0f,-707.0f,144.0f,
    0
}; t_CKUINT ooo_size = 92;

// data for peksblnk.raw...
SAMPLE peksblnk_data[] = {
    0.0f,32.0f,152.0f,353.0f,626.0f,979.0f,1413.0f,1919.0f,
    2489.0f,3148.0f,3871.0f,4658.0f,5525.0f,6449.0f,7437.0f,8489.0f,
    9597.0f,10762.0f,11982.0f,13243.0f,14560.0f,15926.0f,17323.0f,18753.0f,
    20231.0f,21732.0f,23250.0f,24800.0f,26375.0f,27957.0f,29555.0f,31153.0f,
    32767.0f,31153.0f,29555.0f,27957.0f,26375.0f,24800.0f,23250.0f,21732.0f,
    20231.0f,18753.0f,17323.0f,15926.0f,14560.0f,13243.0f,11982.0f,10762.0f,
    9597.0f,8489.0f,7437.0f,6449.0f,5525.0f,4658.0f,3871.0f,3148.0f,
    2489.0f,1919.0f,1413.0f,979.0f,626.0f,353.0f,152.0f,32.0f,
    0.0f,-33.0f,-153.0f,-354.0f,-627.0f,-980.0f,-1414.0f,-1920.0f,
    -2490.0f,-3149.0f,-3872.0f,-4659.0f,-5526.0f,-6442.0f,-7438.0f,-8482.0f,
    -9598.0f,-10763.0f,-11983.0f,-13244.0f,-14561.0f,-15927.0f,-17316.0f,-18754.0f,
    -20232.0f,-21725.0f,-23251.0f,-24801.0f,-26376.0f,-27958.0f,-29556.0f,-31154.0f,
    -32768.0f,-31154.0f,-29556.0f,-27958.0f,-26376.0f,-24801.0f,-23251.0f,-21725.0f,
    -20232.0f,-18754.0f,-17316.0f,-15927.0f,-14561.0f,-13244.0f,-11983.0f,-10763.0f,
    -9598.0f,-8482.0f,-7438.0f,-6442.0f,-5526.0f,-4659.0f,-3872.0f,-3149.0f,
    -2490.0f,-1920.0f,-1414.0f,-980.0f,-627.0f,-354.0f,-153.0f,-33.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT peksblnk_size = 256;

// data for ppksblnk.raw...
SAMPLE ppksblnk_data[] = {
    0.0f,32.0f,152.0f,353.0f,626.0f,979.0f,1413.0f,1919.0f,
    2489.0f,3148.0f,3871.0f,4658.0f,5525.0f,6449.0f,7437.0f,8489.0f,
    9597.0f,10762.0f,11982.0f,13243.0f,14560.0f,15926.0f,17323.0f,18753.0f,
    20231.0f,21732.0f,23250.0f,24800.0f,26375.0f,27957.0f,29555.0f,31153.0f,
    32767.0f,31153.0f,29555.0f,27957.0f,26375.0f,24800.0f,23250.0f,21732.0f,
    20231.0f,18753.0f,17323.0f,15926.0f,14560.0f,13243.0f,11982.0f,10762.0f,
    9597.0f,8489.0f,7437.0f,6449.0f,5525.0f,4658.0f,3871.0f,3148.0f,
    2489.0f,1919.0f,1413.0f,979.0f,626.0f,353.0f,152.0f,32.0f,
    0.0f,32.0f,152.0f,353.0f,626.0f,979.0f,1413.0f,1919.0f,
    2489.0f,3148.0f,3871.0f,4658.0f,5525.0f,6449.0f,7437.0f,8489.0f,
    9597.0f,10762.0f,11982.0f,13243.0f,14560.0f,15926.0f,17323.0f,18753.0f,
    20231.0f,21732.0f,23250.0f,24800.0f,26375.0f,27957.0f,29555.0f,31153.0f,
    32767.0f,31153.0f,29555.0f,27957.0f,26375.0f,24800.0f,23250.0f,21732.0f,
    20231.0f,18753.0f,17323.0f,15926.0f,14560.0f,13243.0f,11982.0f,10762.0f,
    9597.0f,8489.0f,7437.0f,6449.0f,5525.0f,4658.0f,3871.0f,3148.0f,
    2489.0f,1919.0f,1413.0f,979.0f,626.0f,353.0f,152.0f,32.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT ppksblnk_size = 256;

// data for silence.raw...
SAMPLE silence_data[] = {
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT silence_size = 224;

// data for sineblnk.raw...
SAMPLE sineblnk_data[] = {
    0.0f,1606.0f,3212.0f,4802.0f,6392.0f,7967.0f,9509.0f,11035.0f,
    12536.0f,14014.0f,15444.0f,16841.0f,18207.0f,19516.0f,20785.0f,22005.0f,
    23170.0f,24278.0f,25330.0f,26318.0f,27242.0f,28109.0f,28896.0f,29619.0f,
    30278.0f,30848.0f,31354.0f,31788.0f,32141.0f,32414.0f,32615.0f,32727.0f,
    32767.0f,32727.0f,32615.0f,32414.0f,32141.0f,31788.0f,31354.0f,30848.0f,
    30278.0f,29619.0f,28896.0f,28109.0f,27242.0f,26318.0f,25330.0f,24278.0f,
    23170.0f,22005.0f,20785.0f,19516.0f,18207.0f,16841.0f,15444.0f,14014.0f,
    12536.0f,11035.0f,9509.0f,7967.0f,6392.0f,4802.0f,3212.0f,1606.0f,
    0.0f,-1607.0f,-3213.0f,-4803.0f,-6385.0f,-7968.0f,-9510.0f,-11036.0f,
    -12537.0f,-14015.0f,-15445.0f,-16842.0f,-18208.0f,-19517.0f,-20786.0f,-22006.0f,
    -23171.0f,-24279.0f,-25331.0f,-26319.0f,-27243.0f,-28110.0f,-28897.0f,-29620.0f,
    -30271.0f,-30849.0f,-31355.0f,-31789.0f,-32142.0f,-32415.0f,-32616.0f,-32728.0f,
    -32768.0f,-32728.0f,-32616.0f,-32415.0f,-32142.0f,-31789.0f,-31355.0f,-30849.0f,
    -30271.0f,-29620.0f,-28897.0f,-28110.0f,-27243.0f,-26319.0f,-25331.0f,-24279.0f,
    -23171.0f,-22006.0f,-20786.0f,-19517.0f,-18208.0f,-16842.0f,-15445.0f,-14015.0f,
    -12537.0f,-11036.0f,-9510.0f,-7968.0f,-6385.0f,-4803.0f,-3213.0f,-1607.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT sineblnk_size = 256;

// data for sinewave.raw...
SAMPLE sinewave_data[] = {
    0.0f,803.0f,1606.0f,2409.0f,3212.0f,4015.0f,4802.0f,5605.0f,
    6392.0f,7180.0f,7967.0f,8738.0f,9509.0f,10272.0f,11035.0f,11798.0f,
    12536.0f,13275.0f,14014.0f,14729.0f,15444.0f,16151.0f,16841.0f,17532.0f,
    18207.0f,18865.0f,19516.0f,20158.0f,20785.0f,21403.0f,22005.0f,22592.0f,
    23170.0f,23732.0f,24278.0f,24808.0f,25330.0f,25828.0f,26318.0f,26784.0f,
    27242.0f,27684.0f,28109.0f,28511.0f,28896.0f,29266.0f,29619.0f,29957.0f,
    30278.0f,30575.0f,30848.0f,31113.0f,31354.0f,31579.0f,31788.0f,31972.0f,
    32141.0f,32286.0f,32414.0f,32527.0f,32615.0f,32679.0f,32727.0f,32759.0f,
    32767.0f,32759.0f,32727.0f,32679.0f,32615.0f,32527.0f,32414.0f,32286.0f,
    32141.0f,31972.0f,31788.0f,31579.0f,31354.0f,31113.0f,30848.0f,30575.0f,
    30278.0f,29957.0f,29619.0f,29266.0f,28896.0f,28511.0f,28109.0f,27684.0f,
    27242.0f,26784.0f,26318.0f,25828.0f,25330.0f,24808.0f,24278.0f,23732.0f,
    23170.0f,22592.0f,22005.0f,21403.0f,20785.0f,20158.0f,19516.0f,18865.0f,
    18207.0f,17532.0f,16841.0f,16151.0f,15444.0f,14729.0f,14014.0f,13275.0f,
    12536.0f,11798.0f,11035.0f,10272.0f,9509.0f,8738.0f,7967.0f,7180.0f,
    6392.0f,5605.0f,4802.0f,4015.0f,3212.0f,2409.0f,1606.0f,803.0f,
    0.0f,-804.0f,-1607.0f,-2410.0f,-3213.0f,-4016.0f,-4803.0f,-5606.0f,
    -6385.0f,-7181.0f,-7968.0f,-8739.0f,-9510.0f,-10273.0f,-11036.0f,-11791.0f,
    -12537.0f,-13276.0f,-14015.0f,-14730.0f,-15445.0f,-16152.0f,-16842.0f,-17533.0f,
    -18208.0f,-18866.0f,-19517.0f,-20159.0f,-20786.0f,-21404.0f,-22006.0f,-22593.0f,
    -23171.0f,-23733.0f,-24279.0f,-24809.0f,-25331.0f,-25829.0f,-26319.0f,-26785.0f,
    -27243.0f,-27685.0f,-28110.0f,-28512.0f,-28897.0f,-29267.0f,-29620.0f,-29958.0f,
    -30271.0f,-30576.0f,-30849.0f,-31114.0f,-31355.0f,-31580.0f,-31789.0f,-31973.0f,
    -32142.0f,-32287.0f,-32415.0f,-32520.0f,-32616.0f,-32680.0f,-32728.0f,-32760.0f,
    -32768.0f,-32760.0f,-32728.0f,-32680.0f,-32616.0f,-32520.0f,-32415.0f,-32287.0f,
    -32142.0f,-31973.0f,-31789.0f,-31580.0f,-31355.0f,-31114.0f,-30849.0f,-30576.0f,
    -30271.0f,-29958.0f,-29620.0f,-29267.0f,-28897.0f,-28512.0f,-28110.0f,-27685.0f,
    -27243.0f,-26785.0f,-26319.0f,-25829.0f,-25331.0f,-24809.0f,-24279.0f,-23733.0f,
    -23171.0f,-22593.0f,-22006.0f,-21404.0f,-20786.0f,-20159.0f,-19517.0f,-18866.0f,
    -18208.0f,-17533.0f,-16842.0f,-16152.0f,-15445.0f,-14730.0f,-14015.0f,-13276.0f,
    -12537.0f,-11791.0f,-11036.0f,-10273.0f,-9510.0f,-8739.0f,-7968.0f,-7181.0f,
    -6385.0f,-5606.0f,-4803.0f,-4016.0f,-3213.0f,-2410.0f,-1607.0f,-804.0f,
    0
}; t_CKUINT sinewave_size = 256;

// data for snglpeak.raw...
SAMPLE snglpeak_data[] = {
    0.0f,8.0f,32.0f,88.0f,152.0f,240.0f,353.0f,481.0f,
    626.0f,795.0f,979.0f,1188.0f,1413.0f,1654.0f,1919.0f,2192.0f,
    2489.0f,2810.0f,3148.0f,3501.0f,3871.0f,4256.0f,4658.0f,5083.0f,
    5525.0f,5983.0f,6449.0f,6931.0f,7437.0f,7959.0f,8489.0f,9035.0f,
    9597.0f,10175.0f,10762.0f,11364.0f,11982.0f,12601.0f,13243.0f,13902.0f,
    14560.0f,15235.0f,15926.0f,16616.0f,17323.0f,18038.0f,18753.0f,19492.0f,
    20231.0f,20969.0f,21732.0f,22495.0f,23250.0f,24029.0f,24800.0f,25587.0f,
    26375.0f,27162.0f,27957.0f,28752.0f,29555.0f,30358.0f,31153.0f,31964.0f,
    32767.0f,31964.0f,31153.0f,30358.0f,29555.0f,28752.0f,27957.0f,27162.0f,
    26375.0f,25587.0f,24800.0f,24029.0f,23250.0f,22495.0f,21732.0f,20969.0f,
    20231.0f,19492.0f,18753.0f,18038.0f,17323.0f,16616.0f,15926.0f,15235.0f,
    14560.0f,13902.0f,13243.0f,12601.0f,11982.0f,11364.0f,10762.0f,10175.0f,
    9597.0f,9035.0f,8489.0f,7959.0f,7437.0f,6931.0f,6449.0f,5983.0f,
    5525.0f,5083.0f,4658.0f,4256.0f,3871.0f,3501.0f,3148.0f,2810.0f,
    2489.0f,2192.0f,1919.0f,1654.0f,1413.0f,1188.0f,979.0f,795.0f,
    626.0f,481.0f,353.0f,240.0f,152.0f,88.0f,32.0f,8.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT snglpeak_size = 256;

// data for twopeaks.raw...
SAMPLE twopeaks_data[] = {
    0.0f,8.0f,32.0f,88.0f,152.0f,240.0f,353.0f,481.0f,
    626.0f,795.0f,979.0f,1188.0f,1413.0f,1654.0f,1919.0f,2192.0f,
    2489.0f,2810.0f,3148.0f,3501.0f,3871.0f,4256.0f,4658.0f,5083.0f,
    5525.0f,5983.0f,6449.0f,6931.0f,7437.0f,7959.0f,8489.0f,9035.0f,
    9597.0f,10175.0f,10762.0f,11364.0f,11982.0f,12601.0f,13243.0f,13902.0f,
    14560.0f,15235.0f,15926.0f,16616.0f,17323.0f,18038.0f,18753.0f,19492.0f,
    20231.0f,20969.0f,21732.0f,22495.0f,23250.0f,24029.0f,24800.0f,25587.0f,
    26375.0f,27162.0f,27957.0f,28752.0f,29555.0f,30358.0f,31153.0f,31964.0f,
    32767.0f,31964.0f,31153.0f,30358.0f,29555.0f,28752.0f,27957.0f,27162.0f,
    26375.0f,25587.0f,24800.0f,24029.0f,23250.0f,22495.0f,21732.0f,20969.0f,
    20231.0f,19492.0f,18753.0f,18038.0f,17323.0f,16616.0f,15926.0f,15235.0f,
    14560.0f,13902.0f,13243.0f,12601.0f,11982.0f,11364.0f,10762.0f,10175.0f,
    9597.0f,9035.0f,8489.0f,7959.0f,7437.0f,6931.0f,6449.0f,5983.0f,
    5525.0f,5083.0f,4658.0f,4256.0f,3871.0f,3501.0f,3148.0f,2810.0f,
    2489.0f,2192.0f,1919.0f,1654.0f,1413.0f,1188.0f,979.0f,795.0f,
    626.0f,481.0f,353.0f,240.0f,152.0f,88.0f,32.0f,8.0f,
    0.0f,-9.0f,-33.0f,-81.0f,-153.0f,-241.0f,-354.0f,-482.0f,
    -627.0f,-796.0f,-980.0f,-1189.0f,-1414.0f,-1655.0f,-1920.0f,-2193.0f,
    -2490.0f,-2811.0f,-3149.0f,-3502.0f,-3872.0f,-4249.0f,-4659.0f,-5084.0f,
    -5526.0f,-5984.0f,-6442.0f,-6932.0f,-7438.0f,-7960.0f,-8482.0f,-9036.0f,
    -9598.0f,-10176.0f,-10763.0f,-11365.0f,-11983.0f,-12602.0f,-13244.0f,-13903.0f,
    -14561.0f,-15236.0f,-15927.0f,-16609.0f,-17316.0f,-18039.0f,-18754.0f,-19485.0f,
    -20232.0f,-20970.0f,-21725.0f,-22488.0f,-23251.0f,-24030.0f,-24801.0f,-25588.0f,
    -26376.0f,-27163.0f,-27958.0f,-28753.0f,-29556.0f,-30359.0f,-31154.0f,-31965.0f,
    -32768.0f,-31965.0f,-31154.0f,-30359.0f,-29556.0f,-28753.0f,-27958.0f,-27163.0f,
    -26376.0f,-25588.0f,-24801.0f,-24030.0f,-23251.0f,-22488.0f,-21725.0f,-20970.0f,
    -20232.0f,-19485.0f,-18754.0f,-18039.0f,-17316.0f,-16609.0f,-15927.0f,-15236.0f,
    -14561.0f,-13903.0f,-13244.0f,-12602.0f,-11983.0f,-11365.0f,-10763.0f,-10176.0f,
    -9598.0f,-9036.0f,-8482.0f,-7960.0f,-7438.0f,-6932.0f,-6442.0f,-5984.0f,
    -5526.0f,-5084.0f,-4659.0f,-4249.0f,-3872.0f,-3502.0f,-3149.0f,-2811.0f,
    -2490.0f,-2193.0f,-1920.0f,-1655.0f,-1414.0f,-1189.0f,-980.0f,-796.0f,
    -627.0f,-482.0f,-354.0f,-241.0f,-153.0f,-81.0f,-33.0f,-9.0f,
    0
}; t_CKUINT twopeaks_size = 256;

// data for glot_ahh.raw...
SAMPLE glot_ahh_data[] = {
    -1.0f,1.0f,2.0f,3.0f,5.0f,6.0f,5.0f,5.0f,
    4.0f,1.0f,-3.0f,-10.0f,-16.0f,-24.0f,-29.0f,-36.0f,
    -46.0f,-50.0f,-57.0f,-61.0f,-65.0f,-67.0f,-68.0f,-70.0f,
    -69.0f,-67.0f,-65.0f,-60.0f,-56.0f,-52.0f,-46.0f,-41.0f,
    -37.0f,-31.0f,-25.0f,-20.0f,-16.0f,-9.0f,-4.0f,-2.0f,
    1.0f,8.0f,6.0f,9.0f,7.0f,5.0f,3.0f,3.0f,
    0.0f,-3.0f,-13.0f,-12.0f,-16.0f,-16.0f,-13.0f,-8.0f,
    3.0f,20.0f,36.0f,58.0f,77.0f,92.0f,100.0f,103.0f,
    99.0f,91.0f,88.0f,100.0f,135.0f,215.0f,354.0f,563.0f,
    854.0f,1217.0f,1654.0f,2143.0f,2664.0f,3188.0f,3683.0f,4092.0f,
    4411.0f,4612.0f,4685.0f,4633.0f,4458.0f,4190.0f,3860.0f,3492.0f,
    3117.0f,2764.0f,2426.0f,2124.0f,1834.0f,1545.0f,1226.0f,843.0f,
    376.0f,-209.0f,-918.0f,-1762.0f,-2733.0f,-3793.0f,-4925.0f,-6085.0f,
    -7225.0f,-8300.0f,-9248.0f,-10045.0f,-10659.0f,-11069.0f,-11275.0f,-11283.0f,
    -11106.0f,-10786.0f,-10351.0f,-9850.0f,-9311.0f,-8762.0f,-8218.0f,-7692.0f,
    -7180.0f,-6670.0f,-6135.0f,-5549.0f,-4884.0f,-4113.0f,-3236.0f,-2232.0f,
    -1111.0f,108.0f,1405.0f,2743.0f,4082.0f,5379.0f,6597.0f,7699.0f,
    8660.0f,9454.0f,10074.0f,10513.0f,10769.0f,10863.0f,10817.0f,10647.0f,
    10378.0f,10029.0f,9627.0f,9186.0f,8728.0f,8256.0f,7767.0f,7251.0f,
    6711.0f,6120.0f,5474.0f,4754.0f,3949.0f,3055.0f,2079.0f,1042.0f,
    -41.0f,-1130.0f,-2193.0f,-3187.0f,-4080.0f,-4834.0f,-5433.0f,-5857.0f,
    -6113.0f,-6216.0f,-6182.0f,-6045.0f,-5836.0f,-5578.0f,-5312.0f,-5062.0f,
    -4836.0f,-4641.0f,-4479.0f,-4330.0f,-4189.0f,-4039.0f,-3861.0f,-3639.0f,
    -3357.0f,-3015.0f,-2618.0f,-2170.0f,-1692.0f,-1193.0f,-698.0f,-240.0f,
    168.0f,498.0f,751.0f,905.0f,971.0f,952.0f,864.0f,727.0f,
    569.0f,411.0f,271.0f,179.0f,145.0f,189.0f,296.0f,481.0f,
    729.0f,1028.0f,1365.0f,1714.0f,2058.0f,2384.0f,2679.0f,2934.0f,
    3143.0f,3301.0f,3428.0f,3525.0f,3612.0f,3703.0f,3798.0f,3921.0f,
    4074.0f,4256.0f,4469.0f,4692.0f,4912.0f,5116.0f,5271.0f,5365.0f,
    5373.0f,5274.0f,5063.0f,4734.0f,4296.0f,3758.0f,3137.0f,2459.0f,
    1756.0f,1045.0f,360.0f,-282.0f,-867.0f,-1386.0f,-1847.0f,-2256.0f,
    -2623.0f,-2971.0f,-3306.0f,-3652.0f,-4016.0f,-4401.0f,-4796.0f,-5194.0f,
    -5579.0f,-5926.0f,-6221.0f,-6438.0f,-6557.0f,-6565.0f,-6460.0f,-6242.0f,
    -5916.0f,-5505.0f,-5008.0f,-4459.0f,-3871.0f,-3274.0f,-2679.0f,-2103.0f,
    -1557.0f,-1046.0f,-582.0f,-154.0f,235.0f,596.0f,935.0f,1258.0f,
    1577.0f,1892.0f,2208.0f,2522.0f,2834.0f,3133.0f,3414.0f,3657.0f,
    3856.0f,3995.0f,4063.0f,4065.0f,3986.0f,3839.0f,3618.0f,3345.0f,
    3035.0f,2701.0f,2362.0f,2033.0f,1725.0f,1452.0f,1222.0f,1041.0f,
    898.0f,794.0f,719.0f,663.0f,617.0f,564.0f,494.0f,401.0f,
    280.0f,127.0f,-54.0f,-259.0f,-477.0f,-698.0f,-908.0f,-1093.0f,
    -1246.0f,-1360.0f,-1431.0f,-1462.0f,-1465.0f,-1445.0f,-1424.0f,-1410.0f,
    -1418.0f,-1471.0f,-1565.0f,-1710.0f,-1899.0f,-2123.0f,-2372.0f,-2630.0f,
    -2886.0f,-3108.0f,-3297.0f,-3435.0f,-3519.0f,-3542.0f,-3515.0f,-3428.0f,
    -3303.0f,-3144.0f,-2960.0f,-2769.0f,-2565.0f,-2369.0f,-2173.0f,-1986.0f,
    -1803.0f,-1624.0f,-1440.0f,-1240.0f,-1021.0f,-778.0f,-502.0f,-191.0f,
    152.0f,525.0f,921.0f,1331.0f,1745.0f,2139.0f,2508.0f,2840.0f,
    3115.0f,3335.0f,3491.0f,3577.0f,3601.0f,3571.0f,3495.0f,3385.0f,
    3245.0f,3090.0f,2936.0f,2779.0f,2630.0f,2489.0f,2345.0f,2201.0f,
    2047.0f,1875.0f,1675.0f,1442.0f,1169.0f,862.0f,516.0f,146.0f,
    -236.0f,-621.0f,-995.0f,-1343.0f,-1649.0f,-1908.0f,-2112.0f,-2259.0f,
    -2355.0f,-2401.0f,-2405.0f,-2384.0f,-2340.0f,-2289.0f,-2235.0f,-2185.0f,
    -2141.0f,-2106.0f,-2071.0f,-2036.0f,-1996.0f,-1942.0f,-1868.0f,-1775.0f,
    -1653.0f,-1503.0f,-1336.0f,-1141.0f,-935.0f,-719.0f,-504.0f,-300.0f,
    -112.0f,55.0f,194.0f,306.0f,380.0f,432.0f,459.0f,468.0f,
    466.0f,463.0f,465.0f,477.0f,509.0f,558.0f,627.0f,721.0f,
    831.0f,950.0f,1076.0f,1197.0f,1311.0f,1411.0f,1490.0f,1552.0f,
    1588.0f,1600.0f,1599.0f,1583.0f,1561.0f,1531.0f,1508.0f,1491.0f,
    1481.0f,1481.0f,1494.0f,1506.0f,1523.0f,1530.0f,1528.0f,1502.0f,
    1453.0f,1372.0f,1256.0f,1106.0f,923.0f,715.0f,486.0f,244.0f,
    1.0f,-238.0f,-462.0f,-667.0f,-845.0f,-998.0f,-1124.0f,-1228.0f,
    -1314.0f,-1387.0f,-1451.0f,-1515.0f,-1581.0f,-1650.0f,-1723.0f,-1793.0f,
    -1863.0f,-1925.0f,-1969.0f,-2000.0f,-1997.0f,-1971.0f,-1908.0f,-1811.0f,
    -1686.0f,-1523.0f,-1342.0f,-1136.0f,-923.0f,-698.0f,-482.0f,-269.0f,
    -75.0f,107.0f,265.0f,400.0f,520.0f,622.0f,713.0f,793.0f,
    873.0f,954.0f,1036.0f,1121.0f,1210.0f,1303.0f,1388.0f,1468.0f,
    1527.0f,1572.0f,1588.0f,1581.0f,1539.0f,1473.0f,1380.0f,1270.0f,
    1141.0f,1008.0f,873.0f,741.0f,621.0f,515.0f,427.0f,352.0f,
    292.0f,245.0f,203.0f,167.0f,129.0f,86.0f,37.0f,-23.0f,
    -92.0f,-169.0f,-252.0f,-336.0f,-420.0f,-497.0f,-568.0f,-626.0f,
    -668.0f,-699.0f,-716.0f,-723.0f,-720.0f,-718.0f,-710.0f,-711.0f,
    -715.0f,-730.0f,-755.0f,-794.0f,-839.0f,-892.0f,-955.0f,-1010.0f,
    -1066.0f,-1112.0f,-1141.0f,-1162.0f,-1156.0f,-1138.0f,-1098.0f,-1041.0f,
    -972.0f,-891.0f,-805.0f,-713.0f,-628.0f,-546.0f,-471.0f,-402.0f,
    -342.0f,-288.0f,-231.0f,-176.0f,-119.0f,-51.0f,27.0f,116.0f,
    214.0f,324.0f,438.0f,558.0f,670.0f,780.0f,876.0f,957.0f,
    1019.0f,1062.0f,1080.0f,1076.0f,1055.0f,1019.0f,968.0f,909.0f,
    843.0f,779.0f,712.0f,653.0f,597.0f,541.0f,488.0f,439.0f,
    383.0f,324.0f,255.0f,177.0f,91.0f,-6.0f,-117.0f,-230.0f,
    -345.0f,-462.0f,-571.0f,-673.0f,-759.0f,-831.0f,-883.0f,-922.0f,
    -944.0f,-950.0f,-943.0f,-931.0f,-911.0f,-887.0f,-866.0f,-844.0f,
    -826.0f,-811.0f,-795.0f,-780.0f,-765.0f,-746.0f,-719.0f,-685.0f,
    -645.0f,-595.0f,-535.0f,-467.0f,-396.0f,-319.0f,-241.0f,-169.0f,
    -98.0f,-36.0f,16.0f,59.0f,90.0f,115.0f,131.0f,140.0f,
    146.0f,155.0f,168.0f,184.0f,209.0f,242.0f,281.0f,328.0f,
    379.0f,434.0f,483.0f,528.0f,567.0f,595.0f,610.0f,614.0f,
    611.0f,595.0f,575.0f,551.0f,528.0f,505.0f,485.0f,470.0f,
    466.0f,462.0f,460.0f,462.0f,465.0f,459.0f,449.0f,433.0f,
    406.0f,369.0f,318.0f,257.0f,187.0f,110.0f,28.0f,-56.0f,
    -136.0f,-214.0f,-284.0f,-347.0f,-398.0f,-440.0f,-475.0f,-501.0f,
    -524.0f,-537.0f,-554.0f,-566.0f,-581.0f,-593.0f,-610.0f,-623.0f,
    -637.0f,-647.0f,-654.0f,-652.0f,-644.0f,-627.0f,-598.0f,-559.0f,
    -505.0f,-451.0f,-379.0f,-307.0f,-228.0f,-154.0f,-76.0f,-6.0f,
    63.0f,119.0f,169.0f,214.0f,252.0f,282.0f,312.0f,343.0f,
    373.0f,408.0f,443.0f,484.0f,526.0f,565.0f,604.0f,636.0f,
    666.0f,680.0f,685.0f,678.0f,659.0f,624.0f,580.0f,532.0f,
    479.0f,422.0f,366.0f,318.0f,272.0f,235.0f,205.0f,180.0f,
    160.0f,143.0f,126.0f,110.0f,91.0f,67.0f,36.0f,3.0f,
    -36.0f,-78.0f,-123.0f,-167.0f,-212.0f,-248.0f,-286.0f,-315.0f,
    -339.0f,-354.0f,-368.0f,-375.0f,-380.0f,-385.0f,-385.0f,-390.0f,
    -393.0f,-401.0f,-410.0f,-422.0f,-433.0f,-446.0f,-457.0f,-468.0f,
    -476.0f,-476.0f,-474.0f,-467.0f,-454.0f,-433.0f,-406.0f,-376.0f,
    -337.0f,-297.0f,-254.0f,-212.0f,-168.0f,-128.0f,-89.0f,-55.0f,
    -24.0f,3.0f,28.0f,50.0f,72.0f,93.0f,117.0f,143.0f,
    171.0f,203.0f,238.0f,275.0f,314.0f,349.0f,383.0f,411.0f,
    431.0f,445.0f,446.0f,437.0f,420.0f,398.0f,365.0f,328.0f,
    289.0f,251.0f,214.0f,180.0f,152.0f,126.0f,105.0f,85.0f,
    62.0f,42.0f,19.0f,-8.0f,-41.0f,-77.0f,-116.0f,-159.0f,
    -203.0f,-247.0f,-290.0f,-328.0f,-363.0f,-392.0f,-415.0f,-430.0f,
    -440.0f,-439.0f,-436.0f,-431.0f,-419.0f,-401.0f,-387.0f,-370.0f,
    -356.0f,-344.0f,-330.0f,-322.0f,-316.0f,-310.0f,-303.0f,-297.0f,
    -285.0f,-271.0f,-255.0f,-231.0f,-205.0f,-176.0f,-143.0f,-110.0f,
    -81.0f,-49.0f,-22.0f,-5.0f,15.0f,23.0f,31.0f,33.0f,
    36.0f,35.0f,37.0f,38.0f,46.0f,53.0f,69.0f,85.0f,
    106.0f,125.0f,146.0f,164.0f,184.0f,196.0f,204.0f,208.0f,
    207.0f,202.0f,193.0f,184.0f,174.0f,165.0f,158.0f,154.0f,
    153.0f,156.0f,163.0f,171.0f,174.0f,179.0f,174.0f,165.0f,
    149.0f,125.0f,91.0f,56.0f,18.0f,-22.0f,-54.0f,-82.0f,
    -100.0f,-105.0f,-102.0f,-90.0f,-72.0f,-52.0f,-29.0f,-9.0f,
    4.0f,14.0f,18.0f,19.0f,11.0f,9.0f,0.0f,-2.0f,
    -8.0f,-8.0f,-7.0f,-7.0f,-4.0f,-2.0f,0.0f,1.0f,
    1.0f,0.0f,0.0f,0.0f,-1.0f,-1.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,
    0
}; t_CKUINT glot_ahh_size = 992;

// data for glot_eee.raw...
SAMPLE glot_eee_data[] = { 0.0f,
    -2.0f,-3.0f,1.0f,-1.0f,4.0f,4.0f,4.0f,3.0f,
    1.0f,-2.0f,-6.0f,-13.0f,-20.0f,-27.0f,-31.0f,-40.0f,
    -43.0f,-45.0f,-44.0f,-46.0f,-45.0f,-42.0f,-45.0f,-45.0f,
    -46.0f,-48.0f,-52.0f,-51.0f,-55.0f,-58.0f,-57.0f,-54.0f,
    -54.0f,-51.0f,-49.0f,-47.0f,-44.0f,-42.0f,-43.0f,-42.0f,
    -43.0f,-46.0f,-42.0f,-43.0f,-40.0f,-38.0f,-34.0f,-29.0f,
    -29.0f,-27.0f,-26.0f,-24.0f,-25.0f,-26.0f,-27.0f,-32.0f,
    -31.0f,-35.0f,-33.0f,-34.0f,-31.0f,-32.0f,-28.0f,-27.0f,
    -26.0f,-20.0f,-20.0f,-20.0f,-19.0f,-20.0f,-26.0f,-27.0f,
    -35.0f,-40.0f,-46.0f,-49.0f,-50.0f,-53.0f,-51.0f,-46.0f,
    -43.0f,-38.0f,-29.0f,-23.0f,-20.0f,-13.0f,-11.0f,-7.0f,
    -9.0f,-10.0f,-10.0f,-13.0f,-17.0f,-15.0f,-19.0f,-16.0f,
    -14.0f,-11.0f,-9.0f,-5.0f,-2.0f,1.0f,3.0f,6.0f,
    6.0f,6.0f,4.0f,4.0f,0.0f,1.0f,-1.0f,0.0f,
    -2.0f,-1.0f,-2.0f,0.0f,-2.0f,-3.0f,-4.0f,-7.0f,
    -9.0f,-14.0f,-14.0f,-19.0f,-23.0f,-22.0f,-21.0f,-19.0f,
    -17.0f,-11.0f,-9.0f,-2.0f,-1.0f,4.0f,7.0f,8.0f,
    6.0f,7.0f,6.0f,4.0f,1.0f,-1.0f,-8.0f,-11.0f,
    -17.0f,-22.0f,-25.0f,-29.0f,-31.0f,-28.0f,-25.0f,-18.0f,
    -4.0f,8.0f,29.0f,39.0f,43.0f,36.0f,12.0f,-26.0f,
    -75.0f,-119.0f,-154.0f,-154.0f,-98.0f,19.0f,213.0f,476.0f,
    796.0f,1141.0f,1468.0f,1733.0f,1891.0f,1903.0f,1747.0f,1429.0f,
    971.0f,434.0f,-115.0f,-594.0f,-926.0f,-1045.0f,-922.0f,-560.0f,
    -6.0f,669.0f,1359.0f,1967.0f,2389.0f,2567.0f,2467.0f,2118.0f,
    1579.0f,942.0f,321.0f,-186.0f,-498.0f,-576.0f,-427.0f,-103.0f,
    309.0f,714.0f,1013.0f,1133.0f,1050.0f,774.0f,358.0f,-100.0f,
    -516.0f,-788.0f,-855.0f,-701.0f,-351.0f,129.0f,641.0f,1067.0f,
    1325.0f,1338.0f,1089.0f,601.0f,-60.0f,-792.0f,-1472.0f,-2013.0f,
    -2326.0f,-2378.0f,-2174.0f,-1766.0f,-1241.0f,-692.0f,-214.0f,116.0f,
    255.0f,193.0f,-43.0f,-396.0f,-807.0f,-1201.0f,-1527.0f,-1744.0f,
    -1852.0f,-1851.0f,-1786.0f,-1692.0f,-1613.0f,-1581.0f,-1609.0f,-1698.0f,
    -1832.0f,-1976.0f,-2101.0f,-2168.0f,-2157.0f,-2071.0f,-1904.0f,-1687.0f,
    -1450.0f,-1232.0f,-1067.0f,-993.0f,-1012.0f,-1138.0f,-1351.0f,-1628.0f,
    -1942.0f,-2240.0f,-2502.0f,-2686.0f,-2775.0f,-2764.0f,-2657.0f,-2471.0f,
    -2234.0f,-1973.0f,-1718.0f,-1498.0f,-1328.0f,-1224.0f,-1183.0f,-1204.0f,
    -1271.0f,-1372.0f,-1491.0f,-1618.0f,-1734.0f,-1839.0f,-1932.0f,-2006.0f,
    -2069.0f,-2123.0f,-2163.0f,-2190.0f,-2206.0f,-2196.0f,-2160.0f,-2095.0f,
    -1989.0f,-1844.0f,-1662.0f,-1446.0f,-1199.0f,-941.0f,-671.0f,-415.0f,
    -183.0f,12.0f,152.0f,224.0f,232.0f,161.0f,31.0f,-147.0f,
    -345.0f,-526.0f,-665.0f,-728.0f,-685.0f,-532.0f,-266.0f,96.0f,
    529.0f,982.0f,1419.0f,1797.0f,2085.0f,2266.0f,2340.0f,2328.0f,
    2255.0f,2153.0f,2068.0f,2014.0f,2011.0f,2061.0f,2145.0f,2243.0f,
    2332.0f,2387.0f,2404.0f,2385.0f,2351.0f,2341.0f,2380.0f,2506.0f,
    2730.0f,3054.0f,3457.0f,3901.0f,4322.0f,4673.0f,4897.0f,4963.0f,
    4865.0f,4618.0f,4261.0f,3855.0f,3466.0f,3149.0f,2956.0f,2900.0f,
    2983.0f,3173.0f,3431.0f,3711.0f,3962.0f,4142.0f,4240.0f,4254.0f,
    4198.0f,4098.0f,3988.0f,3889.0f,3817.0f,3775.0f,3747.0f,3718.0f,
    3657.0f,3542.0f,3358.0f,3108.0f,2806.0f,2475.0f,2149.0f,1866.0f,
    1663.0f,1549.0f,1549.0f,1637.0f,1801.0f,1996.0f,2190.0f,2344.0f,
    2427.0f,2407.0f,2286.0f,2063.0f,1748.0f,1380.0f,975.0f,565.0f,
    181.0f,-162.0f,-448.0f,-671.0f,-838.0f,-949.0f,-1018.0f,-1053.0f,
    -1060.0f,-1052.0f,-1036.0f,-1020.0f,-1006.0f,-1000.0f,-1000.0f,-1024.0f,
    -1070.0f,-1144.0f,-1256.0f,-1409.0f,-1604.0f,-1840.0f,-2106.0f,-2393.0f,
    -2681.0f,-2951.0f,-3182.0f,-3354.0f,-3459.0f,-3487.0f,-3434.0f,-3321.0f,
    -3163.0f,-2978.0f,-2796.0f,-2637.0f,-2523.0f,-2464.0f,-2474.0f,-2544.0f,
    -2671.0f,-2840.0f,-3031.0f,-3232.0f,-3419.0f,-3588.0f,-3719.0f,-3805.0f,
    -3846.0f,-3840.0f,-3785.0f,-3687.0f,-3551.0f,-3385.0f,-3197.0f,-2998.0f,
    -2798.0f,-2610.0f,-2444.0f,-2312.0f,-2219.0f,-2170.0f,-2163.0f,-2205.0f,
    -2279.0f,-2378.0f,-2487.0f,-2592.0f,-2688.0f,-2754.0f,-2781.0f,-2759.0f,
    -2687.0f,-2565.0f,-2398.0f,-2190.0f,-1950.0f,-1695.0f,-1434.0f,-1191.0f,
    -972.0f,-787.0f,-649.0f,-558.0f,-518.0f,-527.0f,-569.0f,-640.0f,
    -723.0f,-799.0f,-868.0f,-906.0f,-911.0f,-874.0f,-793.0f,-671.0f,
    -515.0f,-325.0f,-115.0f,107.0f,331.0f,541.0f,729.0f,892.0f,
    1012.0f,1089.0f,1120.0f,1104.0f,1052.0f,962.0f,856.0f,741.0f,
    629.0f,533.0f,463.0f,436.0f,447.0f,505.0f,602.0f,735.0f,
    895.0f,1071.0f,1249.0f,1416.0f,1565.0f,1679.0f,1759.0f,1791.0f,
    1782.0f,1729.0f,1638.0f,1519.0f,1381.0f,1236.0f,1099.0f,970.0f,
    872.0f,806.0f,773.0f,782.0f,830.0f,902.0f,1006.0f,1123.0f,
    1242.0f,1355.0f,1453.0f,1526.0f,1564.0f,1566.0f,1528.0f,1451.0f,
    1342.0f,1201.0f,1039.0f,870.0f,701.0f,543.0f,403.0f,293.0f,
    213.0f,174.0f,166.0f,194.0f,248.0f,322.0f,403.0f,485.0f,
    557.0f,611.0f,639.0f,635.0f,598.0f,527.0f,425.0f,299.0f,
    153.0f,-3.0f,-155.0f,-299.0f,-429.0f,-528.0f,-602.0f,-637.0f,
    -638.0f,-608.0f,-549.0f,-471.0f,-374.0f,-279.0f,-185.0f,-111.0f,
    -52.0f,-22.0f,-25.0f,-61.0f,-123.0f,-210.0f,-316.0f,-430.0f,
    -550.0f,-656.0f,-756.0f,-825.0f,-874.0f,-888.0f,-873.0f,-827.0f,
    -756.0f,-664.0f,-561.0f,-452.0f,-344.0f,-253.0f,-174.0f,-123.0f,
    -101.0f,-111.0f,-145.0f,-205.0f,-286.0f,-376.0f,-469.0f,-558.0f,
    -631.0f,-685.0f,-707.0f,-703.0f,-664.0f,-597.0f,-506.0f,-395.0f,
    -276.0f,-148.0f,-30.0f,76.0f,163.0f,225.0f,260.0f,267.0f,
    247.0f,207.0f,146.0f,74.0f,-5.0f,-77.0f,-145.0f,-191.0f,
    -218.0f,-221.0f,-196.0f,-144.0f,-69.0f,28.0f,136.0f,259.0f,
    374.0f,485.0f,575.0f,646.0f,687.0f,705.0f,690.0f,648.0f,
    587.0f,507.0f,422.0f,336.0f,257.0f,194.0f,150.0f,132.0f,
    141.0f,175.0f,232.0f,309.0f,402.0f,500.0f,597.0f,685.0f,
    758.0f,807.0f,835.0f,834.0f,808.0f,757.0f,685.0f,604.0f,
    511.0f,420.0f,333.0f,260.0f,206.0f,170.0f,155.0f,168.0f,
    195.0f,243.0f,302.0f,369.0f,437.0f,497.0f,547.0f,580.0f,
    591.0f,580.0f,543.0f,488.0f,409.0f,315.0f,217.0f,111.0f,
    10.0f,-81.0f,-151.0f,-204.0f,-232.0f,-238.0f,-220.0f,-183.0f,
    -132.0f,-75.0f,-12.0f,44.0f,86.0f,114.0f,121.0f,107.0f,
    68.0f,10.0f,-67.0f,-156.0f,-252.0f,-352.0f,-443.0f,-524.0f,
    -593.0f,-642.0f,-666.0f,-671.0f,-654.0f,-617.0f,-566.0f,-505.0f,
    -438.0f,-374.0f,-315.0f,-269.0f,-242.0f,-233.0f,-243.0f,-277.0f,
    -330.0f,-398.0f,-474.0f,-558.0f,-641.0f,-714.0f,-775.0f,-819.0f,
    -840.0f,-841.0f,-818.0f,-778.0f,-719.0f,-649.0f,-573.0f,-500.0f,
    -430.0f,-375.0f,-334.0f,-312.0f,-308.0f,-322.0f,-351.0f,-393.0f,
    -442.0f,-493.0f,-545.0f,-584.0f,-616.0f,-631.0f,-629.0f,-608.0f,
    -570.0f,-517.0f,-448.0f,-370.0f,-287.0f,-204.0f,-125.0f,-57.0f,
    1.0f,35.0f,54.0f,53.0f,34.0f,-1.0f,-48.0f,-102.0f,
    -159.0f,-213.0f,-255.0f,-285.0f,-300.0f,-293.0f,-271.0f,-228.0f,
    -171.0f,-102.0f,-26.0f,53.0f,128.0f,193.0f,250.0f,285.0f,
    307.0f,305.0f,289.0f,250.0f,204.0f,146.0f,89.0f,36.0f,
    -14.0f,-45.0f,-60.0f,-58.0f,-36.0f,6.0f,63.0f,130.0f,
    203.0f,277.0f,344.0f,402.0f,447.0f,470.0f,474.0f,462.0f,
    432.0f,387.0f,334.0f,275.0f,218.0f,162.0f,117.0f,84.0f,
    66.0f,62.0f,74.0f,101.0f,140.0f,187.0f,243.0f,292.0f,
    344.0f,389.0f,421.0f,437.0f,444.0f,431.0f,401.0f,360.0f,
    303.0f,241.0f,173.0f,107.0f,48.0f,1.0f,-38.0f,-55.0f,
    -58.0f,-44.0f,-21.0f,20.0f,62.0f,109.0f,152.0f,191.0f,
    220.0f,238.0f,243.0f,234.0f,213.0f,183.0f,142.0f,97.0f,
    50.0f,5.0f,-37.0f,-72.0f,-96.0f,-111.0f,-111.0f,-102.0f,
    -84.0f,-54.0f,-20.0f,16.0f,53.0f,86.0f,109.0f,123.0f,
    130.0f,120.0f,103.0f,71.0f,29.0f,-17.0f,-67.0f,-119.0f,
    -170.0f,-212.0f,-246.0f,-273.0f,-284.0f,-285.0f,-268.0f,-247.0f,
    -212.0f,-170.0f,-125.0f,-81.0f,-43.0f,-11.0f,11.0f,21.0f,
    18.0f,3.0f,-28.0f,-65.0f,-107.0f,-154.0f,-197.0f,-236.0f,
    -269.0f,-286.0f,-294.0f,-290.0f,-272.0f,-245.0f,-212.0f,-173.0f,
    -134.0f,-99.0f,-63.0f,-40.0f,-26.0f,-17.0f,-19.0f,-30.0f,
    -50.0f,-74.0f,-101.0f,-131.0f,-156.0f,-181.0f,-197.0f,-205.0f,
    -205.0f,-195.0f,-176.0f,-147.0f,-115.0f,-78.0f,-38.0f,-2.0f,
    31.0f,59.0f,76.0f,88.0f,90.0f,85.0f,74.0f,61.0f,
    44.0f,26.0f,13.0f,1.0f,-6.0f,-11.0f,-12.0f,-10.0f,
    -9.0f,-6.0f,-1.0f,0.0f,4.0f,2.0f,0.0f,
    0
}; t_CKUINT glot_eee_size = 992;

// data for glot_ooo.raw...
SAMPLE glot_ooo_data[] = {
    0.0f,-1.0f,-5.0f,-4.0f,-8.0f,-7.0f,-6.0f,-6.0f,
    2.0f,8.0f,15.0f,23.0f,30.0f,38.0f,43.0f,45.0f,
    46.0f,47.0f,45.0f,45.0f,44.0f,44.0f,45.0f,51.0f,
    55.0f,62.0f,71.0f,76.0f,82.0f,86.0f,90.0f,88.0f,
    89.0f,87.0f,86.0f,86.0f,83.0f,85.0f,86.0f,88.0f,
    90.0f,96.0f,99.0f,101.0f,104.0f,106.0f,106.0f,101.0f,
    99.0f,98.0f,97.0f,98.0f,96.0f,100.0f,107.0f,114.0f,
    121.0f,129.0f,137.0f,142.0f,148.0f,149.0f,149.0f,144.0f,
    139.0f,140.0f,138.0f,146.0f,168.0f,203.0f,256.0f,331.0f,
    425.0f,544.0f,676.0f,822.0f,975.0f,1123.0f,1263.0f,1387.0f,
    1491.0f,1565.0f,1616.0f,1641.0f,1648.0f,1642.0f,1621.0f,1602.0f,
    1578.0f,1557.0f,1533.0f,1509.0f,1466.0f,1406.0f,1318.0f,1196.0f,
    1032.0f,826.0f,573.0f,278.0f,-50.0f,-409.0f,-784.0f,-1174.0f,
    -1565.0f,-1951.0f,-2325.0f,-2686.0f,-3030.0f,-3358.0f,-3671.0f,-3970.0f,
    -4258.0f,-4533.0f,-4800.0f,-5048.0f,-5285.0f,-5501.0f,-5696.0f,-5862.0f,
    -5992.0f,-6081.0f,-6133.0f,-6141.0f,-6108.0f,-6027.0f,-5906.0f,-5749.0f,
    -5561.0f,-5342.0f,-5095.0f,-4827.0f,-4536.0f,-4233.0f,-3913.0f,-3587.0f,
    -3241.0f,-2885.0f,-2524.0f,-2151.0f,-1779.0f,-1392.0f,-1007.0f,-607.0f,
    -207.0f,208.0f,627.0f,1066.0f,1505.0f,1952.0f,2408.0f,2852.0f,
    3290.0f,3703.0f,4085.0f,4430.0f,4735.0f,4991.0f,5199.0f,5358.0f,
    5472.0f,5553.0f,5602.0f,5631.0f,5637.0f,5638.0f,5625.0f,5610.0f,
    5588.0f,5557.0f,5510.0f,5445.0f,5364.0f,5252.0f,5117.0f,4945.0f,
    4750.0f,4519.0f,4265.0f,3989.0f,3697.0f,3397.0f,3094.0f,2804.0f,
    2518.0f,2254.0f,2010.0f,1789.0f,1585.0f,1400.0f,1227.0f,1066.0f,
    911.0f,758.0f,607.0f,459.0f,306.0f,167.0f,33.0f,-94.0f,
    -209.0f,-305.0f,-393.0f,-453.0f,-500.0f,-527.0f,-534.0f,-534.0f,
    -508.0f,-476.0f,-433.0f,-391.0f,-339.0f,-300.0f,-260.0f,-236.0f,
    -220.0f,-220.0f,-241.0f,-267.0f,-314.0f,-366.0f,-430.0f,-494.0f,
    -567.0f,-635.0f,-698.0f,-764.0f,-822.0f,-884.0f,-941.0f,-1005.0f,
    -1077.0f,-1158.0f,-1254.0f,-1367.0f,-1493.0f,-1641.0f,-1798.0f,-1966.0f,
    -2143.0f,-2320.0f,-2490.0f,-2649.0f,-2791.0f,-2913.0f,-3014.0f,-3096.0f,
    -3155.0f,-3195.0f,-3223.0f,-3239.0f,-3248.0f,-3251.0f,-3249.0f,-3241.0f,
    -3230.0f,-3204.0f,-3171.0f,-3120.0f,-3053.0f,-2968.0f,-2858.0f,-2723.0f,
    -2569.0f,-2395.0f,-2206.0f,-1997.0f,-1774.0f,-1543.0f,-1305.0f,-1058.0f,
    -811.0f,-559.0f,-306.0f,-55.0f,197.0f,445.0f,687.0f,929.0f,
    1162.0f,1381.0f,1595.0f,1799.0f,1993.0f,2175.0f,2347.0f,2508.0f,
    2662.0f,2800.0f,2935.0f,3051.0f,3150.0f,3239.0f,3300.0f,3341.0f,
    3353.0f,3340.0f,3298.0f,3234.0f,3147.0f,3042.0f,2920.0f,2791.0f,
    2657.0f,2519.0f,2389.0f,2251.0f,2117.0f,1981.0f,1836.0f,1686.0f,
    1519.0f,1339.0f,1143.0f,932.0f,706.0f,473.0f,234.0f,1.0f,
    -230.0f,-444.0f,-641.0f,-816.0f,-966.0f,-1095.0f,-1204.0f,-1291.0f,
    -1365.0f,-1431.0f,-1490.0f,-1544.0f,-1599.0f,-1651.0f,-1706.0f,-1753.0f,
    -1796.0f,-1832.0f,-1856.0f,-1868.0f,-1867.0f,-1849.0f,-1818.0f,-1775.0f,
    -1722.0f,-1662.0f,-1593.0f,-1520.0f,-1449.0f,-1372.0f,-1295.0f,-1224.0f,
    -1154.0f,-1087.0f,-1027.0f,-973.0f,-929.0f,-893.0f,-867.0f,-851.0f,
    -839.0f,-833.0f,-831.0f,-830.0f,-826.0f,-820.0f,-809.0f,-791.0f,
    -775.0f,-758.0f,-737.0f,-721.0f,-715.0f,-712.0f,-724.0f,-742.0f,
    -775.0f,-811.0f,-859.0f,-905.0f,-954.0f,-997.0f,-1033.0f,-1056.0f,
    -1069.0f,-1063.0f,-1043.0f,-1013.0f,-971.0f,-918.0f,-862.0f,-802.0f,
    -746.0f,-689.0f,-638.0f,-581.0f,-528.0f,-471.0f,-412.0f,-344.0f,
    -264.0f,-180.0f,-80.0f,28.0f,147.0f,269.0f,401.0f,531.0f,
    663.0f,794.0f,924.0f,1051.0f,1173.0f,1289.0f,1402.0f,1509.0f,
    1605.0f,1697.0f,1779.0f,1849.0f,1910.0f,1962.0f,2005.0f,2042.0f,
    2072.0f,2099.0f,2122.0f,2143.0f,2158.0f,2167.0f,2170.0f,2159.0f,
    2137.0f,2097.0f,2035.0f,1959.0f,1865.0f,1752.0f,1631.0f,1497.0f,
    1362.0f,1226.0f,1088.0f,962.0f,834.0f,717.0f,602.0f,490.0f,
    383.0f,276.0f,161.0f,47.0f,-73.0f,-199.0f,-326.0f,-457.0f,
    -585.0f,-711.0f,-830.0f,-943.0f,-1045.0f,-1136.0f,-1211.0f,-1273.0f,
    -1321.0f,-1354.0f,-1380.0f,-1391.0f,-1392.0f,-1388.0f,-1378.0f,-1363.0f,
    -1347.0f,-1327.0f,-1309.0f,-1288.0f,-1267.0f,-1246.0f,-1221.0f,-1188.0f,
    -1153.0f,-1113.0f,-1062.0f,-1006.0f,-940.0f,-870.0f,-793.0f,-711.0f,
    -636.0f,-555.0f,-479.0f,-410.0f,-342.0f,-282.0f,-226.0f,-181.0f,
    -137.0f,-102.0f,-68.0f,-43.0f,-21.0f,-3.0f,12.0f,25.0f,
    36.0f,48.0f,57.0f,66.0f,74.0f,78.0f,87.0f,85.0f,
    85.0f,77.0f,67.0f,54.0f,36.0f,18.0f,0.0f,-18.0f,
    -32.0f,-42.0f,-46.0f,-39.0f,-30.0f,-10.0f,12.0f,42.0f,
    72.0f,103.0f,133.0f,162.0f,185.0f,206.0f,227.0f,243.0f,
    259.0f,279.0f,301.0f,327.0f,358.0f,394.0f,433.0f,476.0f,
    520.0f,570.0f,616.0f,663.0f,702.0f,740.0f,773.0f,799.0f,
    818.0f,828.0f,833.0f,833.0f,825.0f,810.0f,797.0f,777.0f,
    751.0f,727.0f,700.0f,672.0f,644.0f,612.0f,581.0f,546.0f,
    505.0f,464.0f,416.0f,360.0f,301.0f,238.0f,167.0f,94.0f,
    20.0f,-57.0f,-136.0f,-214.0f,-288.0f,-360.0f,-429.0f,-499.0f,
    -560.0f,-619.0f,-676.0f,-727.0f,-774.0f,-817.0f,-856.0f,-897.0f,
    -929.0f,-961.0f,-990.0f,-1015.0f,-1038.0f,-1057.0f,-1072.0f,-1080.0f,
    -1086.0f,-1083.0f,-1076.0f,-1057.0f,-1038.0f,-1011.0f,-983.0f,-949.0f,
    -917.0f,-883.0f,-847.0f,-816.0f,-780.0f,-748.0f,-715.0f,-678.0f,
    -639.0f,-600.0f,-556.0f,-513.0f,-462.0f,-415.0f,-362.0f,-314.0f,
    -262.0f,-213.0f,-165.0f,-118.0f,-77.0f,-31.0f,5.0f,45.0f,
    76.0f,107.0f,136.0f,160.0f,181.0f,201.0f,218.0f,231.0f,
    242.0f,254.0f,261.0f,268.0f,269.0f,275.0f,279.0f,277.0f,
    280.0f,279.0f,276.0f,273.0f,269.0f,261.0f,250.0f,237.0f,
    222.0f,205.0f,187.0f,170.0f,156.0f,144.0f,132.0f,128.0f,
    130.0f,138.0f,146.0f,159.0f,176.0f,188.0f,206.0f,219.0f,
    230.0f,241.0f,247.0f,251.0f,254.0f,256.0f,257.0f,257.0f,
    258.0f,258.0f,260.0f,264.0f,270.0f,273.0f,280.0f,287.0f,
    293.0f,300.0f,300.0f,305.0f,303.0f,298.0f,290.0f,279.0f,
    262.0f,245.0f,224.0f,203.0f,181.0f,158.0f,134.0f,107.0f,
    84.0f,55.0f,35.0f,6.0f,-21.0f,-50.0f,-77.0f,-111.0f,
    -141.0f,-176.0f,-208.0f,-244.0f,-280.0f,-313.0f,-349.0f,-384.0f,
    -415.0f,-448.0f,-477.0f,-503.0f,-524.0f,-543.0f,-551.0f,-562.0f,
    -561.0f,-563.0f,-558.0f,-551.0f,-543.0f,-531.0f,-521.0f,-509.0f,
    -497.0f,-483.0f,-464.0f,-446.0f,-423.0f,-397.0f,-371.0f,-339.0f,
    -307.0f,-270.0f,-239.0f,-200.0f,-166.0f,-134.0f,-102.0f,-69.0f,
    -38.0f,-10.0f,21.0f,50.0f,79.0f,112.0f,142.0f,170.0f,
    198.0f,229.0f,257.0f,282.0f,305.0f,326.0f,345.0f,358.0f,
    370.0f,377.0f,382.0f,385.0f,385.0f,382.0f,380.0f,371.0f,
    365.0f,359.0f,349.0f,342.0f,329.0f,319.0f,304.0f,292.0f,
    277.0f,262.0f,247.0f,227.0f,213.0f,194.0f,178.0f,159.0f,
    143.0f,127.0f,108.0f,92.0f,73.0f,58.0f,42.0f,27.0f,
    12.0f,0.0f,-8.0f,-15.0f,-21.0f,-20.0f,-22.0f,-21.0f,
    -16.0f,-14.0f,-11.0f,-10.0f,-13.0f,-13.0f,-20.0f,-28.0f,
    -37.0f,-45.0f,-53.0f,-61.0f,-64.0f,-67.0f,-64.0f,-61.0f,
    -54.0f,-52.0f,-46.0f,-45.0f,-45.0f,-52.0f,-63.0f,-77.0f,
    -92.0f,-110.0f,-128.0f,-148.0f,-163.0f,-175.0f,-191.0f,-196.0f,
    -203.0f,-210.0f,-216.0f,-219.0f,-225.0f,-230.0f,-240.0f,-251.0f,
    -258.0f,-270.0f,-282.0f,-290.0f,-303.0f,-310.0f,-321.0f,-329.0f,
    -338.0f,-346.0f,-354.0f,-362.0f,-369.0f,-375.0f,-379.0f,-377.0f,
    -374.0f,-370.0f,-358.0f,-345.0f,-328.0f,-309.0f,-289.0f,-265.0f,
    -242.0f,-222.0f,-198.0f,-176.0f,-154.0f,-130.0f,-110.0f,-82.0f,
    -58.0f,-33.0f,-4.0f,24.0f,51.0f,81.0f,107.0f,128.0f,
    153.0f,176.0f,193.0f,211.0f,227.0f,239.0f,252.0f,262.0f,
    276.0f,283.0f,292.0f,301.0f,304.0f,306.0f,309.0f,306.0f,
    306.0f,297.0f,292.0f,284.0f,276.0f,265.0f,258.0f,252.0f,
    245.0f,240.0f,230.0f,229.0f,222.0f,215.0f,204.0f,194.0f,
    181.0f,166.0f,150.0f,133.0f,115.0f,94.0f,79.0f,60.0f,
    44.0f,29.0f,13.0f,3.0f,-9.0f,-19.0f,-28.0f,-36.0f,
    -42.0f,-48.0f,-54.0f,-60.0f,-66.0f,-75.0f,-83.0f,-94.0f,
    -101.0f,-107.0f,-112.0f,-114.0f,-109.0f,-104.0f,-93.0f,-80.0f,
    -63.0f,-45.0f,-32.0f,-17.0f,-4.0f,3.0f,8.0f,9.0f,
    8.0f,7.0f,3.0f,0.0f,-5.0f,-5.0f,-4.0f,-5.0f,
    -5.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,
    0
}; t_CKUINT glot_ooo_size = 992;

// data for glot_pop.raw...
SAMPLE glot_pop_data[] = {
    0.0f,0.0f,1.0f,-1.0f,0.0f,0.0f,0.0f,0.0f,
    1.0f,1.0f,513.0f,561.0f,565.0f,499.0f,374.0f,188.0f,
    -42.0f,-306.0f,-571.0f,-821.0f,-1037.0f,-1214.0f,-1338.0f,-1422.0f,
    -1479.0f,-1520.0f,-1568.0f,-1628.0f,-1708.0f,-1814.0f,-1931.0f,-2062.0f,
    -2185.0f,-2293.0f,-2375.0f,-2432.0f,-2464.0f,-2476.0f,-2471.0f,-2458.0f,
    -2431.0f,-2397.0f,-2338.0f,-2247.0f,-2110.0f,-1916.0f,-1655.0f,-1330.0f,
    -950.0f,-528.0f,-91.0f,337.0f,730.0f,1059.0f,1310.0f,1467.0f,
    1531.0f,1509.0f,1411.0f,1256.0f,1066.0f,847.0f,629.0f,415.0f,
    217.0f,37.0f,-131.0f,-278.0f,-411.0f,-524.0f,-624.0f,-711.0f,
    -778.0f,-827.0f,-859.0f,-867.0f,-866.0f,-846.0f,-824.0f,-804.0f,
    -788.0f,-789.0f,-808.0f,-855.0f,-926.0f,-1019.0f,-1142.0f,-1282.0f,
    -1441.0f,-1617.0f,-1803.0f,-2007.0f,-2223.0f,-2446.0f,-2670.0f,-2886.0f,
    -3077.0f,-3235.0f,-3330.0f,-3347.0f,-3278.0f,-3107.0f,-2844.0f,-2499.0f,
    -2102.0f,-1674.0f,-1253.0f,-869.0f,-548.0f,-299.0f,-131.0f,-29.0f,
    24.0f,59.0f,94.0f,150.0f,240.0f,368.0f,519.0f,688.0f,
    856.0f,994.0f,1093.0f,1144.0f,1135.0f,1077.0f,968.0f,823.0f,
    646.0f,458.0f,268.0f,82.0f,-93.0f,-255.0f,-395.0f,-523.0f,
    -641.0f,-749.0f,-858.0f,-979.0f,-1114.0f,-1266.0f,-1437.0f,-1610.0f,
    -1779.0f,-1925.0f,-2028.0f,-2073.0f,-2047.0f,-1953.0f,-1795.0f,-1592.0f,
    -1374.0f,-1167.0f,-995.0f,-888.0f,-851.0f,-891.0f,-983.0f,-1112.0f,
    -1239.0f,-1325.0f,-1345.0f,-1266.0f,-1081.0f,-788.0f,-412.0f,21.0f,
    465.0f,881.0f,1223.0f,1460.0f,1576.0f,1556.0f,1423.0f,1201.0f,
    934.0f,660.0f,430.0f,280.0f,234.0f,300.0f,459.0f,685.0f,
    930.0f,1143.0f,1275.0f,1285.0f,1145.0f,866.0f,465.0f,-8.0f,
    -490.0f,-913.0f,-1208.0f,-1322.0f,-1233.0f,-941.0f,-472.0f,96.0f,
    701.0f,1240.0f,1641.0f,1848.0f,1830.0f,1590.0f,1181.0f,678.0f,
    174.0f,-238.0f,-481.0f,-502.0f,-293.0f,120.0f,687.0f,1322.0f,
    1943.0f,2470.0f,2853.0f,3075.0f,3151.0f,3120.0f,3036.0f,2957.0f,
    2929.0f,2977.0f,3082.0f,3206.0f,3299.0f,3295.0f,3153.0f,2863.0f,
    2431.0f,1916.0f,1405.0f,999.0f,799.0f,891.0f,1299.0f,2024.0f,
    2997.0f,4118.0f,5278.0f,6312.0f,7105.0f,7554.0f,7625.0f,7328.0f,
    6724.0f,5925.0f,5063.0f,4280.0f,3700.0f,3391.0f,3411.0f,3737.0f,
    4307.0f,5027.0f,5773.0f,6436.0f,6918.0f,7164.0f,7178.0f,7003.0f,
    6733.0f,6509.0f,6468.0f,6734.0f,7386.0f,8444.0f,9841.0f,11430.0f,
    12991.0f,14273.0f,15014.0f,14983.0f,14047.0f,12167.0f,9434.0f,6071.0f,
    2379.0f,-1263.0f,-4504.0f,-7035.0f,-8657.0f,-9297.0f,-9036.0f,-8060.0f,
    -6653.0f,-5126.0f,-3761.0f,-2782.0f,-2285.0f,-2276.0f,-2655.0f,-3251.0f,
    -3867.0f,-4324.0f,-4512.0f,-4379.0f,-3970.0f,-3372.0f,-2719.0f,-2129.0f,
    -1704.0f,-1489.0f,-1470.0f,-1589.0f,-1747.0f,-1853.0f,-1844.0f,-1693.0f,
    -1423.0f,-1108.0f,-819.0f,-663.0f,-707.0f,-966.0f,-1411.0f,-1953.0f,
    -2478.0f,-2836.0f,-2913.0f,-2625.0f,-1947.0f,-922.0f,362.0f,1760.0f,
    3116.0f,4278.0f,5127.0f,5586.0f,5646.0f,5340.0f,4750.0f,3974.0f,
    3115.0f,2269.0f,1495.0f,822.0f,254.0f,-237.0f,-678.0f,-1090.0f,
    -1487.0f,-1856.0f,-2172.0f,-2406.0f,-2515.0f,-2473.0f,-2289.0f,-1978.0f,
    -1593.0f,-1201.0f,-876.0f,-681.0f,-661.0f,-836.0f,-1184.0f,-1664.0f,
    -2198.0f,-2717.0f,-3148.0f,-3432.0f,-3544.0f,-3495.0f,-3322.0f,-3073.0f,
    -2829.0f,-2648.0f,-2581.0f,-2666.0f,-2885.0f,-3213.0f,-3593.0f,-3957.0f,
    -4233.0f,-4365.0f,-4312.0f,-4064.0f,-3636.0f,-3057.0f,-2378.0f,-1656.0f,
    -945.0f,-289.0f,262.0f,697.0f,1002.0f,1167.0f,1205.0f,1115.0f,
    917.0f,630.0f,272.0f,-130.0f,-548.0f,-946.0f,-1294.0f,-1572.0f,
    -1753.0f,-1837.0f,-1835.0f,-1763.0f,-1642.0f,-1510.0f,-1391.0f,-1303.0f,
    -1259.0f,-1251.0f,-1264.0f,-1281.0f,-1271.0f,-1229.0f,-1139.0f,-1000.0f,
    -835.0f,-669.0f,-530.0f,-446.0f,-440.0f,-517.0f,-678.0f,-905.0f,
    -1181.0f,-1471.0f,-1750.0f,-1999.0f,-2197.0f,-2333.0f,-2411.0f,-2422.0f,
    -2375.0f,-2259.0f,-2090.0f,-1850.0f,-1543.0f,-1169.0f,-737.0f,-260.0f,
    232.0f,707.0f,1122.0f,1444.0f,1639.0f,1688.0f,1586.0f,1347.0f,
    1010.0f,615.0f,212.0f,-153.0f,-440.0f,-635.0f,-733.0f,-759.0f,
    -745.0f,-744.0f,-793.0f,-930.0f,-1170.0f,-1513.0f,-1938.0f,-2401.0f,
    -2860.0f,-3257.0f,-3553.0f,-3720.0f,-3747.0f,-3643.0f,-3430.0f,-3141.0f,
    -2811.0f,-2480.0f,-2170.0f,-1903.0f,-1676.0f,-1497.0f,-1356.0f,-1241.0f,
    -1151.0f,-1083.0f,-1041.0f,-1016.0f,-1017.0f,-1041.0f,-1081.0f,-1127.0f,
    -1165.0f,-1182.0f,-1164.0f,-1110.0f,-1007.0f,-871.0f,-706.0f,-533.0f,
    -361.0f,-211.0f,-89.0f,-4.0f,51.0f,68.0f,63.0f,48.0f,
    24.0f,5.0f,-12.0f,-22.0f,-26.0f,-23.0f,-17.0f,-10.0f,
    -5.0f,2.0f,4.0f,6.0f,6.0f,6.0f,5.0f,0.0f,
    0.0f,
    0
}; t_CKUINT glot_pop_size = 521;


#else  // __DISABLE_RAW__

// begin the abuse of memory
SAMPLE ahh_data[] = { 0.0f };
SAMPLE britestk_data[] = { 0.0f }; 
SAMPLE dope_data[] = { 0.0f };
SAMPLE eee_data[] = { 0.0f };
SAMPLE fwavblnk_data[] = { 0.0f };
SAMPLE halfwave_data[] = { 0.0f };
SAMPLE impuls10_data[] = { 0.0f };
SAMPLE impuls20_data[] = { 0.0f };
SAMPLE impuls40_data[] = { 0.0f };
SAMPLE mand1_data[] = { 0.0f };
SAMPLE mandpluk_data[] = { 0.0f };
SAMPLE marmstk1_data[] = { 0.0f };
SAMPLE ooo_data[] = { 0.0f };
SAMPLE peksblnk_data[] = { 0.0f };
SAMPLE ppksblnk_data[] = { 0.0f };
SAMPLE silence_data[] = { 0.0f };
SAMPLE sineblnk_data[] = { 0.0f };
SAMPLE sinewave_data[] = { 0.0f };
SAMPLE snglpeak_data[] = { 0.0f };
SAMPLE twopeaks_data[] = { 0.0f };
SAMPLE glot_ahh_data[] = { 0.0f };
SAMPLE glot_eee_data[] = { 0.0f };
SAMPLE glot_ooo_data[] = { 0.0f };
SAMPLE glot_pop_data[] = { 0.0f };

t_CKUINT ahh_size = 1;
t_CKUINT britestk_size = 1;
t_CKUINT dope_size = 1;
t_CKUINT eee_size = 1;
t_CKUINT fwavblnk_size = 1;
t_CKUINT halfwave_size = 1;
t_CKUINT impuls10_size = 1;
t_CKUINT impuls20_size = 1;
t_CKUINT impuls40_size = 1;
t_CKUINT mand1_size = 1;
t_CKUINT mandpluk_size = 1;
t_CKUINT marmstk1_size = 1;
t_CKUINT ooo_size = 1;
t_CKUINT peksblnk_size = 1;
t_CKUINT ppksblnk_size = 1;
t_CKUINT silence_size = 1;
t_CKUINT sineblnk_size = 1;
t_CKUINT sinewave_size = 1;
t_CKUINT snglpeak_size = 1;
t_CKUINT twopeaks_size = 1;
t_CKUINT glot_ahh_size = 1;
t_CKUINT glot_eee_size = 1;
t_CKUINT glot_ooo_size = 1;
t_CKUINT glot_pop_size = 1;


#endif
