<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <title>Λήψη και Εγκατάσταση Ελεγκτή Εγκυρότητας CSS</title>
  <link rev="made" href="mailto:www-validator-css@w3.org" />
  <link rev="start" href="./" title="Home Page" />
  <style type="text/css" media="all">
    @import "style/base.css";  
    @import "style/docs.css";
  </style>
  <meta name="revision"
  content="$Id$" />
  <!-- SSI Template Version: $Id$ -->

</head>

<body>
  <div id="banner">
   <h1 id="title"><a href="http://www.w3.org/"><img alt="W3C" width="110" height="61" id="logo" src="./images/w3c.png" /></a>
   <a href="./"><span>Υπηρεσία Ελέγχου Εγκυρότητας CSS</span></a></h1>
   <p id="tagline">
     Έλεγχος Cascading Style Sheets (CSS) και εγγράφων (X)HTML με style sheets
   </p>
</div>

<div class="doc">
<h2>Λήψη και Εγκατάσταση Ελεγκτή Εγκυρότητας CSS</h2>
<h3 id="download">Λήψη του Ελεγκτή Εγκυρότητας  CSS</h3>	

<p>Ο ελεγκτής εγκυρότητας  CSS είναι διαθέσιμο σε τρεις διαφορετικές μορφές. Από το CVS για τους προγραμματιστές που επιθυμούν την τελευταία έκδοση, ως ένα αρχείο jar για τη δημιουργία εφαρμογών και για χρήση από τη γραμμή εντολών  (από το  2009) και ως ένα αρχείο  war για εφαρμογές σε διακομιστές.</p>

<h4 id="source">Λήψη του πηγαίου κώδικα</h4>
<p>Ο <a href="https://github.com/w3c/css-validator">πηγαίος κώδικας του Ελεγκτή Εγκυρότητας  CSS</a> μπορεί να ανακτηθεί με το  CVS.
Ακολουθήστε τις οδηγίες  <a href='http://dev.w3.org/cvsweb/'>οδηγίες</a> για να συνδεθείτε με τον διακομιστή CVS του W3C, και ανακτήστε το δομικό στοιχείο (module) <code>2002/css-validator</code>. Σημειώστε ότι η online υπηρεσία για τον ελεγκτή εγκυρότητας CSS έχει μία σταθερή έκδοση του κώδικα, γενικά λίγο παλιότερος από την έκδοση στο CVS, και τα αποτελέσματα καθώς και η συμπεριφορά τους μπορεί να διαφέρει.</p>


<h4>Λήψη του αρχείου Java (jar)</h4>
<p><a href="http://www.w3.org/QA/Tools/css-validator/css-validator.jar">css-validator.jar</a></p>

<h3>Οδηγός Εγκατάστασης</h3>
<p>Η υπηρεσία Έλεγχος Εγκυρότητας CSS βασίζεται σε ένα  servlet που είναι κωδικοποιημένο με βάση την  cross-platform γλώσσα προγραμματισμού Java, και μπορεί να εγκατασταθεί σε οποιαδήποτε πλατφόρμα servlet. Αν και το επίσημη service από την W3C εκτελείται σε διακομιστή  Jigsaw  
  (ο οποίος αποτελεί και την προτεινόμενη εγκατάσταση), για λόγους ευκολίας θα περιγραφεί η εγκατάσταση για έναν Apache servlet engine, τον Tomcat, και θα δοθούν επίσης και κάποιες γρήγορες οδηγίες για το  Jigsaw και για χρήση από τη γραμμή εντολών.</p>

<h4 id="prereq">Προαπαιτήσεις</h4>

<p>Ο οδηγός υποθέτει ότι έχετε εγκαταστήσει επιτυχώς ήδη στον υπολογιστή σας τα παρακάτω:</p>
<ul class="instructions">
<li>ένα περιβάλλον java που λειτουργεί κανονικά,</li>
<li>το εργαλείο προγραμματισμού <a href="http://ant.apache.org/">Ant</a> της java,</li>
<li>έναν Java servlet container όπως τους <a href="http://www.w3.org/Jigsaw/">Jigsaw</a>,
<a href="http://tomcat.apache.org/">Tomcat</a> ή <a href="http://www.mortbay.org/">Jetty</a>, σε περίπτωση που σκοπεύετε να παρέχετε τον ελεγκτή εγκυρότητας ως μία υπηρεσία web.</li>
</ul>
<p id="prereq-libs">
  Για την εγκατάσταση προαπαιτείται να γνωρίζετε ολόκληρο το μονοπάτι της java βιβλιοθήκης με όνομα <span class="file">servlet.jar</span>.
  Είναι γενικά διαθέσιμη στο φάκελο  <span class="dir">[<span class="const">TOMCAT_DIR</span>]/common/lib/</span>, όπου <span class="dir">[<span class="const">TOMCAT_DIR</span>]</span> το μονοπάτι που είναι εγκατεστημένος ο Tomcat. Μπορεί επίσης να βρεθεί με το όνομα servlet-api.jar. Εάν δεν μπορείτε να το βρείτε, θα το έχει η ιστοσελίδα   <a href="http://java.sun.com/products/servlet/DOWNLOAD.html">java.sun.com</a>.</p>

<h4>Εγκατάσταση του ελεγκτή εγκυρότητας  CSS στον Tomcat</h4>
<ol class="instructions">
<li>Κάντε λήψη του πηγαίου κώδικα  CVS όπως περιγράφθηκε <a href="#source">παραπάνω</a> ;</li>
<li>Επεξεργαστείτε το αρχείο με όνομα <span class="file">[<span class="const">VALIDATOR_DIR</span>]build.xml</span> και αντικαταστήστε την τιμή της ιδιότητας servlet.lib με το πλήρες μονοπάτι του αρχείου <span class="file">servlet.jar</span></li>
<li>
Μπορείτε τώρα να δημιουργήσετε τον πηγαίο κώδικα : από το <span class="const">VALIDATOR_DIR</span> εκτελέστε την εντολή <kbd>ant war</kbd>.
Η εκτέλεση του  ant θα κάνει λήψη ενός πλήθους από αναγκαίες βιβλιοθήκες και θα δημιουργήσει το αρχείο με όνομα <span class="file">css-validator.war</span>.</li>
<li>
Αντιγράψτε ή μεταφέρετε το αρχείο <span class="file">css-validator.war</span> στο φάκελο <span class="dir">[<span class="const">TOMCAT_DIR</span>]/webapps</span>.
<li>Τέλος, κάντε επανεκκίνηση στη μηχανή  Tomcat :<br />
<kbd>"cd <span class="dir">[<span class="const">TOMCAT_DIR</span>]</span>; <span class="dir">./bin/</span><span class="file">shutdown.sh</span>; <span class="dir">./bin/</span><span class="file">startup.sh</span>;"</kbd>
</li>
</ol>

<h4>Εγκατάσταση του ελεγκτή εγκυρότητας  CSS στον Jigsaw</h4>
<ol class="instructions">
<li>Κάντε λήψη του πηγαίου κώδικα  CVS όπως περιγράφθηκε προηγουμένως και αποθηκεύστε τον στο φάκελο <span class="dir">[<span class="const">JIGSAW_DIR</span>]/WWW</span>
και δημιουργήστε τον πηγαίο κώδικα με την εντολή  <kbd>ant jigsaw</kbd> ;</li>
<li>Στη συνέχεια, ρυθμίστε τον ριζικό φάκελο για τον ελεγκτή εγκυρότητας  (στις περισσότερες περιπτώσεις θα λέγεται css-validator) έτσι ώστε να γίνει ένας servlet container. Από την εγκατάσταση του  Jigsaw, ενεργοποιήστε το  Jigsaw Admin utility, μεταβείτε στο  <code>css-validator</code> και τροποποιήστε το από  HTTPFrame σε ServletDirectoryFrame ;</li>
<li>Το επόμενο βήμα θα είναι η φημιουργία ενός πόρου  "validator" ως μία κλάση 'ServletWrapper'. Θα δημιουργηθεί αυτόματα ένα πλαίσιο 'ServletWrapperFrame'. Θα χρειαστεί να παρέχετε το όνομα της κλάσης  servlet, η οποία για τον Ελεγκτή Εγκυρότητας  CSS είναι org.w3c.css.servlet.CssValidator. 
  Σημειώστε ότι μπορεί ήδη να υπάρχει ένα αρχείο με όνομα  “validator” – το οποίο ΠΡΕΠΕΙ να το μετονομάσετε, καθώς ο ελεγκτής εγκυρότητας πρέπει να δώσει αυτό το όνομα για το servlet wrapper ;</li>
<li>Βεβαιωθείτε ότι όλες οι βιβλιοθήκες  .jar μέσα στο φάκελο <span class="dir">[<span class="const">JIGSAW_DIR</span>]/WWW/css-validator/lib</span> έχουν προστεθεί σωστά στη ρύθμιση CLASSPATH του Jigsaw.</li>
<li>Τέλος, κάντε επανεκκίνηση στον Jigsaw και συνδέστε τον διακομιστή σας με τον ελεγκτή εγκυρότητας. Το  URI πρέπει να είναι :<br />
http://localhost:8001/css-validator/validator.html</li>
</ol>

<h3>Χρήση από τη Γραμμή Εντολών</h3>

<p>Οποιοσδήποτε υπολογιστής με εγκατεστημένη  Java μπορεί να εκτελέσει τον ελεγκτή εγκυρότητας από το τερματικό/κονσόλα ως ένα εργαλείο της γραμμής εντολών.
Κάντε λήψη του αρχείου  css-validator.jar  (ή δημιουργήστε το με το  <kbd>ant jar</kbd>) και εκτελέστε το ως εξής :<br />
<kbd>java -jar css-validator.jar http://www.w3.org/</kbd>.
</p>
<p>Σημείωση : για τη σωστή λειτουργία, το αρχείο  css-validator.jar πρέπει να βρίσκεται στην ίδια τοποθεσία με το φάκελο lib/ .</p>
</div>
   <ul class="navbar"  id="menu">
	<li><strong><a href="./" title="Home page for the W3C CSS Validation Service">Αρχική Σελίδα</a></strong> <span class="hideme">|</span></li>
        <li><a href="documentation.html" title="Documentation for the W3C CSS Validation Service">Εγχειρίδια Χρήσης</a> <span class="hideme">|</span></li>
        <li><a href="DOWNLOAD.html" title="Download the CSS validator">Λήψη Αρχείων</a> <span class="hideme">|</span></li>
        <li><a href="Email.html" title="How to provide feedback on this service">Η γνώμη σας </a> <span class="hideme">|</span></li>
        <li><a href="thanks.html" title="Credits and Acknowlegments">Ευχαριστίες</a><span class="hideme">|</span></li>


</ul>
 
      <ul id="lang_choice">
     
     <li><a href="DOWNLOAD.html.de"
         lang="de"
         xml:lang="de"
         hreflang="de"
         rel="alternate">Deutsch</a>
     </li>
     
     <li><a href="DOWNLOAD.html.en"
         lang="en"
         xml:lang="en"
         hreflang="en"
         rel="alternate">English</a>
     </li>
     
     <li><a href="DOWNLOAD.html.es"
         lang="es"
         xml:lang="es"
         hreflang="es"
         rel="alternate">Español</a>
     </li>
     
     <li><a href="DOWNLOAD.html.fr"
         lang="fr"
         xml:lang="fr"
         hreflang="fr"
         rel="alternate">Français</a>
     </li>
     
     <li><a href="DOWNLOAD.html.ko"
         lang="ko"
         xml:lang="ko"
         hreflang="ko"
         rel="alternate">한국어</a>
     </li>
     
     <li><a href="DOWNLOAD.html.it"
         lang="it"
         xml:lang="it"
         hreflang="it"
         rel="alternate">Italiano</a>
     </li>
     
     <li><a href="DOWNLOAD.html.nl"
         lang="nl"
         xml:lang="nl"
         hreflang="nl"
         rel="alternate">Nederlands</a>
     </li>
     
     <li><a href="DOWNLOAD.html.ja"
         lang="ja"
         xml:lang="ja"
         hreflang="ja"
         rel="alternate">日本語</a>
     </li>
     
     <li><a href="DOWNLOAD.html.pl-PL"
         lang="pl-PL"
         xml:lang="pl-PL"
         hreflang="pl-PL"
         rel="alternate">Polski</a>
     </li>
     
     <li><a href="DOWNLOAD.html.pt-BR"
         lang="pt-BR"
         xml:lang="pt-BR"
         hreflang="pt-BR"
         rel="alternate">Português</a>
     </li>
     
     <li><a href="DOWNLOAD.html.ru"
         lang="ru"
         xml:lang="ru"
         hreflang="ru"
         rel="alternate">Русский</a>
     </li>
     
     <li><a href="DOWNLOAD.html.sv"
         lang="sv"
         xml:lang="sv"
         hreflang="sv"
         rel="alternate">Svenska</a>
     </li>
     
     <li><a href="DOWNLOAD.html.zh-cn"
         lang="zh-cn"
         xml:lang="zh-cn"
         hreflang="zh-cn"
         rel="alternate">简体中文</a>
     </li>
</ul>



   <div id="footer">
   <p id="activity_logos">

      <a href="http://www.w3.org/QA/" title="W3C's Quality Assurance Activity, bringing you free Web quality tools and more"><img src="http://www.w3.org/QA/2002/12/qa-small.png" alt="QA" /></a><a href="http://www.w3.org/Style/CSS/learning" title="Learn more about Cascading Style Sheets"><img src="images/woolly-icon" alt="CSS" /></a>
   </p>

   <p id="support_logo">
   <a href="http://www.w3.org/QA/Tools/Donate">
   <img src="http://www.w3.org/QA/Tools/I_heart_validator" alt="I heart Validator logo" title=" Validators Donation Program" />
   </a>
   </p>

    <p class="copyright">
      <a rel="Copyright" href="http://www.w3.org/Consortium/Legal/ipr-notice#Copyright">Πνευματικά Δικαιώματα</a> &copy; 1994-2009
      <a href="http://www.w3.org/"><acronym title="World Wide Web Consortium">W3C</acronym></a>&reg;

      (<a href="http://www.csail.mit.edu/"><acronym title="Massachusetts Institute of Technology">MIT</acronym></a>,
      <a href="http://www.ercim.org/"><acronym title="European Research Consortium for Informatics and Mathematics">ERCIM</acronym></a>,
      <a href="http://www.keio.ac.jp/">Keio</a>),
      Με επιφύλαξη παντός δικαιώματος.
      Εφαρμόζονται οι κανόνες της W3C για <a href="http://www.w3.org/Consortium/Legal/ipr-notice#Legal_Disclaimer">ευθύνη</a>,
      <a href="http://www.w3.org/Consortium/Legal/ipr-notice#W3C_Trademarks">καταχωρημένο εμπορικό σήμα</a>,
      <a rel="Copyright" href="http://www.w3.org/Consortium/Legal/copyright-documents">χρήση εγγράφου</a>

      και <a rel="Copyright" href="http://www.w3.org/Consortium/Legal/copyright-software">άδεια χρήσης λογισμικού</a>. Η αλληλεπίδραση σας με αυτόν τον ιστότοπο γίνεται σύμφωνα με τις δηλώσεις μας απορρήτου για <a href="http://www.w3.org/Consortium/Legal/privacy-statement#Public">δημόσια χρήση </a> και για τα 
      <a href="http://www.w3.org/Consortium/Legal/privacy-statement#Members">Μέλη</a>.    </p>
</div>
</body>

</html>




