
# The Book of the Runtime

Welcome to the Book of the Runtime (BOTR) for the .NET Runtime.   This contains
a collection of articles about the non-trivial internals of the .NET Runtime.   Its
intended audience are people actually modifying the code or simply wishing to have a
deep understanding of the runtime.

Below is a table of contents.

- [Book of the Runtime FAQ](botr-faq.md)
- [Introduction to the Common Language Runtime](intro-to-clr.md)
- [Garbage Collection Design](garbage-collection.md)
- [Threading](threading.md)
- [RyuJIT Overview](../jit/ryujit-overview.md)
  - [Porting RyuJIT to other platforms](../jit/porting-ryujit.md)
- [Type System](type-system.md)
- [Type Loader](type-loader.md)
- [Method Descriptor](method-descriptor.md)
- [Virtual Stub Dispatch](virtual-stub-dispatch.md)
- [Stack Walking](stackwalking.md)
- [`System.Private.CoreLib` and calling into the runtime](corelib.md)
- [Data Access Component (DAC) Notes](dac-notes.md)
- [Profiling](profiling.md)
- [Implementing Profilability](profilability.md)
- [What Every Dev needs to Know About Exceptions in the Runtime](exceptions.md)
- [ReadyToRun Overview](readytorun-overview.md)
- [CLR ABI](clr-abi.md)
- [Cross-platform Minidumps](xplat-minidump-generation.md)
- [Mixed Mode Assemblies](mixed-mode.md)
- [Guide For Porting](guide-for-porting.md)
- [Vectors and Intrinsics](vectors-and-intrinsics.md)


It may be possible that this table is not complete.  You can get a complete list
by looking at the directory where all the chapters are stored:

* [All Book of the Runtime (BOTR) chapters on GitHub](../botr)
