# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appconfiguration import AppConfigurationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppConfigurationManagementConfigurationStoresOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppConfigurationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_get(self, resource_group):
        response = self.client.configuration_stores.get(
            resource_group_name=resource_group.name,
            config_store_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_begin_create(self, resource_group):
        response = self.client.configuration_stores.begin_create(
            resource_group_name=resource_group.name,
            config_store_name="str",
            config_store_creation_parameters={
                "location": "str",
                "sku": {"name": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "azureFrontDoor": {"resourceId": "str"},
                    "createMode": "str",
                    "creationDate": "2020-02-20 00:00:00",
                    "dataPlaneProxy": {"authenticationMode": "str", "privateLinkDelegation": "str"},
                    "defaultKeyValueRevisionRetentionPeriodInSeconds": 0,
                    "disableLocalAuth": bool,
                    "enablePurgeProtection": bool,
                    "encryption": {"keyVaultProperties": {"identityClientId": "str", "keyIdentifier": "str"}},
                    "endpoint": "str",
                    "managedOnBehalfOfConfiguration": {"moboBrokerResources": [{"id": "str"}]},
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "softDeleteRetentionInDays": 0,
                    "telemetry": {"resourceId": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_begin_update(self, resource_group):
        response = self.client.configuration_stores.begin_update(
            resource_group_name=resource_group.name,
            config_store_name="str",
            config_store_update_parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "azureFrontDoor": {"resourceId": "str"},
                    "dataPlaneProxy": {"authenticationMode": "str", "privateLinkDelegation": "str"},
                    "defaultKeyValueRevisionRetentionPeriodInSeconds": 0,
                    "disableLocalAuth": bool,
                    "enablePurgeProtection": bool,
                    "encryption": {"keyVaultProperties": {"identityClientId": "str", "keyIdentifier": "str"}},
                    "publicNetworkAccess": "str",
                    "telemetry": {"resourceId": "str"},
                },
                "sku": {"name": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_begin_delete(self, resource_group):
        response = self.client.configuration_stores.begin_delete(
            resource_group_name=resource_group.name,
            config_store_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_list_by_resource_group(self, resource_group):
        response = self.client.configuration_stores.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_list(self, resource_group):
        response = self.client.configuration_stores.list()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_list_keys(self, resource_group):
        response = self.client.configuration_stores.list_keys(
            resource_group_name=resource_group.name,
            config_store_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_regenerate_key(self, resource_group):
        response = self.client.configuration_stores.regenerate_key(
            resource_group_name=resource_group.name,
            config_store_name="str",
            regenerate_key_parameters={"id": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_get_deleted(self, resource_group):
        response = self.client.configuration_stores.get_deleted(
            location="str",
            config_store_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_begin_purge_deleted(self, resource_group):
        response = self.client.configuration_stores.begin_purge_deleted(
            location="str",
            config_store_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_stores_list_deleted(self, resource_group):
        response = self.client.configuration_stores.list_deleted()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
