% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.ivreg.R
\name{model_performance.ivreg}
\alias{model_performance.ivreg}
\title{Performance of instrumental variable regression models}
\usage{
\method{model_performance}{ivreg}(model, metrics = "all", verbose = TRUE, ...)
}
\arguments{
\item{model}{A model.}

\item{metrics}{Can be \code{"all"}, \code{"common"} or a character vector of
metrics to be computed (some of \code{c("AIC", "AICc", "BIC", "R2", "RMSE", "SIGMA", "Sargan", "Wu_Hausman", "weak_instruments")}). \code{"common"} will
compute AIC, BIC, R2 and RMSE.}

\item{verbose}{Toggle off warnings.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Performance of instrumental variable regression models
}
\details{
\code{model_performance()} correctly detects transformed response and
returns the "corrected" AIC and BIC value on the original scale. To get back
to the original scale, the likelihood of the model is multiplied by the
Jacobian/derivative of the transformation.
}
