% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R, R/deactivate.R
\name{activate}
\alias{activate}
\alias{deactivate}
\title{Activate or deactivate a project}
\usage{
activate(project = NULL, profile = NULL)

deactivate(project = NULL, clean = FALSE)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{profile}{The profile to be activated. See
\code{vignette("profiles", package = "renv")} for more information.
When \code{NULL} (the default), the profile is not changed. Use
\code{profile = "default"} to revert to the default \code{renv} profile.}

\item{clean}{If \code{TRUE}, will also remove the \verb{renv/} directory and the
lockfile.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
\code{activate()} enables renv for a project in both the current session and
in all future sessions. You should not generally need to call \code{activate()}
yourself as it's called automatically by \code{\link[=init]{init()}}, which is the best
way to start using renv in a new project.

\code{activate()} first calls \code{\link[=scaffold]{scaffold()}} to set up the project
infrastructure. Most importantly, this creates a project library and adds a
an auto-loader to \code{.Rprofile} to ensure that the project library is
automatically used for all future instances of the project. It then restarts
the session to use that auto-loader.

\code{deactivate()} removes the infrastructure added by \code{activate()}, and
restarts the session. By default it will remove the auto-loader from the
\code{.Rprofile}; use \code{clean = TRUE} to also delete the lockfile and the project
library.
}
\section{Temporary deactivation}{
If you need to temporarily disable autoload activation you can set
the \code{RENV_CONFIG_AUTOLOADER_ENABLED} envvar, e.g.
\code{Sys.setenv(RENV_CONFIG_AUTOLOADER_ENABLED = "false")}.
}

\examples{
\dontrun{

# activate the current project
renv::activate()

# activate a separate project
renv::activate(project = "~/projects/analysis")

# deactivate the currently-activated project
renv::deactivate()

}
}
