% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/clustering.R
\name{FindNeighbors}
\alias{FindNeighbors}
\alias{FindNeighbors.default}
\alias{FindNeighbors.Assay}
\alias{FindNeighbors.dist}
\alias{FindNeighbors.Seurat}
\title{(Shared) Nearest-neighbor graph construction}
\usage{
FindNeighbors(object, ...)

\method{FindNeighbors}{default}(
  object,
  query = NULL,
  distance.matrix = FALSE,
  k.param = 20,
  return.neighbor = FALSE,
  compute.SNN = !return.neighbor,
  prune.SNN = 1/15,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  l2.norm = FALSE,
  cache.index = FALSE,
  index = NULL,
  ...
)

\method{FindNeighbors}{Assay}(
  object,
  features = NULL,
  k.param = 20,
  return.neighbor = FALSE,
  compute.SNN = !return.neighbor,
  prune.SNN = 1/15,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  l2.norm = FALSE,
  cache.index = FALSE,
  ...
)

\method{FindNeighbors}{dist}(
  object,
  k.param = 20,
  return.neighbor = FALSE,
  compute.SNN = !return.neighbor,
  prune.SNN = 1/15,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  l2.norm = FALSE,
  cache.index = FALSE,
  ...
)

\method{FindNeighbors}{Seurat}(
  object,
  reduction = "pca",
  dims = 1:10,
  assay = NULL,
  features = NULL,
  k.param = 20,
  return.neighbor = FALSE,
  compute.SNN = !return.neighbor,
  prune.SNN = 1/15,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  do.plot = FALSE,
  graph.name = NULL,
  l2.norm = FALSE,
  cache.index = FALSE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{query}{Matrix of data to query against object. If missing, defaults to
object.}

\item{distance.matrix}{Boolean value of whether the provided matrix is a
distance matrix; note, for objects of class \code{dist}, this parameter will
be set automatically}

\item{k.param}{Defines k for the k-nearest neighbor algorithm}

\item{return.neighbor}{Return result as \code{\link{Neighbor}} object. Not
used with distance matrix input.}

\item{compute.SNN}{also compute the shared nearest neighbor graph}

\item{prune.SNN}{Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the stringency of pruning (0 --- no pruning, 1 ---
prune everything).}

\item{nn.method}{Method for nearest neighbor finding. Options include: rann,
annoy}

\item{n.trees}{More trees gives higher precision when using annoy approximate
nearest neighbor search}

\item{annoy.metric}{Distance metric for annoy. Options include: euclidean,
cosine, manhattan, and hamming}

\item{nn.eps}{Error bound when performing nearest neighbor seach using RANN;
default of 0.0 implies exact nearest neighbor search}

\item{verbose}{Whether or not to print output to the console}

\item{l2.norm}{Take L2Norm of the data}

\item{cache.index}{Include cached index in returned Neighbor object
(only relevant if return.neighbor = TRUE)}

\item{index}{Precomputed index. Useful if querying new data against existing
index to avoid recomputing.}

\item{features}{Features to use as input for building the (S)NN; used only when
\code{dims} is \code{NULL}}

\item{reduction}{Reduction to use as input for building the (S)NN}

\item{dims}{Dimensions of reduction to use as input}

\item{assay}{Assay to use in construction of (S)NN; used only when \code{dims}
is \code{NULL}}

\item{do.plot}{Plot SNN graph on tSNE coordinates}

\item{graph.name}{Optional naming parameter for stored (S)NN graph
(or Neighbor object, if return.neighbor = TRUE). Default is assay.name_(s)nn.
To store both the neighbor graph and the shared nearest neighbor (SNN) graph,
you must supply a vector containing two names to the \code{graph.name}
parameter. The first element in the vector will be used to store the nearest
neighbor (NN) graph, and the second element used to store the SNN graph. If
only one name is supplied, only the NN graph is stored.}
}
\value{
This function can either return a \code{\link{Neighbor}} object
with the KNN information or a list of \code{\link{Graph}} objects with
the KNN and SNN depending on the settings of \code{return.neighbor} and
\code{compute.SNN}. When running on a \code{\link{Seurat}} object, this
returns the \code{\link{Seurat}} object with the Graphs or Neighbor objects
stored in their respective slots. Names of the Graph or Neighbor object can
be found with \code{\link{Graphs}} or \code{\link{Neighbors}}.
}
\description{
Computes the \code{k.param} nearest neighbors for a given dataset. Can also
optionally (via \code{compute.SNN}), construct a shared nearest neighbor
graph by calculating the neighborhood overlap (Jaccard index) between every
cell and its \code{k.param} nearest neighbors.
}
\examples{
data("pbmc_small")
pbmc_small
# Compute an SNN on the gene expression level
pbmc_small <- FindNeighbors(pbmc_small, features = VariableFeatures(object = pbmc_small))

# More commonly, we build the SNN on a dimensionally reduced form of the data
# such as the first 10 principle components.

pbmc_small <- FindNeighbors(pbmc_small, reduction = "pca", dims = 1:10)

}
\concept{clustering}
