% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-pattern.R
\name{starts_with}
\alias{starts_with}
\alias{ends_with}
\alias{contains}
\alias{matches}
\alias{num_range}
\title{Select variables that match a pattern}
\usage{
starts_with(match, ignore.case = TRUE, vars = NULL)

ends_with(match, ignore.case = TRUE, vars = NULL)

contains(match, ignore.case = TRUE, vars = NULL)

matches(match, ignore.case = TRUE, perl = FALSE, vars = NULL)

num_range(prefix, range, suffix = "", width = NULL, vars = NULL)
}
\arguments{
\item{match}{A character vector. If length > 1, the union of the
matches is taken.

For \code{starts_with()}, \code{ends_with()}, and \code{contains()} this is an exact
match. For \code{matches()} this is a regular expression, and can be a
stringr pattern.}

\item{ignore.case}{If \code{TRUE}, the default, ignores case when matching
names.}

\item{vars}{A character vector of variable names. If not supplied,
the variables are taken from the current selection context (as
established by functions like \code{select()} or \code{pivot_longer()}).}

\item{perl}{Should Perl-compatible regexps be used?}

\item{prefix, suffix}{A prefix/suffix added before/after the numeric range.}

\item{range}{A sequence of integers, like \code{1:5}.}

\item{width}{Optionally, the "width" of the numeric range. For example,
a range of 2 gives "01", a range of three "001", etc.}
}
\description{
These \link[=language]{selection helpers} match variables according
to a given pattern.
\itemize{
\item \code{\link[=starts_with]{starts_with()}}: Starts with an exact prefix.
\item \code{\link[=ends_with]{ends_with()}}: Ends with an exact suffix.
\item \code{\link[=contains]{contains()}}: Contains a literal string.
\item \code{\link[=matches]{matches()}}: Matches a regular expression.
\item \code{\link[=num_range]{num_range()}}: Matches a numerical range like x01, x02, x03.
}
}
\section{Examples}{


Selection helpers can be used in functions like \code{dplyr::select()}
or \code{tidyr::pivot_longer()}. Let's first attach the tidyverse:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidyverse)

# For better printing
iris <- as_tibble(iris)
}\if{html}{\out{</div>}}

\code{starts_with()} selects all variables matching a prefix and
\code{ends_with()} matches a suffix:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{iris \%>\% select(starts_with("Sepal"))
#> # A tibble: 150 x 2
#>   Sepal.Length Sepal.Width
#>          <dbl>       <dbl>
#> 1          5.1         3.5
#> 2          4.9         3  
#> 3          4.7         3.2
#> 4          4.6         3.1
#> # ... with 146 more rows

iris \%>\% select(ends_with("Width"))
#> # A tibble: 150 x 2
#>   Sepal.Width Petal.Width
#>         <dbl>       <dbl>
#> 1         3.5         0.2
#> 2         3           0.2
#> 3         3.2         0.2
#> 4         3.1         0.2
#> # ... with 146 more rows
}\if{html}{\out{</div>}}

You can supply multiple prefixes or suffixes. Note how the order of
variables depends on the order of the suffixes and prefixes:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{iris \%>\% select(starts_with(c("Petal", "Sepal")))
#> # A tibble: 150 x 4
#>   Petal.Length Petal.Width Sepal.Length Sepal.Width
#>          <dbl>       <dbl>        <dbl>       <dbl>
#> 1          1.4         0.2          5.1         3.5
#> 2          1.4         0.2          4.9         3  
#> 3          1.3         0.2          4.7         3.2
#> 4          1.5         0.2          4.6         3.1
#> # ... with 146 more rows

iris \%>\% select(ends_with(c("Width", "Length")))
#> # A tibble: 150 x 4
#>   Sepal.Width Petal.Width Sepal.Length Petal.Length
#>         <dbl>       <dbl>        <dbl>        <dbl>
#> 1         3.5         0.2          5.1          1.4
#> 2         3           0.2          4.9          1.4
#> 3         3.2         0.2          4.7          1.3
#> 4         3.1         0.2          4.6          1.5
#> # ... with 146 more rows
}\if{html}{\out{</div>}}

\code{contains()} selects columns whose names contain a word:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{iris \%>\% select(contains("al"))
#> # A tibble: 150 x 4
#>   Sepal.Length Sepal.Width Petal.Length Petal.Width
#>          <dbl>       <dbl>        <dbl>       <dbl>
#> 1          5.1         3.5          1.4         0.2
#> 2          4.9         3            1.4         0.2
#> 3          4.7         3.2          1.3         0.2
#> 4          4.6         3.1          1.5         0.2
#> # ... with 146 more rows
}\if{html}{\out{</div>}}

\code{starts_with()}, \code{ends_with()}, and \code{contains()} do not use regular expressions. To select with a
regexp use \code{matches()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# [pt] is matched literally:
iris \%>\% select(contains("[pt]al"))
#> # A tibble: 150 x 0

# [pt] is interpreted as a regular expression
iris \%>\% select(matches("[pt]al"))
#> # A tibble: 150 x 4
#>   Sepal.Length Sepal.Width Petal.Length Petal.Width
#>          <dbl>       <dbl>        <dbl>       <dbl>
#> 1          5.1         3.5          1.4         0.2
#> 2          4.9         3            1.4         0.2
#> 3          4.7         3.2          1.3         0.2
#> 4          4.6         3.1          1.5         0.2
#> # ... with 146 more rows
}\if{html}{\out{</div>}}

\code{starts_with()} selects all variables starting with a prefix. To
select a range, use \code{num_range()}. Compare:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{billboard \%>\% select(starts_with("wk"))
#> # A tibble: 317 x 76
#>     wk1   wk2   wk3   wk4   wk5   wk6   wk7   wk8   wk9  wk10  wk11  wk12  wk13
#>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1    87    82    72    77    87    94    99    NA    NA    NA    NA    NA    NA
#> 2    91    87    92    NA    NA    NA    NA    NA    NA    NA    NA    NA    NA
#> 3    81    70    68    67    66    57    54    53    51    51    51    51    47
#> 4    76    76    72    69    67    65    55    59    62    61    61    59    61
#> # ... with 313 more rows, and 63 more variables: wk14 <dbl>, wk15 <dbl>,
#> #   wk16 <dbl>, wk17 <dbl>, wk18 <dbl>, wk19 <dbl>, wk20 <dbl>, wk21 <dbl>, ...

billboard \%>\% select(num_range("wk", 10:15))
#> # A tibble: 317 x 6
#>    wk10  wk11  wk12  wk13  wk14  wk15
#>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1    NA    NA    NA    NA    NA    NA
#> 2    NA    NA    NA    NA    NA    NA
#> 3    51    51    51    47    44    38
#> 4    61    61    59    61    66    72
#> # ... with 313 more rows
}\if{html}{\out{</div>}}
}

\seealso{
The \link[=language]{selection language} page, which includes links to other selection helpers.
}
