#![forbid(unsafe_code)]
//FIXME: Remove once https://github.com/rust-lang/rust-clippy/issues/16394 is resolved
#![allow(renamed_and_removed_lints)]
#![warn(clippy::assigning_clones)]
#![warn(clippy::bool_to_int_with_if)]
#![warn(clippy::borrow_as_ptr)]
#![warn(clippy::case_sensitive_file_extension_comparisons)]
//FIXME: Enable #![warn(clippy::cast_lossless)]
//FIXME: Enable #![warn(clippy::cast_possible_truncation)]
#![warn(clippy::cast_possible_wrap)]
//FIXME: Enable #![warn(clippy::cast_precision_loss)]
#![warn(clippy::cast_ptr_alignment)]
//FIXME: Enable #![warn(clippy::cast_sign_loss)]
#![warn(clippy::checked_conversions)]
#![warn(clippy::cloned_instead_of_copied)]
#![warn(clippy::comparison_chain)]
#![warn(clippy::copy_iterator)]
#![warn(clippy::default_trait_access)]
#![warn(clippy::doc_comment_double_space_linebreaks)]
#![warn(clippy::doc_link_with_quotes)]
//FIXME: Enable #![warn(clippy::doc_markdown)]
#![warn(clippy::elidable_lifetime_names)]
#![warn(clippy::empty_enum)]
//FIXME: Enable #![warn(clippy::enum_glob_use)]
#![warn(clippy::expl_impl_clone_on_copy)]
//FIXME: Enable #![warn(clippy::explicit_deref_methods)]
#![warn(clippy::explicit_into_iter_loop)]
//FIXME: Enable #![warn(clippy::explicit_iter_loop)]
#![warn(clippy::filter_map_next)]
#![warn(clippy::flat_map_option)]
//FIXME: Enable #![warn(clippy::float_cmp)]
#![warn(clippy::fn_params_excessive_bools)]
#![warn(clippy::format_collect)]
//FIXME: Enable #![warn(clippy::format_push_string)]
#![warn(clippy::from_iter_instead_of_collect)]
#![warn(clippy::if_not_else)]
#![warn(clippy::ignore_without_reason)]
//FIXME: Enable #![warn(clippy::ignored_unit_patterns)]
#![warn(clippy::implicit_clone)]
#![warn(clippy::implicit_hasher)]
//FIXME: Enable #![warn(clippy::inconsistent_struct_constructor)]
#![warn(clippy::index_refutable_slice)]
#![warn(clippy::inefficient_to_string)]
#![warn(clippy::inline_always)]
#![warn(clippy::into_iter_without_iter)]
#![warn(clippy::invalid_upcast_comparisons)]
#![warn(clippy::ip_constant)]
//FIXME: Enable #![warn(clippy::items_after_statements)]
#![warn(clippy::iter_filter_is_ok)]
#![warn(clippy::iter_filter_is_some)]
#![warn(clippy::iter_not_returning_iterator)]
#![warn(clippy::iter_without_into_iter)]
#![warn(clippy::large_digit_groups)]
#![warn(clippy::large_futures)]
#![warn(clippy::large_stack_arrays)]
#![warn(clippy::large_types_passed_by_value)]
#![warn(clippy::linkedlist)]
#![warn(clippy::macro_use_imports)]
//FIXME: Enable #![warn(clippy::manual_assert)]
#![warn(clippy::manual_instant_elapsed)]
#![warn(clippy::manual_is_power_of_two)]
#![warn(clippy::manual_is_variant_and)]
//FIXME: Enable #![warn(clippy::manual_let_else)]
#![warn(clippy::manual_midpoint)]
//FIXME: Enable #![warn(clippy::manual_string_new)]
#![warn(clippy::many_single_char_names)]
#![warn(clippy::map_unwrap_or)]
#![warn(clippy::match_bool)]
#![warn(clippy::match_same_arms)]
#![warn(clippy::match_wild_err_arm)]
//FIXME: Enable #![warn(clippy::match_wildcard_for_single_variants)]
#![warn(clippy::maybe_infinite_iter)]
#![warn(clippy::mismatching_type_param_order)]
//FIXME: Enable #![warn(clippy::missing_errors_doc)]
#![warn(clippy::missing_fields_in_debug)]
#![warn(clippy::missing_panics_doc)]
#![warn(clippy::must_use_candidate)]
#![warn(clippy::mut_mut)]
#![warn(clippy::naive_bytecount)]
#![warn(clippy::needless_bitwise_bool)]
//FIXME: Enable #![warn(clippy::needless_continue)]
#![warn(clippy::needless_for_each)]
//FIXME: Enable #![warn(clippy::needless_pass_by_value)]
//FIXME: Enable #![warn(clippy::needless_raw_string_hashes)]
#![warn(clippy::no_effect_underscore_binding)]
#![warn(clippy::no_mangle_with_rust_abi)]
#![warn(clippy::non_std_lazy_statics)]
#![warn(clippy::option_as_ref_cloned)]
#![warn(clippy::option_option)]
#![warn(clippy::ptr_as_ptr)]
#![warn(clippy::ptr_cast_constness)]
#![warn(clippy::pub_underscore_fields)]
#![warn(clippy::range_minus_one)]
#![warn(clippy::range_plus_one)]
#![warn(clippy::redundant_closure_for_method_calls)]
#![warn(clippy::redundant_else)]
#![warn(clippy::ref_as_ptr)]
#![warn(clippy::ref_binding_to_reference)]
#![warn(clippy::ref_option)]
#![warn(clippy::ref_option_ref)]
#![warn(clippy::return_self_not_must_use)]
#![warn(clippy::same_functions_in_if_condition)]
#![warn(clippy::semicolon_if_nothing_returned)]
#![warn(clippy::should_panic_without_expect)]
#![warn(clippy::similar_names)]
#![warn(clippy::single_char_pattern)]
//FIXME: Enable #![warn(clippy::single_match_else)]
#![warn(clippy::stable_sort_primitive)]
#![warn(clippy::str_split_at_newline)]
#![warn(clippy::string_add_assign)]
//FIXME: Enable #![warn(clippy::struct_excessive_bools)]
#![warn(clippy::struct_field_names)]
#![warn(clippy::too_many_lines)]
#![warn(clippy::transmute_ptr_to_ptr)]
#![warn(clippy::trivially_copy_pass_by_ref)]
//FIXME: Enable #![warn(clippy::unchecked_duration_subtraction)]
#![warn(clippy::unicode_not_nfc)]
#![warn(clippy::unnecessary_box_returns)]
//FIXME: Enable #![warn(clippy::unnecessary_debug_formatting)]
#![warn(clippy::unnecessary_join)]
//FIXME: Enable #![warn(clippy::unnecessary_literal_bound)]
#![warn(clippy::unnecessary_semicolon)]
//FIXME: Enable #![warn(clippy::unnecessary_wraps)]
//FIXME: Enable #![warn(clippy::unnested_or_patterns)]
//FIXME: Enable #![warn(clippy::unreadable_literal)]
#![warn(clippy::unsafe_derive_deserialize)]
//FIXME: Enable #![warn(clippy::unused_async)]
//FIXME: Enable #![warn(clippy::unused_self)]
#![warn(clippy::used_underscore_binding)]
#![warn(clippy::used_underscore_items)]
#![warn(clippy::verbose_bit_mask)]
#![warn(clippy::wildcard_imports)]
#![warn(clippy::zero_sized_map_values)]

mod ctl;
mod daemon;
mod force_sync;
mod metrics;

pub use ctl::main as ctl_main;
pub use daemon::main as daemon_main;
pub use metrics::exporter::main as metrics_exporter_main;

#[cfg(test)]
mod test {
    use std::sync::atomic::{AtomicU16, Ordering};

    pub fn alloc_port() -> u16 {
        static PORT: AtomicU16 = AtomicU16::new(5000);
        PORT.fetch_add(1, Ordering::Relaxed)
    }
}
