# GNU Shepherd --- Test restarting services.
# Copyright © 2013-2014, 2016, 2023, 2025 Ludovic Courtès <ludo@gnu.org>
# Copyright © 2018 Carlo Zancanaro <carlo@zancanaro.id.au>
#
# This file is part of the GNU Shepherd.
#
# The GNU Shepherd is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# The GNU Shepherd is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the GNU Shepherd.  If not, see <https://www.gnu.org/licenses/>.

shepherd --version
herd --version

socket="t-socket-$$"
conf="t-conf-$$"
log="t-log-$$"
pid="t-pid-$$"

herd="herd -s $socket"

trap "cat $log || true ;
  rm -f $socket $conf $log;
  test -f $pid && kill \`cat $pid\` || true ; rm -f $pid" EXIT

cat > "$conf"<<EOF
(register-services
 (list (service
	 '(test1)
	 #:start (lambda () #t)
	 #:stop  (const #f))
       (service
	 '(test2)
	 #:requirement '(test1)
	 #:start (lambda* (#:optional (value #t)) value)
	 #:stop  (const #f))
       (service
	 '(test3)
	 #:requirement '(test2)
	 #:start (lambda () #t)
	 #:stop  (const #f))))
EOF

rm -f "$pid"
shepherd -I -s "$socket" -c "$conf" -l "$log" --pid="$pid" &

while ! test -f "$pid" ; do sleep 0.3 ; done

# Start some test services, and make sure they behave how we expect
$herd start test1
$herd start test2
$herd status test1 | grep running
$herd status test2 | grep running

# Restart test1 and make sure that both services are still running (ie. that
# test2 hasn't been stopped)
$herd restart test1
$herd status test1 | grep running
$herd status test2 | grep running

# Now let's test with a transitive dependency
$herd start test3
$herd status test3 | grep running

# After restarting test1 we want test3 to still be running
$herd restart test1
$herd status test1 | grep running
$herd status test2 | grep running
$herd status test3 | grep running

# Passing too many arguments to 'start'.
$herd restart test1 a b c d && false

# Restarting with one argument: the argument must be passed to 'test2' but not
# to its dependent 'test3'.
$herd start test3
$herd restart test2 MAGIC	# restart 'test2' and 'test3'
$herd status test2 | grep MAGIC
$herd status test3 | grep running
