/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;

public class OpenBTree {
    private BTree init_conglomerate;
    private TransactionManager init_xact_manager;
    private Transaction init_rawtran;
    private int init_openmode;
    protected int init_lock_level;
    private DynamicCompiledOpenConglomInfo init_dynamic_info;
    private boolean init_hold;
    private BTreeLockingPolicy init_btree_locking_policy;
    protected ContainerHandle container;
    protected long err_containerid;
    protected TransactionManager init_open_user_scans = null;
    protected LogicalUndo btree_undo = null;
    protected OpenConglomerateScratchSpace runtime_mem;

    public final TransactionManager getXactMgr() {
        return this.init_xact_manager;
    }

    public final Transaction getRawTran() {
        return this.init_rawtran;
    }

    public final int getLockLevel() {
        return this.init_lock_level;
    }

    public final ContainerHandle getContainer() {
        return this.container;
    }

    public final int getOpenMode() {
        return this.init_openmode;
    }

    public final BTree getConglomerate() {
        return this.init_conglomerate;
    }

    public final boolean getHold() {
        return this.init_hold;
    }

    public final BTreeLockingPolicy getLockingPolicy() {
        return this.init_btree_locking_policy;
    }

    public final void setLockingPolicy(BTreeLockingPolicy bTreeLockingPolicy) {
        this.init_btree_locking_policy = bTreeLockingPolicy;
    }

    public final boolean isClosed() {
        return this.container == null;
    }

    public final OpenConglomerateScratchSpace getRuntimeMem() {
        return this.runtime_mem;
    }

    public long getEstimatedRowCount() throws StandardException {
        long l;
        if (this.container == null) {
            this.reopen();
        }
        return (l = this.container.getEstimatedRowCount(0)) == 0L ? 1L : l;
    }

    public void setEstimatedRowCount(long l) throws StandardException {
        if (this.container == null) {
            this.reopen();
        }
        this.container.setEstimatedRowCount(l, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency() throws StandardException {
        ControlRow controlRow = null;
        try {
            if (this.container == null) {
                throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
            }
            controlRow = ControlRow.Get(this, 1L);
            int n = controlRow.checkConsistency(this, null, true);
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    public boolean isTableLocked() {
        return this.init_lock_level == 7;
    }

    public void init(TransactionManager transactionManager, TransactionManager transactionManager2, ContainerHandle containerHandle, Transaction transaction, boolean bl, int n, int n2, BTreeLockingPolicy bTreeLockingPolicy, BTree bTree, LogicalUndo logicalUndo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        if (this.container != null) {
            this.close();
        }
        this.err_containerid = bTree.id.getContainerId();
        this.init_btree_locking_policy = bTreeLockingPolicy;
        if (bTree.isTemporary()) {
            n |= 0x800;
        }
        this.container = containerHandle == null ? transaction.openContainer(bTree.id, null, n) : containerHandle;
        if (this.container == null) {
            throw StandardException.newException("XSCB1.S", new Long(this.err_containerid));
        }
        this.init_conglomerate = bTree;
        this.init_xact_manager = transactionManager2;
        this.init_rawtran = transaction;
        this.init_openmode = n;
        this.init_lock_level = n2;
        this.init_dynamic_info = dynamicCompiledOpenConglomInfo;
        this.init_hold = bl;
        this.init_open_user_scans = transactionManager;
        this.btree_undo = logicalUndo;
        this.runtime_mem = dynamicCompiledOpenConglomInfo != null ? (OpenConglomerateScratchSpace)dynamicCompiledOpenConglomInfo : new OpenConglomerateScratchSpace(bTree.format_ids);
    }

    public ContainerHandle reopen() throws StandardException {
        if (this.container == null) {
            this.container = this.init_xact_manager.getRawStoreXact().openContainer(this.init_conglomerate.id, null, this.init_openmode);
        }
        return this.container;
    }

    public void close() throws StandardException {
        if (this.container != null) {
            this.container.close();
        }
        this.container = null;
    }

    void isIndexableRowConsistent(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
    }

    public ContainerHandle getContainerHandle() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() throws StandardException {
        ControlRow controlRow = null;
        try {
            int n;
            controlRow = ControlRow.Get(this, 1L);
            int n2 = n = controlRow.getLevel() + 1;
            return n2;
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    public RecordHandle makeRecordHandle(long l, int n) throws StandardException {
        return this.container.makeRecordHandle(l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugConglomerate() throws StandardException {
        ControlRow controlRow = null;
        try {
            controlRow = ControlRow.Get(this, 1L);
            controlRow.printTree(this);
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    public static boolean test_errors(OpenBTree openBTree, String string, boolean bl, BTreeLockingPolicy bTreeLockingPolicy, LeafControlRow leafControlRow, boolean bl2) throws StandardException {
        boolean bl3 = bl2;
        return bl3;
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo();
    }

    public boolean[] getColumnSortOrderInfo() throws StandardException {
        return this.init_conglomerate.ascDescInfo;
    }
}

