use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Hypersonic',
    VERSION_FROM     => 'lib/Hypersonic.pm',
    ABSTRACT         => 'Blazing fast HTTP server using JIT-compiled custom ops',
    AUTHOR           => 'Your Name',
    LICENSE          => 'perl_5',
    MIN_PERL_VERSION => '5.010',

    PREREQ_PM => {
        'XS::JIT'         => '0.08',
    },

    TEST_REQUIRES => {
        'Test::More' => '0.88',
    },

    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {
            repository => {
                type => 'git',
                url  => 'https://github.com/yourname/Hypersonic.git',
                web  => 'https://github.com/yourname/Hypersonic',
            },
        },
    },

    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Hypersonic-* _hypersonic_cache' },
);
