# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#	gethostby_emu.t
#
######################### We start with some black magic to print on failure.
# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
	$| = 1; print "1..28\n"; 
	*Net::DNS::ToolKit::Utilities::question = \&question;
}
END {print "not ok 1\n" unless $loaded;}

#use diagnostics;
use Net::DNS::Dig qw (
	ndd_gethostbyname
	ndd_gethostbyaddr
	ndd_gethostbyname2
	AF_INET
	AF_INET6
);
use Net::DNS::Codes qw(:all);
use Net::DNS::ToolKit qw(
	put1char
);
use Net::DNS::ToolKit::RR;
#use Net::DNS::ToolKit::Debug qw(
#	print_buf
#);
use NetAddr::IP::Util qw(
	inet_ntoa
	ipv6_n2x
	ipv6_aton
);

$loaded = 1;
print "ok 1\n";
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test = 2;

sub ok {
  print "ok $test\n";
  ++$test;
}

#require './recurse2txt';

# input:	data pointer
# returns:	pointer to query buffer
#
sub makebuf {
  my $dp = shift;
  my @data = split("\n",$$dp);
  my $off = 0;
  my $buffer = '';
  foreach (@data) {
    $_ =~ /0x.{2}\s+(\d+)/;
    $off = put1char(\$buffer,$off,$1);
  }
  return \$buffer;
}

my $aques1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1011_0010  0xB2  178    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0100  0x04    4    
  13	:  0110_0001  0x61   97  a  
  14	:  0111_0010  0x72  114  r  
  15	:  0111_0000  0x70  112  p  
  16	:  0110_0001  0x61   97  a  
  17	:  0000_0011  0x03    3    
  18	:  0110_0011  0x63   99  c  
  19	:  0110_1111  0x6F  111  o  
  20	:  0110_1101  0x6D  109  m  
  21	:  0000_0000  0x00    0    
  22	:  0000_0000  0x00    0    
  23	:  0000_0001  0x01    1    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    |;

my $aans1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1011_0010  0xB2  178    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_1000  0x08    8    
  10	:  0000_0000  0x00    0    
  11	:  0000_1000  0x08    8    
  12	:  0000_0100  0x04    4    
  13	:  0110_0001  0x61   97  a  
  14	:  0111_0010  0x72  114  r  
  15	:  0111_0000  0x70  112  p  
  16	:  0110_0001  0x61   97  a  
  17	:  0000_0011  0x03    3    
  18	:  0110_0011  0x63   99  c  
  19	:  0110_1111  0x6F  111  o  
  20	:  0110_1101  0x6D  109  m  
  21	:  0000_0000  0x00    0    
  22	:  0000_0000  0x00    0    
  23	:  0000_0001  0x01    1    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    
  26	:  1100_0000  0xC0  192    
  27	:  0000_1100  0x0C   12    
  28	:  0000_0000  0x00    0    
  29	:  0000_0001  0x01    1    
  30	:  0000_0000  0x00    0    
  31	:  0000_0001  0x01    1    
  32	:  0000_0000  0x00    0    
  33	:  0000_0000  0x00    0    
  34	:  0000_0000  0x00    0    
  35	:  0010_1010  0x2A   42  *  
  36	:  0000_0000  0x00    0    
  37	:  0000_0100  0x04    4    
  38	:  1010_1110  0xAE  174    
  39	:  1000_1000  0x88  136    
  40	:  0110_1000  0x68  104  h  
  41	:  1110_1010  0xEA  234    
  42	:  1100_0000  0xC0  192    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0010  0x02    2    
  46	:  0000_0000  0x00    0    
  47	:  0000_0001  0x01    1    
  48	:  0000_0000  0x00    0    
  49	:  0000_0001  0x01    1    
  50	:  0101_0001  0x51   81  Q  
  51	:  0110_1110  0x6E  110  n  
  52	:  0000_0000  0x00    0    
  53	:  0001_0100  0x14   20    
  54	:  0000_0101  0x05    5    
  55	:  0111_0000  0x70  112  p  
  56	:  0110_0100  0x64  100  d  
  57	:  0110_1110  0x6E  110  n  
  58	:  0111_0011  0x73  115  s  
  59	:  0011_0100  0x34   52  4  
  60	:  0000_1000  0x08    8    
  61	:  0111_0101  0x75  117  u  
  62	:  0110_1100  0x6C  108  l  
  63	:  0111_0100  0x74  116  t  
  64	:  0111_0010  0x72  114  r  
  65	:  0110_0001  0x61   97  a  
  66	:  0110_0100  0x64  100  d  
  67	:  0110_1110  0x6E  110  n  
  68	:  0111_0011  0x73  115  s  
  69	:  0000_0011  0x03    3    
  70	:  0110_1111  0x6F  111  o  
  71	:  0111_0010  0x72  114  r  
  72	:  0110_0111  0x67  103  g  
  73	:  0000_0000  0x00    0    
  74	:  1100_0000  0xC0  192    
  75	:  0000_1100  0x0C   12    
  76	:  0000_0000  0x00    0    
  77	:  0000_0010  0x02    2    
  78	:  0000_0000  0x00    0    
  79	:  0000_0001  0x01    1    
  80	:  0000_0000  0x00    0    
  81	:  0000_0001  0x01    1    
  82	:  0101_0001  0x51   81  Q  
  83	:  0110_1110  0x6E  110  n  
  84	:  0000_0000  0x00    0    
  85	:  0001_0100  0x14   20    
  86	:  0000_0101  0x05    5    
  87	:  0111_0000  0x70  112  p  
  88	:  0110_0100  0x64  100  d  
  89	:  0110_1110  0x6E  110  n  
  90	:  0111_0011  0x73  115  s  
  91	:  0011_0001  0x31   49  1  
  92	:  0000_1000  0x08    8    
  93	:  0111_0101  0x75  117  u  
  94	:  0110_1100  0x6C  108  l  
  95	:  0111_0100  0x74  116  t  
  96	:  0111_0010  0x72  114  r  
  97	:  0110_0001  0x61   97  a  
  98	:  0110_0100  0x64  100  d  
  99	:  0110_1110  0x6E  110  n  
  100	:  0111_0011  0x73  115  s  
  101	:  0000_0011  0x03    3    
  102	:  0110_1110  0x6E  110  n  
  103	:  0110_0101  0x65  101  e  
  104	:  0111_0100  0x74  116  t  
  105	:  0000_0000  0x00    0    
  106	:  1100_0000  0xC0  192    
  107	:  0000_1100  0x0C   12    
  108	:  0000_0000  0x00    0    
  109	:  0000_0010  0x02    2    
  110	:  0000_0000  0x00    0    
  111	:  0000_0001  0x01    1    
  112	:  0000_0000  0x00    0    
  113	:  0000_0001  0x01    1    
  114	:  0101_0001  0x51   81  Q  
  115	:  0110_1110  0x6E  110  n  
  116	:  0000_0000  0x00    0    
  117	:  0000_1000  0x08    8    
  118	:  0000_0101  0x05    5    
  119	:  0111_0101  0x75  117  u  
  120	:  0110_0100  0x64  100  d  
  121	:  0110_1110  0x6E  110  n  
  122	:  0111_0011  0x73  115  s  
  123	:  0011_0010  0x32   50  2  
  124	:  1100_0000  0xC0  192    
  125	:  0101_1100  0x5C   92  \  
  126	:  1100_0000  0xC0  192    
  127	:  0000_1100  0x0C   12    
  128	:  0000_0000  0x00    0    
  129	:  0000_0010  0x02    2    
  130	:  0000_0000  0x00    0    
  131	:  0000_0001  0x01    1    
  132	:  0000_0000  0x00    0    
  133	:  0000_0001  0x01    1    
  134	:  0101_0001  0x51   81  Q  
  135	:  0110_1110  0x6E  110  n  
  136	:  0000_0000  0x00    0    
  137	:  0000_1000  0x08    8    
  138	:  0000_0101  0x05    5    
  139	:  0111_0000  0x70  112  p  
  140	:  0110_0100  0x64  100  d  
  141	:  0110_1110  0x6E  110  n  
  142	:  0111_0011  0x73  115  s  
  143	:  0011_0010  0x32   50  2  
  144	:  1100_0000  0xC0  192    
  145	:  0101_1100  0x5C   92  \  
  146	:  1100_0000  0xC0  192    
  147	:  0000_1100  0x0C   12    
  148	:  0000_0000  0x00    0    
  149	:  0000_0010  0x02    2    
  150	:  0000_0000  0x00    0    
  151	:  0000_0001  0x01    1    
  152	:  0000_0000  0x00    0    
  153	:  0000_0001  0x01    1    
  154	:  0101_0001  0x51   81  Q  
  155	:  0110_1110  0x6E  110  n  
  156	:  0000_0000  0x00    0    
  157	:  0000_1000  0x08    8    
  158	:  0000_0101  0x05    5    
  159	:  0111_0101  0x75  117  u  
  160	:  0110_0100  0x64  100  d  
  161	:  0110_1110  0x6E  110  n  
  162	:  0111_0011  0x73  115  s  
  163	:  0011_0001  0x31   49  1  
  164	:  1100_0000  0xC0  192    
  165	:  0101_1100  0x5C   92  \  
  166	:  1100_0000  0xC0  192    
  167	:  0000_1100  0x0C   12    
  168	:  0000_0000  0x00    0    
  169	:  0000_0010  0x02    2    
  170	:  0000_0000  0x00    0    
  171	:  0000_0001  0x01    1    
  172	:  0000_0000  0x00    0    
  173	:  0000_0001  0x01    1    
  174	:  0101_0001  0x51   81  Q  
  175	:  0110_1110  0x6E  110  n  
  176	:  0000_0000  0x00    0    
  177	:  0001_0110  0x16   22    
  178	:  0000_0101  0x05    5    
  179	:  0111_0000  0x70  112  p  
  180	:  0110_0100  0x64  100  d  
  181	:  0110_1110  0x6E  110  n  
  182	:  0111_0011  0x73  115  s  
  183	:  0011_0110  0x36   54  6  
  184	:  0000_1000  0x08    8    
  185	:  0111_0101  0x75  117  u  
  186	:  0110_1100  0x6C  108  l  
  187	:  0111_0100  0x74  116  t  
  188	:  0111_0010  0x72  114  r  
  189	:  0110_0001  0x61   97  a  
  190	:  0110_0100  0x64  100  d  
  191	:  0110_1110  0x6E  110  n  
  192	:  0111_0011  0x73  115  s  
  193	:  0000_0010  0x02    2    
  194	:  0110_0011  0x63   99  c  
  195	:  0110_1111  0x6F  111  o  
  196	:  0000_0010  0x02    2    
  197	:  0111_0101  0x75  117  u  
  198	:  0110_1011  0x6B  107  k  
  199	:  0000_0000  0x00    0    
  200	:  1100_0000  0xC0  192    
  201	:  0000_1100  0x0C   12    
  202	:  0000_0000  0x00    0    
  203	:  0000_0010  0x02    2    
  204	:  0000_0000  0x00    0    
  205	:  0000_0001  0x01    1    
  206	:  0000_0000  0x00    0    
  207	:  0000_0001  0x01    1    
  208	:  0101_0001  0x51   81  Q  
  209	:  0110_1110  0x6E  110  n  
  210	:  0000_0000  0x00    0    
  211	:  0000_1000  0x08    8    
  212	:  0000_0101  0x05    5    
  213	:  0111_0000  0x70  112  p  
  214	:  0110_0100  0x64  100  d  
  215	:  0110_1110  0x6E  110  n  
  216	:  0111_0011  0x73  115  s  
  217	:  0011_0011  0x33   51  3  
  218	:  1100_0000  0xC0  192    
  219	:  0011_1100  0x3C   60  <  
  220	:  1100_0000  0xC0  192    
  221	:  0000_1100  0x0C   12    
  222	:  0000_0000  0x00    0    
  223	:  0000_0010  0x02    2    
  224	:  0000_0000  0x00    0    
  225	:  0000_0001  0x01    1    
  226	:  0000_0000  0x00    0    
  227	:  0000_0001  0x01    1    
  228	:  0101_0001  0x51   81  Q  
  229	:  0110_1110  0x6E  110  n  
  230	:  0000_0000  0x00    0    
  231	:  0001_0101  0x15   21    
  232	:  0000_0101  0x05    5    
  233	:  0111_0000  0x70  112  p  
  234	:  0110_0100  0x64  100  d  
  235	:  0110_1110  0x6E  110  n  
  236	:  0111_0011  0x73  115  s  
  237	:  0011_0101  0x35   53  5  
  238	:  0000_1000  0x08    8    
  239	:  0111_0101  0x75  117  u  
  240	:  0110_1100  0x6C  108  l  
  241	:  0111_0100  0x74  116  t  
  242	:  0111_0010  0x72  114  r  
  243	:  0110_0001  0x61   97  a  
  244	:  0110_0100  0x64  100  d  
  245	:  0110_1110  0x6E  110  n  
  246	:  0111_0011  0x73  115  s  
  247	:  0000_0100  0x04    4    
  248	:  0110_1001  0x69  105  i  
  249	:  0110_1110  0x6E  110  n  
  250	:  0110_0110  0x66  102  f  
  251	:  0110_1111  0x6F  111  o  
  252	:  0000_0000  0x00    0    
  253	:  1100_0000  0xC0  192    
  254	:  0101_0110  0x56   86  V  
  255	:  0000_0000  0x00    0    
  256	:  0000_0001  0x01    1    
  257	:  0000_0000  0x00    0    
  258	:  0000_0001  0x01    1    
  259	:  0000_0000  0x00    0    
  260	:  0000_0000  0x00    0    
  261	:  0000_0100  0x04    4    
  262	:  1110_1010  0xEA  234    
  263	:  0000_0000  0x00    0    
  264	:  0000_0100  0x04    4    
  265	:  1100_1100  0xCC  204    
  266	:  0100_1010  0x4A   74  J  
  267	:  0110_1100  0x6C  108  l  
  268	:  0000_0001  0x01    1    
  269	:  1100_0000  0xC0  192    
  270	:  1000_1010  0x8A  138    
  271	:  0000_0000  0x00    0    
  272	:  0000_0001  0x01    1    
  273	:  0000_0000  0x00    0    
  274	:  0000_0001  0x01    1    
  275	:  0000_0000  0x00    0    
  276	:  0000_0000  0x00    0    
  277	:  0000_0100  0x04    4    
  278	:  1110_1010  0xEA  234    
  279	:  0000_0000  0x00    0    
  280	:  0000_0100  0x04    4    
  281	:  1100_1100  0xCC  204    
  282	:  0100_1010  0x4A   74  J  
  283	:  0110_1101  0x6D  109  m  
  284	:  0000_0001  0x01    1    
  285	:  1100_0000  0xC0  192    
  286	:  1101_0100  0xD4  212    
  287	:  0000_0000  0x00    0    
  288	:  0000_0001  0x01    1    
  289	:  0000_0000  0x00    0    
  290	:  0000_0001  0x01    1    
  291	:  0000_0000  0x00    0    
  292	:  0000_0000  0x00    0    
  293	:  1110_1110  0xEE  238    
  294	:  0010_0011  0x23   35  #  
  295	:  0000_0000  0x00    0    
  296	:  0000_0100  0x04    4    
  297	:  1100_0111  0xC7  199    
  298	:  0000_0111  0x07    7    
  299	:  0100_0100  0x44   68  D  
  300	:  0000_0001  0x01    1    
  301	:  1100_0000  0xC0  192    
  302	:  0011_0110  0x36   54  6  
  303	:  0000_0000  0x00    0    
  304	:  0000_0001  0x01    1    
  305	:  0000_0000  0x00    0    
  306	:  0000_0001  0x01    1    
  307	:  0000_0000  0x00    0    
  308	:  0000_0001  0x01    1    
  309	:  0010_0010  0x22   34  "  
  310	:  0110_1010  0x6A  106  j  
  311	:  0000_0000  0x00    0    
  312	:  0000_0100  0x04    4    
  313	:  1100_0111  0xC7  199    
  314	:  0000_0111  0x07    7    
  315	:  0100_0101  0x45   69  E  
  316	:  0000_0001  0x01    1    
  317	:  1100_0000  0xC0  192    
  318	:  1110_1000  0xE8  232    
  319	:  0000_0000  0x00    0    
  320	:  0000_0001  0x01    1    
  321	:  0000_0000  0x00    0    
  322	:  0000_0001  0x01    1    
  323	:  0000_0000  0x00    0    
  324	:  0000_0000  0x00    0    
  325	:  1110_1110  0xEE  238    
  326	:  0010_0011  0x23   35  #  
  327	:  0000_0000  0x00    0    
  328	:  0000_0100  0x04    4    
  329	:  1100_1100  0xCC  204    
  330	:  0100_1010  0x4A   74  J  
  331	:  0111_0010  0x72  114  r  
  332	:  0000_0001  0x01    1    
  333	:  1100_0000  0xC0  192    
  334	:  1011_0010  0xB2  178    
  335	:  0000_0000  0x00    0    
  336	:  0000_0001  0x01    1    
  337	:  0000_0000  0x00    0    
  338	:  0000_0001  0x01    1    
  339	:  0000_0000  0x00    0    
  340	:  0000_0000  0x00    0    
  341	:  1110_1110  0xEE  238    
  342	:  0010_0011  0x23   35  #  
  343	:  0000_0000  0x00    0    
  344	:  0000_0100  0x04    4    
  345	:  1100_1100  0xCC  204    
  346	:  0100_1010  0x4A   74  J  
  347	:  0111_0011  0x73  115  s  
  348	:  0000_0001  0x01    1    
  349	:  1100_0000  0xC0  192    
  350	:  1001_1110  0x9E  158    
  351	:  0000_0000  0x00    0    
  352	:  0000_0001  0x01    1    
  353	:  0000_0000  0x00    0    
  354	:  0000_0001  0x01    1    
  355	:  0000_0000  0x00    0    
  356	:  0000_0000  0x00    0    
  357	:  1101_1110  0xDE  222    
  358	:  0000_1010  0x0A   10    
  359	:  0000_0000  0x00    0    
  360	:  0000_0100  0x04    4    
  361	:  1100_1100  0xCC  204    
  362	:  0100_0101  0x45   69  E  
  363	:  1110_1010  0xEA  234    
  364	:  0000_0001  0x01    1    
  365	:  1100_0000  0xC0  192    
  366	:  0111_0110  0x76  118  v  
  367	:  0000_0000  0x00    0    
  368	:  0000_0001  0x01    1    
  369	:  0000_0000  0x00    0    
  370	:  0000_0001  0x01    1    
  371	:  0000_0000  0x00    0    
  372	:  0000_0000  0x00    0    
  373	:  1101_1110  0xDE  222    
  374	:  0000_1010  0x0A   10    
  375	:  0000_0000  0x00    0    
  376	:  0000_0100  0x04    4    
  377	:  1100_1100  0xCC  204    
  378	:  0100_1010  0x4A   74  J  
  379	:  0110_0101  0x65  101  e  
  380	:  0000_0001  0x01    1    |;

# ; <<>> dig.pl 1.10 <<>> -d arpa.com
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13234
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 8, ADDITIONAL: 8
# 
# ;; QUESTION SECTION:
# ;arpa.com.			IN	A
# 
# ;; ANSWER SECTION:
# arpa.com.		42	IN	A	174.136.104.234 
# 
# ;; AUTHORITY SECTION:
# arpa.com.		86382	IN	NS	pdns4.ultradns.org. 
# arpa.com.		86382	IN	NS	pdns1.ultradns.net. 
# arpa.com.		86382	IN	NS	udns2.ultradns.net. 
# arpa.com.		86382	IN	NS	pdns2.ultradns.net. 
# arpa.com.		86382	IN	NS	udns1.ultradns.net. 
# arpa.com.		86382	IN	NS	pdns6.ultradns.co.uk. 
# arpa.com.		86382	IN	NS	pdns3.ultradns.org. 
# arpa.com.		86382	IN	NS	pdns5.ultradns.info. 
# 
# ;; ADDITIONAL SECTION:
# pdns1.ultradns.net.	1258	IN	A	204.74.108.1 
# pdns2.ultradns.net.	1258	IN	A	204.74.109.1 
# pdns3.ultradns.org.	60963	IN	A	199.7.68.1 
# pdns4.ultradns.org.	74346	IN	A	199.7.69.1 
# pdns5.ultradns.info.	60963	IN	A	204.74.114.1 
# pdns6.ultradns.co.uk.	60963	IN	A	204.74.115.1 
# udns1.ultradns.net.	56842	IN	A	204.69.234.1 
# udns2.ultradns.net.	56842	IN	A	204.74.101.1 
# 
# ;; Query time: 61 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sun Oct  2 15:12:41 2011
# ;; MSG SIZE rcvd: 381 -- XFR size: 18 records
#
 
my $pques1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    |;

my $pans1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_0010  0x02    2    
  10	:  0000_0000  0x00    0    
  11	:  0000_0010  0x02    2    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    
  46	:  1100_0000  0xC0  192    
  47	:  0000_1100  0x0C   12    
  48	:  0000_0000  0x00    0    
  49	:  0000_1100  0x0C   12    
  50	:  0000_0000  0x00    0    
  51	:  0000_0001  0x01    1    
  52	:  0000_0000  0x00    0    
  53	:  0000_0000  0x00    0    
  54	:  0000_1101  0x0D   13    
  55	:  1110_1010  0xEA  234    
  56	:  0000_0000  0x00    0    
  57	:  0000_1100  0x0C   12    
  58	:  0000_0001  0x01    1    
  59	:  0110_0001  0x61   97  a  
  60	:  0000_0100  0x04    4    
  61	:  0110_0001  0x61   97  a  
  62	:  0111_0010  0x72  114  r  
  63	:  0111_0000  0x70  112  p  
  64	:  0110_0001  0x61   97  a  
  65	:  0000_0011  0x03    3    
  66	:  0110_0011  0x63   99  c  
  67	:  0110_1111  0x6F  111  o  
  68	:  0110_1101  0x6D  109  m  
  69	:  0000_0000  0x00    0    
  70	:  1100_0000  0xC0  192    
  71	:  0001_0000  0x10   16    
  72	:  0000_0000  0x00    0    
  73	:  0000_0010  0x02    2    
  74	:  0000_0000  0x00    0    
  75	:  0000_0001  0x01    1    
  76	:  0000_0000  0x00    0    
  77	:  0000_0000  0x00    0    
  78	:  0000_1101  0x0D   13    
  79	:  1110_1010  0xEA  234    
  80	:  0000_0000  0x00    0    
  81	:  0001_0010  0x12   18    
  82	:  0000_0011  0x03    3    
  83	:  0110_1110  0x6E  110  n  
  84	:  0111_0011  0x73  115  s  
  85	:  0011_0010  0x32   50  2  
  86	:  0000_1011  0x0B   11    
  87	:  0110_0001  0x61   97  a  
  88	:  0111_0010  0x72  114  r  
  89	:  0111_0000  0x70  112  p  
  90	:  0110_1110  0x6E  110  n  
  91	:  0110_0101  0x65  101  e  
  92	:  0111_0100  0x74  116  t  
  93	:  0111_0111  0x77  119  w  
  94	:  0110_1111  0x6F  111  o  
  95	:  0111_0010  0x72  114  r  
  96	:  0110_1011  0x6B  107  k  
  97	:  0111_0011  0x73  115  s  
  98	:  1100_0000  0xC0  192    
  99	:  0100_0001  0x41   65  A  
  100	:  1100_0000  0xC0  192    
  101	:  0001_0000  0x10   16    
  102	:  0000_0000  0x00    0    
  103	:  0000_0010  0x02    2    
  104	:  0000_0000  0x00    0    
  105	:  0000_0001  0x01    1    
  106	:  0000_0000  0x00    0    
  107	:  0000_0000  0x00    0    
  108	:  0000_1101  0x0D   13    
  109	:  1110_1010  0xEA  234    
  110	:  0000_0000  0x00    0    
  111	:  0000_0110  0x06    6    
  112	:  0000_0011  0x03    3    
  113	:  0110_1110  0x6E  110  n  
  114	:  0111_0011  0x73  115  s  
  115	:  0011_0001  0x31   49  1  
  116	:  1100_0000  0xC0  192    
  117	:  0101_0110  0x56   86  V  
  118	:  1100_0000  0xC0  192    
  119	:  0111_0000  0x70  112  p  
  120	:  0000_0000  0x00    0    
  121	:  0000_0001  0x01    1    
  122	:  0000_0000  0x00    0    
  123	:  0000_0001  0x01    1    
  124	:  0000_0000  0x00    0    
  125	:  0000_0000  0x00    0    
  126	:  0000_0001  0x01    1    
  127	:  0000_0110  0x06    6    
  128	:  0000_0000  0x00    0    
  129	:  0000_0100  0x04    4    
  130	:  1101_0000  0xD0  208    
  131	:  0100_1111  0x4F   79  O  
  132	:  0101_1000  0x58   88  X  
  133	:  0000_0111  0x07    7    
  134	:  1100_0000  0xC0  192    
  135	:  0101_0010  0x52   82  R  
  136	:  0000_0000  0x00    0    
  137	:  0000_0001  0x01    1    
  138	:  0000_0000  0x00    0    
  139	:  0000_0001  0x01    1    
  140	:  0000_0000  0x00    0    
  141	:  0000_0000  0x00    0    
  142	:  0000_0001  0x01    1    
  143	:  0000_0110  0x06    6    
  144	:  0000_0000  0x00    0    
  145	:  0000_0100  0x04    4    
  146	:  1101_0000  0xD0  208    
  147	:  0100_1111  0x4F   79  O  
  148	:  0101_1001  0x59   89  Y  
  149	:  0000_1001  0x09    9    |;

my $zans1 = q		# answer count set to zero
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0010  0x02    2    
  10	:  0000_0000  0x00    0    
  11	:  0000_0010  0x02    2    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    
  46	:  1100_0000  0xC0  192    
  47	:  0000_1100  0x0C   12    
  48	:  0000_0000  0x00    0    
  49	:  0000_1100  0x0C   12    
  50	:  0000_0000  0x00    0    
  51	:  0000_0001  0x01    1    
  52	:  0000_0000  0x00    0    
  53	:  0000_0000  0x00    0    
  54	:  0000_1101  0x0D   13    
  55	:  1110_1010  0xEA  234    
  56	:  0000_0000  0x00    0    
  57	:  0000_1100  0x0C   12    
  58	:  0000_0001  0x01    1    
  59	:  0110_0001  0x61   97  a  
  60	:  0000_0100  0x04    4    
  61	:  0110_0001  0x61   97  a  
  62	:  0111_0010  0x72  114  r  
  63	:  0111_0000  0x70  112  p  
  64	:  0110_0001  0x61   97  a  
  65	:  0000_0011  0x03    3    
  66	:  0110_0011  0x63   99  c  
  67	:  0110_1111  0x6F  111  o  
  68	:  0110_1101  0x6D  109  m  
  69	:  0000_0000  0x00    0    
  70	:  1100_0000  0xC0  192    
  71	:  0001_0000  0x10   16    
  72	:  0000_0000  0x00    0    
  73	:  0000_0010  0x02    2    
  74	:  0000_0000  0x00    0    
  75	:  0000_0001  0x01    1    
  76	:  0000_0000  0x00    0    
  77	:  0000_0000  0x00    0    
  78	:  0000_1101  0x0D   13    
  79	:  1110_1010  0xEA  234    
  80	:  0000_0000  0x00    0    
  81	:  0001_0010  0x12   18    
  82	:  0000_0011  0x03    3    
  83	:  0110_1110  0x6E  110  n  
  84	:  0111_0011  0x73  115  s  
  85	:  0011_0010  0x32   50  2  
  86	:  0000_1011  0x0B   11    
  87	:  0110_0001  0x61   97  a  
  88	:  0111_0010  0x72  114  r  
  89	:  0111_0000  0x70  112  p  
  90	:  0110_1110  0x6E  110  n  
  91	:  0110_0101  0x65  101  e  
  92	:  0111_0100  0x74  116  t  
  93	:  0111_0111  0x77  119  w  
  94	:  0110_1111  0x6F  111  o  
  95	:  0111_0010  0x72  114  r  
  96	:  0110_1011  0x6B  107  k  
  97	:  0111_0011  0x73  115  s  
  98	:  1100_0000  0xC0  192    
  99	:  0100_0001  0x41   65  A  
  100	:  1100_0000  0xC0  192    
  101	:  0001_0000  0x10   16    
  102	:  0000_0000  0x00    0    
  103	:  0000_0010  0x02    2    
  104	:  0000_0000  0x00    0    
  105	:  0000_0001  0x01    1    
  106	:  0000_0000  0x00    0    
  107	:  0000_0000  0x00    0    
  108	:  0000_1101  0x0D   13    
  109	:  1110_1010  0xEA  234    
  110	:  0000_0000  0x00    0    
  111	:  0000_0110  0x06    6    
  112	:  0000_0011  0x03    3    
  113	:  0110_1110  0x6E  110  n  
  114	:  0111_0011  0x73  115  s  
  115	:  0011_0001  0x31   49  1  
  116	:  1100_0000  0xC0  192    
  117	:  0101_0110  0x56   86  V  
  118	:  1100_0000  0xC0  192    
  119	:  0111_0000  0x70  112  p  
  120	:  0000_0000  0x00    0    
  121	:  0000_0001  0x01    1    
  122	:  0000_0000  0x00    0    
  123	:  0000_0001  0x01    1    
  124	:  0000_0000  0x00    0    
  125	:  0000_0000  0x00    0    
  126	:  0000_0001  0x01    1    
  127	:  0000_0110  0x06    6    
  128	:  0000_0000  0x00    0    
  129	:  0000_0100  0x04    4    
  130	:  1101_0000  0xD0  208    
  131	:  0100_1111  0x4F   79  O  
  132	:  0101_1000  0x58   88  X  
  133	:  0000_0111  0x07    7    
  134	:  1100_0000  0xC0  192    
  135	:  0101_0010  0x52   82  R  
  136	:  0000_0000  0x00    0    
  137	:  0000_0001  0x01    1    
  138	:  0000_0000  0x00    0    
  139	:  0000_0001  0x01    1    
  140	:  0000_0000  0x00    0    
  141	:  0000_0000  0x00    0    
  142	:  0000_0001  0x01    1    
  143	:  0000_0110  0x06    6    
  144	:  0000_0000  0x00    0    
  145	:  0000_0100  0x04    4    
  146	:  1101_0000  0xD0  208    
  147	:  0100_1111  0x4F   79  O  
  148	:  0101_1001  0x59   89  Y  
  149	:  0000_1001  0x09    9    |;

# ; <<>> dig.pl 1.10 <<>> -t ptr -d 234.104.136.174.in-addr.arpa
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13284
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 2, ADDITIONAL: 2
# 
# ;; QUESTION SECTION:
# ;234.104.136.174.in-addr.arpa.		IN	PTR
# 
# ;; ANSWER SECTION:
# 234.104.136.174.in-addr.arpa.	3562	IN	PTR	a.arpa.com. 
# 
# ;; AUTHORITY SECTION:
# 104.136.174.in-addr.arpa.	3562	IN	NS	ns2.arpnetworks.com. 
# 104.136.174.in-addr.arpa.	3562	IN	NS	ns1.arpnetworks.com. 
# 
# ;; ADDITIONAL SECTION:
# ns1.arpnetworks.com.	262	IN	A	208.79.88.7 
# ns2.arpnetworks.com.	262	IN	A	208.79.89.9 
# 
# ;; Query time: 44 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sun Oct  2 15:26:21 2011
# ;; MSG SIZE rcvd: 150 -- XFR size: 6 records
# 

my $p6ques = q
| 0	:  0011_0110  0x36   54  6  
  1	:  0000_1101  0x0D   13    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0001  0x01    1    
  13	:  0011_0101  0x35   53  5  
  14	:  0000_0001  0x01    1    
  15	:  0011_0011  0x33   51  3  
  16	:  0000_0001  0x01    1    
  17	:  0011_0010  0x32   50  2  
  18	:  0000_0001  0x01    1    
  19	:  0011_0000  0x30   48  0  
  20	:  0000_0001  0x01    1    
  21	:  0110_0110  0x66  102  f  
  22	:  0000_0001  0x01    1    
  23	:  0011_0011  0x33   51  3  
  24	:  0000_0001  0x01    1    
  25	:  0011_0000  0x30   48  0  
  26	:  0000_0001  0x01    1    
  27	:  0011_1000  0x38   56  8  
  28	:  0000_0001  0x01    1    
  29	:  0011_0000  0x30   48  0  
  30	:  0000_0001  0x01    1    
  31	:  0011_0000  0x30   48  0  
  32	:  0000_0001  0x01    1    
  33	:  0011_0000  0x30   48  0  
  34	:  0000_0001  0x01    1    
  35	:  0011_0000  0x30   48  0  
  36	:  0000_0001  0x01    1    
  37	:  0011_0000  0x30   48  0  
  38	:  0000_0001  0x01    1    
  39	:  0011_0000  0x30   48  0  
  40	:  0000_0001  0x01    1    
  41	:  0011_0000  0x30   48  0  
  42	:  0000_0001  0x01    1    
  43	:  0011_0000  0x30   48  0  
  44	:  0000_0001  0x01    1    
  45	:  0011_0000  0x30   48  0  
  46	:  0000_0001  0x01    1    
  47	:  0011_0000  0x30   48  0  
  48	:  0000_0001  0x01    1    
  49	:  0011_0000  0x30   48  0  
  50	:  0000_0001  0x01    1    
  51	:  0011_0000  0x30   48  0  
  52	:  0000_0001  0x01    1    
  53	:  0011_0001  0x31   49  1  
  54	:  0000_0001  0x01    1    
  55	:  0011_0000  0x30   48  0  
  56	:  0000_0001  0x01    1    
  57	:  0011_0000  0x30   48  0  
  58	:  0000_0001  0x01    1    
  59	:  0011_0000  0x30   48  0  
  60	:  0000_0001  0x01    1    
  61	:  0011_0000  0x30   48  0  
  62	:  0000_0001  0x01    1    
  63	:  0011_0000  0x30   48  0  
  64	:  0000_0001  0x01    1    
  65	:  0011_0101  0x35   53  5  
  66	:  0000_0001  0x01    1    
  67	:  0011_0000  0x30   48  0  
  68	:  0000_0001  0x01    1    
  69	:  0011_0001  0x31   49  1  
  70	:  0000_0001  0x01    1    
  71	:  0011_0000  0x30   48  0  
  72	:  0000_0001  0x01    1    
  73	:  0011_0000  0x30   48  0  
  74	:  0000_0001  0x01    1    
  75	:  0011_0010  0x32   50  2  
  76	:  0000_0011  0x03    3    
  77	:  0110_1001  0x69  105  i  
  78	:  0111_0000  0x70  112  p  
  79	:  0011_0110  0x36   54  6  
  80	:  0000_0100  0x04    4    
  81	:  0110_0001  0x61   97  a  
  82	:  0111_0010  0x72  114  r  
  83	:  0111_0000  0x70  112  p  
  84	:  0110_0001  0x61   97  a  
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  0000_1100  0x0C   12    
  88	:  0000_0000  0x00    0    
  89	:  0000_0001  0x01    1    |;

my $p6ans = q
| 0	:  0011_0110  0x36   54  6  
  1	:  0000_1101  0x0D   13    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_0011  0x03    3    
  10	:  0000_0000  0x00    0    
  11	:  0000_0100  0x04    4    
  12	:  0000_0001  0x01    1    
  13	:  0011_0101  0x35   53  5  
  14	:  0000_0001  0x01    1    
  15	:  0011_0011  0x33   51  3  
  16	:  0000_0001  0x01    1    
  17	:  0011_0010  0x32   50  2  
  18	:  0000_0001  0x01    1    
  19	:  0011_0000  0x30   48  0  
  20	:  0000_0001  0x01    1    
  21	:  0110_0110  0x66  102  f  
  22	:  0000_0001  0x01    1    
  23	:  0011_0011  0x33   51  3  
  24	:  0000_0001  0x01    1    
  25	:  0011_0000  0x30   48  0  
  26	:  0000_0001  0x01    1    
  27	:  0011_1000  0x38   56  8  
  28	:  0000_0001  0x01    1    
  29	:  0011_0000  0x30   48  0  
  30	:  0000_0001  0x01    1    
  31	:  0011_0000  0x30   48  0  
  32	:  0000_0001  0x01    1    
  33	:  0011_0000  0x30   48  0  
  34	:  0000_0001  0x01    1    
  35	:  0011_0000  0x30   48  0  
  36	:  0000_0001  0x01    1    
  37	:  0011_0000  0x30   48  0  
  38	:  0000_0001  0x01    1    
  39	:  0011_0000  0x30   48  0  
  40	:  0000_0001  0x01    1    
  41	:  0011_0000  0x30   48  0  
  42	:  0000_0001  0x01    1    
  43	:  0011_0000  0x30   48  0  
  44	:  0000_0001  0x01    1    
  45	:  0011_0000  0x30   48  0  
  46	:  0000_0001  0x01    1    
  47	:  0011_0000  0x30   48  0  
  48	:  0000_0001  0x01    1    
  49	:  0011_0000  0x30   48  0  
  50	:  0000_0001  0x01    1    
  51	:  0011_0000  0x30   48  0  
  52	:  0000_0001  0x01    1    
  53	:  0011_0001  0x31   49  1  
  54	:  0000_0001  0x01    1    
  55	:  0011_0000  0x30   48  0  
  56	:  0000_0001  0x01    1    
  57	:  0011_0000  0x30   48  0  
  58	:  0000_0001  0x01    1    
  59	:  0011_0000  0x30   48  0  
  60	:  0000_0001  0x01    1    
  61	:  0011_0000  0x30   48  0  
  62	:  0000_0001  0x01    1    
  63	:  0011_0000  0x30   48  0  
  64	:  0000_0001  0x01    1    
  65	:  0011_0101  0x35   53  5  
  66	:  0000_0001  0x01    1    
  67	:  0011_0000  0x30   48  0  
  68	:  0000_0001  0x01    1    
  69	:  0011_0001  0x31   49  1  
  70	:  0000_0001  0x01    1    
  71	:  0011_0000  0x30   48  0  
  72	:  0000_0001  0x01    1    
  73	:  0011_0000  0x30   48  0  
  74	:  0000_0001  0x01    1    
  75	:  0011_0010  0x32   50  2  
  76	:  0000_0011  0x03    3    
  77	:  0110_1001  0x69  105  i  
  78	:  0111_0000  0x70  112  p  
  79	:  0011_0110  0x36   54  6  
  80	:  0000_0100  0x04    4    
  81	:  0110_0001  0x61   97  a  
  82	:  0111_0010  0x72  114  r  
  83	:  0111_0000  0x70  112  p  
  84	:  0110_0001  0x61   97  a  
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  0000_1100  0x0C   12    
  88	:  0000_0000  0x00    0    
  89	:  0000_0001  0x01    1    
  90	:  1100_0000  0xC0  192    
  91	:  0000_1100  0x0C   12    
  92	:  0000_0000  0x00    0    
  93	:  0000_1100  0x0C   12    
  94	:  0000_0000  0x00    0    
  95	:  0000_0001  0x01    1    
  96	:  0000_0000  0x00    0    
  97	:  0000_0000  0x00    0    
  98	:  0010_1001  0x29   41  )  
  99	:  0010_1100  0x2C   44  ,  
  100	:  0000_0000  0x00    0    
  101	:  0001_0100  0x14   20    
  102	:  0000_0001  0x01    1    
  103	:  0110_1000  0x68  104  h  
  104	:  0000_1100  0x0C   12    
  105	:  0111_0010  0x72  114  r  
  106	:  0110_1111  0x6F  111  o  
  107	:  0110_1111  0x6F  111  o  
  108	:  0111_0100  0x74  116  t  
  109	:  0010_1101  0x2D   45  -  
  110	:  0111_0011  0x73  115  s  
  111	:  0110_0101  0x65  101  e  
  112	:  0111_0010  0x72  114  r  
  113	:  0111_0110  0x76  118  v  
  114	:  0110_0101  0x65  101  e  
  115	:  0111_0010  0x72  114  r  
  116	:  0111_0011  0x73  115  s  
  117	:  0000_0011  0x03    3    
  118	:  0110_1110  0x6E  110  n  
  119	:  0110_0101  0x65  101  e  
  120	:  0111_0100  0x74  116  t  
  121	:  0000_0000  0x00    0    
  122	:  1100_0000  0xC0  192    
  123	:  0011_0100  0x34   52  4  
  124	:  0000_0000  0x00    0    
  125	:  0000_0010  0x02    2    
  126	:  0000_0000  0x00    0    
  127	:  0000_0001  0x01    1    
  128	:  0000_0000  0x00    0    
  129	:  0000_0000  0x00    0    
  130	:  0010_1001  0x29   41  )  
  131	:  0010_1100  0x2C   44  ,  
  132	:  0000_0000  0x00    0    
  133	:  0000_1110  0x0E   14    
  134	:  0000_0011  0x03    3    
  135	:  0110_1110  0x6E  110  n  
  136	:  0111_0011  0x73  115  s  
  137	:  0011_0001  0x31   49  1  
  138	:  0000_0100  0x04    4    
  139	:  0110_1110  0x6E  110  n  
  140	:  0110_1111  0x6F  111  o  
  141	:  0111_0011  0x73  115  s  
  142	:  0110_0011  0x63   99  c  
  143	:  0000_0011  0x03    3    
  144	:  0110_1101  0x6D  109  m  
  145	:  0110_1001  0x69  105  i  
  146	:  0110_1100  0x6C  108  l  
  147	:  0000_0000  0x00    0    
  148	:  1100_0000  0xC0  192    
  149	:  0011_0100  0x34   52  4  
  150	:  0000_0000  0x00    0    
  151	:  0000_0010  0x02    2    
  152	:  0000_0000  0x00    0    
  153	:  0000_0001  0x01    1    
  154	:  0000_0000  0x00    0    
  155	:  0000_0000  0x00    0    
  156	:  0010_1001  0x29   41  )  
  157	:  0010_1100  0x2C   44  ,  
  158	:  0000_0000  0x00    0    
  159	:  0001_0000  0x10   16    
  160	:  0000_0011  0x03    3    
  161	:  0110_1110  0x6E  110  n  
  162	:  0111_0011  0x73  115  s  
  163	:  0011_0001  0x31   49  1  
  164	:  0000_0101  0x05    5    
  165	:  0110_1000  0x68  104  h  
  166	:  0111_0000  0x70  112  p  
  167	:  0110_0011  0x63   99  c  
  168	:  0110_1101  0x6D  109  m  
  169	:  0110_1111  0x6F  111  o  
  170	:  0000_0011  0x03    3    
  171	:  0110_1000  0x68  104  h  
  172	:  0111_0000  0x70  112  p  
  173	:  0110_0011  0x63   99  c  
  174	:  1100_0000  0xC0  192    
  175	:  1000_1111  0x8F  143    
  176	:  1100_0000  0xC0  192    
  177	:  0011_0100  0x34   52  4  
  178	:  0000_0000  0x00    0    
  179	:  0000_0010  0x02    2    
  180	:  0000_0000  0x00    0    
  181	:  0000_0001  0x01    1    
  182	:  0000_0000  0x00    0    
  183	:  0000_0000  0x00    0    
  184	:  0010_1001  0x29   41  )  
  185	:  0010_1100  0x2C   44  ,  
  186	:  0000_0000  0x00    0    
  187	:  0000_1111  0x0F   15    
  188	:  0000_0011  0x03    3    
  189	:  0110_1110  0x6E  110  n  
  190	:  0111_0011  0x73  115  s  
  191	:  0011_0001  0x31   49  1  
  192	:  0000_0011  0x03    3    
  193	:  0110_0001  0x61   97  a  
  194	:  0111_0010  0x72  114  r  
  195	:  0110_1100  0x6C  108  l  
  196	:  0000_0100  0x04    4    
  197	:  0110_0001  0x61   97  a  
  198	:  0111_0010  0x72  114  r  
  199	:  0110_1101  0x6D  109  m  
  200	:  0111_1001  0x79  121  y  
  201	:  1100_0000  0xC0  192    
  202	:  1000_1111  0x8F  143    
  203	:  1100_0000  0xC0  192    
  204	:  1011_1100  0xBC  188    
  205	:  0000_0000  0x00    0    
  206	:  0000_0001  0x01    1    
  207	:  0000_0000  0x00    0    
  208	:  0000_0001  0x01    1    
  209	:  0000_0000  0x00    0    
  210	:  0000_0000  0x00    0    
  211	:  0000_0000  0x00    0    
  212	:  0010_1000  0x28   40  (  
  213	:  0000_0000  0x00    0    
  214	:  0000_0100  0x04    4    
  215	:  1000_0000  0x80  128    
  216	:  0011_1111  0x3F   63  ?  
  217	:  0001_0000  0x10   16    
  218	:  0000_0100  0x04    4    
  219	:  1100_0000  0xC0  192    
  220	:  1000_0110  0x86  134    
  221	:  0000_0000  0x00    0    
  222	:  0000_0001  0x01    1    
  223	:  0000_0000  0x00    0    
  224	:  0000_0001  0x01    1    
  225	:  0000_0000  0x00    0    
  226	:  0000_0000  0x00    0    
  227	:  0000_0011  0x03    3    
  228	:  1110_0010  0xE2  226    
  229	:  0000_0000  0x00    0    
  230	:  0000_0100  0x04    4    
  231	:  1100_0110  0xC6  198    
  232	:  1111_1101  0xFD  253    
  233	:  0011_0000  0x30   48  0  
  234	:  0000_0111  0x07    7    
  235	:  1100_0000  0xC0  192    
  236	:  1010_0000  0xA0  160    
  237	:  0000_0000  0x00    0    
  238	:  0000_0001  0x01    1    
  239	:  0000_0000  0x00    0    
  240	:  0000_0001  0x01    1    
  241	:  0000_0000  0x00    0    
  242	:  0000_0000  0x00    0    
  243	:  0000_1101  0x0D   13    
  244	:  0000_1100  0x0C   12    
  245	:  0000_0000  0x00    0    
  246	:  0000_0100  0x04    4    
  247	:  1000_1100  0x8C  140    
  248	:  0010_0000  0x20   32     
  249	:  1111_0110  0xF6  246    
  250	:  0000_0100  0x04    4    
  251	:  1100_0000  0xC0  192    
  252	:  1010_0000  0xA0  160    
  253	:  0000_0000  0x00    0    
  254	:  0001_1100  0x1C   28    
  255	:  0000_0000  0x00    0    
  256	:  0000_0001  0x01    1    
  257	:  0000_0000  0x00    0    
  258	:  0000_0000  0x00    0    
  259	:  0000_1101  0x0D   13    
  260	:  0000_1100  0x0C   12    
  261	:  0000_0000  0x00    0    
  262	:  0001_0000  0x10   16    
  263	:  0010_0000  0x20   32     
  264	:  0000_0001  0x01    1    
  265	:  0000_0100  0x04    4    
  266	:  1000_0000  0x80  128    
  267	:  0000_0100  0x04    4    
  268	:  0011_0000  0x30   48  0  
  269	:  1101_1101  0xDD  221    
  270	:  1101_1101  0xDD  221    
  271	:  0000_0000  0x00    0    
  272	:  0000_0000  0x00    0    
  273	:  0000_0000  0x00    0    
  274	:  0000_0000  0x00    0    
  275	:  0000_0010  0x02    2    
  276	:  0100_0110  0x46   70  F  
  277	:  0000_0000  0x00    0    
  278	:  0000_0100  0x04    4    |;

# ; <<>> dig.pl 1.11 <<>> -d -t ptr 5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13837
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 3, ADDITIONAL: 4
# 
# ;; QUESTION SECTION:
# ;5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa.		IN	PTR
# 
# ;; ANSWER SECTION:
# 5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa.	10540	IN	PTR	h.root-servers.net. 
# 
# ;; AUTHORITY SECTION:
# 1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa.	10540	IN	NS	ns1.nosc.mil. 
# 1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa.	10540	IN	NS	ns1.hpcmo.hpc.mil. 
# 1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa.	10540	IN	NS	ns1.arl.army.mil. 
# 
# ;; ADDITIONAL SECTION:
# ns1.arl.army.mil.	40	IN	A	128.63.16.4 
# ns1.nosc.mil.	994	IN	A	198.253.48.7 
# ns1.hpcmo.hpc.mil.	3340	IN	A	140.32.246.4 
# ns1.hpcmo.hpc.mil.	3340	IN	AAAA	2001:480:430:DDDD:0:0:246:4 
# 
# ;; Query time: 60 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sat Oct  8 16:05:20 2011
# ;; MSG SIZE rcvd: 279 -- XFR size: 9 records
# 

my $a6ques = q
| 0	:  0011_0110  0x36   54  6  
  1	:  0010_0010  0x22   34  "  
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0001  0x01    1    
  13	:  0110_1000  0x68  104  h  
  14	:  0000_1100  0x0C   12    
  15	:  0111_0010  0x72  114  r  
  16	:  0110_1111  0x6F  111  o  
  17	:  0110_1111  0x6F  111  o  
  18	:  0111_0100  0x74  116  t  
  19	:  0010_1101  0x2D   45  -  
  20	:  0111_0011  0x73  115  s  
  21	:  0110_0101  0x65  101  e  
  22	:  0111_0010  0x72  114  r  
  23	:  0111_0110  0x76  118  v  
  24	:  0110_0101  0x65  101  e  
  25	:  0111_0010  0x72  114  r  
  26	:  0111_0011  0x73  115  s  
  27	:  0000_0011  0x03    3    
  28	:  0110_1110  0x6E  110  n  
  29	:  0110_0101  0x65  101  e  
  30	:  0111_0100  0x74  116  t  
  31	:  0000_0000  0x00    0    
  32	:  0000_0000  0x00    0    
  33	:  0001_1100  0x1C   28    
  34	:  0000_0000  0x00    0    
  35	:  0000_0001  0x01    1    |;

my $a6ans = q
| 0	:  0011_0110  0x36   54  6  
  1	:  0010_0010  0x22   34  "  
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_1101  0x0D   13    
  10	:  0000_0000  0x00    0    
  11	:  0000_1100  0x0C   12    
  12	:  0000_0001  0x01    1    
  13	:  0110_1000  0x68  104  h  
  14	:  0000_1100  0x0C   12    
  15	:  0111_0010  0x72  114  r  
  16	:  0110_1111  0x6F  111  o  
  17	:  0110_1111  0x6F  111  o  
  18	:  0111_0100  0x74  116  t  
  19	:  0010_1101  0x2D   45  -  
  20	:  0111_0011  0x73  115  s  
  21	:  0110_0101  0x65  101  e  
  22	:  0111_0010  0x72  114  r  
  23	:  0111_0110  0x76  118  v  
  24	:  0110_0101  0x65  101  e  
  25	:  0111_0010  0x72  114  r  
  26	:  0111_0011  0x73  115  s  
  27	:  0000_0011  0x03    3    
  28	:  0110_1110  0x6E  110  n  
  29	:  0110_0101  0x65  101  e  
  30	:  0111_0100  0x74  116  t  
  31	:  0000_0000  0x00    0    
  32	:  0000_0000  0x00    0    
  33	:  0001_1100  0x1C   28    
  34	:  0000_0000  0x00    0    
  35	:  0000_0001  0x01    1    
  36	:  1100_0000  0xC0  192    
  37	:  0000_1100  0x0C   12    
  38	:  0000_0000  0x00    0    
  39	:  0001_1100  0x1C   28    
  40	:  0000_0000  0x00    0    
  41	:  0000_0001  0x01    1    
  42	:  0000_0000  0x00    0    
  43	:  0000_0110  0x06    6    
  44	:  0101_0101  0x55   85  U  
  45	:  0111_0100  0x74  116  t  
  46	:  0000_0000  0x00    0    
  47	:  0001_0000  0x10   16    
  48	:  0010_0000  0x20   32     
  49	:  0000_0001  0x01    1    
  50	:  0000_0101  0x05    5    
  51	:  0000_0000  0x00    0    
  52	:  0000_0000  0x00    0    
  53	:  0000_0001  0x01    1    
  54	:  0000_0000  0x00    0    
  55	:  0000_0000  0x00    0    
  56	:  0000_0000  0x00    0    
  57	:  0000_0000  0x00    0    
  58	:  0000_0000  0x00    0    
  59	:  0000_0000  0x00    0    
  60	:  1000_0000  0x80  128    
  61	:  0011_1111  0x3F   63  ?  
  62	:  0000_0010  0x02    2    
  63	:  0011_0101  0x35   53  5  
  64	:  1100_0000  0xC0  192    
  65	:  0000_1110  0x0E   14    
  66	:  0000_0000  0x00    0    
  67	:  0000_0010  0x02    2    
  68	:  0000_0000  0x00    0    
  69	:  0000_0001  0x01    1    
  70	:  0000_0000  0x00    0    
  71	:  0000_0110  0x06    6    
  72	:  0101_0101  0x55   85  U  
  73	:  0111_0100  0x74  116  t  
  74	:  0000_0000  0x00    0    
  75	:  0000_0100  0x04    4    
  76	:  0000_0001  0x01    1    
  77	:  0110_0101  0x65  101  e  
  78	:  1100_0000  0xC0  192    
  79	:  0000_1110  0x0E   14    
  80	:  1100_0000  0xC0  192    
  81	:  0000_1110  0x0E   14    
  82	:  0000_0000  0x00    0    
  83	:  0000_0010  0x02    2    
  84	:  0000_0000  0x00    0    
  85	:  0000_0001  0x01    1    
  86	:  0000_0000  0x00    0    
  87	:  0000_0110  0x06    6    
  88	:  0101_0101  0x55   85  U  
  89	:  0111_0100  0x74  116  t  
  90	:  0000_0000  0x00    0    
  91	:  0000_0100  0x04    4    
  92	:  0000_0001  0x01    1    
  93	:  0110_0110  0x66  102  f  
  94	:  1100_0000  0xC0  192    
  95	:  0000_1110  0x0E   14    
  96	:  1100_0000  0xC0  192    
  97	:  0000_1110  0x0E   14    
  98	:  0000_0000  0x00    0    
  99	:  0000_0010  0x02    2    
  100	:  0000_0000  0x00    0    
  101	:  0000_0001  0x01    1    
  102	:  0000_0000  0x00    0    
  103	:  0000_0110  0x06    6    
  104	:  0101_0101  0x55   85  U  
  105	:  0111_0100  0x74  116  t  
  106	:  0000_0000  0x00    0    
  107	:  0000_0100  0x04    4    
  108	:  0000_0001  0x01    1    
  109	:  0110_1001  0x69  105  i  
  110	:  1100_0000  0xC0  192    
  111	:  0000_1110  0x0E   14    
  112	:  1100_0000  0xC0  192    
  113	:  0000_1110  0x0E   14    
  114	:  0000_0000  0x00    0    
  115	:  0000_0010  0x02    2    
  116	:  0000_0000  0x00    0    
  117	:  0000_0001  0x01    1    
  118	:  0000_0000  0x00    0    
  119	:  0000_0110  0x06    6    
  120	:  0101_0101  0x55   85  U  
  121	:  0111_0100  0x74  116  t  
  122	:  0000_0000  0x00    0    
  123	:  0000_0100  0x04    4    
  124	:  0000_0001  0x01    1    
  125	:  0110_0011  0x63   99  c  
  126	:  1100_0000  0xC0  192    
  127	:  0000_1110  0x0E   14    
  128	:  1100_0000  0xC0  192    
  129	:  0000_1110  0x0E   14    
  130	:  0000_0000  0x00    0    
  131	:  0000_0010  0x02    2    
  132	:  0000_0000  0x00    0    
  133	:  0000_0001  0x01    1    
  134	:  0000_0000  0x00    0    
  135	:  0000_0110  0x06    6    
  136	:  0101_0101  0x55   85  U  
  137	:  0111_0100  0x74  116  t  
  138	:  0000_0000  0x00    0    
  139	:  0000_0100  0x04    4    
  140	:  0000_0001  0x01    1    
  141	:  0110_1101  0x6D  109  m  
  142	:  1100_0000  0xC0  192    
  143	:  0000_1110  0x0E   14    
  144	:  1100_0000  0xC0  192    
  145	:  0000_1110  0x0E   14    
  146	:  0000_0000  0x00    0    
  147	:  0000_0010  0x02    2    
  148	:  0000_0000  0x00    0    
  149	:  0000_0001  0x01    1    
  150	:  0000_0000  0x00    0    
  151	:  0000_0110  0x06    6    
  152	:  0101_0101  0x55   85  U  
  153	:  0111_0100  0x74  116  t  
  154	:  0000_0000  0x00    0    
  155	:  0000_0100  0x04    4    
  156	:  0000_0001  0x01    1    
  157	:  0110_0001  0x61   97  a  
  158	:  1100_0000  0xC0  192    
  159	:  0000_1110  0x0E   14    
  160	:  1100_0000  0xC0  192    
  161	:  0000_1110  0x0E   14    
  162	:  0000_0000  0x00    0    
  163	:  0000_0010  0x02    2    
  164	:  0000_0000  0x00    0    
  165	:  0000_0001  0x01    1    
  166	:  0000_0000  0x00    0    
  167	:  0000_0110  0x06    6    
  168	:  0101_0101  0x55   85  U  
  169	:  0111_0100  0x74  116  t  
  170	:  0000_0000  0x00    0    
  171	:  0000_0100  0x04    4    
  172	:  0000_0001  0x01    1    
  173	:  0110_0100  0x64  100  d  
  174	:  1100_0000  0xC0  192    
  175	:  0000_1110  0x0E   14    
  176	:  1100_0000  0xC0  192    
  177	:  0000_1110  0x0E   14    
  178	:  0000_0000  0x00    0    
  179	:  0000_0010  0x02    2    
  180	:  0000_0000  0x00    0    
  181	:  0000_0001  0x01    1    
  182	:  0000_0000  0x00    0    
  183	:  0000_0110  0x06    6    
  184	:  0101_0101  0x55   85  U  
  185	:  0111_0100  0x74  116  t  
  186	:  0000_0000  0x00    0    
  187	:  0000_0100  0x04    4    
  188	:  0000_0001  0x01    1    
  189	:  0110_0010  0x62   98  b  
  190	:  1100_0000  0xC0  192    
  191	:  0000_1110  0x0E   14    
  192	:  1100_0000  0xC0  192    
  193	:  0000_1110  0x0E   14    
  194	:  0000_0000  0x00    0    
  195	:  0000_0010  0x02    2    
  196	:  0000_0000  0x00    0    
  197	:  0000_0001  0x01    1    
  198	:  0000_0000  0x00    0    
  199	:  0000_0110  0x06    6    
  200	:  0101_0101  0x55   85  U  
  201	:  0111_0100  0x74  116  t  
  202	:  0000_0000  0x00    0    
  203	:  0000_0100  0x04    4    
  204	:  0000_0001  0x01    1    
  205	:  0110_1011  0x6B  107  k  
  206	:  1100_0000  0xC0  192    
  207	:  0000_1110  0x0E   14    
  208	:  1100_0000  0xC0  192    
  209	:  0000_1110  0x0E   14    
  210	:  0000_0000  0x00    0    
  211	:  0000_0010  0x02    2    
  212	:  0000_0000  0x00    0    
  213	:  0000_0001  0x01    1    
  214	:  0000_0000  0x00    0    
  215	:  0000_0110  0x06    6    
  216	:  0101_0101  0x55   85  U  
  217	:  0111_0100  0x74  116  t  
  218	:  0000_0000  0x00    0    
  219	:  0000_0010  0x02    2    
  220	:  1100_0000  0xC0  192    
  221	:  0000_1100  0x0C   12    
  222	:  1100_0000  0xC0  192    
  223	:  0000_1110  0x0E   14    
  224	:  0000_0000  0x00    0    
  225	:  0000_0010  0x02    2    
  226	:  0000_0000  0x00    0    
  227	:  0000_0001  0x01    1    
  228	:  0000_0000  0x00    0    
  229	:  0000_0110  0x06    6    
  230	:  0101_0101  0x55   85  U  
  231	:  0111_0100  0x74  116  t  
  232	:  0000_0000  0x00    0    
  233	:  0000_0100  0x04    4    
  234	:  0000_0001  0x01    1    
  235	:  0110_0111  0x67  103  g  
  236	:  1100_0000  0xC0  192    
  237	:  0000_1110  0x0E   14    
  238	:  1100_0000  0xC0  192    
  239	:  0000_1110  0x0E   14    
  240	:  0000_0000  0x00    0    
  241	:  0000_0010  0x02    2    
  242	:  0000_0000  0x00    0    
  243	:  0000_0001  0x01    1    
  244	:  0000_0000  0x00    0    
  245	:  0000_0110  0x06    6    
  246	:  0101_0101  0x55   85  U  
  247	:  0111_0100  0x74  116  t  
  248	:  0000_0000  0x00    0    
  249	:  0000_0100  0x04    4    
  250	:  0000_0001  0x01    1    
  251	:  0110_1100  0x6C  108  l  
  252	:  1100_0000  0xC0  192    
  253	:  0000_1110  0x0E   14    
  254	:  1100_0000  0xC0  192    
  255	:  0000_1110  0x0E   14    
  256	:  0000_0000  0x00    0    
  257	:  0000_0010  0x02    2    
  258	:  0000_0000  0x00    0    
  259	:  0000_0001  0x01    1    
  260	:  0000_0000  0x00    0    
  261	:  0000_0110  0x06    6    
  262	:  0101_0101  0x55   85  U  
  263	:  0111_0100  0x74  116  t  
  264	:  0000_0000  0x00    0    
  265	:  0000_0100  0x04    4    
  266	:  0000_0001  0x01    1    
  267	:  0110_1010  0x6A  106  j  
  268	:  1100_0000  0xC0  192    
  269	:  0000_1110  0x0E   14    
  270	:  1100_0000  0xC0  192    
  271	:  1001_1100  0x9C  156    
  272	:  0000_0000  0x00    0    
  273	:  0000_0001  0x01    1    
  274	:  0000_0000  0x00    0    
  275	:  0000_0001  0x01    1    
  276	:  0000_0000  0x00    0    
  277	:  0000_0110  0x06    6    
  278	:  0101_0101  0x55   85  U  
  279	:  0111_0100  0x74  116  t  
  280	:  0000_0000  0x00    0    
  281	:  0000_0100  0x04    4    
  282	:  1100_0110  0xC6  198    
  283	:  0010_1001  0x29   41  )  
  284	:  0000_0000  0x00    0    
  285	:  0000_0100  0x04    4    
  286	:  1100_0000  0xC0  192    
  287	:  1001_1100  0x9C  156    
  288	:  0000_0000  0x00    0    
  289	:  0001_1100  0x1C   28    
  290	:  0000_0000  0x00    0    
  291	:  0000_0001  0x01    1    
  292	:  0000_0000  0x00    0    
  293	:  0000_0110  0x06    6    
  294	:  0101_0101  0x55   85  U  
  295	:  0111_0100  0x74  116  t  
  296	:  0000_0000  0x00    0    
  297	:  0001_0000  0x10   16    
  298	:  0010_0000  0x20   32     
  299	:  0000_0001  0x01    1    
  300	:  0000_0101  0x05    5    
  301	:  0000_0011  0x03    3    
  302	:  1011_1010  0xBA  186    
  303	:  0011_1110  0x3E   62  >  
  304	:  0000_0000  0x00    0    
  305	:  0000_0000  0x00    0    
  306	:  0000_0000  0x00    0    
  307	:  0000_0000  0x00    0    
  308	:  0000_0000  0x00    0    
  309	:  0000_0000  0x00    0    
  310	:  0000_0000  0x00    0    
  311	:  0000_0010  0x02    2    
  312	:  0000_0000  0x00    0    
  313	:  0011_0000  0x30   48  0  
  314	:  1100_0000  0xC0  192    
  315	:  1011_1100  0xBC  188    
  316	:  0000_0000  0x00    0    
  317	:  0000_0001  0x01    1    
  318	:  0000_0000  0x00    0    
  319	:  0000_0001  0x01    1    
  320	:  0000_0000  0x00    0    
  321	:  0000_0110  0x06    6    
  322	:  0101_0101  0x55   85  U  
  323	:  0111_0100  0x74  116  t  
  324	:  0000_0000  0x00    0    
  325	:  0000_0100  0x04    4    
  326	:  1100_0000  0xC0  192    
  327	:  1110_0100  0xE4  228    
  328	:  0100_1111  0x4F   79  O  
  329	:  1100_1001  0xC9  201    
  330	:  1100_0000  0xC0  192    
  331	:  0111_1100  0x7C  124  | .'|'. q|
  332	:  0000_0000  0x00    0    
  333	:  0000_0001  0x01    1    
  334	:  0000_0000  0x00    0    
  335	:  0000_0001  0x01    1    
  336	:  0000_0000  0x00    0    
  337	:  0000_0110  0x06    6    
  338	:  0101_0101  0x55   85  U  
  339	:  0111_0100  0x74  116  t  
  340	:  0000_0000  0x00    0    
  341	:  0000_0100  0x04    4    
  342	:  1100_0000  0xC0  192    
  343	:  0010_0001  0x21   33  !  
  344	:  0000_0100  0x04    4    
  345	:  0000_1100  0x0C   12    
  346	:  1100_0000  0xC0  192    
  347	:  1010_1100  0xAC  172    
  348	:  0000_0000  0x00    0    
  349	:  0000_0001  0x01    1    
  350	:  0000_0000  0x00    0    
  351	:  0000_0001  0x01    1    
  352	:  0000_0000  0x00    0    
  353	:  0000_0110  0x06    6    
  354	:  0101_0101  0x55   85  U  
  355	:  0111_0100  0x74  116  t  
  356	:  0000_0000  0x00    0    
  357	:  0000_0100  0x04    4    
  358	:  1000_0000  0x80  128    
  359	:  0000_1000  0x08    8    
  360	:  0000_1010  0x0A   10    
  361	:  0101_1010  0x5A   90  Z  
  362	:  1100_0000  0xC0  192    
  363	:  1010_1100  0xAC  172    
  364	:  0000_0000  0x00    0    
  365	:  0001_1100  0x1C   28    
  366	:  0000_0000  0x00    0    
  367	:  0000_0001  0x01    1    
  368	:  0000_0000  0x00    0    
  369	:  0000_0110  0x06    6    
  370	:  0101_0101  0x55   85  U  
  371	:  0111_0100  0x74  116  t  
  372	:  0000_0000  0x00    0    
  373	:  0001_0000  0x10   16    
  374	:  0010_0000  0x20   32     
  375	:  0000_0001  0x01    1    
  376	:  0000_0101  0x05    5    
  377	:  0000_0000  0x00    0    
  378	:  0000_0000  0x00    0    
  379	:  0010_1101  0x2D   45  -  
  380	:  0000_0000  0x00    0    
  381	:  0000_0000  0x00    0    
  382	:  0000_0000  0x00    0    
  383	:  0000_0000  0x00    0    
  384	:  0000_0000  0x00    0    
  385	:  0000_0000  0x00    0    
  386	:  0000_0000  0x00    0    
  387	:  0000_0000  0x00    0    
  388	:  0000_0000  0x00    0    
  389	:  0000_1101  0x0D   13    
  390	:  1100_0000  0xC0  192    
  391	:  0100_1100  0x4C   76  L  
  392	:  0000_0000  0x00    0    
  393	:  0000_0001  0x01    1    
  394	:  0000_0000  0x00    0    
  395	:  0000_0001  0x01    1    
  396	:  0000_0000  0x00    0    
  397	:  0000_0110  0x06    6    
  398	:  0101_0101  0x55   85  U  
  399	:  0111_0100  0x74  116  t  
  400	:  0000_0000  0x00    0    
  401	:  0000_0100  0x04    4    
  402	:  1100_0000  0xC0  192    
  403	:  1100_1011  0xCB  203    
  404	:  1110_0110  0xE6  230    
  405	:  0000_1010  0x0A   10    
  406	:  1100_0000  0xC0  192    
  407	:  0101_1100  0x5C   92  \  
  408	:  0000_0000  0x00    0    
  409	:  0000_0001  0x01    1    
  410	:  0000_0000  0x00    0    
  411	:  0000_0001  0x01    1    
  412	:  0000_0000  0x00    0    
  413	:  0000_0110  0x06    6    
  414	:  0101_0101  0x55   85  U  
  415	:  0111_0100  0x74  116  t  
  416	:  0000_0000  0x00    0    
  417	:  0000_0100  0x04    4    
  418	:  1100_0000  0xC0  192    
  419	:  0000_0101  0x05    5    
  420	:  0000_0101  0x05    5    
  421	:  1111_0001  0xF1  241    
  422	:  1100_0000  0xC0  192    
  423	:  0101_1100  0x5C   92  \  
  424	:  0000_0000  0x00    0    
  425	:  0001_1100  0x1C   28    
  426	:  0000_0000  0x00    0    
  427	:  0000_0001  0x01    1    
  428	:  0000_0000  0x00    0    
  429	:  0000_0110  0x06    6    
  430	:  0101_0101  0x55   85  U  
  431	:  0111_0100  0x74  116  t  
  432	:  0000_0000  0x00    0    
  433	:  0001_0000  0x10   16    
  434	:  0010_0000  0x20   32     
  435	:  0000_0001  0x01    1    
  436	:  0000_0101  0x05    5    
  437	:  0000_0000  0x00    0    
  438	:  0000_0000  0x00    0    
  439	:  0010_1111  0x2F   47  /  
  440	:  0000_0000  0x00    0    
  441	:  0000_0000  0x00    0    
  442	:  0000_0000  0x00    0    
  443	:  0000_0000  0x00    0    
  444	:  0000_0000  0x00    0    
  445	:  0000_0000  0x00    0    
  446	:  0000_0000  0x00    0    
  447	:  0000_0000  0x00    0    
  448	:  0000_0000  0x00    0    
  449	:  0000_1111  0x0F   15    
  450	:  1100_0000  0xC0  192    
  451	:  1110_1010  0xEA  234    
  452	:  0000_0000  0x00    0    
  453	:  0000_0001  0x01    1    
  454	:  0000_0000  0x00    0    
  455	:  0000_0001  0x01    1    
  456	:  0000_0000  0x00    0    
  457	:  0000_0110  0x06    6    
  458	:  0101_0101  0x55   85  U  
  459	:  0111_0100  0x74  116  t  
  460	:  0000_0000  0x00    0    
  461	:  0000_0100  0x04    4    
  462	:  1100_0000  0xC0  192    
  463	:  0111_0000  0x70  112  p  
  464	:  0010_0100  0x24   36  $  
  465	:  0000_0100  0x04    4    
  466	:  1100_0000  0xC0  192    
  467	:  0000_1100  0x0C   12    
  468	:  0000_0000  0x00    0    
  469	:  0000_0001  0x01    1    
  470	:  0000_0000  0x00    0    
  471	:  0000_0001  0x01    1    
  472	:  0000_0000  0x00    0    
  473	:  0000_0110  0x06    6    
  474	:  0101_0101  0x55   85  U  
  475	:  0111_0100  0x74  116  t  
  476	:  0000_0000  0x00    0    
  477	:  0000_0100  0x04    4    
  478	:  1000_0000  0x80  128    
  479	:  0011_1111  0x3F   63  ?  
  480	:  0000_0010  0x02    2    
  481	:  0011_0101  0x35   53  5  
  482	:  1100_0000  0xC0  192    
  483	:  0110_1100  0x6C  108  l  
  484	:  0000_0000  0x00    0    
  485	:  0000_0001  0x01    1    
  486	:  0000_0000  0x00    0    
  487	:  0000_0001  0x01    1    
  488	:  0000_0000  0x00    0    
  489	:  0000_0110  0x06    6    
  490	:  0101_0101  0x55   85  U  
  491	:  0111_0100  0x74  116  t  
  492	:  0000_0000  0x00    0    
  493	:  0000_0100  0x04    4    
  494	:  1100_0000  0xC0  192    
  495	:  0010_0100  0x24   36  $  
  496	:  1001_0100  0x94  148    
  497	:  0001_0001  0x11   17    |;

# ; <<>> dig.pl 1.11 <<>> -d -t aaaa h.root-servers.net
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13858
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 13, ADDITIONAL: 12
# 
# ;; QUESTION SECTION:
# ;h.root-servers.net.		IN	AAAA
# 
# ;; ANSWER SECTION:
# h.root-servers.net.	415092	IN	AAAA	2001:500:1:0:0:0:803F:235 
# 
# ;; AUTHORITY SECTION:
# root-servers.net.	415092	IN	NS	e.root-servers.net. 
# root-servers.net.	415092	IN	NS	f.root-servers.net. 
# root-servers.net.	415092	IN	NS	i.root-servers.net. 
# root-servers.net.	415092	IN	NS	c.root-servers.net. 
# root-servers.net.	415092	IN	NS	m.root-servers.net. 
# root-servers.net.	415092	IN	NS	a.root-servers.net. 
# root-servers.net.	415092	IN	NS	d.root-servers.net. 
# root-servers.net.	415092	IN	NS	b.root-servers.net. 
# root-servers.net.	415092	IN	NS	k.root-servers.net. 
# root-servers.net.	415092	IN	NS	h.root-servers.net. 
# root-servers.net.	415092	IN	NS	g.root-servers.net. 
# root-servers.net.	415092	IN	NS	l.root-servers.net. 
# root-servers.net.	415092	IN	NS	j.root-servers.net. 
# 
# ;; ADDITIONAL SECTION:
# a.root-servers.net.	415092	IN	A	198.41.0.4 
# a.root-servers.net.	415092	IN	AAAA	2001:503:BA3E:0:0:0:2:30 
# b.root-servers.net.	415092	IN	A	192.228.79.201 
# c.root-servers.net.	415092	IN	A	192.33.4.12 
# d.root-servers.net.	415092	IN	A	128.8.10.90 
# d.root-servers.net.	415092	IN	AAAA	2001:500:2D:0:0:0:0:D 
# e.root-servers.net.	415092	IN	A	192.203.230.10 
# f.root-servers.net.	415092	IN	A	192.5.5.241 
# f.root-servers.net.	415092	IN	AAAA	2001:500:2F:0:0:0:0:F 
# g.root-servers.net.	415092	IN	A	192.112.36.4 
# h.root-servers.net.	415092	IN	A	128.63.2.53 
# i.root-servers.net.	415092	IN	A	192.36.148.17 
# 
# ;; Query time: 79 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sat Oct  8 16:15:00 2011
# ;; MSG SIZE rcvd: 498 -- XFR size: 27 records
# 

my $naans1 = makebuf(\$aans1);
my $npans1 = makebuf(\$pans1);
my $nzans1 = makebuf(\$zans1);
my $np6ans = makebuf(\$p6ans);
my $na6ans = makebuf(\$a6ans);

my %answers = (
	'bad-name.com'	=> undef,	# 0
	'arpa.com'	=> $naans1,	# 1	A record for arpa.com
	'in-addr.arpa'	=> $npans1,	# 2	PTR record for 234.104.136.174.in-addr.arpa
	'no-name.com'	=> $nzans1,	# 3	zero answer count
    '5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa'
			=> $np6ans,	# 4	ipv6 ptr record for  h.root-servers.net => 2001:500:1::803f:235
	'h.root'	=> $na6ans,	# 5	AAAA record for h.root-servers.net
);

# dummy question builder for testing, does nothing
my $qn;
sub question {
  $qn = $_[0];
  return undef;
}

# dummy query responder for testing
{
	undef local $^W;
	*Net::DNS::Dig::_query = \&_query;
}
sub _query {
  my($here,$bp,$ns) = @_;
  return $answers{$ns};
}

*set_NS = \&Net::DNS::Dig::_set_NS;
&Net::DNS::Dig::_set_Help(0);			################## always take emulator branches

## test 2	check A record for IP address
my $host = '192.168.12.34';
my $netaddr = ndd_gethostbyname($host);
my $got = length($netaddr);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 3	check returned value
$got = inet_ntoa($netaddr);
print "got: $got, exp: $host\nnot "
	unless $got eq $host;
&ok;

## test 4	check a record for hostname (dummy) and use array context
set_NS(qw( bad-name.com arpa.com ));
$host = 'arpa.com';
my @rv = ndd_gethostbyname($host);
$got = length($rv[4]);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 5	check returned value
my $exp = '174.136.104.234';
$got = inet_ntoa($rv[4]);
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 6	check AAAA record for IP address
$host = '2001:500:1::803f:235';
@rv = ndd_gethostbyname($host);
$got = length($rv[4]);
print "return value length = $got, expected 16\nnot "
	unless $got == 16;
&ok;

## test 7	check returned value
$got = ipv6_n2x($rv[4]);
$exp = ipv6_n2x(ipv6_aton($host));
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 8	get host name by address
set_NS(qw( bad-name.com 5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa ));
# NOTE: name field contains netaddr from 2001:500:1::803f:235 above
@response = ndd_gethostbyaddr($rv[4]);
($got) = @response;
$exp = 'h.root-servers.net';
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 9       check for in-addr.arpa name conversion
$exp = '5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa';
print "got: $qn, exp: $exp\nnot "
        unless $qn eq $exp;
&ok;

## test 10	check a record for hostname (dummy) and use array context
set_NS(qw( bad-name.com h.root ));
$host = 'root-servers';
@rv = ndd_gethostbyname2($host,&AF_INET6);
$got = length($rv[4]);
print "return value length = $got, expected 16\nnot "
	unless $got == 16;
&ok;

## test 11	check returned value
$exp = ipv6_n2x(ipv6_aton('2001:500:1::803f:235'));
$got = ipv6_n2x($rv[4]);
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 12       check for in-addr.arpa name conversion
$exp = $host;
print "got: $qn, exp: $exp\nnot "
        unless $qn eq $exp;
&ok;

#########################################

## test 13	check A record for IP address
$host = '192.168.12.34';
$netaddr = ndd_gethostbyname2($host);
$got = length($netaddr);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 14	check returned value
$got = inet_ntoa($netaddr);
print "got: $got, exp: $host\nnot "
	unless $got eq $host;
&ok;

## test 15	check a record for hostname (dummy) and use array context
set_NS(qw( bad-name.com arpa.com ));
$host = 'arpa.com';
@rv = ndd_gethostbyname2($host);
$got = length($rv[4]);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 16	check returned value
$exp = '174.136.104.234';
$got = inet_ntoa($rv[4]);
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 17	check AAAA record for IP address
$host = '2001:500:1::803f:235';
@rv = ndd_gethostbyname2($host);
$got = length($rv[4]);
print "return value length = $got, expected 16\nnot "
	unless $got == 16;
&ok;

## test 18	check returned value
$got = ipv6_n2x($rv[4]);
$exp = ipv6_n2x(ipv6_aton($host));
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 19	get host name by address
set_NS(qw( bad-name.com 5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa ));
# NOTE: name field contains netaddr from 2001:500:1::803f:235 above
@response = ndd_gethostbyaddr($rv[4]);
($got) = @response;
$exp = 'h.root-servers.net';
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 20       check for in-addr.arpa name conversion
$exp = '5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa';
print "got: $qn, exp: $exp\nnot "
        unless $qn eq $exp;
&ok;

################################################

## test 21	check A record for IP address
$host = '192.168.12.34';
$netaddr = ndd_gethostbyname2($host,&AF_INET);
$got = length($netaddr);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 22	check returned value
$got = inet_ntoa($netaddr);
print "got: $got, exp: $host\nnot "
	unless $got eq $host;
&ok;

## test 23	check a record for hostname (dummy) and use array context
set_NS(qw( bad-name.com arpa.com ));
$host = 'arpa.com';
@rv = ndd_gethostbyname2($host,&AF_INET);
$got = length($rv[4]);
print "return value length = $got, expected 4\nnot "
	unless $got == 4;
&ok;

## test 24	check returned value
$exp = '174.136.104.234';
$got = inet_ntoa($rv[4]);
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 25	check AAAA record for IP address
$host = '2001:500:1::803f:235';
@rv = ndd_gethostbyname2($host,&AF_INET6);
$got = length($rv[4]);
print "return value length = $got, expected 16\nnot "
	unless $got == 16;
&ok;

## test 26	check returned value
$got = ipv6_n2x($rv[4]);
$exp = ipv6_n2x(ipv6_aton($host));
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 27	get host name by address
set_NS(qw( bad-name.com 5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa ));
# NOTE: name field contains netaddr from 2001:500:1::803f:235 above
@response = ndd_gethostbyaddr($rv[4],&AF_INET6);
($got) = @response;
$exp = 'h.root-servers.net';
print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 28       check for in-addr.arpa name conversion
$exp = '5.3.2.0.f.3.0.8.0.0.0.0.0.0.0.0.0.0.0.0.1.0.0.0.0.0.5.0.1.0.0.2.ip6.arpa';
print "got: $qn, exp: $exp\nnot "
        unless $qn eq $exp;
&ok;

