/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.latex3.L3Arg;
import java.io.IOException;
import java.util.Arrays;

public class LaTeX3GenericEnvironment
extends Declaration {
    private L3Arg[] argList;
    private boolean isModeSwitcher = false;
    TeXObjectList beginCode;
    TeXObjectList endCode;
    TeXObject[] params;

    public LaTeX3GenericEnvironment(String string, L3Arg[] l3ArgArray, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(string, l3ArgArray, false, teXObjectList, teXObjectList2);
    }

    public LaTeX3GenericEnvironment(String string, L3Arg[] l3ArgArray, boolean bl, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        super(string);
        this.argList = l3ArgArray;
        this.beginCode = teXObjectList;
        this.endCode = teXObjectList2;
    }

    @Override
    public Object clone() {
        return new LaTeX3GenericEnvironment(this.getName(), this.argList, (TeXObjectList)this.beginCode.clone(), (TeXObjectList)this.endCode.clone());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof LaTeX3GenericEnvironment)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LaTeX3GenericEnvironment laTeX3GenericEnvironment = (LaTeX3GenericEnvironment)object;
        if (!this.beginCode.equals(laTeX3GenericEnvironment.beginCode) || !this.endCode.equals(laTeX3GenericEnvironment.endCode)) {
            return false;
        }
        if (this.argList == null && laTeX3GenericEnvironment.argList == null) {
            return true;
        }
        if (this.argList == null || laTeX3GenericEnvironment.argList == null) {
            return false;
        }
        return Arrays.equals(this.argList, laTeX3GenericEnvironment.argList);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    protected TeXObjectList getBeginReplacement(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getReplacement(this.beginCode, teXParser, teXObjectList);
    }

    protected TeXObjectList getReplacement(TeXObjectList teXObjectList, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        if (this.argList == null) {
            return (TeXObjectList)teXObjectList.clone();
        }
        this.params = new TeXObject[this.argList.length];
        for (int i = 0; i < this.argList.length; ++i) {
            TeXObject teXObject = null;
            byte by = this.argList[i].getPopStyle();
            int n = this.argList[i].getToken1();
            int n2 = this.argList[i].getToken2();
            switch (this.argList[i].getId()) {
                case 79: 
                case 111: {
                    n = 91;
                    n2 = 93;
                }
                case 68: 
                case 82: 
                case 100: 
                case 114: {
                    teXObject = TeXParserUtils.popOptArg(by, teXParser, teXObjectList2, n, n2);
                    if (teXObject != null || (teXObject = this.argList[i].getDefaultValue()) == null) break;
                    teXObject = (TeXObject)teXObject.clone();
                    break;
                }
                case 109: {
                    teXObject = TeXParserUtils.popArg(teXParser, teXObjectList2, by);
                    break;
                }
                case 98: {
                    teXObject = this.popBody(teXParser, teXObjectList2, by);
                    if (!this.argList[i].isIgnoreSpace()) break;
                    teXObject = TeXParserUtils.trim(teXObject);
                    break;
                }
                case 99: {
                    teXObject = teXObjectList2 == teXParser || teXObjectList2 == null ? teXParser.popVerbToEndEnv(this.getName()) : this.popVerbBody(teXParser, teXObjectList2);
                    if (!this.argList[i].isIgnoreSpace()) break;
                    teXObject = TeXParserUtils.trim(teXObject);
                    break;
                }
                case 115: {
                    n = 42;
                }
                case 116: {
                    if (this.popModifier(teXParser, teXObjectList2, n) == n) {
                        teXObject = teXParser.getListener().getControlSequence("BooleanTrue");
                        break;
                    }
                    teXObject = teXParser.getListener().getControlSequence("BooleanFalse");
                    break;
                }
                default: {
                    throw new LaTeXSyntaxException(teXParser, "latex.unsupported.xparse_type", this.argList[i], this.toString(teXParser));
                }
            }
            if (teXObject == null) {
                teXObject = L3Arg.createNoValue(teXParser);
            }
            this.params[i] = teXObject;
        }
        TeXObjectList teXObjectList3 = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList3, this.params, teXObjectList);
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("Replacement: " + teXObjectList3);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("Replacement: " + teXObjectList3.toString(teXParser));
        }
        return teXObjectList3;
    }

    protected void addReplacements(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject[] teXObjectArray, TeXObjectList teXObjectList2) throws TeXSyntaxException {
        for (TeXObject teXObject : teXObjectList2) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit();
                if (teXObjectArray == null || n > teXObjectArray.length) {
                    throw new TeXSyntaxException(teXParser, "tex.error.illegal_param", n, this.toString(teXParser));
                }
                teXObjectList.add((TeXObject)teXObjectArray[--n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList.add((TeXObject)((DoubleParam)teXObject).next().clone());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
                teXObjectList.add(teXObjectList3);
                this.addReplacements(teXParser, teXObjectList3, teXObjectArray, (TeXObjectList)teXObject);
                continue;
            }
            teXObjectList.add((TeXObject)teXObject.clone());
        }
    }

    public String getLaTeXSyntaxString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.argList != null) {
            for (L3Arg l3Arg : this.argList) {
                stringBuilder.append(l3Arg.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isModeSwitcher() {
        return this.isModeSwitcher;
    }

    public TeXObjectList popBody(TeXParser teXParser, byte by) throws IOException {
        return this.popBody(teXParser, teXParser, by);
    }

    public TeXObjectList popBody(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        TeXObject teXObject = teXObjectList.pop();
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        while (teXObject != null) {
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof End) {
                String string = this.popLabelString(teXParser, teXObjectList);
                Group group = teXParser.getListener().createGroup(string);
                if (string.equals(this.getName())) {
                    teXObjectList.push(group);
                    teXObjectList.push(teXObject);
                    break;
                }
                teXObjectList2.add(teXObject);
                teXObjectList2.add(group);
            } else {
                teXObjectList2.add(teXObject);
            }
            teXObject = teXObjectList.pop();
        }
        return teXObjectList2;
    }

    public TeXObjectList popVerbBody(TeXParser teXParser) throws IOException {
        return this.popVerbBody(teXParser, teXParser);
    }

    public TeXObjectList popVerbBody(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        byte by = TeXObjectList.POP_RETAIN_IGNOREABLES;
        TeXObject teXObject = TeXParserUtils.pop(teXParser, teXObjectList, by);
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        while (teXObject != null) {
            if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("end")) {
                String string = this.popLabelString(teXParser, teXObjectList);
                Group group = teXParserListener.createGroup(string);
                if (string.equals(this.getName())) {
                    teXObjectList.push(group);
                    teXObjectList.push(teXObject);
                    break;
                }
                teXObjectList2.add(teXObject);
                teXObjectList2.add(group);
            } else if (teXObject instanceof Eol || teXObject instanceof Par) {
                teXObjectList2.add(teXParserListener.getControlSequence("obeyedline"));
            } else if (teXObject instanceof Comment) {
                teXObjectList2.add(teXParserListener.createString(new String(Character.toChars(teXParser.getCommentChar())) + ((Comment)teXObject).getText()));
                teXObjectList2.add(teXParserListener.getControlSequence("obeyedline"));
            } else {
                teXObjectList2.add(teXParserListener.createString(teXObject.toString(teXParser)));
            }
            teXObject = TeXParserUtils.pop(teXParser, teXObjectList, by);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (teXParser.isDebugMode(2048)) {
            teXParser.logMessage("Processing begin " + this.toString());
        }
        TeXObjectList teXObjectList = this.getBeginReplacement(teXParser, teXParser);
        teXObjectList.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isDebugMode(2048)) {
            teXParser.logMessage("Processing begin " + this.toString());
        }
        TeXObjectList teXObjectList2 = this.getBeginReplacement(teXParser, teXObjectList);
        teXObjectList2.process(teXParser, teXObjectList);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.endCode != null && !this.endCode.isEmpty()) {
            if (teXParser.isDebugMode(2048)) {
                teXParser.logMessage("Processing end " + this.toString());
            }
            TeXObjectList teXObjectList2 = new TeXObjectList();
            this.addReplacements(teXParser, teXObjectList2, this.params, this.endCode);
            if (teXParser.isDebugMode(32)) {
                teXParser.logMessage("Replacement: " + teXObjectList2);
            }
            if (teXParser.isDebugMode(16)) {
                teXParser.logMessage("Replacement: " + teXObjectList2.toString(teXParser));
            }
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,syntax=%s,modeSwitcher=%s,begin=%s,end=%s]", this.getClass().getSimpleName(), this.getName(), this.getLaTeXSyntaxString(), this.isModeSwitcher, this.beginCode, this.endCode);
    }
}

