#include "libpng/png.h"
#include "jpg.h"

#define PDF_INFO(N)     (N + image_tab)->image_struct.pdf
#define PNG_PTR(N)      (N + image_tab)->image_struct.png.png_ptr
#define PNG_INFO(N)     (N + image_tab)->image_struct.png.info_ptr
#define JPG_INFO(N)     (N + image_tab)->image_struct.jpg
#define IMG_TYPE(N)     (N + image_tab)->image_type
#define IMG_NAME(N)     (N + image_tab)->image_name
#define IMG_REFCOUNT(N) (N + image_tab)->ref_count

#define IMAGE_TYPE_PDF  0
#define IMAGE_TYPE_PNG  1
#define IMAGE_TYPE_JPG  2

typedef struct {
    png_structp png_ptr;
    png_infop info_ptr;
} png_image_struct;

typedef struct {
    integer bbox[4];
    void *doc;
    void *xref;
} pdf_image_struct;

typedef struct {
    short ref_count;          
    short image_type;
    char *image_name;
    union {
        pdf_image_struct *pdf;
        png_image_struct png;
        JPG_IMAGE_INFO *jpg;
    } image_struct;
} image_entry;

extern image_entry *image_ptr, *image_tab;
extern integer image_max;

extern integer read_pdf_info(integer);
extern void write_epdf(integer, integer);
extern void epdf_delete(integer);
extern void epdf_free();
extern integer read_png_info(integer);
extern void write_png(integer, integer);
extern integer read_jpg_info(integer);
extern void write_jpg(integer, integer);
