#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <GString.h>
#include <gmem.h>
#include "Object.h"
#include "Stream.h"
#include "Array.h"
#include "Dict.h"
#include "XRef.h"
#include "Catalog.h"
#include "Page.h"
#include "PDFDoc.h"
#include "Params.h"
#include "Error.h"
#include "config.h"
#include "epdf.h"

struct NewRef {
    Ref ref;    // ref in original PDF
    int newNum; // object number in output PDF
    NewRef *next; // next entry in list of indirect objects
};

// GBool printCommands = gFalse;
NewRef *newRefList;
static GBool isInit = gFalse;

int addNewRef(Ref *r) {
    //    NewRef *p, *q, *n = (NewRef *)gmalloc(sizeof(NewRef));
    NewRef *p, *q, *n = new NewRef[1];

    n->ref = *r;
    n->next = NULL;
    if (newRefList == NULL)
        newRefList = n;
    else {
        for (p = newRefList; p != NULL; p = p->next) {
            if (p->ref.num == r->num && p->ref.gen == r->gen) {
                // gfree(n);
                delete n;
                return p->newNum;
            }
            q = p;
        }
        q->next = n;
    }
    zpdfcreateobj(0, 0);
    return n->newNum = objptr;
}

void copyObject(Object *);
        
void copyDict(Object *obj, GBool isStreamDict) {
    Object obj1;
    int i;

    for (i = 0; i < obj->dictGetLength(); ++i) {
        if (isStreamDict &&
            (strcmp("Length", obj->dictGetKey(i)) == 0 ||
             strcmp("Filter", obj->dictGetKey(i)) == 0))
             continue;
        writeEPDF("/%s ", obj->dictGetKey(i));
        obj->dictGetValNF(i, &obj1);
        copyObject(&obj1);
        obj1.free();
        writeEPDF("\n");
    }
}

void copyStream(Object *obj) {
    int c;
    
    obj->streamReset();
    while ((c = obj->streamGetChar()) != EOF)
        pdfout(c);
}
    
void copyObject(Object *obj) {
    int  i;
    char *p;
    Object obj1;

    if (obj->isBool()) {
        writeEPDF("%s", obj->getBool() ? "true" : "false");
    }
    else if (obj->isInt()) {
        writeEPDF("%i", obj->getInt());
    }
    else if (obj->isReal()) {
        writeEPDF("%g", obj->getReal());
    }
    else if (obj->isNum()) {
        writeEPDF("%g", obj->getNum());
    }
    else if (obj->isString()) {
        writeEPDF("(");
        for (p = obj->getString()->getCString(); *p; p++)
            if (*p == '(' || *p == ')' || *p == '\\')
                writeEPDF("\\%c", *p);
            else if (!(*p > 0x20 && *p < 0x80 - 1))
                writeEPDF("\\%03o", *p);
            else
                pdfout(*p);
        writeEPDF(")");
    }
    else if (obj->isName()) {
        writeEPDF("/%s", obj->getName());
    }
    else if (obj->isNull()) {
    }
    else if (obj->isArray()) {
        writeEPDF("[ ");
        for (i = 0; i < obj->arrayGetLength(); ++i) {
            obj->arrayGetNF(i, &obj1);
            copyObject(&obj1);
            writeEPDF(" ");
            obj1.free();
        }
        writeEPDF("]");
    }
    else if (obj->isDict()) {
        writeEPDF("<<\n");
        copyDict(obj, gFalse);
        writeEPDF(">>");
    }
    else if (obj->isStream()) {
        obj1.initDict(obj->getStream()->getDict());
        writeEPDF("<<\n");
        copyDict(&obj1, gTrue);
        obj1.free();
        pdfbeginstream();
        copyStream(obj);
        pdfendstream();
    }
    else if (obj->isRef()) {
        writeEPDF("%d 0 R", addNewRef(&obj->getRef()));
    }
    else {
        error(-1, "type <%s> cannot be copied", obj->getTypeName());
    }
}

void writeRefs() {
    NewRef *r, *n;
    Object obj;

    for (r = newRefList; r != NULL; r = r->next) {
        zpdfbeginobj(r->newNum);
        xref->fetch(r->ref.num, r->ref.gen, &obj);
        copyObject(&obj);
        if (!obj.isStream())
            writeEPDF("\nendobj\n");
        obj.free();
    }
    for (r = newRefList; r != NULL; r = n) {
        n = r->next;
        // gfree(r);
        delete r;
    }
}

integer read_pdf_info(integer img) {
    PDFDoc *doc;
    GString *docName;
    Page *page;
    Object contents, obj, resources;

    // initialize
    if (!isInit) {
        isInit = gTrue;
        errorInit();
        initParams(xpdfConfigFile);
    }

    // open PDF file
    xref = NULL;
    docName = new GString(IMG_NAME(img));
    doc = new PDFDoc(docName);
    if (!doc->isOk() || !doc->okToPrint())
        return -1;
    PDF_INFO(img)->doc = (void *)doc;
    PDF_INFO(img)->xref = (void *)xref;

    // get the first page
    page = doc->getCatalog()->getPage(1);
    if (page->isCropped()) {
        PDF_INFO(img)->bbox[0] = page->getCropX1();
        PDF_INFO(img)->bbox[1] = page->getCropY1();
        PDF_INFO(img)->bbox[2] = page->getCropX2();
        PDF_INFO(img)->bbox[3] = page->getCropY2();
    }
    else {
        PDF_INFO(img)->bbox[0] = page->getX1();
        PDF_INFO(img)->bbox[1] = page->getY1();
        PDF_INFO(img)->bbox[2] = page->getX2();
        PDF_INFO(img)->bbox[3] = page->getY2();
    }
    return 0;
}

void write_epdf(integer n, integer img) {
    Page *page;
    Object contents, obj;
    int i;

    xref = (XRef *)PDF_INFO(img)->xref;
    page = ((PDFDoc *)PDF_INFO(img)->doc)->getCatalog()->getPage(1);
    newRefList = NULL;
    
    // write the Page header
    zpdfbegindict(n);
    writeEPDF("/Type /XObject\n");
    writeEPDF("/Subtype /Form\n");
    writeEPDF("/FormType 1\n");
    writeEPDF("/Matrix [1 0 0 1 0 0]\n");
    if (page->isCropped())
        writeEPDF("/BBox [%i %i %i %i]\n",
                  page->getCropX1(),
                  page->getCropY1(),
                  page->getCropX2(),
                  page->getCropY2());
    else
        writeEPDF("/BBox [%i %i %i %i]\n",
                  page->getX1(),
                  page->getY1(),
                  page->getX2(),
                  page->getY2());

    // write the Resources dictionary
    writeEPDF("/Resources ");
    obj.initDict(page->getResourceDict());
    copyObject(&obj);
    obj.free();
    writeEPDF("\n");

    // write the page contents
    page->getContents()->fetch(&contents);
    pdfbeginstream();
    if (contents.isArray()) {
        for (i = 0; i < contents.arrayGetLength(); ++i) {
            contents.arrayGet(i, &obj);
            if (!obj.isStream())
                fail("Weird page contents");
            copyStream(&obj);
            obj.free();
        }
    }
    else if (contents.isStream()) {
        copyStream(&contents);
    }
    else
        fail("Weird page contents");
    contents.free();
    pdfendstream();

    // write out all indirect objects
    writeRefs();
}

void epdf_delete(integer img) {
    xref = (XRef *)PDF_INFO(img)->xref;
    delete (PDFDoc *)PDF_INFO(img)->doc;
}

void epdf_free() {
    if (isInit) {
        freeParams();
        Object::memCheck(errFile);
        gMemReport(errFile);
    }
}
