# Makefile for libpdf - te@informatik.uni-hannover.de
INCLUDE=$(INCLUDE);../../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/programs.mak>
!include <make/library.mak>
!include "../kpathsea.mk"

DEFS = $(DEFS) -DHAVE_CONFIG_H $(PNG_FLAGS) $(ZLIB_FLAGS)
!IF (DEFINED(ZLIB_DLL) && DEFINED(PNG_DLL) && DEFINED(TIFF_DLL))
DEFS = $(DEFS) -DMAKE_TEX_DLL
!ELSE
DEFS = $(DEFS)
!ENDIF

XCPPFLAGS=-I.. -I$(srcdir)/.. -I../.. -I$(srcdir)/../..  \
	-I$(PNGLIBDIR) -I$(ZLIBDIR) -I$(TIFFLIBDIR) -DpdfTeX \
	-I../../dvipsk

DEFS = $(DEFS) -DHAVE_TIFF $(TIFF_FLAGS) 
XCPPFLAGS = $(XCPPFLAGS) -I$(TIFFLIBDIR)


RANLIB=
AR=lib

OBJS = $(objdir)\epdf.obj $(objdir)\mapfile.obj $(objdir)\papersiz.obj       \
	$(objdir)\utils.obj $(objdir)\config.obj $(objdir)\vfpacket.obj      \
	$(objdir)\pkin.obj $(objdir)\writefont.obj $(objdir)\writet1.obj     \
	$(objdir)\writet3.obj $(objdir)\writezip.obj $(objdir)\writeenc.obj  \
	$(objdir)\writettf.obj $(objdir)\writejpg.obj $(objdir)\writepng.obj \
	$(objdir)\writeimg.obj \
	$(objdir)\writetif.obj \
	$(objdir)\pdftoepdf.obj

all_subdirs = $(XPDFDIR)

all: libpdftoepdf $(objdir)\libpdf.lib
	for %%d in ($(all_subdirs)) do pushd %%d & $(MAKE) $@ & popd

$(objdir)\libpdf.lib: $(objdir) $(OBJS)
	$(AR) /OUT:$@  $(OBJS) 

libpdftoepdf: $(objdir)\libpdftoepdf.lib

$(objdir)\libpdftoepdf.lib: $(objdir) $(objdir)\pdftoepdf.obj $(xpdflib)
	$(archive_command) $(objdir)\pdftoepdf.obj $(xpdflib)

$(objdir)\pdftoepdf.obj: pdftoepdf.cc
	$(CC) -I$(XPDFDIR) -I$(XPDFDIR)/.. -I$(XPDFEXTRADIR) $(ALL_CFLAGS) /Tp pdftoepdf.cc

$(xpdflib):	
	pushd $(XPDFDIR) & $(MAKE) $(common_makeflags) all & popd

$(xpdfextralib):	
	pushd $(XPDFEXTRADIR) & $(MAKE) $(common_makeflags) all & popd

!include <make/tkpathsea.mak>

# Under Win32, I'd like to install zlib and libpng
install:: all
	$(mktexdir) $(bindir)
	for %%d in ($(all_subdirs)) do pushd %%d && $(MAKE) $@ && popd

mostlyclean clean::
	-@echo $(verbose) & for %%i in ($(all_subdirs)) do \
		echo Entering %%i for $@ \
		& pushd %%i & $(MAKE) $(makeflags) $@ & popd

distclean maintainer-clean extraclean:: clean
	-@$(RM) config.log config.status

!include <make/clean.mak>
!include <make/rdepend.mak>

!include "./depend.mak"

#
# Local Variables:
# mode: makefile
# End:
