/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.internal.ToolsKt;
import org.luaj.vm2.io.ByteArrayLuaBinOutput;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 \t2\u00020\u0001:\u0012\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/luaj/vm2/lib/StringLib;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "modname", "env", "Byte_", "Char_", "Companion", "Dump", "Find", "Format", "FormatDesc", "GMatchAux", "Gmatch", "Gsub", "Len", "Lower", "Match", "MatchState", "Rep", "Reverse", "Sub", "Upper", "luak"})
public final class StringLib
extends TwoArgFunction {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String FLAGS;
    private static final int L_ESC;
    @NotNull
    private static final LuaString SPECIALS;
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final int MASK_ALPHA = 1;
    private static final int MASK_LOWERCASE = 2;
    private static final int MASK_UPPERCASE = 4;
    private static final int MASK_DIGIT = 8;
    private static final int MASK_PUNCT = 16;
    private static final int MASK_SPACE = 32;
    private static final int MASK_CONTROL = 64;
    private static final int MASK_HEXDIGIT = 128;
    @NotNull
    private static final byte[] CHAR_TABLE;

    @Override
    @NotNull
    public LuaValue call(@NotNull LuaValue modname, @NotNull LuaValue env) {
        LuaTable string = new LuaTable();
        string.set("byte", (LuaValue)new Byte_());
        string.set("char", (LuaValue)new Char_());
        string.set("dump", (LuaValue)new Dump());
        string.set("find", (LuaValue)new Find());
        string.set("format", (LuaValue)new Format());
        string.set("gmatch", (LuaValue)new Gmatch());
        string.set("gsub", (LuaValue)new Gsub());
        string.set("len", (LuaValue)new Len());
        string.set("lower", (LuaValue)new Lower());
        string.set("match", (LuaValue)new Match());
        string.set("rep", (LuaValue)new Rep());
        string.set("reverse", (LuaValue)new Reverse());
        string.set("sub", (LuaValue)new Sub());
        string.set("upper", (LuaValue)new Upper());
        LuaValue[] luaValueArray = new LuaValue[]{LuaValue.Companion.getINDEX(), string};
        LuaTable mt = LuaValue.Companion.tableOf(luaValueArray);
        env.set("string", (LuaValue)string);
        env.get("package").get("loaded").set("string", (LuaValue)string);
        if (LuaString.Companion.getS_metatable() == null) {
            LuaString.Companion.setS_metatable(mt);
        }
        return string;
    }

    public static final /* synthetic */ LuaString access$getSPECIALS$cp() {
        return SPECIALS;
    }

    static {
        byte[] byArray;
        Companion = new Companion(null);
        FLAGS = "-+ #0";
        L_ESC = 37;
        SPECIALS = LuaValue.Companion.valueOf("^$*+?.([%-");
        byte[] CHAR_TABLE = byArray = new byte[256];
        boolean bl = false;
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            CHAR_TABLE[i] = (byte)((ToolsKt.isDigit(c) ? 8 : 0) | (ToolsKt.isLowerCase(c) ? 2 : 0) | (ToolsKt.isUpperCase(c) ? 4 : 0) | (Intrinsics.compare(c, 32) < 0 || c == '\u007f' ? 64 : 0));
            if (Intrinsics.compare(c, 97) >= 0 && Intrinsics.compare(c, 102) <= 0 || Intrinsics.compare(c, 65) >= 0 && Intrinsics.compare(c, 70) <= 0 || Intrinsics.compare(c, 48) >= 0 && Intrinsics.compare(c, 57) <= 0) {
                CHAR_TABLE[i] = (byte)(CHAR_TABLE[i] | 0x80);
            }
            if (Intrinsics.compare(c, 33) >= 0 && Intrinsics.compare(c, 47) <= 0 || Intrinsics.compare(c, 58) >= 0 && Intrinsics.compare(c, 64) <= 0) {
                CHAR_TABLE[i] = (byte)(CHAR_TABLE[i] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            CHAR_TABLE[i] = (byte)(CHAR_TABLE[i] | 1);
        }
        CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
        StringLib.CHAR_TABLE = byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Byte_;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Byte_
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString s;
            LuaString luaString = s = args.checkstring(1);
            Intrinsics.checkNotNull(luaString);
            int l = luaString.m_length;
            int posi = Companion.posrelat(args.optint(2, 1), l);
            int pose = Companion.posrelat(args.optint(3, posi), l);
            int n = 0;
            boolean i = false;
            if (posi <= 0) {
                posi = 1;
            }
            if (pose > l) {
                pose = l;
            }
            if (posi > pose) {
                return LuaValue.Companion.getNONE();
            }
            n = pose - posi + 1;
            if (posi + n <= pose) {
                LuaValue.Companion.error("string slice too long");
            }
            int n2 = 0;
            LuaValue[] luaValueArray = new LuaValue[n];
            LuaValue.Companion companion = LuaValue.Companion;
            while (n2 < n) {
                int n3 = n2++;
                luaValueArray[n3] = LuaValue.Companion.valueOf(s.luaByte(posi + n3 - 1));
            }
            return companion.varargsOf(luaValueArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Char_;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Char_
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            int n = args.narg();
            byte[] bytes = new byte[n];
            int i = 0;
            int a = 1;
            while (i < n) {
                int c = args.checkint(a);
                if (c < 0 || c >= 256) {
                    LuaValue.Companion.argerror(a, "invalid value");
                    throw new KotlinNothingValueException();
                }
                bytes[i] = (byte)c;
                ++i;
                ++a;
            }
            return LuaString.Companion.valueUsing$default(LuaString.Companion, bytes, 0, 0, null, 14, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Dump;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class Dump
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            LuaFunction f = arg.checkfunction();
            ByteArrayLuaBinOutput baos = new ByteArrayLuaBinOutput(0, 1, null);
            try {
                Intrinsics.checkNotNull(f, "null cannot be cast to non-null type org.luaj.vm2.LuaClosure");
                DumpState.Companion.dump(((LuaClosure)f).getP(), baos, true);
                return LuaString.Companion.valueUsing$default(LuaString.Companion, baos.toByteArray(), 0, 0, null, 14, null);
            }
            catch (IOException e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull(string);
                return LuaValue.Companion.error(string);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Find;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Find
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            return Companion.str_find_aux$luak(args, true);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Format;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Format
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString fmt;
            LuaString luaString = fmt = args.checkstring(1);
            Intrinsics.checkNotNull(luaString);
            int n = luaString.length();
            Buffer result2 = new Buffer(n);
            int arg = 1;
            int c = 0;
            int i = 0;
            while (i < n) {
                Format $this$invoke_u24lambda_u240 = this;
                boolean bl = false;
                int n2 = i;
                i = n2 + 1;
                c = fmt.luaByte(n2);
                int n3 = c;
                if (n3 == 10) {
                    result2.append("\n");
                    continue;
                }
                if (n3 == L_ESC) {
                    if (i >= n) continue;
                    Format $this$invoke_u24lambda_u241 = this;
                    boolean bl2 = false;
                    c = fmt.luaByte(i);
                    if (c == L_ESC) {
                        ++i;
                        result2.append((byte)L_ESC);
                        continue;
                    }
                    ++arg;
                    FormatDesc fdsc = new FormatDesc(args, fmt, i);
                    i += fdsc.getLength();
                    char c2 = (char)fdsc.getConversion();
                    if (c2 == 'c') {
                        fdsc.format(result2, (byte)args.checkint(arg));
                        continue;
                    }
                    if (c2 == 'i' ? true : c2 == 'd') {
                        fdsc.format(result2, args.checkint(arg));
                        continue;
                    }
                    if (((c2 == 'o' ? true : c2 == 'u') ? true : c2 == 'x') ? true : c2 == 'X') {
                        fdsc.format(result2, args.checklong(arg));
                        continue;
                    }
                    if ((((c2 == 'e' ? true : c2 == 'E') ? true : c2 == 'f') ? true : c2 == 'g') ? true : c2 == 'G') {
                        fdsc.format(result2, args.checkdouble(arg));
                        continue;
                    }
                    if (c2 == 'q') {
                        LuaString luaString2 = args.checkstring(arg);
                        Intrinsics.checkNotNull(luaString2);
                        Companion.addquoted(result2, luaString2);
                        continue;
                    }
                    if (c2 == 's') {
                        LuaString s = args.checkstring(arg);
                        if (fdsc.getPrecision() == -1) {
                            LuaString luaString3 = s;
                            Intrinsics.checkNotNull(luaString3);
                            if (luaString3.length() >= 100) {
                                result2.append(s);
                                continue;
                            }
                        }
                        LuaString luaString4 = s;
                        Intrinsics.checkNotNull(luaString4);
                        fdsc.format(result2, luaString4);
                        continue;
                    }
                    LuaValue.Companion.error("invalid option '%" + (char)fdsc.getConversion() + "' to 'format'");
                    continue;
                }
                result2.append((byte)c);
            }
            return result2.tostring();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/luaj/vm2/lib/StringLib$FormatDesc;", "", "args", "Lorg/luaj/vm2/Varargs;", "strfrmt", "Lorg/luaj/vm2/LuaString;", "start", "", "(Lorg/luaj/vm2/Varargs;Lorg/luaj/vm2/LuaString;I)V", "alternateForm", "", "conversion", "getConversion", "()I", "explicitPlus", "leftAdjust", "length", "getLength", "precision", "getPrecision", "setPrecision", "(I)V", "space", "width", "zeroPad", "format", "", "buf", "Lorg/luaj/vm2/Buffer;", "c", "", "x", "", "number", "", "s", "Companion", "luak"})
    public static final class FormatDesc {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean leftAdjust;
        private boolean zeroPad;
        private boolean explicitPlus;
        private boolean space;
        private boolean alternateForm;
        private int width;
        private int precision;
        private final int conversion;
        private final int length;
        private static final int MAX_FLAGS = 5;

        public FormatDesc(@NotNull Varargs args, @NotNull LuaString strfrmt, int start) {
            int n;
            int p = 0;
            p = start;
            int n2 = strfrmt.length();
            int c = 0;
            boolean moreFlags = true;
            while (moreFlags) {
                int n3;
                FormatDesc $this$_init__u24lambda_u240 = this;
                boolean bl = false;
                if (p < n2) {
                    int n4 = p;
                    p = n4 + 1;
                    n3 = strfrmt.luaByte(n4);
                } else {
                    n3 = 0;
                }
                c = n3;
                n = c;
                if (n == 45) {
                    this.leftAdjust = true;
                    continue;
                }
                if (n == 43) {
                    this.explicitPlus = true;
                    continue;
                }
                if (n == 32) {
                    this.space = true;
                    continue;
                }
                if (n == 35) {
                    this.alternateForm = true;
                    continue;
                }
                if (n == 48) {
                    this.zeroPad = true;
                    continue;
                }
                moreFlags = false;
            }
            if (p - start > MAX_FLAGS) {
                LuaValue.Companion.error("invalid format (repeated flags)");
            }
            this.width = -1;
            if (ToolsKt.isDigit((char)c)) {
                int n5;
                this.width = c - 48;
                if (p < n2) {
                    n = p;
                    p = n + 1;
                    n5 = strfrmt.luaByte(n);
                } else {
                    n5 = c = 0;
                }
                if (ToolsKt.isDigit((char)c)) {
                    int n6;
                    this.width = this.width * 10 + (c - 48);
                    if (p < n2) {
                        n = p;
                        p = n + 1;
                        n6 = strfrmt.luaByte(n);
                    } else {
                        n6 = 0;
                    }
                    c = n6;
                }
            }
            this.precision = -1;
            if (c == 46) {
                int n7;
                if (p < n2) {
                    n = p;
                    p = n + 1;
                    n7 = strfrmt.luaByte(n);
                } else {
                    n7 = c = 0;
                }
                if (ToolsKt.isDigit((char)c)) {
                    int n8;
                    this.precision = c - 48;
                    if (p < n2) {
                        n = p;
                        p = n + 1;
                        n8 = strfrmt.luaByte(n);
                    } else {
                        n8 = c = 0;
                    }
                    if (ToolsKt.isDigit((char)c)) {
                        int n9;
                        this.precision = this.precision * 10 + (c - 48);
                        if (p < n2) {
                            n = p;
                            p = n + 1;
                            n9 = strfrmt.luaByte(n);
                        } else {
                            n9 = c = 0;
                        }
                    }
                }
            }
            if (ToolsKt.isDigit((char)c)) {
                LuaValue.Companion.error("invalid format (width or precision too long)");
            }
            this.zeroPad &= !this.leftAdjust;
            this.conversion = c;
            this.length = p - start;
        }

        public final int getPrecision() {
            return this.precision;
        }

        public final void setPrecision(int n) {
            this.precision = n;
        }

        public final int getConversion() {
            return this.conversion;
        }

        public final int getLength() {
            return this.length;
        }

        public final void format(@NotNull Buffer buf, byte c) {
            buf.append(c);
        }

        public final void format(@NotNull Buffer buf, long number) {
            int nspaces;
            int minwidth;
            String digits = null;
            if (number == 0L && this.precision == 0) {
                digits = "";
            } else {
                int radix = 0;
                char c = (char)this.conversion;
                radix = (c == 'x' ? true : c == 'X') ? 16 : (c == 'o' ? 8 : 10);
                String string = Long.toString(number, CharsKt.checkRadix(radix));
                Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
                digits = string;
                if (this.conversion == 88) {
                    String string2 = digits.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase()");
                    digits = string2;
                }
            }
            int ndigits = minwidth = digits.length();
            int nzeros = 0;
            if (number < 0L) {
                --ndigits;
            } else if (this.explicitPlus || this.space) {
                ++minwidth;
            }
            nzeros = this.precision > ndigits ? this.precision - ndigits : (this.precision == -1 && this.zeroPad && this.width > minwidth ? this.width - minwidth : 0);
            int n = nspaces = this.width > (minwidth += nzeros) ? this.width - minwidth : 0;
            if (!this.leftAdjust) {
                Companion.pad(buf, ' ', nspaces);
            }
            if (number < 0L) {
                if (nzeros > 0) {
                    buf.append((byte)45);
                    String string = digits.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    digits = string;
                }
            } else if (this.explicitPlus) {
                buf.append((byte)43);
            } else if (this.space) {
                buf.append((byte)32);
            }
            if (nzeros > 0) {
                Companion.pad(buf, '0', nzeros);
            }
            buf.append(digits);
            if (this.leftAdjust) {
                Companion.pad(buf, ' ', nspaces);
            }
        }

        public final void format(@NotNull Buffer buf, double x) {
            buf.append(String.valueOf(x));
        }

        public final void format(@NotNull Buffer buf, @NotNull LuaString s) {
            LuaString s2 = s;
            int nullindex = s2.indexOf((byte)0, 0);
            if (nullindex != -1) {
                s2 = s2.substring(0, nullindex);
            }
            buf.append(s2);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/luaj/vm2/lib/StringLib$FormatDesc$Companion;", "", "()V", "MAX_FLAGS", "", "pad", "", "buf", "Lorg/luaj/vm2/Buffer;", "c", "", "n", "luak"})
        public static final class Companion {
            private Companion() {
            }

            public final void pad(@NotNull Buffer buf, char c, int n) {
                int n2 = n;
                byte b = (byte)c;
                while (n2-- > 0) {
                    buf.append(b);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Gmatch;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Gmatch
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString src = args.checkstring(1);
            LuaString pat = args.checkstring(2);
            LuaString luaString = src;
            Intrinsics.checkNotNull(luaString);
            LuaString luaString2 = pat;
            Intrinsics.checkNotNull(luaString2);
            return new GMatchAux(args, luaString, luaString2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/luaj/vm2/lib/StringLib$GMatchAux;", "Lorg/luaj/vm2/lib/VarArgFunction;", "args", "Lorg/luaj/vm2/Varargs;", "src", "Lorg/luaj/vm2/LuaString;", "pat", "(Lorg/luaj/vm2/Varargs;Lorg/luaj/vm2/LuaString;Lorg/luaj/vm2/LuaString;)V", "ms", "Lorg/luaj/vm2/lib/StringLib$MatchState;", "soffset", "", "srclen", "invoke", "luak"})
    public static final class GMatchAux
    extends VarArgFunction {
        private final int srclen;
        @NotNull
        private final MatchState ms;
        private int soffset;

        public GMatchAux(@NotNull Varargs args, @NotNull LuaString src, @NotNull LuaString pat) {
            this.srclen = src.length();
            this.ms = new MatchState(args, src, pat);
        }

        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            while (this.soffset < this.srclen) {
                this.ms.reset();
                int res = this.ms.match(this.soffset, 0);
                if (res >= 0) {
                    int soff = this.soffset;
                    this.soffset = res;
                    return this.ms.push_captures(true, soff, res);
                }
                int n = this.soffset;
                this.soffset = n + 1;
            }
            return LuaValue.Companion.getNIL();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Gsub;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Gsub
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString src;
            LuaString luaString = src = args.checkstring(1);
            Intrinsics.checkNotNull(luaString);
            int srclen = luaString.length();
            LuaString p = args.checkstring(2);
            LuaValue repl = args.arg(3);
            int max_s = args.optint(4, srclen + 1);
            LuaString luaString2 = p;
            Intrinsics.checkNotNull(luaString2);
            boolean anchor = luaString2.length() > 0 && p.charAt(0) == 94;
            Buffer lbuf = new Buffer(srclen);
            MatchState ms = new MatchState(args, src, p);
            int soffset = 0;
            int n = 0;
            while (n < max_s) {
                ms.reset();
                int res = ms.match(soffset, anchor ? 1 : 0);
                if (res != -1) {
                    ++n;
                    ms.add_value(lbuf, soffset, res, repl);
                }
                if (res != -1 && res > soffset) {
                    soffset = res;
                } else {
                    if (soffset >= srclen) break;
                    lbuf.append((byte)src.luaByte(soffset++));
                }
                if (!anchor) continue;
            }
            lbuf.append(src.substring(soffset, srclen));
            return LuaValue.Companion.varargsOf(lbuf.tostring(), (Varargs)LuaValue.Companion.valueOf(n));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Len;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class Len
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            LuaString luaString = arg.checkstring();
            Intrinsics.checkNotNull(luaString);
            return luaString.len();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Lower;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class Lower
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            String string = arg.checkjstring();
            Intrinsics.checkNotNull(string);
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
            return LuaValue.Companion.valueOf(string2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Match;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Match
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            return Companion.str_find_aux$luak(args, false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Rep;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Rep
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString s = args.checkstring(1);
            int n = args.checkint(2);
            LuaString luaString = s;
            Intrinsics.checkNotNull(luaString);
            byte[] bytes = new byte[luaString.length() * n];
            int len = s.length();
            for (int offset = 0; offset < bytes.length; offset += len) {
                s.copyInto(0, bytes, offset, len);
            }
            return LuaString.Companion.valueUsing$default(LuaString.Companion, bytes, 0, 0, null, 14, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Reverse;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class Reverse
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            LuaString s;
            LuaString luaString = s = arg.checkstring();
            Intrinsics.checkNotNull(luaString);
            int n = luaString.length();
            byte[] b = new byte[n];
            int i = 0;
            int j = n - 1;
            while (i < n) {
                b[j] = (byte)s.luaByte(i);
                ++i;
                --j;
            }
            return LuaString.Companion.valueUsing$default(LuaString.Companion, b, 0, 0, null, 14, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Sub;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class Sub
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            LuaString s;
            LuaString luaString = s = args.checkstring(1);
            Intrinsics.checkNotNull(luaString);
            int l = luaString.length();
            int start = Companion.posrelat(args.checkint(2), l);
            int end2 = Companion.posrelat(args.optint(3, -1), l);
            if (start < 1) {
                start = 1;
            }
            if (end2 > l) {
                end2 = l;
            }
            return start <= end2 ? (Varargs)s.substring(start - 1, end2) : (Varargs)LuaValue.Companion.getEMPTYSTRING();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/StringLib$Upper;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class Upper
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            String string = arg.checkjstring();
            Intrinsics.checkNotNull(string);
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase()");
            return LuaValue.Companion.valueOf(string2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0000\u0018\u0000 A2\u00020\u0001:\u0001AB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002J&\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0002J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0014J\u0016\u0010-\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014J\u0016\u0010/\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0014J\u0016\u00100\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014J\u0016\u00101\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014J\u001e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u0014J\u001e\u00106\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0014J\u001e\u00108\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0014J\u001e\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u0002032\u0006\u0010!\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014J \u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0006\u0010=\u001a\u00020\u001dJ\u001e\u0010>\u001a\u0002032\u0006\u00104\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0014J\u001e\u0010?\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006B"}, d2={"Lorg/luaj/vm2/lib/StringLib$MatchState;", "", "args", "Lorg/luaj/vm2/Varargs;", "s", "Lorg/luaj/vm2/LuaString;", "p", "(Lorg/luaj/vm2/Varargs;Lorg/luaj/vm2/LuaString;Lorg/luaj/vm2/LuaString;)V", "getArgs", "()Lorg/luaj/vm2/Varargs;", "cinit", "", "getCinit", "()[I", "setCinit", "([I)V", "clen", "getClen", "setClen", "level", "", "getLevel", "()I", "setLevel", "(I)V", "getP", "()Lorg/luaj/vm2/LuaString;", "getS", "add_s", "", "lbuf", "Lorg/luaj/vm2/Buffer;", "news", "soff", "e", "add_value", "soffset", "end", "repl", "Lorg/luaj/vm2/LuaValue;", "capture_to_close", "check_capture", "l", "classend", "poffset", "end_capture", "poff", "match", "match_capture", "matchbalance", "matchbracketclass", "", "c", "ec", "max_expand", "ep", "min_expand", "push_captures", "wholeMatch", "push_onecapture", "i", "reset", "singlematch", "start_capture", "what", "Companion", "luak"})
    public static final class MatchState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Varargs args;
        @NotNull
        private final LuaString s;
        @NotNull
        private final LuaString p;
        private int level;
        @NotNull
        private int[] cinit;
        @NotNull
        private int[] clen;

        public MatchState(@NotNull Varargs args, @NotNull LuaString s, @NotNull LuaString p) {
            this.args = args;
            this.s = s;
            this.p = p;
            this.cinit = new int[32];
            this.clen = new int[32];
        }

        @NotNull
        public final Varargs getArgs() {
            return this.args;
        }

        @NotNull
        public final LuaString getS() {
            return this.s;
        }

        @NotNull
        public final LuaString getP() {
            return this.p;
        }

        public final int getLevel() {
            return this.level;
        }

        public final void setLevel(int n) {
            this.level = n;
        }

        @NotNull
        public final int[] getCinit() {
            return this.cinit;
        }

        public final void setCinit(@NotNull int[] nArray) {
            this.cinit = nArray;
        }

        @NotNull
        public final int[] getClen() {
            return this.clen;
        }

        public final void setClen(@NotNull int[] nArray) {
            this.clen = nArray;
        }

        public final void reset() {
            this.level = 0;
        }

        private final void add_s(Buffer lbuf, LuaString news, int soff, int e) {
            int l = news.length();
            for (int i = 0; i < l; ++i) {
                byte b = (byte)news.luaByte(i);
                if (b != L_ESC) {
                    lbuf.append(b);
                    continue;
                }
                if (!ToolsKt.isDigit((char)(b = (byte)news.luaByte(++i)))) {
                    lbuf.append(b);
                    continue;
                }
                if (b == 48) {
                    lbuf.append(this.s.substring(soff, e));
                    continue;
                }
                LuaString luaString = this.push_onecapture(b - 49, soff, e).strvalue();
                Intrinsics.checkNotNull(luaString);
                lbuf.append(luaString);
            }
        }

        public final void add_value(@NotNull Buffer lbuf, int soffset, int end2, @NotNull LuaValue repl) {
            LuaValue repl2 = repl;
            switch (repl2.type()) {
                case 3: 
                case 4: {
                    LuaString luaString = repl2.strvalue();
                    Intrinsics.checkNotNull(luaString);
                    this.add_s(lbuf, luaString, soffset, end2);
                    return;
                }
                case 6: {
                    repl2 = repl2.invoke(this.push_captures(true, soffset, end2)).arg1();
                    break;
                }
                case 5: {
                    repl2 = repl2.get(this.push_onecapture(0, soffset, end2));
                    break;
                }
                default: {
                    LuaValue.Companion.error("bad argument: string/function/table expected");
                    return;
                }
            }
            if (!repl2.toboolean()) {
                repl2 = this.s.substring(soffset, end2);
            } else if (!repl2.isstring()) {
                LuaValue.Companion.error("invalid replacement value (a " + repl2.typename() + ')');
            }
            LuaString luaString = repl2.strvalue();
            Intrinsics.checkNotNull(luaString);
            lbuf.append(luaString);
        }

        @NotNull
        public final Varargs push_captures(boolean wholeMatch, int soff, int end2) {
            int nlevels = this.level == 0 && wholeMatch ? 1 : this.level;
            switch (nlevels) {
                case 0: {
                    return LuaValue.Companion.getNONE();
                }
                case 1: {
                    return this.push_onecapture(0, soff, end2);
                }
            }
            int n = 0;
            LuaValue[] luaValueArray = new LuaValue[nlevels];
            while (n < nlevels) {
                int n2 = n++;
                luaValueArray[n2] = this.push_onecapture(n2, soff, end2);
            }
            LuaValue[] v = luaValueArray;
            return LuaValue.Companion.varargsOf(v);
        }

        private final LuaValue push_onecapture(int i, int soff, int end2) {
            if (i >= this.level) {
                return i == 0 ? (LuaValue)this.s.substring(soff, end2) : LuaValue.Companion.error("invalid capture index");
            }
            int l = this.clen[i];
            if (l == -1) {
                return LuaValue.Companion.error("unfinished capture");
            }
            if (l == -2) {
                return LuaValue.Companion.valueOf(this.cinit[i] + 1);
            }
            int begin = this.cinit[i];
            return this.s.substring(begin, begin + l);
        }

        private final int check_capture(int l) {
            int l2 = l;
            if ((l2 -= 49) < 0 || l2 >= this.level || this.clen[l2] == -1) {
                LuaValue.Companion.error("invalid capture index");
            }
            return l2;
        }

        private final int capture_to_close() {
            int level = this.level;
            --level;
            while (level >= 0) {
                if (this.clen[level] == -1) {
                    return level;
                }
                --level;
            }
            LuaValue.Companion.error("invalid pattern capture");
            return 0;
        }

        public final int classend(int poffset) {
            int n;
            int poffset2 = poffset;
            if ((n = this.p.luaByte(poffset2++)) == L_ESC) {
                if (poffset2 == this.p.length()) {
                    LuaValue.Companion.error("malformed pattern (ends with %)");
                }
                return poffset2 + 1;
            }
            if (n == 91) {
                if (this.p.luaByte(poffset2) == 94) {
                    ++poffset2;
                }
                do {
                    if (poffset2 == this.p.length()) {
                        LuaValue.Companion.error("malformed pattern (missing ])");
                    }
                    if (this.p.luaByte(poffset2++) != L_ESC || poffset2 == this.p.length()) continue;
                    ++poffset2;
                } while (this.p.luaByte(poffset2) != 93);
                return poffset2 + 1;
            }
            return poffset2;
        }

        public final boolean matchbracketclass(int c, int poff, int ec) {
            int poff2 = poff;
            boolean sig = true;
            if (this.p.luaByte(poff2 + 1) == 94) {
                sig = false;
                ++poff2;
            }
            while (++poff2 < ec) {
                if (this.p.luaByte(poff2) == L_ESC) {
                    if (!Companion.match_class(c, this.p.luaByte(++poff2))) continue;
                    return sig;
                }
                if (this.p.luaByte(poff2 + 1) == 45 && poff2 + 2 < ec) {
                    if (this.p.luaByte((poff2 += 2) - 2) > c || c > this.p.luaByte(poff2)) continue;
                    return sig;
                }
                if (this.p.luaByte(poff2) != c) continue;
                return sig;
            }
            return !sig;
        }

        public final boolean singlematch(int c, int poff, int ep) {
            int n = this.p.luaByte(poff);
            if (n == 46) {
                return true;
            }
            if (n == L_ESC) {
                return Companion.match_class(c, this.p.luaByte(poff + 1));
            }
            if (n == 91) {
                return this.matchbracketclass(c, poff, ep - 1);
            }
            return this.p.luaByte(poff) == c;
        }

        public final int match(int soffset, int poffset) {
            int soffset2 = 0;
            soffset2 = soffset;
            int poffset2 = poffset;
            block10: while (poffset2 != this.p.length()) {
                int n = this.p.luaByte(poffset2);
                if (n == 40) {
                    return ++poffset2 < this.p.length() && this.p.luaByte(poffset2) == 41 ? this.start_capture(soffset2, poffset2 + 1, -2) : this.start_capture(soffset2, poffset2, -1);
                }
                if (n == 41) {
                    return this.end_capture(soffset2, poffset2 + 1);
                }
                if (n == L_ESC) {
                    if (poffset2 + 1 == this.p.length()) {
                        LuaValue.Companion.error("malformed pattern (ends with '%')");
                    }
                    switch (this.p.luaByte(poffset2 + 1)) {
                        case 98: {
                            soffset2 = this.matchbalance(soffset2, poffset2 + 2);
                            if (soffset2 == -1) {
                                return -1;
                            }
                            poffset2 += 4;
                            continue block10;
                        }
                        case 102: {
                            int previous;
                            if (this.p.luaByte(poffset2 += 2) != 91) {
                                LuaValue.Companion.error("Missing [ after %f in pattern");
                            }
                            int ep = this.classend(poffset2);
                            int n2 = previous = soffset2 == 0 ? -1 : this.s.luaByte(soffset2 - 1);
                            if (this.matchbracketclass(previous, poffset2, ep - 1) || this.matchbracketclass(this.s.luaByte(soffset2), poffset2, ep - 1)) {
                                return -1;
                            }
                            poffset2 = ep;
                            continue block10;
                        }
                    }
                    int c = this.p.luaByte(poffset2 + 1);
                    if (ToolsKt.isDigit((char)c)) {
                        return (soffset2 = this.match_capture(soffset2, c)) == -1 ? -1 : this.match(soffset2, poffset2 + 2);
                    }
                    if (poffset2 + 1 == this.p.length()) {
                        return soffset2 == this.s.length() ? soffset2 : -1;
                    }
                } else if (n == 36 && poffset2 + 1 == this.p.length()) {
                    return soffset2 == this.s.length() ? soffset2 : -1;
                }
                int ep = this.classend(poffset2);
                boolean m = soffset2 < this.s.length() && this.singlematch(this.s.luaByte(soffset2), poffset2, ep);
                int pc = ep < this.p.length() ? this.p.luaByte(ep) : 0;
                switch (pc) {
                    case 63: {
                        int res = 0;
                        if (m) {
                            MatchState $this$match_u24lambda_u240 = this;
                            boolean bl = false;
                            res = $this$match_u24lambda_u240.match(soffset2 + 1, ep + 1);
                            if (res != -1) {
                                return res;
                            }
                        }
                        poffset2 = ep + 1;
                        continue block10;
                    }
                    case 42: {
                        return this.max_expand(soffset2, poffset2, ep);
                    }
                    case 43: {
                        return m ? this.max_expand(soffset2 + 1, poffset2, ep) : -1;
                    }
                    case 45: {
                        return this.min_expand(soffset2, poffset2, ep);
                    }
                }
                if (!m) {
                    return -1;
                }
                int n3 = soffset2;
                soffset2 = n3 + 1;
                poffset2 = ep;
            }
            return soffset2;
        }

        public final int max_expand(int soff, int poff, int ep) {
            int i = 0;
            while (soff + i < this.s.length() && this.singlematch(this.s.luaByte(soff + i), poff, ep)) {
                ++i;
            }
            while (i >= 0) {
                int res = this.match(soff + i, ep + 1);
                if (res != -1) {
                    return res;
                }
                --i;
            }
            return -1;
        }

        public final int min_expand(int soff, int poff, int ep) {
            int soff2 = soff;
            while (true) {
                int res;
                if ((res = this.match(soff2, ep + 1)) != -1) {
                    return res;
                }
                if (soff2 >= this.s.length() || !this.singlematch(this.s.luaByte(soff2), poff, ep)) break;
                ++soff2;
            }
            return -1;
        }

        public final int start_capture(int soff, int poff, int what) {
            int res = 0;
            int level = this.level;
            if (level >= 32) {
                LuaValue.Companion.error("too many captures");
            }
            this.cinit[level] = soff;
            this.clen[level] = what;
            this.level = level + 1;
            MatchState $this$start_capture_u24lambda_u241 = this;
            boolean bl = false;
            res = $this$start_capture_u24lambda_u241.match(soff, poff);
            if (res == -1) {
                int n = this.level;
                this.level = n + -1;
            }
            return res;
        }

        public final int end_capture(int soff, int poff) {
            int l = this.capture_to_close();
            int res = 0;
            this.clen[l] = soff - this.cinit[l];
            MatchState $this$end_capture_u24lambda_u242 = this;
            boolean bl = false;
            res = $this$end_capture_u24lambda_u242.match(soff, poff);
            if (res == -1) {
                this.clen[l] = -1;
            }
            return res;
        }

        public final int match_capture(int soff, int l) {
            int l2 = l;
            l2 = this.check_capture(l2);
            int len = this.clen[l2];
            return this.s.length() - soff >= len && LuaString.Companion.equals(this.s, this.cinit[l2], this.s, soff, len) ? soff + len : -1;
        }

        public final int matchbalance(int soff, int poff) {
            int slen;
            int soff2 = soff;
            int plen = this.p.length();
            if (poff == plen || poff + 1 == plen) {
                LuaValue.Companion.error("unbalanced pattern");
            }
            if (soff2 >= (slen = this.s.length())) {
                return -1;
            }
            int b = this.p.luaByte(poff);
            if (this.s.luaByte(soff2) != b) {
                return -1;
            }
            int e = this.p.luaByte(poff + 1);
            int cont = 1;
            while (++soff2 < slen) {
                if (this.s.luaByte(soff2) == e) {
                    if (--cont != 0) continue;
                    return soff2 + 1;
                }
                if (this.s.luaByte(soff2) != b) continue;
                ++cont;
            }
            return -1;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/luaj/vm2/lib/StringLib$MatchState$Companion;", "", "()V", "match_class", "", "c", "", "cl", "luak"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean match_class(int c, int cl) {
                char lcl = Character.toLowerCase((char)cl);
                byte cdata = CHAR_TABLE[c];
                boolean res = false;
                char c2 = lcl;
                if (c2 == 'a') {
                    res = (cdata & 1) != 0;
                } else if (c2 == 'd') {
                    res = (cdata & 8) != 0;
                } else if (c2 == 'l') {
                    res = (cdata & 2) != 0;
                } else if (c2 == 'u') {
                    res = (cdata & 4) != 0;
                } else if (c2 == 'c') {
                    res = (cdata & 0x40) != 0;
                } else if (c2 == 'p') {
                    res = (cdata & 0x10) != 0;
                } else if (c2 == 's') {
                    res = (cdata & 0x20) != 0;
                } else if (c2 == 'w') {
                    res = (cdata & 9) != 0;
                } else if (c2 == 'x') {
                    res = (cdata & 0x80) != 0;
                } else if (c2 == 'z') {
                    res = c == 0;
                } else {
                    return cl == c;
                }
                return lcl == cl ? res : !res;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/luaj/vm2/lib/StringLib$Companion;", "", "()V", "CAP_POSITION", "", "CAP_UNFINISHED", "CHAR_TABLE", "", "FLAGS", "", "L_ESC", "MASK_ALPHA", "MASK_CONTROL", "MASK_DIGIT", "MASK_HEXDIGIT", "MASK_LOWERCASE", "MASK_PUNCT", "MASK_SPACE", "MASK_UPPERCASE", "MAX_CAPTURES", "SPECIALS", "Lorg/luaj/vm2/LuaString;", "addquoted", "", "buf", "Lorg/luaj/vm2/Buffer;", "s", "posrelat", "pos", "len", "str_find_aux", "Lorg/luaj/vm2/Varargs;", "args", "find", "", "str_find_aux$luak", "luak"})
    public static final class Companion {
        private Companion() {
        }

        private final void addquoted(Buffer buf, LuaString s) {
            int c = 0;
            buf.append((byte)34);
            int i = 0;
            int n = s.length();
            while (i < n) {
                Companion $this$addquoted_u24lambda_u240 = this;
                boolean bl = false;
                c = s.luaByte(i);
                int n2 = c;
                if ((n2 == 34 ? true : n2 == 92) ? true : n2 == 10) {
                    buf.append((byte)92);
                    buf.append((byte)c);
                } else if (c <= 31 || c == 127) {
                    buf.append((byte)92);
                    if (i + 1 == n || s.luaByte(i + 1) < 48 || s.luaByte(i + 1) > 57) {
                        String string = Integer.toString(c, CharsKt.checkRadix(10));
                        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
                        buf.append(string);
                    } else {
                        buf.append((byte)48);
                        buf.append((byte)(48 + c / 10));
                        buf.append((byte)(48 + c % 10));
                    }
                } else {
                    buf.append((byte)c);
                }
                n2 = i;
                i = n2 + 1;
            }
            buf.append((byte)34);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Varargs str_find_aux$luak(@NotNull Varargs args, boolean find) {
            s = args.checkstring(1);
            pat = args.checkstring(2);
            init = args.optint(3, 1);
            if (init > 0) {
                v0 = s;
                Intrinsics.checkNotNull(v0);
                init = Math.min(init - 1, v0.length());
            } else if (init < 0) {
                v1 = s;
                Intrinsics.checkNotNull(v1);
                init = Math.max(0, v1.length() + init);
            }
            if (!find) ** GOTO lbl-1000
            if (args.arg(4).toboolean()) ** GOTO lbl-1000
            v2 = pat;
            Intrinsics.checkNotNull(v2);
            if (v2.indexOfAny(StringLib.access$getSPECIALS$cp()) == -1) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = fastMatch = false;
            }
            if (fastMatch) {
                v4 = s;
                Intrinsics.checkNotNull(v4);
                v5 = pat;
                Intrinsics.checkNotNull(v5);
                result = v4.indexOf(v5, init);
                if (result != -1) {
                    return LuaValue.Companion.varargsOf(LuaValue.Companion.valueOf(result + 1), (Varargs)LuaValue.Companion.valueOf(result + pat.length()));
                }
            } else {
                v6 = s;
                Intrinsics.checkNotNull(v6);
                v7 = pat;
                Intrinsics.checkNotNull(v7);
                ms = new MatchState(args, v6, v7);
                anchor = false;
                poff = 0;
                if (pat.luaByte(0) == 94) {
                    anchor = true;
                    poff = 1;
                }
                soff = 0;
                soff = init;
                do {
                    res = 0;
                    ms.reset();
                    $this$str_find_aux_u24lambda_u241 = this;
                    $i$a$-run-StringLib$Companion$str_find_aux$1 = false;
                    res = ms.match(soff, poff);
                    if (res != -1) {
                        return find != false ? LuaValue.Companion.varargsOf(LuaValue.Companion.valueOf(soff + 1), LuaValue.Companion.valueOf(res), ms.push_captures(false, soff, res)) : ms.push_captures(true, soff, res);
                    }
                    var12_13 = soff;
                    soff = var12_13 + 1;
                } while (var12_13 < s.length() && !anchor);
            }
            return LuaValue.Companion.getNIL();
        }

        private final int posrelat(int pos, int len) {
            return pos >= 0 ? pos : len + pos + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

