return {

    name      = "indic transliterations",
    version   = "1.00",
    comment   = "Experimental code, the name of this file might change"
             .. "or maybe it become a llg file in the end.",
    author    = "Sreeram and Hans",
    copyright = "ConTeXt development team & whoever made this list",

    transliterations = {
        ["iast to deva"] = {
            mapping = {
                --- vowels
                ["a"] = "अ",
                ["ā"] = "आ",
                ["i"] = "इ",
                ["ī"] = "ई",
                ["u"] = "उ",
                ["ū"] = "ऊ",
                ["ṛ"] = "ऋ",
                ["ṝ"] = "ॠ",
                ["ḷ"] = "ऌ",
                ["ḹ"] = "ॡ",
                ["è"] = "ऎ",
                ["e"] = "ए",
                ["ai"] = "ऐ",
                ["ò"] = "ऒ",
                ["o"] = "ओ",
                ["au"] = "औ",
                --- consonant forms
                ["ka"] = "क",
                ["kā"] = "का",
                ["ki"] = "कि",
                ["kī"] = "की",
                ["ku"] = "कु",
                ["kū"] = "कू",
                ["ke"] = "के",
                ["ko"] = "को",
                ["kai"] = "कै",
                ["kau"] = "कौ",
                ["kḷ"] = "कॢ",
                ["kḹ"] = "कॣ",
                ["kṛ"] = "कृ",
                ["kṝ"] = "कॄ",
                ---
                ["kha"] = "ख",
                ["khā"] = "खा",
                ["khi"] = "खि",
                ["khī"] = "खी",
                ["khu"] = "खु",
                ["khū"] = "खू",
                ["khe"] = "खे",
                ["kho"] = "खो",
                ["khai"] = "खै",
                ["khau"] = "खौ",
                ["khḷ"] = "खॢ",
                ["khḹ"] = "खॣ",
                ["khṛ"] = "खृ",
                ["khṝ"] = "खॄ",
                ---
                ["ga"] = "ग",
                ["gā"] = "गा",
                ["gi"] = "गि",
                ["gī"] = "गी",
                ["gu"] = "गु",
                ["gū"] = "गू",
                ["ge"] = "गे",
                ["go"] = "गो",
                ["gai"] = "गै",
                ["gau"] = "गौ",
                ["gḷ"] = "गॢ",
                ["gḹ"] = "गॣ",
                ["gṛ"] = "गृ",
                ["gṝ"] = "गॄ",
                ---
                ["gha"] = "घ",
                ["ghā"] = "घा",
                ["ghi"] = "घि",
                ["ghī"] = "घी",
                ["ghu"] = "घु",
                ["ghū"] = "घू",
                ["ghe"] = "घे",
                ["gho"] = "घो",
                ["ghai"] = "घै",
                ["ghau"] = "घौ",
                ["ghḷ"] = "घॢ",
                ["ghḹ"] = "घॣ",
                ["ghṛ"] = "घृ",
                ["ghṝ"] = "घॄ",
                ---
                ["ṅa"] = "ङ",
                ["ṅā"] = "ङा",
                ["ṅi"] = "ङि",
                ["ṅī"] = "ङी",
                ["ṅu"] = "ङु",
                ["ṅū"] = "ङू",
                ["ṅe"] = "ङे",
                ["ṅo"] = "ङो",
                ["ṅai"] = "ङै",
                ["ṅau"] = "ङौ",
                ["ṅḷ"] = "ङॢ",
                ["ṅḹ"] = "ङॣ",
                ["ṅṛ"] = "ङृ",
                ["ṅṝ"] = "ङॄ",
                ---
                ["ca"] = "च",
                ["cā"] = "चा",
                ["ci"] = "चि",
                ["cī"] = "ची",
                ["cu"] = "चु",
                ["cū"] = "चू",
                ["ce"] = "चे",
                ["co"] = "चो",
                ["cai"] = "चै",
                ["cau"] = "चौ",
                ["cḷ"] = "चॢ",
                ["cḹ"] = "चॣ",
                ["cṛ"] = "चृ",
                ["cṝ"] = "चॄ",
                ---
                ["cha"] = "छ",
                ["chā"] = "छा",
                ["chi"] = "छि",
                ["chī"] = "छी",
                ["chu"] = "छु",
                ["chū"] = "छू",
                ["che"] = "छे",
                ["cho"] = "छो",
                ["chai"] = "छै",
                ["chau"] = "छौ",
                ["chḷ"] = "छॢ",
                ["chḹ"] = "छॣ",
                ["chṛ"] = "छृ",
                ["chṝ"] = "छॄ",
                ---
                ["ja"] = "ज",
                ["jā"] = "जा",
                ["ji"] = "जि",
                ["jī"] = "जी",
                ["ju"] = "जु",
                ["jū"] = "जू",
                ["je"] = "जे",
                ["jo"] = "जो",
                ["jai"] = "जै",
                ["jau"] = "जौ",
                ["jḷ"] = "जॢ",
                ["jḹ"] = "जॣ",
                ["jṛ"] = "जृ",
                ["jṝ"] = "जॄ",
                ---
                ["jha"] = "झ",
                ["jhā"] = "झा",
                ["jhi"] = "झि",
                ["jhī"] = "झी",
                ["jhu"] = "झु",
                ["jhū"] = "झू",
                ["jhe"] = "झे",
                ["jho"] = "झो",
                ["jhai"] = "झै",
                ["jhau"] = "झौ",
                ["jhḷ"] = "झॢ",
                ["jhḹ"] = "झॣ",
                ["jhṛ"] = "झृ",
                ["jhṝ"] = "झॄ",
                ---
                ["ña"] = "ञ",
                ["ñā"] = "ञा",
                ["ñi"] = "ञि",
                ["ñī"] = "ञी",
                ["ñu"] = "ञु",
                ["ñū"] = "ञू",
                ["ñe"] = "ञे",
                ["ño"] = "ञो",
                ["ñai"] = "ञै",
                ["ñau"] = "ञौ",
                ["ñḷ"] = "ञॢ",
                ["ñḹ"] = "ञॣ",
                ["ñṛ"] = "ञृ",
                ["ñṝ"] = "ञॄ",
                ---
                ["ṭa"] = "ट",
                ["ṭā"] = "टा",
                ["ṭi"] = "टि",
                ["ṭī"] = "टी",
                ["ṭu"] = "टु",
                ["ṭū"] = "टू",
                ["ṭe"] = "टे",
                ["ṭo"] = "टो",
                ["ṭai"] = "टै",
                ["ṭau"] = "टौ",
                ["ṭḷ"] = "टॢ",
                ["ṭḹ"] = "टॣ",
                ["ṭṛ"] = "टृ",
                ["ṭṝ"] = "टॄ",
                ---
                ["ṭha"] = "ठ",
                ["ṭhā"] = "ठा",
                ["ṭhi"] = "ठि",
                ["ṭhī"] = "ठी",
                ["ṭhu"] = "ठु",
                ["ṭhū"] = "ठू",
                ["ṭhe"] = "ठे",
                ["ṭho"] = "ठो",
                ["ṭhai"] = "ठै",
                ["ṭhau"] = "ठौ",
                ["ṭhḷ"] = "ठॢ",
                ["ṭhḹ"] = "ठॣ",
                ["ṭhṛ"] = "ठृ",
                ["ṭhṝ"] = "ठॄ",
                ---
                ["ḍa"] = "ड",
                ["ḍā"] = "डा",
                ["ḍi"] = "डि",
                ["ḍī"] = "डी",
                ["ḍu"] = "डु",
                ["ḍū"] = "डू",
                ["ḍe"] = "डे",
                ["ḍo"] = "डो",
                ["ḍai"] = "डै",
                ["ḍau"] = "डौ",
                ["ḍḷ"] = "डॢ",
                ["ḍḹ"] = "डॣ",
                ["ḍṛ"] = "डृ",
                ["ḍṝ"] = "डॄ",
                ---
                ["ḍha"] = "ढ",
                ["ḍhā"] = "ढा",
                ["ḍhi"] = "ढि",
                ["ḍhī"] = "ढी",
                ["ḍhu"] = "ढु",
                ["ḍhū"] = "ढू",
                ["ḍhe"] = "ढे",
                ["ḍho"] = "ढो",
                ["ḍhai"] = "ढै",
                ["ḍhau"] = "ढौ",
                ["ḍhḷ"] = "ढॢ",
                ["ḍhḹ"] = "ढॣ",
                ["ḍhṛ"] = "ढृ",
                ["ḍhṝ"] = "ढॄ",
                ---
                ["ṇa"] = "ण",
                ["ṇā"] = "णा",
                ["ṇi"] = "णि",
                ["ṇī"] = "णी",
                ["ṇu"] = "णु",
                ["ṇū"] = "णू",
                ["ṇe"] = "णे",
                ["ṇo"] = "णो",
                ["ṇai"] = "णै",
                ["ṇau"] = "णौ",
                ["ṇḷ"] = "णॢ",
                ["ṇḹ"] = "णॣ",
                ["ṇṛ"] = "णृ",
                ["ṇṝ"] = "णॄ",
                ---
                ["ta"] = "त",
                ["tā"] = "ता",
                ["ti"] = "ति",
                ["tī"] = "ती",
                ["tu"] = "तु",
                ["tū"] = "तू",
                ["te"] = "ते",
                ["to"] = "तो",
                ["tai"] = "तै",
                ["tau"] = "तौ",
                ["tḷ"] = "तॢ",
                ["tḹ"] = "तॣ",
                ["tṛ"] = "तृ",
                ["tṝ"] = "तॄ",
                ---
                ["tha"] = "थ",
                ["thā"] = "था",
                ["thi"] = "थि",
                ["thī"] = "थी",
                ["thu"] = "थु",
                ["thū"] = "थू",
                ["the"] = "थे",
                ["tho"] = "थो",
                ["thai"] = "थै",
                ["thau"] = "थौ",
                ["thḷ"] = "थॢ",
                ["thḹ"] = "थॣ",
                ["thṛ"] = "थृ",
                ["thṝ"] = "थॄ",
                ---
                ["da"] = "द",
                ["dā"] = "दा",
                ["di"] = "दि",
                ["dī"] = "दी",
                ["du"] = "दु",
                ["dū"] = "दू",
                ["de"] = "दे",
                ["do"] = "दो",
                ["dai"] = "दै",
                ["dau"] = "दौ",
                ["dḷ"] = "दॢ",
                ["dḹ"] = "दॣ",
                ["dṛ"] = "दृ",
                ["dṝ"] = "दॄ",
                ---
                ["dha"] = "ध",
                ["dhā"] = "धा",
                ["dhi"] = "धि",
                ["dhī"] = "धी",
                ["dhu"] = "धु",
                ["dhū"] = "धू",
                ["dhe"] = "धे",
                ["dho"] = "धो",
                ["dhai"] = "धै",
                ["dhau"] = "धौ",
                ["dhḷ"] = "धॢ",
                ["dhḹ"] = "धॣ",
                ["dhṛ"] = "धृ",
                ["dhṝ"] = "धॄ",
                ---
                ["na"] = "न",
                ["nā"] = "ना",
                ["ni"] = "नि",
                ["nī"] = "नी",
                ["nu"] = "नु",
                ["nū"] = "नू",
                ["ne"] = "ने",
                ["no"] = "नो",
                ["nai"] = "नै",
                ["nau"] = "नौ",
                ["nḷ"] = "नॢ",
                ["nḹ"] = "नॣ",
                ["nṛ"] = "नृ",
                ["nṝ"] = "नॄ",
                ---
                ["pa"] = "प",
                ["pā"] = "पा",
                ["pi"] = "पि",
                ["pī"] = "पी",
                ["pu"] = "पु",
                ["pū"] = "पू",
                ["pe"] = "पे",
                ["po"] = "पो",
                ["pai"] = "पै",
                ["pau"] = "पौ",
                ["pḷ"] = "पॢ",
                ["pḹ"] = "पॣ",
                ["pṛ"] = "पृ",
                ["pṝ"] = "पॄ",
                ---
                ["pha"] = "फ",
                ["phā"] = "फा",
                ["phi"] = "फि",
                ["phī"] = "फी",
                ["phu"] = "फु",
                ["phū"] = "फू",
                ["phe"] = "फे",
                ["pho"] = "फो",
                ["phai"] = "फै",
                ["phau"] = "फौ",
                ["phḷ"] = "फॢ",
                ["phḹ"] = "फॣ",
                ["phṛ"] = "फृ",
                ["phṝ"] = "फॄ",
                ---
                ["ba"] = "ब",
                ["bā"] = "बा",
                ["bi"] = "बि",
                ["bī"] = "बी",
                ["bu"] = "बु",
                ["bū"] = "बू",
                ["be"] = "बे",
                ["bo"] = "बो",
                ["bai"] = "बै",
                ["bau"] = "बौ",
                ["bḷ"] = "बॢ",
                ["bḹ"] = "बॣ",
                ["bṛ"] = "बृ",
                ["bṝ"] = "बॄ",
                ---
                ["bha"] = "भ",
                ["bhā"] = "भा",
                ["bhi"] = "भि",
                ["bhī"] = "भी",
                ["bhu"] = "भु",
                ["bhū"] = "भू",
                ["bhe"] = "भे",
                ["bho"] = "भो",
                ["bhai"] = "भै",
                ["bhau"] = "भौ",
                ["bhḷ"] = "भॢ",
                ["bhḹ"] = "भॣ",
                ["bhṛ"] = "भृ",
                ["bhṝ"] = "भॄ",
                ---
                ["ma"] = "म",
                ["mā"] = "मा",
                ["mi"] = "मि",
                ["mī"] = "मी",
                ["mu"] = "मु",
                ["mū"] = "मू",
                ["me"] = "मे",
                ["mo"] = "मो",
                ["mai"] = "मै",
                ["mau"] = "मौ",
                ["mḷ"] = "मॢ",
                ["mḹ"] = "मॣ",
                ["mṛ"] = "मृ",
                ["mṝ"] = "मॄ",
                ---
                ["ya"] = "य",
                ["yā"] = "या",
                ["yi"] = "यि",
                ["yī"] = "यी",
                ["yu"] = "यु",
                ["yū"] = "यू",
                ["ye"] = "ये",
                ["yo"] = "यो",
                ["yai"] = "यै",
                ["yau"] = "यौ",
                ["yḷ"] = "यॢ",
                ["yḹ"] = "यॣ",
                ["yṛ"] = "यृ",
                ["yṝ"] = "यॄ",
                ---
                ["ra"] = "र",
                ["rā"] = "रा",
                ["ri"] = "रि",
                ["rī"] = "री",
                ["ru"] = "रु",
                ["rū"] = "रू",
                ["re"] = "रे",
                ["ro"] = "रो",
                ["rai"] = "रै",
                ["rau"] = "रौ",
                ["rḷ"] = "रॢ",
                ["rḹ"] = "रॣ",
                ["rṛ"] = "रृ",
                ["rṝ"] = "रॄ",
                ---
                ["la"] = "ल",
                ["lā"] = "ला",
                ["li"] = "लि",
                ["lī"] = "ली",
                ["lu"] = "लु",
                ["lū"] = "लू",
                ["le"] = "ले",
                ["lo"] = "लो",
                ["lai"] = "लै",
                ["lau"] = "लौ",
                ["lḷ"] = "लॢ",
                ["lḹ"] = "लॣ",
                ["lṛ"] = "लृ",
                ["lṝ"] = "लॄ",
                ---
                ["va"] = "व",
                ["vā"] = "वा",
                ["vi"] = "वि",
                ["vī"] = "वी",
                ["vu"] = "वु",
                ["vū"] = "वू",
                ["ve"] = "वे",
                ["vo"] = "वो",
                ["vai"] = "वै",
                ["vau"] = "वौ",
                ["vḷ"] = "वॢ",
                ["vḹ"] = "वॣ",
                ["vṛ"] = "वृ",
                ["vṝ"] = "वॄ",
                ---
                ["śa"] = "श",
                ["śā"] = "शा",
                ["śi"] = "शि",
                ["śī"] = "शी",
                ["śu"] = "शु",
                ["śū"] = "शू",
                ["śe"] = "शे",
                ["śo"] = "शो",
                ["śai"] = "शै",
                ["śau"] = "शौ",
                ["śḷ"] = "शॢ",
                ["śḹ"] = "शॣ",
                ["śṛ"] = "शृ",
                ["śṝ"] = "शॄ",
                ---
                ["ṣa"] = "ष",
                ["ṣā"] = "षा",
                ["ṣi"] = "षि",
                ["ṣī"] = "षी",
                ["ṣu"] = "षु",
                ["ṣū"] = "षू",
                ["ṣe"] = "षे",
                ["ṣo"] = "षो",
                ["ṣai"] = "षै",
                ["ṣau"] = "षौ",
                ["ṣḷ"] = "षॢ",
                ["ṣḹ"] = "षॣ",
                ["ṣṛ"] = "षृ",
                ["ṣṝ"] = "षॄ",
                ---
                ["sa"] = "स",
                ["sā"] = "सा",
                ["si"] = "सि",
                ["sī"] = "सी",
                ["su"] = "सु",
                ["sū"] = "सू",
                ["se"] = "से",
                ["so"] = "सो",
                ["sai"] = "सै",
                ["sau"] = "सौ",
                ["sḷ"] = "सॢ",
                ["sḹ"] = "सॣ",
                ["sṛ"] = "सृ",
                ["sṝ"] = "सॄ",
                ---
                ["ha"] = "ह",
                ["hā"] = "हा",
                ["hi"] = "हि",
                ["hī"] = "ही",
                ["hu"] = "हु",
                ["hū"] = "हू",
                ["he"] = "हे",
                ["ho"] = "हो",
                ["hai"] = "है",
                ["hau"] = "हौ",
                ["hḷ"] = "हॢ",
                ["hḹ"] = "हॣ",
                ["hṛ"] = "हृ",
                ["hṝ"] = "हॄ",
                ---
                ["ḻa"] = "ळ",
                ["ḻā"] = "ळा",
                ["ḻi"] = "ळि",
                ["ḻī"] = "ळी",
                ["ḻu"] = "ळु",
                ["ḻū"] = "ळू",
                ["ḻe"] = "ळे",
                ["ḻo"] = "ळो",
                ["ḻai"] = "ळै",
                ["ḻau"] = "ळौ",
                ["ḻḷ"] = "ळॢ",
                ["ḻḹ"] = "ळॣ",
                ["ḻṛ"] = "ळृ",
                ["ḻṝ"] = "ळॄ",
                ---
                ["kṣa"] = "क्ष",
                ["kṣā"] = "क्षा",
                ["kṣi"] = "क्षि",
                ["kṣī"] = "क्षी",
                ["kṣu"] = "क्षु",
                ["kṣū"] = "क्षू",
                ["kṣe"] = "क्षे",
                ["kṣo"] = "क्षो",
                ["kṣai"] = "क्षै",
                ["kṣau"] = "क्षौ",
                ["kṣḷ"] = "क्षॢ",
                ["kṣḹ"] = "क्षॣ",
                ["kṣṛ"] = "क्षृ",
                ["kṣṝ"] = "क्षॄ",
                ---
                ["jña"] = "ज्ञ",
                ["jñā"] = "ज्ञा",
                ["jñi"] = "ज्ञि",
                ["jñī"] = "ज्ञी",
                ["jñu"] = "ज्ञु",
                ["jñū"] = "ज्ञू",
                ["jñe"] = "ज्ञे",
                ["jño"] = "ज्ञो",
                ["jñai"] = "ज्ञै",
                ["jñau"] = "ज्ञौ",
                ["jñḷ"] = "ज्ञॢ",
                ["jñḹ"] = "ज्ञॣ",
                ["jñṛ"] = "ज्ञृ",
                ["jñṝ"] = "ज्ञॄ",
                ---
                ["k"] = "क्",
                ["kh"] = "ख्",
                ["g"] = "ग्",
                ["gh"] = "घ्",
                ["ṅ"] = "ङ्",
                ["c"] = "च्",
                ["ch"] = "छ्",
                ["j"] = "ज्",
                ["jh"] = "झ्",
                ["ñ"] = "ञ्",
                ["ṭ"] = "ट्",
                ["ṭh"] = "ठ्",
                ["ḍ"] = "ड्",
                ["ḍh"] = "ढ्",
                ["ṇ"] = "ण्",
                ["t"] = "त्",
                ["th"] = "थ्",
                ["d"] = "द्",
                ["dh"] = "ध्",
                ["n"] = "न्",
                ["p"] = "प्",
                ["ph"] = "फ्",
                ["b"] = "ब्",
                ["bh"] = "भ्",
                ["m"] = "म्",
                ["y"] = "य्",
                ["r"] = "र्",
                ["l"] = "ल्",
                ["v"] = "व्",
                ["ś"] = "श्",
                ["ṣ"] = "ष्",
                ["s"] = "स्",
                ["h"] = "ह्",
                ["ḻ"] = "ळ्",
                ["kṣ"] = "क्ष्",
                ["jñ"] = "ज्ञ्",
                -- yogavaahas (always with phonetic)
                ["ṁ"] = "ं",
                ["ṃ"] = "ं",
                ["ḥ"] = "ः",
                ["ँ"] = "ँ",
                -- punctuations
                ["viraama"] = "्",
                ["."] = "।",
                ["|"] = "।",
                ["||"] = "॥",
                -- avagraha 
                ["'"] = "ऽ",  
            },
        },
        ["itrans to deva"] = {
            mapping = {
                --- vowels
                ["a"] = "अ",
                ["A"] = "आ",
                ["i"] = "इ",
                ["I"] = "ई",
                ["u"] = "उ",
                ["U"] = "ऊ",
                ["RRi"] = "ऋ",
                ["RRI"] = "ॠ",
                ["LLi"] = "ऌ",
                ["LLI"] = "ॡ",
                ["e"] = "ए",
                ["ai"] = "ऐ",
                ["o"] = "ओ",
                ["au"] = "औ",
                --- consonant forms
                ["ka"] = "क",
                ["kA"] = "का",
                ["ki"] = "कि",
                ["kI"] = "की",
                ["ku"] = "कु",
                ["kU"] = "कू",
                ["ke"] = "के",
                ["ko"] = "को",
                ["kai"] = "कै",
                ["kau"] = "कौ",
                ["kLLi"] = "कॢ",
                ["kLLI"] = "कॣ",
                ["kRRi"] = "कृ",
                ["kRRI"] = "कॄ",
                ---
                ["kha"] = "ख",
                ["khA"] = "खा",
                ["khi"] = "खि",
                ["khI"] = "खी",
                ["khu"] = "खु",
                ["khU"] = "खू",
                ["khe"] = "खे",
                ["kho"] = "खो",
                ["khai"] = "खै",
                ["khau"] = "खौ",
                ["khLLi"] = "खॢ",
                ["khLLI"] = "खॣ",
                ["khRRi"] = "खृ",
                ["khRRI"] = "खॄ",
                ---
                ["ga"] = "ग",
                ["gA"] = "गा",
                ["gi"] = "गि",
                ["gI"] = "गी",
                ["gu"] = "गु",
                ["gU"] = "गू",
                ["ge"] = "गे",
                ["go"] = "गो",
                ["gai"] = "गै",
                ["gau"] = "गौ",
                ["gLLi"] = "गॢ",
                ["gLLI"] = "गॣ",
                ["gRRi"] = "गृ",
                ["gRRI"] = "गॄ",
                ---
                ["gha"] = "घ",
                ["ghA"] = "घा",
                ["ghi"] = "घि",
                ["ghI"] = "घी",
                ["ghu"] = "घु",
                ["ghU"] = "घू",
                ["ghe"] = "घे",
                ["gho"] = "घो",
                ["ghai"] = "घै",
                ["ghau"] = "घौ",
                ["ghLLi"] = "घॢ",
                ["ghLLI"] = "घॣ",
                ["ghRRi"] = "घृ",
                ["ghRRI"] = "घॄ",
                ---
                ["~Na"] = "ङ",
                ["~NA"] = "ङा",
                ["~Ni"] = "ङि",
                ["~NI"] = "ङी",
                ["~Nu"] = "ङु",
                ["~NU"] = "ङू",
                ["~Ne"] = "ङे",
                ["~No"] = "ङो",
                ["~Nai"] = "ङै",
                ["~Nau"] = "ङौ",
                ["~NLLi"] = "ङॢ",
                ["~NLLI"] = "ङॣ",
                ["~NRRi"] = "ङृ",
                ["~NRRI"] = "ङॄ",
                ---
                ["ca"] = "च",
                ["cA"] = "चा",
                ["ci"] = "चि",
                ["cI"] = "ची",
                ["cu"] = "चु",
                ["cU"] = "चू",
                ["ce"] = "चे",
                ["co"] = "चो",
                ["cai"] = "चै",
                ["cau"] = "चौ",
                ["cLLi"] = "चॢ",
                ["cLLI"] = "चॣ",
                ["cRRi"] = "चृ",
                ["cRRI"] = "चॄ",
                ---
                ["cha"] = "छ",
                ["chA"] = "छा",
                ["chi"] = "छि",
                ["chI"] = "छी",
                ["chu"] = "छु",
                ["chU"] = "छू",
                ["che"] = "छे",
                ["cho"] = "छो",
                ["chai"] = "छै",
                ["chau"] = "छौ",
                ["chLLi"] = "छॢ",
                ["chLLI"] = "छॣ",
                ["chRRi"] = "छृ",
                ["chRRI"] = "छॄ",
                ---
                ["ja"] = "ज",
                ["jA"] = "जा",
                ["ji"] = "जि",
                ["jI"] = "जी",
                ["ju"] = "जु",
                ["jU"] = "जू",
                ["je"] = "जे",
                ["jo"] = "जो",
                ["jai"] = "जै",
                ["jau"] = "जौ",
                ["jLLi"] = "जॢ",
                ["jLLI"] = "जॣ",
                ["jRRi"] = "जृ",
                ["jRRI"] = "जॄ",
                ---
                ["jha"] = "झ",
                ["jhA"] = "झा",
                ["jhi"] = "झि",
                ["jhI"] = "झी",
                ["jhu"] = "झु",
                ["jhU"] = "झू",
                ["jhe"] = "झे",
                ["jho"] = "झो",
                ["jhai"] = "झै",
                ["jhau"] = "झौ",
                ["jhLLi"] = "झॢ",
                ["jhLLI"] = "झॣ",
                ["jhRRi"] = "झृ",
                ["jhRRI"] = "झॄ",
                ---
                ["~na"] = "ञ",
                ["~nA"] = "ञा",
                ["~ni"] = "ञि",
                ["~nI"] = "ञी",
                ["~nu"] = "ञु",
                ["~nU"] = "ञू",
                ["~ne"] = "ञे",
                ["~no"] = "ञो",
                ["~nai"] = "ञै",
                ["~nau"] = "ञौ",
                ["~nLLi"] = "ञॢ",
                ["~nLLI"] = "ञॣ",
                ["~nRRi"] = "ञृ",
                ["~nRRI"] = "ञॄ",
                ---
                ["Ta"] = "ट",
                ["TA"] = "टा",
                ["Ti"] = "टि",
                ["TI"] = "टी",
                ["Tu"] = "टु",
                ["TU"] = "टू",
                ["Te"] = "टे",
                ["To"] = "टो",
                ["Tai"] = "टै",
                ["Tau"] = "टौ",
                ["TLLi"] = "टॢ",
                ["TLLI"] = "टॣ",
                ["TRRi"] = "टृ",
                ["TRRI"] = "टॄ",
                ---
                ["Tha"] = "ठ",
                ["ThA"] = "ठा",
                ["Thi"] = "ठि",
                ["ThI"] = "ठी",
                ["Thu"] = "ठु",
                ["ThU"] = "ठू",
                ["The"] = "ठे",
                ["Tho"] = "ठो",
                ["Thai"] = "ठै",
                ["Thau"] = "ठौ",
                ["ThLLi"] = "ठॢ",
                ["ThLLI"] = "ठॣ",
                ["ThRRi"] = "ठृ",
                ["ThRRI"] = "ठॄ",
                ---
                ["Da"] = "ड",
                ["DA"] = "डा",
                ["Di"] = "डि",
                ["DI"] = "डी",
                ["Du"] = "डु",
                ["DU"] = "डू",
                ["De"] = "डे",
                ["Do"] = "डो",
                ["Dai"] = "डै",
                ["Dau"] = "डौ",
                ["DLLi"] = "डॢ",
                ["DLLI"] = "डॣ",
                ["DRRi"] = "डृ",
                ["DRRI"] = "डॄ",
                ---
                ["Dha"] = "ढ",
                ["DhA"] = "ढा",
                ["Dhi"] = "ढि",
                ["DhI"] = "ढी",
                ["Dhu"] = "ढु",
                ["DhU"] = "ढू",
                ["Dhe"] = "ढे",
                ["Dho"] = "ढो",
                ["Dhai"] = "ढै",
                ["Dhau"] = "ढौ",
                ["DhLLi"] = "ढॢ",
                ["DhLLI"] = "ढॣ",
                ["DhRRi"] = "ढृ",
                ["DhRRI"] = "ढॄ",
                ---
                ["Na"] = "ण",
                ["NA"] = "णा",
                ["Ni"] = "णि",
                ["NI"] = "णी",
                ["Nu"] = "णु",
                ["NU"] = "णू",
                ["Ne"] = "णे",
                ["No"] = "णो",
                ["Nai"] = "णै",
                ["Nau"] = "णौ",
                ["NLLi"] = "णॢ",
                ["NLLI"] = "णॣ",
                ["NRRi"] = "णृ",
                ["NRRI"] = "णॄ",
                ---
                ["ta"] = "त",
                ["tA"] = "ता",
                ["ti"] = "ति",
                ["tI"] = "ती",
                ["tu"] = "तु",
                ["tU"] = "तू",
                ["te"] = "ते",
                ["to"] = "तो",
                ["tai"] = "तै",
                ["tau"] = "तौ",
                ["tLLi"] = "तॢ",
                ["tLLI"] = "तॣ",
                ["tRRi"] = "तृ",
                ["tRRI"] = "तॄ",
                ---
                ["tha"] = "थ",
                ["thA"] = "था",
                ["thi"] = "थि",
                ["thI"] = "थी",
                ["thu"] = "थु",
                ["thU"] = "थू",
                ["the"] = "थे",
                ["tho"] = "थो",
                ["thai"] = "थै",
                ["thau"] = "थौ",
                ["thLLi"] = "थॢ",
                ["thLLI"] = "थॣ",
                ["thRRi"] = "थृ",
                ["thRRI"] = "थॄ",
                ---
                ["da"] = "द",
                ["dA"] = "दा",
                ["di"] = "दि",
                ["dI"] = "दी",
                ["du"] = "दु",
                ["dU"] = "दू",
                ["de"] = "दे",
                ["do"] = "दो",
                ["dai"] = "दै",
                ["dau"] = "दौ",
                ["dLLi"] = "दॢ",
                ["dLLI"] = "दॣ",
                ["dRRi"] = "दृ",
                ["dRRI"] = "दॄ",
                ---
                ["dha"] = "ध",
                ["dhA"] = "धा",
                ["dhi"] = "धि",
                ["dhI"] = "धी",
                ["dhu"] = "धु",
                ["dhU"] = "धू",
                ["dhe"] = "धे",
                ["dho"] = "धो",
                ["dhai"] = "धै",
                ["dhau"] = "धौ",
                ["dhLLi"] = "धॢ",
                ["dhLLI"] = "धॣ",
                ["dhRRi"] = "धृ",
                ["dhRRI"] = "धॄ",
                ---
                ["na"] = "न",
                ["nA"] = "ना",
                ["ni"] = "नि",
                ["nI"] = "नी",
                ["nu"] = "नु",
                ["nU"] = "नू",
                ["ne"] = "ने",
                ["no"] = "नो",
                ["nai"] = "नै",
                ["nau"] = "नौ",
                ["nLLi"] = "नॢ",
                ["nLLI"] = "नॣ",
                ["nRRi"] = "नृ",
                ["nRRI"] = "नॄ",
                ---
                ["pa"] = "प",
                ["pA"] = "पा",
                ["pi"] = "पि",
                ["pI"] = "पी",
                ["pu"] = "पु",
                ["pU"] = "पू",
                ["pe"] = "पे",
                ["po"] = "पो",
                ["pai"] = "पै",
                ["pau"] = "पौ",
                ["pLLi"] = "पॢ",
                ["pLLI"] = "पॣ",
                ["pRRi"] = "पृ",
                ["pRRI"] = "पॄ",
                ---
                ["pha"] = "फ",
                ["phA"] = "फा",
                ["phi"] = "फि",
                ["phI"] = "फी",
                ["phu"] = "फु",
                ["phU"] = "फू",
                ["phe"] = "फे",
                ["pho"] = "फो",
                ["phai"] = "फै",
                ["phau"] = "फौ",
                ["phLLi"] = "फॢ",
                ["phLLI"] = "फॣ",
                ["phRRi"] = "फृ",
                ["phRRI"] = "फॄ",
                ---
                ["ba"] = "ब",
                ["bA"] = "बा",
                ["bi"] = "बि",
                ["bI"] = "बी",
                ["bu"] = "बु",
                ["bU"] = "बू",
                ["be"] = "बे",
                ["bo"] = "बो",
                ["bai"] = "बै",
                ["bau"] = "बौ",
                ["bLLi"] = "बॢ",
                ["bLLI"] = "बॣ",
                ["bRRi"] = "बृ",
                ["bRRI"] = "बॄ",
                ---
                ["bha"] = "भ",
                ["bhA"] = "भा",
                ["bhi"] = "भि",
                ["bhI"] = "भी",
                ["bhu"] = "भु",
                ["bhU"] = "भू",
                ["bhe"] = "भे",
                ["bho"] = "भो",
                ["bhai"] = "भै",
                ["bhau"] = "भौ",
                ["bhLLi"] = "भॢ",
                ["bhLLI"] = "भॣ",
                ["bhRRi"] = "भृ",
                ["bhRRI"] = "भॄ",
                ---
                ["ma"] = "म",
                ["mA"] = "मा",
                ["mi"] = "मि",
                ["mI"] = "मी",
                ["mu"] = "मु",
                ["mU"] = "मू",
                ["me"] = "मे",
                ["mo"] = "मो",
                ["mai"] = "मै",
                ["mau"] = "मौ",
                ["mLLi"] = "मॢ",
                ["mLLI"] = "मॣ",
                ["mRRi"] = "मृ",
                ["mRRI"] = "मॄ",
                ---
                ["ya"] = "य",
                ["yA"] = "या",
                ["yi"] = "यि",
                ["yI"] = "यी",
                ["yu"] = "यु",
                ["yU"] = "यू",
                ["ye"] = "ये",
                ["yo"] = "यो",
                ["yai"] = "यै",
                ["yau"] = "यौ",
                ["yLLi"] = "यॢ",
                ["yLLI"] = "यॣ",
                ["yRRi"] = "यृ",
                ["yRRI"] = "यॄ",
                ---
                ["ra"] = "र",
                ["rA"] = "रा",
                ["ri"] = "रि",
                ["rI"] = "री",
                ["ru"] = "रु",
                ["rU"] = "रू",
                ["re"] = "रे",
                ["ro"] = "रो",
                ["rai"] = "रै",
                ["rau"] = "रौ",
                ["rLLi"] = "रॢ",
                ["rLLI"] = "रॣ",
                ["rRRi"] = "रृ",
                ["rRRI"] = "रॄ",
                ---
                ["la"] = "ल",
                ["lA"] = "ला",
                ["li"] = "लि",
                ["lI"] = "ली",
                ["lu"] = "लु",
                ["lU"] = "लू",
                ["le"] = "ले",
                ["lo"] = "लो",
                ["lai"] = "लै",
                ["lau"] = "लौ",
                ["lLLi"] = "लॢ",
                ["lLLI"] = "लॣ",
                ["lRRi"] = "लृ",
                ["lRRI"] = "लॄ",
                ---
                ["va"] = "व",
                ["vA"] = "वा",
                ["vi"] = "वि",
                ["vI"] = "वी",
                ["vu"] = "वु",
                ["vU"] = "वू",
                ["ve"] = "वे",
                ["vo"] = "वो",
                ["vai"] = "वै",
                ["vau"] = "वौ",
                ["vLLi"] = "वॢ",
                ["vLLI"] = "वॣ",
                ["vRRi"] = "वृ",
                ["vRRI"] = "वॄ",
                ---
                ["sha"] = "श",
                ["shA"] = "शा",
                ["shi"] = "शि",
                ["shI"] = "शी",
                ["shu"] = "शु",
                ["shU"] = "शू",
                ["she"] = "शे",
                ["sho"] = "शो",
                ["shai"] = "शै",
                ["shau"] = "शौ",
                ["shLLi"] = "शॢ",
                ["shLLI"] = "शॣ",
                ["shRRi"] = "शृ",
                ["shRRI"] = "शॄ",
                ---
                ["Sha"] = "ष",
                ["ShA"] = "षा",
                ["Shi"] = "षि",
                ["ShI"] = "षी",
                ["Shu"] = "षु",
                ["ShU"] = "षू",
                ["She"] = "षे",
                ["Sho"] = "षो",
                ["Shai"] = "षै",
                ["Shau"] = "षौ",
                ["ShLLi"] = "षॢ",
                ["ShLLI"] = "षॣ",
                ["ShRRi"] = "षृ",
                ["ShRRI"] = "षॄ",
                ---
                ["sa"] = "स",
                ["sA"] = "सा",
                ["si"] = "सि",
                ["sI"] = "सी",
                ["su"] = "सु",
                ["sU"] = "सू",
                ["se"] = "से",
                ["so"] = "सो",
                ["sai"] = "सै",
                ["sau"] = "सौ",
                ["sLLi"] = "सॢ",
                ["sLLI"] = "सॣ",
                ["sRRi"] = "सृ",
                ["sRRI"] = "सॄ",
                ---
                ["ha"] = "ह",
                ["hA"] = "हा",
                ["hi"] = "हि",
                ["hI"] = "ही",
                ["hu"] = "हु",
                ["hU"] = "हू",
                ["he"] = "हे",
                ["ho"] = "हो",
                ["hai"] = "है",
                ["hau"] = "हौ",
                ["hLLi"] = "हॢ",
                ["hLLI"] = "हॣ",
                ["hRRi"] = "हृ",
                ["hRRI"] = "हॄ",
                ---
                ["ḻa"] = "ळ",
                ["ḻA"] = "ळा",
                ["ḻi"] = "ळि",
                ["ḻI"] = "ळी",
                ["ḻu"] = "ळु",
                ["ḻU"] = "ळू",
                ["ḻe"] = "ळे",
                ["ḻo"] = "ळो",
                ["ḻai"] = "ळै",
                ["ḻau"] = "ळौ",
                ["ḻLLi"] = "ळॢ",
                ["ḻLLI"] = "ळॣ",
                ["ḻRRi"] = "ळृ",
                ["ḻRRI"] = "ळॄ",
                ---
                ["xa"] = "क्ष",
                ["xA"] = "क्षा",
                ["xi"] = "क्षि",
                ["xI"] = "क्षी",
                ["xu"] = "क्षु",
                ["xU"] = "क्षू",
                ["xe"] = "क्षे",
                ["xo"] = "क्षो",
                ["xai"] = "क्षै",
                ["xau"] = "क्षौ",
                ["xLLi"] = "क्षॢ",
                ["xLLI"] = "क्षॣ",
                ["xRRi"] = "क्षृ",
                ["xRRI"] = "क्षॄ",
                ---
                ["j~na"] = "ज्ञ",
                ["j~nA"] = "ज्ञा",
                ["j~ni"] = "ज्ञि",
                ["j~nI"] = "ज्ञी",
                ["j~nu"] = "ज्ञु",
                ["j~nU"] = "ज्ञू",
                ["j~ne"] = "ज्ञे",
                ["j~no"] = "ज्ञो",
                ["j~nai"] = "ज्ञै",
                ["j~nau"] = "ज्ञौ",
                ["j~nLLi"] = "ज्ञॢ",
                ["j~nLLI"] = "ज्ञॣ",
                ["j~nRRi"] = "ज्ञृ",
                ["j~nRRI"] = "ज्ञॄ",
                ---
                ["k"] = "क्",
                ["kh"] = "ख्",
                ["g"] = "ग्",
                ["gh"] = "घ्",
                ["~N"] = "ङ्",
                ["c"] = "च्",
                ["ch"] = "छ्",
                ["j"] = "ज्",
                ["jh"] = "झ्",
                ["~n"] = "ञ्",
                ["T"] = "ट्",
                ["Th"] = "ठ्",
                ["D"] = "ड्",
                ["Dh"] = "ढ्",
                ["N"] = "ण्",
                ["t"] = "त्",
                ["th"] = "थ्",
                ["d"] = "द्",
                ["dh"] = "ध्",
                ["n"] = "न्",
                ["p"] = "प्",
                ["ph"] = "फ्",
                ["b"] = "ब्",
                ["bh"] = "भ्",
                ["m"] = "म्",
                ["y"] = "य्",
                ["r"] = "र्",
                ["l"] = "ल्",
                ["v"] = "व्",
                ["sh"] = "श्",
                ["Sh"] = "ष्",
                ["s"] = "स्",
                ["h"] = "ह्",
                ["ḻ"] = "ळ्",
                ["x"] = "क्ष्",
                ["j~n"] = "ज्ञ्",
                -- yogavaahas (always with phonetic)
                ["M"] = "ं",
                ["H"] = "ः",
                ["ँ"] = "ँ",
                -- punctuations
                ["viraama"] = "्",
                ["."] = "।",
                ["|"] = "।",
                ["||"] = "॥",
            },
        },
        ["deva to iast"] = {
            mapping = {
                -- vowels
                ["अ"] = "a",
                ["आ"] = "ā",
                ["इ"] = "i",
                ["ई"] = "ī",
                ["उ"] = "u",
                ["ऊ"] = "ū",
                ["ऋ"] = "ṛ",
                ["ॠ"] = "ṝ",
                ["ऌ"] = "ḷ",
                ["ॡ"] = "ḹ",
                ["ऎ"] = "è",
                ["ए"] = "e",
                ["ऐ"] = "ai",
                ["ऒ"] = "ò",
                ["ओ"] = "o",
                ["औ"] = "au",
                -- consonant + vowel forms
                ["क"]=  "ka",
                ["का"] = "kā",
                ["कि"] = "ki",
                ["की"] = "kī",
                ["कु"] = "ku",
                ["कू"] = "kū",
                ["के"] = "ke",
                ["को"] = "ko",
                ["कै"] = "kai",
                ["कौ"] = "kau",
                ["कॢ"] = "kḷ",
                ["कॣ"] = "kḹ",
                ["कृ"] = "kṛ",
                ["कॄ"] = "kṝ",
                ---
                ["ख"]=  "kha",
                ["खा"] = "khā",
                ["खि"] = "khi",
                ["खी"] = "khī",
                ["खु"] = "khu",
                ["खू"] = "khū",
                ["खे"] = "khe",
                ["खो"] = "kho",
                ["खै"] = "khai",
                ["खौ"] = "khau",
                ["खॢ"] = "khḷ",
                ["खॣ"] = "khḹ",
                ["खृ"] = "khṛ",
                ["खॄ"] = "khṝ",
                ---
                ["ग"]=  "ga",
                ["गा"] = "gā",
                ["गि"] = "gi",
                ["गी"] = "gī",
                ["गु"] = "gu",
                ["गू"] = "gū",
                ["गे"] = "ge",
                ["गो"] = "go",
                ["गै"] = "gai",
                ["गौ"] = "gau",
                ["गॢ"] = "gḷ",
                ["गॣ"] = "gḹ",
                ["गृ"] = "gṛ",
                ["गॄ"] = "gṝ",
                ---
                ["घ"]=  "gha",
                ["घा"] = "ghā",
                ["घि"] = "ghi",
                ["घी"] = "ghī",
                ["घु"] = "ghu",
                ["घू"] = "ghū",
                ["घे"] = "ghe",
                ["घो"] = "gho",
                ["घै"] = "ghai",
                ["घौ"] = "ghau",
                ["घॢ"] = "ghḷ",
                ["घॣ"] = "ghḹ",
                ["घृ"] = "ghṛ",
                ["घॄ"] = "ghṝ",
                ---
                ["ङ"]=  "ṅa",
                ["ङा"] = "ṅā",
                ["ङि"] = "ṅi",
                ["ङी"] = "ṅī",
                ["ङु"] = "ṅu",
                ["ङू"] = "ṅū",
                ["ङे"] = "ṅe",
                ["ङो"] = "ṅo",
                ["ङै"] = "ṅai",
                ["ङौ"] = "ṅau",
                ["ङॢ"] = "ṅḷ",
                ["ङॣ"] = "ṅḹ",
                ["ङृ"] = "ṅṛ",
                ["ङॄ"] = "ṅṝ",
                ---
                ["च"]=  "ca",
                ["चा"] = "cā",
                ["चि"] = "ci",
                ["ची"] = "cī",
                ["चु"] = "cu",
                ["चू"] = "cū",
                ["चे"] = "ce",
                ["चो"] = "co",
                ["चै"] = "cai",
                ["चौ"] = "cau",
                ["चॢ"] = "cḷ",
                ["चॣ"] = "cḹ",
                ["चृ"] = "cṛ",
                ["चॄ"] = "cṝ",
                --
                ["छ"]=  "cha",
                ["छा"] = "chā",
                ["छि"] = "chi",
                ["छी"] = "chī",
                ["छु"] = "chu",
                ["छू"] = "chū",
                ["छे"] = "che",
                ["छो"] = "cho",
                ["छै"] = "chai",
                ["छौ"] = "chau",
                ["छॢ"] = "chḷ",
                ["छॣ"] = "chḹ",
                ["छृ"] = "chṛ",
                ["छॄ"] = "chṝ",
                --
                ["ज"]=  "ja",
                ["जा"] = "jā",
                ["जि"] = "ji",
                ["जी"] = "jī",
                ["जु"] = "ju",
                ["जू"] = "jū",
                ["जे"] = "je",
                ["जो"] = "jo",
                ["जै"] = "jai",
                ["जौ"] = "jau",
                ["जॢ"] = "jḷ",
                ["जॣ"] = "jḹ",
                ["जृ"] = "jṛ",
                ["जॄ"] = "jṝ",
                --
                ["झ"]=  "jha",
                ["झा"] = "jhā",
                ["झि"] = "jhi",
                ["झी"] = "jhī",
                ["झु"] = "jhu",
                ["झू"] = "jhū",
                ["झे"] = "jhe",
                ["झो"] = "jho",
                ["झै"] = "jhai",
                ["झौ"] = "jhau",
                ["झॢ"] = "jhḷ",
                ["झॣ"] = "jhḹ",
                ["झृ"] = "jhṛ",
                ["झॄ"] = "jhṝ",
                --
                ["ञ"]=  "ña",
                ["ञा"] = "ñā",
                ["ञि"] = "ñi",
                ["ञी"] = "ñī",
                ["ञु"] = "ñu",
                ["ञू"] = "ñū",
                ["ञे"] = "ñe",
                ["ञो"] = "ño",
                ["ञै"] = "ñai",
                ["ञौ"] = "ñau",
                ["ञॢ"] = "ñḷ",
                ["ञॣ"] = "ñḹ",
                ["ञृ"] = "ñṛ",
                ["ञॄ"] = "ñṝ",
                --
                ["ट"]=  "ṭa",
                ["टा"] = "ṭā",
                ["टि"] = "ṭi",
                ["टी"] = "ṭī",
                ["टु"] = "ṭu",
                ["टू"] = "ṭū",
                ["टे"] = "ṭe",
                ["टो"] = "ṭo",
                ["टै"] = "ṭai",
                ["टौ"] = "ṭau",
                ["टॢ"] = "ṭḷ",
                ["टॣ"] = "ṭḹ",
                ["टृ"] = "ṭṛ",
                ["टॄ"] = "ṭṝ",
                --
                ["ठ"]=  "ṭha",
                ["ठा"] = "ṭhā",
                ["ठि"] = "ṭhi",
                ["ठी"] = "ṭhī",
                ["ठु"] = "ṭhu",
                ["ठू"] = "ṭhū",
                ["ठे"] = "ṭhe",
                ["ठो"] = "ṭho",
                ["ठै"] = "ṭhai",
                ["ठौ"] = "ṭhau",
                ["ठॢ"] = "ṭhḷ",
                ["ठॣ"] = "ṭhḹ",
                ["ठृ"] = "ṭhṛ",
                ["ठॄ"] = "ṭhṝ",
                --
                ["ड"]=  "ḍa",
                ["डा"] = "ḍā",
                ["डि"] = "ḍi",
                ["डी"] = "ḍī",
                ["डु"] = "ḍu",
                ["डू"] = "ḍū",
                ["डे"] = "ḍe",
                ["डो"] = "ḍo",
                ["डै"] = "ḍai",
                ["डौ"] = "ḍau",
                ["डॢ"] = "ḍḷ",
                ["डॣ"] = "ḍḹ",
                ["डृ"] = "ḍṛ",
                ["डॄ"] = "ḍṝ",
                --
                ["ढ"]=  "ḍha",
                ["ढा"] = "ḍhā",
                ["ढि"] = "ḍhi",
                ["ढी"] = "ḍhī",
                ["ढु"] = "ḍhu",
                ["ढू"] = "ḍhū",
                ["ढे"] = "ḍhe",
                ["ढो"] = "ḍho",
                ["ढै"] = "ḍhai",
                ["ढौ"] = "ḍhau",
                ["ढॢ"] = "ḍhḷ",
                ["ढॣ"] = "ḍhḹ",
                ["ढृ"] = "ḍhṛ",
                ["ढॄ"] = "ḍhṝ",
                --
                ["ण"]=  "ṇa",
                ["णा"] = "ṇā",
                ["णि"] = "ṇi",
                ["णी"] = "ṇī",
                ["णु"] = "ṇu",
                ["णू"] = "ṇū",
                ["णे"] = "ṇe",
                ["णो"] = "ṇo",
                ["णै"] = "ṇai",
                ["णौ"] = "ṇau",
                ["णॢ"] = "ṇḷ",
                ["णॣ"] = "ṇḹ",
                ["णृ"] = "ṇṛ",
                ["णॄ"] = "ṇṝ",
                --
                ["त"]=  "ta",
                ["ता"] = "tā",
                ["ति"] = "ti",
                ["ती"] = "tī",
                ["तु"] = "tu",
                ["तू"] = "tū",
                ["ते"] = "te",
                ["तो"] = "to",
                ["तै"] = "tai",
                ["तौ"] = "tau",
                ["तॢ"] = "tḷ",
                ["तॣ"] = "tḹ",
                ["तृ"] = "tṛ",
                ["तॄ"] = "tṝ",
                --
                ["थ"]=  "tha",
                ["था"] = "thā",
                ["थि"] = "thi",
                ["थी"] = "thī",
                ["थु"] = "thu",
                ["थू"] = "thū",
                ["थे"] = "the",
                ["थो"] = "tho",
                ["थै"] = "thai",
                ["थौ"] = "thau",
                ["थॢ"] = "thḷ",
                ["थॣ"] = "thḹ",
                ["थृ"] = "thṛ",
                ["थॄ"] = "thṝ",
                --
                ["द"]=  "da",
                ["दा"] = "dā",
                ["दि"] = "di",
                ["दी"] = "dī",
                ["दु"] = "du",
                ["दू"] = "dū",
                ["दे"] = "de",
                ["दो"] = "do",
                ["दै"] = "dai",
                ["दौ"] = "dau",
                ["दॢ"] = "dḷ",
                ["दॣ"] = "dḹ",
                ["दृ"] = "dṛ",
                ["दॄ"] = "dṝ",
                --
                ["ध"]=  "dha",
                ["धा"] = "dhā",
                ["धि"] = "dhi",
                ["धी"] = "dhī",
                ["धु"] = "dhu",
                ["धू"] = "dhū",
                ["धे"] = "dhe",
                ["धो"] = "dho",
                ["धै"] = "dhai",
                ["धौ"] = "dhau",
                ["धॢ"] = "dhḷ",
                ["धॣ"] = "dhḹ",
                ["धृ"] = "dhṛ",
                ["धॄ"] = "dhṝ",
                --
                ["न"]=  "na",
                ["ना"] = "nā",
                ["नि"] = "ni",
                ["नी"] = "nī",
                ["नु"] = "nu",
                ["नू"] = "nū",
                ["ने"] = "ne",
                ["नो"] = "no",
                ["नै"] = "nai",
                ["नौ"] = "nau",
                ["नॢ"] = "nḷ",
                ["नॣ"] = "nḹ",
                ["नृ"] = "nṛ",
                ["नॄ"] = "nṝ",
                --
                ["प"]=  "pa",
                ["पा"] = "pā",
                ["पि"] = "pi",
                ["पी"] = "pī",
                ["पु"] = "pu",
                ["पू"] = "pū",
                ["पे"] = "pe",
                ["पो"] = "po",
                ["पै"] = "pai",
                ["पौ"] = "pau",
                ["पॢ"] = "pḷ",
                ["पॣ"] = "pḹ",
                ["पृ"] = "pṛ",
                ["पॄ"] = "pṝ",
                --
                ["फ"]=  "pha",
                ["फा"] = "phā",
                ["फि"] = "phi",
                ["फी"] = "phī",
                ["फु"] = "phu",
                ["फू"] = "phū",
                ["फे"] = "phe",
                ["फो"] = "pho",
                ["फै"] = "phai",
                ["फौ"] = "phau",
                ["फॢ"] = "phḷ",
                ["फॣ"] = "phḹ",
                ["फृ"] = "phṛ",
                ["फॄ"] = "phṝ",
                --
                ["ब"]=  "ba",
                ["बा"] = "bā",
                ["बि"] = "bi",
                ["बी"] = "bī",
                ["बु"] = "bu",
                ["बू"] = "bū",
                ["बे"] = "be",
                ["बो"] = "bo",
                ["बै"] = "bai",
                ["बौ"] = "bau",
                ["बॢ"] = "bḷ",
                ["बॣ"] = "bḹ",
                ["बृ"] = "bṛ",
                ["बॄ"] = "bṝ",
                --
                ["भ"]=  "bha",
                ["भा"] = "bhā",
                ["भि"] = "bhi",
                ["भी"] = "bhī",
                ["भु"] = "bhu",
                ["भू"] = "bhū",
                ["भे"] = "bhe",
                ["भो"] = "bho",
                ["भै"] = "bhai",
                ["भौ"] = "bhau",
                ["भॢ"] = "bhḷ",
                ["भॣ"] = "bhḹ",
                ["भृ"] = "bhṛ",
                ["भॄ"] = "bhṝ",
                --
                ["म"]=  "ma",
                ["मा"] = "mā",
                ["मि"] = "mi",
                ["मी"] = "mī",
                ["मु"] = "mu",
                ["मू"] = "mū",
                ["मे"] = "me",
                ["मो"] = "mo",
                ["मै"] = "mai",
                ["मौ"] = "mau",
                ["मॢ"] = "mḷ",
                ["मॣ"] = "mḹ",
                ["मृ"] = "mṛ",
                ["मॄ"] = "mṝ",
                --
                ["य"]=  "ya",
                ["या"] = "yā",
                ["यि"] = "yi",
                ["यी"] = "yī",
                ["यु"] = "yu",
                ["यू"] = "yū",
                ["ये"] = "ye",
                ["यो"] = "yo",
                ["यै"] = "yai",
                ["यौ"] = "yau",
                ["यॢ"] = "yḷ",
                ["यॣ"] = "yḹ",
                ["यृ"] = "yṛ",
                ["यॄ"] = "yṝ",
                --
                ["र"]=  "ra",
                ["रा"] = "rā",
                ["रि"] = "ri",
                ["री"] = "rī",
                ["रु"] = "ru",
                ["रू"] = "rū",
                ["रे"] = "re",
                ["रो"] = "ro",
                ["रै"] = "rai",
                ["रौ"] = "rau",
                ["रॢ"] = "rḷ",
                ["रॣ"] = "rḹ",
                ["रृ"] = "rṛ",
                ["रॄ"] = "rṝ",
                --
                ["ल"]=  "la",
                ["ला"] = "lā",
                ["लि"] = "li",
                ["ली"] = "lī",
                ["लु"] = "lu",
                ["लू"] = "lū",
                ["ले"] = "le",
                ["लो"] = "lo",
                ["लै"] = "lai",
                ["लौ"] = "lau",
                ["लॢ"] = "lḷ",
                ["लॣ"] = "lḹ",
                ["लृ"] = "lṛ",
                ["लॄ"] = "lṝ",
                --
                ["व"]=  "va",
                ["वा"] = "vā",
                ["वि"] = "vi",
                ["वी"] = "vī",
                ["वु"] = "vu",
                ["वू"] = "vū",
                ["वे"] = "ve",
                ["वो"] = "vo",
                ["वै"] = "vai",
                ["वौ"] = "vau",
                ["वॢ"] = "vḷ",
                ["वॣ"] = "vḹ",
                ["वृ"] = "vṛ",
                ["वॄ"] = "vṝ",
                --
                ["ष"]=  "ṣa",
                ["षा"] = "ṣā",
                ["षि"] = "ṣi",
                ["षी"] = "ṣī",
                ["षु"] = "ṣu",
                ["षू"] = "ṣū",
                ["षे"] = "ṣe",
                ["षो"] = "ṣo",
                ["षै"] = "ṣai",
                ["षौ"] = "ṣau",
                ["षॢ"] = "ṣḷ",
                ["षॣ"] = "ṣḹ",
                ["षृ"] = "ṣṛ",
                ["षॄ"] = "ṣṝ",
                --
                ["श"]=  "śa",
                ["शा"] = "śā",
                ["शि"] = "śi",
                ["शी"] = "śī",
                ["शु"] = "śu",
                ["शू"] = "śū",
                ["शे"] = "śe",
                ["शो"] = "śo",
                ["शै"] = "śai",
                ["शौ"] = "śau",
                ["शॢ"] = "śḷ",
                ["शॣ"] = "śḹ",
                ["शृ"] = "śṛ",
                ["शॄ"] = "śṝ",
                --
                ["स"]=  "sa",
                ["सा"] = "sā",
                ["सि"] = "si",
                ["सी"] = "sī",
                ["सु"] = "su",
                ["सू"] = "sū",
                ["से"] = "se",
                ["सो"] = "so",
                ["सै"] = "sai",
                ["सौ"] = "sau",
                ["सॢ"] = "sḷ",
                ["सॣ"] = "sḹ",
                ["सृ"] = "sṛ",
                ["सॄ"] = "sṝ",
                --
                ["ह"]=  "ha",
                ["हा"] = "hā",
                ["हि"] = "hi",
                ["ही"] = "hī",
                ["हु"] = "hu",
                ["हू"] = "hū",
                ["हे"] = "he",
                ["हो"] = "ho",
                ["है"] = "hai",
                ["हौ"] = "hau",
                ["हॢ"] = "hḷ",
                ["हॣ"] = "hḹ",
                ["हृ"] = "hṛ",
                ["हॄ"] = "hṝ",
                --
                ["ळ"]=  "l̤a",
                ["ळा"] = "l̤ā",
                ["ळि"] = "l̤i",
                ["ळी"] = "l̤ī",
                ["ळु"] = "l̤u",
                ["ळू"] = "l̤ū",
                ["ळे"] = "l̤e",
                ["ळो"] = "l̤o",
                ["ळै"] = "l̤ai",
                ["ळौ"] = "l̤au",
                ["ळॢ"] = "l̤ḷ",
                ["ळॣ"] = "l̤ḹ",
                ["ळृ"] = "l̤ṛ",
                ["ळॄ"] = "l̤ṝ",
                ---
                ["क्ष"]=  "kṣa",
                ["क्षा"] = "kṣā",
                ["क्षि"] = "kṣi",
                ["क्षी"] = "kṣī",
                ["क्षु"] = "kṣu",
                ["क्षू"] = "kṣū",
                ["क्षे"] = "kṣe",
                ["क्षो"] = "kṣo",
                ["क्षै"] = "kṣai",
                ["क्षौ"] = "kṣau",
                ["क्षॢ"] = "kṣḷ",
                ["क्षॣ"] = "kṣḹ",
                ["क्षृ"] = "kṣṛ",
                ["क्षॄ"] = "kṣṝ",
                ---
                ["ज्ञ"]=  "jña",
                ["ज्ञा"] = "jñā",
                ["ज्ञि"] = "jñi",
                ["ज्ञी"] = "jñī",
                ["ज्ञु"] = "jñu",
                ["ज्ञू"] = "jñū",
                ["ज्ञे"] = "jñe",
                ["ज्ञो"] = "jño",
                ["ज्ञै"] = "jñai",
                ["ज्ञौ"] = "jñau",
                ["ज्ञॢ"] = "jñḷ",
                ["ज्ञॣ"] = "jñḹ",
                ["ज्ञृ"] = "jñṛ",
                ["ज्ञॄ"] = "jñṝ",
                --
                ["क्"]=  "k",
                ["ख्"] = "kh",
                ["ग्"] = "g",
                ["घ्"] = "gh",
                ["ङ्"] = "ṅ",
                ["च्"] = "c",
                ["छ्"] = "ch",
                ["ज्"] = "j",
                ["झ्"] = "jh",
                ["ञ्"] = "ñ",
                ["ट्"] = "ṭ",
                ["ठ्"] = "ṭh",
                ["ड्"] = "ḍ",
                ["ढ्"] = "ḍh",
                ["ण्"] = "ṇ",
                ["त्"] = "t",
                ["थ्"] = "th",
                ["द्"] = "d",
                ["ध्"] = "dh",
                ["न्"] = "n",
                ["प्"] = "p",
                ["फ्"] = "ph",
                ["ब्"] = "b",
                ["भ्"] = "bh",
                ["म्"] = "m",
                ["य्"] = "y",
                ["र्"] = "r",
                ["ल्"] = "l",
                ["व्"] = "v",
                ["श्"] = "ś",
                ["ष्"] = "ṣ",
                ["स्"] = "s",
                ["ह्"] = "h",
                ["ळ्"] = "l̤",
                ["क्ष्"] = "kṣ",
                ["ज्ञ्"] = "jñ",
                -- discard virama (?!) TODO: revisit this if need arises
             -- ["्"] = "",
                ["।"] = "|",
                ["॥"] = "||",
                ["ं"] = "ṃ",
                ["ः"] = "ḥ",
                ["ऽ"] = "\'",
                -- disputed
                ["ँ"] = "̃",
                -- diactrics (combining): provided for completeness
                -- warning: many fonts don't have these
                ["॒"] = "॒",
                -- could not test
             -- ["॑"] = "̭",
                ["॑"] = "॑",
                ["᳚"] = "᳚",
                ["᳛"] = "᳛",
                ["᳡"] = "̀",
                ["꣡"] = "́",
                ["꣢"] = "²",
                ["꣣"] = "³",
                ["꣤"] = "⁴",
                ["꣥"] = "⁵",
                ["꣦"] = "⁶",
                ["꣧"] = "⁷",
                ["꣨"] = "⁸",
                ["꣩"] = "⁹",
                ["꣪"] = "꣪",
                ["꣫"] = "꣫",
                ["꣬"] = "꣬",
                ["꣭"] = "꣭",
                ["꣮"] = "꣮",
                ["꣯"] = "꣯",
                ["꣰"] = "꣰",
                ["꣱"] = "꣱",
            },
        },
        ["deva to mlym"] = {
            mapping = {
                -- vowels
                ["अ"] = "അ",
                ["आ"] = "ആ",
                ["इ"] = "ഇ",
                ["ई"] = "ഈ",
                ["उ"] = "ഉ",
                ["ऊ"] = "ഊ",
                ["ऋ"] = "ഋ",
                ["ॠ"] = "ൠ",
                ["ऌ"] = "ഌ",
                ["ॡ"] = "ൡ",
                ["ऎ"] = "എ",
                ["ए"] = "ഏ",
                ["ऐ"] = "ഐ",
                ["ऒ"] = "ഒ",
                ["ओ"] = "ഓ",
                ["औ"] = "ഔ",
                -- consonants
                ["क"] = "ക",
                ["ख"] = "ഖ",
                ["ग"] = "ഗ",
                ["घ"] = "ഘ",
                ["ङ"] = "ങ",
                ["च"] = "ച",
                ["छ"] = "ഛ",
                ["ज"] = "ജ",
                ["झ"] = "ഝ",
                ["ञ"] = "ഞ",
                ["ट"] = "ട",
                ["ठ"] = "ഠ",
                ["ड"] = "ഡ",
                ["ढ"] = "ഢ",
                ["ण"] = "ണ",
                ["त"] = "ത",
                ["थ"] = "ഥ",
                ["द"] = "ദ",
                ["ध"] = "ധ",
                ["न"] = "ന",
                ["प"] = "പ",
                ["फ"] = "ഫ",
                ["ब"] = "ബ",
                ["भ"] = "ഭ",
                ["म"] = "മ",
                ["य"] = "യ",
                ["र"] = "ര",
                ["ल"] = "ല",
                ["व"] = "വ",
                ["श"] = "ശ",
                ["ष"] = "ഷ",
                ["स"] = "സ",
                ["ह"] = "ഹ",
                ["ळ"] = "ള",
                ["क्ष"] = "ക്ഷ",
                ["ज्ञ"] = "ജ്ഞ",
                -- vowel marks
                ["ा"] = "ാ",
                ["ि"] = "ി",
                ["ी"] = "ീ",
                ["ु"] = "ു",
                ["ू"] = "ൂ",
                ["ृ"] = "ൃ",
                ["ॄ"] = "ൄ",
                ["ॢ"] = "ൢ",
                ["ॣ"] = "ൣ",
                ["ॆ"] = "െ",
                ["े"] = "േ",
                ["ै"] = "ൈ",
                ["ॊ"] = "ൊ",
                ["ो"] = "ോ",
                ["ौ"] = "ൌ",
                -- always with phonetic
                ["ं"] = "ം",
                ["ः"] = "ഃ",
                ["ँ"] = "ഁ",
                -- punctuation marks
                ["्"] = "്",
                ["'"] = "'",
                ["।"] = ".",
                ["॥"] = ".",
                ["‘"] = "‘",
                ["’"] = "’",
            },
        },
        ["deva to tlgu"] = {
            mapping = {
                -- vowels
                ["अ"] = "అ",
                ["आ"] = "ఆ",
                ["इ"] = "ఇ",
                ["ई"] = "ఈ",
                ["उ"] = "ఉ",
                ["ऊ"] = "ఊ",
                ["ऋ"] = "ఋ",
                ["ॠ"] = "ౠ",
                ["ऌ"] = "ఌ",
                ["ॡ"] = "ౡ",
                ["ऎ"] = "ఎ",
                ["ए"] = "ఏ",
                ["ऐ"] = "ఐ",
                ["ऒ"] = "ఒ",
                ["ओ"] = "ఓ",
                ["औ"] = "ఔ",
                -- consonants
                ["क"] = "క",
                ["ख"] = "ఖ",
                ["ग"] = "గ",
                ["घ"] = "ఘ",
                ["ङ"] = "ఙ",
                ["च"] = "చ",
                ["छ"] = "ఛ",
                ["ज"] = "జ",
                ["झ"] = "ఝ",
                ["ञ"] = "ఞ",
                ["ट"] = "ట",
                ["ठ"] = "ఠ",
                ["ड"] = "డ",
                ["ढ"] = "ఢ",
                ["ण"] = "ణ",
                ["त"] = "త",
                ["थ"] = "థ",
                ["द"] = "ద",
                ["ध"] = "ధ",
                ["न"] = "న",
                ["प"] = "ప",
                ["फ"] = "ఫ",
                ["ब"] = "బ",
                ["भ"] = "భ",
                ["म"] = "మ",
                ["य"] = "య",
                ["र"] = "ర",
                ["ल"] = "ల",
                ["व"] = "వ",
                ["श"] = "శ",
                ["ष"] = "ష",
                ["स"] = "స",
                ["ह"] = "హ",
                ["ळ"] = "ళ",
                ["क्ष"] = "క్ష",
                ["ज्ञ"] = "జ్ఞ",
                -- vowel marks
                ["ा"] = "ా",
                ["ि"] = "ి",
                ["ी"] = "ీ",
                ["ु"] = "ు",
                ["ू"] = "ూ",
                ["ृ"] = "ృ",
                ["ॄ"] = "ౄ",
                ["ॢ"] = "ౢ",
                ["ॣ"] = "ౣ",
                ["ॆ"] = "ె",
                ["े"] = "ే",
                ["ै"] = "ై",
                ["ॊ"] = "ొ",
                ["ो"] = "ో",
                ["ौ"] = "ౌ",
                -- always with phonetic
                ["ं"] = "ం",
                ["ः"] = "ః",
                ["ँ"] = "ఀ",
                -- punctuation marks
                ["्"] = "్",
                ["'"] = "'",
                ["।"] = ".",
                ["॥"] = ".",
                ["‘"] = "‘",
                ["’"] = "’",
            },
        },
        ["deva to knda"] = {
            mapping = {
                -- vowels
                ["अ"] = "ಅ",
                ["आ"] = "ಆ",
                ["इ"] = "ಇ",
                ["ई"] = "ಈ",
                ["उ"] = "ಉ",
                ["ऊ"] = "ಊ",
                ["ऋ"] = "ಋ",
                ["ॠ"] = "ೠ",
                ["ऌ"] = "ಌ",
                ["ॡ"] = "ೡ",
                ["ऎ"] = "ಎ",
                ["ए"] = "ಏ",
                ["ऐ"] = "ಐ",
                ["ऒ"] = "ಒ",
                ["ओ"] = "ಓ",
                ["औ"] = "ಔ",
                -- consonants
                ["क"] = "ಕ",
                ["ख"] = "ಖ",
                ["ग"] = "ಗ",
                ["घ"] = "ಘ",
                ["ङ"] = "ಙ",
                ["च"] = "ಚ",
                ["छ"] = "ಛ",
                ["ज"] = "ಜ",
                ["झ"] = "ಝ",
                ["ञ"] = "ಞ",
                ["ट"] = "ಟ",
                ["ठ"] = "ಠ",
                ["ड"] = "ಡ",
                ["ढ"] = "ಢ",
                ["ण"] = "ಣ",
                ["त"] = "ತ",
                ["थ"] = "ಥ",
                ["द"] = "ದ",
                ["ध"] = "ಧ",
                ["न"] = "ನ",
                ["प"] = "ಪ",
                ["फ"] = "ಫ",
                ["ब"] = "ಬ",
                ["भ"] = "ಭ",
                ["म"] = "ಮ",
                ["य"] = "ಯ",
                ["र"] = "ರ",
                ["ल"] = "ಲ",
                ["व"] = "ವ",
                ["श"] = "ಶ",
                ["ष"] = "ಷ",
                ["स"] = "ಸ",
                ["ह"] = "ಹ",
                ["ळ"] = "ಳ",
                ["क्ष"] = "ಕ್ಷ",
                ["ज्ञ"] = "ಜ್ಞ",
                -- vowel marks
                ["ा"] = "ಾ",
                ["ि"] = "ಿ",
                ["ी"] = "ೀ",
                ["ु"] = "ು",
                ["ू"] = "ೂ",
                ["ृ"] = "ೃ",
                ["ॄ"] = "ೄ",
                ["ॢ"] = "ೢ",
                ["ॣ"] = "ೣ",
                ["ॆ"] = "ೆ",
                ["े"] = "ೇ",
                ["ै"] = "ೈ",
                ["ॊ"] = "ೊ",
                ["ो"] = "ೋ",
                ["ौ"] = "ೌ",
                -- always with phonetic
                ["ं"] = "ಂ",
                ["ः"] = "ಃ",
                ["ँ"] = "ಁ",
                -- punctuation marks
                ["्"] = "್",
                ["'"] = "'",
                ["।"] = ".",
                ["॥"] = ".",
                ["‘"] = "‘",
                ["’"] = "’",
            },
        },
        ["deva to gujr"] = {
            mapping = {
                -- vowels
                ["अ"] = "અ",
                ["आ"] = "આ",
                ["इ"] = "ઇ",
                ["ई"] = "ઈ",
                ["उ"] = "ઉ",
                ["ऊ"] = "ઊ",
                ["ऋ"] = "ઋ",
                ["ॠ"] = "ૠ",
                ["ऌ"] = "ઌ",
                ["ॡ"] = "ૡ",
             -- ["ऎ"] = "",
                ["ए"] = "એ",
                ["ऐ"] = "ઐ",
             -- ["ऒ"] = "",
                ["ओ"] = "ઓ",
                ["औ"] = "ઔ",
                -- consonants
                ["क"] = "ક",
                ["ख"] = "ખ",
                ["ग"] = "ગ",
                ["घ"] = "ઘ",
                ["ङ"] = "ઙ",
                ["च"] = "ચ",
                ["छ"] = "છ",
                ["ज"] = "જ",
                ["झ"] = "ઝ",
                ["ञ"] = "ઞ",
                ["ट"] = "ટ",
                ["ठ"] = "ઠ",
                ["ड"] = "ડ",
                ["ढ"] = "ઢ",
                ["ण"] = "ણ",
                ["त"] = "ત",
                ["थ"] = "થ",
                ["द"] = "દ",
                ["ध"] = "ધ",
                ["न"] = "ન",
                ["प"] = "પ",
                ["फ"] = "ફ",
                ["ब"] = "બ",
                ["भ"] = "ભ",
                ["म"] = "મ",
                ["य"] = "ય",
                ["र"] = "ર",
                ["ल"] = "લ",
                ["व"] = "વ",
                ["श"] = "શ",
                ["ष"] = "ષ",
                ["स"] = "સ",
                ["ह"] = "હ",
                ["ळ"] = "ળ",
                ["क्ष"] = "ક્ષ",
                ["ज्ञ"] = "જ્ઞ",
                -- vowel marks
                ["ा"] = "ા",
                ["ि"] = "િ",
                ["ी"] = "ી",
                ["ु"] = "ુ",
                ["ू"] = "ૂ",
                ["ृ"] = "ૃ",
                ["ॄ"] = "ૄ",
                ["ॢ"] = "ૢ",
                ["ॣ"] = "ૣ",
             -- ["ॆ"] = "",
                ["े"] = "ે",
                ["ै"] = "ૈ",
             -- ["ॊ"] = "",
                ["ो"] = "ો",
                ["ौ"] = "ૌ",
                -- always with phonetic
                ["ं"] = "ં",
                ["ः"] = "ઃ",
                ["ँ"] = "ઁ",
                -- punctuation marks
                ["्"] = "્",
                ["'"] = "'",
                ["।"] = ".",
                ["॥"] = ".",
                ["‘"] = "‘",
                ["’"] = "’",
            },
        },
        ["deva to bngl"] = {
            mapping = {
                -- vowels
                ["अ"] = "অ",
                ["आ"] = "আ",
                ["इ"] = "ই",
                ["ई"] = "ঈ",
                ["उ"] = "উ",
                ["ऊ"] = "ঊ",
                ["ऋ"] = "ঋ",
                ["ॠ"] = "ৠ",
                ["ऌ"] = "ঌ",
                ["ॡ"] = "ৡ",
             -- ["ऎ"] = "",
                ["ए"] = "এ",
                ["ऐ"] = "ঐ",
             -- ["ऒ"] = "",
                ["ओ"] = "ও",
                ["औ"] = "ঔ",
                -- consonants
                ["क"] = "ক",
                ["ख"] = "খ",
                ["ग"] = "গ",
                ["घ"] = "ঘ",
                ["ङ"] = "ঙ",
                ["च"] = "চ",
                ["छ"] = "ছ",
                ["ज"] = "জ",
                ["झ"] = "ঝ",
                ["ञ"] = "ঞ",
                ["ट"] = "ট",
                ["ठ"] = "ঠ",
                ["ड"] = "ড",
                ["ढ"] = "ঢ",
                ["ण"] = "ণ",
                ["त"] = "ত",
                ["थ"] = "থ",
                ["द"] = "দ",
                ["ध"] = "ধ",
                ["न"] = "ন",
                ["प"] = "প",
                ["फ"] = "ফ",
                ["ब"] = "ব",
                ["भ"] = "ভ",
                ["म"] = "ম",
                ["य"] = "য",
                ["र"] = "র",
                ["ल"] = "ল",
                ["व"] = "ব",
                ["श"] = "শ",
                ["ष"] = "ষ",
                ["स"] = "স",
                ["ह"] = "হ",
            --  ["ळ"] = "",
                ["क्ष"] = "ক্ষ",
                ["ज्ञ"] = "জ্ঞ",
                -- vowel marks
                ["ा"] = "া",
                ["ि"] = "ি",
                ["ी"] = "ী",
                ["ु"] = "ু",
                ["ू"] = "ূ",
                ["ृ"] = "ৃ",
                ["ॄ"] = "ৄ",
                ["ॢ"] = "ৢ",
                ["ॣ"] = "ৣ",
             -- ["ॆ"] = "",
                ["े"] = "ে",
                ["ै"] = "ৈ",
             -- ["ॊ"] = "",
                ["ो"] = "ো",
                ["ौ"] = "ৌ",
                -- always with phonetic
                ["ं"] = "ং",
                ["ः"] = "ঃ",
                ["ँ"] = "ঁ",
                -- punctuation marks
                ["्"] = "্",
                ["'"] = "'",
                ["।"] = ".",
                ["॥"] = ".",
                ["‘"] = "‘",
                ["’"] = "’",
            },
        },
    }
}
